

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobOption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobOption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobOption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobOption]
  delete from GXDBVersions where name = 'GetJobOption' and type = 5
END
GO

	CREATE FUNCTION GetJobOption(@jobId bigint, @optionId bigint )
	RETURNS NVARCHAR(MAX)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @refTime	INT
		SELECT TOP 1 @taskId=taskId, @subTaskId=subTaskId, @refTime=created FROM TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WHERE jobId=@jobId)
		--Get the option value from the TM_JobOptions table
		DECLARE @attrv NVARCHAR(MAX)
		SELECT @attrv = value FROM TM_JobOptions WITH (READUNCOMMITTED) WHERE (jobId=@jobId OR
			(jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime)))
		AND optionId = @optionId
		--select @attrv = value from TM_JobOptions where jobId = @jobId AND optionId = @optionId
		IF @attrv IS NULL SET @attrv = dbo.GetDefaultOption(@optionId)
		RETURN @attrv
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobOption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobOption' AND revision = '1.10.278.1')

  insert into GXDBVersions values(5, 'GetJobOption',  '1.10.278.1', 'GetJobOption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
