

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobOperationString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobOperationString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobOperationString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobOperationString]
  delete from GXDBVersions where name = 'GetJobOperationString' and type = 5
END
GO

	CREATE FUNCTION GetJobOperationString (@localeId INT, @operationId INT, @appTypeId INT)
	RETURNS NVARCHAR(255)
	-- WITH ENCRYPTION
	AS
	BEGIN
	DECLARE	@retStr NVARCHAR(255)
	SELECT	@retStr =
				  CASE @operationId
			      WHEN 0 THEN N'No Operation'
				  WHEN 1 THEN N'All Operation'
				  WHEN 2 THEN N'Online'
				  WHEN 3 THEN N'Offline'
				  WHEN 4 THEN (CASE WHEN @appTypeId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
				  WHEN 5 THEN N'Restore'
				  WHEN 6 THEN N'Import'
				  WHEN 7 THEN N'CvImport'
				  WHEN 8 THEN N'Media Init'
				  WHEN 9 THEN N'Media Recycle'
				  WHEN 10 THEN N'Prune'
				  WHEN 11 THEN N'CS DR Backup'
				  WHEN 12 THEN N'Index Restore'
				  WHEN 13 THEN N'Aux Copy'
				  WHEN 14 THEN N'Synthetic Full'
				  WHEN 15 THEN N'W2K System Restore'
				  WHEN 16 THEN N'W2K Full Build Restore'
				  WHEN 17 THEN N'Report'
				  WHEN 18 THEN N'Backup 3RD'
				  WHEN 19 THEN N'W2K Full Build Restore371'
				  WHEN 20 THEN N'SchedExport'
				  WHEN 21 THEN N'Media Inventory'
				  WHEN 22 THEN N'Snapshot'
				  WHEN 23 THEN N'Create Replica'
				  WHEN 24 THEN N'Update Replica'
				  WHEN 25 THEN N'DM Outlook Restore'
				  WHEN 26 THEN N'Media Prediction'
				  WHEN 27 THEN N'Snap Recovery'
				  WHEN 28 THEN N'Schedule'
				  WHEN 29 THEN N'Quick DM Restore'
				  WHEN 30 THEN N'System State Backup'
				  WHEN 31 THEN N'Archive Check'
				  WHEN 32 THEN N'Tape Erase'
				  WHEN 33 THEN N'Shelf Mangement'
				  WHEN 34 THEN N'QR Copy Backup'
				  WHEN 35 THEN N'Patch Update'
				  WHEN 36 THEN N'Patch Download'
				  WHEN 37 THEN N'QR RollBack'
				  WHEN 38 THEN N'Selective Delete'
				  WHEN 39 THEN N'WorkFlow'
				  WHEN 40 THEN N'Index Free Restore'
				  WHEN 41 THEN N'Storage Validation'
				  WHEN 42 THEN N'Drive Cleaning'
				  WHEN 43 THEN N'SysRecovery Backup'
				  WHEN 44 THEN N'Browse And Delete'
				  WHEN 45 THEN N'Snap Vault Restore'
				  WHEN 46 THEN N'Stamp Media'
				  WHEN 47 THEN N'Catalogue Media'
				  WHEN 48 THEN N'SR System Recovery'
				  WHEN 49 THEN N'Search And Retrieve'
				  WHEN 50 THEN N'Create Consistency Point'
				  WHEN 51 THEN N'Create Recovery Point'
				  WHEN 52 THEN N'FLR Copy Backup'
				  WHEN 53 THEN N'Offline Content Index'
				  WHEN 54 THEN N'Power Restore'
				  WHEN 55 THEN N'Power Search And Restore'
				  WHEN 56 THEN N'CDR'
				  WHEN 57 THEN N'Online Content Index'
				  WHEN 58 THEN N'SRM OpType'
				  WHEN 59 THEN N'Snap Backup'
				  WHEN 60 THEN N'Backup Copy'
				  WHEN 61 THEN N'Snap To Tape WorkFlow'
				  WHEN 62 THEN N'SRM Report'
				  WHEN 63 THEN N'Maglib Maintenance'
				  WHEN 64 THEN N'Info Management'
				  WHEN 65 THEN N'Snap Backup3RD'
				  WHEN 66 THEN N'Offline Mining Restore'
				  WHEN 67 THEN N'Install Client'
				  WHEN 68 THEN N'UnInstall Client'
				  WHEN 69 THEN N'FDC WorkFlow'
				  WHEN 70 THEN N'Mining Backup'
				  WHEN 71 THEN N'CCM Capture'
				  WHEN 72 THEN N'CCM Merge'
				  WHEN 73 THEN N'FDC Client'
				  WHEN 74 THEN N'Media Refresh'
				  WHEN 75 THEN N'FD CopyType'
				  WHEN 76 THEN N'Archive Optype'
				  WHEN 77 THEN N'Mining Content Index'
				  WHEN 78 THEN N'FDC Preparation'
				  WHEN 79 THEN N'Agentless SRM'
				  WHEN 80 THEN N'Dedup DB Reconstruction'
				  WHEN 81 THEN N'Tape Import'
				  WHEN 82 THEN N'Data Verification'
				  WHEN 83 THEN N'Other Admin Operation'
				  WHEN 84 THEN N'Upgrade Client'
				  WHEN 85 THEN N'Virtual Machine Management'
				  WHEN 86 THEN N'Log Monitoring'
				  WHEN 87 THEN N'Turbo NAS'
				  WHEN 88 THEN N'CommCell Synchronization'
				  WHEN 89 THEN N'Virtualize Machine'
				  WHEN 90 THEN N'Workflow Management'
				  WHEN 91 THEN N'PST Archiving'
				  WHEN 92 THEN N'Send Log Files'
				  WHEN 93 THEN N'Reference Copy Work Flow'
				  WHEN 94 THEN N'Smart Copy'
				  WHEN 95 THEN N'Delayed Catalog Work Flow'
				  WHEN 96 THEN N'Delayed Catalog'
				  WHEN 97 THEN N'PST Archiving'
				  WHEN 98 THEN N'Archive'
				  WHEN 99 THEN N'Move Partition'
				  WHEN 104 THEN N'Aux Copy'
				  ELSE N'Unknown'  END

	IF	@localeId > 0
		SELECT	@retStr = Message
		FROM	WR_LocaleStringsView
		WHERE	LocaleID = @localeId
			AND MessageID = (SELECT TOP 1 MessageID FROM WR_LocaleStringsView WHERE LocaleID = 0 AND Message = @retStr)

	RETURN @retStr
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobOperationString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobOperationString' AND revision = '1.6.80.4')

  insert into GXDBVersions values(5, 'GetJobOperationString',  '1.6.80.4', 'GetJobOperationString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
