

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobErrorName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobErrorName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobErrorName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobErrorName]
  delete from GXDBVersions where name = 'GetJobErrorName' and type = 5
END
GO

	CREATE FUNCTION GetJobErrorName (@errorId INTEGER)
	RETURNS VARCHAR(255)
	-- WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @jobErrorName varchar(255)
	SELECT @jobErrorName =
			CASE @errorId
			WHEN -1 THEN 'Multiple'
			WHEN 0 THEN ''
			WHEN 100 THEN 'Hardware'
			WHEN 150 THEN 'Indexing'
			WHEN 200 THEN 'Software'
			WHEN 300 THEN 'Application'
			WHEN 400 THEN 'Network'
			WHEN 500 THEN 'No Resources'
			WHEN 550 THEN 'Activity control'
			WHEN 600 THEN 'Operation Window'
			ELSE '' END
	RETURN @jobErrorName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobErrorName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobErrorName' AND revision = '1.1.278.1')

  insert into GXDBVersions values(5, 'GetJobErrorName',  '1.1.278.1', 'GetJobErrorName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
