

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobBackupTypeString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobBackupTypeString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobBackupTypeString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobBackupTypeString]
  delete from GXDBVersions where name = 'GetJobBackupTypeString' and type = 5
END
GO

	CREATE FUNCTION GetJobBackupTypeString (@localeId INT, @backupType INT, @appTypeId INT)
	RETURNS NVARCHAR(255)
	AS
	BEGIN
				DECLARE @retStr NVARCHAR(255)
				SET @retStr = N'Unknown'
				IF (@backupType = 1)
					SET @retStr = CASE WHEN @appTypeId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END
				ELSE IF (@backupType = 2)
					SET @retStr = CASE WHEN @appTypeId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN @appTypeId = 125 THEN N'Log Only' ELSE N'Incremental' END
				ELSE IF (@backupType = 4)
					SET @retStr = CASE WHEN @appTypeId IN (37,62) THEN N'Delta' ELSE N'Differential' END
				ELSE IF (@backupType = 0x40)
					SET @retStr = N'Synthetic Full'
				ELSE IF (@backupType = 0x80)
					SET @retStr = N'Synthetic Full'
				ELSE IF (@backupType = 0x4000)
					SET @retStr = N'Synthetic Full'
				ELSE IF (@backupType = 0x100)
					SET @retStr = CASE WHEN @appTypeId = 104 THEN N'Incremental' ELSE N'LOG NOTRUNC' END
				ELSE IF (@backupType = 0x200)
					SET @retStr = N'ASR'
				ELSE IF (@backupType = 0x800)
					SET @retStr = N'Snapshot'
				ELSE IF (@backupType = 0x1000)
					SET @retStr = N'New Volume Creation'
				ELSE IF (@backupType = 0x2000)
					SET @retStr = N'Incremental Volume Update'
				ELSE IF (@backupType = 0x8000)
					SET @retStr = N'Online Full'
				ELSE IF (@backupType = 0x400)
					SET @retStr = N'Offline Full'
				ELSE IF (@backupType = 0x20000)
					SET @retStr = N'Analysis'
				ELSE IF (@backupType = 0x40000)
					SET @retStr = N'Discovery'

	IF	@localeId > 0
		SELECT	@retStr = Message
		FROM	WR_LocaleStringsView
		WHERE	LocaleID = @localeId
			AND MessageID = (SELECT TOP 1 MessageID FROM WR_LocaleStringsView WHERE LocaleID = 0 AND Message = @retStr)

	RETURN @retStr
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobBackupTypeString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobBackupTypeString' AND revision = '1.6.200.1')

  insert into GXDBVersions values(5, 'GetJobBackupTypeString',  '1.6.200.1', 'GetJobBackupTypeString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
