

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetInstanceName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetInstanceName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetInstanceName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetInstanceName]
  delete from GXDBVersions where name = 'GetInstanceName' and type = 5
END
GO

	CREATE FUNCTION GetInstanceName(@instanceName NVARCHAR(512), @appType INT)
	RETURNS NVARCHAR(512)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @instName NVARCHAR(512)
		SET @instName = ''
		DECLARE	@stopIndex INTEGER
		IF	@appType IN (3, 4, 16,
			6, 7, 5,
			51, 52,
			2, 22, 23, 80,
			27, 31,
			32, 37,
			60, 59,
			62, 77,
			70, 81, 104,
			61, 79,
			90, 103, 125, 128,
			106, 58 , 134,135,136)
		BEGIN
			SET @stopIndex = CASE WHEN CHARINDEX(NCHAR(0x12), @instanceName) > 0 THEN CHARINDEX(NCHAR(0x12), @instanceName) - 1 ELSE LEN(@instanceName) END
			SET @instName = SUBSTRING(@instanceName, 1, @stopIndex)
		END
		ELSE
			SET @instName = 'N/A'

		RETURN @instName
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetInstanceName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetInstanceName' AND revision = '1.3.204.5')

  insert into GXDBVersions values(5, 'GetInstanceName',  '1.3.204.5', 'GetInstanceName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
