

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetIndexServerPruningSettings.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetIndexServerPruningSettings'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetIndexServerPruningSettings]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetIndexServerPruningSettings]
  delete from GXDBVersions where name = 'GetIndexServerPruningSettings' and type = 5
END
GO

CREATE FUNCTION [dbo].[GetIndexServerPruningSettings] (@entityId INT, @isSubClientEntity INT)
RETURNS @opts TABLE (entityId INT, enablePruning INT DEFAULT 0, retDays	INT DEFAULT -1, retCycles INT DEFAULT -1, pruningType INT DEFAULT 0)
AS
BEGIN
	DECLARE @pruningEnabled INT = ISNULL((SELECT CAST(ISNULL(value,0) AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'Enable Index Pruning' AND modified = 0),0)
	IF @pruningEnabled > 0
	BEGIN
		INSERT INTO @opts
		SELECT 0, [Enable Index Pruning], [IndexPruning_DBRetentionDays], [IndexPruning_DBRetentionCycle], [IndexPruning_Type] FROM
		(
			SELECT name, CAST( ISNULL(value,0) AS INT) AS value FROM GXGlobalParam WITH (NOLOCK)
			WHERE name in ('Enable Index Pruning','IndexPruning_DBRetentionDays','IndexPruning_DBRetentionCycle', 'IndexPruning_Type') AND modified = 0
		) P
		PIVOT (MAX(value) FOR name in ([Enable Index Pruning],[IndexPruning_DBRetentionDays],[IndexPruning_DBRetentionCycle],[IndexPruning_Type])) T
		IF(@isSubClientEntity = 0) -- Fetch Backupset Property
		BEGIN
			INSERT INTO @opts
			SELECT @entityId, [Enable Index Pruning], [IndexPruning_DBRetentionDays], [IndexPruning_DBRetentionCycle], [IndexPruning_Type] FROM
			(
				SELECT attrName, CAST( ISNULL(attrVal,0) AS INT) AS attrVal FROM APP_BackupSetProp prop WITH (NOLOCK)
				WHERE prop.componentNameId = @entityId AND prop.modified = 0 AND
				prop.attrName in ('Enable Index Pruning','IndexPruning_DBRetentionDays','IndexPruning_DBRetentionCycle', 'IndexPruning_Type') --CV_BACKUPSET_INDEX_PRUNING, INDEX_PRUNING_DB_RETENTION_DAYS
			) P
			PIVOT (MAX(attrVal) FOR attrName in ([Enable Index Pruning],[IndexPruning_DBRetentionDays],[IndexPruning_DBRetentionCycle],[IndexPruning_Type])) T
		END
		ELSE -- Fetch Subclient Property
		BEGIN
			INSERT INTO @opts
			SELECT @entityId, [Enable Index Pruning], [IndexPruning_DBRetentionDays], [IndexPruning_DBRetentionCycle], [IndexPruning_Type] FROM
			(
				SELECT attrName, CAST( ISNULL(attrVal,0) AS INT) AS attrVal FROM APP_SubClientProp prop WITH (NOLOCK)
				WHERE prop.componentNameId = @entityId AND prop.modified = 0 AND
				prop.attrName in ('Enable Index Pruning','IndexPruning_DBRetentionDays','IndexPruning_DBRetentionCycle', 'IndexPruning_Type')
			) P
			PIVOT (MAX(attrVal) FOR attrName in ([Enable Index Pruning],[IndexPruning_DBRetentionDays],[IndexPruning_DBRetentionCycle],[IndexPruning_Type])) T
		END
	END
	RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetIndexServerPruningSettings]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetIndexServerPruningSettings' AND revision = '')

  insert into GXDBVersions values(5, 'GetIndexServerPruningSettings',  '', 'GetIndexServerPruningSettings', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
