

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetIndexServerOptions.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: GetIndexServerOptions'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetIndexServerOptions]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetIndexServerOptions]
  delete from GXDBVersions where name = 'GetIndexServerOptions' and type = 5
END
GO

CREATE FUNCTION [dbo].[GetIndexServerOptions] (@clientId INT, @instanceId INT, @appTypeId INT, @backupsetId INT, @subclientId INT, @isSubClientEntity INT, @propsLevel INT)
RETURNS @opts TABLE (entityId INT, curIdxServer XML, indexMAs XML, indexBkpSp XML, indexBkpEligibleSPs XML, indexPruning INT DEFAULT 0, retDays	INT DEFAULT -1, retCycles INT DEFAULT -1, pruningType INT DEFAULT 0)
AS
BEGIN
IF (@appTypeId <> 125 AND @propsLevel <= 20) --Fetch index properties only when property level is greater than 20, unless it's postgress client
		RETURN
	DECLARE @scIdxEnabled INT = ISNULL((SELECT 1 FROM APP_IDAName IDA WITH (NOLOCK) JOIN APP_IDAProp IDAP WITH (NOLOCK) ON IDA.id = IDAP.componentNameId AND IDA.clientId = @clientId AND IDA.appTypeId = @appTypeId AND IDAP.attrName = 'Subclient Index' and IDAP.attrVal = '1' and IDAP.modified = 0),0)
	IF((@scIdxEnabled = 1 AND @isSubClientEntity = 0) OR (@scIdxEnabled = 0 AND @isSubClientEntity = 1))
		RETURN --> index server options is not supported
	DECLARE @idxSrvrSwitchEnabled INT = (SELECT ISNULL(value, 0) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'EnableIdxSrvrSwitch')
	IF(@isSubClientEntity = 1)
		INSERT INTO @opts(entityId)
		SELECT DISTINCT APP.id
		FROM APP_Application APP WITH (NOLOCK)
		WHERE APP.clientId = @clientId AND APP.instance = @instanceId AND APP.appTypeId = @appTypeId AND  APP.backupSet = @backupsetId AND (@subclientId = 0 OR APP.id = @subclientId)
	ELSE
		INSERT INTO @opts(entityId)
		SELECT DISTINCT APP.backupSet
		FROM APP_Application APP WITH (NOLOCK)
		WHERE APP.clientId = @clientId AND APP.instance = @instanceId AND APP.appTypeId = @appTypeId AND (@backupsetId = 0 OR APP.backupSet = @backupsetId)
	-- Get index server clientid based on whether index is at backupset or subclient level
	DECLARE @curIdxServerName VARCHAR(MAX)
	DECLARE @curIdxServerId INT
	IF(@isSubClientEntity = 0)
	BEGIN
		UPDATE @opts
		SET @curIdxServerId = C.id,
		@curIdxServerName = C.name
		FROM @opts T
		JOIN APP_BackupSetName BS WITH (NOLOCK) ON BS.id = T.entityId
		JOIN App_IndexDBInfo I WITH (NOLOCK) ON I.dbName = BS.GUID AND I.isPrimary = 1
		JOIN App_Client C WITH (NOLOCK) ON C.id = I.currentIdxServer
	END
	ELSE
	BEGIN
		UPDATE @opts
		SET @curIdxServerId = C.id,
		@curIdxServerName = C.name
		FROM @opts T
		JOIN APP_Application APP WITH (NOLOCK) ON APP.id = T.entityId
		JOIN App_IndexDBInfo I WITH (NOLOCK) ON I.dbName = APP.GUID AND I.isPrimary = 1
		JOIN App_Client C WITH (NOLOCK) ON C.id = I.currentIdxServer
	END
	UPDATE @opts
	SET curIdxServer = (SELECT  @curIdxServerName '@clientName', @curIdxServerId   '@clientId' FOR xml PATH('currentIndexServer')),
	indexMAs = (SELECT (SELECT DISTINCT MA.name '@clientName', MA.id '@clientId'
	FROM @opts ENT
	JOIN APP_Application APP WITH (NOLOCK) ON @idxSrvrSwitchEnabled = 1 OR ((@isSubClientEntity = 1 AND ENT.entityId = APP.id) OR (@isSubClientEntity = 0 AND ENT.entityId = APP.backupSet))
	JOIN archGroup AG WITH (NOLOCK) ON APP.dataArchGrpID = AG.id
	JOIN archGroupCopy AGC WITH (NOLOCK) ON AG.id = AGC.archGroupId
	JOIN MMDataPath dataPath WITH(NOLOCK) ON AGC.id = dataPath.CopyId
	JOIN MMDrivePool drivepool WITH (NOLOCK) ON dataPath.DrivePoolId = drivepool.DrivePoolId
	JOIN APP_Client MA WITH (NOLOCK) ON ((MA.id = drivepool.ClientId AND MA.releaseId >= 16) AND dataPath.CopyId = AG.defaultCopy)
		 OR (@idxSrvrSwitchEnabled = 0 AND MA.id = @curIdxServerId)
	WHERE @isSubClientEntity = 1 OR NOT EXISTS (SELECT 1 FROM JMJobAction WITH(NOLOCK) WHERE clientId = 1 AND mediaAgentID = 1 AND appType = 0 AND optype = 4 AND appId = APP.id AND action = 1)
	FOR XML PATH ('qualifyingIndexServers'), TYPE) FOR XML PATH('indexMAs'), TYPE)
	DECLARE @pruningEnabled INT = ISNULL((SELECT CAST(ISNULL(value,0) AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'Enable Index Pruning' AND modified = 0),0)
	IF @pruningEnabled > 0
	BEGIN
		DECLARE @pruningOpts TABLE(entityId INT, enablePruning INT DEFAULT 0, retDays	INT DEFAULT -1, retCycles INT DEFAULT -1, pruningType INT DEFAULT 0)
		IF(@scIdxEnabled = 0 AND @isSubClientEntity = 0) -- Fetch Backupset Property
		BEGIN
			INSERT INTO @pruningOpts SELECT * FROM dbo.GetIndexServerPruningSettings (@backupsetId, 0)
			UPDATE @opts SET
			indexPruning = tmp.enablePruning,
			retDays = tmp.retDays,
			retCycles = tmp.retCycles,
			pruningType = tmp.pruningType
			FROM @pruningOpts tmp WHERE tmp.entityId = @backupsetId
		END
		ELSE -- Fetch Subclient Property
		BEGIN
			INSERT INTO @pruningOpts SELECT * FROM dbo.GetIndexServerPruningSettings (@subclientId, 1)
			UPDATE @opts SET
			indexPruning = tmp.enablePruning,
			retDays = tmp.retDays,
			retCycles = tmp.retCycles,
			pruningType = tmp.pruningType
			FROM @pruningOpts tmp WHERE tmp.entityId = @subclientId
		END
	END
	IF EXISTS(SELECT TOP 1 * FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'Allow IndexBackup SP Change' and value = 1 and modified = 0)
	BEGIN
		UPDATE @opts
		SET indexBkpSp = (SELECT S.archGroupName as '@storagePolicyName', S.archGroupId as '@storagePolicyId'
		FROM dbo.GetIndexBackupSPList(@backupsetId) S WHERE currentArchGroup = 1 FOR XML PATH ('currentIndexBackupSP'))
		UPDATE @opts
		SET indexBkpEligibleSPs = (select (select DISTINCT S.archGroupName '@storagePolicyName', S.archGroupId as '@storagePolicyId'  FROM dbo.GetIndexBackupSPList(@backupsetId) S
		FOR XML PATH ('eligibleIndexBackupSP'), TYPE) FOR XML PATH ('indexBackupSPs'), TYPE)
	END
	RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetIndexServerOptions]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetIndexServerOptions' AND revision = '')

  insert into GXDBVersions values(5, 'GetIndexServerOptions',  '', 'GetIndexServerOptions', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
