

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetIndexServerList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetIndexServerList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetIndexServerList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetIndexServerList]
  delete from GXDBVersions where name = 'GetIndexServerList' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[GetIndexServerList](@backupSetId INT)
RETURNS @idxServerList
TABLE
(
	idxServerId INT,
	idxServerName	NVARCHAR(520),
	currentServer	BIT
)
AS
BEGIN
	DECLARE @idxSrvrSwitchEnabled INT = 0
    SELECT @idxSrvrSwitchEnabled = ISNULL(value, 0) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'EnableIdxSrvrSwitch' and modified = 0
    IF @idxSrvrSwitchEnabled > 0
    BEGIN
	   INSERT INTO @idxServerList
       SELECT DISTINCT S.id   '@clientId',	S.name '@clientName', (CASE WHEN S.id = indexDbInfo.currentIdxServer THEN 1 ELSE 0 END) as currentServer	FROM
       archGroup archGroup WITH(NOLOCK) JOIN archGroupCopy archGroupCopy WITH(NOLOCK) ON archGroup.id = archGroupCopy.archGroupId 		JOIN MMDataPath dataPath WITH(NOLOCK) ON archGroupCopy.id = dataPath.CopyId		JOIN MMDrivePool drivePool WITH(NOLOCK) ON dataPath.DrivePoolId = drivePool.DrivePoolId		JOIN App_Client S WITH(NOLOCK) ON drivePool.ClientId = S.id AND S.releaseId >= 16
	   JOIN App_IndexDBInfo indexDbInfo ON indexDbInfo.backupSetId = @backupSetId
    END
    ELSE
    BEGIN
		INSERT INTO @idxServerList
        SELECT DISTINCT S.id   '@clientId',	S.name '@clientName', (CASE WHEN indexDB.currentIdxServer = S.id THEN 1 ELSE 0 END) FROM
        APP_Application A WITH(NOLOCK) JOIN archGroup archGroup WITH(NOLOCK) ON A.dataArchGrpID = archGroup.id		JOIN archGroupCopy archGroupCopy WITH(NOLOCK) ON archGroup.id = archGroupCopy.archGroupId		JOIN MMDataPath dataPath WITH(NOLOCK) ON archGroupCopy.id = dataPath.CopyId		JOIN MMDrivePool drivePool WITH(NOLOCK) ON dataPath.DrivePoolId = drivePool.DrivePoolId		JOIN App_Client S WITH(NOLOCK) ON drivePool.ClientId = S.id 		JOIN App_IndexDBInfo indexDB WITH(NOLOCK) ON indexDB.backupSetId = @backupSetId AND @backupSetId = A.backupset
	END
	RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetIndexServerList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetIndexServerList' AND revision = '')

  insert into GXDBVersions values(5, 'GetIndexServerList',  '', 'GetIndexServerList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
