

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetIndexBackupSPList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetIndexBackupSPList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetIndexBackupSPList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetIndexBackupSPList]
  delete from GXDBVersions where name = 'GetIndexBackupSPList' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[GetIndexBackupSPList](@backupSetId INT)
RETURNS @idxBackupSPList
TABLE
(
	archGroupId INT,
	archGroupName	NVARCHAR(300),
	currentArchGroup	BIT
)
AS
BEGIN
	INSERT INTO @idxBackupSPList
   SELECT DISTINCT archGroup.id,	archGroup.name,
	(CASE WHEN archGroup.id = indexDB.archGroupId THEN 1 ELSE 0 END)
	FROM	archGroup archGroup WITH(NOLOCK) JOIN APP_Application app WITH(NOLOCK) ON app.dataArchGrpID = archGroup.id AND app.backupSet = @backupSetId
JOIN App_IndexDBInfo indexDB WITH(NOLOCK) ON indexDB.backupSetId = @backupSetId AND archGroup.id > 1
	RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetIndexBackupSPList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetIndexBackupSPList' AND revision = '')

  insert into GXDBVersions values(5, 'GetIndexBackupSPList',  '', 'GetIndexBackupSPList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
