

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetIPAddressString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetIPAddressString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetIPAddressString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetIPAddressString]
  delete from GXDBVersions where name = 'GetIPAddressString' and type = 5
END
GO

	CREATE FUNCTION GetIPAddressString (@i_IP BIGINT)
	RETURNS VARCHAR(20)
	-- WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE @IPString	VARCHAR(20)
		IF @i_IP = -1
			SET @IPString = '255.255.255.255'
		ELSE
		BEGIN
			IF @i_IP < 0
				SET @i_IP = @i_IP + 4294967296
			DECLARE @Octet1		BIGINT
	 		DECLARE @Octet2		TINYINT
	 		DECLARE @Octet3		TINYINT
	 		DECLARE @Octet4		TINYINT
	 		SET @Octet1	= @i_IP / (256 * 256 * 256)
	 		SET @Octet2	= (@i_IP - @Octet1 * 256 * 256 * 256) / (256 * 256)
	 		SET @Octet3	= (@i_IP - @Octet1 * 256 * 256 * 256 - @Octet2 * 256 * 256) / 256
	 		SET @Octet4	= (@i_IP - @Octet1 * 256 * 256 * 256 - @Octet2 * 256 * 256 - @Octet3 * 256)
	 		SET @IPString	= (CONVERT(VARCHAR, @Octet1) + '.' + CONVERT(VARCHAR, @Octet2) + '.' + CONVERT(VARCHAR, @Octet3) + '.' + CONVERT(VARCHAR, @Octet4))
		END
	 	RETURN @IPString
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetIPAddressString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetIPAddressString' AND revision = '1.4.208.1')

  insert into GXDBVersions values(5, 'GetIPAddressString',  '1.4.208.1', 'GetIPAddressString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
