

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetHostnameFromUrl.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetHostnameFromUrl'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetHostnameFromUrl]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetHostnameFromUrl]
  delete from GXDBVersions where name = 'GetHostnameFromUrl' and type = 5
END
GO

 SET ANSI_NULLS ON
 GO
 SET QUOTED_IDENTIFIER ON
 GO
 SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
 GO
	CREATE FUNCTION GetHostnameFromUrl(@webUrl NVARCHAR(2083))
	RETURNS NVARCHAR(512)
		AS
		BEGIN
			DECLARE @pos1 INT = CHARINDEX('//', @webUrl)
			DECLARE @pos2 INT = CASE WHEN @pos1 = 0 THEN 1 ELSE @pos1 + 2 END

			RETURN SUBSTRING(@webUrl,
				@pos2,

				CASE
					WHEN CHARINDEX(':', @webUrl, @pos2) > 0 THEN CHARINDEX(':', @webUrl, @pos2) - @pos2
					WHEN CHARINDEX('/', @webUrl, @pos2) > 0 THEN CHARINDEX('/', @webUrl, @pos2) - @pos2
					WHEN CHARINDEX('?', @webUrl, @pos2) > 0 THEN CHARINDEX('?', @webUrl, @pos2) - @pos2
					ELSE LEN(@webUrl)
				END
				)
		END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetHostnameFromUrl]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetHostnameFromUrl' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'GetHostnameFromUrl',  '1.1.2.1', 'GetHostnameFromUrl', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
