

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDriveByJobId.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDriveByJobId'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDriveByJobId]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDriveByJobId]
  delete from GXDBVersions where name = 'GetDriveByJobId' and type = 5
END
GO

	CREATE FUNCTION GetDriveByJobId(@i_jobId INTEGER)
	RETURNS NVARCHAR(MAX)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE	@driveType	integer
		DECLARE	@driveName	nvarchar(128)
		DECLARE @o_driveList NVARCHAR(MAX)
		SET @o_driveList=''

		DECLARE @tempDrive TABLE(
			id	integer
		)

		INSERT INTO @tempDrive
		SELECT DISTINCT DriveId
		FROM JMJobResourceHistory
		WHERE jobId=@i_jobId

		DECLARE driveList CURSOR FOR
			SELECT DISTINCT DriveTypeId, AliasName
			FROM @tempDrive LEFT JOIN MMDrive WITH (READUNCOMMITTED) ON Id=DriveId
		OPEN driveList
		FETCH NEXT FROM driveList INTO @driveType, @driveName
		WHILE @@FETCH_STATUS <> -1
		BEGIN
			IF LEN(@o_driveList) <> 0
				SET @o_driveList =  @o_driveList + ', '

			IF @driveType = 10001
				SET @o_driveList = @o_driveList + 'Magnetic'
			ELSE
				SET @o_driveList = @o_driveList + @driveName

			FETCH NEXT FROM driveList INTO @driveType, @driveName
		END
		CLOSE driveList
		DEALLOCATE driveList

		RETURN @o_driveList
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDriveByJobId]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDriveByJobId' AND revision = '1.2.208.3')

  insert into GXDBVersions values(5, 'GetDriveByJobId',  '1.2.208.3', 'GetDriveByJobId', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
