

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDependentSubClientForSubClient.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: GetDependentSubClientForSubClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDependentSubClientForSubClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDependentSubClientForSubClient]
  delete from GXDBVersions where name = 'GetDependentSubClientForSubClient' and type = 5
END
GO

	CREATE FUNCTION dbo.GetDependentSubClientForSubClient
	(
		@i_sub_clientId integer
	)
	RETURNS
	@subClientIds table
	(
		id integer
	)
	AS
	BEGIN
	-- Need to EXEC CCM_Create_Synonyms '<database name>' before invoking this function, will fail otherwise
	-- Because of CCM Capture From Other DB framework
	IF NOT EXISTS (SELECT 1 FROM CCM_SOURCE_JMJobDataLink WHERE parentAppid = @i_sub_clientId  OR childAppid = @i_sub_clientId )
		RETURN
	DECLARE @appList TABLE(appId integer, primary key (appId))
	DECLARE @parent_count      INTEGER
	DECLARE @child_count       INTEGER
	INSERT INTO @appList VALUES(@i_sub_clientId)
	SET @parent_count = @@ROWCOUNT
	WHILE (@parent_count > 0 OR @child_count > 0)
	BEGIN
		INSERT INTO @appList
		SELECT DISTINCT a.childAppid
		FROM CCM_SOURCE_JMJobDataLink a WITH (NOLOCK)
		INNER JOIN @appList b ON a.parentAppid = b.appId
		LEFT OUTER JOIN @appList c ON a.childAppid = c.appId
		WHERE a.childAppid > 0 AND c.appId IS NULL
 		AND EXISTS(SELECT 1 FROM CCM_SOURCE_APP_Application WHERE id = a.childAppid)
		SET @child_count = @@ROWCOUNT
		INSERT INTO @appList
		SELECT DISTINCT a.parentAppid
		FROM CCM_SOURCE_JMJobDataLink a WITH (NOLOCK)
		INNER JOIN @appList b ON a.childAppid = b.appId
		LEFT OUTER JOIN @appList c ON a.parentAppid = c.appId
		WHERE a.parentAppid > 0 AND c.appId is null
		SET @parent_count = @@ROWCOUNT
	END
	 INSERT INTO @subClientIds
	 SELECT DISTINCT appId FROM @appList
	 WHERE appId <> @i_sub_clientId
		RETURN
	END
	GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDependentSubClientForSubClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDependentSubClientForSubClient' AND revision = '1.4.88.3')

  insert into GXDBVersions values(5, 'GetDependentSubClientForSubClient',  '1.4.88.3', 'GetDependentSubClientForSubClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
