

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDefaultAnalyticsIndexPath.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDefaultAnalyticsIndexPath'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDefaultAnalyticsIndexPath]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDefaultAnalyticsIndexPath]
  delete from GXDBVersions where name = 'GetDefaultAnalyticsIndexPath' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION GetDefaultAnalyticsIndexPath(@i_clientID INT, @i_suffixPath NVARCHAR(1024))
RETURNS NVARCHAR(2048)
AS
BEGIN
	--set default folder to AnalyticsIndex
	IF ISNULL(@i_suffixPath, '') = ''
		SET @i_suffixPath = '\AnalyticsIndex'
	ELSE
	BEGIN
		SET @i_suffixPath = LTRIM(RTRIM(@i_suffixPath))
		--prefix slash char if not present
		 IF @i_suffixPath NOT LIKE '\%' AND @i_suffixPath NOT LIKE '/%'
			SET @i_suffixPath = '\' + @i_suffixPath
		-- remove trailing slash chars
		 IF @i_suffixPath LIKE '%\' OR @i_suffixPath LIKE '%/'
			SET @i_suffixPath = SUBSTRING(@i_suffixPath, 1, LEN(@i_suffixPath)-1)
	END
	--By default use MediaAgent indexCache directory
	  DECLARE @defaultIndexPath NVARCHAR(2048) = N''
		SET @defaultIndexPath  = (	SELECT  attrVal
									FROM APP_ClientProp (NOLOCK)
									WHERE componentNameId = @i_clientID AND attrName = 'Idx: cache path'  AND modified =0
								)
	--if MA package is not installed, use client install directory
		IF ISNULL(@defaultIndexPath, '') = ''
		BEGIN
			SET @defaultIndexPath  = (	SELECT install_dir
										FROM APP_Platform (NOLOCK)
										WHERE clientId = @i_clientID AND platformType = 4
										)
			IF @defaultIndexPath = 'N/A' SET @defaultIndexPath = ''
		END
	--append i_suffixPath path and correct slash char based on OS type
		IF ISNULL(@defaultIndexPath, '') <> ''
			SET @defaultIndexPath  =  @defaultIndexPath + (SELECT CASE WHEN S.Type ='WINDOWS' THEN REPLACE (@i_suffixPath,'/','\') ELSE REPLACE (@i_suffixPath,'\','/') END
										FROM APP_Client C
										JOIN SimOperatingSystem S (NOLOCK) ON C.simOperatingSystemId = S.id
										WHERE C.Id = @i_clientID)
	RETURN @defaultIndexPath
END
GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDefaultAnalyticsIndexPath]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDefaultAnalyticsIndexPath' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'GetDefaultAnalyticsIndexPath',  '1.1.2.1', 'GetDefaultAnalyticsIndexPath', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
