

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDayStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDayStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDayStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDayStart]
  delete from GXDBVersions where name = 'GetDayStart' and type = 5
END
GO

	CREATE FUNCTION GetDayStart (@DateArg DATETIME, @DayStartOffset int)
	RETURNS DATETIME
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @DiffSeconds int
		SET @DiffSeconds = datepart(hour, @DateArg) * 3600
					+ datepart(minute, @DateArg) * 60
					+ datepart(second, @DateArg)
		SET @DiffSeconds = @DiffSeconds - @DayStartOffset
		RETURN dateadd(second, dbo.GetUnixTime(@DateArg) - @DiffSeconds, '01/01/1970')
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDayStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDayStart' AND revision = '1.3.304.1')

  insert into GXDBVersions values(5, 'GetDayStart',  '1.3.304.1', 'GetDayStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
