

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDayBoundaryCurrentCycleStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDayBoundaryCurrentCycleStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDayBoundaryCurrentCycleStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDayBoundaryCurrentCycleStart]
  delete from GXDBVersions where name = 'GetDayBoundaryCurrentCycleStart' and type = 5
END
GO

    CREATE FUNCTION GetDayBoundaryCurrentCycleStart (@commCellId int, @currentTime DATETIME, @treatWeekend int)
    RETURNS DATETIME
    -- WITH ENCRYPTION
    AS
    BEGIN
        DECLARE @timeNextCycle          datetime
        DECLARE @timePrevCycle          datetime
        DECLARE @timeSecondPrevCycle    datetime
        DECLARE @dayNum                 int
        DECLARE @dayNumNextCycle        int
        DECLARE @dayNumPrevCycle        int
        DECLARE @dayNumSecondPrevCycle  int
        DECLARE @todayCycleEnd          datetime
        DECLARE @nextCycleEnd           datetime
        DECLARE @prevCycleEnd           datetime
        DECLARE @secondPrevCycleEnd     datetime
        DECLARE @todayCycleStart        datetime
        DECLARE @nextCycleStart         datetime
        DECLARE @prevCycleStart         datetime
        DECLARE @secondPrevCycleStart   datetime
        DECLARE @daysCommCellId         int
        SET @daysCommCellId     = CASE WHEN EXISTS (SELECT CommCellId FROM APP_CommCellDays WHERE CommCellId = @commCellId) THEN @commCellId ELSE 1 END
        SET @dayNum             = DATEPART(dw, @currentTime)
        SET @timeNextCycle  = DATEADD(day,
                                      CASE WHEN @treatWeekend = 1 AND @dayNum = 6 THEN +3
                                           WHEN @treatWeekend = 1 AND @dayNum = 7 THEN +2
                                           ELSE                                        +1
                                      END,
                                      @currentTime)
        SET @dayNumNextCycle = DATEPART(dw, @timeNextCycle)
        SET @timePrevCycle = DATEADD(day,
                                     CASE WHEN @treatWeekend = 1 AND @dayNum = 1 THEN -3
                                          WHEN @treatWeekend = 1 AND @dayNum = 7 THEN -2
                                          ELSE                                        -1
                                     END,
                                     @currentTime)
        SET @dayNumPrevCycle = DATEPART(dw, @timePrevCycle)
        SET @timeSecondPrevCycle = DATEADD(day,
                                           CASE WHEN @treatWeekend = 1 AND @dayNum = 2 THEN -4
                                                WHEN @treatWeekend = 1 AND @dayNum = 1 THEN -4
                                                WHEN @treatWeekend = 1 AND @dayNum = 7 THEN -3
                                                ELSE                                        -2
                                           END,
                                           @currentTime)
        SET @dayNumSecondPrevCycle  = DATEPART(dw, @timeSecondPrevCycle)
        SET @todayCycleEnd = DATEADD(minute,
                                     (SELECT CASE @treatWeekend
                                                WHEN 1  THEN WkEndActivityOffSetEnd
                                                ELSE        WkDayActivityOffSetEnd
                                             END
                                      FROM   APP_CommCellDays
                                      WHERE     commCellId = @daysCommCellId
                                            AND DayNum = @dayNum),
                                      dbo.GetDayStart(@currentTime, 0))
        SET @nextCycleEnd = DATEADD(minute,
                                    (SELECT CASE @treatWeekend
                                                WHEN 1 THEN WkEndActivityOffSetEnd
                                                ELSE        WkDayActivityOffSetEnd
                                            END
                                     FROM   APP_CommCellDays
                                     WHERE      CommCellId = @daysCommCellId
                                            AND DayNum = @dayNumNextCycle),
                                     dbo.GetDayStart(@timeNextCycle, 0))
        SET @prevCycleEnd = DATEADD(minute,
                                   (SELECT  CASE @treatWeekend
                                                 WHEN 1  THEN WkEndActivityOffSetEnd
                                                 ELSE         WkDayActivityOffSetEnd
                                            END
                                    FROM    APP_CommCellDays
                                    WHERE       CommCellId = @daysCommCellId
                                            AND DayNum = @dayNumPrevCycle),
                                    dbo.GetDayStart(@timePrevCycle, 0))
        SET @secondPrevCycleEnd = DATEADD(minute,
                                          (SELECT CASE @treatWeekend
                                                        WHEN 1  THEN  WkEndActivityOffSetEnd
                                                        ELSE          WkDayActivityOffSetEnd
                                                  END
                                           FROM   APP_CommCellDays
                                           WHERE      CommCellId = @daysCommCellId
                                                  AND DayNum = @dayNumSecondPrevCycle),
                                           dbo.GetDayStart(@timeSecondPrevCycle, 0))
        SET @todayCycleStart = DATEADD(minute,
                                       (SELECT  CASE @treatWeekend
                                                    WHEN 1  THEN WkEndActivityOffSetStart
                                                    ELSE         WkDayActivityOffSetStart
                                                END
                                        FROM    APP_CommCellDays
                                        WHERE       CommCellId = @daysCommCellId
                                                AND dayNum = @dayNum),
                                       dbo.GetDayStart(@currentTime, 0))
        SET @nextCycleStart = DATEADD(minute,
                                      (SELECT  CASE @treatWeekend
                                                   WHEN 1 THEN WkEndActivityOffSetStart
                                                   ELSE        WkDayActivityOffSetStart
                                               END
                                       FROM    APP_CommCellDays
                                       WHERE       CommCellId = @daysCommCellId
                                               AND DayNum = @dayNumNextCycle),
                                      dbo.GetDayStart(@timeNextCycle, 0))
        SET @prevCycleStart = DATEADD(minute,
                                      (SELECT CASE @treatWeekend
                                                  WHEN 1 THEN WkEndActivityOffSetStart
                                                  ELSE        WkDayActivityOffSetStart
                                              END
                                       FROM   APP_CommCellDays
                                       WHERE      CommCellId = @daysCommCellId
                                              AND DayNum = @dayNumPrevCycle),
                                      dbo.GetDayStart(@timePrevCycle, 0))
        SET @secondPrevCycleStart = DATEADD(minute,
                                            (SELECT  CASE @treatWeekend
                                                        WHEN 1 THEN WkEndActivityOffSetStart
                                                        ELSE        WkDayActivityOffSetStart
                                             END
                                             FROM    APP_CommCellDays
                                             WHERE       CommCellId = @daysCommCellId
                                                     AND DayNum = @DayNumSecondPrevCycle),
                                            dbo.GetDayStart(@TimeSecondPrevCycle, 0))
        IF @currentTime >= @todayCycleEnd
        BEGIN
            RETURN @todayCycleEnd
        END
        ELSE
        IF @currentTime >= @prevCycleEnd and @currentTime < @todayCycleEnd
        BEGIN
            RETURN @prevCycleEnd
        END
            RETURN @secondPrevCycleEnd
    END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDayBoundaryCurrentCycleStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDayBoundaryCurrentCycleStart' AND revision = '1.4.210.1')

  insert into GXDBVersions values(5, 'GetDayBoundaryCurrentCycleStart',  '1.4.210.1', 'GetDayBoundaryCurrentCycleStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
