

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDay.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDay'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDay]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDay]
  delete from GXDBVersions where name = 'GetDay' and type = 5
END
GO

	CREATE FUNCTION GetDay (@DayStartOffset int, @weekOffset int, @dayOfweekOffset int, @year int, @month int, @calendarId int)
	RETURNS DATETIME
		AS
	BEGIN
			DECLARE @startDate DATETIME
			DECLARE @wantedDate DATETIME
			DECLARE @weekDay integer
			DECLARE @dayDiff integer
			DECLARE @endDate DATETIME
			DECLARE @daysCount INTEGER
				set @startDate = 0
				set @endDate = 0
				set @startDate = dbo.GetStartDay(@year, @month, @calendarId)
				set @endDate = dbo.GetEndDay(@year, @month, @calendarId)
				set @daysCount = DATEDIFF(d, @startDate,@endDate)
				if (@startDate = 0) OR (@endDate = 0)
					return 0
				set @wantedDate = @startDate
				set @weekDay = DATEPART(weekday, @startDate)
				if(@dayOfweekOffset > 0)
				BEGIN
					set @dayDiff = @dayOfweekOffset - @weekDay
					if (@dayDiff < 0)
						set @wantedDate = DATEADD(day, (7 + @dayDiff), @startDate)
					else
						set @wantedDate = DATEADD(day, (@dayDiff), @startDate)
					set @wantedDate = DATEADD(day, ((@weekOffset -1) *7), @wantedDate)
				END
				if (@DayStartOffset > 0)
                    if(@DayStartOffset > @daysCount)
						set @wantedDate = @endDate
    			    else
						set @wantedDate = DATEADD(day, (@DayStartOffset-1), @wantedDate)
				IF (@wantedDate > @endDate) OR (@wantedDate < @startDate)
					return 0
				return @wantedDate
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDay]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDay' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetDay',  '1.4', 'GetDay', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
