

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDateTimeFormatString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDateTimeFormatString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDateTimeFormatString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDateTimeFormatString]
  delete from GXDBVersions where name = 'GetDateTimeFormatString' and type = 5
END
GO

	CREATE FUNCTION GetDateTimeFormatString (@UnixTimeArg integer, @inTime DATETIME, @formatType integer)
	RETURNS VARCHAR(128)
	-- WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE @time 		DATETIME
	 	DECLARE @timeStr	VARCHAR(128)

	 	IF @inTime is not null
	 		SET @time = @inTime
	 	ELSE IF @UnixTimeArg > 0
	 		SET @time = dateadd(second, @UnixTimeArg, '01/01/1970')
	 	ELSE
	 		RETURN ''
		DECLARE @day    int
		DECLARE @month  int
		DECLARE @year   int
		DECLARE @hour   int
		DECLARE @minute int
		DECLARE @sec	int
		DECLARE @dayStr varchar(4)
		DECLARE @monthStr varchar(4)

		SET @month    = DATEPART(MONTH, @time)
		SET @day      = DATEPART(DAY, @time)
            SET @monthStr = ( CASE WHEN @month < 10 THEN '0' + CAST(@month as nvarchar(4)) ELSE CAST(@month as nvarchar(4)) END)
		SET @dayStr   = ( CASE WHEN @day < 10 THEN '0' + CAST(@day as nvarchar(4)) ELSE CAST(@day as nvarchar(4)) END)
		SET @year     = DATEPART(YEAR,@time)
		SET @hour     = DATEPART(hour, @time)
		SET @minute   = DATEPART(minute, @time)
		SET @sec      = DATEPART(second, @time)

		IF ( @formatType = 0 )  SET @timeStr = @monthStr + '/' + @dayStr ELSE SET  @timeStr = @dayStr + '/' + @monthStr

		SET @timeStr += '/'
		SET @timeStr += CAST( @year as nvarchar(4))
		SET @timeStr += ' '
		SET @timeStr += ( CASE WHEN @hour < 10 THEN '0' + CAST(@hour as nvarchar(4)) ELSE CAST(@hour as nvarchar(4)) END)
		SET @timeStr += ':'
		SET @timeStr += ( CASE WHEN @minute < 10 THEN '0' + CAST(@minute as nvarchar(4)) ELSE CAST(@minute as nvarchar(4)) END)
		SET @timeStr += ':'
		SET @timeStr += ( CASE WHEN @sec < 10 THEN '0' + CAST(@sec as nvarchar(4)) ELSE CAST(@sec as nvarchar(4)) END)

		RETURN @timeStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDateTimeFormatString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDateTimeFormatString' AND revision = '1.2.200.1')

  insert into GXDBVersions values(5, 'GetDateTimeFormatString',  '1.2.200.1', 'GetDateTimeFormatString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
