

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDateTime2.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDateTime2'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDateTime2]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDateTime2]
  delete from GXDBVersions where name = 'GetDateTime2' and type = 5
END
GO

	CREATE FUNCTION GetDateTime2 (@UnixTimeArg integer, @inTime DATETIME, @dateOnly integer)
	RETURNS VARCHAR(128)
	-- WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE @time 		DATETIME
	 	DECLARE @timeStr	VARCHAR(128)
		DECLARE @dpPos		INT
	 	IF @inTime is not null
	 		SET @time = @inTime
	 	ELSE IF @UnixTimeArg > 0
	 		SET @time = dateadd(second, @UnixTimeArg, '01/01/1970')
	 	ELSE
	 		RETURN ''
	 	SET @timeStr = convert(VARCHAR(128), @time)
		SET @dpPos = CHARINDEX(' ', REVERSE(@timeStr))
		IF @dateOnly > 0 AND @dpPos > 0
			SET @timeStr = SUBSTRING(@timeStr, 1, LEN(@timeStr) - @dpPos)
		RETURN @timeStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDateTime2]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDateTime2' AND revision = '1.1.290.1')

  insert into GXDBVersions values(5, 'GetDateTime2',  '1.1.290.1', 'GetDateTime2', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
