

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetCurrentAvgQITimeMedian.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetCurrentAvgQITimeMedian'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetCurrentAvgQITimeMedian]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetCurrentAvgQITimeMedian]
  delete from GXDBVersions where name = 'GetCurrentAvgQITimeMedian' and type = 5
END
GO

	CREATE FUNCTION GetCurrentAvgQITimeMedian(@SIDBStoreId int, @SubStoreId int, @CommCellId int, @DaysToConsider int)
	RETURNS bigint
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @SubStoresAvgQITime table (SubStoreId int, AvgQITime bigint, RowNumber int)
		DECLARE @SubStoresMedianAvgQITime table (SubStoreId int, AvgQITime bigint)
		DECLARE @AvgQITimeMedian bigint = 0
		DECLARE @DayStartOnDaysToConsider int = 0

		IF (@DaysToConsider = 0)
		BEGIN
			SELECT	TOP 1 @DaysToConsider = ISNULL(value, 3)
			FROM	MMConfigs WITH (READUNCOMMITTED)
			WHERE	name = 'MMCONFIG_STORE_LIMIT_EVENT_DAYS_TO_CONSIDER'
		END
		SET @DayStartOnDaysToConsider = dbo.GetUnixTime(dbo.ClientLocalToUTCTime(DATEADD(DAY, datediff(DAY, 0, GETDATE()), -@DaysToConsider), 2))

		INSERT 	INTO @SubStoresAvgQITime
		SELECT 	SubStoreId, AvgQITime,
				ROW_NUMBER() OVER (PARTITION BY SubStoreId ORDER BY AvgQITime ASC) AS RowNumber
		FROM 	IdxSIDBUsageHistory WITH (READUNCOMMITTED)
		WHERE 	HistoryType = 2
				AND SIDBStoreId = @SIDBStoreId
				AND (@SubStoreId = 0 OR SubStoreId = @SubStoreId)
				AND CommCellId = @CommCellId
				AND ModifiedTime >= @DayStartOnDaysToConsider
		--Cleanup if we dont have records for min 60% of number of days to consider, we dont need such stores.
		IF @DaysToConsider >= 10
			SET @DaysToConsider = @DaysToConsider * 0.6
		DELETE SSD1
		FROM @SubStoresAvgQITime SSD1,
		(
			SELECT SubStoreId FROM @SubStoresAvgQITime GROUP BY SubStoreId HAVING COUNT(*) < @DaysToConsider
		) SSD2
		WHERE SSD1.SubStoreId = SSD2.SubstoreId

		INSERT INTO @SubStoresMedianAvgQITime
		SELECT SubStoreId,  AVG(AvgQITime)
		FROM (
				SELECT	SubStoreId, AvgQITime,
				RowNumber AS RowNumAsc,
				ROW_NUMBER() OVER (PARTITION BY SubStoreId ORDER BY RowNumber DESC) AS RowNumDesc
				FROM 	@SubStoresAvgQITime
			) Usage
		WHERE RowNumAsc IN (RowNumDesc, RowNumDesc - 1, RowNumDesc + 1)
		GROUP BY SubStoreId
		SELECT @AvgQITimeMedian = ISNULL(MAX(AvgQITime), 0)
		FROM @SubStoresMedianAvgQITime


		RETURN @AvgQITimeMedian
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetCurrentAvgQITimeMedian]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetCurrentAvgQITimeMedian' AND revision = '1.5.50.3')

  insert into GXDBVersions values(5, 'GetCurrentAvgQITimeMedian',  '1.5.50.3', 'GetCurrentAvgQITimeMedian', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
