

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClusterClientsForClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClusterClientsForClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClusterClientsForClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClusterClientsForClient]
  delete from GXDBVersions where name = 'GetClusterClientsForClient' and type = 5
END
GO

	CREATE FUNCTION dbo.GetClusterClientsForClient
	(
		@i_clientId integer
	)
	RETURNS
	@clientIds table
	(
		id integer
	)
	AS
	BEGIN
	-- Need to EXEC CCM_Create_Synonyms '<database name>' before invoking this function, will fail otherwise
	-- Because of CCM Capture From Other DB framework
	DECLARE @virtual_client table (id int)
    DECLARE @physical_client table (id int)
	DECLARE @capture_table table (id int)
	DECLARE @vclient_count int
	DECLARE @pclient_count int
    SET @vclient_count = 0
	SET @pclient_count = 0
	INSERT INTO @virtual_client
	SELECT DISTINCT VMClientId
	FROM CCM_SOURCE_APP_VMToPMMap
	WHERE VMClientId = @i_clientId
	INSERT INTO @physical_client
	SELECT DISTINCT PMClientId
	FROM CCM_SOURCE_APP_VMToPMMap
	WHERE PMClientId = @i_clientId
	SET @vclient_count = (SELECT COUNT(*) FROM @virtual_client)
	SET @pclient_count = (SELECT COUNT(*) FROM @physical_client)
	-- Ideally, in any iteration of the loop, one of the two count
	-- will be zero and only one inner if block will be executed
	-- The complex while logic is required because the requirement is to
	-- ensure that the complete cluster configuration is captured.
	/*
	  Example:
	  Cluster 1 : V1 and P1, P2
	  Cluster 2 : V2 and P1, P3
	  Any request to capture cluster V1 will capture, V1, P1, P2, V2 and P3
	 */
	WHILE (@vclient_count > 0 OR @pclient_count > 0)
	BEGIN
		   IF(@vclient_count > 0)
		   BEGIN
		     DELETE FROM @physical_client
		     INSERT INTO @physical_client
		     SELECT DISTINCT PMClientId from CCM_SOURCE_APP_VMToPMMap
		     where VMClientId IN (select id from @virtual_client)
		       and PMClientId NOT IN (select id from @capture_table)
		     INSERT INTO @capture_table
		     SELECT id FROM @physical_client
		     WHERE  id NOT IN (select id from @capture_table)
		     DELETE FROM @virtual_client
		   END
		   IF(@pclient_count > 0)
		   BEGIN
		     DELETE FROM @virtual_client
		     INSERT INTO @virtual_client
		     SELECT DISTINCT VMClientId from CCM_SOURCE_APP_VMToPMMap
		     where PMClientId IN (select id from @physical_client)
		       and VMClientId NOT IN (select id from @capture_table)
		     INSERT INTO @capture_table
		     SELECT id FROM @virtual_client
		     WHERE  id NOT IN (select id from @capture_table)
		     DELETE FROM @physical_client
		   END
		     SET @vclient_count = (SELECT COUNT(*) FROM @virtual_client)
		     SET @pclient_count = (SELECT COUNT(*) FROM @physical_client)
	 END
	 INSERT INTO @clientIds
	 SELECT id FROM @capture_table
		RETURN
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClusterClientsForClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClusterClientsForClient' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetClusterClientsForClient',  '1.4', 'GetClusterClientsForClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
