

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientOwners.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientOwners'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientOwners]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientOwners]
  delete from GXDBVersions where name = 'GetClientOwners' and type = 5
END
GO

	CREATE FUNCTION GetClientOwners(@clId INTEGER)
	RETURNS NVARCHAR(MAX)
	-- WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @owners VARCHAR(max)
	-- exclude USERS_QNET|USERS_HIDE|USERS_MMC_SSO|USERS_MMC_COMMON_SSO
	DECLARE @excludeUsersFlags int = ( CAST (0x200 AS INT) | CAST (0x004 AS INT) | CAST (0x080 AS INT) | CAST(0x100 AS INT) )
	SET @owners = ''
	SELECT @owners = @owners + u.login + ','
	FROM sec_getClientOwnersExpandUG UUG
		INNER JOIN UMUsers U ON U.id = UUG.userId AND UUG.clientId=@clId
		AND (U.flags & @excludeUsersFlags) = 0
	IF @owners IS NOT NULL AND LEN(@owners) > 0
	BEGIN
		SELECT @owners = SUBSTRING(@owners,1,LEN(@owners) -1)
	END
	RETURN @owners
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientOwners]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientOwners' AND revision = '1.4.42.3')

  insert into GXDBVersions values(5, 'GetClientOwners',  '1.4.42.3', 'GetClientOwners', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
