

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientHardwareName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientHardwareName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientHardwareName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientHardwareName]
  delete from GXDBVersions where name = 'GetClientHardwareName' and type = 5
END
GO

	CREATE FUNCTION GetClientHardwareName (@i_clientID INTEGER, @i_SimOSInfo varchar(255))
	RETURNS VARCHAR(255)
	-- WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE @simOSInfo		varchar(255)
		DECLARE @hwInfoPos		INTEGER
		IF @i_SimOSInfo IS NULL OR @i_SimOSInfo = ''
			SET @simOSInfo = ISNULL((SELECT attrval FROM APP_clientProp where componentNameId = @i_clientID AND attrname = 'Sim OS Info' AND modified = 0), '')
		ELSE
			SET @simOSInfo = @i_SimOSInfo
		IF @simOSInfo = ''
			RETURN ''
		SET @hwInfoPos = CHARINDEX('-:', REVERSE(@simOSInfo))-1
		IF @hwInfoPos = -1
		BEGIN
			SET @hwInfoPos = ISNULL((SELECT simOperatingSystemId FROM APP_client, APP_clientProp where APP_client.Id = @i_clientID AND  componentNameId = @i_clientID AND attrname = 'Sim OS Info' AND APP_clientProp.modified = 0), '')
			SET @simOSInfo = ISNULL((SELECT Name FROM simOperatingSystem where id = @hwInfoPos), '')
			IF @simOSInfo = 'DATA ONTAP'
			RETURN 'Network Appliance'
			IF @simOSInfo = 'Celerra'
			RETURN 'EMC Celerra'
		END
		RETURN substring(@simOSInfo, LEN(@simOSInfo) - @hwInfoPos + 1, @hwInfoPos + 1)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientHardwareName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientHardwareName' AND revision = '1.2.272.1')

  insert into GXDBVersions values(5, 'GetClientHardwareName',  '1.2.272.1', 'GetClientHardwareName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
