

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientGroup.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientGroup'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientGroup]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientGroup]
  delete from GXDBVersions where name = 'GetClientGroup' and type = 5
END
GO

	CREATE FUNCTION GetClientGroup(@clId INTEGER)
	RETURNS NVARCHAR(MAX)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @groups NVARCHAR(MAX)
		DECLARE @curGrp NVARCHAR(512)
		SET @groups = ''
		DECLARE cgCur CURSOR FOR
			SELECT GRP.name
			FROM APP_ClientGroupAssoc ASSOC, APP_ClientGroup GRP
			WHERE ASSOC.clientGroupId = GRP.id
				AND ASSOC.clientId = @clId
		OPEN cgCur
		FETCH NEXT FROM cgCur INTO @curGrp
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @groups = @groups + @curGrp + '; '
			FETCH NEXT FROM cgCur INTO @curGrp
		END
		CLOSE cgCur
		DEALLOCATE cgCur
		-- Truncate the extra semicolon at the end
		IF LEN(@groups) <> 0
			SET @groups = LEFT(@groups, LEN(@groups) -1 )
		RETURN @groups
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientGroup]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientGroup' AND revision = '1.4.202.2')

  insert into GXDBVersions values(5, 'GetClientGroup',  '1.4.202.2', 'GetClientGroup', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
