

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientForWorkflow.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientForWorkflow'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientForWorkflow]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientForWorkflow]
  delete from GXDBVersions where name = 'GetClientForWorkflow' and type = 5
END
GO

	CREATE FUNCTION GetClientForWorkflow(@workflowId INTEGER, @clientId INTEGER)
	RETURNS INTEGER
	AS
	BEGIN
	DECLARE @selectedClientId int
	DECLARE @engineTable TABLE (clientId int, flag int, jobs int)
	DECLARE @lastestVersion int
	SELECT @lastestVersion = ISNULL(Max(Version), 0) FROM WF_Deploy Where WorkflowId = @workflowId
	IF @lastestVersion = 0
		RETURN 0
	INSERT INTO @engineTable
	SELECT d.clientId, 1, ISNULL(j.jobs, 0)
	FROM WF_Deploy d
	LEFT OUTER JOIN (
		SELECT cloudId As clientId, Count(*) AS jobs
		FROM JMAdminJobInfoTable with(nolock)
		WHERE opType = 90
		GROUP BY cloudId
	) j ON d.ClientId = j.clientId
	WHERE [Version] = @lastestVersion AND WorkflowId = @workflowId
	AND d.ClientId IN (
		SELECT ClientId
		FROM dbo.simInstalledPackages with(nolock)
		WHERE simPackageID in (808,854)
	)
	IF EXISTS(SELECT * FROM @engineTable WHERE clientId = @clientId)
	BEGIN
		SET @selectedClientId = @clientId
	END
	ELSE
	BEGIN
		SET @selectedClientId = (SELECT TOP 1 clientId FROM @engineTable ORDER BY jobs)
	END
	RETURN @selectedClientId
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientForWorkflow]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientForWorkflow' AND revision = '1.3.12.6')

  insert into GXDBVersions values(5, 'GetClientForWorkflow',  '1.3.12.6', 'GetClientForWorkflow', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
