

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientAgents.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientAgents'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientAgents]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientAgents]
  delete from GXDBVersions where name = 'GetClientAgents' and type = 5
END
GO

	CREATE FUNCTION GetClientAgents(@clId INTEGER)
	RETURNS NVARCHAR(MAX)
	-- WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @agents NVARCHAR(max)
	DECLARE @curAgent NVARCHAR(512)
	SET @agents = ''
	DECLARE agentCur CURSOR FOR
	SELECT DISTINCT display_name
	FROM simAppTypeLicTypeMap
	WHERE appTypeId IN (SELECT appTypeId FROM APP_Application WHERE clientId = @clId AND apptypeId < 1000)
	OPEN agentCur
	FETCH NEXT FROM agentCur INTO @curAgent
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @agents = @agents + @curAgent + ', '
		FETCH NEXT FROM agentCur INTO @curAgent
	END
	IF @agents IS NOT NULL AND LEN(@agents) > 0
	BEGIN
		SELECT @agents = SUBSTRING(@agents,1,LEN(@agents) -1)
	END
	CLOSE agentCur
	DEALLOCATE agentCur
	RETURN @agents
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientAgents]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientAgents' AND revision = '1.3.208.1')

  insert into GXDBVersions values(5, 'GetClientAgents',  '1.3.208.1', 'GetClientAgents', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
