

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetBkpLevelOfSnapJobs.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetBkpLevelOfSnapJobs'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetBkpLevelOfSnapJobs]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetBkpLevelOfSnapJobs]
  delete from GXDBVersions where name = 'GetBkpLevelOfSnapJobs' and type = 5
END
GO

	CREATE FUNCTION GetBkpLevelOfSnapJobs(@inJobID BIGINT, @inCommCellID INT, @inArchGroupCopyId INT)
	RETURNS INT
	AS
	BEGIN
	DECLARE @opType INT
	DECLARE @outBkpLevel INT
	DECLARE @appType INT

	SELECT @opType = BKP.opType, @outBkpLevel = BKP.bkpLevel, @appType = APP.appTypeId
	FROM JMBkpStats BKP WITH(NOLOCK)
	INNER JOIN APP_Application APP WITH(NOLOCK) ON APP.id = BKP.appId
	WHERE BKP.jobId = @inJobId AND BKP.commCellId = @inCommCellId

	IF	@inArchGroupCopyId <> 0
		AND @outBkpLevel <> 1 -- FULL
		AND @opType = 59 --SNAPBACKUP
		AND ( @appType IN (13 /*NETAPP*/, 88 /*CENTERA*/, 106 /*VIRTUAL_SERVER_IDA*/) )
			  --OR @appType IN (SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35, 0)) -- APPGRP_FileSystemIDA
		AND EXISTS (SELECT 1
					FROM archGroupCopy AGC WITH (NOLOCK)
					INNER JOIN archGroup AG WITH (NOLOCK) ON AGC.archGroupId = AG.id
					WHERE AGC.isSnapCopy = 1
					AND AG.flags & 32768 = 32768 -- CVA_SP_CONSIDER_INCR_SNAPS_AS_FULL_FLAG
					AND AGC.id = @inArchGroupCopyId)
	BEGIN
		SET @outBkpLevel = 1 --FULL
	END

	RETURN ISNULL(@outBkpLevel, 0)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetBkpLevelOfSnapJobs]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetBkpLevelOfSnapJobs' AND revision = '')

  insert into GXDBVersions values(5, 'GetBkpLevelOfSnapJobs',  '', 'GetBkpLevelOfSnapJobs', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
