

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetBkpLevelForSnapCopy.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetBkpLevelForSnapCopy'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetBkpLevelForSnapCopy]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetBkpLevelForSnapCopy]
  delete from GXDBVersions where name = 'GetBkpLevelForSnapCopy' and type = 5
END
GO

	CREATE FUNCTION GetBkpLevelForSnapCopy(@inAppId INTEGER, @inBackupLevel INTEGER, @inArchGroupCopyId INT)
	RETURNS INT
	AS
	BEGIN
	DECLARE @opType INT
	DECLARE @outBkpLevel INT
	DECLARE @appType INT = 0

	SET @outBkpLevel = @inBackupLevel
	SELECT @appType = A.appTypeId
	FROM APP_Application A WITH(NOLOCK)
	INNER JOIN APP_SubClientProp SCPROP WITH(NOLOCK) ON A.id = SCPROP.ComponentNameId
	WHERE A.id = @inAppId AND SCPROP.attrName = 'Enable Snap Backups' AND CAST(attrVal AS INT) = 1

	IF	@inArchGroupCopyId <> 0
		AND @outBkpLevel <> 1 -- FULL
		AND ( @appType IN (13 /*NETAPP*/, 88 /*CENTERA*/, 106 /*VIRTUAL_SERVER_IDA*/) )
			  --OR @appType IN (SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35, 0)) -- APPGRP_FileSystemIDA
		AND EXISTS (SELECT 1
					FROM archGroupCopy AGC WITH (NOLOCK)
					INNER JOIN archGroup AG WITH (NOLOCK) ON AGC.archGroupId = AG.id
					WHERE AGC.isSnapCopy = 1
					AND AG.flags & 32768 = 32768 -- CVA_SP_CONSIDER_INCR_SNAPS_AS_FULL_FLAG
					AND AGC.id = @inArchGroupCopyId)
	BEGIN
		SET @outBkpLevel = 1 --FULL
	END

	RETURN ISNULL(@outBkpLevel, 0)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetBkpLevelForSnapCopy]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetBkpLevelForSnapCopy' AND revision = '')

  insert into GXDBVersions values(5, 'GetBkpLevelForSnapCopy',  '', 'GetBkpLevelForSnapCopy', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
