

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetBillableInformation.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetBillableInformation'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetBillableInformation]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetBillableInformation]
  delete from GXDBVersions where name = 'GetBillableInformation' and type = 5
END
GO

	CREATE FUNCTION GetBillableInformation
	(
	@clientId int,
	@appTypeId int,
	@instId int,
	@backupSetId int,
	@appId int
	)
    RETURNS
	@billableInformation table
	(
	instanceID INT,
	isQnetReg INT,
	assocEntityID	INT,
	assocLevel INT,
	assocDisplayName NVARCHAR(MAX))
     AS
	BEGIN
	DECLARE @QnetRegStatus INT
	DECLARE @r_tmpAssocEntityID INT
	DECLARE @r_tmpAssocLevel	INT
	DECLARE @r_appId	INT
	DECLARE @r_AssocEntityID INT
	DECLARE @r_AssocLevel	INT
	DECLARE @r_AssocDisplayName	NVARCHAR(MAX)
	IF (EXISTS (SELECT * FROM QNetReg WHERE RegStatus = 1))
	BEGIN
	SET @QnetRegStatus = 1
	INSERT INTO @billableInformation(instanceID) VALUES (@instId)
		UPDATE @billableInformation  SET isQnetReg = @QnetRegStatus WHERE instanceID = @instId
	END
	IF 	@QnetRegStatus = 1
	BEGIN
		SELECT @r_tmpAssocEntityID = EntityID, @r_tmpAssocLevel = AssocType
		FROM BLEntityMembers
		WHERE ClientID IN (@clientID, 0)
		AND AppTypeID IN (@appTypeID, 0)
		AND InstanceID IN (@instId, 0)
		AND BackupSetID IN (@backupSetId,0)
		AND AppID IN (@appId,0)
		SELECT @r_AssocEntityID = BLE.EntityID,
		@r_AssocDisplayName = (SELECT (CASE WHEN (BLE.QNetDisplayName IS null) THEN BLE.DisplayName ELSE BLE.QNetDisplayName + '/' + BLE.DisplayName END)),
		@r_AssocLevel = (SELECT AssocLevel = (CASE WHEN @r_tmpAssocLevel IS null THEN 0
				ELSE @r_tmpAssocLevel
				END)
			)
		FROM BLEntity BLE
		WHERE EntityID = (SELECT EntityID = (CASE WHEN @r_tmpAssocEntityID IS null THEN 1
				ELSE @r_tmpAssocEntityID
				END))
		UPDATE  @billableInformation SET assocEntityID =@r_AssocEntityID ,assocLevel = @r_AssocLevel ,assocDisplayName = @r_AssocDisplayName WHERE instanceID = @instId
	END
	RETURN
    END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetBillableInformation]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetBillableInformation' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetBillableInformation',  '1.2', 'GetBillableInformation', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
