

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetAutoSizeStr.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAutoSizeStr'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAutoSizeStr]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAutoSizeStr]
  delete from GXDBVersions where name = 'GetAutoSizeStr' and type = 5
END
GO

	CREATE FUNCTION GetAutoSizeStr(@size bigint)
	RETURNS VARCHAR(128)
	-- WITH ENCRYPTION
	AS
	BEGIN
    DECLARE @outStr VARCHAR(128)
    DECLARE @Bytes  float = cast( @size as float)
 	SELECT @outStr =
	CASE
	     WHEN @Bytes < 1024 THEN CAST(@Bytes as VARCHAR(100)) + ' Bytes'
   	     WHEN @Bytes < 1048576 THEN CAST(ROUND((@Bytes/1024),2) as VARCHAR(100))+' KB'
	     WHEN @Bytes < 1073741824 THEN CAST(ROUND((@Bytes/1048576),2) as VARCHAR(100)) + ' MB'
	     WHEN @Bytes < 1099511627776 THEN CAST(ROUND((@Bytes/1073741824),2) as VARCHAR(100)) + ' GB'
   	     WHEN @Bytes < 1125899906842624 THEN CAST(ROUND((@Bytes/1099511627776),2) as VARCHAR(100)) + ' TB'
         WHEN @Bytes < 1152921504606846976 THEN CAST(ROUND((@Bytes/1125899906842624),2) as VARCHAR(100)) + ' PB'
	END
    RETURN @outStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAutoSizeStr]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAutoSizeStr' AND revision = '1.1.202.1')

  insert into GXDBVersions values(5, 'GetAutoSizeStr',  '1.1.202.1', 'GetAutoSizeStr', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
