

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetAssociatedEvents.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAssociatedEvents'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAssociatedEvents]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAssociatedEvents]
  delete from GXDBVersions where name = 'GetAssociatedEvents' and type = 5
END
GO

	CREATE FUNCTION GetAssociatedEvents(@jobId INTEGER, @ccId INTEGER, @locId INTEGER)
	RETURNS NVARCHAR(MAX)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @id INTEGER
		DECLARE @client VARCHAR(512)
		DECLARE @subsys VARCHAR(512)
		DECLARE @timeSrc INTEGER
		DECLARE @MsgText NVARCHAR(MAX)
		DECLARE @returnText NVARCHAR(MAX)
		SET @returnText = ''

		DECLARE evCur CURSOR FOR
		SELECT  E.id, E.client, E.subsystem, E.timeSource, ISNULL(C.Message, ISNULL(dbo.fn_EvFormatEventMsgText(E.id, @locId, E.messageId, 1, @ccid), '')) AS MsgText
		FROM    evMsg E LEFT OUTER JOIN EvMsgCache C ON C.evMsgId = E.id AND C.commcellId = E.commCellID
		WHERE   e.commCellID = @ccId AND E.jobId_l = @jobId

		OPEN evCur
		FETCH NEXT FROM evCur INTO @id, @client, @subsys, @timeSrc, @MsgText
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @returnText = @returnText + '\n'
			SET @returnText = @returnText + CAST(@id AS NVARCHAR(10))
			SET @returnText = @returnText + ' [' + @client + '/' + @subsys + '] '
			SET @returnText = @returnText + (CASE WHEN @timeSrc > 0 THEN ' [' + CAST(dbo.GetDateTime(@timeSrc) AS NVARCHAR(64)) + '] ' ELSE '' END) + ':'
			SET @returnText = @returnText + @MsgText
			FETCH NEXT FROM evCur INTO @id, @client, @subsys, @timeSrc, @MsgText
		END
		CLOSE evCur
		DEALLOCATE evCur
		RETURN @returnText

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAssociatedEvents]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAssociatedEvents' AND revision = '1.2.200.1')

  insert into GXDBVersions values(5, 'GetAssociatedEvents',  '1.2.200.1', 'GetAssociatedEvents', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
