

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetAppTypesList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAppTypesList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAppTypesList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAppTypesList]
  delete from GXDBVersions where name = 'GetAppTypesList' and type = 5
END
GO

		CREATE FUNCTION GetAppTypesList ( @commCellName VARCHAR(MAX) )
		RETURNS @AppTypesList TABLE ( clientName VARCHAR(MAX), appType INTEGER )
		AS
		BEGIN
		INSERT INTO @AppTypesList
		(
			clientName, appType
		)
		SELECT map.exMachineName, ida_type.type
		FROM
		APP_Client c, LicUsage lic, CommServ_Capture..CCM_edcClientNameMap map, APP_iDAType ida_type
		WHERE
			c.name = map.gxMachineName AND
			map.exServerAliasName = @commCellName AND
			lic.CId = c.id AND
			ida_type.type = lic.AppType

		INSERT INTO @AppTypesList
		(
			clientName, appType
		)
		SELECT map.exMachineName, ida_type.type
		FROM
		APP_Client c, LicUsage lic, edcClientNameMap map, APP_iDAType ida_type
		WHERE
			c.name = map.gxMachineName AND
			map.exServerAliasName = @commCellName AND
			lic.CId = c.id AND
			ida_type.type = lic.AppType
		INSERT INTO @AppTypesList
		(
			clientName, appType
		)
		SELECT clientName, ida.ccpType
		FROM @AppTypesList list, App_iDAType ida
		WHERE
		list.appType = ida.type
		AND list.appType <> ida.ccpType
		AND ida.ccpType <> 0
		RETURN;
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAppTypesList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAppTypesList' AND revision = '')

  insert into GXDBVersions values(5, 'GetAppTypesList',  '', 'GetAppTypesList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
