

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetAnalyticsStaticCores.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAnalyticsStaticCores'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAnalyticsStaticCores]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAnalyticsStaticCores]
  delete from GXDBVersions where name = 'GetAnalyticsStaticCores' and type = 5
END
GO

	CREATE FUNCTION GetAnalyticsStaticCores ( @l_roleName VARCHAR(256),@l_cloudId INT = 0 )
	RETURNS @CoresList TABLE ( coreName VARCHAR(256), indexServerClientId INTEGER, roleName VARCHAR(256) )
	AS
	BEGIN
		DECLARE @l_indexServerClientId INT = (select TOP 1 ClientId from DM2SearchServerCoreInfo WITH(NOLOCK) where CloudId = @l_cloudId AND (CoreRoles & 128) > 0);
		DECLARE @l_serverType  INT = (select CloudType from DM2Cloud WITH(NOLOCK) where cloudId = @l_cloudId);
		DECLARE @i int = 0;
		DECLARE @coreNumEnd int = 0;
		DECLARE @l_corePrefix VARCHAR(256) = ''
		DECLARE @DataAnalyticsRole varchar(256) = 'Data Analytics'
		DECLARE @DownloadCenterRole varchar(256) = 'Download Center'
		DECLARE @LogMonitoringRole  varchar(256) = 'Log Monitoring'
		DECLARE @EDGEDriveRole varchar(256) = 'EDGE Drive'
		DECLARE @ReviewSetRole varchar(256) = 'Review Set'
		DECLARE @WebAnalyticsRole varchar(256) = 'Web Analytics'
		DECLARE @ExchangeIndexRole varchar(256) = 'Exchange Index'
		DECLARE @SystemRole	varchar(256) = 'System Default'
		IF @l_serverType = 1 OR @l_cloudId = 0
		BEGIN
		IF @l_roleName = @DataAnalyticsRole OR @l_roleName = ''
		BEGIN
		SET @coreNumEnd = 7
		WHILE @i <= @coreNumEnd
		BEGIN
		SET @l_corePrefix = CONCAT('cvcorefla',@i)
		INSERT INTO @CoresList (
						coreName, indexServerClientId, roleName
					) select @l_corePrefix,@l_indexServerClientId,@DataAnalyticsRole
					SET @i = @i + 1
					END
		SET @coreNumEnd = 3
		SET @i = 0
		WHILE @i <= @coreNumEnd
		BEGIN
		SET @l_corePrefix = CONCAT('cvcoreaudit',@i)
		INSERT INTO @CoresList (
						coreName, indexServerClientId, roleName
					) select @l_corePrefix,@l_indexServerClientId, @DataAnalyticsRole
					SET @i = @i + 1
					END
					INSERT INTO @CoresList(
						coreName, indexServerClientId) select ActualCoreName,ClientId from SECollectionInfo where  ActualCoreName collate SQL_Latin1_General_CP1_CS_AS like '%DC_%' AND CloudID = @l_cloudId  AND ClientId <> 0
			END
		IF @l_roleName = @DownloadCenterRole OR @l_roleName = ''
			BEGIN
					SET @i = 0
					INSERT INTO @CoresList (
						coreName, indexServerClientId, roleName
					) select 'downloadcenterdata',@l_indexServerClientId,@DownloadCenterRole
					INSERT INTO @CoresList (
						coreName, indexServerClientId, roleName
					) select 'downloadcenterreadme',@l_indexServerClientId,@DownloadCenterRole
					INSERT INTO @CoresList (
						coreName, indexServerClientId, roleName
					) select 'downloadcenteraudit',@l_indexServerClientId,@DownloadCenterRole
			END
		IF @l_roleName = @LogMonitoringRole OR @l_roleName = ''
			BEGIN
					SET @i = 0
					SET @coreNumEnd = 3
					WHILE @i <= @coreNumEnd
					BEGIN
						SET @l_corePrefix = CONCAT('cvcorelm',@i)
						INSERT INTO @CoresList (
							coreName, indexServerClientId,roleName
						) select @l_corePrefix,@l_indexServerClientId,@LogMonitoringRole
						SET @i = @i + 1
					END
			END
		IF @l_roleName = @EDGEDriveRole OR @l_roleName = ''
			BEGIN
					SET @i = 0
					SET @coreNumEnd = 7
					WHILE @i <= @coreNumEnd
					BEGIN
						SET @l_corePrefix = CONCAT('edge',@i)
						INSERT INTO @CoresList (
							coreName, indexServerClientId, roleName
						) select @l_corePrefix,@l_indexServerClientId,@EDGEDriveRole
						SET @l_corePrefix = CONCAT('version',@i)
						INSERT INTO @CoresList (
							coreName, indexServerClientId, roleName
						) select @l_corePrefix,@l_indexServerClientId,@EDGEDriveRole
					SET @i = @i + 1
					END
			END
		IF @l_roleName = @ReviewSetRole OR @l_roleName = ''
			BEGIN
						SET @i = 0
						SET @l_corePrefix = 'myreviewsets'
						INSERT INTO @CoresList (
							coreName, indexServerClientId, roleName
						) select @l_corePrefix,@l_indexServerClientId, @ReviewSetRole
						INSERT INTO @CoresList (
							coreName, indexServerClientId, roleName
						) select concat('rscore',dmc.containerId),dms.ClientId, @ReviewSetRole from dm2container dmc inner join DM2SearchServerCoreInfo dms on dmc.cloudId = dms.cloudId where dmc.containerType = 9501 and dmc.cloudId = @l_cloudId
			END
		IF @l_roleName = @WebAnalyticsRole OR @l_roleName = ''
			BEGIN
						SET @i = 0
						SET @l_corePrefix = 'webanalytics'
						INSERT INTO @CoresList (
							coreName, indexServerClientId, roleName
						) select @l_corePrefix,@l_indexServerClientId,@WebAnalyticsRole
						INSERT INTO @CoresList (
							coreName, indexServerClientId, roleName
						) select war.SiteGuid,dms.ClientId,@WebAnalyticsRole from WARegisteredSite war inner join Dm2searchservercoreinfo dms on war.CloudId = dms.CloudId where war.CloudId = @l_cloudId
			END
		IF @l_roleName = @ExchangeIndexRole OR @l_roleName = ''
			BEGIN
				SET @i = 0
				SET @coreNumEnd = 7
				WHILE @i <= @coreNumEnd
				BEGIN
					SET @l_corePrefix = CONCAT('usermbx',@i)
					INSERT INTO @CoresList (
						coreName, indexServerClientId, roleName
					) select @l_corePrefix,@l_indexServerClientId,@ExchangeIndexRole
					SET @i = @i + 1
				END
				SET @l_corePrefix = 'journalmbx'
				INSERT INTO @CoresList (
					coreName, indexServerClientId, roleName
				) select @l_corePrefix,@l_indexServerClientId,@ExchangeIndexRole
			END
		IF @l_roleName = @SystemRole
			BEGIN
				INSERT INTO @CoresList (
					coreName, indexServerClientId, roleName
				)
				SELECT 'cvemptyshard', DMC.ClientId, @SystemRole from DM2SearchServerCoreInfo DMC where DMC.CloudId=@l_cloudId or @l_cloudId = 0
				UNION
				SELECT 'datasourceinfo',DMC.ClientId, @SystemRole from DM2SearchServerCoreInfo DMC where DMC.CloudId=@l_cloudId or @l_cloudId = 0
				UNION
				SELECT 'indexserverinfo',DMC.ClientId, @SystemRole from DM2SearchServerCoreInfo DMC where DMC.CloudId=@l_cloudId or @l_cloudId = 0
				UNION
				SELECT 'complianceaudit',DMC.ClientId, @SystemRole from DM2SearchServerCoreInfo DMC where DMC.CloudId=@l_cloudId or @l_cloudId = 0
			END
			--
			-- merge causes error when a target row matches more than one source row, use update statement instead..
			-- Also if cloudid input is given, make sure it is considered when matching rows of SECollectionInfo
			--
			UPDATE C
			SET indexServerClientId = S.ClientId
			FROM @CoresList C
			JOIN SECollectionInfo S WITH(NOLOCK) ON C.coreName = S.ActualCoreName
			WHERE ISNULL(indexServerClientId, 0) = 0 AND (@l_cloudId = 0 OR S.CloudID = @l_cloudId)
		END
		RETURN;
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAnalyticsStaticCores]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAnalyticsStaticCores' AND revision = '')

  insert into GXDBVersions values(5, 'GetAnalyticsStaticCores',  '', 'GetAnalyticsStaticCores', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
