

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetAllJobOptions.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAllJobOptions'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAllJobOptions]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAllJobOptions]
  delete from GXDBVersions where name = 'GetAllJobOptions' and type = 5
END
GO

	CREATE FUNCTION GetAllJobOptions(@jobId bigint)
	RETURNS
	@listTbl table (optionId bigint, value NVARCHAR(MAX), type INT)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @refTime	INT
		SELECT TOP 1 @taskId=taskId, @subTaskId=subTaskId, @refTime=created FROM TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WITH (READUNCOMMITTED) WHERE jobId=@jobId)
		--Get the list of option values from the TM_JobOptions table
		INSERT INTO @listTbl
		SELECT DISTINCT optionId, value, type FROM TM_JobOptions WITH (READUNCOMMITTED) WHERE (jobId=@jobId)
		UNION ALL
		SELECT DISTINCT optionId, value, type FROM TM_JobOptions AS TJ WITH (READUNCOMMITTED) WHERE (
				(jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime))
			) AND
			NOT EXISTS(SELECT * FROM TM_JobOptions AS LT WITH (READUNCOMMITTED) WHERE (jobId=@jobId) AND LT.optionId = TJ.optionId)
		RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAllJobOptions]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAllJobOptions' AND revision = '1.12.200.1')

  insert into GXDBVersions values(5, 'GetAllJobOptions',  '1.12.200.1', 'GetAllJobOptions', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
