

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetAWSKeyForUser.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAWSKeyForUser'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAWSKeyForUser]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAWSKeyForUser]
  delete from GXDBVersions where name = 'GetAWSKeyForUser' and type = 5
END
GO

	CREATE FUNCTION GetAWSKeyForUser(@userName 	nvarchar(255))
	RETURNS VARCHAR(400)
	-- WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @subclientId int
		DECLARE @ReturnVal VARCHAR(400)
		--
		SELECT @subclientId = dbo.GetEdgeDriveSubClientId(@userName)
		--
		IF @subclientId IS NOT NULL
		BEGIN
			SELECT @ReturnVal = attrVal FROM APP_SubClientProp WITH(NOLOCK)
			WHERE attrName =  'S3_SECURITY_KEY' AND modified = 0 AND componentNameId = @subclientId
		END
		--
		RETURN @ReturnVal
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAWSKeyForUser]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAWSKeyForUser' AND revision = '1.1.4.5')

  insert into GXDBVersions values(5, 'GetAWSKeyForUser',  '1.1.4.5', 'GetAWSKeyForUser', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
