

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GenerateHostName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GenerateHostName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GenerateHostName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GenerateHostName]
  delete from GXDBVersions where name = 'GenerateHostName' and type = 5
END
GO

	create function GenerateHostName(
	@name as nvarchar(255),
	@hostname as nvarchar(1024),
		@guid as nvarchar(1024),
		@instancetype as int = 0)
	returns
	int
	AS
	BEGIN
		declare @ret as nvarchar(255)
		declare @queryStr nvarchar(255)
		declare @currentHostName nvarchar(255)
		declare @lastName nvarchar(255)
		declare @lastNumber int
		declare @patIndex int
		set @lastNumber = -1
		declare appclients cursor for
			select cl.net_hostname from APP_Client cl where  CAST(GUID AS NVARCHAR(1024)) = @guid ORDER BY net_hostname
		open appclients
		fetch next from appclients into @currentHostName
		WHILE @@FETCH_STATUS = 0
		begin
			if @currentHostName = @hostname
			begin
				set @lastNumber = 0;
			end
			else
			begin
				set @patIndex = -1
				set @patIndex = patindex(@hostname + '[_]%', @currentHostName)
				if @patIndex != 0
				begin
					declare @startIndex int
					set @startIndex = len(@hostname + '_')
					set @lastName = substring(@currentHostName, @startIndex + 1, len(@currentHostName) - @startIndex)
					if isnumeric(@lastName+'.0e0') = 1 and LEN(@lastName) <= 9
					begin
						set @lastNumber = convert(integer, @lastName)
					end
				end
			end
		fetch next from appclients into @currentHostName
		end
		close  appclients
		deallocate  appclients
		if @lastNumber <> -1
			return @lastNumber
		IF NOT EXISTS	(select * from APP_Client WITH (NOLOCK) where net_hostname = @hostname)
		BEGIN
			SET @lastNumber=0
			return @lastNumber
		END
		DECLARE @nintMaxNum int
		SET @nintMaxNum=2147483647
		SET @lastNumber=1
		WHILE @lastNumber <= @nintMaxNum
		begin

		IF NOT EXISTS	(select * from APP_Client WITH (NOLOCK) where net_hostname = @hostname + '_' + convert(varchar,@lastNumber))
			return @lastNumber

		SET @lastNumber=@lastNumber+1
		end
		return @lastNumber
	End



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GenerateHostName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GenerateHostName' AND revision = '1.10.2.1')

  insert into GXDBVersions values(5, 'GenerateHostName',  '1.10.2.1', 'GenerateHostName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
