

--  ------------  Generated from [../../../Source/CommServer/Db/Function/GenerateClientName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GenerateClientName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GenerateClientName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GenerateClientName]
  delete from GXDBVersions where name = 'GenerateClientName' and type = 5
END
GO

	create function GenerateClientName(
	@name as nvarchar(255),
	@hostname as nvarchar(1024),
		@vmguid as nvarchar(1024),
		@instanceguid as nvarchar(1024),
		@instancetype as int = 0 )
	returns
	int
	AS
	BEGIN
		declare @ret as nvarchar(255)
		declare @queryStr nvarchar(255)
		declare @currentName nvarchar(255)
		declare @lastName nvarchar(255)
		declare @lastNumber int
		declare @patIndex int
		set @lastNumber = -1
		if(@instancetype != 8)
		BEGIN
		    IF EXISTS ( SELECT name from GXGlobalParam where name ='VirtualMachineClientUseInstanceGUID' and value = '1' and modified =0 )
		    BEGIN
		     declare appclients cursor for
			 select name from APP_Client where name like @name + '%' and CAST(GUID AS NVARCHAR(1024))= (case when @instanceguid is null then @vmguid	else @instanceguid end) order by name
		    END
		    ELSE
		    BEGIN
		     declare appclients cursor for
			 select name from APP_Client where name like @name + '%' and CAST(GUID AS NVARCHAR(1024))= @vmguid order by name
		    END
		open appclients
		fetch next from appclients into @currentName
		WHILE @@FETCH_STATUS = 0
		begin
			if @currentName = @name
			begin
				set @lastNumber = 0;
			end
			else
			begin
				set @patIndex = -1
				set @patIndex = patindex(@name + '[_]%', @currentName)
				if @patIndex != 0
				begin
					declare @startIndex int
					set @startIndex = len(@name + '_')
					set @lastName = substring(@currentName, @startIndex + 1, len(@currentName) - @startIndex)
					if isnumeric(@lastName+'.0e0') = 1 and LEN(@lastName) <= 9
					begin
						set @lastNumber = convert(integer, @lastName)
					end
				end
			end
		fetch next from appclients into @currentName
		end
		close  appclients
		deallocate  appclients
		IF @instanceguid IS NOT NULL
		declare appclients cursor for
			select C.name from APP_Client C
							INNER JOIN APP_ClientProp CP
							ON C.id = CP.componentNameId
							AND CP.attrName = 'Virtual Machine Instance UUID' AND CP.modified=0
							where C.name like @name + '%' AND CP.attrVal = @instanceguid order by C.name
		ELSE
		declare appclients cursor for
			select C.name from APP_Client C
							INNER JOIN APP_ClientProp CP
							ON C.id = CP.componentNameId
							AND CP.attrName = 'Virtual Machine GUID'
							where C.name like @name + '%' AND CP.attrVal = @vmguid order by C.name
		open appclients
		fetch next from appclients into @currentName
		WHILE @@FETCH_STATUS = 0
		begin
			if @currentName = @name
			begin
				set @lastNumber = 0;
			end
			else
			begin
				set @patIndex = -1
				set @patIndex = patindex(@name + '[_]%', @currentName)
				if @patIndex != 0
				begin
					set @startIndex = len(@name + '_')
					set @lastName = substring(@currentName, @startIndex + 1, len(@currentName) - @startIndex)
					if isnumeric(@lastName+'.0e0') = 1 and LEN(@lastName) <= 9
					begin
						set @lastNumber = convert(integer, @lastName)
					end
				end
			end
		fetch next from appclients into @currentName
		end
		close  appclients
		deallocate  appclients
			END
		if @lastNumber <> -1
			return @lastNumber;
		IF NOT EXISTS	(select * from APP_Client WITH (NOLOCK) where name = @name )
		BEGIN
			SET @lastNumber=0
			return @lastNumber
		END
		DECLARE @nintMaxNum int
		SET @nintMaxNum=2147483647
		SET @lastNumber=1
		WHILE @lastNumber <= @nintMaxNum
		begin

		IF NOT EXISTS	(select * from APP_Client WITH (NOLOCK) where name = @name + '_' + convert(varchar,@lastNumber))
			return @lastNumber

		SET @lastNumber=@lastNumber+1
		end
		return @lastNumber
	End


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GenerateClientName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GenerateClientName' AND revision = '1.15.2.3')

  insert into GXDBVersions values(5, 'GenerateClientName',  '1.15.2.3', 'GenerateClientName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
