SET QUOTED_IDENTIFIER OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetHourStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetHourStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetHourStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetHourStart]
  delete from GXDBVersions where name = 'GetHourStart' and type = 5
END
GO

	CREATE FUNCTION GetHourStart (@DateArg DATETIME)
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @DiffSeconds int
		SET @DiffSeconds = datepart(minute, @DateArg) * 60
					+ datepart(second, @DateArg)
		RETURN dateadd(second, (dbo.GetUnixTime(@DateArg) - @DiffSeconds), '01/01/1970')
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetHourStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetHourStart' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetHourStart',  '1.3', 'GetHourStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDayStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDayStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDayStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDayStart]
  delete from GXDBVersions where name = 'GetDayStart' and type = 5
END
GO

	CREATE FUNCTION GetDayStart (@DateArg DATETIME, @DayStartOffset int)
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @DiffSeconds int
		SET @DiffSeconds = datepart(hour, @DateArg) * 3600
					+ datepart(minute, @DateArg) * 60
					+ datepart(second, @DateArg)
		SET @DiffSeconds = @DiffSeconds - @DayStartOffset
		RETURN dateadd(second, dbo.GetUnixTime(@DateArg) - @DiffSeconds, '01/01/1970')
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDayStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDayStart' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetDayStart',  '1.3', 'GetDayStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetWeekStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetWeekStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetWeekStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetWeekStart]
  delete from GXDBVersions where name = 'GetWeekStart' and type = 5
END
GO

	CREATE FUNCTION GetWeekStart (@DateArg DATETIME, @DayStartOffset int)
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE	@CurrentTime	DATETIME
		SET @CurrentTime = DATEADD(second, -@DayStartOffset, @DateArg)
		DECLARE @wkDay integer
		SET @wkDay = (SELECT CASE DATEPART(WEEKDAY, @CurrentTime)
				WHEN 1 THEN 8
				ELSE datepart(WEEKDAY, @CurrentTime)
				END )
		RETURN dbo.GetDateTime(dbo.GetUnixTime(dbo.GetDayStart(@CurrentTime, @DayStartOffset)) - ((@wkDay - 2) * 3600 * 24))
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetWeekStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetWeekStart' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetWeekStart',  '1.2', 'GetWeekStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetMonthStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetMonthStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetMonthStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetMonthStart]
  delete from GXDBVersions where name = 'GetMonthStart' and type = 5
END
GO

	CREATE FUNCTION GetMonthStart (@DateArg DATETIME, @DayStartOffset int)
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @MonthDate DATETIME
		SET @MonthDate = CAST( datename(month, @DateArg) + ' 1 ' + datename(year, @DateArg) AS DATETIME )
		SET @MonthDate = dbo.GetDateTime(dbo.GetUnixTime(@MonthDate) + @DayStartOffset )
		RETURN @MonthDate
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetMonthStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetMonthStart' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetMonthStart',  '1.2', 'GetMonthStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDateTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDateTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDateTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDateTime]
  delete from GXDBVersions where name = 'GetDateTime' and type = 5
END
GO

CREATE FUNCTION GetDateTime (@UnixTimeArg integer)
RETURNS DATETIME
WITH ENCRYPTION
AS
BEGIN
return dateadd(second, @UnixTimeArg, '01/01/1970')
END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDateTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDateTime' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetDateTime',  '1.4', 'GetDateTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetUnixTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetUnixTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetUnixTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetUnixTime]
  delete from GXDBVersions where name = 'GetUnixTime' and type = 5
END
GO

	CREATE FUNCTION GetUnixTime (@DateTimeArg datetime)
	RETURNS INT
	WITH ENCRYPTION
	AS
	BEGIN
    DECLARE @dateTimeBase DATETIME
    DECLARE @unixtime int
    set @dateTimeBase = '01/01/1970'
	if (@DateTimeArg < @dateTimeBase)
	  set @unixtime = 0
	ELSE
	  set @unixtime =  datediff(second, '01/01/1970', @DateTimeArg)
	return @unixtime
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetUnixTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetUnixTime' AND revision = '1.5')

  insert into GXDBVersions values(5, 'GetUnixTime',  '1.5', 'GetUnixTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetYearStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetYearStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetYearStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetYearStart]
  delete from GXDBVersions where name = 'GetYearStart' and type = 5
END
GO

	CREATE FUNCTION GetYearStart (@DateArg DATETIME, @DayStartOffset int)
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @YearDate DATETIME
		SET @YearDate = CAST( '1/1/' + datename(year, @DateArg) AS DATETIME )
		SET @YearDate = dbo.GetDateTime(dbo.GetUnixTime(@YearDate) + @DayStartOffset )
		RETURN @YearDate
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetYearStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetYearStart' AND revision = '')

  insert into GXDBVersions values(5, 'GetYearStart',  '', 'GetYearStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/UTCToLocalTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: UTCToLocalTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UTCToLocalTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[UTCToLocalTime]
  delete from GXDBVersions where name = 'UTCToLocalTime' and type = 5
END
GO

	CREATE FUNCTION UTCToLocalTime(@UTCTime DATETIME, @timeZoneName VARCHAR(255))
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
		RETURN dbo.UTCToLocalDateTimeConversionManaged(@UTCTime, @timeZoneName)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [UTCToLocalTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'UTCToLocalTime' AND revision = '1.4')

  insert into GXDBVersions values(5, 'UTCToLocalTime',  '1.4', 'UTCToLocalTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/UTCToLocalStringTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: UTCToLocalStringTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UTCToLocalStringTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[UTCToLocalStringTime]
  delete from GXDBVersions where name = 'UTCToLocalStringTime' and type = 5
END
GO

	CREATE FUNCTION UTCToLocalStringTime(@UTCTime DATETIME, @timeZoneName VARCHAR(255))
	RETURNS VARCHAR(20)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @LocalTime	DATETIME
		SET @LocalTime = dbo.UTCToLocalTime(@UTCTime, @timeZoneName)
		RETURN CONVERT(VARCHAR(10), @LocalTime, 101) + ' ' + CONVERT(VARCHAR(8), @LocalTime, 108)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [UTCToLocalStringTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'UTCToLocalStringTime' AND revision = '1.1')

  insert into GXDBVersions values(5, 'UTCToLocalStringTime',  '1.1', 'UTCToLocalStringTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/LocalToUTCTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: LocalToUTCTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LocalToUTCTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[LocalToUTCTime]
  delete from GXDBVersions where name = 'LocalToUTCTime' and type = 5
END
GO

	CREATE FUNCTION LocalToUTCTime(@LocalTime DATETIME, @timeZoneName VARCHAR(255))
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
		RETURN dbo.LocalToUTCDateTimeConversionManaged(@LocalTime, @timeZoneName)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [LocalToUTCTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'LocalToUTCTime' AND revision = '1.4')

  insert into GXDBVersions values(5, 'LocalToUTCTime',  '1.4', 'LocalToUTCTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/UTCToClientLocalTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: UTCToClientLocalTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UTCToClientLocalTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[UTCToClientLocalTime]
  delete from GXDBVersions where name = 'UTCToClientLocalTime' and type = 5
END
GO

	CREATE FUNCTION UTCToClientLocalTime(@UTCTime DATETIME, @ChildID integer)
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @LocalTime	DateTime
		DECLARE @DSTFlag	integer
		DECLARE @Bias		integer
		DECLARE @STDBias	integer
		DECLARE @DSTBias	integer
		DECLARE @STDDate	DATETIME
		DECLARE @DSTDate	DATETIME
		DECLARE @CurrentYear	integer
		--Get the timezone info from the APP_Client table
		DECLARE @attrv varchar(255)
		DECLARE @timeZoneName varchar(255)
		DECLARE @count int
		DECLARE @CHAR int
		DECLARE @position int
		DECLARE @length int
		select @attrv = TimeZoneStdName From SchedTimeZone(NOLOCK) where TimeZoneID = ISNULL((select TOP 1 CAST(attrVal as int) from APP_ClientProp(NOLOCK) where componentNameId = @ChildID and attrName = 'timezone Id' and modified = 0), 0)
		IF (@attrv IS NULL)
		BEGIN
		BEGIN
			select @attrv = attrVal  from APP_ClientProp WITH (READUNCOMMITTED) where componentNameId = @ChildID AND attrName = 'timezone' AND modified = 0
		END
		IF (@attrv IS NULL)
		BEGIN
			select @attrv = attrVal  from APP_ClientProp WITH (READUNCOMMITTED) where componentNameId = 2 AND attrName = 'timezone' AND modified = 0
		END
		SET @CHAR = 1
		SET @count = 1
		SET @length = DATALENGTH(@attrv)
		SET @position = @length
		WHILE (@position > 0 AND  @CHAR <> 58)
			BEGIN
			SET @CHAR = ASCII(SUBSTRING(@attrv, @position, 1))
			SET @position = @position - 1
		END
		SET @timeZoneName =  RIGHT(@attrv,@length - @position-1)
		END
		ELSE
			SET @timeZoneName = @attrv
		SET @LocalTime = dbo.UTCToLocalTime(@UTCTime , @timeZoneName)
		RETURN @LocalTime
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [UTCToClientLocalTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'UTCToClientLocalTime' AND revision = '1.6')

  insert into GXDBVersions values(5, 'UTCToClientLocalTime',  '1.6', 'UTCToClientLocalTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/CellLocalToUTCTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: CellLocalToUTCTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CellLocalToUTCTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[CellLocalToUTCTime]
  delete from GXDBVersions where name = 'CellLocalToUTCTime' and type = 5
END
GO

	CREATE FUNCTION CellLocalToUTCTime(@LocalTime DATETIME, @commCellId INT)
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @commCellTimeZoneName nvarchar(255) = ( SELECT  timeZone
		                                                FROM    APP_CommCell
		                                                WHERE   id = @commCellId)
		SELECT  @commCellTimeZoneName = TimeZoneStdName
		FROM    SchedTimeZone
		WHERE   TimeZoneName = SUBSTRING(@commCellTimeZoneName, CHARINDEX(':', @commCellTimeZoneName, CHARINDEX(':', @commCellTimeZoneName, 0) + 1) + 1, 255)
		RETURN dbo.LocalToUTCDateTimeConversionManaged(@LocalTime, @commCellTimeZoneName)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [CellLocalToUTCTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'CellLocalToUTCTime' AND revision = '1.2')

  insert into GXDBVersions values(5, 'CellLocalToUTCTime',  '1.2', 'CellLocalToUTCTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/UTCToCellLocalTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: UTCToCellLocalTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[UTCToCellLocalTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[UTCToCellLocalTime]
  delete from GXDBVersions where name = 'UTCToCellLocalTime' and type = 5
END
GO

	CREATE FUNCTION UTCToCellLocalTime(@UTCTime DATETIME, @commCellId INT)
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @commCellTimeZoneName nvarchar(255) = ( SELECT  timeZone
		                                                FROM    APP_CommCell
		                                                WHERE   id = @commCellId)
		SELECT  @commCellTimeZoneName = TimeZoneStdName
		FROM    SchedTimeZone
		WHERE   TimeZoneName = SUBSTRING(@commCellTimeZoneName, CHARINDEX(':', @commCellTimeZoneName, CHARINDEX(':', @commCellTimeZoneName, 0) + 1) + 1, 255)
		RETURN dbo.UTCToLocalDateTimeConversionManaged(@UTCTime, @commCellTimeZoneName)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [UTCToCellLocalTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'UTCToCellLocalTime' AND revision = '1.2')

  insert into GXDBVersions values(5, 'UTCToCellLocalTime',  '1.2', 'UTCToCellLocalTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/ClientLocalToUTCTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ClientLocalToUTCTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ClientLocalToUTCTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ClientLocalToUTCTime]
  delete from GXDBVersions where name = 'ClientLocalToUTCTime' and type = 5
END
GO

	CREATE FUNCTION ClientLocalToUTCTime(@LocalTime DATETIME, @ChildID integer)
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @UTCTime	DateTime
		DECLARE @DSTFlag	integer
		DECLARE @Bias		integer
		DECLARE @STDBias	integer
		DECLARE @DSTBias	integer
		DECLARE @STDDate	DATETIME
		DECLARE @DSTDate	DATETIME
		DECLARE @CurrentYear	integer
		--Get the timezone info from the APP_Client table
		DECLARE @attrv varchar(255)
		DECLARE @timeZoneName varchar(255)
		DECLARE @count int
		DECLARE @CHAR int
		DECLARE @position int
		DECLARE @length int
		BEGIN
			select @attrv = attrVal  from APP_ClientProp WITH (READUNCOMMITTED) where componentNameId = @ChildID AND attrName = 'timezone' AND modified = 0
		END
		SET @CHAR = 1
		SET @count = 1
		SET @length = DATALENGTH(@attrv)
		SET @position = @length
		WHILE (@position > 0 AND  @CHAR <> 58)
			BEGIN
			SET @CHAR = ASCII(SUBSTRING(@attrv, @position, 1))
			SET @position = @position - 1
		END
		SET @timeZoneName =  RIGHT(@attrv,@length - @position-1)
		SET @UTCTime = dbo.LocalToUTCTime(@LocalTime , @timeZoneName)
		RETURN @UTCTime
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ClientLocalToUTCTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ClientLocalToUTCTime' AND revision = '1.4')

  insert into GXDBVersions values(5, 'ClientLocalToUTCTime',  '1.4', 'ClientLocalToUTCTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetBigIntFromInt.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetBigIntFromInt'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetBigIntFromInt]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetBigIntFromInt]
  delete from GXDBVersions where name = 'GetBigIntFromInt' and type = 5
END
GO

	CREATE FUNCTION GetBigIntFromInt (@high integer, @low integer)
	RETURNS BIGINT
	WITH ENCRYPTION
	AS
	BEGIN
	 	return (convert(bigint,@high)*2147483648+convert(bigint,@low))
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetBigIntFromInt]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetBigIntFromInt' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetBigIntFromInt',  '1.1', 'GetBigIntFromInt', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/FixInstanceName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: FixInstanceName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[FixInstanceName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[FixInstanceName]
  delete from GXDBVersions where name = 'FixInstanceName' and type = 5
END
GO

	CREATE FUNCTION FixInstanceName (@InstanceName varchar(255), @AppTypeID int)
	RETURNS VARCHAR(255)
	WITH ENCRYPTION
	BEGIN
		RETURN	CASE WHEN @AppTypeID in (6, 7, 51, 52, 59, 60, 77, 90)
				THEN SUBSTRING(@InstanceName, 0, PATINDEX('%' + CHAR(0x12) + '%', @InstanceName))
					WHEN @AppTypeID in (65, 75, 76, 87)
				THEN SUBSTRING(@InstanceName, 0, PATINDEX(N'%' + NCHAR(0x13) + N'%', @InstanceName))
				ELSE @InstanceName
		   	END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [FixInstanceName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'FixInstanceName' AND revision = '1.2')

  insert into GXDBVersions values(5, 'FixInstanceName',  '1.2', 'FixInstanceName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/JMGetLocalizedMessageMaxFunc.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: JMGetLocalizedMessageMaxFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMGetLocalizedMessageMaxFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[JMGetLocalizedMessageMaxFunc]
  delete from GXDBVersions where name = 'JMGetLocalizedMessageMaxFunc' and type = 5
END
GO

	CREATE FUNCTION JMGetLocalizedMessageMaxFunc(@localeId integer, @inputMsgs varchar(256))
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @messages varchar(256)
		DECLARE @msgId varchar(40)
		DECLARE @endIndex integer
		DECLARE @startIndex integer
		DECLARE @EventId integer
		DECLARE @output nvarchar(MAX)
		DECLARE @MsgTxt nvarchar(MAX)
		DECLARE @subSystemName varchar(64)
		DECLARE @machineName varchar(64)
		SET @startIndex = 0
		SET @messages = @inputMsgs
		SET @output = N''
		SET @endIndex = CHARINDEX(',', @messages, @startIndex)
		IF (@endIndex is NULL OR @endIndex = 0)
		BEGIN
			SET @output = @messages
		END
		ELSE
		BEGIN
			WHILE(@endIndex IS NOT NULL AND @endIndex <> 0)
			BEGIN
				SET @EventId = 0
				SET @msgId = SUBSTRING(@messages,@startIndex,@endIndex-@startIndex)
				SELECT @EventId = messageId, @subSystemName = subsystem, @machineName = client  FROM JMFailureReasonMsg WITH (READUNCOMMITTED) WHERE id = @msgId
				if (@EventId IS NOT null AND @EventId <> 0)
				BEGIN
					SET @MsgTxt = DBO.JMFormatPendingMsgText( @msgId, @localeId, @EventId, 1)
					IF LEN(@machineName) <> 0
					BEGIN
						SET @MsgTxt = @MsgTxt + '<br>Source: ' + @machineName
						IF LEN(@subSystemName) <> 0
							SET @MsgTxt = @MsgTxt + ', Process: ' + @subSystemName
					END
					IF @MsgTxt IS NOT null
					BEGIN
						IF LEN(@output) <> 0 BEGIN
							SET @output = @output + NCHAR(10)
						END
						SET @MsgTxt = REPLACE(@MsgTxt, NCHAR(10), NCHAR(13))
						SET @output = @output + @MsgTxt
					END
				END
				SET @startIndex = @endIndex + 1
				SET @endIndex = CHARINDEX(',', @messages, @startIndex)
			END
		END
	RETURN @output
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [JMGetLocalizedMessageMaxFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'JMGetLocalizedMessageMaxFunc' AND revision = '1.3')

  insert into GXDBVersions values(5, 'JMGetLocalizedMessageMaxFunc',  '1.3', 'JMGetLocalizedMessageMaxFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/JMGetLocalizedMessageFunc.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: JMGetLocalizedMessageFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMGetLocalizedMessageFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[JMGetLocalizedMessageFunc]
  delete from GXDBVersions where name = 'JMGetLocalizedMessageFunc' and type = 5
END
GO

	CREATE FUNCTION JMGetLocalizedMessageFunc(@localeId integer, @inputMsgs varchar(256))
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @output nvarchar(1024)
	  SET @output=dbo.JMGetLocalizedMessageMaxFunc(@localeId,@inputMsgs)
	RETURN @output
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [JMGetLocalizedMessageFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'JMGetLocalizedMessageFunc' AND revision = '1.13')

  insert into GXDBVersions values(5, 'JMGetLocalizedMessageFunc',  '1.13', 'JMGetLocalizedMessageFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/ConvertBigIntToHexStr.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ConvertBigIntToHexStr'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ConvertBigIntToHexStr]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ConvertBigIntToHexStr]
  delete from GXDBVersions where name = 'ConvertBigIntToHexStr' and type = 5
END
GO

	CREATE FUNCTION ConvertBigIntToHexStr ( @Num BIGINT )
	RETURNS NVARCHAR(16)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @Str	NVARCHAR(16)
		DECLARE @Index	INTEGER

	SET @Str = ''

		WHILE @NUM > 0
		BEGIN
			SET @Index = @Num & 0xF
			SET @Num = @Num/16
			SET @Str = SUBSTRING('0123456789ABCDEF', @Index+1, 1)+@Str
		END
		RETURN @Str
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ConvertBigIntToHexStr]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ConvertBigIntToHexStr' AND revision = '1.1')

  insert into GXDBVersions values(5, 'ConvertBigIntToHexStr',  '1.1', 'ConvertBigIntToHexStr', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/fn_EvFormatEventMsgText.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: fn_EvFormatEventMsgText'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_EvFormatEventMsgText]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_EvFormatEventMsgText]
  delete from GXDBVersions where name = 'fn_EvFormatEventMsgText' and type = 5
END
GO

	CREATE FUNCTION fn_EvFormatEventMsgText( @MsgId INTEGER, @LocaleId INTEGER, @EventId INTEGER, @UniqPosition INTEGER, @CCId INTEGER)
	RETURNS NVARCHAR(max)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @MsgTxt		NVARCHAR(max)
		DECLARE @Data		NVARCHAR(max)
		DECLARE @MsgTxtTmp	NVARCHAR(max)
		DECLARE @ArgPos		INTEGER
		DECLARE @ArgIndex	INTEGER
		DECLARE @DataType	INTEGER
		DECLARE @HexFlag	INTEGER
		DECLARE @FullFmtSpecLen	INTEGER
		DECLARE @ParentMask	INTEGER

		SELECT @MsgTxt = Message
		FROM EvLocaleMsgs
		WHERE MessageId = @EventId
		AND LocaleId = @LocaleId

		IF @MsgTxt is null
		BEGIN
			SET @LocaleId = 0				-- If message id not found then try English

			SELECT @MsgTxt = Message
				FROM EvLocaleMsgs
				WHERE MessageId = @EventId
				AND LocaleId = @LocaleId

			IF @MsgTxt is null			-- If even English message not found then error out
			BEGIN
				RETURN @MsgTxt
			END
		END

		SET @ParentMask = @UniqPosition & 0xFFFFFFF0

		DECLARE GetTextPos CURSOR
		FOR	SELECT ArgPos, ArgIndex, DataType, HexFlag, FullFmtSpecLen
			FROM EvLocaleMsgArgInfo
			WHERE MessageId = @EventId
			AND LocaleId = @LocaleId
			ORDER BY ArgIndex DESC
		FOR READ ONLY

		OPEN GetTextPos

		FETCH NEXT FROM GetTextPos
		INTO @ArgPos, @ArgIndex, @DataType, @HexFlag, @FullFmtSpecLen

		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @UniqPosition = @ParentMask + @ArgPos

			SELECT @Data = Data FROM EvParam WHERE EvMsgId = @MsgId AND Position = @UniqPosition AND commCellId = @CCId

			IF @DataType = 13		-- Event, Now recurse
				SET @MsgTxtTmp = dbo.fn_EvFormatEventMsgText(@MsgId, @LocaleId, CAST(@Data AS INTEGER), (@UniqPosition*16),@CCId)
			ELSE IF @HexFlag = 1
				SET @MsgTxtTmp = dbo.ConvertBigIntToHexStr(CAST(@Data AS bigint))
			ELSE
				SET @MsgTxtTmp = @Data

			SET @Data = STUFF(@MsgTxt, @ArgIndex, @FullFmtSpecLen, @MsgTxtTmp)
			SET @MsgTxt = @Data		-- Putting this in one statement did not work, something gets overwritten


			FETCH NEXT FROM GetTextPos
			INTO @ArgPos, @ArgIndex, @DataType, @HexFlag, @FullFmtSpecLen
		END

		CLOSE GetTextPos
		DEALLOCATE GetTextPos

		RETURN @MsgTxt
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_EvFormatEventMsgText]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_EvFormatEventMsgText' AND revision = '1.10')

  insert into GXDBVersions values(5, 'fn_EvFormatEventMsgText',  '1.10', 'fn_EvFormatEventMsgText', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/JMFormatPendingMsgText.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: JMFormatPendingMsgText'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMFormatPendingMsgText]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[JMFormatPendingMsgText]
  delete from GXDBVersions where name = 'JMFormatPendingMsgText' and type = 5
END
GO

	CREATE FUNCTION JMFormatPendingMsgText ( @MsgId INTEGER, @LocaleId INTEGER, @EventId INTEGER, @UniqPosition INTEGER )
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @MsgTxt		NVARCHAR(4000)
		DECLARE @Data		NVARCHAR(4000)
		DECLARE @MsgTxtTmp	NVARCHAR(4000)
		DECLARE @ArgPos		INTEGER
		DECLARE @ArgIndex	INTEGER
		DECLARE @DataType	INTEGER
		DECLARE @HexFlag	INTEGER
		DECLARE @FullFmtSpecLen	INTEGER
		DECLARE @ParentMask	INTEGER

		SELECT @MsgTxt = Message
		FROM EvLocaleMsgs
		WHERE MessageId = @EventId
		AND LocaleId = @LocaleId

		IF @MsgTxt is null
		BEGIN
			SET @LocaleId = 0				-- If message id not found then try English

			SELECT @MsgTxt = Message
				FROM EvLocaleMsgs WITH (READUNCOMMITTED)
				WHERE MessageId = @EventId
				AND LocaleId = @LocaleId

			IF @MsgTxt is null			-- If even English message not found then error out
			BEGIN
				RETURN @MsgTxt
			END
		END

		SET @ParentMask = @UniqPosition & 0xFFFFFFF0

		DECLARE GetTextPos CURSOR
		FOR	SELECT ArgPos, ArgIndex, DataType, HexFlag, FullFmtSpecLen
			FROM EvLocaleMsgArgInfo WITH (READUNCOMMITTED)
			WHERE MessageId = @EventId
			AND LocaleId = @LocaleId
			ORDER BY ArgIndex DESC
		FOR READ ONLY

		OPEN GetTextPos

		FETCH NEXT FROM GetTextPos
		INTO @ArgPos, @ArgIndex, @DataType, @HexFlag, @FullFmtSpecLen

		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @UniqPosition = @ParentMask + @ArgPos

			SELECT @Data = Data FROM JMFailureReasonMsgParam WITH (READUNCOMMITTED) WHERE MsgId = @MsgId AND Position = @UniqPosition

			IF @DataType = 13		-- Event, Now recurse
				SET @MsgTxtTmp = dbo.JMFormatPendingMsgText(@MsgId, @LocaleId, CAST(@Data AS INTEGER), (@UniqPosition*16))
			ELSE IF @HexFlag = 1
				SET @MsgTxtTmp = dbo.ConvertBigIntToHexStr(CAST(@Data AS bigint))
			ELSE
				SET @MsgTxtTmp = @Data

			SET @Data = STUFF(@MsgTxt, @ArgIndex, @FullFmtSpecLen, @MsgTxtTmp)
			SET @MsgTxt = @Data		-- Putting this in one statement did not work, something gets overwritten


			FETCH NEXT FROM GetTextPos
			INTO @ArgPos, @ArgIndex, @DataType, @HexFlag, @FullFmtSpecLen
		END

		CLOSE GetTextPos
		DEALLOCATE GetTextPos

		RETURN @MsgTxt
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [JMFormatPendingMsgText]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'JMFormatPendingMsgText' AND revision = '1.3')

  insert into GXDBVersions values(5, 'JMFormatPendingMsgText',  '1.3', 'JMFormatPendingMsgText', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientIdForJob.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientIdForJob'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientIdForJob]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientIdForJob]
  delete from GXDBVersions where name = 'GetClientIdForJob' and type = 5
END
GO

	CREATE FUNCTION GetClientIdForJob(@JobId bigint)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @jobCategory	INTEGER
		DECLARE @clientId	INTEGER
		SET @clientId = -1
		SELECT @jobCategory = jobCategory FROM JMJobInfo WHERE jobId = @JobId
		IF(@jobCategory IS NOT NULL)
		BEGIN
			IF (@jobCategory = 1)
			BEGIN
				SET @clientId = ISNULL((SELECT clientId FROM APP_Application WHERE id IN (SELECT applicationId FROM JMBkpJobInfo WHERE jobId = @JobId)),-1)
			END
			ELSE IF (@jobCategory = 2)
			BEGIN
				SET @clientId = ISNULL((SELECT destClientId FROM JMRstJobInfo WHERE jobId = @JobId),-1)
			END
		END
		RETURN @clientId
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientIdForJob]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientIdForJob' AND revision = '1.5')

  insert into GXDBVersions values(5, 'GetClientIdForJob',  '1.5', 'GetClientIdForJob', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetTaskIDForJob.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetTaskIDForJob'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetTaskIDForJob]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetTaskIDForJob]
  delete from GXDBVersions where name = 'GetTaskIDForJob' and type = 5
END
GO

	CREATE FUNCTION GetTaskIDForJob(@JobId bigint)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @jobCategory	INTEGER
		DECLARE @taskId		INTEGER
		SET @taskId = -1
		SELECT @jobCategory = jobCategory FROM JMJobInfo WHERE jobId = @JobId
		IF(@jobCategory IS NOT NULL)
		BEGIN
			SET @taskId = CASE @jobCategory
			WHEN 1 THEN ISNULL((SELECT bkpTaskID FROM JMJobTaskLink WHERE jobId = @JobId),-1)
			WHEN 2 THEN ISNULL((SELECT rstTaskID FROM JMJobTaskLink WHERE jobId = @JobId),-1)
			ELSE ISNULL((SELECT adminTaskID FROM JMJobTaskLink WHERE jobId = @JobId),-1)
			END
		END
		RETURN @taskId
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetTaskIDForJob]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetTaskIDForJob' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetTaskIDForJob',  '1.4', 'GetTaskIDForJob', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobTypeForJobID.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobTypeForJobID'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobTypeForJobID]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobTypeForJobID]
  delete from GXDBVersions where name = 'GetJobTypeForJobID' and type = 5
END
GO

	CREATE FUNCTION GetJobTypeForJobID(@JobId bigint)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @jobCategory	INTEGER
		DECLARE @opType			INTEGER
		SELECT @jobCategory = jobCategory, @opType = opType FROM JMJobInfo WHERE jobId = @JobId
		IF(@jobCategory IS NULL)
		BEGIN
			RETURN -1
		END
		ELSE
		BEGIN
			SET @opType = CASE @jobCategory
			WHEN 1 THEN 4
			WHEN 2 THEN 5
			ELSE ISNULL(@opType,-1)
			END
		END
		RETURN @opType
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobTypeForJobID]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobTypeForJobID' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetJobTypeForJobID',  '1.3', 'GetJobTypeForJobID', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetStartDay.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetStartDay'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetStartDay]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetStartDay]
  delete from GXDBVersions where name = 'GetStartDay' and type = 5
END
GO

	CREATE FUNCTION GetStartDay(@year int, @month int,  @calendarId int )
		RETURNS DATETIME
		AS
		BEGIN
			DECLARE @startDate DATETIME
			DECLARE @calType INT
			set @startDate = 0
			set @calType = (Select calType from APP_CustomCalendar where id = @calendarId)
			if (@calType > 2)
			select @startDate = startDate from   APP_CustomCalendarMonths where year = @year and month = @month and calendarId = @calendarId
			Else
			Begin
			declare @name as varchar(125)
			set @name = (LTRIM(STR(@month)) + '/1/' + LTRIM(STR(@year)))
			set @startDate = CAST(@name AS datetime)
			End
			return @startDate
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetStartDay]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetStartDay' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetStartDay',  '1.4', 'GetStartDay', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetEndDay.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetEndDay'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetEndDay]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetEndDay]
  delete from GXDBVersions where name = 'GetEndDay' and type = 5
END
GO

	CREATE FUNCTION GetEndDay(@year int, @month int,  @calendarId int )
	RETURNS DATETIME
	AS
	BEGIN
	DECLARE @endDate DATETIME
	DECLARE @calType INT
	set @endDate = 0
	set @calType = (Select calType from APP_CustomCalendar where id = @calendarId)
	if (@calType > 2)
	select @endDate = endDate from   APP_CustomCalendarMonths where year = @year and month = @month and calendarId = @calendarId
		Else
	Begin
	declare @name as varchar(125)
	set @name = (LTRIM(STR(@month)) + '/1/' + LTRIM(STR(@year)))
	set @endDate = CAST(@name AS datetime)
	set @endDate = DATEADD(month, 1, @endDate)
	set @endDate = DATEADD(day, -1, @endDate)
	End
	return @endDate
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetEndDay]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetEndDay' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetEndDay',  '1.4', 'GetEndDay', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDay.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDay'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDay]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDay]
  delete from GXDBVersions where name = 'GetDay' and type = 5
END
GO

	CREATE FUNCTION GetDay (@DayStartOffset int, @weekOffset int, @dayOfweekOffset int, @year int, @month int, @calendarId int)
	RETURNS DATETIME
		AS
	BEGIN
			DECLARE @startDate DATETIME
			DECLARE @wantedDate DATETIME
			DECLARE @weekDay integer
			DECLARE @dayDiff integer
			DECLARE @endDate DATETIME
			DECLARE @daysCount INTEGER
				set @startDate = 0
				set @endDate = 0
				set @startDate = dbo.GetStartDay(@year, @month, @calendarId)
				set @endDate = dbo.GetEndDay(@year, @month, @calendarId)
				set @daysCount = DATEDIFF(d, @startDate,@endDate)
				if (@startDate = 0) OR (@endDate = 0)
					return 0
				set @wantedDate = @startDate
				set @weekDay = DATEPART(weekday, @startDate)
				if(@dayOfweekOffset > 0)
				BEGIN
					set @dayDiff = @dayOfweekOffset - @weekDay
					if (@dayDiff < 0)
						set @wantedDate = DATEADD(day, (7 + @dayDiff), @startDate)
					else
						set @wantedDate = DATEADD(day, (@dayDiff), @startDate)
					set @wantedDate = DATEADD(day, ((@weekOffset -1) *7), @wantedDate)
				END
				if (@DayStartOffset > 0)
                    if(@DayStartOffset > @daysCount)
						set @wantedDate = @endDate
    			    else
						set @wantedDate = DATEADD(day, (@DayStartOffset-1), @wantedDate)
				IF (@wantedDate > @endDate) OR (@wantedDate < @startDate)
					return 0
				return @wantedDate
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDay]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDay' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetDay',  '1.4', 'GetDay', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetNthweekendDay.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetNthweekendDay'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetNthweekendDay]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetNthweekendDay]
  delete from GXDBVersions where name = 'GetNthweekendDay' and type = 5
END
GO

	CREATE FUNCTION GetNthweekendDay(@Offset int, @year int, @month int, @calendarId int)
		RETURNS DATETIME
		AS
		BEGIN
			DECLARE @startDate DATETIME
			DECLARE @endDate DATETIME
			DECLARE @firstweekendday DATETIME
			DECLARE @wantedDate DATETIME
			DECLARE @weekDay integer
			DECLARE @dayDiff integer
				DECLARE @divident float
			set @startDate = 0
			set @endDate = 0
			set @startDate = dbo.GetStartDay(@year, @month, @calendarId)
				set @endDate = dbo.GetEndDay(@year, @month, @calendarId)
			if (@startDate = 0) OR (@endDate = 0)
			return 0
			set @weekDay = DATEPART(weekday, @startDate)
			if(@weekDay = 1)
			BEGIN
			set @Offset =  @Offset - 1
			if (@Offset = 0)
				return @startDate
			END
			set @dayDiff = 7 - @weekDay
				set @firstweekendday = DATEADD(day, @dayDiff, @startDate)
			if (@Offset =1)
			return @firstweekendday
			set @divident = (CAST(@offset as float)/2)
			if (@divident) > ABS( @offset/2)
				set @wantedDate = DATEADD(day, ((ABS( @offset/2)) *7) , @firstweekendday)
			ELSE
				set @wantedDate = DATEADD(day, (((ABS( @offset/2))-1) *7) +1 , @firstweekendday)
			IF (@wantedDate > @endDate) OR (@wantedDate < @startDate)
			return 0
			return @wantedDate
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetNthweekendDay]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetNthweekendDay' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetNthweekendDay',  '1.1', 'GetNthweekendDay', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetNthweekDay.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetNthweekDay'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetNthweekDay]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetNthweekDay]
  delete from GXDBVersions where name = 'GetNthweekDay' and type = 5
END
GO

	CREATE FUNCTION GetNthweekDay(@Offset int, @year int, @month int, @calendarId int )
		RETURNS DATETIME
		AS
		BEGIN
			DECLARE @startDate DATETIME
			DECLARE @wantedDate DATETIME
			DECLARE @endDate DATETIME
			DECLARE @weekDay integer
			DECLARE @dayDiff integer
			set @startDate = 0
			set @endDate = 0
			set @startDate = dbo.GetStartDay(@year, @month, @calendarId)
			set @endDate = dbo.GetEndDay(@year, @month, @calendarId)
			if (@startDate = 0) OR (@endDate = 0)
				return 0
			set @weekDay = DATEPART(weekday, @startDate)
			set  @daydiff =  @offset + ((@offset/5) *2)
			if(@weekDay = 7)
			set @daydiff =  @daydiff + 2
			else if(@weekDay = 1)
			set @daydiff =  @daydiff + 1
			if (@weekDay < 7) AND (@weekDay > 1)
			BEGIN
			if((@weekDay + (@Offset % 5)) > 6)
				set @daydiff =  @daydiff + 2
			END
			set @wantedDate = DATEADD(day, (@daydiff -1)  , @startDate)
				set @weekDay = DATEPART(weekday, @wantedDate)
			if (@weekDay = 7)
			set @wantedDate = DATEADD(day, -1  , @wantedDate)
			else if (@weekDay = 1)
				set @wantedDate = DATEADD(day, -2  , @wantedDate)
			IF (@wantedDate > @endDate) OR (@wantedDate < @startDate)
			return 0
				return @wantedDate
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetNthweekDay]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetNthweekDay' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetNthweekDay',  '1.1', 'GetNthweekDay', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetLastWeekend.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetLastWeekend'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetLastWeekend]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetLastWeekend]
  delete from GXDBVersions where name = 'GetLastWeekend' and type = 5
END
GO

	CREATE FUNCTION GetLastWeekend(@year int, @month int, @calendarId int)
		RETURNS DATETIME
		AS
		BEGIN
			DECLARE @startDate DATETIME
			DECLARE @endDate DATETIME
			DECLARE @desireDate DATETIME
			DECLARE @weekDay integer
			set @startDate = 0
			set @endDate = 0
			set @startDate = dbo.GetStartDay(@year, @month, @calendarId)
				set @endDate = dbo.GetEndDay(@year, @month, @calendarId)
			if (@startDate = 0) OR (@endDate = 0)
			return 0
			set @weekDay = DATEPART(weekday, @endDate)
			if ((@weekDay > 1 ) AND ( @weekday < 7))
				set @desireDate = DATEADD(day, (- @weekday +1) ,  @endDate)
			else
				set @desireDate =  @endDate
			return @desireDate
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetLastWeekend]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetLastWeekend' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetLastWeekend',  '1.1', 'GetLastWeekend', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetLastWeekDayOfMonth.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetLastWeekDayOfMonth'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetLastWeekDayOfMonth]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetLastWeekDayOfMonth]
  delete from GXDBVersions where name = 'GetLastWeekDayOfMonth' and type = 5
END
GO

	CREATE FUNCTION GetLastWeekDayOfMonth(@weekofday int, @year int, @month int, @calendarId int)
		RETURNS DATETIME
		AS
		BEGIN
			DECLARE @startDate DATETIME
			DECLARE @endDate DATETIME
			DECLARE @desireDate DATETIME
			DECLARE @weekDay integer
			DECLARE @dayDiff integer
				set @startDate = 0
			set @endDate = 0
				set @startDate = dbo.GetStartDay(@year, @month, @calendarId)
				set @endDate = dbo.GetEndDay(@year, @month, @calendarId)
			if (@startDate = 0) OR (@endDate = 0)
			return 0
			set @weekDay = DATEPART(weekday, @endDate)
			set @dayDiff = @weekDay - @weekofday
			if (@dayDiff) < 0
				set @desireDate = DATEADD(day, ( -7 - @dayDiff) ,  @endDate)
			else
				set @desireDate = DATEADD(day, (- @dayDiff) ,  @endDate)
			return @desireDate
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetLastWeekDayOfMonth]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetLastWeekDayOfMonth' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetLastWeekDayOfMonth',  '1.1', 'GetLastWeekDayOfMonth', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetLastWeekDay.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetLastWeekDay'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetLastWeekDay]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetLastWeekDay]
  delete from GXDBVersions where name = 'GetLastWeekDay' and type = 5
END
GO

	CREATE FUNCTION GetLastWeekday(@year int, @month int  , @calendarId int )
		RETURNS DATETIME
		AS
		BEGIN
			DECLARE @startDate DATETIME
			DECLARE @endDate DATETIME
			DECLARE @desireDate DATETIME
			DECLARE @weekDay integer
			set @startDate = 0
			set @endDate = 0
			set @startDate = dbo.GetStartDay(@year, @month, @calendarId)
				set @endDate = dbo.GetEndDay(@year, @month, @calendarId)
			if (@startDate = 0) OR (@endDate = 0)
			return 0
			set @weekDay = DATEPART(weekday, @endDate)
			if (@weekDay = 1)
				set @desireDate = DATEADD(day, (-2) ,  @endDate)
			else if (@weekDay = 7)
				set @desireDate = DATEADD(day, (- 1) ,  @endDate)
			else
				set @desireDate =  @endDate
			return @desireDate
			END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetLastWeekDay]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetLastWeekDay' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetLastWeekDay',  '1.2', 'GetLastWeekDay', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2Func_NumExtRetJobsOnMedia.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2Func_NumExtRetJobsOnMedia'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2Func_NumExtRetJobsOnMedia]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2Func_NumExtRetJobsOnMedia]
  delete from GXDBVersions where name = 'MMS2Func_NumExtRetJobsOnMedia' and type = 5
END
GO

	CREATE FUNCTION MMS2Func_NumExtRetJobsOnMedia(@inMediaId 	integer)
	RETURNS integer
	AS
	BEGIN
		DECLARE @numJob 	integer

		declare @tblChunkList table (archChunkId bigint, commCellId int)
		declare @tblArchFileCopyList table (archfileId int, commCellId int, copyId int)
		declare @tblJobCopyList table (jobId int, commCellId int, copyId int, fileType int)
		declare @tblExtendedJobCopy table (jobId int, commCellId int, retentionFlags int)

		insert into @tblChunkList
		select id, commCellId
		from archChunk
		where volumeId in (select volumeId from MMVolume where mediaId = @inMediaId)

		insert into @tblArchFileCopyList
		select distinct a.archFileId, a.commCellId, a.archCopyId
		from archChunkMapping a, @tblChunkList b
		where a.archChunkId = b.archChunkId
		and a.chunkCommCellId = b.commCellId

		insert into @tblJobCopyList
		select distinct a.jobId, a.commCellId, b.copyId, a.fileType
		from archFile a, @tblArchFileCopyList b
		where a.id = b.archFileId
		and a.commCellId = b.commCellId

		insert into @tblExtendedJobCopy
		select distinct a.jobid, a.commcellId, a.retentionFlags
		from JMJobDataStats a, @tblJobCopyList b
		where a.jobId = b.jobId
		and a.commCellId = b.commCellId
		and a.archGrpCopyId = b.copyId
		and a.dataType = b.filetype
		and a.disabled & 256 = 0
		and a.status <> 1000
		and a.retentionFlags > 0

		set @numJob = @@rowCount
		RETURN @numJob

     END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2Func_NumExtRetJobsOnMedia]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2Func_NumExtRetJobsOnMedia' AND revision = '1.6')

  insert into GXDBVersions values(5, 'MMS2Func_NumExtRetJobsOnMedia',  '1.6', 'MMS2Func_NumExtRetJobsOnMedia', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsIndexingApp.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsIndexingApp'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsIndexingApp]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsIndexingApp]
  delete from GXDBVersions where name = 'IsIndexingApp' and type = 5
END
GO

	CREATE FUNCTION IsIndexingApp(@AppId int)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @requiresIndexing	INTEGER

		SET @requiresIndexing = 0

		IF (	(SELECT AppTypeId FROM APP_Application WHERE id = @AppId) IN
				(
					1,
					11,
					12,
					13,
					29,
					20,
					19,
					36,
					17,
					18,
					33,
					34,
					36,
					38,
					21,
					42,
					43,
					56,
					63,
					64,
					74,
					74,
					86,
					88,
					8,
					45,
				    56,
					54,
					67,
					68,
					3,
					5,
					22,
					37,
					61,
					62,
					79,
					80,
					103,
					104,
					125,
					126,
					128,
					135
				)
		  )
		BEGIN
			SET @requiresIndexing = 1
		END
		RETURN @requiresIndexing
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsIndexingApp]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsIndexingApp' AND revision = '1.14')

  insert into GXDBVersions values(5, 'IsIndexingApp',  '1.14', 'IsIndexingApp', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2Func_GetLANFreeDataPaths.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2Func_GetLANFreeDataPaths'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2Func_GetLANFreeDataPaths]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2Func_GetLANFreeDataPaths]
  delete from GXDBVersions where name = 'MMS2Func_GetLANFreeDataPaths' and type = 5
END
GO

	CREATE FUNCTION MMS2Func_GetLANFreeDataPaths(	@i_copyId	integer,
                                                    @i_clientId	integer,
                                                    @i_appId 	integer,
                                                    @i_use_SC_DPs	integer,
																										@i_dataType	integer )
	RETURNS @MMS2Func_GetLANFreeDataPaths  table (DataPathId Integer, isVirtual Integer)
	AS
	BEGIN
		DECLARE @isIndexing	integer
		SET @isIndexing = dbo.IsIndexingApp(@i_AppId)
		DECLARE @l_tmpClientIds TABLE (clientId Integer, isVirtual Integer)
		DECLARE @l_physicalClientId Integer
 		SET @l_physicalClientId = ISNULL(
 				(	SELECT attrVal from APP_ClientProp where attrName = N'Active Physical Node' and modified = 0 and componentnameId = @i_clientId )
 				, @i_clientId )
		IF (@l_physicalClientId <> @i_clientId)
		BEGIN
			INSERT INTO @l_tmpClientIds VALUES (@i_clientId, 1)
		END
		INSERT INTO @l_tmpClientIds VALUES (@l_physicalClientId, 0)
		DECLARE @l_tmpDatapathInfo TABLE (DataPathId Integer, drivePoolId Integer, drivePoolType Integer, Flag Integer, MAClientId Integer, HostClientId Integer, isSCDataPath Integer)
		INSERT INTO @l_tmpDatapathInfo
		SELECT DPath.DataPathId, DPath.DrivePoolId, DP.DrivePoolType, DPath.Flag, DP.ClientId, DPath.HostClientId, 0
		FROM MMDataPath AS DPath, MMDrivePool AS DP
		WHERE DPath.CopyId = @i_copyId AND DP.DrivePoolId = DPath.DrivePoolId
    IF (@i_use_SC_DPs = 1)
		BEGIN
			DELETE FROM @l_tmpDatapathInfo
			WHERE DataPathId NOT IN
			(
						Select DataPathId
						from APP_AppToDataPath
						where componentNameId = @i_AppId AND
						dataType = @i_dataType
			)
		END
		DELETE FROM @l_tmpDatapathInfo
		WHERE (Flag & 4) = 0
		DECLARE @l_tmpOfflineMATbl TABLE (MAClientId Integer)
		INSERT INTO @l_tmpOfflineMATbl
		SELECT DISTINCT MAClientId
		FROM @l_tmpDatapathInfo
		DELETE @l_tmpOfflineMATbl
		FROM @l_tmpOfflineMATbl AS tmpOfflTbl, IdxAccessPath AS IAP, IdxCache AS IC, MMHost as MH
		WHERE
			MH.ClientId = tmpOfflTbl.MAClientId AND MH.MmHostSoftState = 1 AND
		  	IAP.ClientId = tmpOfflTbl.MAClientId AND IC.IdxCacheId = IAP.IdxCacheId AND
			(	@isIndexing = 0 OR
					(
     					IC.Enabled = 1 AND IAP.Enabled = 1 AND IC.Softstate = 1 AND IAP.Softstate = 1 AND IC.IdxCacheType = 1
					)
			)
     DELETE FROM @l_tmpDatapathInfo
     FROM @l_tmpDatapathInfo AS tmpDP, @l_tmpOfflineMATbl AS tmpOfflTbl
     WHERE tmpDP.MAClientId = tmpOfflTbl.MAClientId
		INSERT INTO @MMS2Func_GetLANFreeDataPaths
		SELECT distinct tmpDP.DataPathId, TCLIDs.isVirtual
		FROM  @l_tmpDatapathInfo AS tmpDP, @l_tmpClientIds as TCLIDs
		WHERE tmpDP.HostClientId = TCLIDs.clientId
		RETURN
 	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2Func_GetLANFreeDataPaths]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2Func_GetLANFreeDataPaths' AND revision = '1.7')

  insert into GXDBVersions values(5, 'MMS2Func_GetLANFreeDataPaths',  '1.7', 'MMS2Func_GetLANFreeDataPaths', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2FUNC_GetGuiMediaAttribute.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2FUNC_GetGuiMediaAttribute'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2FUNC_GetGuiMediaAttribute]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2FUNC_GetGuiMediaAttribute]
  delete from GXDBVersions where name = 'MMS2FUNC_GetGuiMediaAttribute' and type = 5
END
GO

	CREATE FUNCTION MMS2FUNC_GetGuiMediaAttribute(@i_MediaId int)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN

  IF (@i_MediaId = 0) RETURN 0
	declare @l_MediaAttributes INTEGER
	declare @l_IsAged INTEGER
	declare @l_IsInMediaGroup INTEGER
	declare @l_isMagBit INTEGER
	declare @l_isMediaExportedBit INTEGER
	declare @l_MediaFlagsBit	INTEGER
	declare @l_isRSMBit	INTEGER
	declare @l_LibraryTypeId INTEGER
	declare @l_isCleaningMediaBit INTEGER
	declare @l_VolCount	INTEGER
	declare @l_libraryTypeBits INTEGER
	declare @l_isWrongLibraryBit INTEGER
 	declare @l_mediaStatus	INTEGER
	declare @l_isDuplicateBit INTEGER
	declare @l_isUnrecogBarCode INTEGER
	SELECT
		@l_MediaAttributes = M.attributes,
		@l_IsAged = M.IsAged,
		@l_IsInMediaGroup = M.IsInMediaGroup,
		@l_isWrongLibraryBit = CASE WHEN (M.MediaLocation IN (1,2)  AND (M.LibraryId > 0) AND (M.LastWriteLibraryId > 0) AND (M.LibraryId <> M.LastWriteLibraryId)) THEN 262144 ELSE 0 END,
		@l_isMagBit = CASE WHEN M.mediaTypeId = 10001 THEN 8 ELSE 0 END,
		@l_isMediaExportedBit = CASE WHEN M.mediaLocation = 3 THEN 2 ELSE 0 END,
		@l_MediaFlagsBit = CASE WHEN M.MediaFlags = 2 THEN 32 WHEN M.MediaFlags = 3 THEN 64 ELSE 0 END,
		@l_isRSMBit = CASE WHEN M.ExternalGUID <> '' then 1024 ELSE 0 END,
		@l_LibraryTypeId = isnull(L.LibraryTypeId, 0),
		@l_isCleaningMediaBit = CASE WHEN isnull(MT.IsCleaningMedia, 0) = 1 THEN 512 ELSE 0 END
	FROM MMMedia AS M with (nolock)
		LEFT OUTER JOIN MMLibrary AS L with (nolock) ON (M.LibraryId > 0 AND M.LibraryId = L.LibraryId)
		LEFT OUTER JOIN MMMediaType AS MT with (nolock) ON M.MediaTypeId = MT.MediaTypeId
	WHERE M.MediaId = @i_MediaId
	SET @l_mediaStatus  = ISNULL((  SELECT TOP 1 mediaStatus from MMSlot where mediaid = @i_MediaId ), 0)
  SET @l_isDuplicateBit = (CASE WHEN (@l_mediaStatus & 1) <> 0 THEN 131072 ELSE 0 END)
  IF (@l_mediaStatus & 4) <> 0
  BEGIN
  	SET @l_isWrongLibraryBit = 262144
  	SET @l_isMediaExportedBit = 0
  END
  SET @l_isUnrecogBarCode = CASE WHEN 	(@l_mediaStatus & 2) > 0 THEN 1048576 ELSE 0 END
	SET  @l_libraryTypeBits = CASE 	WHEN @l_LibraryTypeId = 3 THEN 8
					WHEN @l_LibraryTypeId IN (4,5) THEN 4
					ELSE 0 END
 IF (@l_LibraryTypeId = 8) AND (@l_isWrongLibraryBit  > 0)
 BEGIN
 		SET @l_isWrongLibraryBit = 0
 END
	declare @o_MediaAttributeForGUI INTEGER
	SET @o_MediaAttributeForGUI  = 	@l_MediaFlagsBit | @l_isMediaExportedBit | @l_isWrongLibraryBit |
					@l_isRSMBit | @l_isCleaningMediaBit | @l_isMagBit | @l_libraryTypeBits  | @l_isDuplicateBit  | @l_isUnrecogBarCode |
					(@l_MediaAttributes & 16777216) | (@l_MediaAttributes & 536870912)
	IF @l_IsAged > 0
	BEGIN
	  SET @o_MediaAttributeForGUI = @o_MediaAttributeForGUI | 8388608
	END
	IF @l_IsInMediaGroup > 0
	BEGIN
	  SET @o_MediaAttributeForGUI = @o_MediaAttributeForGUI | 1
	END
	declare @l_Volumes TABLE (VolumeId INTEGER, VolumeFlags INTEGER, Attributes INTEGER)
	insert into @l_Volumes
	select volumeId, VolumeFlags, Attributes from MMVolume with (nolock) WHERE MediaId = @i_MediaId
	SET @l_VolCount = @@ROWCOUNT
	DECLARE @l_MediaRefreshBit INTEGER
	SELECT	TOP 1 @l_MediaRefreshBit =
			CASE
				WHEN (Attributes & 16) > 0 THEN 1073741824
				WHEN (Attributes &  8) > 0 THEN 1024
				ELSE 0
			END
	FROM @l_Volumes
	DECLARE @l_SideAVolID INTEGER
	DECLARE @l_SideABit INTEGER
	DECLARE @l_SideBBit INTEGER
	SET @l_SideABit  = 0
	SET @l_SideBBit  = 0
	IF (@l_VolCount > 0)
	BEGIN
		SELECT TOP 1 	@l_SideAVolID = VolumeId,
			     	@l_SideABit =
				CASE
					WHEN VolumeFlags IN (1, 8) THEN 128
					WHEN VolumeFlags = 2 THEN 256
					WHEN VolumeFlags = 3 THEN 4096
					WHEN VolumeFlags = 4 THEN 2048
					WHEN VolumeFlags = 7 THEN 2097152
					ELSE 0
				END
		FROM @l_Volumes
		DELETE FROM @l_Volumes
		WHERE VolumeId = @l_SideAVolID
	END
	IF (@l_VolCount > 1)
	BEGIN
		  SET @o_MediaAttributeForGUI = @o_MediaAttributeForGUI | 16
		SELECT TOP 1 	@l_SideBBit =
				CASE
					WHEN VolumeFlags IN (1, 8) THEN 8192
					WHEN VolumeFlags = 2 THEN 16384
					WHEN VolumeFlags = 3 THEN 65536
					WHEN VolumeFlags = 4 THEN 32768
					WHEN VolumeFlags = 7 THEN 4194304
					ELSE 0
				END
		FROM @l_Volumes
	END
	SET @o_MediaAttributeForGUI = @o_MediaAttributeForGUI |  @l_SideABit | @l_SideBBit | @l_MediaRefreshBit
		RETURN @o_MediaAttributeForGUI
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2FUNC_GetGuiMediaAttribute]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2FUNC_GetGuiMediaAttribute' AND revision = '1.13')

  insert into GXDBVersions values(5, 'MMS2FUNC_GetGuiMediaAttribute',  '1.13', 'MMS2FUNC_GetGuiMediaAttribute', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/JMGetLocalizedMessageAndIDFunc.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: JMGetLocalizedMessageAndIDFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMGetLocalizedMessageAndIDFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[JMGetLocalizedMessageAndIDFunc]
  delete from GXDBVersions where name = 'JMGetLocalizedMessageAndIDFunc' and type = 5
END
GO

	CREATE FUNCTION JMGetLocalizedMessageAndIDFunc(@localeId integer, @inputMsgs varchar(256))
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @messages varchar(256)
		DECLARE @msgId varchar(40)
		DECLARE @endIndex integer
		DECLARE @startIndex integer
		DECLARE @EventId integer
		DECLARE @output nvarchar(1024)
		DECLARE @MsgTxt nvarchar(4000)
		SET @startIndex = 0
		SET @messages = @inputMsgs
		SET @output = N''
		SET @endIndex = CHARINDEX(',', @messages, @startIndex)
		IF (@endIndex is NULL OR @endIndex = 0)
		BEGIN
			SET @output = @messages
		END
		ELSE
		BEGIN
			WHILE(@endIndex IS NOT NULL AND @endIndex <> 0)
			BEGIN
				SET @msgId = SUBSTRING(@messages,@startIndex,@endIndex-@startIndex)
				SET @EventId = (SELECT messageId FROM JMFailureReasonMsg WITH (READUNCOMMITTED) WHERE id = @msgId)
				if (@EventId IS NOT null)
				BEGIN
					SET @MsgTxt = DBO.JMFormatPendingMsgText( @msgId, @localeId, @EventId, 1)
					IF @MsgTxt IS NOT null
					BEGIN
						IF LEN(@output) <> 0 BEGIN
							SET @output = @output + NCHAR(10)
						END
						SET @MsgTxt = REPLACE(@MsgTxt, NCHAR(10), NCHAR(13) )
						SET @output = @output + CAST(@EventId AS varchar) + NCHAR(13) + @MsgTxt
					END
				END
				SET @startIndex = @endIndex + 1
				SET @endIndex = CHARINDEX(',', @messages, @startIndex)
			END
		END
	RETURN @output
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [JMGetLocalizedMessageAndIDFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'JMGetLocalizedMessageAndIDFunc' AND revision = '1.6')

  insert into GXDBVersions values(5, 'JMGetLocalizedMessageAndIDFunc',  '1.6', 'JMGetLocalizedMessageAndIDFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/NTFormatMsgText.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: NTFormatMsgText'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTFormatMsgText]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NTFormatMsgText]
  delete from GXDBVersions where name = 'NTFormatMsgText' and type = 5
END
GO

	CREATE FUNCTION NTFormatMsgText ( @MsgId INTEGER, @LocaleId INTEGER, @EventId INTEGER, @AlertEventId INTEGER, @UniqPosition INTEGER )
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @MsgTxt		NVARCHAR(4000)
		DECLARE @Data		NVARCHAR(4000)
		DECLARE @MsgTxtTmp	NVARCHAR(4000)
		DECLARE @ArgPos		INTEGER
		DECLARE @ArgIndex	INTEGER
		DECLARE @DataType	INTEGER
		DECLARE @HexFlag	INTEGER
		DECLARE @FullFmtSpecLen	INTEGER
		DECLARE @ParentMask	INTEGER

		SELECT @MsgTxt = Message
		FROM EvLocaleMsgs
		WHERE MessageId = @EventId
		AND LocaleId = @LocaleId

		IF @MsgTxt is null
		BEGIN
			SET @LocaleId = 0				-- If message id not found then try English

			SELECT @MsgTxt = Message
				FROM EvLocaleMsgs WITH (READUNCOMMITTED)
				WHERE MessageId = @EventId
				AND LocaleId = @LocaleId

			IF @MsgTxt is null			-- If even English message not found then error out
			BEGIN
				RETURN @MsgTxt
			END
		END

		SET @ParentMask = @UniqPosition & 0xFFFFFFF0

		DECLARE GetTextPos CURSOR
		FOR	SELECT ArgPos, ArgIndex, DataType, HexFlag, FullFmtSpecLen
			FROM EvLocaleMsgArgInfo WITH (READUNCOMMITTED)
			WHERE MessageId = @EventId
			AND LocaleId = @LocaleId
			ORDER BY ArgIndex DESC
		FOR READ ONLY

		OPEN GetTextPos

		FETCH NEXT FROM GetTextPos
		INTO @ArgPos, @ArgIndex, @DataType, @HexFlag, @FullFmtSpecLen

		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @UniqPosition = @ParentMask + @ArgPos

			SELECT @Data = Data FROM ntdMsgParam WITH (READUNCOMMITTED)
			  WHERE MsgIndex = @MsgId
				 AND eventId = @AlertEventId
				 AND msgId    = @eventId			-- MR 89466
				 AND Position = @UniqPosition

			IF @DataType = 13		-- Event, Now recurse
				SET @MsgTxtTmp = dbo.NTFormatMsgText(@MsgId, @LocaleId, CAST(@Data AS INTEGER), @AlertEventId, (@UniqPosition*16))
			ELSE IF @HexFlag = 1
				SET @MsgTxtTmp = dbo.ConvertBigIntToHexStr(CAST(@Data AS bigint))
			ELSE
				SET @MsgTxtTmp = @Data

			SET @Data = STUFF(@MsgTxt, @ArgIndex, @FullFmtSpecLen, @MsgTxtTmp)
			SET @MsgTxt = @Data		-- Putting this in one statement did not work, something gets overwritten


			FETCH NEXT FROM GetTextPos
			INTO @ArgPos, @ArgIndex, @DataType, @HexFlag, @FullFmtSpecLen
		END

		CLOSE GetTextPos
		DEALLOCATE GetTextPos

		RETURN @MsgTxt
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NTFormatMsgText]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NTFormatMsgText' AND revision = '1.3')

  insert into GXDBVersions values(5, 'NTFormatMsgText',  '1.3', 'NTFormatMsgText', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetQNetPruneTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetQNetPruneTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetQNetPruneTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetQNetPruneTime]
  delete from GXDBVersions where name = 'GetQNetPruneTime' and type = 5
END
GO

	CREATE FUNCTION GetQNetPruneTime ()
	RETURNS int
	WITH ENCRYPTION
	BEGIN
		DECLARE @IsQNetInstalled	int
		DECLARE	@QNetPruneTime		DATETIME
		DECLARE	@QNetJobPruneTime	DATETIME
		DECLARE	@QNetMMPruneTime	DATETIME
		DECLARE	@CurrentUTCTime		DATETIME
		DECLARE @DayHistoryPeriod	int
		DECLARE	@QNetAuxJobPruneTime	DATETIME
		DECLARE	@QNetMMStatPruneTime	DATETIME
		DECLARE	@QNetMMDrvPruneTime		DATETIME
		SET	@CurrentUTCTime = GETUTCDATE()
        DECLARE @oneYear			DATETIME = dateadd(day, -365, @CurrentUTCTime)
		SELECT	TOP 1 @DayHistoryPeriod = CONVERT(int, CONVERT(varchar(5), Value))
		FROM	GXGlobalParam
		WHERE	name = 'DailyHistoryForQNetRetentionPeriod'
		IF (@DayHistoryPeriod IS NULL)
			SET	@DayHistoryPeriod = 7
		IF (OBJECT_ID('QNetReg') IS NOT NULL AND EXISTS(SELECT * FROM QNetReg))
		BEGIN
			SELECT	@QNetJobPruneTime = dateadd(day, - @DayHistoryPeriod, MIN(LastHistoryJobUpdateTime)),
				  @QNetMMPruneTime = dateadd(day, - @DayHistoryPeriod, MIN(LastHistoryMMUpdateTime)),
				  @QNetAuxJobPruneTime = dateadd(day, - @DayHistoryPeriod, MIN(LastHistoryJobAUXUpdateTime)),
				  @QNetMMStatPruneTime = dateadd(day, - @DayHistoryPeriod, MIN(LastHistoryMMStatUpdateTime)),
				  @QNetMMDrvPruneTime = dateadd(day, - @DayHistoryPeriod, MIN(LastHistoryMMDrvUpdateTime))
			FROM	QNetReg
		END
		IF (@QNetJobPruneTime IS NULL)
			SET	@QNetJobPruneTime = dateadd(day, - @DayHistoryPeriod, @CurrentUTCTime)
		ELSE
			IF ( (@QNetAuxJobPruneTime >= @oneYear  )
 				AND (@QNetAuxJobPruneTime IS NOT NULL )
				AND (@QNetAuxJobPruneTime < @QNetJobPruneTime) )
				SET @QNetJobPruneTime = @QNetAuxJobPruneTime
			IF ( (@QNetMMStatPruneTime >= @oneYear  )
 				AND (@QNetMMStatPruneTime IS NOT NULL )
				AND (@QNetMMStatPruneTime < @QNetMMPruneTime) )
				SET @QNetMMPruneTime = @QNetMMStatPruneTime
			IF ( (@QNetMMDrvPruneTime >= @oneYear  )
 				AND (@QNetMMDrvPruneTime IS NOT NULL )
				AND (@QNetMMDrvPruneTime < @QNetMMPruneTime))
				SET @QNetMMPruneTime = @QNetMMDrvPruneTime
		IF (@QNetMMPruneTime IS NULL)
			SET	@QNetMMPruneTime = dateadd(day, - @DayHistoryPeriod, @CurrentUTCTime)
		RETURN (CASE WHEN (@QNetJobPruneTime < @oneYear) OR (@QNetMMPruneTime < @oneYear)
				THEN dbo.GetUnixTime(@oneYear)
				WHEN (@QNetJobPruneTime < @QNetMMPruneTime)
				THEN dbo.GetUnixTime(@QNetJobPruneTime)
				ELSE dbo.GetUnixTime(@QNetMMPruneTime)
			END)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetQNetPruneTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetQNetPruneTime' AND revision = '1.7')

  insert into GXDBVersions values(5, 'GetQNetPruneTime',  '1.7', 'GetQNetPruneTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientTimeZone.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientTimeZone'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientTimeZone]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientTimeZone]
  delete from GXDBVersions where name = 'GetClientTimeZone' and type = 5
END
GO

	CREATE FUNCTION GetClientTimeZone(@ChildID integer)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		--Get the timezone info from the APP_Client table
		DECLARE @attrv varchar(255)
		DECLARE @timeZoneName varchar(255)
		DECLARE @count int
		DECLARE @CHAR int
		DECLARE @position int
		DECLARE @length int
		DECLARE @client_status int
		BEGIN
			set @attrv = (select attrVal from APP_ClientProp WITH (READUNCOMMITTED) where componentNameId = @ChildID AND attrName = 'timezone' AND modified = 0)
		END
		IF (@attrv is null)
		BEGIN
			select @client_status = status from APP_Client where id = @ChildID
			IF (@client_status & 0x200000 = 0x200000)
				select @attrv = attrVal  from APP_ClientProp WITH (READUNCOMMITTED) where componentNameId = 2 AND attrName = 'timezone' AND modified = 0
			ELSE IF (@client_status & 0x0400 = 0x0400)
				select @attrv = attrVal  from APP_ClientProp WITH (READUNCOMMITTED) where componentNameId = 2 AND attrName = 'timezone' AND modified = 0
			ELSE IF (@client_status & 0x0200 = 0x0200)
				select @attrv = attrVal  from APP_ClientProp WITH (READUNCOMMITTED) where componentNameId = 2 AND attrName = 'timezone' AND modified = 0
			ELSE IF (@client_status & 0x0040 = 0x0040)
				select @attrv = attrVal  from APP_ClientProp WITH (READUNCOMMITTED) where componentNameId = 2 AND attrName = 'timezone' AND modified = 0
			ELSE IF (@client_status & 0x4000000 = 0x4000000)
				select @attrv = attrVal  from APP_ClientProp WITH (READUNCOMMITTED) where componentNameId = 2 AND attrName = 'timezone' AND modified = 0
			ELSE IF NOT EXISTS ( SELECT * FROM siminstalledPackages WITH (READUNCOMMITTED) where clientId = @ChildID) -- GET FOR ALL DUMMY CLIENTS
				select @attrv = attrVal  from APP_ClientProp WITH (READUNCOMMITTED) where componentNameId = 2 AND attrName = 'timezone' AND modified = 0
		END
		SET @CHAR = 1
		SET @count = 1
		SET @length = DATALENGTH(@attrv)
		SET @position = @length
		WHILE (@position > 0 AND  @CHAR <> 58)
			BEGIN
			SET @CHAR = ASCII(SUBSTRING(@attrv, @position, 1))
			SET @position = @position - 1
		END
		SET @timeZoneName =  RIGHT(@attrv,@length - @position-1)
		RETURN @timeZoneName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientTimeZone]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientTimeZone' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetClientTimeZone',  '1.3', 'GetClientTimeZone', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSubclientProp.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSubclientProp'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSubclientProp]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSubclientProp]
  delete from GXDBVersions where name = 'GetSubclientProp' and type = 5
END
GO

	CREATE FUNCTION GetSubclientProp(@ChildID integer, @propName NVARCHAR(1024))
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		--Get the timezone info from the APP_Client table
		DECLARE @attrv varchar(255)
		BEGIN
			select @attrv = attrVal  from APP_SubclientProp where componentNameId = @ChildID AND attrName = @propName AND modified = 0
		END
		RETURN @attrv
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSubclientProp]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSubclientProp' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetSubclientProp',  '1.1', 'GetSubclientProp', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetBackupsetProp.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetBackupsetProp'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetBackupsetProp]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetBackupsetProp]
  delete from GXDBVersions where name = 'GetBackupsetProp' and type = 5
END
GO

	CREATE FUNCTION GetBackupsetProp(@ChildID integer, @propName NVARCHAR(1024))
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		--Get the timezone info from the APP_Client table
		DECLARE @attrv varchar(255)
		BEGIN
			select @attrv = attrVal  from APP_BackupsetProp where componentNameId = @ChildID AND attrName = @propName AND modified = 0
		END
		RETURN @attrv
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetBackupsetProp]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetBackupsetProp' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetBackupsetProp',  '1.1', 'GetBackupsetProp', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSubTaskOption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSubTaskOption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSubTaskOption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSubTaskOption]
  delete from GXDBVersions where name = 'GetSubTaskOption' and type = 5
END
GO

	CREATE FUNCTION GetSubTaskOption(@taskId integer, @subTaskId integer, @optionId integer )
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @attrv NVARCHAR(1024)
		select @attrv = value from TM_SubTaskOptions where optionId = @optionId and subTaskId = @subTaskId
		IF @attrv IS NULL SET @attrv = dbo.GetDefaultOption(@optionId)
		RETURN @attrv
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSubTaskOption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSubTaskOption' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetSubTaskOption',  '1.4', 'GetSubTaskOption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsDayRollover.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsDayRollover'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsDayRollover]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsDayRollover]
  delete from GXDBVersions where name = 'IsDayRollover' and type = 5
END
GO

		CREATE FUNCTION IsDayRollOver (@DateArg int, @DayArg2 int)
		RETURNS INT
		AS
		BEGIN
			DECLARE @Date1 DATETIME
			DECLARE @Date2 DATETIME
			SET @Date1 = dbo.getDateTime(@DateArg)
			SET @Date2 = dbo.getDateTime(@DayArg2)
				IF (DATEPART(dy,@Date1) = DATEPART(dy,@Date2))
				RETURN 0
		RETURN 1

		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsDayRollover]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsDayRollover' AND revision = '1.2')

  insert into GXDBVersions values(5, 'IsDayRollover',  '1.2', 'IsDayRollover', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/JMGetKBArticlesForFailures.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: JMGetKBArticlesForFailures'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMGetKBArticlesForFailures]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[JMGetKBArticlesForFailures]
  delete from GXDBVersions where name = 'JMGetKBArticlesForFailures' and type = 5
END
GO

    CREATE FUNCTION [dbo].[JMGetKBArticlesForFailures]
    (
    	@failureReasonsList NVARCHAR(256),
    	@localeId			int = 0

    )
    RETURNS NVARCHAR(1024)
    AS
    BEGIN
       	DECLARE @startIndex		AS INT
       	DECLARE @endIndex		AS INT
       	DECLARE @retval			NVARCHAR(1024)
       	DECLARE @reasonId		BIGINT
       	DECLARE @msgId			bigint

       	DECLARE @cliVer			AS INT
       	DECLARE @serVer			AS INT
       	DECLARE @iDa			AS INT
       	DECLARE @opType			AS INT
       	DECLARE @phaseNum		AS INT
    	DECLARE @customMsgId	bigint

       	DECLARE @nameOpPhase	AS NVARCHAR(256)
       	DECLARE @opTableId		AS INT

       	SET @startIndex = 1
       	SET @endIndex   = 0
       	SET @retval		= N''

       	SET @retval = N''

       	if LEN(@failureReasonsList) > 0 BEGIN

       		SET @endIndex = CHARINDEX(',', @failureReasonsList, @startIndex)
       		IF  @endIndex IS NOT NULL AND @endIndex <> 0 BEGIN
       			WHILE @endIndex IS NOT NULL AND @endIndex <> 0 BEGIN
       				SET @reasonId = CONVERT( BIGINT, SUBSTRING(@failureReasonsList, @startIndex, @endIndex - @startIndex) )

       				SELECT @msgId		= JMFailureReasonMsg.messageId,
       					   @cliVer		= JMFailureReasonMsg.clientVersion,
       					   @serVer		= JMFailureReasonMsg.serverVersion,
       					   @iDa			= JMFailureReasonMsg.iDA,
       					   @opType		= JMFailureReasonMsg.opType,
       					   @phaseNum	= JMFailureReasonMsg.phaseNumber,
       					   @customMsgId = JMFailureReasonMsg.customMessageId

       				FROM   JMFailureReasonMsg INNER JOIN EvLocaleMsgs ON JMFailureReasonMsg.messageId = EvLocaleMsgs.MessageID
       				WHERE  (EvLocaleMsgs.hasKBArticle = 1)     AND
                           (EvLocaleMsgs.LocaleID = @localeId) AND
                           (JMFailureReasonMsg.id = @reasonId)

       				IF @msgId IS NOT NULL BEGIN
       					IF LEN( @retval ) > 0
       						SET @retval = @retval + ':'

       					IF @cliVer IS NOT NULL
       						SET @retval = @retval + N'cliver=' + CAST(@cliVer as NVARCHAR)     + CHAR(13)

       					IF @serVer IS NOT NULL
       						SET @retval = @retval + N'server=' + CAST(@serVer as NVARCHAR)     + CHAR(13)

       					IF 	@iDa IS NOT NULL
       						SET @retval = @retval + N'ida=' + CAST(@iDa as NVARCHAR)           + CHAR(13)

    					IF @opType IS NOT NULL
       						SET @retval = @retval + N'opType=' + CAST(@opType AS NVARCHAR) + CHAR(13)

    					IF @phaseNum IS NOT NULL
    						SET @retval = @retval + N'phaseNum=' + CAST(@phaseNum AS NVARCHAR) + CHAR(13)

       					SET @retval = @retval + N'messageId=' + CAST( @msgId AS NVARCHAR ) + CHAR(13)

    					SET @retval = @retval + N'customMessageId=' + CAST(@customMsgId AS NVARCHAR) + N';'

       				END

       				SET @msgId		 = NULL
       				SET @cliVer		 = NULL
       				SET @serVer		 = NULL
       				SET @iDa		 = NULL
       				SET @opType		 = NULL
       				SET @phaseNum	 = NULL
    				SET @customMsgId = NULL

       				SET @startIndex = @endIndex + 1
       				SET @endIndex = CHARINDEX(',', @failureReasonsList, @startIndex)
       			END
       		END

       	END

       	return @retval;

       END





GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [JMGetKBArticlesForFailures]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'JMGetKBArticlesForFailures' AND revision = '1.3')

  insert into GXDBVersions values(5, 'JMGetKBArticlesForFailures',  '1.3', 'JMGetKBArticlesForFailures', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2FUNC_GetGUIMediaAttributeString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2FUNC_GetGUIMediaAttributeString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2FUNC_GetGUIMediaAttributeString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2FUNC_GetGUIMediaAttributeString]
  delete from GXDBVersions where name = 'MMS2FUNC_GetGUIMediaAttributeString' and type = 5
END
GO

 			CREATE FUNCTION MMS2FUNC_GetGUIMediaAttributeString(@GAttr Integer)
 			RETURNS varchar(1024)
 			AS
 			BEGIN

 				IF (@GAttr = 0) RETURN ''

 				DECLARE @GAttrString  VARCHAR(1024)

 				-- MMS2_MULTIPLESIDED_MEDIA				16
 				-- MMS2_MAGNETIC_MEDIA						8
 				-- MMS2_RSM_MEDIA							1024


 				SET @GAttrString  = CASE	WHEN (@GAttr  & 8) > 0 THEN 'Mountpath, '
 											WHEN (@GAttr  & 16) > 0 THEN 'Optical Media, '
 											WHEN (@GAttr  & 1024) > 0 THEN 'RSM Media, '
 											WHEN (@GAttr  <> 0) THEN 'Tape Media, '
 											ELSE ', ' END

 				-- MMS2_STANDALONE_MEDIA					4
 				IF 	(@GAttr  & 4) > 0 	SET @GAttrString = @GAttrString  + 'Standalone, '

 				-- MMS2_DUPLICATE_MEDIA					131072
 				IF 	(@GAttr  & 131072) > 0	SET @GAttrString = @GAttrString  + 'Duplicate Barcode, '

 				-- MMS2_INVALID_BARCODE_MEDIA				1048576
 				IF 	(@GAttr  & 1048576) >0 	SET @GAttrString = @GAttrString  + 'Invalid Barcode, '

 				-- MMS2_NONGALAXY_MEDIA					524288
 				IF 	(@GAttr  & 524288) >0 	SET @GAttrString = @GAttrString  + 'Non Galaxy Media, '

 				-- MMS2_CLEANING_MEDIA					512
 				IF 	(@GAttr  & 512) > 0	SET @GAttrString = @GAttrString  + 'Cleaning Media, '

 				-- MMS2_ASSIGNED_MEDIA						1
 				IF 	(@GAttr  & 1) >0	SET @GAttrString = @GAttrString  + 'Assigned, '

 				-- MMS2_BAD_MEDIA							32
 				IF 	(@GAttr  & 32) >0 	SET @GAttrString = @GAttrString  + 'Bad, '
 				-- if tape (not optical)
 				-- MMS2_MEDIA_SIDEA_BAD					2048
 				-- MMS2_BAD_MEDIA							32
 				-- MMS2_MULTIPLESIDED_MEDIA				16
 				IF (@GAttr & (2048 | 32 | 16)) = 2048 SET @GAttrString = @GAttrString  + 'Bad, '

 				-- MMS2_DEPRECATED_MEDIA					64
 				IF 	(@GAttr  & 64) > 0	SET @GAttrString = @GAttrString  + 'Deprecated, '

 				-- MMS2_EXPORTED_MEDIA						2
 				IF 	(@GAttr  & 2) >0  	SET @GAttrString = @GAttrString  + 'Exported, '

 				-- MMS2_MEDIA_IN_WRONG_LIB					262144
 				IF 	(@GAttr  & 262144) >0  	SET @GAttrString = @GAttrString  + 'Wrong Library, '

 				-- 16777216 = MMS2_PINNED
 				IF 	(@GAttr  & 16777216) >0 	SET @GAttrString = @GAttrString  + 'Pinned, '

 				-- 8388608 = MMS2_AGED_MEDIA
 				IF 	(@GAttr  & 8388608) >0 SET @GAttrString = @GAttrString  + 'Aged, '

 				-- MMS2_MEDIA_SIDEA_ACTIVE					128
 				IF 	(@GAttr  & (128|8)) =128 	SET @GAttrString = @GAttrString  +
 							( CASE WHEN (@GAttr  & (16| 8)) = 16 THEN 'Side A ' ELSE '' END ) + 'Active, '

 				-- MMS2_MEDIA_SIDEA_FULL					256
 				IF 	(@GAttr  & (256|8)) = 256 	SET @GAttrString = @GAttrString  +
 							( CASE WHEN (@GAttr  & (16| 8)) = 16 THEN 'Side A ' ELSE '' END ) + 'Full, '

 				-- MMS2_MEDIA_SIDEA_BAD					2048
 				-- MMS2_MULTIPLESIDED_MEDIA				16
 				IF 	(@GAttr  & (2048 | 16 | 8) = (2048|16))	SET @GAttrString = @GAttrString  + 'Side A Bad, '

 				-- MMS2_MEDIA_SIDEA_RDONLY					4096
 				IF 	(@GAttr  & (4096 | 8)) = 4096 	SET @GAttrString = @GAttrString  +
 							( CASE WHEN (@GAttr  & (16| 8)) = 16 THEN 'Side A ' ELSE '' END ) + 'Read Only, '

 				-- MMS2_MEDIA_SIDEA_PARTIALLY_FULL			2097152
 				IF 	(@GAttr  & (2097152|8)) = 2097152 	SET @GAttrString = @GAttrString  +
 							( CASE WHEN (@GAttr  & (16| 8)) = 16 THEN 'Side A ' ELSE '' END ) + 'Appendable, '

 				-- MMS2_MEDIA_SIDEB_ACTIVE					8192
 				IF 	(@GAttr  & ( 8192 | 8)) = 8192 	SET @GAttrString = @GAttrString  + 'Side B Active, '

 				-- MMS2_MEDIA_SIDEB_FULL					16384
 				IF 	(@GAttr  & (16384|8)) =16384 	SET @GAttrString = @GAttrString  + 'Side B Full, '

 				-- MMS2_MEDIA_SIDEB_BAD					32768
 				IF 	(@GAttr  & 32768|8) = 32768 	SET @GAttrString = @GAttrString  + 'Side B Bad, '

 				-- MMS2_MEDIA_SIDEB_RDONLY					65536
 				IF 	(@GAttr  & (65536|8)) = 65536 	SET @GAttrString = @GAttrString  + 'Side B Read Only, '

 				-- MMS2_MEDIA_SIDEB_PARTIALLY_FULL			4194304
 				IF (@GAttr  & (4194304|8)) = 4194304	SET @GAttrString = @GAttrString  + 'Side B Read Appendable, '

 				RETURN case when @GAttrString <> '' then Substring(@GAttrString, 1, len(@GAttrString) - 1) else '' end

 			END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2FUNC_GetGUIMediaAttributeString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2FUNC_GetGUIMediaAttributeString' AND revision = '1.2')

  insert into GXDBVersions values(5, 'MMS2FUNC_GetGUIMediaAttributeString',  '1.2', 'MMS2FUNC_GetGUIMediaAttributeString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2FUNC_GetJobsForDrive.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2FUNC_GetJobsForDrive'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2FUNC_GetJobsForDrive]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2FUNC_GetJobsForDrive]
  delete from GXDBVersions where name = 'MMS2FUNC_GetJobsForDrive' and type = 5
END
GO

 			create function MMS2FUNC_GetJobsForDrive (@driveId Integer)
			returns varchar(1024)
			as
			begin

				if (@driveId <= 0) return ''

				declare @l_jobList Varchar(1024)
				set @l_jobList = ''

				SELECT @l_jobList = CASE
										WHEN jobId_l is not null then @l_jobList + cast (jobId_l as varchar(11)) + ', '
										ELSE 'Dangling resource, '
									END

				FROM MMResource R LEFT OUTER JOIN MMResourceToJob MRJ ON MRJ.ReservationId = R.ReservationId
				INNER JOIN MMDrive D ON R.DriveId = D.DriveId
				WHERE D.DriveTypeId <> 10001 AND  D.DriveId > 0 And d.driveId = @driveId

				RETURN case when @l_jobList <> '' then Substring(@l_jobList, 1, len(@l_jobList) - 1) else '' end

			end



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2FUNC_GetJobsForDrive]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2FUNC_GetJobsForDrive' AND revision = '1.2')

  insert into GXDBVersions values(5, 'MMS2FUNC_GetJobsForDrive',  '1.2', 'MMS2FUNC_GetJobsForDrive', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2FUNC_DecodeRetentionFlag.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2FUNC_DecodeRetentionFlag'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2FUNC_DecodeRetentionFlag]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2FUNC_DecodeRetentionFlag]
  delete from GXDBVersions where name = 'MMS2FUNC_DecodeRetentionFlag' and type = 5
END
GO

	CREATE FUNCTION MMS2FUNC_DecodeRetentionFlag (@i_CopyId Integer, @i_RetentionFlag Integer)
	RETURNS varchar(1024)
	AS
	BEGIN

		IF (@i_copyId = 0 OR @i_copyId is null OR @i_retentionFlag is null) RETURN ''


		IF (@i_RetentionFlag = 0)
		BEGIN

			DECLARE @l_basicRetDays INTEGER

			SELECT TOP 1  @l_basicRetDays = retentiondays
			FROM archagingrule
			WHERE copyid = @i_copyId

			IF (@l_basicRetDays is null) return ''

			RETURN 'Basic Retention (' +
					(	case when @l_basicRetDays < 0 then 'Infinite)'
						else cast (@l_basicRetDays as varchar(11)) + ' days)'
						end
					)
		END

		DECLARE @l_RetentionFlags VARCHAR(1024)
		SET @l_RetentionFlags = ''

		select @l_RetentionFlags = @l_RetentionFlags +
			case when (@i_retentionFlag & retentionRule) > 1 then
			(
				(	case retentionRule
						WHEN 2 then 'All '
						WHEN 4 then 'Weekly '
						WHEN 8 then 'Monthly '
						WHEN 16 then 'Quarterly '
						WHEN 32 then 'Semi annual '
						WHEN 64 then 'Annual '
						else ''
					end
				) + ' (' +
				(
					case when retentiondays > 0 then cast (retentiondays as varchar(11)) + ') days'
					else 'infinite)'
					end
				)
			) else '' end
			+ ', '
		from archagingruleextended
		where copyid = @i_copyid
		order by retentionrule desc

		RETURN case when @l_RetentionFlags <> '' then substring(@l_RetentionFlags,1,len(@l_RetentionFlags)-1) else '' end

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2FUNC_DecodeRetentionFlag]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2FUNC_DecodeRetentionFlag' AND revision = '1.2')

  insert into GXDBVersions values(5, 'MMS2FUNC_DecodeRetentionFlag',  '1.2', 'MMS2FUNC_DecodeRetentionFlag', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/isAdminJobVisible.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isAdminJobVisible'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isAdminJobVisible]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isAdminJobVisible]
  delete from GXDBVersions where name = 'isAdminJobVisible' and type = 5
END
GO

	CREATE FUNCTION isAdminJobVisible(@userid int, @commcellid int, @archGroupId int, @jobid int, @optype int, @clientId  int = 0)
	RETURNS INT
	AS
	BEGIN
		DECLARE @rowCount INT
		DECLARE @reqCapability INT
		DECLARE @isLibraryOperation INT
		DECLARE @workflowId INT = 0
		IF @optype = 90
		BEGIN
			SELECT @workflowId = ISNULL(attributeValueInt, 0) FROM JMJobOptions WHERE jobId = @jobId AND commCellId = @commcellId AND attributeId = 0 AND attributeName = 'workflowId'
		END
		-- MEDIAINVENTORY, TAPEERASE, DRIVEVALIDATION, DRIVECLEANING, STAMPMEDIA, CATALOGUEMEDIA
		IF @optype IN (21,32,41,42,46,47)
		BEGIN
			SET @isLibraryOperation = 1
			-- capabilities required to view an admin job are one of the following: Job Management, Administrative Management, Storage Policy Management, View
			-- POWER(2,EV_SCHEDULE_ADMIN-1) | POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_MANAGE_ARCHIVES-1) | POWER(2,EV_MANAGE_LIBRARY-1) | POWER(2,EV_VISIBILITY-1)
			SET @reqCapability = POWER(2,1-1) | POWER(2,16-1) | POWER(2,4-1) | POWER(2,8-1) | POWER(2,31-1)
		END
		ELSE
		BEGIN
			SET @isLibraryOperation = 0
			-- capabilities required to view an admin job are one of the following: Job Management, Administrative Management, Storage Policy Management, View
			-- POWER(2,EV_SCHEDULE_ADMIN-1) | POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_MANAGE_ARCHIVES-1) | POWER(2,EV_VISIBILITY-1)
			SET @reqCapability = POWER(2,1-1) | POWER(2,16-1) | POWER(2,4-1) | POWER(2,31-1)
		END
		SET @rowCount = (SELECT TOP 1 1 FROM UMUserCredentials WHERE @userid = userid AND (capabilities & @reqCapability) <> 0 AND
		((clientid=0 AND clientgroupid=0 AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND taskId = 0 AND vtContainerId=0 and vtPolicyId=0 and vtShelfId=0 and reviewSetId = 0 and querySetId = 0 and downloadSetId = 0 and tagId = 0 and legalHoldId = 0 and ermId = 0 and cdPolicyId = 0 and complianceReportId = 0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0) OR
		(@archGroupId <> 0 AND (@archGroupId = archGroupId OR archGroupId=-10)) OR
		(@workflowId>0 AND (workflowId=@workflowId OR workflowId=-10)) OR
		(@clientId>0 AND (@clientId = clientid OR clientId=-10) AND clientgroupid=0 AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND taskId = 0 AND vtContainerId=0 and vtPolicyId=0 and vtShelfId=0 and reviewSetId = 0 and querySetId = 0 and downloadSetId = 0 and tagId = 0 and legalHoldId = 0 and ermId = 0 and cdPolicyId = 0 and complianceReportId = 0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0)OR
		(@clientId>0 AND clientgroupId <> 0 AND EXISTS (SELECT TOP 1 * FROM APP_ClientGroupAssoc WHERE (APP_ClientGroupAssoc.clientGroupId = UMUserCredentials.clientGroupId OR UMUserCredentials.clientGroupId=-10) AND APP_ClientGroupAssoc.clientid=@clientid))))
		IF ISNULL(@rowCount,0) = 0
		BEGIN
			IF @isLibraryOperation = 1
			BEGIN
				SET @rowCount = (SELECT TOP 1 1 FROM UMUserCredentials WHERE @userid = userid AND (capabilities & @reqCapability) <> 0 AND
				(libraryId =-10 OR libraryId IN (SELECT attributeValueInt FROM JMJobOptions WHERE jobId = @jobId AND commCellId = @commcellId AND attributeId = 10)))
			END
		END
		RETURN ISNULL(@rowCount,0)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isAdminJobVisible]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isAdminJobVisible' AND revision = '1.13')

  insert into GXDBVersions values(5, 'isAdminJobVisible',  '1.13', 'isAdminJobVisible', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/isRstJobVisible.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isRstJobVisible'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isRstJobVisible]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isRstJobVisible]
  delete from GXDBVersions where name = 'isRstJobVisible' and type = 5
END
GO

	CREATE FUNCTION isRstJobVisible(@userid int, @commcellid int, @srcClientid int, @destClientid int, @apptypeid int, @instanceid int, @backupsetid int)
	RETURNS INT
	AS
	BEGIN
		DECLARE @rowCount INT
		DECLARE @reqCapability INT
		-- capabilities required to view a restore job are one of the following: Job Management, Browse and In Place and out of place Recover, View
		-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_VISIBILITY-1)
		SET @reqCapability = POWER(2,16-1) | POWER(2,20-1) | POWER(2,22-1) | POWER(2,31-1)
		SET @rowCount = (SELECT TOP 1 1 FROM UMUserCredentials WHERE @userid = userid AND (capabilities & @reqCapability) <> 0 AND
		((clientid=0 AND clientgroupid=0 AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND taskId = 0 AND vtContainerId=0 and vtPolicyId=0 and vtShelfId=0 and reviewSetId = 0 and querySetId = 0 and downloadSetId = 0 and tagId = 0 and legalHoldId = 0 and ermId = 0 and cdPolicyId = 0 and complianceReportId = 0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0 ) OR
		-- if you have the rights on the destination at any level then you will see the restore job
		(clientId=-10) OR
		(clientid=@destClientid) OR
		(clientid=@srcClientid AND apptypeid=0) OR
		(clientid=@srcClientid AND apptypeid=@apptypeid AND instanceid=0) OR
		(clientid=@srcClientid AND apptypeid=@apptypeid AND instanceid=@instanceid AND backupsetid=0) OR
		(clientid=@srcClientid AND apptypeid=@apptypeid AND instanceid=@instanceid AND backupsetid=@backupsetid AND subclientid=0) OR
		((clientgroupid <> 0 AND EXISTS (SELECT TOP 1 * FROM APP_ClientGroupAssoc WHERE (APP_ClientGroupAssoc.clientGroupId = UMUserCredentials.clientGroupId  OR UMUserCredentials.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=@srcClientid OR APP_ClientGroupAssoc.clientid=@destClientid))))))
		RETURN ISNULL(@rowCount,0)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isRstJobVisible]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isRstJobVisible' AND revision = '1.13')

  insert into GXDBVersions values(5, 'isRstJobVisible',  '1.13', 'isRstJobVisible', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/isBkpJobVisible.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isBkpJobVisible'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isBkpJobVisible]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isBkpJobVisible]
  delete from GXDBVersions where name = 'isBkpJobVisible' and type = 5
END
GO

	CREATE FUNCTION isBkpJobVisible(@userid int, @commcellid int, @clientid int, @apptypeid int, @instanceid int, @backupsetid int, @subclientid int)
	RETURNS INT
	AS
	BEGIN
		DECLARE @rowCount INT
		DECLARE @reqCapability INT
		-- capabilities required to view a backup job are one of the following: Job Management, Data Protection Operations, Browse and In Place Recover, Browse and Out of Place Recover, Browse, Report Management, View
		-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_BACKUP-1)| POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_BROWSE-1)| POWER(2,EV_RUN_REPORTS-1) | POWER(2,EV_VISIBILITY-1)
		SET @reqCapability = POWER(2,16-1) | POWER(2,12-1) | POWER(2,20-1) | POWER(2,22-1) | POWER(2,13-1) | POWER(2,15-1) | POWER(2,31-1)
		-- need only one row that matches the required capability
		SET @rowCount = (SELECT TOP 1 1 FROM UMUserCredentials WHERE @userid = userid AND (capabilities & @reqCapability) <> 0 AND
		((clientid=0 AND clientgroupid=0 AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND taskId = 0 AND vtContainerId=0 and vtPolicyId=0 and vtShelfId=0 and reviewSetId = 0 and querySetId = 0 and downloadSetId = 0 and tagId = 0 and legalHoldId = 0 and ermId = 0 and cdPolicyId = 0 and complianceReportId = 0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0 ) OR
		(clientid=-10) OR
		(clientid=@clientid AND apptypeid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=@instanceid AND backupsetid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=@instanceid AND backupsetid=@backupsetid AND subclientid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=@instanceid AND backupsetid=@backupsetid AND subclientid=@subclientid) OR
		(clientgroupid <> 0 AND EXISTS (SELECT TOP 1 * FROM APP_ClientGroupAssoc WHERE (APP_ClientGroupAssoc.clientGroupId = UMUserCredentials.clientGroupId OR UMUserCredentials.clientGroupId=-10) AND APP_ClientGroupAssoc.clientid=@clientid))))
		RETURN ISNULL(@rowCount,0)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isBkpJobVisible]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isBkpJobVisible' AND revision = '1.14')

  insert into GXDBVersions values(5, 'isBkpJobVisible',  '1.14', 'isBkpJobVisible', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/isVisible.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isVisible'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isVisible]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isVisible]
  delete from GXDBVersions where name = 'isVisible' and type = 5
END
GO

	CREATE FUNCTION isVisible(@inUserid int, @inJobid int, @inCommcellid INT, @inClientid INT, @eventUserId INT, @libraryId INT = 0, @maClientId INT = 0, @mediaId INT = 0, @driveId INT = 0)
	RETURNS INT
	AS
	BEGIN

	IF @inUserId = 0 OR @eventUserId = @inUserId
	BEGIN
		-- no need to check visiblity
		RETURN 1
	END

	IF @inJobid <> 0 -- check the visibility of the job if the job id is passed in
	BEGIN
		DECLARE @isJobRunning		INT
		DECLARE @jobCategory		INT
		DECLARE @jobStartedBy		INT
		DECLARE @jobStartedByUser	varchar(255)

		DECLARE @srcClientid	INT
		DECLARE @destClientid	INT
		DECLARE @apptypeid		INT
		DECLARE @instanceid		INT
		DECLARE @backupsetid	INT
		DECLARE @subclientid	INT
		DECLARE @archGroupid	INT
		DECLARE @opType			INT
		DECLARE @userName		varchar(255)

		-- check if the job is running or completed so that the appropriate table can be checked
		SELECT @jobCategory = JMJobStats.jobCategory, @isJobRunning = CASE status WHEN 1 THEN 1 ELSE 0 END FROM JMJobStats WHERE jobid = @inJobid AND commcellid = @inCommcellId
		IF @isJobRunning IS NULL
		BEGIN
			-- the job id was not found. So return false
			RETURN 0
		END
		ELSE IF @isJobRunning = 1
		BEGIN
			-- this is a running job.
			IF @jobCategory = 1 -- this is a running backup job
			BEGIN
				SELECT @jobStartedBy = userid, @srcClientid = clientid, @apptypeid = apptypeid, @instanceid = instance, @backupsetid = backupset, @subclientid = applicationid FROM RunningBackups WHERE jobid = @inJobid AND commcellId = @inCommcellId
				IF @@ROWCOUNT = 0
				BEGIN
					-- if the row cannot be found then return error.
					RETURN 0
				END
				ELSE
				BEGIN
					-- at least one of the capabilities are needed to see a backup job
					IF @jobStartedBy = @inUserid OR dbo.isBkpJobVisible(@inUserid,@inCommcellId,@srcClientid,@apptypeid,@instanceid,@backupsetid,@subclientid)=1
						RETURN 1
					ELSE
						RETURN 0
				END
			END
			ELSE IF @jobCategory = 2 -- this is a running restore job
			BEGIN
				SELECT @jobStartedBy = userid, @srcClientid = srcClientid, @destClientid = destClientid, @apptypeid = apptype, @instanceid = instanceid, @backupsetid = bkpSetId FROM RunningRestores WHERE jobid = @inJobid AND commcellId = @inCommcellId
				IF @@ROWCOUNT = 0
				BEGIN
					-- if the row cannot be found then return error.
					RETURN 0
				END
				ELSE
				BEGIN
					-- at least one of the capabilities are needed to see a restore job
					-- the user can have rights on either the source or the destination client id
					IF @jobStartedBy = @inUserId OR dbo.isRstJobVisible(@inUserId,@inCommcellId,@srcClientid,@destClientId,@apptypeid,@instanceid,@backupsetid)=1
						RETURN 1
					ELSE
						RETURN 0
				END
			END
			ELSE -- this is a running admin job
			BEGIN
				SELECT @jobStartedBy = userid, @archGroupid = archGrpId, @opType = opType FROM RunningAdminJobs WHERE jobid = @inJobid AND commcellId = @inCommcellId
				IF @@ROWCOUNT = 0
				BEGIN
					-- if the row cannot be found then return error.
					RETURN 0
				END
				ELSE
				BEGIN
					IF @jobStartedBy = @inUserId OR dbo.isAdminJobVisible(@inUserId,@inCommcellId,@archGroupid,@inJobid,@opType,0)=1
						RETURN 1
					ELSE
						RETURN 0
				END
			END
		END
		ELSE
		BEGIN
			-- this is a completed job.
			SET @userName = ISNULL((SELECT [login] FROM UMUsers WHERE id = @inUserId),'')

			IF @jobCategory = 1 -- this is a completed backup job
			BEGIN
				SELECT @jobStartedByUser = username, @srcClientid = App_Application.clientid, @apptypeid = App_Application.apptypeid, @instanceid = App_Application.instance, @backupsetid = App_Application.backupset, @subclientid = appId FROM JMBkpStats, App_Application WHERE jobid = @inJobid AND commcellId = @inCommcellId AND JMBkpStats.appId = App_Application.id
				IF @@ROWCOUNT = 0
				BEGIN
					-- if the row cannot be found then return error. However if the user id matches then return true for that USER
					RETURN 0
				END
				ELSE
				BEGIN
					-- at least one of the capabilities are needed to see a backup job
					IF @userName = @jobStartedByUser OR dbo.isBkpJobVisible(@inUserid,@inCommcellId,@srcClientid,@apptypeid,@instanceid,@backupsetid,@subclientid)=1
						RETURN 1
					ELSE
						RETURN 0
				END
			END
			ELSE IF @jobCategory = 2 -- this is a completed restore job
			BEGIN
				SELECT @jobStartedByUser = username, @srcClientid = srcClientid, @destClientid = destClientid, @apptypeid = apptype, @instanceid = instanceid, @backupsetid = bkpSetID FROM JMRestoreStats WHERE jobid = @inJobid AND commcellId = @inCommcellId
				IF @@ROWCOUNT = 0
				BEGIN
					-- if the row cannot be found then return error.
					RETURN 0
				END
				ELSE
				BEGIN
					-- at least one of the capabilities are needed to see a restore job
					-- the user can have rights on either the source or the destination client id
					IF @userName = @jobStartedByUser OR dbo.isRstJobVisible(@inUserId,@inCommcellId,@srcClientid,@destClientId,@apptypeid,@instanceid,@backupsetid)=1
						RETURN 1
					ELSE
						RETURN 0
				END
			END
			ELSE -- this is a completed admin job
			BEGIN
				SELECT @jobStartedByUser = username, @archGroupid = archGrpId, @opType = opType FROM JMAdminJobStatsTable WHERE jobid = @inJobid AND commcellId = @inCommcellId
				IF @@ROWCOUNT = 0
				BEGIN
					-- For admin jobs if the row cannot be found then ignore the user name and just check commcell level priveledges.
					IF dbo.isAdminJobVisible(@inUserId,@inCommcellId,0,@inJobid,@opType,0)=1
						RETURN 1
					ELSE
						RETURN 0
				END
				ELSE
				BEGIN
					IF @userName = @jobStartedByUser OR dbo.isAdminJobVisible(@inUserId,@inCommcellId,@archGroupid,@inJobid,@opType,0)=1
						RETURN 1
					ELSE
						RETURN 0
				END
			END
		END
	END
	ELSE
	BEGIN
		IF @inClientId = 0
		BEGIN
			SET @inClientId = 2 -- current commcellid
		END

		-- now check for visibility of this client. If the user has any rights on this client then he can see events from this client
		IF dbo.isClientVisible(@inUserId,@inClientId,@libraryId,@maClientId,@mediaId,@driveId)=1
			RETURN 1
		ELSE
			RETURN 0
	END
	RETURN 0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isVisible]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isVisible' AND revision = '1.5')

  insert into GXDBVersions values(5, 'isVisible',  '1.5', 'isVisible', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/isClientVisible.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isClientVisible'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isClientVisible]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isClientVisible]
  delete from GXDBVersions where name = 'isClientVisible' and type = 5
END
GO

	CREATE FUNCTION isClientVisible(@inUserid INT, @inClientId INT, @libraryId INT = 0, @maClientId INT = 0, @mediaId INT = 0, @driveId INT = 0)
	RETURNS INT
	AS
	BEGIN
		DECLARE @rowCount INT
		SET @rowCount = (SELECT TOP 1 1 FROM UMUserCredentials WITH (NOLOCK) WHERE @inUserid = userid AND capabilities <> 0 AND
			( ( (commcellid=@inClientId OR commcellid=@maClientId) AND clientid=0 AND clientgroupid=0 AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND vtContainerId=0 and vtPolicyId=0 and vtShelfId=0 and reviewSetId = 0 and querySetId = 0 and downloadSetId = 0 and tagId = 0 and legalHoldId = 0 and ermId = 0 and cdPolicyId = 0 and complianceReportId = 0 and taskId = 0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0)
		  OR ( (commcellid=2 AND clientid=0 AND clientgroupid=0 AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 and vtContainerId=0 and vtPolicyId=0 and vtShelfId=0 and reviewSetId = 0 and querySetId = 0 and downloadSetId = 0 and tagId = 0 and legalHoldId = 0 and ermId = 0 and cdPolicyId = 0 and complianceReportId = 0 and taskId = 0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0)) -- will be true if the user has any commcell level capabilities
		  OR (@inClientId<>0 OR @maClientId<>0 AND clientId=-10)
		  OR ( (clientid=@inClientId OR mediaAgentId=@inClientId OR (@maClientId <> 0 AND (mediaAgentId=@maClientId OR mediaAgentId=-10))) AND clientgroupid=0 AND libraryId=0 AND archGroupId=0) OR
		(@libraryId <> 0 AND libraryId = @libraryId) OR
		(clientgroupid <> 0 AND EXISTS (SELECT TOP 1 * FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = UMUserCredentials.clientGroupId OR UMUserCredentials.clientGroupId=-10) AND (clientid=@inClientId OR clientId=@maClientId)))))
		RETURN ISNULL(@rowCount,0)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isClientVisible]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isClientVisible' AND revision = '1.9')

  insert into GXDBVersions values(5, 'isClientVisible',  '1.9', 'isClientVisible', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/SplitIDs.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SplitIDs'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SplitIDs]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SplitIDs]
  delete from GXDBVersions where name = 'SplitIDs' and type = 5
END
GO

	CREATE FUNCTION dbo.SplitIDs
	(
		@IDsList varchar(max)
	)
	RETURNS
	@ParsedList table
	(
		_ID bigint
	)
	AS
	BEGIN
		DECLARE @_ID varchar(64), @Pos int
		SET @IDsList = LTRIM(RTRIM(@IDsList))+ ','
		SET @Pos = CHARINDEX(',', @IDsList, 1)
		IF REPLACE(@IDsList, ',', '') <> ''
		BEGIN
			WHILE @Pos > 0
			BEGIN
				SET @_ID = LTRIM(RTRIM(LEFT(@IDsList, @Pos - 1)))
				IF @_ID <> ''
				BEGIN
					INSERT INTO @ParsedList (_ID)
					VALUES (CAST(@_ID AS bigint)) --Use Appropriate conversion
				END
				SET @IDsList = RIGHT(@IDsList, LEN(@IDsList) - @Pos)
				SET @Pos = CHARINDEX(',', @IDsList, 1)
			END
		END
		RETURN
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SplitIDs]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SplitIDs' AND revision = '1.3')

  insert into GXDBVersions values(5, 'SplitIDs',  '1.3', 'SplitIDs', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientMangledHostName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientMangledHostName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientMangledHostName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientMangledHostName]
  delete from GXDBVersions where name = 'GetClientMangledHostName' and type = 5
END
GO

	CREATE FUNCTION GetClientMangledHostName(@clientId	INTEGER, @intName varchar(255) = NULL)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @mangledHostName varchar(255)
	IF (@intName IS NULL)
	BEGIN
		 SELECT @mangledHostName = Net_HostName + '*' + Name + '*' + CAST(CVDPort AS varchar(10)) + '*' + CAST(EvmgrcPort AS varchar(10))
		 from App_client WITH (READUNCOMMITTED) where id = @clientId
	END
	ELSE BEGIN
	(select @mangledHostName = @intName + '*' + Name + '*' + CAST(CVDPort AS varchar(10)) + '*' + CAST(EvmgrcPort AS varchar(10))
			from App_client WITH (READUNCOMMITTED) where id = @clientId)
	END

		RETURN @mangledHostName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientMangledHostName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientMangledHostName' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetClientMangledHostName',  '1.4', 'GetClientMangledHostName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetCompactDateTimeString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetCompactDateTimeString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetCompactDateTimeString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetCompactDateTimeString]
  delete from GXDBVersions where name = 'GetCompactDateTimeString' and type = 5
END
GO

	CREATE FUNCTION GetCompactDateTimeString (@DTarg DATETIME)
	RETURNS char(12)
	WITH ENCRYPTION
	AS
	BEGIN
	 	return CONVERT(CHAR(2),DATEPART(hour,@DTarg))+':'+CONVERT(CHAR(2),DATEPART(minute,@DTarg))+':'+CONVERT(CHAR(2),DATEPART(second,@DTarg))+':'+CONVERT(CHAR(3),DATEPART(ms,@DTarg))
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetCompactDateTimeString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetCompactDateTimeString' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetCompactDateTimeString',  '1.1', 'GetCompactDateTimeString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetMediaLocation.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetMediaLocation'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetMediaLocation]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetMediaLocation]
  delete from GXDBVersions where name = 'GetMediaLocation' and type = 5
END
GO

	CREATE FUNCTION GetMediaLocation(@MediaId integer, @MediaLocation integer, @LibraryId integer, @ExportLocationId integer)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @location NVARCHAR(1024)
		set @location = 'Not Available'
		if @MediaLocation = 1 and @LibraryId > 0
			SELECT @location = isnull(AliasName, 'Not Available') from MMLibrary where LibraryId = @LibraryId
		if @MediaLocation = 2
			SELECT @location = isnull(DriveName, 'Not Available') from MMDrive where MediaId = @MediaId
		if @MediaLocation = 3 and @ExportLocationId > 0
			SELECT @location = isnull(ExportLocation, 'Not Available') from MMExportLocation where ExportLocationId = @ExportLocationId
		RETURN @location
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetMediaLocation]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetMediaLocation' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetMediaLocation',  '1.1', 'GetMediaLocation', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobOption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobOption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobOption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobOption]
  delete from GXDBVersions where name = 'GetJobOption' and type = 5
END
GO

	CREATE FUNCTION GetJobOption(@jobId bigint, @optionId bigint )
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @refTime	INT
		SELECT TOP 1 @taskId=taskId, @subTaskId=subTaskId, @refTime=created FROM TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WHERE jobId=@jobId)
		--Get the option value from the TM_JobOptions table
		DECLARE @attrv NVARCHAR(MAX)
		SELECT @attrv = value FROM TM_JobOptions WITH (READUNCOMMITTED) WHERE (jobId=@jobId OR
			(jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime)))
		AND optionId = @optionId
		--select @attrv = value from TM_JobOptions where jobId = @jobId AND optionId = @optionId
		IF @attrv IS NULL SET @attrv = dbo.GetDefaultOption(@optionId)
		RETURN @attrv
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobOption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobOption' AND revision = '1.10')

  insert into GXDBVersions values(5, 'GetJobOption',  '1.10', 'GetJobOption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDefaultOption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDefaultOption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDefaultOption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDefaultOption]
  delete from GXDBVersions where name = 'GetDefaultOption' and type = 5
END
GO

	CREATE FUNCTION GetDefaultOption(@optionId integer )
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		--Get the default value from the TM_StaticTaskOption table
		DECLARE @attrv NVARCHAR(1024)
			select @attrv = defVal from TM_StaticTaskOption where optionId = @optionId
		RETURN @attrv
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDefaultOption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDefaultOption' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetDefaultOption',  '1.1', 'GetDefaultOption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetOptionString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetOptionString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetOptionString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetOptionString]
  delete from GXDBVersions where name = 'GetOptionString' and type = 5
END
GO

	CREATE FUNCTION GetOptionString(@optionId integer, @jobId integer, @taskId integer, @subTaskId integer)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @retVal NVARCHAR(1024)
		--Get the option value
		IF @jobId = 0
			SET @retVal = dbo.GetSubTaskOption(@taskId, @subTaskId, @optionId)
		ELSE
			SET @retVal = dbo.GetJobOption(@jobId, @optionId)
		RETURN @retVal
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetOptionString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetOptionString' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetOptionString',  '1.1', 'GetOptionString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetOptionInt.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetOptionInt'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetOptionInt]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetOptionInt]
  delete from GXDBVersions where name = 'GetOptionInt' and type = 5
END
GO

	CREATE FUNCTION GetOptionInt(@optionId integer, @jobId bigint, @taskId integer, @subTaskId integer)
	RETURNS INT
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @ret INT
		--Get the option value from the TM_JobOptions table
		IF @jobId = 0
			SET @ret = CONVERT(INT, dbo.GetSubTaskOption(@taskId, @subTaskId, @optionId))
		ELSE
			SET @ret = CONVERT(INT, dbo.GetJobOption(@jobId, @optionId))
		RETURN @ret
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetOptionInt]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetOptionInt' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetOptionInt',  '1.1', 'GetOptionInt', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetOptionBool.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetOptionBool'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetOptionBool]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetOptionBool]
  delete from GXDBVersions where name = 'GetOptionBool' and type = 5
END
GO

	CREATE FUNCTION GetOptionBool(@optionId integer, @jobId bigint, @taskId integer, @subTaskId integer)
	RETURNS INT
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @retVal INT
		--Get the option value
		IF @jobId = 0
			SET @retVal = CONVERT(INT, dbo.GetSubTaskOption(@taskId, @subTaskId, @optionId))
		ELSE
			SET @retVal = CONVERT(INT, dbo.GetJobOption(@jobId, @optionId))
		IF @retVal != 0
			SET @retVal = 1
		RETURN @retVal
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetOptionBool]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetOptionBool' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetOptionBool',  '1.1', 'GetOptionBool', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetOptionLong.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetOptionLong'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetOptionLong]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetOptionLong]
  delete from GXDBVersions where name = 'GetOptionLong' and type = 5
END
GO

	CREATE FUNCTION GetOptionLong(@optionId integer, @jobId bigint, @taskId integer, @subTaskId integer)
	RETURNS BIGINT
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @ret BIGINT
		--Get the option value
		IF @jobId = 0
			SET @ret = CONVERT(BIGINT, dbo.GetSubTaskOption(@taskId, @subTaskId, @optionId))
		ELSE
			SET @ret = CONVERT(BIGINT, dbo.GetJobOption(@jobId, @optionId))
		RETURN @ret
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetOptionLong]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetOptionLong' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetOptionLong',  '1.2', 'GetOptionLong', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobOptionList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobOptionList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobOptionList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobOptionList]
  delete from GXDBVersions where name = 'GetJobOptionList' and type = 5
END
GO

	CREATE FUNCTION GetJobOptionList(@jobId bigint, @optionId bigint)
	RETURNS
	@listTbl table (value NVARCHAR(MAX))
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @refTime	INT
		SELECT @taskId=taskId, @subTaskId=subTaskId, @refTime=created from TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WHERE jobId=@jobId)
		--Get the list of option values from the TM_JobOptions table
		INSERT INTO @listTbl SELECT value FROM TM_JobOptions WITH (READUNCOMMITTED) WHERE (jobId=@jobId OR
			(jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime)))
			AND optionId = @optionId
		--INSERT INTO @listTbl SELECT value FROM TM_JobOptions WHERE jobId = @jobId AND optionId = @optionId
		RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobOptionList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobOptionList' AND revision = '1.8')

  insert into GXDBVersions values(5, 'GetJobOptionList',  '1.8', 'GetJobOptionList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetAllJobOptions.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAllJobOptions'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAllJobOptions]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAllJobOptions]
  delete from GXDBVersions where name = 'GetAllJobOptions' and type = 5
END
GO

	CREATE FUNCTION GetAllJobOptions(@jobId bigint)
	RETURNS
	@listTbl table (optionId bigint, value NVARCHAR(MAX), type INT)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @refTime	INT
		SELECT TOP 1 @taskId=taskId, @subTaskId=subTaskId, @refTime=created FROM TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WITH (READUNCOMMITTED) WHERE jobId=@jobId)
		--Get the list of option values from the TM_JobOptions table
		INSERT INTO @listTbl
		SELECT DISTINCT optionId, value, type FROM TM_JobOptions WITH (READUNCOMMITTED) WHERE (jobId=@jobId)
		UNION ALL
		SELECT DISTINCT optionId, value, type FROM TM_JobOptions AS TJ WITH (READUNCOMMITTED) WHERE (
				(jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime))
			) AND
			NOT EXISTS(SELECT * FROM TM_JobOptions AS LT WITH (READUNCOMMITTED) WHERE (jobId=@jobId) AND LT.optionId = TJ.optionId)
		RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAllJobOptions]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAllJobOptions' AND revision = '1.12')

  insert into GXDBVersions values(5, 'GetAllJobOptions',  '1.12', 'GetAllJobOptions', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetXMLJobOptions.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetXMLJobOptions'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetXMLJobOptions]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetXMLJobOptions]
  delete from GXDBVersions where name = 'GetXMLJobOptions' and type = 5
END
GO

	CREATE FUNCTION GetXMLJobOptions(@jobId bigint)
	RETURNS XML
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @xmlText	XML
		DECLARE @refTime	INT
		SELECT TOP 1 @taskId=[taskId], @subTaskId=[subTaskId], @refTime=[created] FROM TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WITH (READUNCOMMITTED) WHERE [jobId]=@jobId)
		--GET THE LIST OF OPTION VALUES FROM THE TM_JOBXMLOPTIONS TABLE
		SET @xmlText =
		(
				SELECT xmlValue FROM TM_JobXMLOptions WITH (READUNCOMMITTED) WHERE (jobId=@jobId)
				UNION ALL		--ONLY ONE QUERY WILL RETURN OUTPUT BUT UNION ALL IS NEEDED BECAUSE XML CANNOT BE DISTINCT
				SELECT xmlValue FROM TM_JobXMLOptions AS TJ WITH (READUNCOMMITTED) WHERE (
					(jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime))
				) AND
				NOT EXISTS(SELECT * FROM TM_JobXMLOptions AS LT WITH (READUNCOMMITTED) WHERE (jobId=@jobId))
		)
		RETURN @xmlText
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetXMLJobOptions]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetXMLJobOptions' AND revision = '1.10')

  insert into GXDBVersions values(5, 'GetXMLJobOptions',  '1.10', 'GetXMLJobOptions', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSubTaskOptionList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSubTaskOptionList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSubTaskOptionList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSubTaskOptionList]
  delete from GXDBVersions where name = 'GetSubTaskOptionList' and type = 5
END
GO

	CREATE FUNCTION GetSubTaskOptionList(@taskId integer, @subTaskId integer, @optionId integer)
	RETURNS
	@listTbl table (value NVARCHAR(1024))
	WITH ENCRYPTION
	AS
	BEGIN
		--Get the list of option values from the TM_SubTaskOptions table
		INSERT INTO @listTbl SELECT value FROM TM_SubTaskOptions WHERE optionId = @optionId AND subTaskId = @subTaskId
		RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSubTaskOptionList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSubTaskOptionList' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetSubTaskOptionList',  '1.3', 'GetSubTaskOptionList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetOptionListString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetOptionListString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetOptionListString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetOptionListString]
  delete from GXDBVersions where name = 'GetOptionListString' and type = 5
END
GO

	CREATE FUNCTION GetOptionListString(@optionId integer, @jobId bigint, @taskId integer, @subTaskId integer)
	RETURNS
	@listTbl table (value NVARCHAR(1024))
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @ret INT
		--Get the option value
		IF @jobId = 0
			INSERT INTO @listTbl SELECT value FROM dbo.GetSubTaskOptionList(@taskId, @subTaskId, @optionId)
		ELSE
			INSERT INTO @listTbl SELECT value FROM dbo.GetJobOptionList(@jobId, @optionId)
		RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetOptionListString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetOptionListString' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetOptionListString',  '1.1', 'GetOptionListString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetOptionListInt.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetOptionListInt'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetOptionListInt]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetOptionListInt]
  delete from GXDBVersions where name = 'GetOptionListInt' and type = 5
END
GO

	CREATE FUNCTION GetOptionListInt(@optionId integer, @jobId bigint, @taskId integer, @subTaskId integer)
	RETURNS
	@listTbl table (value INT)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @ret INT
		--Get the option value
		IF @jobId = 0
			INSERT INTO @listTbl SELECT CAST(value AS INT) FROM dbo.GetSubTaskOptionList(@taskId, @subTaskId, @optionId)
		ELSE
			INSERT INTO @listTbl SELECT CAST(value AS INT) FROM dbo.GetJobOptionList(@jobId, @optionId)
		RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetOptionListInt]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetOptionListInt' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetOptionListInt',  '1.1', 'GetOptionListInt', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetOptionListLong.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetOptionListLong'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetOptionListLong]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetOptionListLong]
  delete from GXDBVersions where name = 'GetOptionListLong' and type = 5
END
GO

	CREATE FUNCTION GetOptionListLong(@optionId integer, @jobId bigint, @taskId integer, @subTaskId integer)
	RETURNS
	@listTbl table (value BIGINT)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @ret INT
		--Get the option value
		IF @jobId = 0
			INSERT INTO @listTbl SELECT CAST(value AS BIGINT) FROM dbo.GetSubTaskOptionList(@taskId, @subTaskId, @optionId)
		ELSE
			INSERT INTO @listTbl SELECT CAST(value AS BIGINT) FROM dbo.GetJobOptionList(@jobId, @optionId)
		RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetOptionListLong]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetOptionListLong' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetOptionListLong',  '1.1', 'GetOptionListLong', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/BuildSubTaskExtOption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BuildSubTaskExtOption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BuildSubTaskExtOption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BuildSubTaskExtOption]
  delete from GXDBVersions where name = 'BuildSubTaskExtOption' and type = 5
END
GO

	CREATE FUNCTION BuildSubTaskExtOption(@taskId integer, @subTaskId integer, @optionType integer )
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @sOption		VARCHAR(MAX)
		DECLARE @maxBit			INT
		DECLARE @staticTbl		TABLE (optionId INT, defVAl INT, bitVal INT)
		DECLARE @optionTbl		TABLE (optionId INT, optVal INT)
		DECLARE @optionIdTbl	TABLE (optionId INT)
		DECLARE @defVal			INT
		DECLARE	@bitVal			INT
		DECLARE @count			INT
		SET @count = 0
		SET @sOption = ''
		SET @maxBit = (SELECT TOP (1) bitVal FROM TM_StaticTaskOption WHERE flagType = @optionType ORDER BY bitVal DESC)
		INSERT INTO @staticTbl SELECT optionId, defVal, bitVal FROM TM_StaticTaskOption WHERE flagType = @optionType ORDER BY bitVal
		WHILE @count <= @maxBit
		BEGIN
			--CLEAR TEMP TABLE
			DELETE @optionIdTbl
			--GET THE OPTION ID
			INSERT INTO @optionIdTbl SELECT optionId FROM @staticTbl WHERE bitVal = @count
			--GET THE DEFAULT VALUE
			SET @bitVal = ISNULL((SELECT TOP(1) defVAl FROM @staticTbl WHERE bitVal = @count), 0)
			--GET THE OPTION VALUE
			SET @bitVal = ISNULL((SELECT TOP(1) value FROM TM_SubTaskOptions WHERE optionId IN (SELECT optionId FROM @optionIdTbl) AND
									subTaskId = @subTaskId), @bitVal)
			SET @sOption = @sOption + CAST(@bitVal AS CHAR(1))
			SET @count = @count + 1
		END
		RETURN @sOption
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BuildSubTaskExtOption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BuildSubTaskExtOption' AND revision = '1.4')

  insert into GXDBVersions values(5, 'BuildSubTaskExtOption',  '1.4', 'BuildSubTaskExtOption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/BuildSubTaskOption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BuildSubTaskOption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BuildSubTaskOption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BuildSubTaskOption]
  delete from GXDBVersions where name = 'BuildSubTaskOption' and type = 5
END
GO

	CREATE FUNCTION BuildSubTaskOption(@taskId integer, @subTaskId integer, @optionType integer )
	RETURNS BIGINT
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @bitOption		BIGINT
		DECLARE @bitLOption		VARBINARY(MAX)
		DECLARE @bitHOption		VARBINARY(MAX)
		DECLARE @maxBit			INT
		DECLARE @staticTbl		TABLE (optionId INT, defVAl INT, bitVal INT)
		DECLARE @optionTbl		TABLE (optionId INT, optVal INT)
		DECLARE @optionIdTbl	TABLE (optionId INT)
		DECLARE @defVal			INT
		DECLARE	@bitVal			INT
		DECLARE @count			INT
		SET @count = 0
		SET @bitLOption = 0
		SET @bitHOption = 0
		SET @bitOption = 0
		SET @maxBit = (SELECT TOP (1) bitVal FROM TM_StaticTaskOption WHERE flagType = @optionType ORDER BY bitVal DESC)
		INSERT INTO @staticTbl SELECT optionId, defVal, bitVal FROM TM_StaticTaskOption WHERE flagType = @optionType ORDER BY bitVal
		WHILE @count <= @maxBit
		BEGIN
			--CLEAR TEMP TABLE
			DELETE @optionIdTbl
			--GET THE OPTION ID
			INSERT INTO @optionIdTbl SELECT optionId FROM @staticTbl WHERE bitVal = @count
			--GET THE DEFAULT VALUE
			SET @bitVal = ISNULL((SELECT TOP(1) defVAl FROM @staticTbl WHERE bitVal = @count), 0)
			--GET THE OPTION VALUE
			SET @bitVal = ISNULL((SELECT TOP(1) value FROM TM_SubTaskOptions WHERE optionId IN (SELECT optionId FROM @optionIdTbl) AND
									subTaskId = @subTaskId), @bitVal)
			IF @bitVal != 0
				IF @count < 31
					SET @bitLOption = @bitLOption + POWER(2, @count)
				ELSE
					SET @bitHOption = @bitHOption + POWER(2, @count-31)
			SET @count = @count + 1
		END
		SET @bitOption = dbo.GetBigIntFromInt(@bitHOption, @bitLOption)
		RETURN @bitOption
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BuildSubTaskOption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BuildSubTaskOption' AND revision = '1.6')

  insert into GXDBVersions values(5, 'BuildSubTaskOption',  '1.6', 'BuildSubTaskOption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/BuildJobExtOption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BuildJobExtOption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BuildJobExtOption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BuildJobExtOption]
  delete from GXDBVersions where name = 'BuildJobExtOption' and type = 5
END
GO

	CREATE FUNCTION BuildJobExtOption(@jobId bigint, @optionType integer )
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @sOption		VARCHAR(MAX)
		DECLARE @maxBit			INT
		DECLARE @staticTbl		TABLE (optionId INT, defVAl INT, bitVal INT)
		DECLARE @optionTbl		TABLE (optionId INT, optVal INT)
		DECLARE @optionIdTbl	TABLE (optionId INT)
		DECLARE @defVal			INT
		DECLARE	@bitVal			INT
		DECLARE @count			INT
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @refTime	INT
		SET @count = 0
		SET @sOption = ''
		SELECT TOP 1 @taskId=taskId, @subTaskId=subTaskId, @refTime=created from TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WHERE jobId=@jobId)
		SET @maxBit = (SELECT TOP (1) bitVal FROM TM_StaticTaskOption WITH (READUNCOMMITTED) WHERE flagType = @optionType ORDER BY bitVal DESC)
		INSERT INTO @staticTbl SELECT optionId, defVal, bitVal FROM TM_StaticTaskOption WITH (READUNCOMMITTED) WHERE flagType = @optionType ORDER BY bitVal
		WHILE @count <= @maxBit
		BEGIN
			--CLEAR TEMP TABLE
			DELETE @optionIdTbl
			--GET THE OPTION ID
			INSERT INTO @optionIdTbl SELECT optionId FROM @staticTbl WHERE bitVal = @count
			--GET THE DEFAULT VALUE
			SET @bitVal = ISNULL((SELECT TOP(1) defVAl FROM @staticTbl WHERE bitVal = @count), 0)
			--GET THE OPTION VALUE
			IF @jobId != 0
			BEGIN
				--SET @bitVal = ISNULL((SELECT TOP 1 value FROM TM_JobOptions WHERE optionId IN (SELECT optionId FROM @optionIdTbl) AND jobId = @jobId), @bitVal)
				SET @bitVal = ISNULL((SELECT TOP 1 value FROM TM_JobOptions WITH (READUNCOMMITTED) WHERE optionId IN (SELECT optionId FROM @optionIdTbl) AND
						(jobId=@jobId OR (jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime)))), @bitVal)
			END
			SET @sOption = @sOption + CAST(@bitVal AS CHAR(1))
			SET @count = @count + 1
		END
		RETURN @sOption
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BuildJobExtOption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BuildJobExtOption' AND revision = '1.9')

  insert into GXDBVersions values(5, 'BuildJobExtOption',  '1.9', 'BuildJobExtOption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/BuildJobOption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BuildJobOption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BuildJobOption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BuildJobOption]
  delete from GXDBVersions where name = 'BuildJobOption' and type = 5
END
GO

	CREATE FUNCTION BuildJobOption(@jobId bigint, @optionType integer )
	RETURNS BIGINT
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @bitOption		BIGINT
		DECLARE @bitLOption		VARBINARY(MAX)
		DECLARE @bitHOption		VARBINARY(MAX)
		DECLARE @maxBit			INT
		DECLARE @staticTbl		TABLE (optionId INT, defVAl INT, bitVal INT)
		DECLARE @optionTbl		TABLE (optionId INT, optVal INT)
		DECLARE @optionIdTbl	TABLE (optionId INT)
		DECLARE @defVal			INT
		DECLARE	@bitVal			INT
		DECLARE @count			INT
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @refTime	INT
		SET @count = 0
		SET @bitLOption = 0
		SET @bitHOption = 0
		SET @bitOption = 0
		SELECT TOP 1 @taskId=taskId, @subTaskId=subTaskId, @refTime=created from TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WHERE jobId=@jobId)
		SET @maxBit = (SELECT TOP (1) bitVal FROM TM_StaticTaskOption WITH (READUNCOMMITTED) WHERE flagType = @optionType ORDER BY bitVal DESC)
		INSERT INTO @staticTbl SELECT optionId, defVal, bitVal FROM TM_StaticTaskOption WITH (READUNCOMMITTED) WHERE flagType = @optionType ORDER BY bitVal
		WHILE @count <= @maxBit
		BEGIN
			--CLEAR TEMP TABLE
			DELETE @optionIdTbl
			--GET THE OPTION ID
			INSERT INTO @optionIdTbl SELECT optionId FROM @staticTbl WHERE bitVal = @count
			--GET THE DEFAULT VALUE
			SET @bitVal = ISNULL((SELECT TOP(1) defVAl FROM @staticTbl WHERE bitVal = @count), 0)
			--GET THE OPTION VALUE
			IF @jobId != 0
			BEGIN
				--SET @bitVal = ISNULL((SELECT TOP 1 value FROM TM_JobOptions WHERE optionId IN (SELECT optionId FROM @optionIdTbl) AND jobId = @jobId), @bitVal)
				SET @bitVal = ISNULL((SELECT TOP 1 value FROM TM_JobOptions WITH (READUNCOMMITTED) WHERE optionId IN (SELECT optionId FROM @optionIdTbl) AND
						(jobId=@jobId OR (jobId=0 AND subTaskId=@subTaskId AND created <= @refTime AND (modified=0 OR modified > @refTime)))), @bitVal)
			END
			IF @bitVal != 0
				IF @count < 31
					SET @bitLOption = @bitLOption + POWER(2, @count)
				ELSE
					SET @bitHOption = @bitHOption + POWER(2, @count-31)
			SET @count = @count + 1
		END
		SET @bitOption = dbo.GetBigIntFromInt(@bitHOption, @bitLOption)
		RETURN @bitOption
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BuildJobOption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BuildJobOption' AND revision = '1.11')

  insert into GXDBVersions values(5, 'BuildJobOption',  '1.11', 'BuildJobOption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetBitwiseOption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetBitwiseOption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetBitwiseOption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetBitwiseOption]
  delete from GXDBVersions where name = 'GetBitwiseOption' and type = 5
END
GO

	CREATE FUNCTION GetBitwiseOption(@jobId bigint, @taskId integer, @subTaskId integer, @optionType integer )
	RETURNS VARBINARY(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @biOption		VARBINARY(MAX)
		IF @jobId != 0
		BEGIN
			SET  @biOption = dbo.BuildJobOption(@jobId, @optionType)
		END
		ELSE
		BEGIN
			SET  @biOption = dbo.BuildSubTaskOption(@taskId, @subTaskId, @optionType)
		END
		RETURN @biOption
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetBitwiseOption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetBitwiseOption' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetBitwiseOption',  '1.2', 'GetBitwiseOption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsBitwiseOptionSet.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsBitwiseOptionSet'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsBitwiseOptionSet]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsBitwiseOptionSet]
  delete from GXDBVersions where name = 'IsBitwiseOptionSet' and type = 5
END
GO

	CREATE FUNCTION IsBitwiseOptionSet(@jobId bigint, @taskId integer, @subTaskId integer, @optionType integer, @option bigint )
	RETURNS INT
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @biOption		VARBINARY(MAX)
		DECLARE @retVal INT
		IF @jobId = 0
		BEGIN
			SET  @biOption = dbo.BuildJobOption(@jobId, @optionType)
		END
		ELSE
		BEGIN
			SET  @biOption = dbo.BuildSubTaskOption(@taskId, @subTaskId, @optionType)
		END
		IF ((@biOption & @option) = @option)
			SET @retVal = 1
		ELSE
			SET @retVal = 0
		RETURN @retVal
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsBitwiseOptionSet]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsBitwiseOptionSet' AND revision = '1.1')

  insert into GXDBVersions values(5, 'IsBitwiseOptionSet',  '1.1', 'IsBitwiseOptionSet', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetExtendedOption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetExtendedOption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetExtendedOption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetExtendedOption]
  delete from GXDBVersions where name = 'GetExtendedOption' and type = 5
END
GO

	CREATE FUNCTION GetExtendedOption(@jobId bigint, @taskId integer, @subTaskId integer, @optionType integer, @optIndex integer )
	RETURNS VARCHAR(1)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @sOption		VARCHAR(MAX)
		IF @jobId != 0
		BEGIN
			SET  @sOption = dbo.BuildJobExtOption(@jobId, @optionType)
		END
		ELSE
		BEGIN
			SET  @sOption = dbo.BuildSubTaskExtOption(@taskId, @subTaskId, @optionType)
		END
		--SUBSTRING STARTS FROM 1 NOT FROM 0
		RETURN SUBSTRING(@sOption, @optIndex+1, 1)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetExtendedOption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetExtendedOption' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetExtendedOption',  '1.2', 'GetExtendedOption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetExtendedOptionString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetExtendedOptionString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetExtendedOptionString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetExtendedOptionString]
  delete from GXDBVersions where name = 'GetExtendedOptionString' and type = 5
END
GO

	CREATE FUNCTION GetExtendedOptionString(@jobId bigint, @taskId integer, @subTaskId integer, @optionType integer )
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @sOption		VARCHAR(MAX)
		IF @jobId != 0
		BEGIN
			SET  @sOption = dbo.BuildJobExtOption(@jobId, @optionType)
		END
		ELSE
		BEGIN
			SET  @sOption = dbo.BuildSubTaskExtOption(@taskId, @subTaskId, @optionType)
		END
		RETURN @sOption
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetExtendedOptionString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetExtendedOptionString' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetExtendedOptionString',  '1.2', 'GetExtendedOptionString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetBackupLevel.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetBackupLevel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetBackupLevel]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetBackupLevel]
  delete from GXDBVersions where name = 'GetBackupLevel' and type = 5
END
GO

	CREATE FUNCTION GetBackupLevel( @bkpType int )
		RETURNS INT
		AS
		BEGIN
		DECLARE @backupLevel INT
		SET @backupLevel =
		CASE @bkpType
			  WHEN 1 THEN 1
			  WHEN 2 THEN 2
			  WHEN 3 THEN 4
			  WHEN 4 THEN 64
			  WHEN 5 THEN 512
			  WHEN 6 THEN 128
			  WHEN 7 THEN 16384
			  WHEN 8 THEN 2048
			  WHEN 9 THEN 4096
			  WHEN 10 THEN 8192
			  WHEN 11 THEN 131072
			  WHEN 12 THEN 262144
		 END
		RETURN 	@backupLevel
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetBackupLevel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetBackupLevel' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetBackupLevel',  '1.3', 'GetBackupLevel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/RptGetJobClientTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: RptGetJobClientTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetJobClientTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetJobClientTime]
  delete from GXDBVersions where name = 'RptGetJobClientTime' and type = 5
END
GO

	CREATE FUNCTION RptGetJobClientTime (@i_clientID INTEGER, @i_unixTime INTEGER)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE @UTCTime		DATETIME
		DECLARE @localTime		DATETIME
		DECLARE @CSTZAdjSec		INTEGER
		SET @UTCTime		= DBO.GetDateTime(@i_unixTime)
		SET @localTime		= DBO.UTCTOclientLocalTime(@UTCTime, @i_clientID)
		SET @CSTZAdjSec		= DBO.getUnixTime(GetUTCDate()) - DBO.getUnixTime(GetDate())
		RETURN DBO.getUnixTime(@localTime) + @CSTZAdjSec
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetJobClientTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetJobClientTime' AND revision = '1.2')

  insert into GXDBVersions values(5, 'RptGetJobClientTime',  '1.2', 'RptGetJobClientTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSizeString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSizeString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSizeString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSizeString]
  delete from GXDBVersions where name = 'GetSizeString' and type = 5
END
GO

	CREATE FUNCTION GetSizeString ( @size BIGINT )
	RETURNS VARCHAR(128)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @sizefl		FLOAT
		DECLARE @dpPos		INT
		DECLARE @sizeStr	VARCHAR(100)


		IF @size > 1024 * 1024 * 1024
			SET @sizefl = convert(float, @size) / (1024 * 1024 * 1024)
		ELSE IF @size > 1024 * 1024
			SET @sizefl = convert(float, @size) / (1024 * 1024)
		ELSE IF @size > 1024
			SET @sizefl = convert(float, @size) / 1024
		ELSE
			SET @sizefl = convert(float, @size)

		SET @sizefl = ROUND(@sizefl,2)
		SET @sizeStr = convert(varchar(100), @sizefl)
		SET @dpPos = CHARINDEX('.', @sizeStr)

		IF @dpPos > 0
			SET @sizeStr = SUBSTRING(@sizeStr, 1, @dpPos+2)

		IF @size > 1024 * 1024 * 1024
			SET @sizeStr = @sizeStr + ' GB'
		ELSE IF @size > 1024 * 1024
			SET @sizeStr = @sizeStr + ' MB'
		ELSE IF @size > 1024
			SET @sizeStr = @sizeStr + ' KB'
		ELSE
			SET @sizeStr = @sizeStr + ' Bytes'

		RETURN @sizeStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSizeString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSizeString' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetSizeString',  '1.2', 'GetSizeString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/SplitIDString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SplitIDString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SplitIDString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SplitIDString]
  delete from GXDBVersions where name = 'SplitIDString' and type = 5
END
GO

	CREATE FUNCTION dbo.SplitIDString
	(
		@IDsList varchar(MAX)
	)
	RETURNS
	@ParsedList table
	(
		_ID varchar(100)
	)
	AS
	BEGIN
		DECLARE @_ID varchar(100), @Pos int
		SET @IDsList = LTRIM(RTRIM(@IDsList))+ ','
		SET @Pos = CHARINDEX(',', @IDsList, 1)
		IF REPLACE(@IDsList, ',', '') <> ''
		BEGIN
			WHILE @Pos > 0
			BEGIN
				SET @_ID = LTRIM(RTRIM(LEFT(@IDsList, @Pos - 1)))
				IF @_ID <> ''
				BEGIN
					INSERT INTO @ParsedList (_ID)
					VALUES (@_ID) --Use Appropriate conversion
				END
				SET @IDsList = RIGHT(@IDsList, LEN(@IDsList) - @Pos)
				SET @Pos = CHARINDEX(',', @IDsList, 1)
			END
		END
		RETURN
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SplitIDString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SplitIDString' AND revision = '1.4')

  insert into GXDBVersions values(5, 'SplitIDString',  '1.4', 'SplitIDString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getSIDBStoreNameList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getSIDBStoreNameList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getSIDBStoreNameList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getSIDBStoreNameList]
  delete from GXDBVersions where name = 'getSIDBStoreNameList' and type = 5
END
GO

	CREATE FUNCTION getSIDBStoreNameList(@i_jobId INT, @i_commCellId INT)
	RETURNS VARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @nameStr VARCHAR(MAX)
		DECLARE @tblJobSIDBStoreNameList TABLE (jobId INT, commCellId INT, SIDBStoreName NVARCHAR(256))
		INSERT INTO @tblJobSIDBStoreNameList
		SELECT DISTINCT AF.jobId, AF.commCellId, SS.SIDBStoreName
		FROM archFile AF WITH (NOLOCK), archFileSILOVolume AFSV WITH (NOLOCK), MMVolume V WITH (NOLOCK), idxSIDBStore SS WITH (NOLOCK)
		WHERE	AF.jobId = @i_jobId
		AND		AF.commCellId = @i_commCellId
		AND		AF.id = AFSV.archFileId
		AND		AF.commCellId = AFSV.commCellId
		AND		AFSV.siloVolumeId = V.volumeId
		AND		AFSV.commCellId = (CASE V.origCCcommCellId WHEN 0 THEN 2 ELSE V.origCCcommCellId END)
		AND		V.SIDBStoreId = SS.SIDBStoreId
		AND		SS.commCellId = (CASE V.origCCcommCellId WHEN 0 THEN 2 ELSE V.origCCcommCellId END)
		AND		V.SIDBStoreId > 0
		SELECT @nameStr=COALESCE(@nameStr + ', ', '') + TT.SIDBStoreName
		FROM @tblJobSIDBStoreNameList TT
		RETURN ISNULL(@nameStr, '')
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getSIDBStoreNameList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getSIDBStoreNameList' AND revision = '1.1')

  insert into GXDBVersions values(5, 'getSIDBStoreNameList',  '1.1', 'getSIDBStoreNameList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetThroughputString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetThroughputString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetThroughputString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetThroughputString]
  delete from GXDBVersions where name = 'GetThroughputString' and type = 5
END
GO

	CREATE FUNCTION GetThroughputString ( @sizeInByes BIGINT, @timeInsec INT, @unit int )
	RETURNS VARCHAR(128)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @throughput	FLOAT
		DECLARE @dpPos		INT
		DECLARE @throughputStr	VARCHAR(100)
		IF @timeInsec > 0
		BEGIN
			SET @throughput = convert(float, @sizeInByes) / @timeInsec
			IF @unit = 1 -- GB/Hour
				SET @throughput = @throughput * 3600 / (1024 * 1024 * 1024)
			SET @throughputStr = convert(varchar(100), @throughput)
			SET @dpPos = CHARINDEX('.', @throughputStr)
			IF @dpPos > 0
				SET @throughputStr = SUBSTRING(@throughputStr, 1, @dpPos+2)
			IF @unit = 1
				SET @throughputStr = @throughputStr + ' GB/Hr'
			ELSE
				SET @throughputStr = @throughputStr + ' Bytes/sec'
		END
		ELSE
			SET @throughputStr = '0'
		RETURN @throughputStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetThroughputString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetThroughputString' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetThroughputString',  '1.1', 'GetThroughputString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDateTime2.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDateTime2'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDateTime2]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDateTime2]
  delete from GXDBVersions where name = 'GetDateTime2' and type = 5
END
GO

	CREATE FUNCTION GetDateTime2 (@UnixTimeArg integer, @inTime DATETIME, @dateOnly integer)
	RETURNS VARCHAR(128)
	WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE @time 		DATETIME
	 	DECLARE @timeStr	VARCHAR(128)
		DECLARE @dpPos		INT
	 	IF @inTime is not null
	 		SET @time = @inTime
	 	ELSE IF @UnixTimeArg > 0
	 		SET @time = dateadd(second, @UnixTimeArg, '01/01/1970')
	 	ELSE
	 		RETURN ''
	 	SET @timeStr = convert(VARCHAR(128), @time)
		SET @dpPos = CHARINDEX(' ', REVERSE(@timeStr))
		IF @dateOnly > 0 AND @dpPos > 0
			SET @timeStr = SUBSTRING(@timeStr, 1, LEN(@timeStr) - @dpPos)
		RETURN @timeStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDateTime2]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDateTime2' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetDateTime2',  '1.1', 'GetDateTime2', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/isSnapShotVisible.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isSnapShotVisible'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isSnapShotVisible]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isSnapShotVisible]
  delete from GXDBVersions where name = 'isSnapShotVisible' and type = 5
END
GO

	CREATE FUNCTION isSnapshotVisible(@userid int, @copyId int, @arrayId int, @appId int)
	RETURNS INT
	AS
	BEGIN
		DECLARE @rowCount INT
		DECLARE @reqCapability INT

		DECLARE @archGroupId INT
		DECLARE @clientid INT
		DECLARE @apptypeid INT
		DECLARE @instanceid INT
		DECLARE @backupsetid INT

		SELECT @archGroupId=archGroupId FROM archGroupCopy WHERE id=@copyId
		SELECT @clientid=clientId, @apptypeid=appTypeId, @instanceid=instance , @backupsetid=backupSet FROM App_Application WHERE id=@appId

		-- capabilities required to view a backup job are one of the following: Job Management, Data Protection Operations, Browse and In Place Recover, Browse and Out of Place Recover, Browse, Report Management
		-- POWER(2,EV_SCHEDULE_ADMIN-1)
		IF @arrayId > 0 SET @reqCapability = POWER(2,1-1)
		-- POWER(2,EV_MANAGE_ARCHIVES-1)
		ELSE IF @copyId > 0 SET @reqCapability = POWER(2,4-1)
		-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_BACKUP-1)| POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_BROWSE-1)| POWER(2,EV_RUN_REPORTS-1)
		ELSE IF @appId > 0 SET @reqCapability = POWER(2,16-1) | POWER(2,12-1) | POWER(2,20-1) | POWER(2,22-1) | POWER(2,13-1)| POWER(2,15-1)
		-- need only one row that matches the required capability
		SET @rowCount = (SELECT TOP 1 1 FROM UMUserCredentials WHERE @userid = userid AND (capabilities & @reqCapability) <> 0 AND
		((clientid=0 AND clientgroupid=0 AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND taskId = 0 AND vtContainerId=0 and vtPolicyId=0 and vtShelfId=0 and reviewSetId = 0 and querySetId = 0 and downloadSetId = 0 and tagId = 0 and legalHoldId = 0 and ermId = 0 and cdPolicyId = 0 and complianceReportId = 0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0) OR
		(@archGroupId <> 0 AND (archGroupId=-10 OR @archGroupId = archGroupId)) OR
		(@arrayId <> 0 AND (arrayId=-10 OR @arrayId = arrayId)) OR
		(@clientId<>0 AND clientId=-10) OR
		(clientid=@clientid AND apptypeid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=@instanceid AND backupsetid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=@instanceid AND backupsetid=@backupsetid AND subclientid=0) OR
		(clientid=@clientid AND apptypeid=@apptypeid AND instanceid=@instanceid AND backupsetid=@backupsetid AND subclientid=@appId) OR
		(clientgroupid <> 0 AND EXISTS (SELECT TOP 1 * FROM APP_ClientGroupAssoc WHERE (UMUserCredentials.clientGroupId=-10 OR APP_ClientGroupAssoc.clientGroupId = UMUserCredentials.clientGroupId) AND APP_ClientGroupAssoc.clientid=@clientid))))
		RETURN ISNULL(@rowCount,0)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isSnapShotVisible]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isSnapShotVisible' AND revision = '1.4')

  insert into GXDBVersions values(5, 'isSnapShotVisible',  '1.4', 'isSnapShotVisible', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/cte_split_inline.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: cte_split_inline'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cte_split_inline]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[cte_split_inline]
  delete from GXDBVersions where name = 'cte_split_inline' and type = 5
END
GO

	CREATE FUNCTION cte_split_inline (@list  nvarchar(MAX),@delim nchar(1) = ',')
	RETURNS TABLE
	AS
    RETURN
	WITH csvtbl(start, stop) AS (
	 SELECT start = convert(bigint, 1),
 		    stop = charindex(@delim COLLATE Slovenian_BIN2, @list + @delim)
	 UNION ALL
	 SELECT start = stop + 1,
			stop = charindex(@delim COLLATE Slovenian_BIN2,
							 @list + @delim, stop + 1)
	 FROM   csvtbl
	 WHERE  stop > 0
	)
	SELECT ltrim(rtrim(substring(@list, start,
					      CASE WHEN stop > 0 THEN stop - start ELSE 0 END)))
		   AS Value
	FROM   csvtbl
	WHERE  stop > 0



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [cte_split_inline]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'cte_split_inline' AND revision = '1.1')

  insert into GXDBVersions values(5, 'cte_split_inline',  '1.1', 'cte_split_inline', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetHourlyStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetHourlyStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetHourlyStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetHourlyStart]
  delete from GXDBVersions where name = 'DAGetHourlyStart' and type = 5
END
GO

	CREATE FUNCTION DAGetHourlyStart(@jobStartTime INTEGER, @EveryXHours INTEGER, @minutesSinceDayStarts INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @dayStartTime 						DATETIME
			DECLARE	@hourlyStartTime					DATETIME

			IF @EveryXHours < 1
				SET @EveryXHours = 1

			IF @EveryXHours > 24
				SET @EveryXHours = 24

			IF @EveryXHours > 0
			BEGIN
				SET @dayStartTime = dbo.getDateTime(dbo.DAGetDailyStart(@jobStartTime, @minutesSinceDayStarts))

				SET @hourlyStartTime = DATEADD(HH, ((DATEDIFF(HH, @dayStartTime, dbo.getDateTime(@jobStartTime))/@EveryXHours) * @EveryXHours), @dayStartTime)

				IF @hourlyStartTime > dbo.getDateTime(@jobStartTime)
					SET @hourlyStartTime = DATEADD(HH, -1 * @EveryXHours, @hourlyStartTime)
			END

			RETURN dbo.getUnixTime(@hourlyStartTime)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetHourlyStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetHourlyStart' AND revision = '1.3')

  insert into GXDBVersions values(5, 'DAGetHourlyStart',  '1.3', 'DAGetHourlyStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetDailyStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetDailyStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetDailyStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetDailyStart]
  delete from GXDBVersions where name = 'DAGetDailyStart' and type = 5
END
GO

	CREATE FUNCTION DAGetDailyStart(@jobStartTime INTEGER, @minutesSinceDayStarts INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @dayStartTime 			DATETIME
			DECLARE	@dailyStartTime			DATETIME

			IF @minutesSinceDayStarts < 0
				SET @minutesSinceDayStarts = 0

			IF @minutesSinceDayStarts >= (24 * 60)
				SET @minutesSinceDayStarts = 0

			SET @dayStartTime = DATEADD(DAY, DATEDIFF(DAY, 0, dbo.getDateTime(@jobStartTime)), 0)

			SET @dailyStartTime = DATEADD(MI, @minutesSinceDayStarts, @dayStartTime)

			IF @dailyStartTime > dbo.getDateTime(@jobStartTime)
				SET @dailyStartTime = DATEADD(DAY, -1, @dailyStartTime)

			RETURN dbo.getUnixTime(@dailyStartTime)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetDailyStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetDailyStart' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DAGetDailyStart',  '1.1', 'DAGetDailyStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetWeekStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetWeekStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetWeekStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetWeekStart]
  delete from GXDBVersions where name = 'DAGetWeekStart' and type = 5
END
GO

	CREATE FUNCTION DAGetWeekStart(@jobStartTime INTEGER, @weekStartsFrom INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @jobStartDate 	DATETIME
			DECLARE @dayOfWeek 			INTEGER
			DECLARE @numDay 				INTEGER
			DECLARE @startDate 			DATETIME

			-- Get the Date Part
			SET @jobStartDate = DATEADD(DAY, DATEDIFF(DAY, 0, dbo.getDateTime(@jobStartTime)), 0)
			SET @dayOfWeek = (DATEPART(WEEKDAY, @jobStartDate) +  @@DATEFIRST - 1) % 7

			IF (@dayOfWeek < @weekStartsFrom)
				SET @numDay = @weekStartsFrom - @dayOfWeek - 7;
			else
				SET @numDay = @weekStartsFrom - @dayOfWeek;

			SET @startDate = DATEADD(DAY, @numDay, @jobStartDate)

			RETURN dbo.getUnixTime(@startDate)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetWeekStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetWeekStart' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DAGetWeekStart',  '1.1', 'DAGetWeekStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetMonthStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetMonthStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetMonthStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetMonthStart]
  delete from GXDBVersions where name = 'DAGetMonthStart' and type = 5
END
GO

	CREATE FUNCTION DAGetMonthStart(@jobStartTime INTEGER, @calendarId INTEGER, @monthStartsFrom INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @jobStartDate 						DATETIME
			DECLARE @monthStartDate 					DATETIME
			DECLARE @monthStartsFromDate			DATETIME
			DECLARE @prevMonthDate						DATETIME
			DECLARE @prevMonthStartDate				DATETIME
			DECLARE @prevMonthStartFromDate		DATETIME
			DECLARE @year 										INTEGER
			DECLARE @month 										INTEGER
			DECLARE @day 											INTEGER
			DECLARE @calType 									INTEGER

			-- Get the Date Part
			SET @jobStartDate = DATEADD(DAY, DATEDIFF(DAY, 0, dbo.getDateTime(@jobStartTime)), 0)
			SET @calType = 0
			SET @monthStartDate = 0

			SET @calType = (SELECT calType FROM APP_CustomCalendar WHERE id = @calendarId)
			IF (@calType > 2)
			BEGIN
			  SELECT @monthStartDate = startDate
				FROM APP_CustomCalendarMonths
				WHERE startDate <= @jobStartDate
				AND endDate >= @jobStartDate
				AND calendarId = @calendarId
			END

			--If Standard Calendar OR Custom Calendar with no months defined OR custom calendar not defined, then get standard calendar dates
			IF (@monthStartDate = 0)
			BEGIN
				SET @year = DATEPART(YEAR, @jobStartDate)
				SET @month = DATEPART(MONTH, @jobStartDate)
				SET @day = DATEPART(DAY, @jobStartDate)
				SET @monthStartDate = dbo.getStartDay(@year, @month, 0)
				SET @calType = 1	-- Standard calendar
			END

			IF (@monthStartsFrom = 1)
			BEGIN
				RETURN dbo.getUnixTime(@monthStartDate)
			END

			SET @monthStartsFromDate = DATEADD(DAY, @monthStartsFrom - 1, @monthStartDate)

			-- If jobStartTime = 2/20 and monthStart = 15, return should be 2/15
			-- If jobStartTime = 2/28 and monthStart = 28, return should be 2/28
			IF (@jobStartDate >= @monthStartsFromDate)
			BEGIN
				RETURN dbo.getUnixTime(@monthStartsFromDate)
			END

			--Job belongs to previous month, get previous month offset
			SET @prevMonthDate = DATEADD(DAY, -1, @monthStartDate)

			--Get the previous month start date
			SET @prevMonthStartDate = 0

			IF (@calType > 2)
			BEGIN
			  SELECT @prevMonthStartDate = startDate
				FROM APP_CustomCalendarMonths
				WHERE startDate <= @prevMonthDate
				AND endDate >= @prevMonthDate
				AND calendarId = @calendarId
			END

			--If Standard Calendar OR Custom Calendar with no months defined OR custom calendar not defined, then get standard calendar dates
			IF (@prevMonthStartDate = 0)
			BEGIN
				SET @year = DATEPART(YEAR, @jobStartDate)
				SET @month = DATEPART(MONTH, @jobStartDate)
				SET @day = DATEPART(DAY, @jobStartDate)
				SET @monthStartDate = dbo.getStartDay(@year, @month, 0)

				IF (@monthStartsFrom = 1)
				BEGIN
					RETURN dbo.getUnixTime(@monthStartDate)
				END

				SET @monthStartsFromDate = DATEADD(DAY, @monthStartsFrom - 1, @monthStartDate)

				-- If jobStartTime = 2/20 and monthStart = 15, return should be 2/15
				-- If jobStartTime = 2/28 and monthStart = 28, return should be 2/28
				IF (@jobStartDate >= @monthStartsFromDate)
				BEGIN
					RETURN dbo.getUnixTime(@monthStartsFromDate)
				END

				--Job belongs to previous month, get previous month offset
				SET @prevMonthDate = DATEADD(DAY, -1, @monthStartDate)

				SET @year = DATEPART(YEAR, @prevMonthDate)
				SET @month = DATEPART(MONTH, @prevMonthDate)
				SET @day = DATEPART(DAY, @prevMonthDate)
				SET @prevMonthStartDate = dbo.getStartDay(@year, @month, 0)
			END

			--Get the Previous Month Start Date
			SET @prevMonthStartFromDate = DATEADD(DAY, @monthStartsFrom - 1, @prevMonthStartDate)

			-- If jobStartTime = 2/20 and monthStart = 25, return should be 1/25
			-- If jobStartTime = 2/28 and monthStart = 31, return should be 2/1
			-- If jobStartTime = 3/30 and monthStart = 31, return should be 3/1
			IF (@prevMonthStartFromDate < @monthStartDate)
				SET @monthStartsFromDate = @prevMonthStartFromDate
			ELSE
				SET @monthStartsFromDate = @monthStartDate

			RETURN dbo.getUnixTime(@monthStartsFromDate)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetMonthStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetMonthStart' AND revision = '1.2')

  insert into GXDBVersions values(5, 'DAGetMonthStart',  '1.2', 'DAGetMonthStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetQuarterStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetQuarterStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetQuarterStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetQuarterStart]
  delete from GXDBVersions where name = 'DAGetQuarterStart' and type = 5
END
GO

	CREATE FUNCTION DAGetQuarterStart(@jobStartTime INTEGER, @calendarId INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @jobStartDate 			DATETIME
			DECLARE @monthStartDate			DATETIME
			DECLARE @quarterStartDate 	DATETIME
			DECLARE @year 							INTEGER
			DECLARE @month 							INTEGER
			DECLARE @day 								INTEGER
			DECLARE @calType 						INTEGER
			DECLARE @yearStartMonth 		INTEGER
			DECLARE @diffMonth 					INTEGER
			DECLARE @monthOffset 				INTEGER

			-- Get the Date Part
			SET @jobStartDate = DATEADD(DAY, DATEDIFF(DAY, 0, dbo.getDateTime(@jobStartTime)), 0)
			SET @calType = 0
			SET @year = DATEPART(YEAR, @jobStartDate)
			SET @month = DATEPART(MONTH, @jobStartDate)
			SET @day = DATEPART(DAY, @jobStartDate)
			SET @monthStartDate = 0
			SET @quarterStartDate = 0
			SET @yearStartMonth = 0
			SET @diffMonth = 0
			SET @monthOffset = 0

			SET @calType = (SELECT calType FROM APP_CustomCalendar WHERE id = @calendarId)
			IF (@calType > 2)
			BEGIN
			  SELECT @monthStartDate = startDate, @year = year, @month = month
				FROM APP_CustomCalendarMonths
				WHERE startDate <= @jobStartDate
				AND endDate >= @jobStartDate
				AND calendarId = @calendarId
			END

			--If Standard Calendar OR Custom Calendar with no months defined OR custom calendar not defined, then set standard calendar
			IF (@monthStartDate = 0)
			BEGIN
				SET @year = DATEPART(YEAR, @jobStartDate)
				SET @month = DATEPART(MONTH, @jobStartDate)
				SET @day = DATEPART(DAY, @jobStartDate)
				IF (@calType <> 2)
					SET @calendarId = 1
			END

			SELECT @yearStartMonth = beginMonth
			FROM APP_CustomCalendar
			WHERE id = @calendarId

			--If Standard Calendar OR Custom Calendar with no months defined OR custom calendar not defined, then get standard calendar month
			IF (@yearStartMonth = 0)
				SET @yearStartMonth = 1

			SET @diffMonth = @month - @yearStartMonth

			IF (@diffMonth < 0)
 			BEGIN
				SET @diffMonth = @diffMonth + 12
				SET @monthOffset = @yearStartMonth + (@diffMonth / 3) * 3
				IF (@monthOffset > 12)
					SET @quarterStartDate = dbo.getstartday(@year, (@yearStartMonth - 12 + (@diffMonth / 3) * 3), @calendarId)
				ELSE
					SET @quarterStartDate = dbo.getstartday((@year -1), (@yearStartMonth + (@diffMonth / 3) * 3), @calendarId)
			END
			ELSE
			BEGIN
				SET @quarterStartDate = dbo.getstartday(@year, (@yearStartMonth + (@diffMonth / 3) * 3), @calendarId)
			END

			RETURN dbo.getUnixTime(@quarterStartDate)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetQuarterStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetQuarterStart' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DAGetQuarterStart',  '1.1', 'DAGetQuarterStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetHalfYearStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetHalfYearStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetHalfYearStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetHalfYearStart]
  delete from GXDBVersions where name = 'DAGetHalfYearStart' and type = 5
END
GO

	CREATE FUNCTION DAGetHalfYearStart(@jobStartTime INTEGER, @calendarId INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @jobStartDate 			DATETIME
			DECLARE @monthStartDate			DATETIME
			DECLARE @halfYearStartDate 	DATETIME
			DECLARE @year 							INTEGER
			DECLARE @month 							INTEGER
			DECLARE @day 								INTEGER
			DECLARE @calType 						INTEGER
			DECLARE @yearStartMonth 		INTEGER
			DECLARE @diffMonth 					INTEGER
			DECLARE @monthOffset 				INTEGER

			-- Get the Date Part
			SET @jobStartDate = DATEADD(DAY, DATEDIFF(DAY, 0, dbo.getDateTime(@jobStartTime)), 0)
			SET @calType = 0
			SET @year = DATEPART(YEAR, @jobStartDate)
			SET @month = DATEPART(MONTH, @jobStartDate)
			SET @day = DATEPART(DAY, @jobStartDate)
			SET @monthStartDate = 0
			SET @halfYearStartDate = 0
			SET @yearStartMonth = 0
			SET @diffMonth = 0
			SET @monthOffset = 0

			SET @calType = (SELECT calType FROM APP_CustomCalendar WHERE id = @calendarId)
			IF (@calType > 2)
			BEGIN
			  SELECT @monthStartDate = startDate, @year = year, @month = month
				FROM APP_CustomCalendarMonths
				WHERE startDate <= @jobStartDate
				AND endDate >= @jobStartDate
				AND calendarId = @calendarId
			END

			--If Standard Calendar OR Custom Calendar with no months defined OR custom calendar not defined, then get standard calendar dates
			IF (@monthStartDate = 0)
			BEGIN
				SET @year = DATEPART(YEAR, @jobStartDate)
				SET @month = DATEPART(MONTH, @jobStartDate)
				SET @day = DATEPART(DAY, @jobStartDate)
				IF (@calType <> 2)
					SET @calendarId = 1
			END

			SELECT @yearStartMonth = beginMonth
			FROM APP_CustomCalendar
			WHERE id = @calendarId

			--If Standard Calendar OR Custom Calendar with no months defined OR custom calendar not defined, then get standard calendar month
			IF (@yearStartMonth = 0)
				SET @yearStartMonth = 1

			SET @diffMonth = @month - @yearStartMonth

			IF (@diffMonth < 0)
 			BEGIN
				SET @diffMonth = @diffMonth + 12
				SET @monthOffset = @yearStartMonth + (@diffMonth / 6) * 6
				IF (@monthOffset > 12)
					SET @halfYearStartDate = dbo.getstartday(@year, (@yearStartMonth - 12 + (@diffMonth / 6) * 6), @calendarId)
				ELSE
					SET @halfYearStartDate = dbo.getstartday((@year -1), (@yearStartMonth + (@diffMonth / 6) * 6), @calendarId)
			END
			ELSE
			BEGIN
				SET @halfYearStartDate = dbo.getstartday(@year, (@yearStartMonth + (@diffMonth / 6) * 6), @calendarId)
			END

			RETURN dbo.getUnixTime(@halfYearStartDate)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetHalfYearStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetHalfYearStart' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DAGetHalfYearStart',  '1.1', 'DAGetHalfYearStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetYearStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetYearStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetYearStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetYearStart]
  delete from GXDBVersions where name = 'DAGetYearStart' and type = 5
END
GO

	CREATE FUNCTION DAGetYearStart(@jobStartTime INTEGER, @calendarId INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @jobStartDate 			DATETIME
			DECLARE @monthStartDate			DATETIME
			DECLARE @yearStartDate 			DATETIME
			DECLARE @year 							INTEGER
			DECLARE @month 							INTEGER
			DECLARE @day 								INTEGER
			DECLARE @calType 						INTEGER
			DECLARE @yearStartMonth 		INTEGER
			DECLARE @diffMonth 					INTEGER

			-- Get the Date Part
			SET @jobStartDate = DATEADD(DAY, DATEDIFF(DAY, 0, dbo.getDateTime(@jobStartTime)), 0)
			SET @calType = 0
			SET @year = DATEPART(YEAR, @jobStartDate)
			SET @month = DATEPART(MONTH, @jobStartDate)
			SET @day = DATEPART(DAY, @jobStartDate)
			SET @monthStartDate = 0
			SET @yearStartDate = 0
			SET @yearStartMonth = 0
			SET @diffMonth = 0

			SET @calType = (SELECT calType FROM APP_CustomCalendar WHERE id = @calendarId)
			IF (@calType > 2)
			BEGIN
			  SELECT @monthStartDate = startDate, @year = year, @month = month
				FROM APP_CustomCalendarMonths
				WHERE startDate <= @jobStartDate
				AND endDate >= @jobStartDate
				AND calendarId = @calendarId
			END

			--If Standard Calendar OR Custom Calendar with no months defined OR custom calendar not defined, then get standard calendar dates
			IF (@monthStartDate = 0)
			BEGIN
				SET @year = DATEPART(YEAR, @jobStartDate)
				SET @month = DATEPART(MONTH, @jobStartDate)
				SET @day = DATEPART(DAY, @jobStartDate)
				IF (@calType <> 2)
					SET @calendarId = 1
			END

			SELECT @yearStartMonth = beginMonth
			FROM APP_CustomCalendar
			WHERE id = @calendarId

			--If Standard Calendar OR Custom Calendar with no months defined OR custom calendar not defined, then get standard calendar month
			IF (@yearStartMonth = 0)
				SET @yearStartMonth = 1

			SET @diffMonth = @month - @yearStartMonth

			IF (@diffMonth < 0)
				SET @yearStartDate = dbo.getstartday((@year -1), @yearStartMonth, @calendarId)
			ELSE
				SET @yearStartDate = dbo.getstartday(@year, @yearStartMonth, @calendarId)

			RETURN dbo.getUnixTime(@yearStartDate)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetYearStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetYearStart' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DAGetYearStart',  '1.1', 'DAGetYearStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetHourlyEnd.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetHourlyEnd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetHourlyEnd]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetHourlyEnd]
  delete from GXDBVersions where name = 'DAGetHourlyEnd' and type = 5
END
GO

	CREATE FUNCTION DAGetHourlyEnd(@jobStartTime INTEGER, @EveryXHours INTEGER, @minutesSinceDayStarts INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE	@hourlyStartTime		DATETIME
			DECLARE	@hourlyEndTime			DATETIME
			DECLARE @dayEndTime		 			DATETIME

			SET @dayEndTime = dbo.getDateTime(dbo.DAGetDailyEnd(@jobStartTime, @minutesSinceDayStarts))
			SET @hourlyStartTime = dbo.getDateTime(dbo.DAGetHourlyStart(@jobStartTime, @EveryXHours, @minutesSinceDayStarts))
			SET @hourlyEndTime = dbo.getDateTime(dbo.getUnixTime(DATEADD(HH, @EveryXHours, @hourlyStartTime)) - 1)

			IF @hourlyEndTime > @dayEndTime
				SET @hourlyEndTime = @dayEndTime

			RETURN dbo.getUnixTime(@hourlyEndTime)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetHourlyEnd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetHourlyEnd' AND revision = '1.2')

  insert into GXDBVersions values(5, 'DAGetHourlyEnd',  '1.2', 'DAGetHourlyEnd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetDailyEnd.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetDailyEnd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetDailyEnd]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetDailyEnd]
  delete from GXDBVersions where name = 'DAGetDailyEnd' and type = 5
END
GO

	CREATE FUNCTION DAGetDailyEnd(@jobStartTime INTEGER, @minutesSinceDayStarts INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE	@dailyStartTime			DATETIME
			DECLARE	@dailyEndTime				DATETIME

			SET @dailyStartTime = dbo.getDateTime(dbo.DAGetDailyStart(@jobStartTime, @minutesSinceDayStarts))
			SET @dailyEndTime = dbo.getDateTime(dbo.getUnixTime(DATEADD(DAY, 1, @dailyStartTime)) - 1)

			RETURN dbo.getUnixTime(@dailyEndTime)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetDailyEnd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetDailyEnd' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DAGetDailyEnd',  '1.1', 'DAGetDailyEnd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetWeekEnd.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetWeekEnd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetWeekEnd]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetWeekEnd]
  delete from GXDBVersions where name = 'DAGetWeekEnd' and type = 5
END
GO

	CREATE FUNCTION DAGetWeekEnd(@jobStartTime INTEGER, @weekStartsFrom INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @weekStartDate 	INTEGER
			DECLARE @weekEndDate 		DATETIME

			-- Get the StartDate of Week
			SET @weekStartDate = dbo.DAGetWeekStart(@jobStartTime, @weekStartsFrom)
			SET @weekEndDate = DATEADD(DAY, 6, dbo.getDateTime(@weekStartDate))

			RETURN dbo.getUnixTime(@weekEndDate) + (24 * 3600) - 1
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetWeekEnd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetWeekEnd' AND revision = '1.2')

  insert into GXDBVersions values(5, 'DAGetWeekEnd',  '1.2', 'DAGetWeekEnd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetMonthEnd.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetMonthEnd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetMonthEnd]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetMonthEnd]
  delete from GXDBVersions where name = 'DAGetMonthEnd' and type = 5
END
GO

	CREATE FUNCTION DAGetMonthEnd(@jobStartTime INTEGER, @calendarId INTEGER, @monthStartsFrom INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @monthStartDate 	INTEGER
			DECLARE	@monthEndDate 		DATETIME

			SET @monthEndDate = 0

			-- Get the StartDate of Month
			SET	@monthStartDate = dbo.DAGetMonthStart(@jobStartTime, @calendarId, @monthStartsFrom)
			SET @monthEndDate = dbo.getDateTime(@monthStartDate)

			WHILE (@monthStartDate = dbo.DAGetMonthStart(dbo.getUnixTime(@monthEndDate), @calendarId, @monthStartsFrom))
			BEGIN
				SET @monthEndDate = DATEADD(DAY, 1, @monthEndDate)
			END

			SET @monthEndDate = DATEADD(DAY, -1, @monthEndDate)

			RETURN dbo.getUnixTime(@monthEndDate) + (24 * 3600) - 1
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetMonthEnd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetMonthEnd' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DAGetMonthEnd',  '1.1', 'DAGetMonthEnd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetQuarterEnd.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetQuarterEnd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetQuarterEnd]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetQuarterEnd]
  delete from GXDBVersions where name = 'DAGetQuarterEnd' and type = 5
END
GO

	CREATE FUNCTION DAGetQuarterEnd(@jobStartTime INTEGER, @calendarId INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @quarterStartDate 	INTEGER
			DECLARE @quarterEndDate 		DATETIME
			DECLARE @year 							INTEGER
			DECLARE @month 							INTEGER
			DECLARE @endMonth 					INTEGER

			SET @year 	= 0
			SET @month 	= 0
			SET @quarterEndDate = 0

			-- Get the StartDate of Quarter
			SET @quarterStartDate = dbo.DAGetQuarterStart(@jobStartTime, @calendarId)

			SELECT @year = year, @month = month
			FROM APP_CustomCalendarMonths
			WHERE startDate = dbo.getDateTime(@quarterStartDate)
			AND		calendarId = @calendarId

			--Custom Calendar
			IF (@month <> 0 AND @year <> 0)
			BEGIN
				SET @endMonth =  CASE (((@month % 12) + 2) % 12) WHEN 0 THEN 12 ELSE (((@month % 12) + 2) % 12) END
				IF (@endMonth <= @month)
				BEGIN
					SET @year = @year + 1
				END

				SELECT @quarterEndDate = endDate
				FROM APP_CustomCalendarMonths
				WHERE year = @year
				AND		month = @endMonth
				AND		calendarId = @calendarId
			END

			--Standard Calendar
			IF (@quarterEndDate = 0)
			BEGIN
				SET @quarterEndDate = DATEADD(MONTH, 3, dbo.getDateTime(@quarterStartDate))
				SET @quarterEndDate = DATEADD(DAY, -1, @quarterEndDate)
			END

			RETURN dbo.getUnixTime(@quarterEndDate) + (24 * 3600) - 1
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetQuarterEnd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetQuarterEnd' AND revision = '1.2')

  insert into GXDBVersions values(5, 'DAGetQuarterEnd',  '1.2', 'DAGetQuarterEnd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetHalfYearEnd.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetHalfYearEnd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetHalfYearEnd]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetHalfYearEnd]
  delete from GXDBVersions where name = 'DAGetHalfYearEnd' and type = 5
END
GO

	CREATE FUNCTION DAGetHalfYearEnd(@jobStartTime INTEGER, @calendarId INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @halfYearStartDate 	INTEGER
			DECLARE @halfYearEndDate 		DATETIME
			DECLARE @year 							INTEGER
			DECLARE @month 							INTEGER
			DECLARE @endMonth 					INTEGER

			SET @year 	= 0
			SET @month 	= 0
			SET @halfYearEndDate = 0

			-- Get the StartDate of Half Year
			SET @halfYearStartDate = dbo.DAGetHalfYearStart(@jobStartTime, @calendarId)

			SELECT @year = year, @month = month
			FROM APP_CustomCalendarMonths
			WHERE startDate = dbo.getDateTime(@halfYearStartDate)
			AND		calendarId = @calendarId

			--Custom Calendar
			IF (@month <> 0 AND @year <> 0)
			BEGIN
				SET @endMonth =  CASE (((@month % 12) + 5) % 12) WHEN 0 THEN 12 ELSE (((@month % 12) + 5) % 12) END
				IF (@endMonth <= @month)
				BEGIN
					SET @year = @year + 1
				END

				SELECT @halfYearEndDate = endDate
				FROM APP_CustomCalendarMonths
				WHERE year = @year
				AND		month = @endMonth
				AND		calendarId = @calendarId
			END

			--Standard Calendar
			IF (@halfYearEndDate = 0)
			BEGIN
				SET @halfYearEndDate = DATEADD(MONTH, 6, dbo.getDateTime(@halfYearStartDate))
				SET @halfYearEndDate = DATEADD(DAY, -1, @halfYearEndDate)
			END

			RETURN dbo.getUnixTime(@halfYearEndDate) + (24 * 3600) - 1
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetHalfYearEnd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetHalfYearEnd' AND revision = '1.2')

  insert into GXDBVersions values(5, 'DAGetHalfYearEnd',  '1.2', 'DAGetHalfYearEnd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetYearEnd.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetYearEnd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetYearEnd]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetYearEnd]
  delete from GXDBVersions where name = 'DAGetYearEnd' and type = 5
END
GO

	CREATE FUNCTION DAGetYearEnd(@jobStartTime INTEGER, @calendarId INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @yearStartDate 	INTEGER
			DECLARE @yearEndDate 		DATETIME
			DECLARE @year 					INTEGER
			DECLARE @month 					INTEGER
			DECLARE @endMonth 			INTEGER

			SET @year 	= 0
			SET @month 	= 0
			SET @yearEndDate = 0

			-- Get the StartDate of Year
			SET @yearStartDate = dbo.DAGetYearStart(@jobStartTime, @calendarId)

			SELECT @year = year, @month = month
			FROM APP_CustomCalendarMonths
			WHERE startDate = dbo.getDateTime(@yearStartDate)
			AND		calendarId = @calendarId

			--Custom Calendar
			IF (@month <> 0 AND @year <> 0)
			BEGIN
				SET @endMonth =  CASE (((@month % 12) + 11) % 12) WHEN 0 THEN 12 ELSE (((@month % 12) + 11) % 12) END
				IF (@endMonth <= @month)
				BEGIN
					SET @year = @year + 1
				END

				SELECT @yearEndDate = endDate
				FROM APP_CustomCalendarMonths
				WHERE year = @year
				AND		month = @endMonth
				AND		calendarId = @calendarId
			END

			--Standard Calendar
			IF (@yearEndDate = 0)
			BEGIN
				SET @yearEndDate = DATEADD(MONTH, 12, dbo.getDateTime(@yearStartDate))
				SET @yearEndDate = DATEADD(DAY, -1, @yearEndDate)
			END

			RETURN dbo.getUnixTime(@yearEndDate) + (24 * 3600) - 1
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetYearEnd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetYearEnd' AND revision = '1.2')

  insert into GXDBVersions values(5, 'DAGetYearEnd',  '1.2', 'DAGetYearEnd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DaTSRptGetMountPathErrorCode.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DaTSRptGetMountPathErrorCode'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DaTSRptGetMountPathErrorCode]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DaTSRptGetMountPathErrorCode]
  delete from GXDBVersions where name = 'DaTSRptGetMountPathErrorCode' and type = 5
END
GO

	CREATE FUNCTION DaTSRptGetMountPathErrorCode(@inSIDBStoreId INTEGER, @inCopyId INTEGER, @inMediaId INTEGER)
		RETURNS VARCHAR(MAX)
		AS
		BEGIN
			DECLARE @ErrorCodeList VARCHAR(MAX)

			DECLARE	@numberOfFailureToDisplay		INTEGER
			SET			@numberOfFailureToDisplay		= 5

			SELECT @numberOfFailureToDisplay = isnull(value, 0)
			FROM MMConfigs
			WHERE name = 'DA_CONFIG_NUMBER_OF_FAILURE_REASON_TO_DISPLAY_IN_REPORT'

			--Populate MountPath ErrorCode for failures in pruning
			--Replace -ve error code with 53032 (E_MM_SIDB_PRUNE_AFILE_PENDING)
			SELECT TOP (@numberOfFailureToDisplay) @ErrorCodeList = COALESCE(@ErrorCodeList + ',', '') + CAST(TMP.FailureErrorCode AS VARCHAR(10))
			FROM (
							SELECT T.SIDBStoreId, T.copyId, T.MediaId, T.FailureErrorCode, SUM(T.ErrorCount) AS ErrorCount
							FROM (
									SELECT DAF.SIDBStoreId, DAF.copyId, MS.MediaId,
												 (CASE WHEN DAF.FailureErrorCode >= 0 THEN DAF.FailureErrorCode ELSE 53032 END) AS FailureErrorCode,
												 COUNT(*) AS ErrorCount
      						FROM MMDeletedAF DAF WITH (NOLOCK), MMMountPath MP WITH (NOLOCK), MMMediaSide MS WITH (NOLOCK)
									WHERE DAF.MountPathId > 0
									AND		DAF.FailureErrorCode != 0
									AND		DAF.SIDBStoreId = @inSIDBStoreId
									AND		DAF.copyId = @inCopyId
									AND		DAF.MountPathId = MP.MountPathId
									AND		MP.MediaSideId = MS.MediaSideId
									AND		MS.MediaId = @inMediaId
      						GROUP BY DAF.SIDBStoreId, DAF.copyId, MS.MediaId, (CASE WHEN DAF.FailureErrorCode >= 0 THEN DAF.FailureErrorCode ELSE 53032 END)

									UNION ALL

									SELECT V.SIDBStoreId, ISNULL(CAST(S.archGroupCopyId AS INT), 2147483647) AS copyId, V.mediaId,
												 (CASE WHEN V.FailureErrorCode >= 0 THEN V.FailureErrorCode ELSE 53032 END) AS FailureErrorCode,
												 COUNT(*) AS ErrorCount
									FROM MMVolume V WITH (NOLOCK)
									LEFT OUTER JOIN archStream S WITH (NOLOCK)
										ON	V.mediaGroupId = S.mediaGroupId
      						WHERE V.mediaId > 0
									AND		V.FailureErrorCode != 0
									AND		V.siloStatus != 2
									AND		V.SIDBStoreId = @inSIDBStoreId
									AND	 	ISNULL(CAST(S.archGroupCopyId AS INT), 2147483647) = @inCopyId
 									AND		V.MediaId = @inMediaId
									GROUP BY V.SIDBStoreId, ISNULL(CAST(S.archGroupCopyId AS INT), 2147483647), V.mediaId, (CASE WHEN V.FailureErrorCode >= 0 THEN V.FailureErrorCode ELSE 53032 END)

									UNION ALL

      						SELECT V.SIDBStoreId, ISNULL(CAST(S.archGroupCopyId AS INT), 2147483647) AS copyId, MS.mediaId,
												 (CASE WHEN V.FailureErrorCode >= 0 THEN V.FailureErrorCode ELSE 53032 END) AS FailureErrorCode,
												 COUNT(*) AS ErrorCount
									FROM MMVolume V WITH (NOLOCK)
										INNER JOIN MMMountPath MP WITH (NOLOCK)
											ON V.currMountPathId = MP.mountPathId
										INNER JOIN MMMediaSide MS WITH (NOLOCK)
											ON		MP.MediaSideId = MS.MediaSideId
										LEFT OUTER JOIN archStream S WITH (NOLOCK)
											ON	V.mediaGroupId = S.mediaGroupId
									WHERE V.currMountPathId > 0
      						AND		V.FailureErrorCode != 0
									AND		V.siloStatus = 2
									AND		V.SIDBStoreId = @inSIDBStoreId
									AND	 	ISNULL(CAST(S.archGroupCopyId AS INT), 2147483647) = @inCopyId
									AND		MS.MediaId = @inMediaId
									GROUP BY V.SIDBStoreId, ISNULL(CAST(S.archGroupCopyId AS INT), 2147483647), MS.mediaId, (CASE WHEN V.FailureErrorCode >= 0 THEN V.FailureErrorCode ELSE 53032 END)
							) T
      				GROUP BY T.SIDBStoreId, T.copyId, T.MediaId, T.FailureErrorCode
			) TMP
			ORDER BY TMP.ErrorCount DESC

			RETURN @ErrorCodeList
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DaTSRptGetMountPathErrorCode]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DaTSRptGetMountPathErrorCode' AND revision = '1.4')

  insert into GXDBVersions values(5, 'DaTSRptGetMountPathErrorCode',  '1.4', 'DaTSRptGetMountPathErrorCode', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetMaxDateTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetMaxDateTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetMaxDateTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetMaxDateTime]
  delete from GXDBVersions where name = 'GetMaxDateTime' and type = 5
END
GO

	CREATE FUNCTION GetMaxDateTime(@Arg1 DATETIME, @Arg2 DATETIME)
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @Max DATETIME
		IF( @Arg1 >= @Arg2 )
			SET @Max = @Arg1
		ELSE
			SET @Max = @Arg2
		RETURN @Max
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetMaxDateTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetMaxDateTime' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetMaxDateTime',  '1.1', 'GetMaxDateTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsBackupAllEntitiesValid.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsBackupAllEntitiesValid'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsBackupAllEntitiesValid]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsBackupAllEntitiesValid]
  delete from GXDBVersions where name = 'IsBackupAllEntitiesValid' and type = 5
END
GO

	CREATE  FUNCTION IsBackupAllEntitiesValid (@AppTypeID int, @InstanceId int, @BackupSetId int, @AppId int, @Status int)
	RETURNS INT
	WITH ENCRYPTION
	BEGIN
		IF ( @AppTypeID IN (4,16,70) AND (@InstanceID = 0 Or @BackupSetID = 0 OR @AppID = 0) AND ((@Status & 8) = 0) )
		BEGIN
			RETURN 0
		END
		RETURN 1
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsBackupAllEntitiesValid]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsBackupAllEntitiesValid' AND revision = '1.1')

  insert into GXDBVersions values(5, 'IsBackupAllEntitiesValid',  '1.1', 'IsBackupAllEntitiesValid', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsSchdBackupTypeFull.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsSchdBackupTypeFull'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsSchdBackupTypeFull]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsSchdBackupTypeFull]
  delete from GXDBVersions where name = 'IsSchdBackupTypeFull' and type = 5
END
GO

	CREATE  FUNCTION IsSchdBackupTypeFull (@AppTypeID int, @AppId int, @BackupType int)
	RETURNS INT
	WITH ENCRYPTION
	BEGIN
		IF ( @AppTypeID IN (45,56,57,58,66,73, 82, 83, 89, 90) AND ((@BackupType = 2) OR (@BackupType & 0x800000 = 0x800000)) )
		BEGIN
			DECLARE		@NewIdxCycle	integer
			DECLARE		@CurrentIdxCycle	integer
			SET @NewIdxCycle = (SELECT CAST(SCP.attrVal AS INT)
						FROM APP_SubClientProp AS SCP
						WHERE SCP.ComponentNameID = @AppID
							AND attrName = 'New Index Cycle'
							AND modified = 0)
			SET @CurrentIdxCycle = (SELECT CAST(SCP.attrVal AS INT)
						FROM APP_SubClientProp AS SCP
						WHERE SCP.ComponentNameID = @AppID
							AND attrName = 'Archival Cycle Num'
							AND modified = 0)
			IF ( (@CurrentIdxCycle >= @NewIdxCycle)  )
				RETURN 1
			ELSE
				RETURN 0
		END
		ELSE
		BEGIN
			IF ( @AppTypeID IN (47, 50) AND (@BackupType & 0x80000 = 0x80000))
				RETURN 1
			ELSE
				RETURN 0
		END
		RETURN 0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsSchdBackupTypeFull]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsSchdBackupTypeFull' AND revision = '1.2')

  insert into GXDBVersions values(5, 'IsSchdBackupTypeFull',  '1.2', 'IsSchdBackupTypeFull', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsSchdBackupTypeIncr.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsSchdBackupTypeIncr'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsSchdBackupTypeIncr]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsSchdBackupTypeIncr]
  delete from GXDBVersions where name = 'IsSchdBackupTypeIncr' and type = 5
END
GO

	CREATE  FUNCTION IsSchdBackupTypeIncr (@AppTypeID int, @AppId int, @BackupType int)
	RETURNS INT
	WITH ENCRYPTION
	BEGIN
		IF ( @AppTypeID IN (45,56,57,58,66,73,82,83,89,90) AND ((@BackupType = 2) OR (@BackupType & 0x800000 = 0x800000)) )
		BEGIN
			DECLARE		@NewIdxCycle	integer
			DECLARE		@CurrentIdxCycle	integer
			SET @NewIdxCycle = (SELECT CAST(SCP.attrVal AS INT)
						FROM APP_SubClientProp AS SCP
						WHERE SCP.ComponentNameID = @AppID
							AND attrName = 'New Index Cycle'
							AND modified = 0)
			SET @CurrentIdxCycle = (SELECT CAST(SCP.attrVal AS INT)
						FROM APP_SubClientProp AS SCP
						WHERE SCP.ComponentNameID = @AppID
							AND attrName = 'Archival Cycle Num'
							AND modified = 0)
			IF ( (@CurrentIdxCycle >= @NewIdxCycle)  )
				RETURN 0
			ELSE
				RETURN 1
		END
		ELSE IF ( @AppTypeID IN (8, 9, 14, 15, 26, 27, 30, 31, 35, 44, 45, 53, 54, 55, 56, 57, 67, 68, 82, 105) AND (@BackupType & 0x1000000 = 0x1000000) )
		BEGIN
			DECLARE		@BackupLevel	integer
			SET @BackupLevel = ISNULL( (SELECT CAST(SCP.attrVal AS INT)
						FROM APP_SubClientProp AS SCP
						WHERE SCP.ComponentNameID = @AppID
							AND SCP.attrName = 'Backup Level'
							AND SCP.modified = 0), 0x02)
			IF (@BackupLevel = 0x02)
				RETURN 1
			ELSE
				RETURN 0
		END
		ELSE
		BEGIN
			IF ( @AppTypeID IN (47, 50) AND (@BackupType & 0x100000 = 0x100000))
				RETURN 1
			ELSE
				RETURN 0
		END
		RETURN 0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsSchdBackupTypeIncr]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsSchdBackupTypeIncr' AND revision = '1.2')

  insert into GXDBVersions values(5, 'IsSchdBackupTypeIncr',  '1.2', 'IsSchdBackupTypeIncr', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsSchdBackupTypeDiff.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsSchdBackupTypeDiff'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsSchdBackupTypeDiff]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsSchdBackupTypeDiff]
  delete from GXDBVersions where name = 'IsSchdBackupTypeDiff' and type = 5
END
GO

	CREATE  FUNCTION IsSchdBackupTypeDiff (@AppTypeID int, @AppId int, @BackupType int)
	RETURNS INT
	WITH ENCRYPTION
	BEGIN
		IF ( @AppTypeID IN (8, 9, 14, 15, 26, 27, 30, 31, 35, 44, 45, 53, 54, 55, 56, 57, 67, 68, 82, 105) AND (@BackupType & 0x1000000 = 0x1000000) )
		BEGIN
			DECLARE		@BackupLevel	integer
			SET @BackupLevel = ISNULL( (SELECT CAST(SCP.attrVal AS INT)
						FROM APP_SubClientProp AS SCP
						WHERE SCP.ComponentNameID = @AppID
							AND SCP.attrName = 'Backup Level'
							AND SCP.modified = 0), 0x02)
			IF (@BackupLevel = 0x03)
				RETURN 1
			ELSE
				RETURN 0
		END
		RETURN 0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsSchdBackupTypeDiff]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsSchdBackupTypeDiff' AND revision = '1.2')

  insert into GXDBVersions values(5, 'IsSchdBackupTypeDiff',  '1.2', 'IsSchdBackupTypeDiff', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsInstanceValid.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsInstanceValid'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsInstanceValid]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsInstanceValid]
  delete from GXDBVersions where name = 'IsInstanceValid' and type = 5
END
GO

	CREATE  FUNCTION IsInstanceValid (@AppTypeID int)
	RETURNS INT
	WITH ENCRYPTION
	BEGIN
		IF ( @AppTypeID IN (
						0,		-- CV_APPTYPE_NOT_DEFINED
						1,		-- UNUSED_CV_APPTYPE_1
						12,		-- CV_APPTYPE_NETWARE_FS
						10,		-- CV_APPTYPE_NDS
						11,		-- UNUSED_CV_APPTYPE_11
						13,		-- CV_APPTYPE_NAS_FS
						17,		-- CV_APPTYPE_HPUX32_FS
						18,		-- UNUSED_CV_APPTYPE_18
						19,		-- CV_APPTYPE_SOLARIS32_FS
						20,		-- UNUSED_CV_APPTYPE_20
						21,		-- CV_APPTYPE_AIX_FS
						24,		-- UNUSED_CV_APPTYPE_24
						25,		-- LEGACY_CV_APPTYPE_PROXYHOST
						28,		-- UNUSED_CV_APPTYPE_28
						29,		-- CV_APPTYPE_LINUX_FS
						33,		-- CV_APPTYPE_WINDOWS_FILESYSTEM
						34,		-- LEGACY_CV_APPTYPE_XP64_BIT
						36,		-- CV_APPTYPE_UNIX_TRU64_FS_64
						38,		-- UNUSED_CV_APPTYPE_38
						40,		-- LEGACY_CV_APPTYPE_UNIX_PROXYHOST
						41,		-- CV_APPTYPE_GRANULAR_AD
						42,		-- LEGACY_CV_APPTYPE_WIN2003_32BIT
						43,		-- LEGACY_CV_APPTYPE_WIN2003_64BIT
						47,		-- CV_APPTYPE_QR_AGENT
						48,		-- UNUSED_CV_APPTYPE_48
						50,		-- CV_APPTYPE_UNIX_REPLICATION_IDA
						1000,	-- CV_APPTYPE_COMMSRVMGMT
						63,		-- CV_APPTYPE_APPLEMAC_FS
						64,		-- CV_APPTYPE_SGI_FS
						65,		-- CV_APPTYPE_IMAGE_WINFS_IDA
						66,		-- CV_APPTYPE_UNIX_FS_DATA_MIGRATOR
						8,		-- UNUSED_CV_APPTYPE_8
						9,		-- UNUSED_CV_APPTYPE_9
						14,		-- LEGACY_CV_APPTYPE_14
						15,		-- LEGACY_CV_APPTYPE_15
						26,		-- UNUSED_CV_APPTYPE_26
						27,		-- UNUSED_CV_APPTYPE_27
						30,		-- UNUSED_CV_APPTYPE_30
						31,		-- UNUSED_CV_APPTYPE_31
						35,		-- UNUSED_CV_APPTYPE_35
						44,		-- UNUSED_CV_APPTYPE_44
						45,		-- UNUSED_CV_APPTYPE_45
						53,		-- CV_APPTYPE_MSEXCHANGE_DATABASE
						54,		-- CV_APPTYPE_MSEXCHANGE_MAILBOX
						55,		-- CV_APPTYPE_MSEXCHANGE_WEB_FOLDER
						56,		-- UNUSED_CV_APPTYPE_57
						57,		-- UNUSED_CV_APPTYPE_57
						67,		-- CV_APPTYPE_MS_EXCHANGE_ARCHIVER
						68,		-- UNUSED_CV_APPTYPE_68
						46,		-- UNUSED_CV_APPTYPE_46
						69,		-- CV_APPTYPE_MS_SHAREPOINTV2_DB
						71,		-- CV_APPTYPE_GROUPWISEDB
						74,		-- CV_APPTYPE_FREE_BSD
						75,		-- CV_APPTYPE_IMAGE_UNIXFS_IDA
						76,		-- CV_APPTYPE_PROXYHOST_IMAGELEVEL
						78,		-- CV_APPTYPE_MS_SHAREPOINTV2_DOC
						82,			-- Data Migrator for Exchange Public Folder
						83,			-- DataMigrator for Netware
						84,			-- File Replication
						86,			-- OES File System on Linux
						87,			-- Image Level ProxyHost on Unix
						91,			-- Data Protection Manager
						93,			-- Content Indexing Agent
						105,		-- CI For Exchange Mailbox
						107,		-- Workstation Backup
						600,		-- SRM Agent For Windows File Systems
						605,		-- SRM Agent For UNIX File Systems
						606			-- SRM Agent For Exchange
						)
				)
		BEGIN
			RETURN 0
		END
		RETURN 1
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsInstanceValid]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsInstanceValid' AND revision = '1.5')

  insert into GXDBVersions values(5, 'IsInstanceValid',  '1.5', 'IsInstanceValid', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2FUNC_GetMediaValidData.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2FUNC_GetMediaValidData'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2FUNC_GetMediaValidData]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2FUNC_GetMediaValidData]
  delete from GXDBVersions where name = 'MMS2FUNC_GetMediaValidData' and type = 5
END
GO

	CREATE FUNCTION MMS2FUNC_GetMediaValidData( @MediaId int )
		RETURNS bigint
		AS
		BEGIN
			DECLARE @ValidData	bigint

			DECLARE @tblAFChunk TABLE (archFileId int, afCommcellId int, archChunkId bigint, acCommCellId int, archCopyId int, dedupedSize bigint)
			--create index tblAFChunk_archFileId on @tblAFChunk (archFileId, CommCellId)

			INSERT INTO @tblAFChunk
			SELECT A.archFileId, A.commCellId, A.archChunkId, A.chunkCommcellId, A.archCopyId, A.dedupedSize
			FROM  ArchChunkMapping A INNER JOIN
			( SELECT Id, CommcellId FROM ArchChunk WHERE VolumeId IN
				(SELECT VolumeId FROM MMVolume WHERE MediaId = @MediaId)) B
			ON A.ArchChunkId = B.Id and A.chunkCommcellId = B.CommcellId

			delete @tblAFChunk
			from @tblAFChunk t, archFile af
			where af.id = t.archFileId and af.commCellId = t.afCommcellid
			and af.isvalid <> 1

			select @ValidData = sum(dedupedSize) from @tblAFChunk

			RETURN 	@ValidData
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2FUNC_GetMediaValidData]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2FUNC_GetMediaValidData' AND revision = '1.4')

  insert into GXDBVersions values(5, 'MMS2FUNC_GetMediaValidData',  '1.4', 'MMS2FUNC_GetMediaValidData', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDiffFromCSTimeZone.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDiffFromCSTimeZone'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDiffFromCSTimeZone]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDiffFromCSTimeZone]
  delete from GXDBVersions where name = 'GetDiffFromCSTimeZone' and type = 5
END
GO

	CREATE FUNCTION GetDiffFromCSTimeZone(@i_time INTEGER, @i_TimeZone VARCHAR(255), @i_csTimeZone VARCHAR(255))
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
	IF @i_TimeZone = '' RETURN 0
	IF @i_csTimeZone = ''
		SET	@i_csTimeZone = dbo.GetClientTimeZone(2)
	RETURN ( dbo.GetUnixTime(dbo.UTCToLocalTime(dbo.GetDateTime(@i_time), @i_TimeZone))
			-dbo.GetUnixTime(dbo.UTCToLocalTime(dbo.GetDateTime(@i_time), @i_csTimeZone)) )
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDiffFromCSTimeZone]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDiffFromCSTimeZone' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetDiffFromCSTimeZone',  '1.4', 'GetDiffFromCSTimeZone', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsAppTypeExists.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsAppTypeExists'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsAppTypeExists]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsAppTypeExists]
  delete from GXDBVersions where name = 'IsAppTypeExists' and type = 5
END
GO

	CREATE FUNCTION IsAppTypeExists(@appGroup int, @appType int, @typeOfGroup int = 0 )
		RETURNS INT
		AS
		BEGIN
			DECLARE @calType INT
			set @calType = 0
			IF EXISTS ( select APP_APPTYPEGROUPASSOC.appGroupId, APP_APPTYPEGROUPASSOC.appTypeId from  APP_APPTYPEGROUPASSOC where APP_APPTYPEGROUPASSOC.appGroupId = @appGroup and APP_APPTYPEGROUPASSOC.typeOfGroup = @typeOfGroup and APP_APPTYPEGROUPASSOC.appTypeId = @appType )
			BEGIN
				set @calType = 1
			END

			return @calType
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsAppTypeExists]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsAppTypeExists' AND revision = '1.3')

  insert into GXDBVersions values(5, 'IsAppTypeExists',  '1.3', 'IsAppTypeExists', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetAppTypesForAppGroup.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAppTypesForAppGroup'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAppTypesForAppGroup]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAppTypesForAppGroup]
  delete from GXDBVersions where name = 'GetAppTypesForAppGroup' and type = 5
END
GO

	CREATE FUNCTION dbo.GetAppTypesForAppGroup
	(
		@appGroupId integer,
		@typeOfGroup int = 0
	)
	RETURNS
	@AppTypeIds table
	(
		appTypeId integer
	)
	AS
	BEGIN
		DECLARE @_copyAppTypeid int

			insert into @AppTypeIds  select appTypeId from APP_AppTypeGroupAssoc where
			appGroupId=@appGroupId and typeOfGroup=@typeOfGroup


		RETURN
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAppTypesForAppGroup]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAppTypesForAppGroup' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetAppTypesForAppGroup',  '1.2', 'GetAppTypesForAppGroup', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DecodeInvalidXMLChar.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DecodeInvalidXMLChar'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DecodeInvalidXMLChar]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DecodeInvalidXMLChar]
  delete from GXDBVersions where name = 'DecodeInvalidXMLChar' and type = 5
END
GO

	CREATE FUNCTION DecodeInvalidXMLChar(@inputString nvarchar(max))
	RETURNS nvarchar(max)

	AS
	BEGIN
		return dbo.decodeInvalidXMLCharsCLR(@inputString)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DecodeInvalidXMLChar]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DecodeInvalidXMLChar' AND revision = '1.4')

  insert into GXDBVersions values(5, 'DecodeInvalidXMLChar',  '1.4', 'DecodeInvalidXMLChar', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/EncodeInvalidXMLChar.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: EncodeInvalidXMLChar'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[EncodeInvalidXMLChar]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[EncodeInvalidXMLChar]
  delete from GXDBVersions where name = 'EncodeInvalidXMLChar' and type = 5
END
GO

	CREATE FUNCTION EncodeInvalidXMLChar(@inputstring nvarchar(max))
	RETURNS nvarchar(max)
	AS
	BEGIN
					DECLARE @outputstring nvarchar(max)
						SET @outputstring = ''
					DECLARE @length int
						SET @length = LEN(@inputstring)
					DECLARE @pos int
						SET @pos = 1
					DECLARE @hexVal varbinary(4)
						SET @hexVal = 0
					DECLARE @hexStr varchar(16)
						SET @hexStr = ''
					DECLARE @invalidCharFound int
						SET @invalidCharFound = 0
					DECLARE @currentChar nvarchar(1)
					WHILE @pos < (@length + 1)
					BEGIN
						SET @currentChar = SUBSTRING(@inputstring, @pos, 1)
						DECLARE @currentCharBin int
						SET @currentCharBin = unicode(@currentChar)

						IF  (@currentCharBin = 0x9) OR (@currentCharBin = 0xA) OR (@currentCharBin = 0xD )
								OR ((@currentCharBin >= 0x20) AND (@currentCharBin <= 0xD7FF))
								OR ((@currentCharBin >= 0xE000) AND (@currentCharBin <= 0xFFFD))  --((ch >= 0x10000) && (ch <= 0x10FFFF))  -- wchar max size is 2 bytes so commenting the condition
						BEGIN
							SET @outputstring = @outputstring + @currentChar
						END
						ELSE
						BEGIN
							SET @invalidCharFound = 1
							SET @outputstring = @outputstring + '|#'
							SET @hexVal = CAST(unicode(@currentChar) AS varbinary(2)) -- each nvarchar is 2 bytes
							SET @hexStr = master.dbo.fn_varbintohexstr(@hexVal)
							SET @hexStr = SUBSTRING(@hexStr,3,16)
							SET @outputstring = @outputstring + @hexStr + '!'
						END
						SET @pos = @pos + 1
					END
					IF @invalidCharFound <> 0
					BEGIN
						SET @outputstring = '|' + @outputstring
					END
					return @outputstring
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [EncodeInvalidXMLChar]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'EncodeInvalidXMLChar' AND revision = '1.9')

  insert into GXDBVersions values(5, 'EncodeInvalidXMLChar',  '1.9', 'EncodeInvalidXMLChar', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/ArchGroupTimeZone.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ArchGroupTimeZone'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ArchGroupTimeZone]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ArchGroupTimeZone]
  delete from GXDBVersions where name = 'ArchGroupTimeZone' and type = 5
END
GO

	CREATE FUNCTION ArchGroupTimeZone(@i_archGroupId integer, @i_clientId integer)
	RETURNS VARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE	@l_TimeZone		VARCHAR(255)
	DECLARE	@l_TimeZoneType	INTEGER
	SELECT	@l_TimeZone = TimeZone, @l_TimeZoneType = TimeZoneType
	FROM	archGroup WITH (NOLOCK)
	WHERE	id = @i_archGroupId
	IF	@l_TimeZoneType = 0
		SET @l_TimeZone = ''
	ELSE
	IF	@l_TimeZoneType = 1 AND @i_clientId > 0
		SET	@l_TimeZone = dbo.GetClientTimeZone(@i_clientId)
	RETURN @l_TimeZone
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ArchGroupTimeZone]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ArchGroupTimeZone' AND revision = '1.2')

  insert into GXDBVersions values(5, 'ArchGroupTimeZone',  '1.2', 'ArchGroupTimeZone', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientHardwareName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientHardwareName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientHardwareName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientHardwareName]
  delete from GXDBVersions where name = 'GetClientHardwareName' and type = 5
END
GO

	CREATE FUNCTION GetClientHardwareName (@i_clientID INTEGER, @i_SimOSInfo varchar(255))
	RETURNS VARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE @simOSInfo		varchar(255)
		DECLARE @hwInfoPos		INTEGER
		IF @i_SimOSInfo IS NULL OR @i_SimOSInfo = ''
			SET @simOSInfo = ISNULL((SELECT attrval FROM APP_clientProp where componentNameId = @i_clientID AND attrname = 'Sim OS Info' AND modified = 0), '')
		ELSE
			SET @simOSInfo = @i_SimOSInfo
		IF @simOSInfo = ''
			RETURN ''
		SET @hwInfoPos = CHARINDEX('-:', REVERSE(@simOSInfo))-1
		IF @hwInfoPos = -1
		BEGIN
			SET @hwInfoPos = ISNULL((SELECT simOperatingSystemId FROM APP_client, APP_clientProp where APP_client.Id = @i_clientID AND  componentNameId = @i_clientID AND attrname = 'Sim OS Info' AND APP_clientProp.modified = 0), '')
			SET @simOSInfo = ISNULL((SELECT Name FROM simOperatingSystem where id = @hwInfoPos), '')
			IF @simOSInfo = 'DATA ONTAP'
			RETURN 'Network Appliance'
			IF @simOSInfo = 'Celerra'
			RETURN 'EMC Celerra'
		END
		RETURN substring(@simOSInfo, LEN(@simOSInfo) - @hwInfoPos + 1, @hwInfoPos + 1)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientHardwareName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientHardwareName' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetClientHardwareName',  '1.2', 'GetClientHardwareName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientOSName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientOSName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientOSName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientOSName]
  delete from GXDBVersions where name = 'GetClientOSName' and type = 5
END
GO

	CREATE FUNCTION GetClientOSName (@i_clientID INTEGER, @i_SimOSInfo varchar(255))
	RETURNS VARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE @simOSInfo		varchar(255)
		DECLARE @osName			varchar(255)
		DECLARE @osRel			varchar(255)
		DECLARE @hwInfoPos		INTEGER
		IF @i_SimOSInfo IS NULL OR @i_SimOSInfo = ''
			SET @simOSInfo = ISNULL((SELECT attrval FROM APP_clientProp where componentNameId = @i_clientID AND attrname = 'Sim OS Info' AND modified = 0), '')
		ELSE
			SET @simOSInfo = @i_SimOSInfo
		IF @simOSInfo = ''
			RETURN ''
		SET @osName = substring(@simOSInfo, 0, CHARINDEX(':-', @simOSInfo))
		IF CHARINDEX('Windows', @osName) = 0
		BEGIN
		SET @osRel = substring(@simOSInfo, CHARINDEX(':-', @simOSInfo) + 2, LEN(@simOSInfo) - LEN(CHARINDEX(':-', @simOSInfo)))
		SET @osName = @osName + ' ' + substring(@osRel, 0, CHARINDEX(':-', @osRel))
		END
		IF @osName = ''
		BEGIN
			SET @osName = substring(@simOSInfo, 0, CHARINDEX(':', @simOSInfo))
			IF @osName like 'NetApp Release%'
			SET @osName = ISNULL((SELECT Name FROM simOperatingSystem where id = (SELECT simOperatingSystemId FROM APP_client where id = @i_clientID) ), '')
		END
		IF @osName = ''
		BEGIN
			SET @osName = @simOSInfo
		END
		RETURN @osName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientOSName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientOSName' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetClientOSName',  '1.4', 'GetClientOSName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientOSRelease.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientOSRelease'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientOSRelease]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientOSRelease]
  delete from GXDBVersions where name = 'GetClientOSRelease' and type = 5
END
GO

	CREATE FUNCTION GetClientOSRelease (@i_clientID INTEGER, @i_SimOSInfo varchar(255))
	RETURNS VARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE @simOSInfo		varchar(255)
	 	DECLARE @osRelease		varchar(255)
		DECLARE @hwInfoPos		INTEGER
		IF @i_SimOSInfo IS NULL OR @i_SimOSInfo = ''
			SET @simOSInfo = ISNULL((SELECT attrval FROM APP_clientProp where componentNameId = @i_clientID AND attrname = 'Sim OS Info' AND modified = 0), '')
		ELSE
			SET @simOSInfo = @i_SimOSInfo
		IF @simOSInfo = ''
			RETURN ''
		SET @osRelease = substring(@simOSInfo, CHARINDEX(':-', @simOSInfo) + 2, LEN(@simOSInfo) - LEN(CHARINDEX(':-', @simOSInfo)))
		SET @osRelease = substring(@osRelease , 0, CHARINDEX(':-', @osRelease))
		RETURN @osRelease
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientOSRelease]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientOSRelease' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetClientOSRelease',  '1.2', 'GetClientOSRelease', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientOSVersion.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientOSVersion'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientOSVersion]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientOSVersion]
  delete from GXDBVersions where name = 'GetClientOSVersion' and type = 5
END
GO

	CREATE FUNCTION GetClientOSVersion (@i_clientID INTEGER, @i_SimOSInfo varchar(255))
	RETURNS VARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE @simOSInfo		varchar(255)
	 	DECLARE @osVersion		varchar(255)
		IF @i_SimOSInfo IS NULL OR @i_SimOSInfo = ''
			SET @simOSInfo = ISNULL((SELECT attrval FROM APP_clientProp where componentNameId = @i_clientID AND attrname = 'Sim OS Info' AND modified = 0), '')
		ELSE
			SET @simOSInfo = @i_SimOSInfo
		IF @simOSInfo = ''
			RETURN ''
		SET @osVersion = substring(@simOSInfo, CHARINDEX(':-', @simOSInfo) + 2, LEN(@simOSInfo) - LEN(CHARINDEX(':-', @simOSInfo)))
		SET @osVersion = substring(@osVersion, CHARINDEX(':-', @osVersion) + 2, LEN(@osVersion) - LEN(CHARINDEX(':-', @osVersion)))
		SET @osVersion = substring(@osVersion , 0, CHARINDEX(':-', @osVersion))
		IF @osVersion = ''
		BEGIN
			IF @simOSInfo like 'NetApp Release%'
			SET @i_SimOSInfo = CHARINDEX(':', REVERSE(@simOSInfo))-4
			RETURN substring(@simOSInfo, LEN(@simOSInfo) - @i_SimOSInfo + 1, @i_SimOSInfo + 1)
		END
		RETURN @osVersion
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientOSVersion]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientOSVersion' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetClientOSVersion',  '1.2', 'GetClientOSVersion', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClusterClientsForClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClusterClientsForClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClusterClientsForClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClusterClientsForClient]
  delete from GXDBVersions where name = 'GetClusterClientsForClient' and type = 5
END
GO

	CREATE FUNCTION dbo.GetClusterClientsForClient
	(
		@i_clientId integer
	)
	RETURNS
	@clientIds table
	(
		id integer
	)
	AS
	BEGIN
	-- Need to EXEC CCM_Create_Synonyms '<database name>' before invoking this function, will fail otherwise
	-- Because of CCM Capture From Other DB framework
	DECLARE @virtual_client table (id int)
    DECLARE @physical_client table (id int)
	DECLARE @capture_table table (id int)
	DECLARE @vclient_count int
	DECLARE @pclient_count int
    SET @vclient_count = 0
	SET @pclient_count = 0
	INSERT INTO @virtual_client
	SELECT DISTINCT VMClientId
	FROM CCM_SOURCE_APP_VMToPMMap
	WHERE VMClientId = @i_clientId
	INSERT INTO @physical_client
	SELECT DISTINCT PMClientId
	FROM CCM_SOURCE_APP_VMToPMMap
	WHERE PMClientId = @i_clientId
	SET @vclient_count = (SELECT COUNT(*) FROM @virtual_client)
	SET @pclient_count = (SELECT COUNT(*) FROM @physical_client)
	-- Ideally, in any iteration of the loop, one of the two count
	-- will be zero and only one inner if block will be executed
	-- The complex while logic is required because the requirement is to
	-- ensure that the complete cluster configuration is captured.
	/*
	  Example:
	  Cluster 1 : V1 and P1, P2
	  Cluster 2 : V2 and P1, P3
	  Any request to capture cluster V1 will capture, V1, P1, P2, V2 and P3
	 */
	WHILE (@vclient_count > 0 OR @pclient_count > 0)
	BEGIN
		   IF(@vclient_count > 0)
		   BEGIN
		     DELETE FROM @physical_client
		     INSERT INTO @physical_client
		     SELECT DISTINCT PMClientId from CCM_SOURCE_APP_VMToPMMap
		     where VMClientId IN (select id from @virtual_client)
		       and PMClientId NOT IN (select id from @capture_table)
		     INSERT INTO @capture_table
		     SELECT id FROM @physical_client
		     WHERE  id NOT IN (select id from @capture_table)
		     DELETE FROM @virtual_client
		   END
		   IF(@pclient_count > 0)
		   BEGIN
		     DELETE FROM @virtual_client
		     INSERT INTO @virtual_client
		     SELECT DISTINCT VMClientId from CCM_SOURCE_APP_VMToPMMap
		     where PMClientId IN (select id from @physical_client)
		       and VMClientId NOT IN (select id from @capture_table)
		     INSERT INTO @capture_table
		     SELECT id FROM @virtual_client
		     WHERE  id NOT IN (select id from @capture_table)
		     DELETE FROM @physical_client
		   END
		     SET @vclient_count = (SELECT COUNT(*) FROM @virtual_client)
		     SET @pclient_count = (SELECT COUNT(*) FROM @physical_client)
	 END
	 INSERT INTO @clientIds
	 SELECT id FROM @capture_table
		RETURN
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClusterClientsForClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClusterClientsForClient' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetClusterClientsForClient',  '1.4', 'GetClusterClientsForClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDependentSubClientForSubClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDependentSubClientForSubClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDependentSubClientForSubClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDependentSubClientForSubClient]
  delete from GXDBVersions where name = 'GetDependentSubClientForSubClient' and type = 5
END
GO

	CREATE FUNCTION dbo.GetDependentSubClientForSubClient
	(
		@i_sub_clientId integer,
        @time_from integer,
        @time_to integer
	)
	RETURNS
	@subClientIds table
	(
		id integer
	)
	AS
	BEGIN
	-- Need to EXEC CCM_Create_Synonyms '<database name>' before invoking this function, will fail otherwise
	-- Because of CCM Capture From Other DB framework
	DECLARE @lt_CCM_ArchFile TABLE(id integer, commCellId integer, appId integer, jobId integer, cTime integer)
	INSERT INTO @lt_CCM_ArchFile
	SELECT id , commCellId , appId , jobId , cTime
	FROM CCM_SOURCE_ArchFile
	WHERE appId = @i_sub_clientId
	IF (@time_from > 0) OR (@time_to > 0)
	BEGIN
		DECLARE @jobToCapture TABLE(jobId integer, commcellId integer, startTime integer, endTime integer)
		INSERT INTO @jobToCapture
		SELECT jobId, commCellId, MIN(cTime), MAX(cTime)
		FROM @lt_CCM_ArchFile
		WHERE appId = @i_sub_clientId
		GROUP BY jobId, commCellId
		IF @time_from > 0
			DELETE @lt_CCM_ArchFile
			FROM @lt_CCM_ArchFile a, @jobToCapture b
			WHERE a.jobId = b.jobId
			AND a.commCellId = b.commCellId
			AND a.appId = @i_sub_clientId
			AND	b.startTime < @time_from
		IF @time_to > 0
			DELETE @lt_CCM_ArchFile
			FROM @lt_CCM_ArchFile a, @jobToCapture b
			WHERE a.jobId = b.jobId
			AND a.commCellId = b.commCellId
			AND a.appId = @i_sub_clientId
			AND	b.endTime > @time_to
		DELETE @jobToCapture
	END
		DECLARE @parentJobs        TABLE(jobId integer, commcellId integer)
		DECLARE @childJobs         TABLE(jobId integer, commcellId integer)
		DECLARE @parent_count      INTEGER
		DECLARE @child_count       INTEGER
		DECLARE @to_capture_parent TABLE(jobId integer, commcellId integer)
		DECLARE @to_capture_child  TABLE(jobId integer, commcellId integer)
		INSERT INTO @childJobs
		SELECT DISTINCT a.childJobId, a.commCellId
		FROM CCM_SOURCE_JMJobDataLink a, @lt_CCM_ArchFile b
		WHERE a.parentJobId = b.jobId AND a.commCellId = b.commCellId
		AND (SELECT COUNT(*)
		     FROM   @lt_CCM_ArchFile c
		     WHERE  a.childJobId = c.jobId
		       AND  a.commCellId = c.commCellId) = 0
		INSERT INTO @parentJobs
		SELECT DISTINCT a.parentJobId, a.commCellId
		FROM CCM_SOURCE_JMJobDataLink a, @lt_CCM_ArchFile b
		WHERE a.childJobId = b.jobId AND a.commCellId = b.commCellId
		AND (SELECT COUNT(*)
		     FROM   @lt_CCM_ArchFile c
		     WHERE  a.parentJobId = c.jobId
		       AND  a.commCellId  = c.commCellId) = 0
		SET @parent_count = (SELECT COUNT(*) FROM @parentJobs)
		SET @child_count = (SELECT COUNT(*) FROM @childJobs)
		WHILE (@parent_count > 0 OR @child_count > 0)
		BEGIN
			INSERT INTO @to_capture_parent
			SELECT jobId, commCellId
			FROM @parentJobs
			INSERT INTO @to_capture_child
			SELECT jobId, commCellId
			FROM @childJobs
			DELETE FROM @parentJobs
			DELETE FROM @childJobs
			INSERT INTO @parentJobs
			SELECT DISTINCT a.parentJobId, a.commCellId
			FROM   CCM_SOURCE_JMJobDataLink a, @to_capture_child b
			WHERE  a.childJobId = b.jobId AND a.commCellId = b.commCellId
			AND    (SELECT COUNT(*)
			        FROM @to_capture_parent c
			        WHERE c.jobId = a.parentJobId
			          AND c.commCellId = a.commCellId) = 0
		        AND    (SELECT COUNT(*)
		                FROM @lt_CCM_ArchFile d
		                WHERE d.jobId = a.parentJobId
		                  AND d.commCellId = a.commCellId) = 0
		        INSERT INTO @childJobs
		        SELECT DISTINCT a.childJobId, a.commCellId
		        FROM   CCM_SOURCE_JMJobDataLink a, @to_capture_parent b
		        WHERE  a.parentJobId = b.jobId AND a.commCellId = b.commCellId
		        AND    (SELECT COUNT(*)
		                FROM @to_capture_child c
		                WHERE c.jobId = a.childJobId
		                  AND c.commCellId = a.commCellId) = 0
			AND    (SELECT COUNT(*)
					FROM @lt_CCM_ArchFile d
					WHERE d.jobID = a.childJobId
					  AND d.commCellId = a.commCellId) = 0
			SET @parent_count = (SELECT COUNT(*) FROM @parentJobs)
			SET @child_count = (SELECT COUNT(*) FROM @childJobs)
		END
		INSERT into @lt_CCM_ArchFile
		SELECT 	a.id , a.commCellId , a.appId , a.jobId , a.cTime
		FROM CCM_SOURCE_ArchFile a, @to_capture_parent b
		WHERE a.jobId = b.jobId
		AND   a.commCellId = b.commCellId
		    AND   (SELECT COUNT(*)
		           FROM   @lt_CCM_ArchFile c
		           WHERE  c.id = a.id
		           AND    c.commCellId = a.commCellId) = 0
		INSERT into @lt_CCM_ArchFile
		SELECT 	a.id , a.commCellId , a.appId , a.jobId , a.cTime
		FROM CCM_SOURCE_ArchFile a, @to_capture_child b
		WHERE a.jobId = b.jobId
		AND   a.commCellId = b.commCellId
		    AND   (SELECT COUNT(*)
		           FROM   @lt_CCM_ArchFile c
		           WHERE  c.id = a.id
		           AND    c.commCellId = a.commCellId) = 0
	 INSERT INTO @subClientIds
	 SELECT DISTINCT appId FROM @lt_CCM_ArchFile
	 WHERE appId <> @i_sub_clientId
		RETURN
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDependentSubClientForSubClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDependentSubClientForSubClient' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetDependentSubClientForSubClient',  '1.4', 'GetDependentSubClientForSubClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetCCPappType.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetCCPappType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetCCPappType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetCCPappType]
  delete from GXDBVersions where name = 'GetCCPappType' and type = 5
END
GO

	CREATE FUNCTION GetCCPappType(@inAppTypeId int)
	RETURNS INT
	AS
	BEGIN

	DECLARE @retType as integer = ISNULL((Select ccpType from app_idaType where type = @inAppTypeId), 0)
		return @retType
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetCCPappType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetCCPappType' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetCCPappType',  '1.1', 'GetCCPappType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getXMLError.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getXMLError'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getXMLError]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getXMLError]
  delete from GXDBVersions where name = 'getXMLError' and type = 5
END
GO

	CREATE FUNCTION getXMLError(@MesageID bigint,@PARAM1 VARCHAR(MAX) = NULL,
	@PARAM2 VARCHAR(MAX) = NULL,@PARAM3 VARCHAR(MAX) = NULL,@PARAM4 VARCHAR(MAX) = NULL)
	RETURNS XML
	AS
	BEGIN
	DECLARE @XMLMessage XML
	DECLARE @XMLMessageTmp XML
	DECLARE @Message VARCHAR(MAX)
	DECLARE @MessageTmp VARCHAR(MAX)
	DECLARE @ArgCount INT
	DECLARE @ind INT
	DECLARE @SUBSTR VARCHAR(100)
	DECLARE @ArgPos		INTEGER
	DECLARE @ArgIndex	INTEGER
	DECLARE @DataType	INTEGER
	DECLARE @HexFlag	INTEGER
	DECLARE @FullFmtSpecLen	INTEGER
	DECLARE @LocaleID INTEGER
	SET @XMLMessageTmp = ''
	SET @LocaleID = 0
	select @ArgCount = ArgCount,@Message = Message
	from EvLocaleMsgs where MessageID = @MesageID AND LocaleID = @LocaleID
	SET @XMLMessage = CAST (@Message AS XML)
	DECLARE GetTextPos CURSOR
	FOR	SELECT ArgPos, ArgIndex, DataType, HexFlag, FullFmtSpecLen
		FROM EvLocaleMsgArgInfo
		WHERE MessageId = @MesageID
		AND LocaleId = @LocaleID
		ORDER BY ArgIndex DESC
	FOR READ ONLY
	OPEN GetTextPos
	FETCH NEXT FROM GetTextPos
	INTO @ArgPos, @ArgIndex, @DataType, @HexFlag, @FullFmtSpecLen
	while @@FETCH_STATUS = 0
	BEGIN
		IF @DataType = 13
		BEGIN
			SET @MessageTmp = CAST(dbo.getXMLError(@PARAM1,@PARAM2,@PARAM3,@PARAM4,0) AS VARCHAR(MAX))
			SET @XMLMessageTmp = '<EventCodeInfo> <Info English = "'+@MessageTmp+'"
										Code = "'+CAST(@PARAM1 AS VARCHAR(MAX))+'"/>
										<Param p1 = "'+CAST(@PARAM2 AS VARCHAR(MAX))+'"
												p2 = "'+CAST(@PARAM3 AS VARCHAR(MAX))+'"
												p3 = "'+CAST(@PARAM4 AS VARCHAR(MAX))+'" />
								</EventCodeInfo>'
			SET @Message = STUFF(@Message, @ArgIndex, @FullFmtSpecLen,@MessageTmp)
			IF @ArgPos = @ArgCount
				SET @Message = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
						<MediaManager_Error>
								<EventInfo>
								<Info English = "'+@Message+'"
								Code = "'+CAST(@MesageID AS VARCHAR(MAX))+'"/>
								<Param>
								'+CAST(@XMLMessageTmp AS VARCHAR(MAX))+'
								</Param>
								</EventInfo>
						</MediaManager_Error>'
		END
		ELSE IF @ArgPos = 1
			SET @Message = STUFF(@Message, @ArgIndex, @FullFmtSpecLen, @PARAM1)
		ELSE IF @ArgPos = 2
			SET @Message = STUFF(@Message, @ArgIndex, @FullFmtSpecLen, @PARAM2)
		ELSE IF @ArgPos = 3
		SET @Message = STUFF(@Message, @ArgIndex, @FullFmtSpecLen, @PARAM3)
		ELSE IF @ArgPos = 4
		SET @Message = STUFF(@Message, @ArgIndex, @FullFmtSpecLen, @PARAM4)
		FETCH NEXT FROM GetTextPos
			INTO @ArgPos, @ArgIndex, @DataType, @HexFlag, @FullFmtSpecLen
		END
    set   @XMLMessage = CAST(@Message AS XML)
	return @XMLMessage
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getXMLError]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getXMLError' AND revision = '')

  insert into GXDBVersions values(5, 'getXMLError',  '', 'getXMLError', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/formDB2PartitionClientIdString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: formDB2PartitionClientIdString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[formDB2PartitionClientIdString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[formDB2PartitionClientIdString]
  delete from GXDBVersions where name = 'formDB2PartitionClientIdString' and type = 5
END
GO

 	IF  NOT EXISTS (SELECT * FROM sys.types st WHERE st.name = N'DB2PartitionString')
 	BEGIN
 		CREATE TYPE DB2PartitionString AS TABLE (PartitionID int, clientID int)
 	END
	GO
	CREATE FUNCTION formDB2PartitionClientIdString(@DB2Partition  DB2PartitionString  READONLY)
	RETURNS NVARCHAR(MAX)
	AS

	BEGIN
		DECLARe @partitionString NVARCHAR(MAX)
		SET @partitionString = ''

		DECLARE DB2PartitionCur CURSOR STATIC FOR
		select distinct PartitionID, clientID from @DB2Partition

		OPEN  DB2PartitionCur

		DECLARE @clientId int
		DECLARE @partitionId int
		FETCH  NEXT FROM DB2PartitionCur INTO @partitionId, @clientId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF @partitionString <> ''
			BEGIN
				SET @partitionString = @partitionString + ' '
			END
			SET @partitionString = @partitionString + convert(nvarchar(32), @partitionId)
			SET @partitionString = @partitionString + ','
			SET @partitionString = @partitionString + convert(nvarchar(32), @clientId)

			FETCH NEXT FROM DB2PartitionCur INTO @partitionId, @clientId
		END

	    CLOSE       DB2PartitionCur
	    DEALLOCATE  DB2PartitionCur

		RETURN @partitionString
	END





GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [formDB2PartitionClientIdString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'formDB2PartitionClientIdString' AND revision = '1.3')

  insert into GXDBVersions values(5, 'formDB2PartitionClientIdString',  '1.3', 'formDB2PartitionClientIdString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/parseDB2PartitionClientIdString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: parseDB2PartitionClientIdString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[parseDB2PartitionClientIdString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[parseDB2PartitionClientIdString]
  delete from GXDBVersions where name = 'parseDB2PartitionClientIdString' and type = 5
END
GO

	CREATE FUNCTION parseDB2PartitionClientIdString(@partitionString NVARCHAR(MAX) )
	RETURNS @DB2PartitionClientIds TABLE (PartitionId INT , clientId INT)
	AS
	BEGIN
		DECLARE @inStrLen int
		DECLARE @partitionId int
		DECLARE @clientId int
		DECLARE @nextSeper int
		DECLARE @nextComma int

		DECLARE @element nvarchar(64)
		DECLARE @partitionIdStr nvarchar(64)
		DECLARE @clientIdStr nvarchar(64)

		SET  @inStrLen   = LEN(@partitionString)
		IF @inStrLen > 0
		BEGIN
			WHILE LEN(@partitionString) > 0
			BEGIN
				SET @nextSeper   = CHARINDEX(' ', @partitionString, 1)
				IF @nextSeper = 0
				BEGIN
					SET @partitionString = @partitionString+' '
					SET @nextSeper = @instrlen+1
				END

				SET @element    = RTRIM(LTRIM(SUBSTRING(@partitionString, 1, @nextSeper-1)))
				IF LEN(@element) > 0
				BEGIN
					SET @nextComma   = CHARINDEX(',', @partitionString, 1)
					IF @nextComma = 0
						BREAK

					SET @partitionIdStr    = RTRIM(LTRIM(SUBSTRING(@element, 1, @nextComma-1)))
					SET @clientIdStr    = RTRIM(LTRIM(SUBSTRING(@element, @nextComma+1, LEN(@element))))

					SET @partitionId = convert(int, @partitionIdStr)
					SET @clientId = convert(int, @clientIdStr)

					INSERT INTO @DB2PartitionClientIds VALUES(@partitionId, @clientId)
				END


				IF (@inStrLen - @nextSeper <= 0)
					BREAK

				SET @partitionString = SUBSTRING(@partitionString, @nextSeper+1, @inStrLen-@nextSeper)
				SET @inStrLen = LEN(@partitionString)

			END
		END

	   RETURN
	END




GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [parseDB2PartitionClientIdString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'parseDB2PartitionClientIdString' AND revision = '1.1')

  insert into GXDBVersions values(5, 'parseDB2PartitionClientIdString',  '1.1', 'parseDB2PartitionClientIdString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobOperationName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobOperationName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobOperationName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobOperationName]
  delete from GXDBVersions where name = 'GetJobOperationName' and type = 5
END
GO

	CREATE FUNCTION GetJobOperationName (@operationId INTEGER)
	RETURNS VARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @jobOperationName varchar(255)
	SELECT @jobOperationName =
				  CASE @operationId
			      WHEN 0 THEN 'No Operation'
				  WHEN 1 THEN 'All Operation'
				  WHEN 2 THEN 'Online'
				  WHEN 3 THEN 'Offline'
				  WHEN 4 THEN 'Backup'
				  WHEN 5 THEN 'Restore'
				  WHEN 6 THEN 'Import'
				  WHEN 7 THEN 'CvImport'
				  WHEN 8 THEN 'Media Init'
				  WHEN 9 THEN 'Media Recycle'
				  WHEN 10 THEN 'Prune'
				  WHEN 11 THEN 'CS DR Backup'
				  WHEN 12 THEN 'Index Restore'
				  WHEN 13 THEN 'Aux Copy'
				  WHEN 14 THEN 'Synthetic Full'
				  WHEN 15 THEN 'W2K System Restore'
				  WHEN 16 THEN 'W2K Full Build Restore'
				  WHEN 17 THEN 'Report'
				  WHEN 18 THEN 'Backup 3RD'
				  WHEN 19 THEN 'W2K Full Build Restore371'
				  WHEN 20 THEN 'SchedExport'
				  WHEN 21 THEN 'Media Inventory'
				  WHEN 22 THEN 'Snap Shot'
				  WHEN 23 THEN 'Create Replica'
				  WHEN 24 THEN 'Update Replica'
				  WHEN 25 THEN 'DM Outlook Restore'
				  WHEN 26 THEN 'Media Prediction'
				  WHEN 27 THEN 'Snap Recovery'
				  WHEN 28 THEN 'Schedule'
				  WHEN 29 THEN 'Quick DM Restore'
				  WHEN 30 THEN 'System State Backup'
				  WHEN 31 THEN 'Archive Check'
				  WHEN 32 THEN 'Tape Erase'
				  WHEN 33 THEN 'Shelf Mangement'
				  WHEN 34 THEN 'QR Copy Backup'
				  WHEN 35 THEN 'Patch Update'
				  WHEN 36 THEN 'Patch Download'
				  WHEN 37 THEN 'QR RollBack'
				  WHEN 38 THEN 'Selective Delete'
				  WHEN 39 THEN 'WorkFlow'
				  WHEN 40 THEN 'Index Free Restore'
				  WHEN 41 THEN 'Drive Validation'
				  WHEN 42 THEN 'Drive Cleaning'
				  WHEN 43 THEN 'SysRecovery Backup'
				  WHEN 44 THEN 'Browse And Delete'
				  WHEN 45 THEN 'Snap Vault Restore'
				  WHEN 46 THEN 'Stamp Media'
				  WHEN 47 THEN 'Catalogue Media'
				  WHEN 48 THEN 'SR System Recovery'
				  WHEN 49 THEN 'Search And Retrieve'
				  WHEN 50 THEN 'Create Consistency Point'
				  WHEN 51 THEN 'Create Recovery Point'
				  WHEN 52 THEN 'FLR Copy Backup'
				  WHEN 53 THEN 'Offline content Index'
				  WHEN 54 THEN 'Power Restore'
				  WHEN 55 THEN 'Power Search And Restore'
				  WHEN 56 THEN 'CDR'
				  WHEN 57 THEN 'Online Content Index'
				  WHEN 58 THEN 'SRM OpType'
				  WHEN 59 THEN 'Snap Backup'
				  WHEN 60 THEN 'Snap To Tape'
				  WHEN 61 THEN 'Snap Tp Tape WorkFlow'
				  WHEN 62 THEN 'SRM Report'
				  WHEN 63 THEN 'Maglib Maintenance'
				  WHEN 64 THEN 'Info Management'
				  WHEN 65 THEN 'Snap Backup3RD'
				  WHEN 66 THEN 'Offline Mining Restore'
				  WHEN 67 THEN 'Install Client'
				  WHEN 68 THEN 'UnInstall Client'
				  WHEN 69 THEN 'FDC WorkFlow'
				  WHEN 70 THEN 'Mining Backup'
				  WHEN 71 THEN 'CCM Capture'
				  WHEN 72 THEN 'CCM Merge'
				  WHEN 73 THEN 'FDC Client'
				  WHEN 74 THEN 'Media Refreshing'
				  WHEN 75 THEN 'FD CopyType'
				  WHEN 76 THEN 'Archive Optype'
				  WHEN 77 THEN 'Mining Content Index'
				  WHEN 78 THEN 'FDC Preparation'
				  WHEN 79 THEN 'Agentless SRM'
				  WHEN 80 THEN 'Dedup DB Reconstruction'
				  WHEN 81 THEN 'Tape Import'
				  WHEN 82 THEN 'Data Verification'
				  WHEN 83 THEN 'Other Admin Operation'
				  WHEN 84 THEN 'Upgrade Client'
				  WHEN 85 THEN 'Virtual Machine Management'
				  WHEN 86 THEN 'Log Monitoring'
				  WHEN 87 THEN 'Turbo NAS'
				  WHEN 88 THEN 'CommCell Synchronization'
				  WHEN 89 THEN 'Virtualize Machine'
				  WHEN 90 THEN 'Workflow Management'
				  WHEN 91 THEN 'PST Archiving'
				  WHEN 92 THEN 'Send Log Files'
				  WHEN 93 THEN 'Reference Copy Work Flow'
				  WHEN 94 THEN 'Smart Copy'
				  WHEN 95 THEN 'Delayed Catalog Work Flow'
				  WHEN 96 THEN 'Delayed Catalog'
				  WHEN 97 THEN 'PST Archiving'
				  WHEN 98 THEN 'Archive'
				  WHEN 99 THEN 'Move Partition'
				  WHEN 104 THEN 'Aux Copy'
				  ELSE 'UnKnown'  END
	RETURN @jobOperationName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobOperationName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobOperationName' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetJobOperationName',  '1.4', 'GetJobOperationName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobStatusName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobStatusName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobStatusName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobStatusName]
  delete from GXDBVersions where name = 'GetJobStatusName' and type = 5
END
GO

	CREATE FUNCTION GetJobStatusName (@statusId INTEGER)
	RETURNS VARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @jobStatusName varchar(255)
		SELECT @jobStatusName =
			CASE @statusId
			WHEN 1 THEN 'Success'
			WHEN 2 THEN 'Failed'
			WHEN 3 THEN 'PartialSuccess'
			WHEN 4 THEN 'Killed'
			WHEN 5 THEN 'Suspended'
			WHEN 6 THEN 'Interrupted'
			WHEN 9 THEN 'Failed to Start'
			ELSE 'Unknown' END
	RETURN @jobStatusName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobStatusName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobStatusName' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetJobStatusName',  '1.1', 'GetJobStatusName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobErrorName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobErrorName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobErrorName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobErrorName]
  delete from GXDBVersions where name = 'GetJobErrorName' and type = 5
END
GO

	CREATE FUNCTION GetJobErrorName (@errorId INTEGER)
	RETURNS VARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @jobErrorName varchar(255)
	SELECT @jobErrorName =
			CASE @errorId
			WHEN -1 THEN 'Multiple'
			WHEN 0 THEN ''
			WHEN 100 THEN 'Hardware'
			WHEN 150 THEN 'Indexing'
			WHEN 200 THEN 'Software'
			WHEN 300 THEN 'Application'
			WHEN 400 THEN 'Network'
			WHEN 500 THEN 'No Resources'
			WHEN 550 THEN 'Activity control'
			WHEN 600 THEN 'Operation Window'
			ELSE '' END
	RETURN @jobErrorName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobErrorName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobErrorName' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetJobErrorName',  '1.1', 'GetJobErrorName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobFailureReason.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobFailureReason'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobFailureReason]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobFailureReason]
  delete from GXDBVersions where name = 'GetJobFailureReason' and type = 5
END
GO

	CREATE FUNCTION GetJobFailureReason(@jobId integer)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
      DECLARE @resultStr NVARCHAR(1024)
      SELECT @resultStr = coalesce(@resultStr,'')+ failureReason + ','
      FROM JMBkpAtmptStats
      WHERE jobId= @jobId and failureReason not like ''
      RETURN @resultStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobFailureReason]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobFailureReason' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetJobFailureReason',  '1.1', 'GetJobFailureReason', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetMediaList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetMediaList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetMediaList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetMediaList]
  delete from GXDBVersions where name = 'GetMediaList' and type = 5
END
GO

	CREATE FUNCTION GetMediaList(@JobId integer)
	RETURNS VARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @mediaList VARCHAR(1024) SET @mediaList =''
		DECLARE @t_barcode VARCHAR(1024)
		DECLARE @t_mediaId INT
		IF @JobId >  0
		BEGIN
			DECLARE getMediaList CURSOR FOR
				SELECT DISTINCT M.mediaId, M.barcode FROM MMMedia M,JMJobResourceHistory R
				WHERE R.mediaId = M.mediaId AND R.jobid = @JobId
			OPEN getMediaList
			FETCH NEXT FROM getMediaList INTO @t_mediaId, @t_barcode
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF @mediaList != ''
					SET @mediaList = @mediaList + ', '
				IF  @t_barcode = 'CV_MAGNETIC'
					SET @mediaList = @mediaList + (SELECT aliasName from MMDrive where MediaId = @t_mediaId)
				ELSE
					SET @mediaList = @mediaList + @t_barcode
				FETCH NEXT FROM getMediaList INTO @t_mediaId, @t_barcode
			END
			CLOSE getMediaList
			DEALLOCATE getMediaList
		END
		RETURN @mediaList
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetMediaList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetMediaList' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetMediaList',  '1.1', 'GetMediaList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetPackageID.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetPackageID'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetPackageID]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetPackageID]
  delete from GXDBVersions where name = 'GetPackageID' and type = 5
END
GO

	CREATE FUNCTION GetPackageID (@i_appType INTEGER, @i_SimOSID INTEGER)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE	@packageID	INT
	 	DECLARE	@osType		VARCHAR(256)
	 	DECLARE	@osSubType	VARCHAR(256)
	 	DECLARE @pkgStartID	INT
	 	DECLARE @pkgEndID	INT
	 	SELECT @osType = type, @osSubType = subType FROM SimOperatingSystem WHERE id = @i_SimOSID
	 	SET @pkgStartID = (CASE @osType	WHEN 'Unix' THEN 1000
	 					WHEN 'Netware' THEN 2000
	 					ELSE 0 END)
	 	SET @pkgEndID	= (CASE @osType	WHEN 'Unix' THEN 2000
	 					WHEN 'Netware' THEN 3000
	 					ELSE 1000 END)
		IF @i_appType = 1001 AND @osType = 'Unix'				-- UNIX Base client
			SET @packageID = 1002
		ELSE IF @i_appType IN (17,19,21,29,36,63,64,74)			-- UNIX FileSystem
			SET @packageID = 1002
		ELSE IF @i_appType IN (11, 33, 34, 42, 43)				-- WIN FileSystem
			SET @packageID = 1
		ELSE IF (@i_appType = 1002)	AND (@osType = 'Windows')	-- WIN Media Agent
			SET @packageID = 51
	 	ELSE IF @i_appType = 1002 AND @osType = 'Unix'			-- UNIX Media Agent
	 		SET @packageID = 1301
	 	ELSE IF @i_appType = 44
	 		SET @packageID = 154
	 	ELSE IF @i_appType = 14
	 		SET @packageID = 152
	 	ELSE IF @i_appType = 15
	 		SET @packageID = 151
	 	ELSE
			SET @packageID = ISNULL((SELECT distinct simPackageId FROM simPackageMap WHERE appType = @i_appType AND simOSId IN (0, @i_SimOSID) AND simPackageId > @pkgStartID AND simPackageId < @pkgEndID), 0)
		IF @packageID = 0
			SET @packageID = ISNULL((SELECT distinct simPackageId FROM simPackageMap
						 WHERE appType = @i_appType AND simOSId IN
								(	select id from simOperatingSystem
									where type = @osType AND subType = @osSubType AND Version in ('new', 'any') AND PlatformType = 'Any')), 0)
		IF @packageID = 0
			SET @packageID = ISNULL((SELECT distinct simPackageId FROM simPackageMap WHERE appType = @i_appType AND simOSId = 0), 0)
		RETURN @packageID
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetPackageID]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetPackageID' AND revision = '1.9')

  insert into GXDBVersions values(5, 'GetPackageID',  '1.9', 'GetPackageID', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/canUserAnnotate.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: canUserAnnotate'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[canUserAnnotate]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[canUserAnnotate]
  delete from GXDBVersions where name = 'canUserAnnotate' and type = 5
END
GO

	CREATE FUNCTION canUserAnnotate (@UserGuid CHAR(36))
	RETURNS BIT
	WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE @ReturnValue BIT = 0
	 	DECLARE @capabilityMask bigint = POWER( 2.0, ( 32 - 1 ) )
	 	--UMCapability (id = EV_MANAGE_ANNOTATIONS) -- Annotation Management
	 	Select @ReturnValue = CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END
	 	From umusercredentials A
	 	join umusers b on a.userid = b.id and b.userguid = @UserGuid
	 	Where (capabilities &  @capabilityMask > 0)
	 	Return @ReturnValue
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [canUserAnnotate]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'canUserAnnotate' AND revision = '1.2')

  insert into GXDBVersions values(5, 'canUserAnnotate',  '1.2', 'canUserAnnotate', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DM2GetContainerCount.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DM2GetContainerCount'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DM2GetContainerCount]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DM2GetContainerCount]
  delete from GXDBVersions where name = 'DM2GetContainerCount' and type = 5
END
GO

	CREATE FUNCTION DM2GetContainerCount (@i_EntityType INT, @i_UserGUID char(36))
	RETURNS INT
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @count INT
	SELECT @count = COUNT(*) FROM DM2Container
	WHERE containerType = @i_EntityType and userid = (SELECT Id from UMUSers WHERE UserGuid = @i_UserGUID)
	 	RETURN @count
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DM2GetContainerCount]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DM2GetContainerCount' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DM2GetContainerCount',  '1.1', 'DM2GetContainerCount', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getRecentSuccessCITimeOfHold.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getRecentSuccessCITimeOfHold'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getRecentSuccessCITimeOfHold]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getRecentSuccessCITimeOfHold]
  delete from GXDBVersions where name = 'getRecentSuccessCITimeOfHold' and type = 5
END
GO

	CREATE FUNCTION getRecentSuccessCITimeOfHold (@i_ClientId int, @i_HoldType int)
	RETURNS INT
	AS
	BEGIN
	-- start function body
	RETURN
	(
		SELECT
			  TOP 1 servStartDate
		FROM
			  JMBkpStats J WITH (NOLOCK)
		INNER JOIN
		(
			  SELECT jobId, commCellId from archFile WITH (NOLOCK)
			  WHERE fileType = 1 AND appid in
				(
					SELECT Id FROM APP_Application TA WITH (NOLOCK)
					WHERE TA.ClientId = @i_ClientId AND TA.appTypeId IN (SELECT appType FROM dbo.getHoldsToAppTypeMapping(@i_HoldType))
				)
			  GROUP BY jobId , commCellId
			  HAVING MIN(flags) = 64 and MAX(flags) = 64
		) T
		ON
			  J.jobId = T.jobId AND J.CommCellId = T.commCellId
		INNER JOIN
			  APP_Application A WITH (NOLOCK)
		ON
			  A.id = J.appId
		WHERE
			  A.clientId IN (@i_ClientId) AND A.appTypeId IN (SELECT appType FROM dbo.getHoldsToAppTypeMapping(@i_HoldType))
				AND J.status in (1, 3, 14)
		ORDER BY
			  J.jobId desc
	)
	-- end function body
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getRecentSuccessCITimeOfHold]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getRecentSuccessCITimeOfHold' AND revision = '1.3')

  insert into GXDBVersions values(5, 'getRecentSuccessCITimeOfHold',  '1.3', 'getRecentSuccessCITimeOfHold', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getLowestRefTimeOfHold.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getLowestRefTimeOfHold'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getLowestRefTimeOfHold]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getLowestRefTimeOfHold]
  delete from GXDBVersions where name = 'getLowestRefTimeOfHold' and type = 5
END
GO

	CREATE FUNCTION getLowestRefTimeOfHold (@i_ClientId int, @i_HoldType int)
	RETURNS INT
	AS
	BEGIN
	-- start function body
		RETURN
		(
		SELECT TOP 1 referenceTime FROM JMReferenceCopy WITH(NOLOCK)
		WHERE refAppId in (
				SELECT id FROM APP_Application A WITH(NOLOCK)
				WHERE A.clientId = (@i_ClientId) AND A.appTypeId IN (SELECT appType FROM dbo.getHoldsToAppTypeMapping(@i_HoldType))
				)
		AND referenceTime > 0
		ORDER BY referenceTime
		)
	-- end function body
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getLowestRefTimeOfHold]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getLowestRefTimeOfHold' AND revision = '1.3')

  insert into GXDBVersions values(5, 'getLowestRefTimeOfHold',  '1.3', 'getLowestRefTimeOfHold', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getItemCountInLatestCycleOfHold.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getItemCountInLatestCycleOfHold'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getItemCountInLatestCycleOfHold]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getItemCountInLatestCycleOfHold]
  delete from GXDBVersions where name = 'getItemCountInLatestCycleOfHold' and type = 5
END
GO

	CREATE FUNCTION getItemCountInLatestCycleOfHold (@i_ClientId int, @i_HoldType int)
	RETURNS INT
	AS
	BEGIN
	-- start function body
	RETURN
		(
		SELECT SUM(J.totalNumOfFiles)
		FROM JMBkpStats J WITH (NOLOCK)
		INNER JOIN
			APP_Application A WITH(NOLOCK)
		ON
			J.appId = A.id
		INNER JOIN
				  APP_SubClientProp SP WITH(NOLOCK)
			ON
				SP.componentNameId = A.id AND SP.attrName = 'sys:full cycle num' AND SP.attrVal = J.fullCycleNum
		WHERE A.clientId = (@i_ClientId) AND A.appTypeId IN (SELECT appType FROM dbo.getHoldsToAppTypeMapping(@i_HoldType))
		AND j.status in ( 1 , 3 , 14)
		)
	-- end function body
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getItemCountInLatestCycleOfHold]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getItemCountInLatestCycleOfHold' AND revision = '1.3')

  insert into GXDBVersions values(5, 'getItemCountInLatestCycleOfHold',  '1.3', 'getItemCountInLatestCycleOfHold', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getBackupLevelText.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getBackupLevelText'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getBackupLevelText]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getBackupLevelText]
  delete from GXDBVersions where name = 'getBackupLevelText' and type = 5
END
GO

	CREATE FUNCTION getBackupLevelText (@bkpLevel int, @localeId int)
	RETURNS nvarchar(2048)
	AS
	BEGIN
	-- start function body
	DECLARE @messageNum int = CASE
    WHEN @bkpLevel = 1 THEN (773 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    WHEN @bkpLevel = 2 THEN (775 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    WHEN @bkpLevel = 4 THEN (778 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    WHEN @bkpLevel = 8 THEN (891 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    WHEN @bkpLevel IN (64,128,16384) THEN (779 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    WHEN @bkpLevel = 256 THEN (780 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    WHEN @bkpLevel = 512 THEN (776 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    WHEN @bkpLevel = 1024 THEN (781 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    WHEN @bkpLevel = 2048 THEN (1555 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    WHEN @bkpLevel = 4096 THEN (2066 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    WHEN @bkpLevel = 8192 THEN (1557 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    WHEN @bkpLevel = 32768 THEN (782 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    WHEN @bkpLevel = 131072 THEN (1708 | (CAST(POWER(2, 24) AS BIGINT) * 35))
    WHEN @bkpLevel = 262144 THEN (1709 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	END
	-- Return english message here. We may need to take localeId input later
	RETURN
	(
	SELECT Message FROM EvLocaleMsgs
	WHERE SubsystemID = 35 AND LocaleId = @localeId AND MessageID = @messageNum
	)
	-- end function body
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getBackupLevelText]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getBackupLevelText' AND revision = '1.3')

  insert into GXDBVersions values(5, 'getBackupLevelText',  '1.3', 'getBackupLevelText', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getCIStatusText.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getCIStatusText'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getCIStatusText]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getCIStatusText]
  delete from GXDBVersions where name = 'getCIStatusText' and type = 5
END
GO

	CREATE FUNCTION getCIStatusText (@jobId int, @localeId int)
	RETURNS nvarchar(2048)
	AS
	BEGIN
	-- declarations
	DECLARE @dataFilesCount int = 0
	DECLARE @successCICount int = 0
	DECLARE @partialCount int = 0
	DECLARE @pickedCount int = 0
	DECLARE @failedCount int = 0
	DECLARE @expiredCount int = 0
	DECLARE @notPickedCount int = 0
	DECLARE @status int = 0
	--determine counts in order to compute ci status of job..
	--SELECT @successCICount = count(*) FROM archFile WITH(NOLOCK) where jobid = @jobId AND isValid = 1 and fileType = 1 AND flags & CVA_AF_CI_SUCCESS_FLAG = CVA_AF_CI_SUCCESS_FLAG
	--SELECT @partialCount = count(*) FROM archFile WITH(NOLOCK) where jobid = @jobId AND isValid = 1 and fileType = 1 AND flags & CVA_AF_CI_PARTIAL_FLAG = CVA_AF_CI_PARTIAL_FLAG
	--SELECT @pickedCount = count(*) FROM archFile WITH(NOLOCK) where jobid = @jobId AND isValid = 1 and fileType = 1 AND flags & CVA_AF_CI_REQUIRED_FLAG = CVA_AF_CI_REQUIRED_FLAG
	--SELECT @failedCount = count(*) FROM archFile WITH(NOLOCK) where jobid = @jobId AND isValid = 1 and fileType = 1 AND flags & CVA_AF_CI_FAILURE_FLAG = CVA_AF_CI_FAILURE_FLAG
	--SELECT @expiredCount = count(*) FROM archFile WITH(NOLOCK) where jobid = @jobId AND isValid = 1 and fileType = 1 AND flags & CVA_AF_CI_EXPIRED_FLAG = CVA_AF_CI_EXPIRED_FLAG
	--SELECT @notPickedCount = count(*) FROM archFile WITH(NOLOCK) where jobid = @jobId AND isValid = 1 and fileType = 1 AND flags = 0
	--SELECT @dataFilesCount = count(*) FROM archFile WITH(NOLOCK) where jobid = @jobId AND isValid = 1 and fileType = 1
	SELECT @successCICount = CASE WHEN T.flags = 64 THEN T.FlagCount END,
	@partialCount = CASE WHEN T.flags = 32 THEN T.FlagCount END,
	@pickedCount = CASE WHEN T.flags = 16 THEN T.FlagCount END,
	@failedCount = CASE WHEN T.flags = 128 THEN T.FlagCount END,
	@expiredCount = CASE WHEN T.flags = 256 THEN T.FlagCount END,
	@notPickedCount = CASE WHEN T.flags = 0 THEN T.FlagCount END
	FROM
	(
	SELECT COUNT(flags) FlagCount, flags FROM archFile WITH(NOLOCK)
	WHERE jobid = @jobId AND isValid = 1 and fileType = 1
	GROUP BY FLAGS
	) T
	SELECT @dataFilesCount = COUNT(id) FROM archFile WITH(NOLOCK) WHERE jobid = @jobId AND isValid = 1 and fileType = 1
	--computing ci status of job now..
	IF @pickedCount > 0 AND @pickedCount = @dataFilesCount
	BEGIN
		SET @status = 16
		--PRINT 'Picked'
	END
	ELSE IF @successCICount > 0 AND @successCICount = @dataFilesCount
	BEGIN
		SET @status = 64
		--PRINT 'Success'
	END
	ELSE IF @notPickedCount > 0
	BEGIN
		SET @status = 0
		--PRINT 'Not Picked'
	END
	ELSE IF @failedCount > 0 AND @failedCount = @dataFilesCount
	BEGIN
		SET @status = 128
		--PRINT 'Failed'
	END
	ELSE IF @successCICount > 0 OR @partialCount > 0
	BEGIN
		SET @status = 32
		--PRINT 'Partial'
	END
	ELSE
	BEGIN
		SET @status = (371 | (CAST(POWER(2, 24) AS BIGINT) * 61))
		--PRINT 'Unknown'
	END
	-- start function body
	DECLARE @messageId int = CASE
	WHEN @status = 16 THEN (507 | (CAST(POWER(2, 24) AS BIGINT) * 61))
	WHEN @status = 32 THEN (1595 | (CAST(POWER(2, 24) AS BIGINT) * 61))
	WHEN @status = 64 THEN (881 | (CAST(POWER(2, 24) AS BIGINT) * 61))
	WHEN @status = 128 THEN (579 | (CAST(POWER(2, 24) AS BIGINT) * 61))
	WHEN @status = 256 THEN (1199 | (CAST(POWER(2, 24) AS BIGINT) * 61))
	WHEN @status = 0 THEN (508 | (CAST(POWER(2, 24) AS BIGINT) * 61))
	END
	-- Return localized message from here.
	RETURN
	(
	SELECT TOP 1 Message FROM EvLocaleMsgs
	WHERE SubsystemID = 61 AND LocaleId = @localeId AND MessageID = @messageId
	)
	-- end function body
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getCIStatusText]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getCIStatusText' AND revision = '1.2')

  insert into GXDBVersions values(5, 'getCIStatusText',  '1.2', 'getCIStatusText', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getHoldsToAppTypeMapping.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getHoldsToAppTypeMapping'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getHoldsToAppTypeMapping]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getHoldsToAppTypeMapping]
  delete from GXDBVersions where name = 'getHoldsToAppTypeMapping' and type = 5
END
GO

	CREATE FUNCTION getHoldsToAppTypeMapping (@HoldTypes varchar(max) = '')
	RETURNS
	@supportedRefAppTypes TABLE (
			refAppType			integer,
			appType				integer
		)
	AS
	BEGIN
	DECLARE @appTypeHoldType TABLE
	(
		appType			integer,
		holdType		integer
	)
	Insert Into @appTypeHoldType values(33/*File System*/, 4)
	Insert Into @appTypeHoldType values(29/*File System*/, 4)
	Insert Into @appTypeHoldType values(54/*Mail Box*/, 5)
	Insert Into @appTypeHoldType values(67/*Journal*/, 6)
	-- Populate the supported AppTypes
	Insert Into @supportedRefAppTypes values(33, 11)
	Insert Into @supportedRefAppTypes values(33, 34)
	Insert Into @supportedRefAppTypes values(33, 42)
	Insert Into @supportedRefAppTypes values(33, 43)
	Insert Into @supportedRefAppTypes values(33, 1)
	Insert Into @supportedRefAppTypes values(29, 17)
	Insert Into @supportedRefAppTypes values(29, 18)
	Insert Into @supportedRefAppTypes values(29, 19)
	Insert Into @supportedRefAppTypes values(29, 20)
	Insert Into @supportedRefAppTypes values(29, 21)
	Insert Into @supportedRefAppTypes values(29, 29)
	Insert Into @supportedRefAppTypes values(29, 36)
	Insert Into @supportedRefAppTypes values(29, 38)
	Insert Into @supportedRefAppTypes values(29, 63)
	Insert Into @supportedRefAppTypes values(29, 64)
	Insert Into @supportedRefAppTypes values(29, 74)
	Insert Into @supportedRefAppTypes values(54, 54)
	Insert Into @supportedRefAppTypes values(67, 67)
 	-- logic for returning appropriate app-types for requested hold types
	IF ISNULL(@HoldTypes, '') <> ''
	BEGIN
		--For review set, all app-type are applicable and so we delete nothing from main mapping table
		IF NOT EXISTS (SELECT TOP 1 * FROM dbo.SplitIDs(@holdTypes) R WHERE R._ID = 7)
		BEGIN
			--Delete app-types other than the one for the requested hold types so that we return only what is desired
			DELETE FROM @supportedRefAppTypes
			WHERE refAppType  NOT IN
			(
				SELECT apptype FROM @appTypeHoldType A
				INNER JOIN dbo.SplitIDs(@holdTypes) R ON A.holdType = R._ID
			)
		END
	END
	-- Done with logic, now return..
	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getHoldsToAppTypeMapping]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getHoldsToAppTypeMapping' AND revision = '1.2')

  insert into GXDBVersions values(5, 'getHoldsToAppTypeMapping',  '1.2', 'getHoldsToAppTypeMapping', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobStateName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobStateName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobStateName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobStateName]
  delete from GXDBVersions where name = 'GetJobStateName' and type = 5
END
GO

	CREATE FUNCTION GetJobStateName (@stateId INTEGER)
	RETURNS VARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @jobStateName varchar(255)
		SELECT @jobStateName =
			CASE @stateId
			WHEN 1 THEN 'Running'
			WHEN 2 THEN 'Pending'
			WHEN 3 THEN 'Waiting'
			WHEN 4 THEN 'Completed'
			WHEN 5 THEN 'Suspended'
			WHEN 6 THEN 'Kill Pending'
			WHEN 7 THEN 'Suspend Pending'
			WHEN 8 THEN 'Interrupt Pending'
			WHEN 9 THEN 'Completed'
			WHEN 10 THEN 'Failed'
			WHEN 11 THEN 'Killed'
			WHEN 12 THEN 'Completed w/ one or more errors'
			WHEN 13 THEN 'System Kill Pending'
			WHEN 14 THEN 'Suspended'
			WHEN 15 THEN 'Queued'
			WHEN 16 THEN 'Queued'
			WHEN 17 THEN 'Running (Cannot be verified)'
			WHEN 18 THEN 'Abnormally Terminated Cleanup'
			ELSE 'Unknown' END
	RETURN @jobStateName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobStateName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobStateName' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetJobStateName',  '1.1', 'GetJobStateName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetLicensePropName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetLicensePropName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetLicensePropName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetLicensePropName]
  delete from GXDBVersions where name = 'GetLicensePropName' and type = 5
END
GO

	CREATE FUNCTION GetLicensePropName(@licenseType varchar(128))
	RETURNS varchar(128)
	AS
	BEGIN
		DECLARE @retVal varchar(128)
		SET @retVal =
		CASE @licenseType
			WHEN 1004						THEN "NDMP Remote Server"
			WHEN 1008							THEN "QR Enabler"
			WHEN 1012						THEN "SNMP Enabler"
			WHEN 1010							THEN "Centerra"
			WHEN 1006					THEN "EZ Browse"
			WHEN 1007					THEN "HotSpot"
			WHEN 1013				THEN "QR Enabler Snap View"
			WHEN 13								THEN "NAS FS iDA"
			WHEN 88								THEN "NAS FS iDA"				-- Not a mistake! see 8.0 clientProperties.cpp
			WHEN 1016					THEN "Content Indexing Enabled"
			WHEN 1017					THEN "Echo View Enabler"
			WHEN 1021						THEN "Data Encryption"
			WHEN 1022 					THEN "Data Verification"
			WHEN 1023 					THEN "Data Multiplexing"
			WHEN 1024 					THEN "Commcell Migration"
			WHEN 1025 						THEN "GX Compliance"
			WHEN 1026 							THEN "Grid Store"
			WHEN 1019 						THEN "Vault Tracker AppType"
			WHEN 1029 							THEN "Open System SnapVault"
			WHEN 1031 					THEN "ONTAP SnapVault"
			WHEN 1032 				THEN "System Recovery Client"
			WHEN 1033 				THEN "System Recovery Boot Server"
			WHEN 1020 					THEN "Magnetic Library AppType"
			WHEN 1076 							THEN "Single Instance Store"
			WHEN 1077 				THEN "Magnetic AuxCopy Encryption"
			WHEN 1009 				THEN "NDMP Restore Enabler"
			WHEN 1035 								THEN "Installed "+"Content Addressed Storage"
			WHEN 1036 								THEN "Installed "+"DVD Support"
			WHEN 1037 								THEN "Installed "+"UDO Support"
			WHEN 1038 						THEN "Installed "+"CommCell Readiness Check"
			WHEN 1039 							THEN "Installed "+"Advanced FileSystem iDA Options"
			WHEN 1040 				THEN "Installed "+"1-Touch Server for Windows"
			WHEN 1041 							THEN "Installed "+"Erase Data"
			WHEN 1042 						THEN "Installed "+"Client Groups"
			WHEN 1043 						THEN "Installed "+"FileSystem Accelerator"
			WHEN 1044 				THEN "Installed "+"Dynamic Mount Path Sharing"
			WHEN 1052 							THEN "Installed "+"Advanced Copy Features"
			WHEN 1053 								THEN "Installed "+"Advanced Media Management Features"
			WHEN 1055 					THEN "Installed "+"NDMP Tape Server"
			WHEN 1056 			THEN "Installed "+"Vault Tracker"
			WHEN 1057 							THEN "Installed "+"Librarries"
			WHEN 1058 								THEN "Installed "+"Drives"
			WHEN 1059 			THEN "Installed "+"Recovery Points"
			WHEN 1061 				THEN "Installed "+"Open File Handler"
			WHEN 1062 						THEN "Installed "+"CommServe Database"
			WHEN 1066 						THEN "Filer Snapshot"
			WHEN 92 						THEN "SRM"
			WHEN 1067 			THEN "File Replication Driver"
			WHEN 1068 						THEN "FSDM Driver"
			WHEN 1069 					THEN "OSSV VSS Provider"
			WHEN 1070 				THEN "Desktop Search Server"
			WHEN 1064 					THEN "Content Index Server"
			WHEN 1071 					THEN "CDR VSS Provider"
			WHEN 1072 				THEN "Shared Dynamic Disk"
			WHEN 1073 					THEN "Active Directory Signon"
			WHEN 1074 			THEN "Desktop Search Server Database"
			WHEN 1075 					THEN "Compliance Search"
			WHEN 1078 					THEN "OWA Proxy Enabler"
			WHEN 1079 							THEN "Legal Hold"
			WHEN 120 				THEN "SharePoint Search Connector"
			WHEN 1082 						THEN "SRM Services"
			WHEN 1080 					THEN "SRM Services DB"
			WHEN 1081 			THEN "Proxy File Share Archiver"
			WHEN 1083 						THEN "Media Explorer"
			WHEN 1084 							THEN "Unix Base Zero Package"
			WHEN 1085 							THEN "Unix File Replication Driver"
			WHEN 1086 						THEN "Offline Mining Exhange Admin Tool"
			WHEN 1087 						THEN "Offline Mining Exhange User Tool"
			WHEN 1088 						THEN "Hardware Snap Enabler"
			WHEN 1089				THEN "Offline Mining Sharepoint Tool"
			WHEN 1091 								THEN "Office Communication Server"
			WHEN 1092 						THEN "Snap Backups Enabled"  -- Defect 54577
			WHEN 17 							THEN "SRM Agent For UNIX File Systems"
			WHEN 18 							THEN "SRM Agent For UNIX File Systems"
			WHEN 19 						THEN "SRM Agent For UNIX File Systems"
			WHEN 20 						THEN "SRM Agent For UNIX File Systems"
			WHEN 21 								THEN "SRM Agent For UNIX File Systems"
			WHEN 29 							THEN "SRM Agent For UNIX File Systems"
			WHEN 106 						THEN "SRM for Virtual Server"
			WHEN 58 					THEN "SRM for Virtual Server"
			WHEN 53 				THEN "SRM Agent For Exchange"
			WHEN 54 					THEN "SRM Agent For Exchange"
			WHEN 1096 				THEN "Compliance Director"
			WHEN 1097 							THEN "Tagging"
			WHEN 1098 								THEN "Microsoft Office Sharepoint Server"
			WHEN 1101 					THEN "Tape De-Duplication"
			WHEN 1100 			THEN "Block Level De-Duplication"
			WHEN 121 						THEN "Metrics Reporting Server"
			WHEN 122 						THEN "Monitored Ops Clients"
			WHEN 1104 					THEN "CommNet Browser"
			WHEN 1107 					THEN "CommNet Explorer"
			WHEN 1102 				THEN "CommNet SNMP Enabler"
			WHEN 1103 				THEN "Developer License"
			WHEN 1117 					THEN "SRM for Virtual Server"
			WHEN 654 						THEN "SRM for Lotus Notes"
			WHEN 128 							THEN "Documentum"
			WHEN 1108 				THEN "File Level Enabler for SRM"
			WHEN 127 			THEN "External Data Connector"
			WHEN 1106 					THEN "CommNet Server DB"
			WHEN 1110 						THEN "Sharepoint Online CI Enabler"
			WHEN 1111 					THEN "Library Sharing Across CommCells"
			WHEN 1112 						THEN "Client Side DeDuplication"
			WHEN 1113 						THEN "Cloud Storage"
			WHEN 1114 		THEN "SAP ArchiveLink"
			WHEN 1115 					THEN "Agentless Data collection for SRM"
			WHEN 1116	THEN "Subscription Based Cloud Storage"
			WHEN 605							THEN "SRM Agent For UNIX File Systems"
			WHEN 600							THEN "SRM Agent For Windows File Systems"
			WHEN 606							THEN "SRM Agent For Exchange"
			WHEN 603							THEN "SRM Agent For Network Attached Storage"
			WHEN 124						THEN "Object Link"
			WHEN 1099								THEN	"AD offline Enabler"
			WHEN 66				THEN	"Unix File Archiver"
			WHEN 1124						THEN	"Remote Operation Management Service"
			WHEN 1130						THEN	"Protected Mailboxes"
			ELSE 								 		  "Installed "
		END
		return @retVal
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetLicensePropName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetLicensePropName' AND revision = '1.17')

  insert into GXDBVersions values(5, 'GetLicensePropName',  '1.17', 'GetLicensePropName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/isLicenseInstalled.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isLicenseInstalled'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isLicenseInstalled]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isLicenseInstalled]
  delete from GXDBVersions where name = 'isLicenseInstalled' and type = 5
END
GO

	CREATE FUNCTION isLicenseInstalled(@clientId int, @licType int)
	RETURNS INT
	AS
	BEGIN

	DECLARE @retType as integer = CONVERT(int,
			ISNULL(
					(SELECT attrVal FROM app_clientprop
						 WHERE componentNameId = @clientId AND attrName = dbo.GetLicensePropName(@licType) AND modified = 0),
						 '0')
			)
		return @retType
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isLicenseInstalled]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isLicenseInstalled' AND revision = '1.1')

  insert into GXDBVersions values(5, 'isLicenseInstalled',  '1.1', 'isLicenseInstalled', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/ROMSLookupTokens.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ROMSLookupTokens'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ROMSLookupTokens]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ROMSLookupTokens]
  delete from GXDBVersions where name = 'ROMSLookupTokens' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION ROMSLookupTokens( @xml xml )
	RETURNS xml
	AS
	BEGIN
		SET QUOTED_IDENTIFIER ON
		-- Declare the return variable here
		DECLARE @result xml
		DECLARE @lookupIDs VARCHAR(MAX) SET @lookupIDs = '1241513998'; --Add tokenIds here
		-- Add the T-SQL statements to compute the return value here
		SET @result = (
		SELECT 1 AS [TAG],
	      NULL AS [Parent],
	      Token.i.value(N'@tokenId', 'bigint') [token!1!TokenID],
	      CASE WHEN e.Message IS NOT NULL THEN e.Message
	      ELSE Token.i.value(N'./tokenValueList[1]/@val', 'nvarchar(MAX)') END [token!1]
	      FROM
	       @xml.nodes(N'(/CVGui_DetectedAlertsData/details/tokVal[fn:not(fn:empty(./tokenValueList))])') Token(i)
	      LEFT JOIN EvLocaleMsgs e ON e.LocaleID = 0
	      AND Token.i.exist('@tokenId[fn:contains(sql:variable("@lookupIDs"), .)]') = 1
	      AND e.MessageID = Token.i.query('xs:integer(./tokenValueList[1]/@val)').value('.', 'bigint')
	      FOR XML EXPLICIT, ROOT('tokens') )
		-- Return the result of the function
		SET QUOTED_IDENTIFIER OFF
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ROMSLookupTokens]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ROMSLookupTokens' AND revision = '1.3')

  insert into GXDBVersions values(5, 'ROMSLookupTokens',  '1.3', 'ROMSLookupTokens', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetAppTypesList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAppTypesList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAppTypesList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAppTypesList]
  delete from GXDBVersions where name = 'GetAppTypesList' and type = 5
END
GO

		CREATE FUNCTION GetAppTypesList ( @commCellName VARCHAR(MAX) )
		RETURNS @AppTypesList TABLE ( clientName VARCHAR(MAX), appType INTEGER )
		AS
		BEGIN
		INSERT INTO @AppTypesList
		(
			clientName, appType
		)
		SELECT map.exMachineName, ida_type.type
		FROM
		APP_Client c, LicUsage lic, CommServ_Capture..CCM_edcClientNameMap map, APP_iDAType ida_type
		WHERE
			c.name = map.gxMachineName AND
			map.exServerAliasName = @commCellName AND
			lic.CId = c.id AND
			ida_type.type = lic.AppType

		INSERT INTO @AppTypesList
		(
			clientName, appType
		)
		SELECT map.exMachineName, ida_type.type
		FROM
		APP_Client c, LicUsage lic, edcClientNameMap map, APP_iDAType ida_type
		WHERE
			c.name = map.gxMachineName AND
			map.exServerAliasName = @commCellName AND
			lic.CId = c.id AND
			ida_type.type = lic.AppType
		INSERT INTO @AppTypesList
		(
			clientName, appType
		)
		SELECT clientName, ida.ccpType
		FROM @AppTypesList list, App_iDAType ida
		WHERE
		list.appType = ida.type
		AND list.appType <> ida.ccpType
		AND ida.ccpType <> 0
		RETURN;
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAppTypesList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAppTypesList' AND revision = '')

  insert into GXDBVersions values(5, 'GetAppTypesList',  '', 'GetAppTypesList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsAppTypeInstalled.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsAppTypeInstalled'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsAppTypeInstalled]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsAppTypeInstalled]
  delete from GXDBVersions where name = 'IsAppTypeInstalled' and type = 5
END
GO

	CREATE FUNCTION IsAppTypeInstalled
	(
	 @commcellName	VARCHAR(255),
	 @clientName	VARCHAR(255),
	 @clientHost	VARCHAR(255),
	 @appType		INTEGER
	)
	RETURNS INTEGER
	AS
	BEGIN
	DECLARE @clientID INT = ( SELECT id FROM APP_Client client WHERE name =
	COALESCE
	(
		( SELECT gxMachineName FROM CommServ_Capture..CCM_edcClientNameMap WHERE exServerAliasName=@commcellName AND exMachineName = @clientName AND exMachineHostName = @clientHost),
		( SELECT gxMachineName FROM edcClientNameMap WHERE exServerAliasName=@commcellName AND exMachineName = @clientName AND  exMachineHostName = @clientHost)
	) )
	IF EXISTS( SELECT * FROM LicUsage WHERE
		CId = @clientID	AND
		( appType = @appType OR appType IN ( SELECT type FROM APP_iDAType WHERE ccpType = @appType ) ) )
			RETURN 1
	RETURN 0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsAppTypeInstalled]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsAppTypeInstalled' AND revision = '')

  insert into GXDBVersions values(5, 'IsAppTypeInstalled',  '', 'IsAppTypeInstalled', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSnapClientsForClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSnapClientsForClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSnapClientsForClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSnapClientsForClient]
  delete from GXDBVersions where name = 'GetSnapClientsForClient' and type = 5
END
GO

	CREATE FUNCTION dbo.GetSnapClientsForClient
	(
		@i_clientId integer
	)
	RETURNS
	@clientIds table
	(
		id integer
	)
	AS
	BEGIN
	-- Need to EXEC CCM_Create_Synonyms '<database name>' before invoking this function, will fail otherwise
	-- Because of CCM Capture From Other DB framework
		INSERT INTO @clientIds values(@i_clientId)
		REFETCH:
		INSERT INTO @clientIds
		SELECT DISTINCT originclientid FROM CCM_SOURCE_SMVolume WHERE SourceClientId in(SELECT ID FROM @clientIds)
		AND originclientid NOT IN (SELECT ID FROM @clientIds) and OriginClientId <> 0
		IF @@ROWCOUNT > 0
		BEGIN
			GOTO REFETCH
		END
		INSERT INTO @clientIds
		SELECT DISTINCT sourceclientid FROM CCM_SOURCE_SMVolume WHERE originClientId in(SELECT ID FROM @clientIds)
		AND sourceclientid NOT IN (SELECT ID FROM @clientIds) AND SourceClientId <> 0
		IF @@ROWCOUNT > 0
		BEGIN
			GOTO REFETCH
		END
		RETURN
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSnapClientsForClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSnapClientsForClient' AND revision = '')

  insert into GXDBVersions values(5, 'GetSnapClientsForClient',  '', 'GetSnapClientsForClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetLoggingLevel.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetLoggingLevel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetLoggingLevel]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetLoggingLevel]
  delete from GXDBVersions where name = 'GetLoggingLevel' and type = 5
END
GO

	CREATE FUNCTION GetLoggingLevel
	(
	)
	RETURNS INTEGER
	AS
	BEGIN
	DECLARE @loggingLevel INT = ( SELECT TOP 1 loggingLevel FROM DBLog WHERE connectionId = @@SPID )
	RETURN @loggingLevel
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetLoggingLevel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetLoggingLevel' AND revision = '')

  insert into GXDBVersions values(5, 'GetLoggingLevel',  '', 'GetLoggingLevel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetPropValue.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetPropValue'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetPropValue]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetPropValue]
  delete from GXDBVersions where name = 'GetPropValue' and type = 5
END
GO

	CREATE FUNCTION GetPropValue (@INattName nvarchar(1024), @clientId int)
	RETURNS varchar(1024)
	AS
	BEGIN
		declare @attrValue varchar(1024)
		SET @attrValue = (select attrVal
						  from APP_ClientProp
						  where attrName = @INattName AND
		   				  componentNameId = @clientId AND modified = 0)
		return (@attrValue)
	END;



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetPropValue]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetPropValue' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetPropValue',  '1.3', 'GetPropValue', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/NormalizeForXML.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: NormalizeForXML'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NormalizeForXML]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NormalizeForXML]
  delete from GXDBVersions where name = 'NormalizeForXML' and type = 5
END
GO

	CREATE FUNCTION NormalizeForXML(@string NVARCHAR(4000))
	RETURNS NVARCHAR(4000)
	AS BEGIN

	    DECLARE @rv  NVARCHAR(4000) = N''
	    DECLARE @len INT = LEN(@string)
	    DECLARE @i   INT = 1

	    WHILE @i <= @len BEGIN
	        DECLARE @char NCHAR(1) = SUBSTRING(@string, @i, 1)
	        -- all chacters with UNICODE code less then 32 are invalid except <CR>, <LF> and <TAB>
	        IF(UNICODE(@char) < 0x20) AND UNICODE(@char) <> 0x9 AND UNICODE(@char) <> 0xA AND UNICODE(@char) <> 0xD
	            SET @rv += '&#' + CAST(UNICODE(@char) AS NVARCHAR(24))
	        ELSE
	            SET @rv += @char
	        SET @i += 1
	    END

		-- Return the result of the function
		RETURN @rv
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NormalizeForXML]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NormalizeForXML' AND revision = '1.2')

  insert into GXDBVersions values(5, 'NormalizeForXML',  '1.2', 'NormalizeForXML', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/CCM_SplitStringByToken.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: CCM_SplitStringByToken'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CCM_SplitStringByToken]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[CCM_SplitStringByToken]
  delete from GXDBVersions where name = 'CCM_SplitStringByToken' and type = 5
END
GO

	CREATE FUNCTION dbo.CCM_SplitStringByToken
	(
		@IDsList varchar(1024),
		@token	char(1)
	)
	RETURNS
	@ParsedList table
	(
		_ID varchar(1024)
	)
	AS
	BEGIN
		DECLARE @_ID varchar(1024), @Pos int
		SET @IDsList = LTRIM(RTRIM(@IDsList))+ @token
		SET @Pos = CHARINDEX(@token, @IDsList, 1)
		IF REPLACE(@IDsList,@token, '') <> ''
		BEGIN
			WHILE @Pos > 0
			BEGIN
				SET @_ID = LTRIM(RTRIM(LEFT(@IDsList, @Pos - 1)))
				IF @_ID <> ''
				BEGIN
					INSERT INTO @ParsedList (_ID)
					VALUES (@_ID) --Use Appropriate conversion
				END
				SET @IDsList = RIGHT(@IDsList, LEN(@IDsList) - @Pos)
				SET @Pos = CHARINDEX(@token, @IDsList, 1)
			END
		END
		RETURN
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [CCM_SplitStringByToken]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'CCM_SplitStringByToken' AND revision = '1.2')

  insert into GXDBVersions values(5, 'CCM_SplitStringByToken',  '1.2', 'CCM_SplitStringByToken', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/SplitStringByDelimiter.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SplitStringByDelimiter'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SplitStringByDelimiter]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SplitStringByDelimiter]
  delete from GXDBVersions where name = 'SplitStringByDelimiter' and type = 5
END
GO

    CREATE FUNCTION dbo.SplitStringByDelimiter
    (
        @IDsList nvarchar(MAX),
        @token  char(1)
    )
    RETURNS
    @ParsedList table
    (
        _ID nvarchar(MAX)
    )
    AS
    BEGIN
        DECLARE @_ID nvarchar(MAX), @Pos int
        SET @IDsList = LTRIM(RTRIM(@IDsList))+ @token
        SET @Pos = CHARINDEX(@token, @IDsList, 1)
        IF REPLACE(@IDsList,@token, '') <> ''
        BEGIN
            WHILE @Pos > 0
            BEGIN
                SET @_ID = LTRIM(RTRIM(LEFT(@IDsList, @Pos - 1)))
                IF @_ID <> ''
                BEGIN
                    INSERT INTO @ParsedList (_ID)
                    VALUES (@_ID) --Use Appropriate conversion
                END
                SET @IDsList = RIGHT(@IDsList, LEN(@IDsList) - @Pos)
                SET @Pos = CHARINDEX(@token, @IDsList, 1)
            END
        END
        RETURN
    END
    GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SplitStringByDelimiter]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SplitStringByDelimiter' AND revision = '1.2')

  insert into GXDBVersions values(5, 'SplitStringByDelimiter',  '1.2', 'SplitStringByDelimiter', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsArchiverAgent.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsArchiverAgent'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsArchiverAgent]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsArchiverAgent]
  delete from GXDBVersions where name = 'IsArchiverAgent' and type = 5
END
GO

	CREATE FUNCTION IsArchiverAgent (@licType int)
	RETURNS integer
	AS
	BEGIN
		DECLARE @retVal integer;
		SET @retVal = 0
		IF (@licType in (1, 2))
			SET @retVal = 1
		return @retVal
	END;



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsArchiverAgent]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsArchiverAgent' AND revision = '1.2')

  insert into GXDBVersions values(5, 'IsArchiverAgent',  '1.2', 'IsArchiverAgent', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/CCMGetDependentClientsForDocumentumClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: CCMGetDependentClientsForDocumentumClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CCMGetDependentClientsForDocumentumClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[CCMGetDependentClientsForDocumentumClient]
  delete from GXDBVersions where name = 'CCMGetDependentClientsForDocumentumClient' and type = 5
END
GO

	CREATE FUNCTION dbo.CCMGetDependentClientsForDocumentumClient
	(
		@i_clientId integer
	)
	RETURNS
	@clientIds table
	(
		id integer
	)
	AS
	BEGIN
	-- Need to EXEC CCM_Create_Synonyms '<database name>' before invoking this function, will fail otherwise
	-- Because of CCM Capture From Other DB framework
	DECLARE @StringsToProcess TABLE(StringToProcess nvarchar(max))
	INSERT @StringsToProcess
	SELECT DISTINCT fileName from CCM_SOURCE_APP_ScFilterFile WHERE componentNameId in (SELECT id from CCM_SOURCE_APP_Application WHERE clientId = @i_clientId) and type in (16,17)
	INSERT @StringsToProcess
	SELECT DISTINCT fileName from CCM_SOURCE_APP_InstFilterFile WHERE componentNameId in (SELECT instance from CCM_SOURCE_APP_Application WHERE clientId = @i_clientId) and type in (16,17)
	INSERT @clientIds
	SELECT DISTINCT CAST(SUBSTRING(StringToProcess,1,CHARINDEX(' ',StringToProcess)) AS integer)
	FROM @StringsToProcess
	INSERT @clientIds
	SELECT DISTINCT CAST(attrval AS integer) FROM CCM_SOURCE_APP_InstanceProp WHERE componentNameId in (SELECT instance from CCM_SOURCE_APP_Application WHERE clientId = @i_clientId) and attrName = 'DOCUMENTUM DbClientId'
	AND CAST(attrval AS integer) NOT IN (SELECT id FROM @clientIds)
	DELETE @clientIds WHERE id = 0
	DELETE @clientIds WHERE id = @i_clientId
	RETURN
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [CCMGetDependentClientsForDocumentumClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'CCMGetDependentClientsForDocumentumClient' AND revision = '')

  insert into GXDBVersions values(5, 'CCMGetDependentClientsForDocumentumClient',  '', 'CCMGetDependentClientsForDocumentumClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GenerateClientName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GenerateClientName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GenerateClientName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GenerateClientName]
  delete from GXDBVersions where name = 'GenerateClientName' and type = 5
END
GO

	create function GenerateClientName(
	@name as nvarchar(255),
	@hostname as nvarchar(1024),
		@vmguid as nvarchar(1024),
		@instanceguid as nvarchar(1024),
		@instancetype as int = 0 )
	returns
	int
	AS
	BEGIN
		declare @ret as nvarchar(255)
		declare @queryStr nvarchar(255)
		declare @currentName nvarchar(255)
		declare @lastName nvarchar(255)
		declare @lastNumber int
		declare @patIndex int
		set @lastNumber = -1
			if(@instancetype != 8)
			BEGIN
		declare appclients cursor for
			select name from APP_Client where name like @name + '%' and CAST(GUID AS NVARCHAR(1024))= @vmguid order by name
		open appclients
		fetch next from appclients into @currentName
		WHILE @@FETCH_STATUS = 0
		begin
			if @currentName = @name
			begin
				set @lastNumber = 0;
			end
			else
			begin
				set @patIndex = -1
				set @patIndex = patindex(@name + '[_]%', @currentName)
				if @patIndex != 0
				begin
					declare @startIndex int
					set @startIndex = len(@name + '_')
					set @lastName = substring(@currentName, @startIndex + 1, len(@currentName) - @startIndex)
					if isnumeric(@lastName) = 1 and LEN(@lastName) <= 9
					begin
						set @lastNumber = convert(integer, @lastName)
					end
				end
			end
		fetch next from appclients into @currentName
		end
		close  appclients
		deallocate  appclients
		IF @instanceguid IS NOT NULL
		declare appclients cursor for
			select C.name from APP_Client C
							INNER JOIN APP_ClientProp CP
							ON C.id = CP.componentNameId
							AND CP.attrName = 'Virtual Machine Instance UUID'
							where C.name like @name + '%' AND CP.attrVal = @instanceguid order by C.name
		ELSE
		declare appclients cursor for
			select C.name from APP_Client C
							INNER JOIN APP_ClientProp CP
							ON C.id = CP.componentNameId
							AND CP.attrName = 'Virtual Machine GUID'
							where C.name like @name + '%' AND CP.attrVal = @vmguid order by C.name
		open appclients
		fetch next from appclients into @currentName
		WHILE @@FETCH_STATUS = 0
		begin
			if @currentName = @name
			begin
				set @lastNumber = 0;
			end
			else
			begin
				set @patIndex = -1
				set @patIndex = patindex(@name + '[_]%', @currentName)
				if @patIndex != 0
				begin
					set @startIndex = len(@name + '_')
					set @lastName = substring(@currentName, @startIndex + 1, len(@currentName) - @startIndex)
					if isnumeric(@lastName) = 1 and LEN(@lastName) <= 9
					begin
						set @lastNumber = convert(integer, @lastName)
					end
				end
			end
		fetch next from appclients into @currentName
		end
		close  appclients
		deallocate  appclients
			END
		if @lastNumber <> -1
			return @lastNumber;
		IF NOT EXISTS	(select * from APP_Client WITH (NOLOCK) where name = @name )
		BEGIN
			SET @lastNumber=0
			return @lastNumber
		END
		DECLARE @nintMaxNum int
		SET @nintMaxNum=2147483647
		SET @lastNumber=1
		WHILE @lastNumber <= @nintMaxNum
		begin

		IF NOT EXISTS	(select * from APP_Client WITH (NOLOCK) where name = @name + '_' + convert(varchar,@lastNumber))
			return @lastNumber

		SET @lastNumber=@lastNumber+1
		end
		return @lastNumber
	End



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GenerateClientName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GenerateClientName' AND revision = '1.15')

  insert into GXDBVersions values(5, 'GenerateClientName',  '1.15', 'GenerateClientName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDayBoundaryCurrentCycleStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDayBoundaryCurrentCycleStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDayBoundaryCurrentCycleStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDayBoundaryCurrentCycleStart]
  delete from GXDBVersions where name = 'GetDayBoundaryCurrentCycleStart' and type = 5
END
GO

    CREATE FUNCTION GetDayBoundaryCurrentCycleStart (@commCellId int, @currentTime DATETIME, @treatWeekend int)
    RETURNS DATETIME
    WITH ENCRYPTION
    AS
    BEGIN
        DECLARE @timeNextCycle          datetime
        DECLARE @timePrevCycle          datetime
        DECLARE @timeSecondPrevCycle    datetime
        DECLARE @dayNum                 int
        DECLARE @dayNumNextCycle        int
        DECLARE @dayNumPrevCycle        int
        DECLARE @dayNumSecondPrevCycle  int
        DECLARE @todayCycleEnd          datetime
        DECLARE @nextCycleEnd           datetime
        DECLARE @prevCycleEnd           datetime
        DECLARE @secondPrevCycleEnd     datetime
        DECLARE @todayCycleStart        datetime
        DECLARE @nextCycleStart         datetime
        DECLARE @prevCycleStart         datetime
        DECLARE @secondPrevCycleStart   datetime
        DECLARE @daysCommCellId         int
        SET @daysCommCellId     = CASE WHEN EXISTS (SELECT CommCellId FROM APP_CommCellDays WHERE CommCellId = @commCellId) THEN @commCellId ELSE 1 END
        SET @dayNum             = DATEPART(dw, @currentTime)
        SET @timeNextCycle  = DATEADD(day,
                                      CASE WHEN @treatWeekend = 1 AND @dayNum = 6 THEN +3
                                           WHEN @treatWeekend = 1 AND @dayNum = 7 THEN +2
                                           ELSE                                        +1
                                      END,
                                      @currentTime)
        SET @dayNumNextCycle = DATEPART(dw, @timeNextCycle)
        SET @timePrevCycle = DATEADD(day,
                                     CASE WHEN @treatWeekend = 1 AND @dayNum = 1 THEN -3
                                          WHEN @treatWeekend = 1 AND @dayNum = 7 THEN -2
                                          ELSE                                        -1
                                     END,
                                     @currentTime)
        SET @dayNumPrevCycle = DATEPART(dw, @timePrevCycle)
        SET @timeSecondPrevCycle = DATEADD(day,
                                           CASE WHEN @treatWeekend = 1 AND @dayNum = 2 THEN -4
                                                WHEN @treatWeekend = 1 AND @dayNum = 1 THEN -4
                                                WHEN @treatWeekend = 1 AND @dayNum = 7 THEN -3
                                                ELSE                                        -2
                                           END,
                                           @currentTime)
        SET @dayNumSecondPrevCycle  = DATEPART(dw, @timeSecondPrevCycle)
        SET @todayCycleEnd = DATEADD(minute,
                                     (SELECT CASE @treatWeekend
                                                WHEN 1  THEN WkEndActivityOffSetEnd
                                                ELSE        WkDayActivityOffSetEnd
                                             END
                                      FROM   APP_CommCellDays
                                      WHERE     commCellId = @daysCommCellId
                                            AND DayNum = @dayNum),
                                      dbo.GetDayStart(@currentTime, 0))
        SET @nextCycleEnd = DATEADD(minute,
                                    (SELECT CASE @treatWeekend
                                                WHEN 1 THEN WkEndActivityOffSetEnd
                                                ELSE        WkDayActivityOffSetEnd
                                            END
                                     FROM   APP_CommCellDays
                                     WHERE      CommCellId = @daysCommCellId
                                            AND DayNum = @dayNumNextCycle),
                                     dbo.GetDayStart(@timeNextCycle, 0))
        SET @prevCycleEnd = DATEADD(minute,
                                   (SELECT  CASE @treatWeekend
                                                 WHEN 1  THEN WkEndActivityOffSetEnd
                                                 ELSE         WkDayActivityOffSetEnd
                                            END
                                    FROM    APP_CommCellDays
                                    WHERE       CommCellId = @daysCommCellId
                                            AND DayNum = @dayNumPrevCycle),
                                    dbo.GetDayStart(@timePrevCycle, 0))
        SET @secondPrevCycleEnd = DATEADD(minute,
                                          (SELECT CASE @treatWeekend
                                                        WHEN 1  THEN  WkEndActivityOffSetEnd
                                                        ELSE          WkDayActivityOffSetEnd
                                                  END
                                           FROM   APP_CommCellDays
                                           WHERE      CommCellId = @daysCommCellId
                                                  AND DayNum = @dayNumSecondPrevCycle),
                                           dbo.GetDayStart(@timeSecondPrevCycle, 0))
        SET @todayCycleStart = DATEADD(minute,
                                       (SELECT  CASE @treatWeekend
                                                    WHEN 1  THEN WkEndActivityOffSetStart
                                                    ELSE         WkDayActivityOffSetStart
                                                END
                                        FROM    APP_CommCellDays
                                        WHERE       CommCellId = @daysCommCellId
                                                AND dayNum = @dayNum),
                                       dbo.GetDayStart(@currentTime, 0))
        SET @nextCycleStart = DATEADD(minute,
                                      (SELECT  CASE @treatWeekend
                                                   WHEN 1 THEN WkEndActivityOffSetStart
                                                   ELSE        WkDayActivityOffSetStart
                                               END
                                       FROM    APP_CommCellDays
                                       WHERE       CommCellId = @daysCommCellId
                                               AND DayNum = @dayNumNextCycle),
                                      dbo.GetDayStart(@timeNextCycle, 0))
        SET @prevCycleStart = DATEADD(minute,
                                      (SELECT CASE @treatWeekend
                                                  WHEN 1 THEN WkEndActivityOffSetStart
                                                  ELSE        WkDayActivityOffSetStart
                                              END
                                       FROM   APP_CommCellDays
                                       WHERE      CommCellId = @daysCommCellId
                                              AND DayNum = @dayNumPrevCycle),
                                      dbo.GetDayStart(@timePrevCycle, 0))
        SET @secondPrevCycleStart = DATEADD(minute,
                                            (SELECT  CASE @treatWeekend
                                                        WHEN 1 THEN WkEndActivityOffSetStart
                                                        ELSE        WkDayActivityOffSetStart
                                             END
                                             FROM    APP_CommCellDays
                                             WHERE       CommCellId = @daysCommCellId
                                                     AND DayNum = @DayNumSecondPrevCycle),
                                            dbo.GetDayStart(@TimeSecondPrevCycle, 0))
        IF @currentTime >= @todayCycleEnd
        BEGIN
            RETURN @todayCycleEnd
        END
        ELSE
        IF @currentTime >= @prevCycleEnd and @currentTime < @todayCycleEnd
        BEGIN
            RETURN @prevCycleEnd
        END
            RETURN @secondPrevCycleEnd
    END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDayBoundaryCurrentCycleStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDayBoundaryCurrentCycleStart' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetDayBoundaryCurrentCycleStart',  '1.4', 'GetDayBoundaryCurrentCycleStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsSubClientValid.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsSubClientValid'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsSubClientValid]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsSubClientValid]
  delete from GXDBVersions where name = 'IsSubClientValid' and type = 5
END
GO

	CREATE FUNCTION IsSubClientValid (@AppTypeID int, @SubClientStatus int, @ForJobsOnly int = 0)
	RETURNS INT
	WITH ENCRYPTION
	BEGIN
		RETURN CASE WHEN (@AppTypeID in (58) AND (@SubClientStatus & 0x400 = 0x400)) THEN 1
			        WHEN ((@AppTypeID in (24, 25, 40, 47, 48, 50, 65, 66, 67, 68, 73, 75, 76) AND
			             (@SubClientStatus & 0x8) = 0x8) OR
			             (@AppTypeID in (72, 85, 127)) OR
			             (@AppTypeID in (84, 107) AND @ForJobsOnly = 0) OR
			             (@AppTypeID in (121, 122)) OR
			             (@AppTypeID BETWEEN 600 AND 700) OR
			             (@AppTypeID >= 1000) ) THEN 0
		        	WHEN (@SubClientStatus & 0x10 = 0x10) OR        -- CV_STATUS_DUMMY
		             	 (@SubClientStatus & 0x20 = 0x20) OR        -- CV_STATUS_HIDDEN
		                 (@SubClientStatus & 0x100000 = 0x100000)   -- CV_STATUS_DUMMY_FOR_FIREWALL_SETUP
		                                                                                 THEN 0
				    ELSE 1
			    END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsSubClientValid]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsSubClientValid' AND revision = '1.6')

  insert into GXDBVersions values(5, 'IsSubClientValid',  '1.6', 'IsSubClientValid', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/SplitString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SplitString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SplitString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SplitString]
  delete from GXDBVersions where name = 'SplitString' and type = 5
END
GO

	CREATE FUNCTION [dbo].[SplitString]
	(
		@RowData nvarchar(max),
		@SplitOn nvarchar(5)
	)
	RETURNS @RtnValue table
	(
		Id int identity(1,1),
		Data nvarchar(max)
	)
	AS
	BEGIN
	Declare @Cnt int
	Set @Cnt = 1
	Declare @dummy INT = 0
	DECLARE @quoteIndex INT = 0
	DECLARE @splitIndex INT = 0
	While @dummy = 0
	Begin
		SET @quoteIndex = CHARINDEX('"',@RowData)
		SET @splitIndex = CHARINDEX(@SplitOn,@RowData)
		IF @splitIndex = 0
			BREAK
		IF ( @quoteIndex <> 0 AND @quoteIndex < @splitIndex )
		BEGIN
			IF (CHARINDEX('"', @RowData, @quoteIndex + 1) > 0)
			BEGIN
				Insert Into @RtnValue (data)
				Select
				Data = ltrim(rtrim(Substring(@RowData,@quoteIndex + 1,(CHARINDEX('"', @RowData, @quoteIndex + 1)-2))))
				Set @RowData = Substring(@RowData,Charindex('"',@RowData, @quoteIndex + 1)+2,len(@RowData))
			END
		END
		ELSE
		BEGIN
			Insert Into @RtnValue (data)
			Select
				Data = ltrim(rtrim(Substring(@RowData,1,Charindex(@SplitOn,@RowData)-1)))
			Set @RowData = Substring(@RowData,Charindex(@SplitOn,@RowData)+1,len(@RowData))
		END
		Set @Cnt = @Cnt + 1
	End
	IF LEN(LTRIM(RTRIM(@ROWDATA))) <> 0
		Insert Into @RtnValue (data)
			Select Data = ltrim(rtrim(@RowData))
	Return
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SplitString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SplitString' AND revision = '1.2')

  insert into GXDBVersions values(5, 'SplitString',  '1.2', 'SplitString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobBackupTypeDisplay.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobBackupTypeDisplay'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobBackupTypeDisplay]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobBackupTypeDisplay]
  delete from GXDBVersions where name = 'GetJobBackupTypeDisplay' and type = 5
END
GO

	CREATE FUNCTION [dbo].[GetJobBackupTypeDisplay]
	(
		@backupType int
	)
	RETURNS varchar(1024)
	AS
	BEGIN
				DECLARE @outputstring varchar(1024)
				SET @outputstring = 'Unknown'
				IF (@backupType = 1)
					SET @outputstring = 'Full'
				ELSE IF (@backupType = 2)
					SET @outputstring = 'Incremental'
				ELSE IF (@backupType = 4)
					SET @outputstring = 'Differential'
				ELSE IF (@backupType = 0x40)
					SET @outputstring = 'Synthetic Full'
				ELSE IF (@backupType = 0x80)
					SET @outputstring = 'Synthetic Full'
				ELSE IF (@backupType = 0x100)
					SET @outputstring = 'Incremental'
				ELSE IF (@backupType = 0x800)
					SET @outputstring = 'Snapshot'
				ELSE IF (@backupType = 0x1000)
					SET @outputstring = 'New Volume Creation'
				ELSE IF (@backupType = 0x2000)
					SET @outputstring = 'Incremental Volume Update'
				ELSE IF (@backupType = 0x8000)
					SET @outputstring = 'Online Full'
				ELSE IF (@backupType = 1024)
					SET @outputstring = 'Offline Full'
				ELSE IF (@backupType = 0x20000)
					SET @outputstring = 'Analysis'
				ELSE IF (@backupType = 0x40000)
					SET @outputstring = 'Discovery'
				return @outputstring
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobBackupTypeDisplay]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobBackupTypeDisplay' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetJobBackupTypeDisplay',  '1.2', 'GetJobBackupTypeDisplay', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetAvg.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAvg'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAvg]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAvg]
  delete from GXDBVersions where name = 'GetAvg' and type = 5
END
GO

	CREATE FUNCTION GetAvg (@A float, @B float)
	RETURNS FLOAT
	WITH ENCRYPTION
	BEGIN
		RETURN (@A + @B) / 2.0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAvg]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAvg' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetAvg',  '1.2', 'GetAvg', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetMaxInt.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetMaxInt'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetMaxInt]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetMaxInt]
  delete from GXDBVersions where name = 'GetMaxInt' and type = 5
END
GO

	CREATE FUNCTION GetMaxInt (@Value1 int, @Value2 int)
	RETURNS INT
	WITH ENCRYPTION
	BEGIN
		RETURN CASE WHEN @Value1 > @Value2 THEN @Value1
				    ELSE @Value2
			   END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetMaxInt]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetMaxInt' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetMaxInt',  '1.2', 'GetMaxInt', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsBackupLevelFull.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsBackupLevelFull'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsBackupLevelFull]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsBackupLevelFull]
  delete from GXDBVersions where name = 'IsBackupLevelFull' and type = 5
END
GO

	CREATE FUNCTION IsBackupLevelFull(@BkpLevel int)
	RETURNS INT
	WITH ENCRYPTION
	BEGIN
		RETURN CASE
			WHEN @BkpLevel in (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000)
				THEN 1
				ELSE 0
			END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsBackupLevelFull]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsBackupLevelFull' AND revision = '1.2')

  insert into GXDBVersions values(5, 'IsBackupLevelFull',  '1.2', 'IsBackupLevelFull', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsBackupLevelSynthFull.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsBackupLevelSynthFull'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsBackupLevelSynthFull]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsBackupLevelSynthFull]
  delete from GXDBVersions where name = 'IsBackupLevelSynthFull' and type = 5
END
GO

	CREATE FUNCTION IsBackupLevelSynthFull (@BkpLevel int)
	RETURNS INT
	WITH ENCRYPTION
	BEGIN
		RETURN CASE
			WHEN @BkpLevel in (0x40, 0x80, 0x4000)
				THEN 1
				ELSE 0
			END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsBackupLevelSynthFull]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsBackupLevelSynthFull' AND revision = '1.2')

  insert into GXDBVersions values(5, 'IsBackupLevelSynthFull',  '1.2', 'IsBackupLevelSynthFull', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/SubstitutePositionalArg.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SubstitutePositionalArg'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SubstitutePositionalArg]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SubstitutePositionalArg]
  delete from GXDBVersions where name = 'SubstitutePositionalArg' and type = 5
END
GO

	CREATE FUNCTION SubstitutePositionalArg(@Message nvarchar(2000), @Arg sql_variant, @HexFlag integer,
					                        @ArgIndex integer, @FmtSpecLen integer)
	RETURNS nvarchar(4000)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @MsgPrefix nvarchar(2000)
		DECLARE @MsgSuffix nvarchar(2000)
		DECLARE @ArgVal nvarchar(256)
		SET @MsgPrefix = SUBSTRING(@Message, 1, @ArgIndex)
		SET @MsgSuffix = SUBSTRING(@Message, (@ArgIndex + @FmtSpecLen + 1), (LEN(@Message) - (@ArgIndex + @FmtSpecLen)))
		IF (@HexFlag = 1)
			SET @ArgVal = dbo.ConvertBigIntToHexStr(CAST(@Arg AS bigint))
		ELSE
			SET @ArgVal = CAST(@Arg AS nvarchar(256))
		RETURN @MsgPrefix + @ArgVal + @MsgSuffix
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SubstitutePositionalArg]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SubstitutePositionalArg' AND revision = '1.1')

  insert into GXDBVersions values(5, 'SubstitutePositionalArg',  '1.1', 'SubstitutePositionalArg', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/SubsArgs0.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SubsArgs0'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SubsArgs0]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SubsArgs0]
  delete from GXDBVersions where name = 'SubsArgs0' and type = 5
END
GO

	CREATE FUNCTION SubsArgs0(@localeId integer, @messageId bigint)
	RETURNS NVARCHAR(4000)
	WITH ENCRYPTION
	BEGIN
		DECLARE @rawMessage	NVARCHAR(1024)
		SELECT  @rawMessage = Message
		FROM    EvLocaleMsgs
		WHERE       LocaleID = @localeId
				AND MessageID = @messageId
		RETURN @rawMessage
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SubsArgs0]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SubsArgs0' AND revision = '1.1')

  insert into GXDBVersions values(5, 'SubsArgs0',  '1.1', 'SubsArgs0', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/SubsArgs1.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SubsArgs1'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SubsArgs1]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SubsArgs1]
  delete from GXDBVersions where name = 'SubsArgs1' and type = 5
END
GO

	CREATE FUNCTION SubsArgs1(@LocaleID integer, @MessageID bigint, @Arg sql_variant)
	RETURNS nvarchar(4000)
	WITH ENCRYPTION
	BEGIN
		DECLARE @RawMessage	nvarchar(1024)
		DECLARE @ArgIndex	integer
		DECLARE @ArgPos		integer
		DECLARE @DataType	integer
		DECLARE @HexFlag	integer
		DECLARE @FullFmtSpecLen	integer
		SELECT  @RawMessage = Message
		FROM    EvLocaleMsgs
		WHERE       LocaleID = @LocaleID
				AND MessageID = @MessageID
		-- DECLARE CURSOR
		DECLARE SubsArgCursor CURSOR FOR
		SELECT  Q1.ArgIndex, Q1.ArgPos, Q1.DataType, Q1.HexFlag, Q1.FullFmtSpecLen
		FROM    EvLocaleMsgArgInfo AS Q1
		WHERE       Q1.LocaleID = @LocaleID
				AND Q1.MessageID = @MessageID
		ORDER BY ArgIndex DESC
		-- Open Cursor
		Open SubsArgCursor
		-- Fetch
		FETCH NEXT FROM SubsArgCursor
		INTO @ArgIndex, @ArgPos, @DataType, @HexFlag, @FullFmtSpecLen
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @RawMessage = dbo.SubstitutePositionalArg(@RawMessage, @Arg, @HexFlag, @ArgIndex - 1, @FullFmtSpecLen)
			FETCH NEXT FROM SubsArgCursor
			INTO @ArgIndex, @ArgPos, @DataType, @HexFlag, @FullFmtSpecLen
		END
		-- Close & Deallocate Cursors
		CLOSE SubsArgCursor
		DEALLOCATE SubsArgCursor
		RETURN @RawMessage
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SubsArgs1]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SubsArgs1' AND revision = '1.1')

  insert into GXDBVersions values(5, 'SubsArgs1',  '1.1', 'SubsArgs1', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/SubsArgs2.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SubsArgs2'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SubsArgs2]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SubsArgs2]
  delete from GXDBVersions where name = 'SubsArgs2' and type = 5
END
GO

	CREATE FUNCTION SubsArgs2(@LocaleID integer, @MessageID bigint, @Arg1 sql_variant, @Arg2 sql_variant)
	RETURNS nvarchar(4000)
	WITH ENCRYPTION
	BEGIN
		DECLARE @RawMessage	nvarchar(1024)
		DECLARE @Arg		sql_variant
		DECLARE @ArgIndex	integer
		DECLARE @ArgPos		integer
		DECLARE @DataType	integer
		DECLARE @HexFlag	integer
		DECLARE @FullFmtSpec	nvarchar(32)
		DECLARE @FullFmtSpecLen	integer
		SELECT  @RawMessage = Message
		FROM    EvLocaleMsgs
		WHERE       LocaleID = @LocaleID
				AND MessageID = @MessageID
		-- DECLARE CURSOR
		DECLARE SubsArgCursor CURSOR
		FOR
		SELECT  Q1.ArgIndex, Q1.ArgPos, Q1.DataType, Q1.HexFlag, Q1.FullFmtSpec, Q1.FullFmtSpecLen
		FROM    EvLocaleMsgArgInfo AS Q1
		WHERE       Q1.LocaleID = @LocaleID
				AND Q1.MessageID = @MessageID
		ORDER BY ArgIndex DESC
		-- Open Cursor
		Open SubsArgCursor
		-- Fetch
		FETCH NEXT FROM SubsArgCursor
		INTO @ArgIndex, @ArgPos, @DataType, @HexFlag, @FullFmtSpec, @FullFmtSpecLen
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT @Arg = (CASE @ArgPos
							WHEN 1 THEN @Arg1
							WHEN 2 THEN @Arg2
							ELSE @FullFmtSpec
						END)
			SET @RawMessage = dbo.SubstitutePositionalArg(@RawMessage, @Arg, @HexFlag, @ArgIndex - 1, @FullFmtSpecLen)
			FETCH NEXT FROM SubsArgCursor
			INTO @ArgIndex, @ArgPos, @DataType, @HexFlag, @FullFmtSpec, @FullFmtSpecLen
		END
		-- Close & Deallocate Cursors
		CLOSE SubsArgCursor
		DEALLOCATE SubsArgCursor
		RETURN @RawMessage
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SubsArgs2]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SubsArgs2' AND revision = '1.1')

  insert into GXDBVersions values(5, 'SubsArgs2',  '1.1', 'SubsArgs2', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/SubsArgs3.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SubsArgs3'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SubsArgs3]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SubsArgs3]
  delete from GXDBVersions where name = 'SubsArgs3' and type = 5
END
GO

	CREATE FUNCTION SubsArgs3(@LocaleID integer, @MessageID bigint, @Arg1 sql_variant, @Arg2 sql_variant,
			                  @Arg3 sql_variant)
	RETURNS nvarchar(4000)
	WITH ENCRYPTION
	BEGIN
		DECLARE @RawMessage	nvarchar(1024)
		DECLARE @Arg		sql_variant
		DECLARE @ArgIndex	integer
		DECLARE @ArgPos		integer
		DECLARE @DataType	integer
		DECLARE @HexFlag	integer
		DECLARE @FullFmtSpec	nvarchar(32)
		DECLARE @FullFmtSpecLen	integer
		SELECT  @RawMessage = Message
		FROM    EvLocaleMsgs
		WHERE       LocaleID = @LocaleID
				AND MessageID = @MessageID
		-- DECLARE CURSOR
		DECLARE SubsArgCursor CURSOR FOR
		SELECT  Q1.ArgIndex, Q1.ArgPos, Q1.DataType, Q1.HexFlag, Q1.FullFmtSpec, Q1.FullFmtSpecLen
		FROM    EvLocaleMsgArgInfo AS Q1
		WHERE       Q1.LocaleID = @LocaleID
				AND Q1.MessageID = @MessageID
		ORDER BY ArgIndex DESC
		-- Open Cursor
		Open SubsArgCursor
		-- Fetch
		FETCH NEXT FROM SubsArgCursor
		INTO @ArgIndex, @ArgPos, @DataType, @HexFlag, @FullFmtSpec, @FullFmtSpecLen
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT @Arg = (CASE @ArgPos
							WHEN 1 THEN @Arg1
							WHEN 2 THEN @Arg2
							WHEN 3 THEN @Arg3
							ELSE @FullFmtSpec
						END)
			SET @RawMessage = dbo.SubstitutePositionalArg(@RawMessage, @Arg, @HexFlag, @ArgIndex - 1, @FullFmtSpecLen)
			FETCH NEXT FROM SubsArgCursor
			INTO @ArgIndex, @ArgPos, @DataType, @HexFlag, @FullFmtSpec, @FullFmtSpecLen
		END
		-- Close & Deallocate Cursors
		CLOSE SubsArgCursor
		DEALLOCATE SubsArgCursor
		RETURN @RawMessage
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SubsArgs3]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SubsArgs3' AND revision = '1.1')

  insert into GXDBVersions values(5, 'SubsArgs3',  '1.1', 'SubsArgs3', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/SubsArgs4.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SubsArgs4'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SubsArgs4]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SubsArgs4]
  delete from GXDBVersions where name = 'SubsArgs4' and type = 5
END
GO

	CREATE FUNCTION SubsArgs4(@LocaleID integer, @MessageID bigint, @Arg1 sql_variant, @Arg2 sql_variant,
			                  @Arg3 sql_variant, @Arg4 sql_variant)
	RETURNS nvarchar(4000)
	WITH ENCRYPTION
	BEGIN
		DECLARE @RawMessage	nvarchar(1024)
		DECLARE @Arg		sql_variant
		DECLARE @ArgIndex	integer
		DECLARE @ArgPos		integer
		DECLARE @DataType	integer
		DECLARE @HexFlag	integer
		DECLARE @FullFmtSpec	nvarchar(32)
		DECLARE @FullFmtSpecLen	integer
		SELECT  @RawMessage = Message
		FROM    EvLocaleMsgs
		WHERE       LocaleID = @LocaleID
				AND MessageID = @MessageID
		-- DECLARE CURSOR
		DECLARE SubsArgCursor CURSOR FOR
		SELECT  Q1.ArgIndex, Q1.ArgPos, Q1.DataType, Q1.HexFlag, Q1.FullFmtSpec, Q1.FullFmtSpecLen
		FROM    EvLocaleMsgArgInfo AS Q1
		WHERE       Q1.LocaleID = @LocaleID
				AND Q1.MessageID = @MessageID
		ORDER BY ArgIndex DESC
		-- Open Cursor
		Open SubsArgCursor
		-- Fetch
		FETCH NEXT FROM SubsArgCursor
		INTO @ArgIndex, @ArgPos, @DataType, @HexFlag, @FullFmtSpec, @FullFmtSpecLen
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT @Arg = (CASE @ArgPos
							WHEN 1 THEN @Arg1
							WHEN 2 THEN @Arg2
							WHEN 3 THEN @Arg3
							WHEN 4 THEN @Arg4
							ELSE @FullFmtSpec
						END)
			SET @RawMessage = dbo.SubstitutePositionalArg(@RawMessage, @Arg, @HexFlag, @ArgIndex - 1, @FullFmtSpecLen)
			FETCH NEXT FROM SubsArgCursor
			INTO @ArgIndex, @ArgPos, @DataType, @HexFlag, @FullFmtSpec, @FullFmtSpecLen
		END
		-- Close & Deallocate Cursors
		CLOSE SubsArgCursor
		DEALLOCATE SubsArgCursor
		RETURN @RawMessage
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SubsArgs4]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SubsArgs4' AND revision = '1.1')

  insert into GXDBVersions values(5, 'SubsArgs4',  '1.1', 'SubsArgs4', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/SubsArgs5.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SubsArgs5'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SubsArgs5]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SubsArgs5]
  delete from GXDBVersions where name = 'SubsArgs5' and type = 5
END
GO

	CREATE FUNCTION SubsArgs5(@LocaleID integer, @MessageID bigint, @Arg1 sql_variant, @Arg2 sql_variant,
			                  @Arg3 sql_variant, @Arg4 sql_variant, @Arg5 sql_variant)
	RETURNS nvarchar(4000)
	WITH ENCRYPTION
	BEGIN
		DECLARE @RawMessage	nvarchar(1024)
		DECLARE @Arg		sql_variant
		DECLARE @ArgIndex	integer
		DECLARE @ArgPos		integer
		DECLARE @DataType	integer
		DECLARE @HexFlag	integer
		DECLARE @FullFmtSpec	nvarchar(32)
		DECLARE @FullFmtSpecLen	integer
		SELECT  @RawMessage = Message
		FROM    EvLocaleMsgs
		WHERE       LocaleID = @LocaleID
				AND MessageID = @MessageID
		-- DECLARE CURSOR
		DECLARE SubsArgCursor CURSOR FOR
		SELECT  Q1.ArgIndex, Q1.ArgPos, Q1.DataType, Q1.HexFlag, Q1.FullFmtSpec, Q1.FullFmtSpecLen
		FROM    EvLocaleMsgArgInfo AS Q1
		WHERE       Q1.LocaleID = @LocaleID
				AND Q1.MessageID = @MessageID
		ORDER BY ArgIndex DESC
		-- Open Cursor
		Open SubsArgCursor
		-- Fetch
		FETCH NEXT FROM SubsArgCursor
		INTO @ArgIndex, @ArgPos, @DataType, @HexFlag, @FullFmtSpec, @FullFmtSpecLen
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT @Arg = (CASE @ArgPos
							WHEN 1 THEN @Arg1
							WHEN 2 THEN @Arg2
							WHEN 3 THEN @Arg3
							WHEN 4 THEN @Arg4
							WHEN 5 THEN @Arg5
							ELSE @FullFmtSpec
						END)
			SET @RawMessage = dbo.SubstitutePositionalArg(@RawMessage, @Arg, @HexFlag, @ArgIndex - 1, @FullFmtSpecLen)
			FETCH NEXT FROM SubsArgCursor
			INTO @ArgIndex, @ArgPos, @DataType, @HexFlag, @FullFmtSpec, @FullFmtSpecLen
		END
		-- Close & Deallocate Cursors
		CLOSE SubsArgCursor
		DEALLOCATE SubsArgCursor
		RETURN @RawMessage
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SubsArgs5]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SubsArgs5' AND revision = '1.1')

  insert into GXDBVersions values(5, 'SubsArgs5',  '1.1', 'SubsArgs5', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/SubsArgs6.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SubsArgs6'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SubsArgs6]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SubsArgs6]
  delete from GXDBVersions where name = 'SubsArgs6' and type = 5
END
GO

	CREATE FUNCTION SubsArgs6(@LocaleID integer, @MessageID bigint, @Arg1 sql_variant, @Arg2 sql_variant,
			                  @Arg3 sql_variant, @Arg4 sql_variant, @Arg5 sql_variant, @Arg6 sql_variant)
	RETURNS nvarchar(4000)
	WITH ENCRYPTION
	BEGIN
		DECLARE @RawMessage	nvarchar(1024)
		DECLARE @Arg		sql_variant
		DECLARE @ArgIndex	integer
		DECLARE @ArgPos		integer
		DECLARE @DataType	integer
		DECLARE @HexFlag	integer
		DECLARE @FullFmtSpec	nvarchar(32)
		DECLARE @FullFmtSpecLen	integer
		SELECT  @RawMessage = Message
		FROM    EvLocaleMsgs
		WHERE       LocaleID = @LocaleID
				AND MessageID = @MessageID
		-- DECLARE CURSOR
		DECLARE SubsArgCursor CURSOR FOR
		SELECT  Q1.ArgIndex, Q1.ArgPos, Q1.DataType, Q1.HexFlag, Q1.FullFmtSpec, Q1.FullFmtSpecLen
		FROM    EvLocaleMsgArgInfo AS Q1
		WHERE       Q1.LocaleID = @LocaleID
				AND Q1.MessageID = @MessageID
		ORDER   BY ArgIndex DESC
		-- Open Cursor
		Open SubsArgCursor
		-- Fetch
		FETCH NEXT FROM SubsArgCursor
		INTO @ArgIndex, @ArgPos, @DataType, @HexFlag, @FullFmtSpec, @FullFmtSpecLen
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT @Arg = (CASE @ArgPos
							WHEN 1 THEN @Arg1
							WHEN 2 THEN @Arg2
							WHEN 3 THEN @Arg3
							WHEN 4 THEN @Arg4
							WHEN 5 THEN @Arg5
							WHEN 6 THEN @Arg6
							ELSE @FullFmtSpec
						END)
			SET @RawMessage = dbo.SubstitutePositionalArg(@RawMessage, @Arg, @HexFlag, @ArgIndex - 1, @FullFmtSpecLen)
			FETCH NEXT FROM SubsArgCursor
			INTO @ArgIndex, @ArgPos, @DataType, @HexFlag, @FullFmtSpec, @FullFmtSpecLen
		END
		-- Close & Deallocate Cursors
		CLOSE SubsArgCursor
		DEALLOCATE SubsArgCursor
		RETURN @RawMessage
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SubsArgs6]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SubsArgs6' AND revision = '1.1')

  insert into GXDBVersions values(5, 'SubsArgs6',  '1.1', 'SubsArgs6', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/BuildSubClientName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BuildSubClientName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BuildSubClientName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BuildSubClientName]
  delete from GXDBVersions where name = 'BuildSubClientName' and type = 5
END
GO

    CREATE FUNCTION BuildSubClientName (@appTypeID int, @instanceName NVARCHAR(255), @bkpSetName NVARCHAR(255), @subClientName NVARCHAR(255), @status INT = 0, @localeId INT = 0)
    RETURNS NVARCHAR(255)
    WITH ENCRYPTION
    AS BEGIN
        RETURN (CASE WHEN     @appTypeID =  2         -- Oracle     -- Instance Applications
                          OR  @appTypeID =  3         -- Informix
                          OR  @appTypeID =  5         -- Sybase
                          OR  @appTypeID =  6         -- Lotus Notes DB
                          OR  @appTypeID = 22         -- Oracle 8
                          OR  @appTypeID = 24         -- Serverless Data Manager
                          OR  @appTypeID = 27         -- FasTrax Exchange DB
                          OR  @appTypeID = 31         -- FasTrax Exchange DB 2000
                          OR  @appTypeID = 32         -- SharePoint DB
                          OR  @appTypeID = 48         -- Serverless Data Manager on Unix
                          OR  @appTypeID = 51         -- UNIX Lotus Notes DB
                          OR  @appTypeID = 59         -- Lotus Notes 6 Database
                          OR  @appTypeID = 61         -- SAP for Oracle
                          OR  @appTypeID = 77         -- Notes 6 Database On Unix
                          OR  @appTypeID = 79         -- SAP for SAPDB
                          OR  @appTypeID = 80         -- Oracle RAC
                          OR  @appTypeID = 81         -- SQL Server
                          OR  @appTypeID = 89         -- Share Point Data Migrator
                          OR  @appTypeID = 104        -- MySQL
                          OR  @appTypeID = 127        -- EDC
                          OR  @appTypeID = 128        -- Documentum
                    THEN  @instanceName + N'\' + @subClientName
                    WHEN  @appTypeID =  4             -- SQL Server     -- Instance & Backupset Applications
                          OR  @appTypeID =  7         -- Lotus Notes Doc
                          OR  @appTypeID = 16         -- SQL Server 2000
                          OR  @appTypeID = 37         -- DB2 (MR #50738)
                          OR  @appTypeID = 52         -- UNIX Lotus Notes Doc
                          OR  @appTypeID = 60         -- Lotus Notes 6 Document
                          OR  @appTypeID = 62         -- Unix DB2 (MR #50738)
                          OR  @appTypeID = 70         -- SQL Server 2005
                          OR  @appTypeID = 89         -- Share Point Data Migrator
                          OR  @appTypeID = 90         -- Lotus Notes Document Data Migrator
                          OR  @appTypeID = 90         -- Lotus Notes Document Data Migrator
                          OR  @appTypeID = 103        -- DB2 DPF
                          OR  @appTypeID = 106        -- VirtualServer
                          OR  @appTypeID = 125        -- Postgress
                          OR  @appTypeID = 130        -- Other AppType
                    THEN  @instanceName + N'\' + @bkpSetName + N'\' + @subClientName
                    WHEN  @appTypeID =  9             -- Exchange Database 5.5 -- Subclient Appcliations
                          OR  @appTypeID = 15         -- Exchange Database 2000
                          OR  @appTypeID = 53         -- Exchange Titanium Database
                          OR  @appTypeID = 65         -- Image Level
                          OR  @appTypeID = 66         -- Unix File System Data Migrator
                          OR  @appTypeID = 67         -- Exchange Archiver
                          OR  @appTypeID = 68         -- Exchange 5.5 Archiver
                          OR  @appTypeID = 25         -- ProxyHost (MR #50352)
                          OR  @appTypeID = 40         -- ProxyHost on Unix (MR #50352)
                          OR  @appTypeID = 47         -- QR Agent (MR #50352)
                          OR  @appTypeID = 50         -- QR Agent on Unix (MR #50352)
                          OR  @appTypeID = 48         -- Serverless Data Manager on Unix (MR #50352)
                          OR  @appTypeID = 71         -- GroupWise DB
                          OR  @appTypeID = 75         -- Image Level On Unix
                          OR  @appTypeID = 76         -- Proxy Host For Image Level
                          OR  @appTypeID = 87         -- Image Level ProxyHost on Unix
                    THEN  @subClientName
                    WHEN  (@appTypeID =  58 AND @status & 0x400 = 0x400) -- Windows File System Data Migrator
                    THEN  (CASE LEN(@instanceName)
                                WHEN 0 THEN N'Local Migration Instance\'+ dbo.SubsArgs0(@localeID, CAST(1644167168 AS BIGINT) | CAST(246 AS BIGINT)) + N'\' + @subClientName
                                ELSE @instanceName + N'\' + dbo.SubsArgs0(@localeID, CAST(1644167168 AS BIGINT) | CAST(246 AS BIGINT)) + N'\' + @subClientName
                            END)
                    WHEN  (@appTypeID =  58 and @status & 0x400 <> 0x400) -- Windows File System Data Migrator
                    THEN  (CASE LEN(@instanceName)
                                WHEN 0 THEN N'Local Migration Instance\Local Migration BackupSet\'+ @subClientName
                                ELSE @instanceName + N'\' + @bkpSetName + N'\' + @subClientName
                           END)
                    WHEN   @appTypeID = 69
                    THEN   N'Databases\' + @subClientName
                    WHEN   @appTypeID = 73
                    THEN   (CASE LEN(@instanceName)
                                 WHEN 0 THEN N'Network Share Instance\Network Share Backupset\'+ @subClientName
                                 ELSE @instanceName + N'\' + @bkpSetName + N'\' + @subClientName
                            END)
                    ELSE  @bkpSetName + N'\' + @subClientName -- Any other AppType
            END)
    END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BuildSubClientName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BuildSubClientName' AND revision = '1.2')

  insert into GXDBVersions values(5, 'BuildSubClientName',  '1.2', 'BuildSubClientName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/BuildSubClientNameIndirect.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BuildSubClientNameIndirect'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BuildSubClientNameIndirect]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BuildSubClientNameIndirect]
  delete from GXDBVersions where name = 'BuildSubClientNameIndirect' and type = 5
END
GO

    CREATE FUNCTION BuildSubClientNameIndirect(@appTypeID INT, @instanceId INT, @backupsetId INT, @subClientId INT, @status INT = 0, @localeId INT = 0)
    RETURNS NVARCHAR(255)
    WITH ENCRYPTION
    AS BEGIN
        DECLARE @instanceName  NVARCHAR(255) = ISNULL((SELECT [name] FROM APP_InstanceName WHERE id = @instanceId), 'default')
        DECLARE @bkpSetName    NVARCHAR(255) = ISNULL((SELECT [name] FROM APP_BackupSetName WHERE id = @backupsetId), 'default')
        DECLARE @subClientName NVARCHAR(255) = ISNULL((SELECT subclientName FROM APP_Application WHERE id = @subClientId),'default')
        RETURN  dbo.BuildSubClientName(@appTypeID, @instanceName, @bkpSetName, @subClientName, @status, @localeId)
    END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BuildSubClientNameIndirect]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BuildSubClientNameIndirect' AND revision = '1.1')

  insert into GXDBVersions values(5, 'BuildSubClientNameIndirect',  '1.1', 'BuildSubClientNameIndirect', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/BuildSubClientNameById.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BuildSubClientNameById'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BuildSubClientNameById]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BuildSubClientNameById]
  delete from GXDBVersions where name = 'BuildSubClientNameById' and type = 5
END
GO

    CREATE FUNCTION BuildSubClientNameById(@subClientId INT, @status INT = 0, @localeId INT = 0)
    RETURNS NVARCHAR(255)
    WITH ENCRYPTION
    AS BEGIN
        DECLARE @instanceName   NVARCHAR(255)
        DECLARE @bkpSetName     NVARCHAR(255)
        DECLARE @subClientName  NVARCHAR(255)
        DECLARE @appTypeID      INT
        SELECT  @instanceName   = ISNULL((SELECT [name] FROM APP_InstanceName  WHERE id = A.instance), 'default'),
                @bkpSetName     = ISNULL((SELECT [name] FROM APP_BackupSetName WHERE id = A.backupSet), 'default'),
                @subClientName  = A.subclientName,
                @appTypeID      = A.appTypeId
        FROM APP_Application A
        WHERE   id = @subClientId
        RETURN  dbo.BuildSubClientName(@appTypeID, @instanceName, @bkpSetName, @subClientName, @status, @localeId)
    END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BuildSubClientNameById]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BuildSubClientNameById' AND revision = '1.1')

  insert into GXDBVersions values(5, 'BuildSubClientNameById',  '1.1', 'BuildSubClientNameById', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/RoundPercent.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: RoundPercent'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RoundPercent]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RoundPercent]
  delete from GXDBVersions where name = 'RoundPercent' and type = 5
END
GO

    CREATE FUNCTION RoundPercent ( @valueToRound FLOAT, @roundingMethod INTEGER )
    RETURNS INT
    WITH ENCRYPTION
    AS
    BEGIN
        declare @rv int
        if @valueToRound > 0 begin
            if @roundingMethod = 1 begin
                set @rv = CAST( (@valueToRound + 0.5) as int )
            end
            else if @roundingMethod = 2 begin
                set @rv = CAST( (@valueToRound + 0.4) as int )
            end
            else if @roundingMethod = 3 begin
                if (CAST(@valueToRound as int) % 2) = 0
                    set @rv = CAST( (@valueToRound  + 0.5) as int )
                else
                    set @rv = CAST( (@valueToRound  + 0.4) as int )
            end
            else begin
                set @rv = @valueToRound
            end
        end
        else begin
            set @rv = 0
        end
        return @rv
    end



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RoundPercent]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RoundPercent' AND revision = '1.1')

  insert into GXDBVersions values(5, 'RoundPercent',  '1.1', 'RoundPercent', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/isBkpJobLevelMatches.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isBkpJobLevelMatches'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isBkpJobLevelMatches]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isBkpJobLevelMatches]
  delete from GXDBVersions where name = 'isBkpJobLevelMatches' and type = 5
END
GO

	CREATE FUNCTION [dbo].[isBkpJobLevelMatches](@bkpLevel INT, @backupFull INT, @backupIncremental INT, @backupDifferential INT, @backupSynthetic INT)
	RETURNS BIT
	AS
	BEGIN
		DECLARE @rv BIT = 0
	    IF @backupFull <> 0 AND @backupIncremental <> 0 AND @backupDifferential <> 0 AND @backupSynthetic <> 0 BEGIN
	        SET @rv = 1
	    END
	    ELSE BEGIN
	        IF      (@backupFull         <> 0 AND dbo.IsBackupLevelFull(@bkpLevel) = 1 AND dbo.IsBackupLevelSynthFull(@bkpLevel) <> 1)
	            OR  (@backupIncremental  <> 0 AND @bkpLevel = 2 )
	            OR  (@backupDifferential <> 0 AND @bkpLevel = 4 )
	            OR  (@backupSynthetic    <> 0 AND dbo.IsBackupLevelSynthFull(@bkpLevel) = 1) BEGIN
	                SET @rv = 1
	        END
	    END
	    RETURN @rv
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isBkpJobLevelMatches]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isBkpJobLevelMatches' AND revision = '1.2')

  insert into GXDBVersions values(5, 'isBkpJobLevelMatches',  '1.2', 'isBkpJobLevelMatches', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/isJobStateMatches.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isJobStateMatches'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isJobStateMatches]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isJobStateMatches]
  delete from GXDBVersions where name = 'isJobStateMatches' and type = 5
END
GO

 CREATE FUNCTION [dbo].[isJobStateMatches](@jobState INT, @stateCompleted INT, @stateCompletedErr INT, @stateCompletedWrn INT, @stateFailed INT, @stateKilled INT, @stateDelayed INT, @stateActive INT, @stateNoRun INT)
 RETURNS BIT
 AS
 BEGIN
     DECLARE @rv BIT = 1
     IF (@stateCompleted = 0) OR (@stateCompletedErr = 0) OR (@stateCompletedWrn = 0) OR (@stateFailed = 0) OR
        (@stateKilled = 0) OR (@stateDelayed = 0) OR (@stateActive = 0) OR (@stateNoRun = 0) BEGIN

         SET @rv = 0

         IF   ((@stateCompleted    <> 0) AND (@jobState IN (4, 9)))          -- COMPLETED, COMPLETEDSUCCESS                                 : COMPLETED
 		    OR((@stateCompletedErr <> 0) AND (@jobState IN (12)))            -- COMPLETEDPARTIAL                                             : COMPLETED_WITH_ERRORS
 		    OR((@stateCompletedWrn <> 0) AND (@jobState IN (19)))            -- COMPLETEDWITHWARNINGS                                        : COMPLETED_WITH_WARNINGS
            OR((@stateFailed       <> 0) AND (@jobState IN (10, 18)))        -- COMPLETEDFAIL, DANGLINGJOBCLEANUP                            : FAILED
		    OR((@stateKilled       <> 0) AND (@jobState IN (11 )))           -- STATEKILLED                                                  : KILLED
		    OR((@stateDelayed      <> 0) AND (@jobState IN (2,3,5,14,15,16)))-- PENDING, WAITING, STOPPED, DORMANTSCHEDWAIT, DORMANT, QUEUED : DELAYED
            OR((@stateActive       <> 0) AND (@jobState IN (1,6,7,8,13,17))) -- RUNNING, *PENDING, RUNNING_UNVERIFIABLE                      : RUNNING
         BEGIN
             SET @rv = 1
         END

     END

     RETURN @rv
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isJobStateMatches]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isJobStateMatches' AND revision = '1.2')

  insert into GXDBVersions values(5, 'isJobStateMatches',  '1.2', 'isJobStateMatches', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/isJobStatusMatches.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isJobStatusMatches'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isJobStatusMatches]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isJobStatusMatches]
  delete from GXDBVersions where name = 'isJobStatusMatches' and type = 5
END
GO

 CREATE FUNCTION [isJobStatusMatches](@jobStatus INT, @statusCompleted INT, @statusCompletedErr INT, @statusCompletedWrn INT, @statusFailed INT, @statusKilled INT, @statusDelayed INT, @statusActive INT, @statusNoRun INT)
 RETURNS BIT
 AS
 BEGIN
    DECLARE @rv BIT = 1

    IF (@statusCompleted = 0) OR (@statusCompletedErr = 0) OR (@statusCompletedWrn = 0) OR (@statusFailed = 0) OR
       (@statusKilled = 0) OR (@statusDelayed = 0) OR (@statusActive = 0) OR (@statusNoRun = 0) BEGIN

        SET @rv = 0

        IF     @jobStatus = 7
            OR ((@statusCompleted    <> 0) AND (@jobStatus IN (1)))             -- JMSUCCESS
            OR ((@statusCompletedErr <> 0) AND (@jobStatus IN (3)))             -- PARTIALSUCCESS
            OR ((@statusCompletedWrn <> 0) AND (@jobStatus IN (14, 16)))            -- JMSUCCESSWITHWARNINGS
            OR ((@statusFailed       <> 0) AND (@jobStatus IN (2,15)))          -- FAIL, SYSTEMFAILED
            OR ((@statusKilled       <> 0) AND (@jobStatus IN (4)))             -- KILLED
            OR ((@statusDelayed      <> 0) AND (@jobStatus IN (5,6)))           -- STSTOPPED, STINTERRUPTED
            OR ((@statusActive       <> 0) AND (@jobStatus IN (10, 11, 12,13))) -- NOTATTEMPTED, CVJOBSTATUS_STARTED
            OR ((@statusNoRun        <> 0) AND (@jobStatus IN (8,9)))           -- STSKIPPED, DROPPED
        BEGIN
            SET @rv = 1
        END
    END

    RETURN @rv
  END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isJobStatusMatches]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isJobStatusMatches' AND revision = '1.3')

  insert into GXDBVersions values(5, 'isJobStatusMatches',  '1.3', 'isJobStatusMatches', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/BuildFullEntityName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BuildFullEntityName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BuildFullEntityName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BuildFullEntityName]
  delete from GXDBVersions where name = 'BuildFullEntityName' and type = 5
END
GO

    CREATE FUNCTION BuildFullEntityName (@groupBy INT, @subclientId INT, @status INT = 0, @localeId INT = 0)
    RETURNS NVARCHAR(2048)
    WITH ENCRYPTION
    AS BEGIN
        DECLARE @commCellName   NVARCHAR(512) = N''
        DECLARE @clientName     NVARCHAR(512) = N''
        DECLARE @agentName      NVARCHAR(512) = N''
        DECLARE @subclientName  NVARCHAR(512) = dbo.BuildSubClientNameById(@subclientId, @status, @localeId)
        SELECT  @commCellName   = CC.aliasName,
        @clientName     = CL.name,
        @agentName      = IDA.name
        FROM    APP_Application A   INNER JOIN APP_Client CL ON CL.id = A.clientId
                INNER JOIN APP_CommCell CC ON CC.id = A.origCCId
                INNER JOIN APP_iDAType IDA ON IDA.[type] = A.appTypeId
        WHERE A.id = @subclientId
        IF SUBSTRING(@subclientName, 1, LEN(@clientName) + 1) = @clientName + N'\' BEGIN
            -- some subclient names could start with client name.
            SET @subclientName = SUBSTRING(@subclientName, (LEN(@clientName) + 2), LEN(@subclientName))
        END
        DECLARE @fullName      NVARCHAR(2000) = N''
        IF @groupBy = 1 BEGIN               -- client
            SET @fullName = @agentName + N'\' + @subclientName
        END ELSE IF @groupBy = 2 BEGIN      -- agent
            SET @fullName = @commCellName + N'\' + @clientName + N'\' + @subclientName
        END ELSE IF @groupBy = 4 BEGIN      -- client group
            SET @fullName = @commCellName + N'\' + @agentName + N'\' + @clientName + N'\' + @subclientName
        END ELSE BEGIN                          -- commcell, storage, job
            SET @fullName = @clientName + N'\' + + @agentName + N'\' + @subclientName
        END
        RETURN  @fullName
    END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BuildFullEntityName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BuildFullEntityName' AND revision = '1.1')

  insert into GXDBVersions values(5, 'BuildFullEntityName',  '1.1', 'BuildFullEntityName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobStatusForReport.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobStatusForReport'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobStatusForReport]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobStatusForReport]
  delete from GXDBVersions where name = 'GetJobStatusForReport' and type = 5
END
GO

 CREATE FUNCTION [GetJobStatusForReport](@statusOrStateValue INT, @isStatus bit = 1)
 RETURNS INT
 AS
 BEGIN
     DECLARE @rv INT = NULL

 	--COMPLETED               =1,
 	--COMPLETED_WITH_ERRORS   =2,
	--COMPLETED_WITH_WARNINGS =3,
	--FAILED                  =4,
	--KILLED                  =5,
	--DELAYED                 =6,
	--RUNNING                 =7,
    --NORUN                   =8

     IF @isStatus = 1 BEGIN

         SET @rv = CASE @statusOrStateValue WHEN  1 THEN  1  -- JMSUCCESS                : COMPLETED
                                            WHEN  2 THEN  4  -- FAIL                     : FAILED
                                            WHEN  3 THEN  2  -- PARTIALSUCCESS           : COMPLETED_WITH_ERRORS
                                            WHEN  4 THEN  5  -- KILLED                   : KILLED
                                            WHEN  5 THEN  6  -- STSTOPPED                : DELAYED
                                            WHEN  6 THEN  6  -- STINTERRUPTED            : DELAYED
                                            WHEN  8 THEN  8  -- STSKIPPED                : NO RUN
                                            WHEN  9 THEN  8  -- DROPPED                  : NO RUN
                                            WHEN 10 THEN  4  -- INSYNC                   : RUNNING
                                            WHEN 11 THEN  4  -- OUTOFSYNC                : RUNNING
                                            WHEN 12 THEN  7  -- NOTATTEMPTED             : RUNNING
                                            WHEN 13 THEN  7  -- CVJOBSTATUS_STARTED      : RUNNING
                                            WHEN 14 THEN  3  -- JMSUCCESSWITHWARNINGS    : COMPLETED_WITH_WARNINGS
                                            WHEN 15 THEN  4  -- SYSTEMFAILED	     : FAILED
                                            WHEN 16 THEN  9  -- COMMITTED 	             : COMPLETED_WITH_WARNINGS
                                            ELSE -1
                   END

     END ELSE BEGIN

         SET @rv = CASE @statusOrStateValue WHEN  1 THEN  7  -- RUNNING                  : RUNNING
                                            WHEN  2 THEN  6  -- PENDING                  : DELAYED
                                            WHEN  3 THEN  6  -- WAITING                  : DELAYED
                                            WHEN  4 THEN  1  -- COMPLETED                : COMPLETED
                                            WHEN  5 THEN  6  -- STOPPED                  : DELAYED
                                            WHEN  6 THEN  7  -- KILLPENDING              : RUNNING
                                            WHEN  7 THEN  7  -- STOPPENDING              : RUNNING
                                            WHEN  8 THEN  7  -- INTERRUPTPENDING         : RUNNING
                                            WHEN  9 THEN  1  -- COMPLETEDSUCCESS         : COMPLETED
                                            WHEN 10 THEN  4  -- COMPLETEDFAIL            : FAILED
                                            WHEN 11 THEN  5  -- STATEKILLED              : KILLED
                                            WHEN 12 THEN  2  -- COMPLETEDPARTIAL         : COMPLETED_WITH_ERRORS
                                            WHEN 13 THEN  7  -- SYSTEMKILLPENDING        : RUNNNING
                                            WHEN 14 THEN  6  -- DORMANT                  : DELAYED
                                            WHEN 15 THEN  6  -- QUEUED                   : DELAYED
                                            WHEN 16 THEN  6  -- DORMANTSCHEDWAIT         : DELAYED
                                            WHEN 17 THEN  7  -- RUNNING_UNVERIFIABLE     : RUNNING
                                            WHEN 18 THEN  4  -- DANGLINGJOBCLEANUP       : FAILED
                                            WHEN 19 THEN  3  -- COMPLETEDWITHWARNINGS    : COMPLETED_WITH_WARNINGS
                                            ELSE -1
                   END
     END

     RETURN @rv

 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobStatusForReport]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobStatusForReport' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetJobStatusForReport',  '1.4', 'GetJobStatusForReport', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppCheckSecurityPermissions.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AppCheckSecurityPermissions'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppCheckSecurityPermissions]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppCheckSecurityPermissions]
  delete from GXDBVersions where name = 'AppCheckSecurityPermissions' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION AppCheckSecurityPermissions ( @userId integer, @securityInfo XML)
	RETURNS integer
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result integer
		SET @result = (SELECT 1 WHERE @userId IN (SELECT ref.value('@userId', 'integer')
					FROM  @securityInfo.nodes ('securityAssociations/users') R(ref)))
		IF (@result = 0 or @result IS NULL)
			IF ( (SELECT COUNT(UG.userId) from umusergroup AS UG where groupId in (SELECT ref.value('@userGroupId', 'integer')
			FROM  @securityInfo.nodes ('securityAssociations/userGroups') R(ref)) AND UG.userId=@userId) > 0)
				SET @result = 1
		IF (@result = 0 or @result IS NULL )
			IF ( (SELECT COUNT(EUG.userId) from umdsusergroup AS EUG where groupId in (SELECT ref.value('@groupId', 'integer')
			FROM  @securityInfo.nodes ('securityAssociations/externalUserGroups') R(ref)) AND EUG.userId=@userId) > 0)
				SET @result = 1
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppCheckSecurityPermissions]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppCheckSecurityPermissions' AND revision = '1.4')

  insert into GXDBVersions values(5, 'AppCheckSecurityPermissions',  '1.4', 'AppCheckSecurityPermissions', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/AppCheckVMPolicySecurityPermissions.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AppCheckVMPolicySecurityPermissions'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AppCheckVMPolicySecurityPermissions]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AppCheckVMPolicySecurityPermissions]
  delete from GXDBVersions where name = 'AppCheckVMPolicySecurityPermissions' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION AppCheckVMPolicySecurityPermissions ( @userId integer, @policyId integer, @flags integer)
	RETURNS integer
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result integer = 0
		IF (@flags = 0)
		BEGIN
			IF EXISTS (SELECT * FROM app_vmallocationpolicyprop WHERE @policyId=componentNameId AND @userId=CAST(attrVal as INT) AND (attrName='user'))
				SET @result = 1
			IF (@result = 0)
				IF EXISTS (SELECT * FROM umusergroup AS UG INNER JOIN app_vmallocationpolicyprop AS VM_APP ON CAST(VM_APP.attrVal as INT)=UG.groupId
									 WHERE (@policyId=VM_APP.componentNameId) AND (UG.userId=@userId) AND (VM_APP.attrName='usergroup'))
												SET @result	= 1
			IF (@result = 0)
				IF EXISTS (SELECT * FROM umdsusergroup AS UG INNER JOIN app_vmallocationpolicyprop AS VM_APP ON CAST(VM_APP.attrVal as INT)=UG.groupId
									 WHERE (@policyId=VM_APP.componentNameId) AND (UG.userId=@userId) AND (VM_APP.attrName='extusergroup'))
												SET @result	= 1
			IF (@result = 0)
				IF EXISTS (SELECT * FROM UMDSUserGroup AS UG INNER JOIN UMDSGroupMaps AS UDSM ON  UDSM.umDSgroupId = UG.groupId JOIN app_vmallocationpolicyprop AS VM_APP ON CAST(VM_APP.attrVal as INT)=UDSM.umgroupId
								 WHERE (@policyId=VM_APP.componentNameId) AND (UG.userId=@userId) AND (VM_APP.attrName='usergroup'))
												SET @result =1
			END
		ELSE
		BEGIN
			SELECT	@result = dbo.IsClientVisible(@userId, A.clientId, 0, 0, 0, 0)
			FROM	App_VMAllocationPolicy P
					INNER JOIN App_VMDataCenterMap M
						ON P.vDataCenterId = M.vDataCenterId
					INNER JOIN APP_Application A
						ON M.instanceId = A.instance
			WHERE	P.id = @policyId
			IF @result = 0
			BEGIN
				DECLARE @memberServers table(vsMemberServers xml);

				INSERT INTO @memberServers
				SELECT	CAST(IP.attrVal AS XML)
				FROM	App_VMAllocationPolicy P
						INNER JOIN App_VMDataCenterMap M
							ON P.vDataCenterId = M.vDataCenterId
						INNER JOIN APP_InstanceProp IP
							ON M.instanceId = IP.componentNameId
				WHERE	P.id = @policyId
					AND IP.attrName = 'Vs Member Servers'

				SELECT @result = MAX(dbo.IsClientVisible(@userId, ISNULL(ref.value('client[1]/@clientId', 'INTEGER'),0), 0, 0, 0, 0))
				FROM  @memberServers srvTab cross apply srvTab.vsMemberServers.nodes('App_MemberServers/memberServers') R ( ref )
			END
		END
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AppCheckVMPolicySecurityPermissions]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AppCheckVMPolicySecurityPermissions' AND revision = '1.5')

  insert into GXDBVersions values(5, 'AppCheckVMPolicySecurityPermissions',  '1.5', 'AppCheckVMPolicySecurityPermissions', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDateTimeBig.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDateTimeBig'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDateTimeBig]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDateTimeBig]
  delete from GXDBVersions where name = 'GetDateTimeBig' and type = 5
END
GO

	CREATE FUNCTION GetDateTimeBig (@UnixTimeArg bigint)
	RETURNS DATETIME
	WITH ENCRYPTION
	AS
	BEGIN
	declare @l_MAXINT int = 2147483647
	/*DateAdd function doesn't take bigint - so split the input into a number of max ints
	and call DateAdd for each*/
	if(@UnixTimeArg > @l_MAXINT)
	begin
		declare @iterations bigint
		declare @reminder int
		declare @dateVar datetime = '01/01/1970'
		SET @iterations = @UnixTimeArg/@l_MAXINT
		SET @reminder = @UnixTimeArg%@l_MAXINT
		WHILE(@iterations > 0)
		begin
			select @dateVar = dateadd(second,@l_MAXINT,@dateVar)
			SET @iterations = @iterations - 1
		end
		IF @reminder > 0
			select @dateVar = dateadd(second,@reminder,@dateVar)
		return @dateVar
	end
	return dateadd(second, @UnixTimeArg, '01/01/1970')
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDateTimeBig]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDateTimeBig' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetDateTimeBig',  '1.1', 'GetDateTimeBig', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetUnixTimeBig.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetUnixTimeBig'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetUnixTimeBig]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetUnixTimeBig]
  delete from GXDBVersions where name = 'GetUnixTimeBig' and type = 5
END
GO

	CREATE FUNCTION GetUnixTimeBig (@DateTimeArg datetime)
	RETURNS BIGINT
	WITH ENCRYPTION
	AS
	BEGIN
	declare @MAXINT integer = 2147483647
	declare @MAXINTDATE datetime = '2038-01-19 03:14:07.000'
	declare @baseDate datetime = '1970-01-01 00:00:00.000'
	declare @unixtime bigint = 0
	while(@DateTimeArg > @MAXINTDATE)
	begin
		set @unixtime = @unixtime + @MAXINT
		set @DateTimeArg = DATEADD(SECOND,-@MAXINT,@DateTimeArg)
	end
	if(@DateTimeArg > @baseDate)
		set @unixtime =  @unixtime + datediff(second, @baseDate, @DateTimeArg)
	return @unixtime
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetUnixTimeBig]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetUnixTimeBig' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetUnixTimeBig',  '1.1', 'GetUnixTimeBig', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetBillableInformation.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetBillableInformation'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetBillableInformation]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetBillableInformation]
  delete from GXDBVersions where name = 'GetBillableInformation' and type = 5
END
GO

	CREATE FUNCTION GetBillableInformation
	(
	@clientId int,
	@appTypeId int,
	@instId int,
	@backupSetId int,
	@appId int
	)
    RETURNS
	@billableInformation table
	(
	instanceID INT,
	isQnetReg INT,
	assocEntityID	INT,
	assocLevel INT,
	assocDisplayName NVARCHAR(MAX))
     AS
	BEGIN
	DECLARE @QnetRegStatus INT
	DECLARE @r_tmpAssocEntityID INT
	DECLARE @r_tmpAssocLevel	INT
	DECLARE @r_appId	INT
	DECLARE @r_AssocEntityID INT
	DECLARE @r_AssocLevel	INT
	DECLARE @r_AssocDisplayName	NVARCHAR(MAX)
	IF (EXISTS (SELECT * FROM QNetReg WHERE RegStatus = 1))
	BEGIN
	SET @QnetRegStatus = 1
	INSERT INTO @billableInformation(instanceID) VALUES (@instId)
		UPDATE @billableInformation  SET isQnetReg = @QnetRegStatus WHERE instanceID = @instId
	END
	IF 	@QnetRegStatus = 1
	BEGIN
		SELECT @r_tmpAssocEntityID = EntityID, @r_tmpAssocLevel = AssocType
		FROM BLEntityMembers
		WHERE ClientID IN (@clientID, 0)
		AND AppTypeID IN (@appTypeID, 0)
		AND InstanceID IN (@instId, 0)
		AND BackupSetID IN (@backupSetId,0)
		AND AppID IN (@appId,0)
		SELECT @r_AssocEntityID = BLE.EntityID,
		@r_AssocDisplayName = (SELECT (CASE WHEN (BLE.QNetDisplayName IS null) THEN BLE.DisplayName ELSE BLE.QNetDisplayName + '/' + BLE.DisplayName END)),
		@r_AssocLevel = (SELECT AssocLevel = (CASE WHEN @r_tmpAssocLevel IS null THEN 0
				ELSE @r_tmpAssocLevel
				END)
			)
		FROM BLEntity BLE
		WHERE EntityID = (SELECT EntityID = (CASE WHEN @r_tmpAssocEntityID IS null THEN 1
				ELSE @r_tmpAssocEntityID
				END))
		UPDATE  @billableInformation SET assocEntityID =@r_AssocEntityID ,assocLevel = @r_AssocLevel ,assocDisplayName = @r_AssocDisplayName WHERE instanceID = @instId
	END
	RETURN
    END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetBillableInformation]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetBillableInformation' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetBillableInformation',  '1.2', 'GetBillableInformation', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetIPAddressString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetIPAddressString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetIPAddressString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetIPAddressString]
  delete from GXDBVersions where name = 'GetIPAddressString' and type = 5
END
GO

	CREATE FUNCTION GetIPAddressString (@i_IP BIGINT)
	RETURNS VARCHAR(20)
	WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE @IPString	VARCHAR(20)
		IF @i_IP = -1
			SET @IPString = '255.255.255.255'
		ELSE
		BEGIN
			IF @i_IP < 0
				SET @i_IP = @i_IP + 4294967296
			DECLARE @Octet1		BIGINT
	 		DECLARE @Octet2		TINYINT
	 		DECLARE @Octet3		TINYINT
	 		DECLARE @Octet4		TINYINT
	 		SET @Octet1	= @i_IP / (256 * 256 * 256)
	 		SET @Octet2	= (@i_IP - @Octet1 * 256 * 256 * 256) / (256 * 256)
	 		SET @Octet3	= (@i_IP - @Octet1 * 256 * 256 * 256 - @Octet2 * 256 * 256) / 256
	 		SET @Octet4	= (@i_IP - @Octet1 * 256 * 256 * 256 - @Octet2 * 256 * 256 - @Octet3 * 256)
	 		SET @IPString	= (CONVERT(VARCHAR, @Octet1) + '.' + CONVERT(VARCHAR, @Octet2) + '.' + CONVERT(VARCHAR, @Octet3) + '.' + CONVERT(VARCHAR, @Octet4))
		END
	 	RETURN @IPString
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetIPAddressString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetIPAddressString' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetIPAddressString',  '1.4', 'GetIPAddressString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetIPAddressInt.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetIPAddressInt'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetIPAddressInt]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetIPAddressInt]
  delete from GXDBVersions where name = 'GetIPAddressInt' and type = 5
END
GO

	CREATE FUNCTION GetIPAddressInt (@i_IP VARCHAR(20))
	RETURNS BIGINT
	WITH ENCRYPTION
	AS
	BEGIN
		RETURN (CONVERT(BIGINT, PARSENAME(@i_IP,1)) + CONVERT(BIGINT, PARSENAME(@i_IP,2)) * 256 + CONVERT(BIGINT, PARSENAME(@i_IP,3)) * 256 * 256 + CONVERT(BIGINT, PARSENAME(@i_IP,4)) * 256 * 256 * 256)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetIPAddressInt]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetIPAddressInt' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetIPAddressInt',  '1.1', 'GetIPAddressInt', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetWorkflowStatusName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetWorkflowStatusName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetWorkflowStatusName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetWorkflowStatusName]
  delete from GXDBVersions where name = 'GetWorkflowStatusName' and type = 5
END
GO

	CREATE FUNCTION GetWorkflowStatusName (@Status int)
	RETURNS nvarchar(255)
	AS
	BEGIN
		DECLARE @statusName varchar(255)
		SELECT @statusName =
			CASE @Status
			WHEN 0 THEN 'Idle'
			WHEN 1 THEN 'Queued'
			WHEN 2 THEN 'Running'
			WHEN 3 THEN 'Suspended'
			WHEN 4 THEN 'Success'
			WHEN 5 THEN 'Error'
			WHEN 6 THEN 'Failed'
			ELSE 'Unknown' END
		RETURN @statusName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetWorkflowStatusName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetWorkflowStatusName' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetWorkflowStatusName',  '1.1', 'GetWorkflowStatusName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientForWorkflow.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientForWorkflow'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientForWorkflow]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientForWorkflow]
  delete from GXDBVersions where name = 'GetClientForWorkflow' and type = 5
END
GO

	CREATE FUNCTION GetClientForWorkflow(@workflowId INTEGER, @clientId INTEGER)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		-- retrieve all installed engines that have the provided workflow id latest version deployed to it
		DECLARE @latestVersion INT
		SELECT @latestVersion = MAX(version)
		FROM WF_Deploy
		WHERE WorkflowId = @workflowId
		DECLARE @t_clients TABLE (rowNum int, clientId int, flag int);
		INSERT INTO @t_clients(rowNum, clientId, flag)
		SELECT ROW_NUMBER() OVER (ORDER BY ClientId), ClientId, 1
		FROM dbo.simInstalledPackages
		WHERE simPackageID = 808
		AND ClientId in (SELECT clientId FROM WF_Deploy WHERE WorkflowId = @workflowId AND version = @latestVersion)
		-- set the provided default client as the highest priority (if it exists)
		UPDATE @t_clients
		SET flag = 0
		WHERE clientId = @clientId
		DECLARE @selectedClientId int
		DECLARE @count INT
		SELECT @count = COUNT(*) FROM @t_clients
		IF (@count > 0)
		BEGIN
			--check to see if we are randomly selecting an engine
			IF EXISTS(SELECT * FROM GXGlobalParam WHERE name = 'RandomWorkflowEngine' and value = '1')
			BEGIN
				--return a random engine
				DECLARE @randomRow INT
				SET @randomRow = DATEPART(SECOND, GETDATE()) % @count
				SELECT TOP 1 @selectedClientId = clientId
				FROM @t_clients t
				WHERE rowNum = @randomRow+1
			END
			ELSE
			BEGIN
				-- return the highest priority client
				SELECT TOP 1 @selectedClientId = clientId
				FROM @t_clients t
				ORDER BY t.flag
			END
		END
		RETURN @selectedClientId
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientForWorkflow]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientForWorkflow' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetClientForWorkflow',  '1.3', 'GetClientForWorkflow', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetUserInteractions.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetUserInteractions'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetUserInteractions]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetUserInteractions]
  delete from GXDBVersions where name = 'GetUserInteractions' and type = 5
END
GO

 CREATE FUNCTION GetUserInteractions (
 	@USER_ID		INTEGER,
 	@ALLOW_ALL		BIT=0
 	)
  RETURNS @Results TABLE (
 	InteractionId	INT
  )
  AS
  BEGIN

 	IF (@ALLOW_ALL = 1)
 	BEGIN
  		DECLARE @isUserAdmin int = 0
  		IF EXISTS ( SELECT UD.userId
  					FROM UMDSUserGroup UD INNER JOIN UMDSGroupMaps GM
  					ON UD.groupId = GM.umDSgroupId
  					WHERE UD.userId = @USER_ID AND GM.umgroupId = 1 )
  			SET @isUserAdmin = 1
  		IF EXISTS (	SELECT id
  					FROM UMUserGroup INNER JOIN UMUsers
  					ON UMUserGroup.userId = UMUsers.id
  					WHERE UMUsers.id = @USER_ID AND UMUserGroup.groupId = 1 )
  			SET @isUserAdmin = 1

  		IF (@isUserAdmin = 1)
  		BEGIN
  			INSERT INTO @Results(InteractionId)
  			SELECT InteractionId
  			FROM WF_Interaction

  			GOTO COMPLETE
  		END
  	END

  	INSERT INTO @Results(InteractionId)
  	SELECT Distinct InteractionId
  	FROM WF_InteractionUsers
  	WHERE userId = @USER_ID

  	INSERT INTO @Results(InteractionId)
  	SELECT Distinct InteractionId
  	FROM WF_InteractionUsers
  	WHERE groupId in
  	(
  		SELECT UMGroups.id
  		FROM UMGroups INNER JOIN UMUserGroup ON UMGroups.id = UMUserGroup.groupId
  		WHERE UMUserGroup.userId = @USER_ID
  	)
  	And InteractionId NOT IN (SELECT InteractionId FROM @Results)

  	INSERT INTO @Results(InteractionId)
  	SELECT Distinct InteractionId
  	FROM WF_InteractionUsers
  	WHERE groupId in
  	(
  		SELECT   DISTINCT  UMGroups.id
  		FROM      UMGroups INNER JOIN
  				  UMDSGroupMaps ON UMGroups.id = UMDSGroupMaps.umgroupId INNER JOIN
  				  UMDSUserGroup ON UMDSGroupMaps.umDSgroupId = UMDSUserGroup.groupId
  		WHERE     UMDSUserGroup.userId  = @USER_ID
  	)
  	And InteractionId NOT IN (SELECT InteractionId FROM @Results)

  	INSERT INTO @Results(InteractionId)
  	SELECT Distinct InteractionId
  	FROM WF_InteractionUsers
  	WHERE extGroupId in
  	(
  		SELECT UMDSgroups.id
  		FROM UMDSgroups INNER JOIN UMDSUserGroup ON UMDSgroups.id = UMDSUserGroup.groupId
  		WHERE UMDSUserGroup.userId = @USER_ID
  	)
  	And InteractionId NOT IN (SELECT InteractionId FROM @Results)

  	COMPLETE:

  RETURN
  END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetUserInteractions]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetUserInteractions' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetUserInteractions',  '1.4', 'GetUserInteractions', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsBEAssocPresent_QSUtilFN.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsBEAssocPresent_QSUtilFN'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsBEAssocPresent_QSUtilFN]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsBEAssocPresent_QSUtilFN]
  delete from GXDBVersions where name = 'IsBEAssocPresent_QSUtilFN' and type = 5
END
GO

	CREATE FUNCTION IsBEAssocPresent_QSUtilFN(@cid integer,@assoclevel integer,@apptypeid integer, @instanceid integer, @backupid integer)
	RETURNS INTEGER
	AS
	BEGIN
	      DECLARE @iResult INTEGER
	      DECLARE @tmpAL   INTEGER
	      SET @tmpAL = 2
	      -- Check if any association present at client level
	            IF EXISTS (SELECT * FROM BLEntityMembers WHERE ClientID=@cid AND AssocType=@tmpAL AND AppTypeID=0
	      						AND InstanceID = 0 AND BackupSetID = 0 AND AppID = 0)
	      	     SET @iResult = 1
	            IF (@iResult = 1 AND @tmpAL <= @assoclevel)
	              RETURN @tmpAL
	            -- Check if any association present at IDA level
	            SET @tmpAL = 3
	            IF EXISTS (SELECT * FROM BLEntityMembers WHERE ClientID=@cid AND AssocType=@tmpAL AND AppTypeID=@apptypeid
	      				AND InstanceID = 0 AND BackupSetID = 0 AND AppID = 0)
	      	    SET @iResult = 1
	            IF (@iResult = 1 AND @tmpAL <= @assoclevel)
	              RETURN @tmpAL
	            -- Check if any association present at instance level.
	            SET @tmpAL = 4
	            IF EXISTS (SELECT * FROM BLEntityMembers WHERE ClientID=@cid AND AssocType=@tmpAL AND AppTypeID=@apptypeid
	      						AND InstanceID = @instanceid AND BackupSetID = 0 AND AppID = 0)
	      	      SET @iResult = 1
	      	  IF (@iResult = 1 AND @tmpAL <= @assoclevel)
	              RETURN @tmpAL
	            -- Check if any association present at backupSet  level.
	              SET @tmpAL = 5
	              IF EXISTS (SELECT * FROM BLEntityMembers WHERE ClientID=@cid AND AssocType=@tmpAL AND AppTypeID=@apptypeid
	      						AND InstanceID = @instanceid  AND BackupSetID = @backupid AND AppID = 0)
	      	      SET @iResult = 1
	            IF (@iResult = 1 AND @tmpAL <= @assoclevel)
	              RETURN @tmpAL
	          RETURN 0
	      END
	      GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsBEAssocPresent_QSUtilFN]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsBEAssocPresent_QSUtilFN' AND revision = '')

  insert into GXDBVersions values(5, 'IsBEAssocPresent_QSUtilFN',  '', 'IsBEAssocPresent_QSUtilFN', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientName]
  delete from GXDBVersions where name = 'scgGetClientName' and type = 5
END
GO

	CREATE FUNCTION scgGetClientName(@clientId integer)
	RETURNS NVARCHAR(max)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result nvarchar(max) =  (SELECT name from app_client with(nolock) where id=@clientId)
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientName' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgGetClientName',  '1.2', 'scgGetClientName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientHostName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientHostName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientHostName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientHostName]
  delete from GXDBVersions where name = 'scgGetClientHostName' and type = 5
END
GO

	CREATE FUNCTION scgGetClientHostName(@clientId integer)
	RETURNS NVARCHAR(max)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result nvarchar(max) =  (SELECT net_hostname from app_client with(nolock) where id=@clientId)
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientHostName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientHostName' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgGetClientHostName',  '1.2', 'scgGetClientHostName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientCPUCount.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientCPUCount'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientCPUCount]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientCPUCount]
  delete from GXDBVersions where name = 'scgGetClientCPUCount' and type = 5
END
GO

	CREATE FUNCTION scgGetClientCPUCount(@clientId integer)
	RETURNS integer
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result integer =  ISNULL((SELECT cast(attrVal as integer) from app_clientprop with(nolock) where (attrName='CPU count' and componentNameId=@clientId)), 0)
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientCPUCount]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientCPUCount' AND revision = '1.3')

  insert into GXDBVersions values(5, 'scgGetClientCPUCount',  '1.3', 'scgGetClientCPUCount', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgCompareAppTypes.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgCompareAppTypes'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgCompareAppTypes]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgCompareAppTypes]
  delete from GXDBVersions where name = 'scgCompareAppTypes' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION scgCompareAppTypes(@clientId integer, @operation varchar(8), @Agents XML)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @AppTypes TABLE (
			appTypeId INT PRIMARY KEY
		)
		INSERT INTO @AppTypes
			SELECT ref.value('@appTypeId' , 'INT') appTypeId FROM @Agents.nodes('TMMsg_AppGroupSelection/appTypes') R(ref)
			UNION --ALL
			SELECT
				at.appTypeId
			FROM APP_AppTypeGroupAssoc at WITH(NOLOCK)
				INNER JOIN (SELECT ref.value('@appGroupId' , 'INT') appGroupId FROM @Agents.nodes('TMMsg_AppGroupSelection/appGroups') R(ref)) ag ON
					at.appGroupId = ag.appGroupId
					AND at.typeOfGroup = 0

		DECLARE @return_status INTEGER = 0
		SELECT TOP 1
			@return_status = 1
		FROM
			@AppTypes at
			INNER JOIN APP_IDAName n ON
				n.clientId = @clientId
				AND at.appTypeId = n.appTypeId

		--SELECT @return_status return_status

		DECLARE @result INT = 0
		SELECT
			@result = 1
		WHERE
			((@return_status = 1) AND (@operation = '='))
			OR
			((@return_status != 1) AND (@operation = '!='))

		RETURN @result
	END
	GO
	SET QUOTED_IDENTIFIER OFF
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgCompareAppTypes]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgCompareAppTypes' AND revision = '1.8')

  insert into GXDBVersions values(5, 'scgCompareAppTypes',  '1.8', 'scgCompareAppTypes', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientOSName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientOSName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientOSName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientOSName]
  delete from GXDBVersions where name = 'scgGetClientOSName' and type = 5
END
GO

	CREATE FUNCTION scgGetClientOSName(@clientId integer)
	RETURNS nvarchar(max)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result nvarchar(max) =  ISNULL((SELECT attrVal from app_clientprop with(nolock) where (attrName='Sim OS Info' and componentNameId=@clientId)), '')
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientOSName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientOSName' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgGetClientOSName',  '1.2', 'scgGetClientOSName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientVersion.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientVersion'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientVersion]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientVersion]
  delete from GXDBVersions where name = 'scgGetClientVersion' and type = 5
END
GO

	CREATE FUNCTION scgGetClientVersion(@clientId integer)
	RETURNS nvarchar(max)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result nvarchar(max)


		SET @result = (SELECT releaseId FROM APP_Client where id = @clientId)



		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientVersion]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientVersion' AND revision = '1.4')

  insert into GXDBVersions values(5, 'scgGetClientVersion',  '1.4', 'scgGetClientVersion', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientTimezoneId.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientTimezoneId'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientTimezoneId]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientTimezoneId]
  delete from GXDBVersions where name = 'scgGetClientTimezoneId' and type = 5
END
GO

	CREATE FUNCTION scgGetClientTimezoneId(@clientId integer)
	RETURNS integer
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result integer =  ISNULL((SELECT cast(attrVal as integer) from app_clientprop with(nolock) where (attrName='timezone Id' and componentNameId=@clientId)), 0)
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientTimezoneId]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientTimezoneId' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgGetClientTimezoneId',  '1.2', 'scgGetClientTimezoneId', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientProps.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientProps'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientProps]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientProps]
  delete from GXDBVersions where name = 'scgGetClientProps' and type = 5
END
GO

	CREATE FUNCTION scgGetClientProps(@clientId integer, @operation varchar(8), @clientProp integer )
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result INTEGER = 0
		DECLARE @propTrue	INTEGER = 0
		IF (@clientProp = 1)
		BEGIN
		DECLARE @rstatus INTEGER = 0
		SET @rstatus = (select specialClientFlags from App_Client with(nolock) where id = @clientId)
		IF ((@operation = '=') AND ((@rstatus&2) = 0))
				SET @result=1
		IF ((@operation = '!=') AND ((@rstatus&2) != 0))
				SET @result=1
		END
		IF (@clientProp = 2)
		BEGIN
		IF EXISTS (select * from APP_Client where id=@clientid and (status&0x2)!=2)
			SET @propTrue = 1
		IF ((@operation = '=') AND (@propTrue = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@propTrue != 1))
				SET @result=1
		END
		IF (@clientProp = 3)
		BEGIN
		IF EXISTS (select * from app_clientprop with(nolock) where componentNameId=@clientId and attrName='Virtual Server Discovered Clients' and attrVal='1')
			SET @propTrue = 1
		IF ((@operation = '=') AND (@propTrue = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@propTrue != 1))
				SET @result=1
		END
		IF (@clientProp = 4)
		BEGIN
		IF EXISTS (select * from app_clientprop with(nolock) where componentNameId=@clientId and attrName='Installed 1-Touch Server for Windows' and attrVal='1')
			SET @propTrue = 1
		IF ((@operation = '=') AND (@propTrue = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@propTrue != 1))
				SET @result=1
		END
		IF (@clientProp = 5)
		BEGIN
		IF EXISTS (SELECT clientId FROM MMhost with(nolock)  WHERE clientId = @clientId AND clientId NOT IN (SELECT PMClientId FROM APP_VMToPMMap with(nolock) WHERE VMClientId = 2) AND clientId > 1)
			SET @propTrue = 1
		IF ((@operation = '=') AND (@propTrue = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@propTrue != 1))
				SET @result=1
		END
		IF (@clientProp = 6)
		BEGIN
		IF EXISTS (select * from app_clientprop with(nolock) where componentNameId=@clientId and attrName='Virtual Client' and attrVal='1')
			SET @propTrue = 1
		IF ((@operation = '=') AND (@propTrue = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@propTrue != 1))
				SET @result=1
		END
		IF (@clientProp = 7)
		BEGIN
		DECLARE @cstatus INTEGER = 0
		SET @cstatus = (select status from App_Client with(nolock) where id = @clientId)
		IF (@cstatus = 0) --Check if its present in the Client Properties
		BEGIN
		IF EXISTS (select * from app_clientprop with(nolock) where componentNameId=@clientId and attrName='Personal Workstation' and attrVal = '1')
			SET @cstatus = 1
		END
		IF ((@operation = '=') AND ((@cstatus&0x1000) != 0))
				SET @result=1
		IF ((@operation = '!=') AND ((@cstatus&0x1000) = 0))
				SET @result=1
		END
		IF (@clientProp = 8)
		BEGIN
		DECLARE @isReferenceCopyClient INTEGER = 0
		IF (0x4000000  & (SELECT status FROM APP_Client WHERE id = @clientId)) = 0x4000000
			SET @isReferenceCopyClient = 1
		IF ((@operation = '=') AND (@isReferenceCopyClient = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@isReferenceCopyClient != 1))
				SET @result=1
		END
		IF (@clientProp = 9)
		BEGIN
		DECLARE @isEdgeClient INTEGER = 0
		IF (0x10000000   & (SELECT status FROM APP_Client WHERE id = @clientId)) = 0x10000000
			SET @isEdgeClient = 1
		IF ((@operation = '=') AND (@isEdgeClient = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@isEdgeClient != 1))
				SET @result=1
		END
		IF (@clientProp = 10)
		BEGIN
		DECLARE @simOsId INTEGER = 0
		DECLARE @isNasOs INTEGER = 0
		SET @simOsId = (select simOperatingSystemId from App_Client with(nolock) where id = @clientId)
		IF (SELECT SubType FROM simOperatingSystem WHERE id = @simOsId) = 'NAS'
			SET @isNasOs = 1
		IF ((@operation = '=') AND (@isNasOs = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@isNasOs != 1))
				SET @result=1
		END
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientProps]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientProps' AND revision = '1.17')

  insert into GXDBVersions values(5, 'scgGetClientProps',  '1.17', 'scgGetClientProps', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgCheckClientInGroup.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgCheckClientInGroup'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgCheckClientInGroup]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgCheckClientInGroup]
  delete from GXDBVersions where name = 'scgCheckClientInGroup' and type = 5
END
GO

	CREATE FUNCTION scgCheckClientInGroup(@clientId integer, @operation varchar(8), @compValue integer )
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result INTEGER = 0
		IF EXISTS(select * from dbo.app_clientGroupassoc with(nolock) where clientGroupId=@compValue and clientId=@clientId)
		BEGIN
			IF (@operation = '=')
				SET @result=1
		END
		ELSE
		BEGIN
			IF (@operation = '!=')
				SET @result=1
		END
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgCheckClientInGroup]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgCheckClientInGroup' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgCheckClientInGroup',  '1.2', 'scgCheckClientInGroup', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgClientHasPinnedJob.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgClientHasPinnedJob'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgClientHasPinnedJob]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgClientHasPinnedJob]
  delete from GXDBVersions where name = 'scgClientHasPinnedJob' and type = 5
END
GO

	CREATE FUNCTION scgClientHasPinnedJob(@clientId integer)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result INTEGER = 0
		IF EXISTS (select * from APP_application with(nolock) where (clientId=@clientId) and appTypeid in (SELECT DISTINCT appId FROM JMJobDataStats with(nolock) WHERE (disabled&2 > 0) and (disabled&256 = 0)))
		BEGIN
			SET @result=1
		END
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgClientHasPinnedJob]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgClientHasPinnedJob' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgClientHasPinnedJob',  '1.2', 'scgClientHasPinnedJob', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientOSType.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientOSType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientOSType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientOSType]
  delete from GXDBVersions where name = 'scgGetClientOSType' and type = 5
END
GO

	CREATE FUNCTION scgGetClientOSType(@clientId integer)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result INTEGER = 0
		DECLARE @osType nvarchar(128) = ISNULL((select type From simOperatingSystem with(nolock) where id = (select simOperatingSystemId from app_client with(nolock) where id=@clientId)), '')
		IF (@osType = 'Windows')
			set @result = 1
		IF (@osType = 'Unix')
			set @result = 2
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientOSType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientOSType' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgGetClientOSType',  '1.2', 'scgGetClientOSType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgCheckPackageInstalled.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgCheckPackageInstalled'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgCheckPackageInstalled]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgCheckPackageInstalled]
  delete from GXDBVersions where name = 'scgCheckPackageInstalled' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION scgCheckPackageInstalled(@clientId integer, @operation varchar(8), @packagesXml XML)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @package_exists INTEGER = 0
	DECLARE @packages TABLE (package INTEGER)
	INSERT INTO @packages(package)
	SELECT ref.value('@val' , 'integer')
	FROM @packagesXml.nodes('App_AdvanceKeyInfo/packages') R(ref)
	IF EXISTS ( (select * from @packages) INTERSECT (SELECT simPackageID FROM simInstalledPackages with(nolock) where clientId=@clientId))
		SET @package_exists = 1
	IF (@package_exists = 0)
	BEGIN
		IF EXISTS ((select name from simpackage with(nolock) where id in (select * from @packages)) INTERSECT (SELECT name FROM simpackage with(nolock) where id in (select simPackageid from simInstalledPackages with(nolock) where ClientId=@clientId)))
			SET @package_exists = 1
	END
	DECLARE @result INTEGER = 0
	IF ((@operation = '=') AND (@package_exists= 1))
			SET @result=1
	IF ((@operation = '!=') AND (@package_exists != 1))
			SET @result=1
	return @result
	END
	GO
	SET QUOTED_IDENTIFIER OFF
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgCheckPackageInstalled]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgCheckPackageInstalled' AND revision = '')

  insert into GXDBVersions values(5, 'scgCheckPackageInstalled',  '', 'scgCheckPackageInstalled', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientOfflineDays.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientOfflineDays'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientOfflineDays]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientOfflineDays]
  delete from GXDBVersions where name = 'scgGetClientOfflineDays' and type = 5
END
GO

	CREATE FUNCTION scgGetClientOfflineDays(@clientId integer)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @DaysOffline INTEGER =
		ISNULL((SELECT MAX(CTC.lastOfflineTime)
				 FROM CCRClientToClient CTC WITH(NOLOCK)
				 WHERE CTC.FromClientId = 2 AND CTC.ToClientId = @clientId
					   AND CTC.serviceType=0 AND CTC.lastOfflineTime > CTC.lastOnlineTime), 0)
		IF @DaysOffline > 0
			SET @DaysOffline = (dbo.GetUnixTime(GetUTCDate()) - @DaysOffline)/(24*3600)
		RETURN @DaysOffline
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientOfflineDays]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientOfflineDays' AND revision = '1.3')

  insert into GXDBVersions values(5, 'scgGetClientOfflineDays',  '1.3', 'scgGetClientOfflineDays', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientOnlineDays.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientOnlineDays'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientOnlineDays]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientOnlineDays]
  delete from GXDBVersions where name = 'scgGetClientOnlineDays' and type = 5
END
GO

	CREATE FUNCTION scgGetClientOnlineDays(@clientId integer)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @daysOnline INTEGER =
	ISNULL((SELECT MAX(CTC.lastOnlineTime)
		    FROM   CCRClientToClient CTC WITH(NOLOCK)
            WHERE      CTC.FromClientId = 2 AND CTC.ToClientId = @clientId
				   AND CTC.serviceType=0 AND CTC.lastOfflineTime < CTC.lastOnlineTime), 0)
			IF @daysOnline > 0
				SET @daysOnline = (dbo.GetUnixTime(GetUTCDate()) - @daysOnline)/(24*3600)
			RETURN @daysOnline
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientOnlineDays]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientOnlineDays' AND revision = '')

  insert into GXDBVersions values(5, 'scgGetClientOnlineDays',  '', 'scgGetClientOnlineDays', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgInactiveADUsersAsClientOwner.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgInactiveADUsersAsClientOwner'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgInactiveADUsersAsClientOwner]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgInactiveADUsersAsClientOwner]
  delete from GXDBVersions where name = 'scgInactiveADUsersAsClientOwner' and type = 5
END
GO

	CREATE FUNCTION scgInactiveADUsersAsClientOwner(@clientId integer)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
	    DECLARE @hasInactiveOwner INT = CASE WHEN EXISTS(SELECT objectId
	                                                     FROM   UMUserandGroupEntityAssociation
	                                                     WHERE      (entityType = 2009)
	                                                            AND (userId IN (SELECT id FROM UMusers WHERE  (flags & 4) <> 0 AND umdsPRoviderID <> 0))
	                                                            AND objectId = @clientId ) THEN 1
	                                         ELSE 0 END
	    DECLARE @hasActiveOwner INT = CASE WHEN EXISTS(SELECT objectId
	                                                   FROM   UMUserandGroupEntityAssociation
	                                                   WHERE      (entityType = 2009)
	                                                          AND (userId IN (SELECT id FROM UMusers WHERE  (flags & 4) = 0 OR umdsPRoviderID = 0))
	                                                          AND objectId = @clientId ) THEN 1
	                                       ELSE 0 END
	    RETURN CASE WHEN @hasInactiveOwner = 1 AND @hasActiveOwner = 0 THEN 1 ELSE 0 END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgInactiveADUsersAsClientOwner]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgInactiveADUsersAsClientOwner' AND revision = '')

  insert into GXDBVersions values(5, 'scgInactiveADUsersAsClientOwner',  '', 'scgInactiveADUsersAsClientOwner', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgDaysSinceLastBkpForClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgDaysSinceLastBkpForClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgDaysSinceLastBkpForClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgDaysSinceLastBkpForClient]
  delete from GXDBVersions where name = 'scgDaysSinceLastBkpForClient' and type = 5
END
GO

	CREATE FUNCTION scgDaysSinceLastBkpForClient(@clientId integer)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
	    -- job status constants declare in /vaultcx/Source/Include/JobManager/cvjob.h
	    DECLARE @statusSuccess INT = 1          -- JMSUCCESS
	    DECLARE @statusPartialSuccess INT = 3   -- PARTIALSUCCESS
	    DECLARE @lastBackupForClient INTEGER = ISNULL(
	        (SELECT  MAX(servStartDate)
	         FROM    JMBkpStats BS WITH(NOLOCK) INNER JOIN APP_Application APP WITH(NOLOCK) ON APP.id = BS.appId
	         WHERE       APP.clientId = @clientId
	                 AND BS.status IN (@statusSuccess, @statusPartialSuccess)), 0)
	    RETURN CASE WHEN @lastBackupForClient = 0 THEN 2147483647
	                ELSE (dbo.GetUnixTime(GetUTCDate()) - @lastBackupForClient)/(24*3600)
	           END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgDaysSinceLastBkpForClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgDaysSinceLastBkpForClient' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgDaysSinceLastBkpForClient',  '1.2', 'scgDaysSinceLastBkpForClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgDaysSinceClientCreated.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgDaysSinceClientCreated'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgDaysSinceClientCreated]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgDaysSinceClientCreated]
  delete from GXDBVersions where name = 'scgDaysSinceClientCreated' and type = 5
END
GO

	CREATE FUNCTION scgDaysSinceClientCreated(@clientId integer)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
	    -- refTime gets populated on client creation
	    DECLARE @clientCreatedDate INTEGER = ISNULL((SELECT refTime FROM APP_Client WHERE id = @clientId), 0)
	    -- in some cases (for example, for CS itself) refTime is not set. Then try to figure out when the very first package was installed
	    -- for the client
	    IF @clientCreatedDate = 0 BEGIN
	        SET @clientCreatedDate  = dbo.GetUnixTime((SELECT Min(OpTime) FROM simInstalledPackagesHistory WHERE ClientId = @clientId))
	    END
	    -- return number of days since then
	    RETURN CASE WHEN @clientCreatedDate = 0 THEN 2147483647
	                ELSE (dbo.GetUnixTime(GetUTCDate()) - @clientCreatedDate)/(24*3600)
	           END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgDaysSinceClientCreated]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgDaysSinceClientCreated' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgDaysSinceClientCreated',  '1.2', 'scgDaysSinceClientCreated', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgClientActsAsProxy.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgClientActsAsProxy'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgClientActsAsProxy]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgClientActsAsProxy]
  delete from GXDBVersions where name = 'scgClientActsAsProxy' and type = 5
END
GO

	CREATE FUNCTION scgClientActsAsProxy(@clientId integer)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
	    RETURN ISNULL((SELECT TOP 1 isDMZ FROM APP_FirewallOptions WHERE clientId = @clientId ORDER BY id DESC), 0)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgClientActsAsProxy]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgClientActsAsProxy' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgClientActsAsProxy',  '1.2', 'scgClientActsAsProxy', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgBackupActivityForClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgBackupActivityForClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgBackupActivityForClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgBackupActivityForClient]
  delete from GXDBVersions where name = 'scgBackupActivityForClient' and type = 5
END
GO

	CREATE FUNCTION scgBackupActivityForClient(@clientId integer)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
        -- CVOpType::BACKUP. Definition can be found at vaultcx/Source/Include/CvConstDef.h#144
        DECLARE @operationType INT = 4
	    RETURN CASE WHEN ISNULL((SELECT action & 0x2 FROM JMJobAction WHERE clientId = @clientId AND appType = 0 AND opType = @operationType), 0) = 0 THEN 0
                    ELSE 1
               END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgBackupActivityForClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgBackupActivityForClient' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgBackupActivityForClient',  '1.2', 'scgBackupActivityForClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgRestoreActivityForClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgRestoreActivityForClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgRestoreActivityForClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgRestoreActivityForClient]
  delete from GXDBVersions where name = 'scgRestoreActivityForClient' and type = 5
END
GO

	CREATE FUNCTION scgRestoreActivityForClient(@clientId integer)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
        -- CVOpType::RESTORE. Definition can be found at vaultcx/Source/Include/CvConstDef.h#144
        DECLARE @operationType INT = 5
	    RETURN CASE WHEN ISNULL((SELECT action & 0x2 FROM JMJobAction WHERE clientId = @clientId AND appType = 0 AND opType = @operationType), 0) = 0 THEN 0
                    ELSE 1
               END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgRestoreActivityForClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgRestoreActivityForClient' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgRestoreActivityForClient',  '1.2', 'scgRestoreActivityForClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgClientExcludedFromSLAReport.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgClientExcludedFromSLAReport'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgClientExcludedFromSLAReport]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgClientExcludedFromSLAReport]
  delete from GXDBVersions where name = 'scgClientExcludedFromSLAReport' and type = 5
END
GO

	CREATE FUNCTION scgClientExcludedFromSLAReport(@clientId integer)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
	    RETURN CASE WHEN ISNULL((SELECT CL.name AS 'Excluded Client Name'
	                             FROM   APP_Client CL INNER JOIN APP_ClientProp CP ON CL.id = CP.componentNameId
	                             WHERE      CP.attrName = 'Exclude From SLA' AND CP.attrVal = '1' AND CP.modified = 0
	                                    AND CL.id = @clientId), 0) = 0 THEN 0
	                ELSE 1 END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgClientExcludedFromSLAReport]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgClientExcludedFromSLAReport' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgClientExcludedFromSLAReport',  '1.2', 'scgClientExcludedFromSLAReport', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgIntellisnapClients.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgIntellisnapClients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgIntellisnapClients]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgIntellisnapClients]
  delete from GXDBVersions where name = 'scgIntellisnapClients' and type = 5
END
GO

	CREATE FUNCTION scgIntellisnapClients(@clientid INTEGER)
	RETURNS INTEGER
	WITH ENCRYPTION
	BEGIN
	    RETURN CASE WHEN EXISTS (SELECT CL.id FROM APP_Client CL (NOLOCK) WHERE  CL.id = @clientId AND LOWER(dbo.IsClientSnapEnabled(CL.id)) = 'yes'
	                             UNION
	                             SELECT DISTINCT VOL.SourceClientId FROM SMVolume VOL (NOLOCK) WHERE VOL.SourceClientId = @clientId) THEN 1
	                ELSE 0
	           END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgIntellisnapClients]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgIntellisnapClients' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgIntellisnapClients',  '1.2', 'scgIntellisnapClients', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgClientsWithAttachedStorage.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgClientsWithAttachedStorage'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgClientsWithAttachedStorage]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgClientsWithAttachedStorage]
  delete from GXDBVersions where name = 'scgClientsWithAttachedStorage' and type = 5
END
GO

	CREATE FUNCTION scgClientsWithAttachedStorage(@clientid INTEGER)
	RETURNS INTEGER
	WITH ENCRYPTION
	BEGIN
	    RETURN CASE WHEN EXISTS (SELECT  *
	                             FROM    APP_Client CL WITH(NOLOCK)
	                             WHERE       CL.id = @clientId
	                                     AND (CL.id IN (SELECT distinct clientId FROM MMLibraryController WITH (NOLOCK)) OR
	                                          CL.Id IN (SELECT distinct clientId FROM MMDrivepool WITH (NOLOCK)))) THEN 1
	                ELSE 0
	           END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgClientsWithAttachedStorage]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgClientsWithAttachedStorage' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgClientsWithAttachedStorage',  '1.2', 'scgClientsWithAttachedStorage', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgCaseManagerHoldClients.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgCaseManagerHoldClients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgCaseManagerHoldClients]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgCaseManagerHoldClients]
  delete from GXDBVersions where name = 'scgCaseManagerHoldClients' and type = 5
END
GO

	CREATE FUNCTION scgCaseManagerHoldClients(@clientid INTEGER)
	RETURNS INTEGER
	WITH ENCRYPTION
	BEGIN
	    RETURN CASE WHEN EXISTS (SELECT  DISTINCT APP.clientId FROM JMReferenceCopy (NOLOCK) REF, App_Application (NOLOCK) APP
	                             WHERE       REF.refAppId IN (SELECT id FROM App_Application(NOLOCK) WHERE clientId IN(SELECT RefCopyClientId FROM DM2CaseInfo (NOLOCK)))
	                                     AND REF.srcAppId = APP.id
	                                     AND APP.clientId = @clientId) THEN 1
	                ELSE 0
	           END
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgCaseManagerHoldClients]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgCaseManagerHoldClients' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgCaseManagerHoldClients',  '1.2', 'scgCaseManagerHoldClients', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgMediaAgentsInGroup.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgMediaAgentsInGroup'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgMediaAgentsInGroup]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgMediaAgentsInGroup]
  delete from GXDBVersions where name = 'scgMediaAgentsInGroup' and type = 5
END
GO

	CREATE FUNCTION scgMediaAgentsInGroup(@clientid INTEGER, @operation NVARCHAR(10), @groupPattern NVARCHAR(1024))
	RETURNS INTEGER
	WITH ENCRYPTION
	BEGIN
	    DECLARE @rv INTEGER = 0
	    IF @operation = 'E_WITH'                        BEGIN SET @groupPattern = '%' + @groupPattern END
	    IF @operation = 'S_WITH'                        BEGIN SET @groupPattern = @groupPattern + '%' END
	    IF @operation = 'LIKE' OR @operation = 'N_LIKE' BEGIN SET @groupPattern = '%' + @groupPattern + '%' END
	    -- at the very beginnig verify that client is MA. if client is not MA then it should not be included in group
	    IF EXISTS (SELECT * FROM MMHost WHERE ClientId = @clientid) BEGIN
	        -- get list of groups to be considered
	        DECLARE @temp_Groups TABLE (groupId INTEGER)
	        INSERT INTO @temp_Groups
	            SELECT DISTINCT id FROM APP_ClientGroup WHERE name LIKE @groupPattern ORDER BY id
	        -- for each group verify if client belongs to it
	        DECLARE @currentGroupId INT = (SELECT TOP 1 groupId FROM @temp_Groups ORDER BY groupId)
	        WHILE (@currentGroupId IS NOT NULL) AND @rv = 0 BEGIN
	            -- check if client belongs to a group
	            IF EXISTS (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientGroupId = @currentGroupId AND clientId = @clientid) BEGIN
	                IF (@operation != 'N_LIKE') AND (@operation != '!=') BEGIN
	                    SET @rv = 1
	                END
	            END ELSE BEGIN
	                IF (@operation = 'N_LIKE') OR (@operation = '!=') BEGIN
	                    SET @rv = 1
	                END
	            END
	            -- get next group
	            SET @currentGroupId = (SELECT TOP 1 groupId FROM @temp_Groups WHERE groupId > @currentGroupId ORDER BY groupId)
	        END
	    END
	    RETURN @rv
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgMediaAgentsInGroup]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgMediaAgentsInGroup' AND revision = '1.2')

  insert into GXDBVersions values(5, 'scgMediaAgentsInGroup',  '1.2', 'scgMediaAgentsInGroup', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientName]
  delete from GXDBVersions where name = 'GetClientName' and type = 5
END
GO

	CREATE FUNCTION GetClientName (@clientId INT)
	RETURNS NVARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
    DECLARE @clientName NVARCHAR(255) = (SELECT name FROM APP_Client WHERE ID = @clientId)
	RETURN @clientName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientName' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetClientName',  '1.4', 'GetClientName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/archUncopiedMediaFn.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: archUncopiedMediaFn'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[archUncopiedMediaFn]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[archUncopiedMediaFn]
  delete from GXDBVersions where name = 'archUncopiedMediaFn' and type = 5
END
GO

    	CREATE FUNCTION archUncopiedMediaFn(
    		@i_spId		INTEGER,
    		@i_copyId	INTEGER
    	)
    	RETURNS @STORAGE_SrcMediaInfoTbl TABLE (
    		PolicyId			INTEGER,
    		PolicyName			NVARCHAR(288),
    		CopyId				INTEGER,
    		CopyName			NVARCHAR(288),
    		TargetStream		INTEGER,
    		Media				NVARCHAR(288),
    		Library				NVARCHAR(288),
    		Location			NVARCHAR(1024),
    		UnCopiedData		BIGINT
    	)
    	AS
    	BEGIN

    		DECLARE @defCopyId  integer

    		IF @i_spId = 0
    		   SET @i_spId = (SELECT archGroupId FROM archGroupCopy WITH (NOLOCK) WHERE id = @i_copyId)

    		SET @defCopyId = (SELECT defaultCopy FROM archGroup WITH (NOLOCK) WHERE id = @i_spId)

    		DECLARE @tblAFC TABLE (
    			archFileId int, commCellId int, archCopyId int,
    			isValid int, streamNum int, physicalSize bigint,
    			sourceCopyId int, srcIsValid int, srcStreamNum int, srcPhysicalSize bigint,
    			primary key (archFileId, commCellId, archCopyId))

    		DECLARE @tblChunk TABLE (
    			archCopyId int, streamNum int, volumeId int,
    			archChunkId bigint, commCellId int, copiedBytes bigint, uncopiedBytes bigint)

    		DECLARE @tblVolume TABLE (
    			commCellId int, archCopyId int, streamNum int, volumeId int, volumeName varchar(112),
    			mediaId int, mediaSideId int, CreationTime int, SIDBStoreId int, SiloStatus int,
    			firstChunkId bigint, copiedBytes bigint, uncopiedBytes bigint)

    		DECLARE @tblMedia TABLE (
    			MediaId int, MountPathId int, MountPathName varchar(1024), MountPathTypeId int)

    		DECLARE @tblMediaLocation TABLE (
    			mediaId int, uniqueId varchar(300), barCode varchar(256), mediaTypeId int, attributes int,
    			libraryId int, locationType int, locationId int, location nvarchar(1024))


    		INSERT INTO @tblAFC
    		SELECT	A.id, A.commCellId, B.archGrpCopyId, 0, 0, 0, B.sourceCopyId, 0, 0, 0
    		FROM	archFile A WITH (NOLOCK),
    				(SELECT T.*
    				FROM	JMJobDataStats J WITH (NOLOCK),
    						(SELECT	JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpId, JDS.archGrpCopyId, AGC.sourceCopyId
    						FROM	JMJobDataStats JDS WITH (NOLOCK),
    								(SELECT id AS destCopyId, (case sourceCopyId when 0 then @defCopyId else sourceCopyId end) AS sourceCopyId
    								FROM	archGroupCopy WITH (NOLOCK)
    								WHERE	(@i_copyId <= 0 OR (@i_copyId = @defCopyId AND sourceCopyId = 0) OR id = @i_copyId)
    									AND id <> @defCopyId AND archGroupId = @i_spId AND isActive = 1) AGC
    						WHERE	JDS.archGrpCopyId = AGC.destCopyId AND JDS.status IN (101, 102, 103)
    								AND (JDS.disabled & (1 + 256)) = 0) T
    				WHERE	J.jobId = T.jobId
    					AND J.archGrpCopyId = T.sourceCopyId
    					AND J.dataType = T.dataType
    					AND J.commCellId = T.commCellId
    					AND J.status = 100 AND (J.disabled & (1 + 256)) = 0) B
    		WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
    				AND A.fileType = B.dataType AND A.archGroupId = B.archGrpId AND A.isValid = 1

    		UPDATE	@tblAFC SET srcIsValid= B.isValid, srcStreamNum = B.streamNum, srcPhysicalSize = B.physicalSize
    		FROM	@tblAFC A, archFileCopy B WITH (NOLOCK)
    		WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.sourceCopyId = B.archCopyId

    		UPDATE	@tblAFC SET isValid = B.isValid, streamNum = B.streamNum, physicalSize = B.physicalSize
    		FROM	@tblAFC A, archFileCopy B WITH (NOLOCK)
    		WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.archCopyId = B.archCopyId

    		DELETE	@tblAFC
    		WHERE	isValid = 1 OR srcIsValid <> 1 OR physicalSize = srcPhysicalSize

    		UPDATE	@tblAFC
    		SET		streamNum = (case (B.flags & 4)
    							when 0 then A.srcStreamNum
    							else (1 + (A.srcStreamNum - 1)%B.maxStreamNum) end)
    		FROM	@tblAFC A, archGroupCopy B WITH (NOLOCK)
    		WHERE	A.streamNum = 0 AND A.archCopyId = B.id

    		INSERT INTO @tblChunk
    		SELECT	AFC.archCopyId, AFC.streamNum, 0, ACM.archChunkId, ACM.chunkCommCellId,
    				MAX(AFC.physicalSize - ACM.physicalOffset),
    				SUM(case when (AFC.physicalSize - ACM.physicalOffset) > 0 then (AFC.physicalSize - ACM.physicalOffset) else ACM.physicalSize end)
    		FROM	@tblAFC AFC, archChunkMapping ACM WITH (NOLOCK)
    		WHERE	ACM.archFileId = AFC.archFileId AND ACM.commCellId = AFC.commCellId AND ACM.archCopyId = AFC.sourceCopyId
    				AND ACM.physicalSize > (AFC.physicalSize - ACM.physicalOffset)
    		GROUP BY AFC.archCopyId, AFC.streamNum, ACM.archChunkId, ACM.chunkCommCellId

    		UPDATE	@tblChunk SET volumeId = AC.volumeId
    		FROM	@tblChunk T, archChunk AC WITH (NOLOCK)
    		WHERE	AC.id = T.archChunkId AND AC.commCellId = T.commCellId

    		INSERT INTO @tblVolume
    		SELECT	T.commCellId, T.archCopyId, T.streamNum, V.VolumeId, V.VolumeName,
    				V.MediaId, V.MediaSideId, V.CreationTime, V.SIDBStoreId, V.SiloStatus,
    				T.firstChunkId, T.copiedBytes, T.uncopiedBytes
    		FROM 	(SELECT	commCellId, archCopyId, streamNum, volumeId,
    						MIN(archChunkId) AS firstChunkId, MAX(copiedBytes) AS copiedBytes, SUM(uncopiedBytes) AS uncopiedBytes
    				FROM	@tblChunk
    				GROUP BY commCellId, archCopyId, streamNum, volumeId) T, MMVolume V WITH (NOLOCK)
    		WHERE	T.volumeId = V.VolumeId


    		-- Get media for SILO Restore
    		DECLARE	@SiloVol TABLE (CopyId INT, VolumeId INT, SIDBStoreId INT, CreationTime INT)

    		INSERT	INTO @SiloVol
    		SELECT	0, 0, SIDBStoreId, MAX(CreationTime)
    		FROM	@tblVolume
    		WHERE	SIDBStoreId > 0 AND SiloStatus = 3 /*SILO_VOLUME_MIGRATED_OFFDISK*/
    		GROUP BY SIDBStoreId

    		IF @@ROWCOUNT > 0
    		BEGIN
    			EXEC archMediaForSiloViatable 0, 0

    			INSERT	INTO @tblVolume
    			SELECT	V.origCCcommCellId, S.archGroupCopyId, S.stream, V.VolumeId, V.VolumeName,
    					V.MediaId, V.MediaSideId, V.CreationTime, V.SIDBStoreId, V.SiloStatus,
    					0, 0, 0
    			FROM	@SiloVol T, MMVolume V WITH (READUNCOMMITTED), archStream S WITH (READUNCOMMITTED)
    			WHERE	T.VolumeId = V.VolumeId AND T.VolumeId > 0
    				AND S.mediaGroupId = V.MediaGroupId
    		END

    		INSERT INTO @tblMedia
    		SELECT	a.MediaId, ISNULL(b.MountPathId, 0), ISNULL(b.MountPathName, ''), ISNULL(b.MountPathTypeId, 0)
    		FROM	(SELECT	DISTINCT MediaId, MediaSideId FROM @tblVolume) AS a
    				LEFT OUTER JOIN MMS2getMountPathNameGUIView AS b ON a.MediaSideId = b.MediaSideId

    		INSERT INTO @tblMediaLocation
    		SELECT	DISTINCT M.MediaId, M.UniqueId, M.BarCode, M.MediaTypeId, M.Attributes, M.LibraryId, M.MediaLocation,

    				(case M.MediaTypeId
    				when 10001 then MP.MountPathId
    				else (case M.MediaLocation
    					when 1 then (SELECT SlotId  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
    					when 2 then (SELECT DriveId FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
    					else M.ExportLocationId
    					end)
    				end),

    				(case M.MediaTypeId
    				when 10001 then MP.MountPathName
    				else
    					(case M.MediaLocation
    					when 1 then (SELECT SlotName  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = M.MediaId)
    					when 2 then (SELECT AliasName FROM MMDrive WITH (NOLOCK) WHERE MediaId = M.MediaId)
    					else ISNULL((SELECT ExportLocation FROM MMExportLocation WHERE ExportLocationId = M.ExportLocationId), '') end)
    				end)

    		FROM	@tblMedia AS MP, MMMedia AS M WITH (NOLOCK)
    		WHERE	M.MediaId = MP.MediaId

    		INSERT INTO @STORAGE_SrcMediaInfoTbl
    		SELECT	@i_spId, (SELECT name FROM archGroup WITH (NOLOCK) WHERE id = @i_spId),
    				M.archCopyId, (SELECT name FROM archGroupCopy WITH (NOLOCK) WHERE id = M.archCopyId), M.streamNum,
    				(case when ML.mediaTypeId = 10001 then M.VolumeName else ML.barCode end),
    				(SELECT AliasName FROM MMLibrary WHERE LibraryId = ML.libraryId), ML.location, M.uncopiedBytes
    		FROM 	@tblVolume M, @tblMediaLocation ML
    		WHERE	M.MediaId = ML.MediaId
    		ORDER BY M.archCopyId, M.streamNum, M.commCellId, M.copiedBytes DESC, M.firstChunkId

    		RETURN
    	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [archUncopiedMediaFn]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'archUncopiedMediaFn' AND revision = '1.2')

  insert into GXDBVersions values(5, 'archUncopiedMediaFn',  '1.2', 'archUncopiedMediaFn', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientEncryption.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientEncryption'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientEncryption]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientEncryption]
  delete from GXDBVersions where name = 'GetClientEncryption' and type = 5
END
GO

	CREATE FUNCTION GetClientEncryption(@clientId integer)
	RETURNS VARCHAR(100)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result VARCHAR(100) = 'No'
		IF EXISTS (select attrname from App_ClientProp where attrName = 'Encrypt: encryption' and attrVal = 1 and componentNameId = @clientId)
		BEGIN
			SET @result='Yes'
		END
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientEncryption]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientEncryption' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetClientEncryption',  '1.1', 'GetClientEncryption', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientSP.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientSP'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientSP]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientSP]
  delete from GXDBVersions where name = 'GetClientSP' and type = 5
END
GO

	CREATE FUNCTION GetClientSP(@clientId integer)
	RETURNS VARCHAR(100)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @spTable table ( sp nvarchar(1000))
		DECLARE @spstr nvarchar(1000) = ''
		insert into @spTable
		select distinct sp.name
		from archGroup sp, APP_Application APP
   		where APP.clientId  = @clientId and ( sp.id = APP.dataArchGrpID or sp.id = APP.logArchGrpID) and sp.id <> 1
		select  @spstr = @spstr + COALESCE(sp+',','')
        from @spTable
        order by sp

		IF @spstr <> ''
			SET @spstr = SUBSTRING(@spstr,0,LEN(@spstr))
		RETURN @spstr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientSP]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientSP' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetClientSP',  '1.1', 'GetClientSP', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientOneTouch.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientOneTouch'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientOneTouch]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientOneTouch]
  delete from GXDBVersions where name = 'GetClientOneTouch' and type = 5
END
GO

	CREATE FUNCTION GetClientOneTouch(@clientId integer)
	RETURNS VARCHAR(100)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result VARCHAR(100) = 'No'
		IF EXISTS (SELECT subclientStatus from APP_Application where (subclientStatus & 0x0100 = 0x0100) and clientId = @clientId)
		BEGIN
			SET @result='Yes'
		END
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientOneTouch]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientOneTouch' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetClientOneTouch',  '1.1', 'GetClientOneTouch', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/BackupSummaryFn.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: BackupSummaryFn'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BackupSummaryFn]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BackupSummaryFn]
  delete from GXDBVersions where name = 'BackupSummaryFn' and type = 5
END
GO

	CREATE FUNCTION BackupSummaryFn (
		@treeSelection XML,
		@reportParameters XML,
		@localeId INTEGER,
		@userId	INTEGER,
		@request XML
	)
	RETURNS @bkpJobList	TABLE (
		JobType							INTEGER,		--Use Enum
		ClientId						INTEGER,
		ClientName						NVARCHAR(510),
		AgentTypeId						INTEGER,
		AgentName						VARCHAR(510),
		InstanceId						INTEGER,
		InstanceName					NVARCHAR(1024),
		BackupSetId						INTEGER,
		BackupSetName					NVARCHAR(256),
		SubClientId						INTEGER,
		SubClientName					NVARCHAR(256),
		StoragePolicyId					INTEGER,
		StoragePolicyName				NVARCHAR(510),
		JobId							INTEGER,
		CommcellId						INTEGER,
		CommcellName					NVARCHAR(512),
		Status							INTEGER,
		ScheduleInitiated				INTEGER,
		SubTaskName						NVARCHAR(512),
		TaskName						NVARCHAR(512),
		BackupLevel						INTEGER,
		ScanType						INTEGER,		--Use enum
		StartTime						DATETIME,
		WriteStartTime					DATETIME,
		EndTime							DATETIME,
		WriteEndTime					DATETIME,
		CurrentPhase					VARCHAR(128),
		ApplicationSize					BIGINT,
		CompressionRatePct				FLOAT,
		NwTransBytes					BIGINT,
		SizeOnMedia						BIGINT,
		SpaceSavingsPct					INTEGER,
		DataSizeChange					FLOAT,
		TransferTime					INTEGER,		--Duration
		CurrentTransferTime				INTEGER,		--Duration
		ThroughputGB					FLOAT,
		CurrentThroughputGB				FLOAT,
		ThroughputMB					FLOAT,
		CurrentThroughputMB				FLOAT,
		ProtectedObjects				BIGINT,
		FailedFiles						BIGINT,
		FailedFolders					BIGINT,
		QRDestination					NVARCHAR(510),
		AssociatedMedia					NVARCHAR(510),
		Drive							NVARCHAR(510),
		MediaAgent						NVARCHAR(510),
		ClientGroup						NVARCHAR(510),
		UserName						NVARCHAR(1024),
		RetainedUntil					DATETIME,
		RetainedBy						INTEGER,		--Use enum (Basic/Extended/NA)
		IsAged							INTEGER,		--Use enum (Yes/No/NA)
		IsMediaDeleted					INTEGER,		--Use enum (Yes/No/NA)
		IsBackupCopyJob					INTEGER,		--Use enum (Yes/No/NA)
		IsSnapBackup					INTEGER,		--Use enum (Yes/No/NA)
		IsPerformanceJob				INTEGER,		--Use enum (Yes/No/NA)
		QROperationType					INTEGER,		--Use enum (Incremental Update/Snapshot/Quick Recovery Agent Volume Creation/NA
		ScanTypeChangeReason			NVARCHAR(MAX),
		FailureReason					NVARCHAR(MAX),
		JobDesc							NVARCHAR(4000),
		ClientDesc						NVARCHAR(4000),
		AgentDesc						NVARCHAR(4000),
		BackupSetDesc					NVARCHAR(4000),
		InstanceDesc					NVARCHAR(4000),
		SubClientDesc					NVARCHAR(4000),
		Events							NVARCHAR(MAX),
		JobAttempts						NVARCHAR(MAX),

		SCContentFilters				NVARCHAR(MAX),
		ProtectedObjectsList			NVARCHAR(MAX),
		FailedObjectsList				NVARCHAR(MAX),
		ContentIndexingFailures			NVARCHAR(MAX),
		StubbedFilesList				NVARCHAR(MAX),
		LogDetails						NVARCHAR(MAX),
		JobDetails						NVARCHAR(MAX)
	)
	AS
	BEGIN
		DECLARE @MAXINT	integer
		SET	@MAXINT	= 0x7FFFFFFF

		DECLARE @startTime		integer
		DECLARE @endTime		integer
		DECLARE @rangetype		integer

		DECLARE @isAssocMediaSelected	INTEGER
		DECLARE @isClientGroupSelected	INTEGER
		DECLARE @RetainedUntilSelected	INTEGER
		DECLARE @RetainedBySelected		INTEGER
		DECLARE @AssocEventsSelected	INTEGER
		DECLARE @JobAttemptsSelected	INTEGER

		SET @isAssocMediaSelected	= (SELECT COUNT(*) FROM @request.nodes('/SelectClause/SC_Cell') item(c) WHERE	ISNULL(item.c.value('./@id', 'INT'),0) = 251658418)
		SET @isClientGroupSelected	= (SELECT COUNT(*) FROM @request.nodes('/SelectClause/SC_Cell') item(c) WHERE	ISNULL(item.c.value('./@id', 'INT'),0) = 251658421)
		SET @RetainedUntilSelected	= (SELECT COUNT(*) FROM @request.nodes('/SelectClause/SC_Cell') item(c) WHERE	ISNULL(item.c.value('./@id', 'INT'),0) = 251658423)
		SET @RetainedBySelected		= (SELECT COUNT(*) FROM @request.nodes('/SelectClause/SC_Cell') item(c) WHERE	ISNULL(item.c.value('./@id', 'INT'),0) = 251658424)
		SET @AssocEventsSelected	= (SELECT COUNT(*) FROM @request.nodes('/SelectClause/SC_Cell') item(c) WHERE	ISNULL(item.c.value('./@id', 'INT'),0) = 251658439)
		SET @JobAttemptsSelected	= (SELECT COUNT(*) FROM @request.nodes('/SelectClause/SC_Cell') item(c) WHERE	ISNULL(item.c.value('./@id', 'INT'),0) = 251658440)

		SET @startTime = 0
		SET @endTime = 0
		SELECT @startTime = dbo.GetUnixTime(ISNULL(item.c.value('./@value', 'DATETIME'), dbo.GetDateTime(0)))
			FROM @reportParameters.nodes('/Parameters/PC_Cell') item(c)
			WHERE ISNULL(item.c.value('./@type', 'INT'),0) = 7
		SELECT @endTime = dbo.GetUnixTime(ISNULL(item.c.value('./@value', 'DATETIME'), dbo.GetDateTime(0)))
			FROM @reportParameters.nodes('/Parameters/PC_Cell') item(c)
			WHERE ISNULL(item.c.value('./@type', 'INT'),0) = 8

		DECLARE @tblApplication		TABLE (id INT, clientId INT, appTypeId INT, instance INT, subclientStatus INT, dataArchGrpId INT, logArchGrpId INT)
		DECLARE @selectedIds TABLE (id INT)

		IF EXISTS ( SELECT item.c.value('./@_type_', 'INT')
						FROM @treeSelection.nodes('/TreeSelections/subclientFilterList') item(c))
		BEGIN
			INSERT	INTO @selectedIds(id)
			SELECT	* FROM dbo.GetSelectedSubClients(@treeSelection)

			INSERT	INTO @tblApplication
			SELECT	DISTINCT A.id, clientId, appTypeId, instance, subClientStatus, dataArchGrpID, logArchGrpID
			FROM	APP_Application A, @selectedIds S
			WHERE	A.id = S.id
		END
		ELSE IF EXISTS ( SELECT item.c.value('./@clientGroupId', 'INT')
						FROM @treeSelection.nodes('/TreeSelections/Items') item(c)
						WHERE	ISNULL(item.c.value('./@clientGroupId', 'INT'),0) = 0)
		BEGIN
			INSERT INTO @selectedIds(id)
			SELECT	item.c.value('./@clientId', 'int') as id
			FROM @treeSelection.nodes('/TreeSelections/Items') item(c)

			INSERT	INTO @tblApplication
			SELECT	DISTINCT A.id, clientId, appTypeId, instance, subClientStatus, dataArchGrpID, logArchGrpID
			FROM	APP_Application A, @selectedIds S
			WHERE	A.clientId = S.id OR S.id = -1
		END
		ELSE IF EXISTS ( SELECT item.c.value('./@clientGroupId', 'INT')
						FROM @treeSelection.nodes('/TreeSelections/Items') item(c)
						WHERE	ISNULL(item.c.value('./@clientGroupId', 'INT'),0) <> 0)
		BEGIN
			INSERT	INTO @selectedIds(id)
			SELECT	item.c.value('./@clientGroupId', 'int') as id
			FROM	@treeSelection.nodes('/TreeSelections/Items') item(c)

			INSERT	INTO @tblApplication
			SELECT	DISTINCT A.id, A.clientId, appTypeId, instance, subClientStatus, dataArchGrpId, logArchGrpId
			FROM	APP_Application A, APP_ClientGroupAssoc CG, @selectedIds S
			WHERE	(A.clientId = CG.clientId AND CG.clientGroupId = S.id) OR S.id = -1
		END

		DELETE FROM @selectedIds
		IF EXISTS ( SELECT	item.c.value('./@include', 'INT')
						FROM	@treeSelection.nodes('/TreeSelections/agentList/flags') item(c)
						WHERE	item.c.value('./@include', 'INT') = 1)
		BEGIN
			INSERT	INTO @selectedIds(id)
			SELECT	DISTINCT apptypeId FROM APP_IDAName
		END
		ELSE
		BEGIN
			INSERT	INTO @selectedIds(id)
			SELECT	item.c.value('./@applicationId', 'INT') as id
			FROM	@treeSelection.nodes('/TreeSelections/agentList') item(c)
		END
		IF NOT EXISTS ( SELECT item.c.value('./@_type_', 'INT')
						FROM @treeSelection.nodes('/TreeSelections/subclientFilterList') item(c))
			DELETE	FROM @tblApplication
			WHERE	appTypeId NOT IN (SELECT DISTINCT id FROM @selectedIds)

		DECLARE @descTbl			TABLE (cJobid INT, cellId INT, cJobDesc nvarchar(MAX), xJobInfo nvarchar(MAX))


		DECLARE @BKPXT TABLE(
			ccId	INT,
			jobId	INT,
			optype	INT,
			clId	INT,
			appId	INT,
			appType	INT,
			bLevel	INT,
			status	INT,
			state	INT,
			startT	INT,
			endT	INT,
			duration INT,
			cPhase	INT,
			objects	BIGINT,
			uncompSize	BIGINT,
			bTime	INT,
			initF	INT,
			failIds	varchar(512),
			failR	ntext,
			sFl	INT,
			sFd	INT,
			bFl	INT,
			bFd	INT,
			options	INT,
			attributes	BIGINT,
			userName	nvarchar(1024),
			archGrp	INT,
			logArchGrp INT,
			wST 	INT,
			wET 	INT,
			failError	INT,
			cIdx	BIGINT	default(0),
			scanType	INT	default(0),
			scanChangeReason	varchar(1024) default(''),
			compSize	BIGINT,
			bkpSize	BIGINT,
			percChange	INT,
			jobDescription nvarchar(MAX) default(N''),
			xmlJobInfo nvarchar(MAX) default(N''),
			snapJobId	INT,
			snapJobStatus	INT,
			dataStatus		INT,
			agedTime		INT,
			transferredDataSize BIGINT default(-1),
			sizeOnMedia		BIGINT,
			t_subTaskId		INT
		)


		INSERT INTO @BKPXT
		SELECT 2, J.jobId, J.optype, A.clientId, A.id, appTypeId, bkpLevel, 0, state, jobStartTime, lastStartOrRun, jobElapsedTime, currentPhase, filesXfered, uncompbytes,
			isnull((select sum(writeTime) from JMBkpAttemptInfo WITH (READUNCOMMITTED) where JMBkpAttemptInfo.jobId=J.jobId), 0)+isnull((select max(writeTime) from JMJobStreams WITH (READUNCOMMITTED) where jobId=J.jobId), 0),
			initFrom, failureReason, dbo.JMGetLocalizedMessageFunc(@localeId, failureReason), scanFileFailures, scanFolderFailures, backupFileFailures,
			backupFolderFailures, bkpOptions, bkpAttributes,
			(select login from UMUsers where id=userId), currentPolicy, 0, 0, 0, 0, 0, scanType, scanTypeChangeReason, compbytes, compbytes, 0, J.jobDescription, J.xmlJobInfo, 0, 0, -1, -1, -1, 0, B.backupTaskId
		FROM	JMJobInfo J WITH (READUNCOMMITTED), JMBkpJobInfo B WITH (READUNCOMMITTED), @tblApplication A
		WHERE	J.commcellId=B.commcellId and J.jobId=B.jobId and applicationId=A.id AND
			(@endTime = 0 OR jobStartTime <= @endTime)

		UPDATE @BKPXT
		SET	wst=(select top 1 A.startTime
			FROM	JMBkpAttemptInfo A WITH (READUNCOMMITTED), JMJobResourceHistory J WITH (READUNCOMMITTED)
			WHERE	T.ccId=J.commCellId and T.jobId=A.jobId and
				T.jobId=J.jobId and A.phaseNum=J.phaseNum and A.attemptNum=J.attemptNum
			ORDER BY A.phaseNum, A.attemptNum)
		FROM	@BKPXT T

		INSERT INTO @descTbl
		SELECT	J.jobid, J.commcellId, J.jobDescription, J.xmlJobInfo
		FROM	JMJobStats J WITH (READUNCOMMITTED)
				INNER JOIN JMBkpStats B
					ON J.jobId = B.jobID AND J.commcellId = B.commcellId
		WHERE	(@startTime = 0 OR B.servEndDate >= @startTime) AND (@endTime = 0 OR B.servStartDate <= @endTime)

		INSERT INTO @BKPXT
		SELECT commcellId,jobId,optype,clientId,appId,appType,bkpLevel,(case displayStatus when 0 then status else displayStatus end),0,servStartDate,servEndDate,duration,0,
			totalNumOfFiles,totalUncompbytes,totalWriteTime,initFrom,failureReason,dbo.JMGetLocalizedMessageFunc(@localeId,failureReason),
			scanFileFailures,scanFolderFailures,backupFileFailures,backupFolderFailures,bkpOptions,bkpAttributes,userName,
			J.dataArchGrpId, J.logArchGrpId,0,0,failureErrorCode,0,
			scanType,scanTypeChangeReason,totalcompbytes,totalBackupSize,percentageChange,
			cJobDesc , xJobInfo , 0, 0, J.dataStatus,J.agedTime, J.nwTransBytes, 0, J.subTaskId
		FROM	JMBkpStats J
				LEFT JOIN @descTbl
					ON cjobId = J.jobId and cellId =J.commcellId
				INNER JOIN APP_Application A
					ON	A.id = J.appId
		WHERE (@startTime = 0 OR J.servEndDate >= @startTime) AND (@endTime = 0 OR J.servStartDate <= @endTime)

		UPDATE @BKPXT
		SET	wst=(select top 1 A.servStartDate
			FROM	JMBkpAtmptStats A WITH (READUNCOMMITTED), JMJobResourceHistory J WITH (READUNCOMMITTED)
			WHERE	T.ccId=J.commCellId and T.jobId=A.jobId and
				T.jobId=J.jobId and A.phase=J.phaseNum and A.number=J.attemptNum
			ORDER BY A.phase, A.number)
		FROM	@BKPXT T

		UPDATE @BKPXT
		SET	wet=(select top 1 A.servEndDate
			FROM	JMBkpAtmptStats A WITH (READUNCOMMITTED), JMJobResourceHistory J WITH (READUNCOMMITTED)
			WHERE	T.ccId=J.commCellId and T.jobId=A.jobId and
				T.jobId=J.jobId and A.phase=J.phaseNum and A.number=J.attemptNum
			ORDER BY A.phase DESC, A.number DESC)
		FROM	@BKPXT T


		INSERT INTO @BKPXT
		SELECT	Q.commcellId, Q.jobId, A.opType, Q.clientId, -1, 1115 /*apptype*/, 0,
				A.status, 0, A.servStart, A.servEnd, (A.servEnd - A.servStart), 0,
				A.numFiles, A.uncompBytes, A.totalWriteTime, A.initFrom, A.failureReason, dbo.JMGetLocalizedMessageFunc(@localeId, failureReason),
				0, 0, 0, 0, 0, 0, A.username,
				(CASE A.archGrpId WHEN 0 THEN -1 ELSE A.archGrpId END), 0, 0, 0, A.failureErrorCode, 0,
				0, '', 0, 0, 0,
				'', N'', 0, 0, A.dataStatus, -1, -1, 0, A.subTaskId
		FROM	JMQinetixUpdateStatus Q WITH (READUNCOMMITTED), JMAdminJobStatsTable A WITH (READUNCOMMITTED)
		WHERE	Q.jobId = A.jobId AND
				Q.commcellId = A.commcellID AND
				A.opType = 79 AND
				(@startTime = 0 OR A.servEnd >= @startTime) AND (@endTime = 0 OR A.servStart <= @endTime) AND
				Q.clientId > 0

		DELETE @BKPXT
		WHERE clId NOT IN (SELECT DISTINCT clientId FROM SRM..SRMSECGetCSUserObjectsFN(@userId))

		UPDATE	@BKPXT
		SET		appType = 33
		WHERE	appType in (1, 11, 34, 42, 43)

		INSERT INTO	@bkpJobList
		(	JobType, ClientId, ClientName, AgentTypeId, AgentName, InstanceId, InstanceName,
			BackupSetId, BackupSetName, SubClientId, SubClientName, StoragePolicyId, StoragePolicyName,
			JobId, CommcellId, Status, ScheduleInitiated, SubTaskName, TaskName, BackupLevel, ScanType, StartTime, WriteStartTime, EndTime, WriteEndTime,
			CurrentPhase, ApplicationSize, CompressionRatePct, NwTransBytes, SizeOnMedia, SpaceSavingsPct, DataSizeChange, TransferTime,
			CurrentTransferTime, ThroughputGB, CurrentThroughputGB, ThroughputMB, CurrentThroughputMB, ProtectedObjects, FailedFiles, FailedFolders,
			QRDestination, AssociatedMedia, Drive, MediaAgent, ClientGroup, UserName, RetainedUntil, RetainedBy,
			IsAged, IsMediaDeleted, IsBackupCopyJob, IsSnapBackup, IsPerformanceJob, QROperationType, ScanTypeChangeReason, FailureReason,
			JobDesc, ClientDesc, AgentDesc, BackupSetDesc, InstanceDesc, SubClientDesc,
			Events, JobAttempts, SCContentFilters, ProtectedObjectsList, FailedObjectsList, ContentIndexingFailures,
			StubbedFilesList, LogDetails, JobDetails
		)
		SELECT
		dbo.GetBkpJobReportType(appType), clId, (select name from APP_Client WITH (READUNCOMMITTED) where id=clId),
		appType, (select name from APP_iDAType WITH (READUNCOMMITTED) where type=appType),
		instance, (select dbo.GetInstanceName(APP_InstanceName.name, appType) from APP_InstanceName WITH (READUNCOMMITTED) where id=instance),
		(SELECT backupSet FROM APP_Application WHERE id = appId),(select name from APP_BackupSetName WITH (READUNCOMMITTED) where id=(SELECT backupSet FROM APP_Application WHERE id = appId)),
		appId,(SELECT subClientName FROM APP_Application WHERE id = appId), archGrp,isnull((select name from archGroup WITH (READUNCOMMITTED) where id=archGrp),''),
		JobId, ccId, dbo.GetBkpJobStatus(status, state),
		CASE WHEN initF = 3 /*SCHEDINITIATED*/ THEN 1 ELSE 0 END,
		CASE WHEN initF = 3 THEN (SELECT subTaskName FROM TM_SubTask WHERE subTaskId = t_subTaskId) ELSE N'' END, --Sub task Name
		CASE WHEN initF = 3 THEN (SELECT taskName FROM TM_Task WHERE taskId = (SELECT taskId FROM TM_SubTask WHERE subTaskId = t_subTaskId)) ELSE N'' END, --Task Name
		bLevel,
		dbo.GetScanType(scanType), CASE WHEN startT <= 0 THEN dbo.GetDateTime(0) ELSE dbo.GetDateTime(ISNULL(startT, 0)) END,
		CASE WHEN wST <= 0 THEN dbo.GetDateTime(0) ELSE dbo.GetDateTime(ISNULL(wST, 0)) END,
		CASE WHEN endT <= 0 THEN dbo.GetDateTime(0) ELSE dbo.GetDateTime(ISNULL(endT, 0)) END,
		CASE WHEN wET <= 0 THEN dbo.GetDateTime(0) ELSE dbo.GetDateTime(ISNULL(wET, 0)) END,
		(CASE cPhase
			WHEN 0 THEN 'N/A'
			ELSE (SELECT name FROM JMPhase P WITH (READUNCOMMITTED), JMOpTable O WITH (READUNCOMMITTED) WHERE O.appTypeType=appType AND O.operation=optype AND P.opTableId=O.id AND P.phase=cPhase)
		END),
		uncompSize, dbo.GetCompressionRate(uncompSize, compSize), transferredDataSize, dbo.GetSizeOnMedia(jobId, ccid),
		dbo.GetSpaceSavingPct(uncompSize, jobId, ccid, optype, status), percChange, bTime, dbo.GetCurrentTransferTime(jobId, ccid, status),
		dbo.GetThroughput(uncompSize, btime, 1 /*GB/Hour */), dbo.GetThroughput(dbo.GetCurrentSize(jobId, ccid, status), dbo.GetCurrentTransferTime(jobId, ccid, status), 1 /*GB/Hour */),
		dbo.GetThroughput(uncompSize, bTime, 2/*MB/Sec*/), dbo.GetThroughput(dbo.GetCurrentSize(jobId, ccid, status), dbo.GetCurrentTransferTime(jobId, ccid, status), 2 /*MB/Sec */),
		objects, (sFl+bFl), (sFd+bFd), dbo.GetQRDestination(jobId, ccid),
		CASE WHEN @isAssocMediaSelected <> 0 THEN dbo.GetAssociatedMedia(jobId, ccid, opType) ELSE '' END, dbo.GetDriveByJobId(jobId),
		dbo.GetMediaAgent(jobId, ccId),
		CASE WHEN @isClientGroupSelected <> 0 THEN dbo.GetClientGroup(clId) ELSE '' END, userName, dbo.GetDateTime(0), 1, --retention time and type will be updated later
		0, 0, 0, 0, 0,
		999, scanChangeReason, failR, jobDescription, '',
		'', '', '', '',
		CASE WHEN @AssocEventsSelected <> 0 THEN dbo.GetAssociatedEvents(jobId, ccId, @localeId) ELSE '' END, '', '', '', '', '', '', '', ''
		FROM	@BKPXT, @tblApplication WHERE appId = id


		--Retention details
		IF (@RetainedUntilSelected <> 0 OR @RetainedBySelected <> 0)
		BEGIN
		DECLARE @tempJobRetention TABLE(
			jobId INT, commCellId INT, archGrpCopyId INT,
			retentionDays INT, extRetentionFlags INT, extRetentionDays INT,
			manualRetentionEndTime BIGINT, manualRetaided INT,
			PRIMARY KEY(jobId, commCellId, archGrpCopyId))

		DECLARE @maxJobRetention TABLE(
			jobId INT, commCellId INT, extRetentionFlags INT, retentionDays BIGINT, extRetentionDays BIGINT, manualRetentionEndTime BIGINT,
			PRIMARY KEY(jobId, commCellId))


		INSERT INTO @tempJobRetention
		SELECT	DISTINCT B.jobId, B.commCellId, B.archGrpCopyId,
					(case when J.AppType in (SELECT appTypeId FROM APP_IDATypeHandlingInfo WITH (NOLOCK) WHERE isDMAppType = 1)
						 then A.archiverRetDays else A.retentionDays end),
					B.retentionFlags, 0,
					B.manualRetentionEndTime, B.disabled & 2
		FROM	JMJobDataStats B WITH (NOLOCK), @BKPXT J,
					(SELECT AR.copyId,
							(case when AR.retentionDays < 0 then @MAXINT else AR.retentionDays end) AS retentionDays,
							(case when AR.archiverRetDays < 0 then @MAXINT else AR.archiverRetDays end) AS archiverRetDays
					FROM	archAgingRule AR WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
					WHERE	AR.copyId = AGC.id ) A
		WHERE	B.commCellId = J.ccId AND B.jobId = J.jobId
				AND B.status IN (2, 100)
				AND A.copyId = B.archGrpCopyId
				AND J.appId = B.appId

		UPDATE	@tempJobRetention
		SET		extRetentionFlags = (
					case
					when extRetentionFlags & 64 <> 0 then 64
					when extRetentionFlags & 32 <> 0 then 32
					when extRetentionFlags & 16 <> 0 then 16
					when extRetentionFlags & 8 <> 0 then 8
					when extRetentionFlags & 4 <> 0 then 4
					when extRetentionFlags & 2 <> 0 then 2
					end)
		WHERE	extRetentionFlags <> 0

		UPDATE	@tempJobRetention
		SET		extRetentionDays = b.retentionDays
		FROM	@tempJobRetention a,
					(SELECT AR.copyId, AR.retentionRule,
					(case when AR.retentionDays < 0 then @MAXINT else AR.retentionDays end) AS retentionDays
					FROM	archAgingRuleExtended AR WITH (READUNCOMMITTED), archGroupCopy AGC WITH (NOLOCK)
					WHERE	AR.copyId = AGC.id ) b
		WHERE	b.copyId = a.archGrpCopyId AND b.retentionRule = a.extRetentionFlags

		INSERT INTO @maxJobRetention
		SELECT	jobId, commCellId, MAX(extRetentionFlags), MAX(retentionDays), MAX(extRetentionDays), MAX(manualRetentionEndTime)
		FROM	@tempJobRetention
		GROUP BY jobId, commCellId


		UPDATE	@bkpJobList
		SET		RetainedUntil =
				(CASE	WHEN R.retentionDays = @MAXINT THEN dbo.GetDateTime(-1)
						WHEN R.manualRetentionEndTime = -1 THEN dbo.GetDateTime(0)
						WHEN (dbo.GetUnixTime(B.StartTime) + (R.retentionDays * 60 * 60 * 24)) < R.manualRetentionEndTime
							THEN dbo.GetDateTimeBIG(R.manualRetentionEndTime)
						WHEN (dbo.GetUnixTime(B.StartTime) + (R.retentionDays * 60 * 60 * 24)) >= R.manualRetentionEndTime
							THEN dbo.GetDateTimeBIG(dbo.GetUnixTime(B.StartTime) + (R.retentionDays * 60 * 60 * 24))
						ELSE
							dbo.GetDateTime(0)
				END)
		FROM	@maxJobRetention R, @bkpJobList B
		WHERE	R.jobId = B.jobId AND R.commcellId = B.commcellId

		UPDATE	@bkpJobList
		SET		RetainedBy =
				(CASE	WHEN R.extRetentionFlags > 0 THEN 2	--EXTENDED RETENTION
						ELSE 1								--BASIC RETENTION
				END)
		FROM	@maxJobRetention R, @bkpJobList B
		WHERE	R.jobId = B.jobId AND R.commcellId = B.commcellId
		END

		--Aged
		UPDATE	@bkpJobList
		SET		IsAged = 1
		FROM	JMBkpStats J WITH (READUNCOMMITTED), @bkpJobList B
		WHERE	B.jobId=J.jobId and B.CommcellId = J.commcellId and J.dataStatus=1 AND B.status NOT IN (2, 4, 9)	--(FAIL, KILLED, DROPPED)

		--MediaDeleted
		UPDATE	@bkpJobList
		SET		IsMediaDeleted = 1
		FROM	JMBkpStats J WITH (READUNCOMMITTED), @bkpJobList B
		WHERE	B.jobId=J.jobId and B.CommcellId=J.commcellId and J.dataStatus=2 AND B.status IN (1, 3)	-- JMSUCCESS, PARTIALSUCCESS
			AND B.AgentTypeId NOT IN (SELECT appTypeId FROM APP_IDATypeHandlingInfo  WITH (READUNCOMMITTED) WHERE isDMAppType = 1)


		--BackupCopyJob
		UPDATE	@bkpJobList
		SET		IsBackupCopyJob = 1
		FROM	@BKPXT J, @bkpJobList B
		WHERE	J.jobId = B.jobId AND J.ccId = B.commcellId AND opType = 60  --SNAPTOTAPE


		--Snap Backup jobs
		UPDATE	@bkpJobList
		SET		IsSnapBackup = 1
		FROM	@BKPXT J, @bkpJobList B
		WHERE	J.jobId = B.jobId AND J.ccId = B.commcellId AND opType = 59  --SNAPBACKUP

		--Performance Jobs
		UPDATE	@bkpJobList
		SET		IsPerformanceJob = 1
		FROM	@BKPXT J, @bkpJobList B
		WHERE	J.jobId = B.jobId AND J.ccId = B.commcellId
			AND dbo.GetOptionInt(312685036, B.jobId, 0, 0) = 1

		--QROperationType
		UPDATE	@bkpJobList
		SET		QROperationType = (
				CASE WHEN opType = 22 THEN 1 -- Create Snapshot
					WHEN opType = 23 THEN 2 -- Quick Recovery Agent Volume Creation
					WHEN optype = 24 THEN 3 -- Update Snapshot
					ELSE 999 --N/A
				END)
		FROM	@BKPXT J, @bkpJobList B
		WHERE	J.jobId = B.jobId AND J.ccId = B.commcellId

		--Update description fields
		UPDATE @bkpJobList
		SET ClientDesc = ISNULL((SELECT clientDescription FROM APP_Client WITH (READUNCOMMITTED) WHERE id= T.ClientId and T.ClientId> 0),N''),
			AgentDesc = ISNULL((SELECT attrVal FROM APP_IDAProp WITH (READUNCOMMITTED) WHERE componentNameId = (select id from APP_IDAName where clientId= T.ClientId and appTypeId = T.AgentTypeId and T.ClientId>0) AND attrName ='IDA Description' and modified =0),N''),
			BackupSetDesc = ISNULL((SELECT attrVal FROM APP_BackupSetProp WITH (READUNCOMMITTED) WHERE componentNameId= T.BackupSetId and T.BackupSetId> 0 AND attrName ='User Description' and modified =0),N''),
			InstanceDesc = ISNULL((SELECT attrVal FROM APP_InstanceProp WITH (READUNCOMMITTED) WHERE componentNameId= T.InstanceId and T.InstanceId> 0 AND attrName ='User Description' and modified =0),N''),
			SubClientDesc = ISNULL((SELECT attrVal FROM APP_SubClientProp WITH (READUNCOMMITTED) WHERE componentNameId= T.SubClientId and T.SubClientId > 0 AND attrName ='User Description' and modified =0),N''),
			CommcellName = ISNULL((SELECT aliasName FROM APP_CommCell WHERE id = T.CommcellId), N'')
		FROM @bkpJobList T
		RETURN

	END




GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BackupSummaryFn]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BackupSummaryFn' AND revision = '1.14')

  insert into GXDBVersions values(5, 'BackupSummaryFn',  '1.14', 'BackupSummaryFn', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetBkpJobReportType.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetBkpJobReportType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetBkpJobReportType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetBkpJobReportType]
  delete from GXDBVersions where name = 'GetBkpJobReportType' and type = 5
END
GO

	CREATE FUNCTION GetBkpJobReportType(@appType INTEGER)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @rptType INTEGER
		SET @rptType =
		CASE	WHEN @appType = 84
					THEN 7792
					WHEN (@appType = 47
							OR @appType = 50)
					THEN 7716
					WHEN (@appType = 45
							OR @appType = 56
							OR @appType = 57
							OR @appType = 58
							OR @appType = 66
							OR @appType = 73
							OR @appType = 82
							OR @appType = 83
							OR @appType = 67
							OR @appType = 68
							OR @appType = 90
							OR @appType = 89)
					THEN 7717
					WHEN (@appType = 93
							OR @appType = 105)
					THEN 7788
					WHEN (@appType = 600
							OR @appType = 601
							OR @appType = 602
							OR @appType = 603
							OR @appType = 604
							OR @appType = 605
							OR @appType = 606
							OR @appType = 607
							OR @appType = 650
							OR @appType = 651
							OR @appType = 652
							OR @appType = 699)
					THEN 7744
					ELSE 7715
		END
		return @rptType
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetBkpJobReportType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetBkpJobReportType' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetBkpJobReportType',  '1.2', 'GetBkpJobReportType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetBkpJobStatus.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetBkpJobStatus'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetBkpJobStatus]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetBkpJobStatus]
  delete from GXDBVersions where name = 'GetBkpJobStatus' and type = 5
END
GO

	CREATE FUNCTION GetBkpJobStatus(@status INTEGER, @state INTEGER)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @retVal INTEGER
		IF @status <> 0
		BEGIN
			IF @status NOT IN (1, 2, 9, 3, 14, 4, 5, 6)
				SET @retVal = 50 --Unknown
			ELSE
				RETURN @status
		END
		ELSE
		BEGIN
			SET @retVal = (CASE	WHEN (@state = 1 OR @state = 4 OR @state = 9)
					THEN 51  --Active
					ELSE
						52 --Delayed
			END)
		END
		RETURN @retVal
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetBkpJobStatus]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetBkpJobStatus' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetBkpJobStatus',  '1.2', 'GetBkpJobStatus', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetScanType.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetScanType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetScanType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetScanType]
  delete from GXDBVersions where name = 'GetScanType' and type = 5
END
GO

	CREATE FUNCTION GetScanType(@scanType INTEGER)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @sT INTEGER
		SET @sT =
			CASE @scanType
				WHEN	1 THEN 1	-- JM_SCAN_TYPE_CHANGE_JOURNAL
				WHEN	2 THEN 2	-- JM_SCAN_TYPE_CLASSIC
				WHEN	3 THEN 3	-- JM_SCAN_TYPE_MIXED
			ELSE
				9 -- N/A
			END
		RETURN @sT
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetScanType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetScanType' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetScanType',  '1.1', 'GetScanType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetCompressionRate.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetCompressionRate'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetCompressionRate]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetCompressionRate]
  delete from GXDBVersions where name = 'GetCompressionRate' and type = 5
END
GO

	CREATE FUNCTION GetCompressionRate(@uncompSize BIGINT, @compSize BIGINT)
	RETURNS FLOAT
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @compRate FLOAT
		IF (@uncompSize > 0 AND @compsize > 0 AND @uncompSize > @compSize)
		BEGIN
			SET @compRate = ((@uncompSize - @compSize)/(@uncompSize * 1.0)) * 100
		END
		ELSE
			SET @compRate = 0
		RETURN @compRate * 100.0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetCompressionRate]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetCompressionRate' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetCompressionRate',  '1.3', 'GetCompressionRate', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSizeOnMedia.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSizeOnMedia'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSizeOnMedia]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSizeOnMedia]
  delete from GXDBVersions where name = 'GetSizeOnMedia' and type = 5
END
GO

	CREATE FUNCTION GetSizeOnMedia(@jobId INTEGER, @ccId INTEGER)
	RETURNS BIGINT
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @sizeOnMedia BIGINT
		SELECT @sizeOnMedia = SUM(ISNULL(S.sizeOnMedia, 0)) FROM JMJobDataStats S
				WHERE S.commcellId = @ccId AND S.jobId = @jobId AND S.AuxCopyJobId = 0

		RETURN ISNULL(@sizeOnMedia, -1)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSizeOnMedia]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSizeOnMedia' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetSizeOnMedia',  '1.2', 'GetSizeOnMedia', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSpaceSavingPct.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSpaceSavingPct'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSpaceSavingPct]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSpaceSavingPct]
  delete from GXDBVersions where name = 'GetSpaceSavingPct' and type = 5
END
GO

	CREATE FUNCTION GetSpaceSavingPct(@uncompSize BIGINT, @jobId INTEGER, @ccId INTEGER, @optype INTEGER, @status INTEGER)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @sizeOnMedia BIGINT
		DECLARE @spaceSavingPct INTEGER
		SELECT @sizeOnMedia = SUM(ISNULL(S.sizeOnMedia, 0)) FROM JMJobDataStats S
				WHERE S.commcellId = @ccId AND S.jobId = @jobId AND S.AuxCopyJobId = 0

		IF @opType = 60 OR @status IN (2, 9, 4)-- 60->SNAPTOTAPE,2->failed,4->killed,9->Dropped
		BEGIN
			SET @spaceSavingPct = -1
			RETURN @spaceSavingPct * 100.0
		END
		IF @uncompSize > @sizeOnMedia
			SET @spaceSavingPct = ((@uncompSize - @sizeOnMedia)/(@uncompSize * 1.0)) * 100
		ELSE
			SET @spaceSavingPct = 0
		RETURN @spaceSavingPct * 100.0
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSpaceSavingPct]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSpaceSavingPct' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetSpaceSavingPct',  '1.4', 'GetSpaceSavingPct', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetCurrentTransferTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetCurrentTransferTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetCurrentTransferTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetCurrentTransferTime]
  delete from GXDBVersions where name = 'GetCurrentTransferTime' and type = 5
END
GO

	CREATE FUNCTION GetCurrentTransferTime(@jobId INTEGER, @ccId INTEGER, @status INTEGER)
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @currentTransTime INTEGER
		SELECT @currentTransTime = max(writeTime) FROM JMJobStreams
		WHERE	jobId = @jobId AND commcellId = @ccId AND @status = 0

		RETURN ISNULL(@currentTransTime, -1)

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetCurrentTransferTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetCurrentTransferTime' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetCurrentTransferTime',  '1.2', 'GetCurrentTransferTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetCurrentSize.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetCurrentSize'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetCurrentSize]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetCurrentSize]
  delete from GXDBVersions where name = 'GetCurrentSize' and type = 5
END
GO

	CREATE FUNCTION GetCurrentSize(@jobId INTEGER, @ccId INTEGER, @status INTEGER)
	RETURNS BIGINT
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @currentSize BIGINT
		SELECT @currentSize = SUM(unCompBytes) FROM JMJobStreams
		WHERE	jobId = @jobId AND commcellId = @ccId AND @status = 0

		RETURN @currentSize

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetCurrentSize]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetCurrentSize' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetCurrentSize',  '1.2', 'GetCurrentSize', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetThroughput.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetThroughput'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetThroughput]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetThroughput]
  delete from GXDBVersions where name = 'GetThroughput' and type = 5
END
GO

	CREATE FUNCTION GetThroughput(@size BIGINT, @time INTEGER, @throughputUnit INTEGER)
	RETURNS FLOAT
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @throughPut FLOAT
		IF (@throughputUnit = 1) --GB/Hour
		BEGIN
			IF (@size > 0 AND @time > 0)
				SET @throughput = ((@size * 3600.0)/@time+1)/(1024 * 1024 * 1024)
			ELSE
				SET @throughput = 0
		END
		ELSE		-- MB/Sec
		BEGIN
			IF (@size > 0 AND @time > 0)
				SET @throughput = ((@size * 1.0)/@time+1)/(1024 * 1024)
			ELSE
				SET @throughput = 0
		END
		RETURN @throughput
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetThroughput]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetThroughput' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetThroughput',  '1.2', 'GetThroughput', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetQRDestination.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetQRDestination'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetQRDestination]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetQRDestination]
  delete from GXDBVersions where name = 'GetQRDestination' and type = 5
END
GO

	CREATE FUNCTION GetQRDestination(@jobId INTEGER, @ccId INTEGER)
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @QrDest NVARCHAR(MAX)
		SET @QrDest = N''
		DECLARE @clName VARCHAR(510)
		DECLARE @devName VARCHAR(510)
		DECLARE qrCur CURSOR FOR
			SELECT DstClientName, DstDevName FROM QRJobVolumeHistory
			WHERE jobId = @jobId AND commcellId = @ccId
		OPEN qrCur
		FETCH NEXT FROM qrCur INTO @clName, @devName
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @QrDest = @QrDest + @clName
			SET @QrDest = @QrDest + ':'
			SET @QrDest = @QrDest + @devName
			FETCH NEXT FROM qrCur INTO @clName, @devName
			IF @@FETCH_STATUS = 0
				SET @QrDest = @QrDest + ', '
		END
		CLOSE qrCur
		DEALLOCATE qrCur
		RETURN @QrDest
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetQRDestination]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetQRDestination' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetQRDestination',  '1.2', 'GetQRDestination', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetAssociatedMedia.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAssociatedMedia'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAssociatedMedia]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAssociatedMedia]
  delete from GXDBVersions where name = 'GetAssociatedMedia' and type = 5
END
GO

	CREATE FUNCTION GetAssociatedMedia(@jobId INTEGER, @ccId INTEGER, @opType INTEGER)
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @mediaList NVARCHAR(MAX)
		IF (@opType = 60) --SNAPTOTAPE
			SET @mediaList = N''
		ELSE
			SET @mediaList = CommServ.dbo.rptGetMediaListByCopyOrJobFn(0, @jobId)
		RETURN @mediaList
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAssociatedMedia]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAssociatedMedia' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetAssociatedMedia',  '1.1', 'GetAssociatedMedia', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/rptGetMediaListByCopyOrJobFn.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: rptGetMediaListByCopyOrJobFn'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[rptGetMediaListByCopyOrJobFn]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[rptGetMediaListByCopyOrJobFn]
  delete from GXDBVersions where name = 'rptGetMediaListByCopyOrJobFn' and type = 5
END
GO

	CREATE FUNCTION rptGetMediaListByCopyOrJobFn(@copyId	INTEGER, @jobId INTEGER)
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @tempAFCopy TABLE(
			afId	integer,
			ccId	integer
		)

		IF @copyId > 0
			INSERT INTO @tempAFCopy
			SELECT archFileId, commCellId
			FROM   archFileCopy WITH (READUNCOMMITTED)
			WHERE  archCopyId = @copyId AND isValid = 1
		ELSE
			INSERT INTO @tempAFCopy
			SELECT id, commCellId
			FROM   archFile WITH (READUNCOMMITTED)
			WHERE  JobId =  @jobId
		DECLARE @tempChunk TABLE (archChunkId INTEGER, ccId INTEGER)
		DECLARE @tempVolume TABLE (volumeId INTEGER)

		INSERT INTO @tempChunk
		SELECT DISTINCT archChunkId, ccid
		FROM   archChunkMapping WITH (READUNCOMMITTED), @tempAFCopy
		WHERE  archFileId = afId AND commCellId = ccId AND (@copyId > 0 AND archCopyId = @copyId OR @copyId = 0)

		INSERT INTO   @tempVolume
		SELECT DISTINCT volumeId
		FROM   archChunk WITH (READUNCOMMITTED), @tempChunk
		WHERE  id = archChunkId and commCellId = ccId

		DECLARE @tempMedia TABLE (barcode VARCHAR(64), magMediaSideId INTEGER)

		INSERT INTO @tempMedia
		SELECT DISTINCT M.barcode, magMediaSideId=(case M.MediaTypeId when 10001 /*CV_MAGNETIC_MEDIA*/ then V.MediaSideId else 0 end)
		FROM @tempVolume T 	LEFT JOIN MMVolume V WITH (READUNCOMMITTED) ON T.VolumeId=V.VolumeId
					LEFT JOIN MMMedia M WITH (READUNCOMMITTED) ON V.MediaId=M.MediaId

		DECLARE @media VARCHAR(MAX)
		SET @media = ''
		DECLARE magCur CURSOR FOR
				SELECT magMediaSideId, barcode,
					mountPath=M.MountPathName
				FROM @tempMedia LEFT OUTER JOIN CommServ.dbo.MMS2getMountPathNameGUIView M WITH (READUNCOMMITTED)
					ON magMediaSideId>0 and magMediaSideId=M.MediaSideId
					ORDER BY barcode, mountPath
		OPEN magCur
		DECLARE @isMag INT
		DECLARE @barcode VARCHAR(128)
		DECLARE @mountPath	VARCHAR(256)
		FETCH NEXT FROM magCur INTO @isMag, @barcode, @mountPath
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @media = '\n' + @media + (CASE WHEN @isMag > 0 THEN @mountPath ELSE @barcode END)
			FETCH NEXT FROM magCur INTO @isMag, @barcode, @mountPath
		END
		CLOSE magCur
		DEALLOCATE magCur
		RETURN @media
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [rptGetMediaListByCopyOrJobFn]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'rptGetMediaListByCopyOrJobFn' AND revision = '1.1')

  insert into GXDBVersions values(5, 'rptGetMediaListByCopyOrJobFn',  '1.1', 'rptGetMediaListByCopyOrJobFn', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientGroup.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientGroup'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientGroup]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientGroup]
  delete from GXDBVersions where name = 'GetClientGroup' and type = 5
END
GO

	CREATE FUNCTION GetClientGroup(@clId INTEGER)
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @groups NVARCHAR(MAX)
		DECLARE @curGrp VARCHAR(512)
		SET @groups = ''
		DECLARE cgCur CURSOR FOR
			SELECT GRP.name
			FROM APP_ClientGroupAssoc ASSOC, APP_ClientGroup GRP
			WHERE ASSOC.clientGroupId = GRP.id
				AND ASSOC.clientId = @clId
		OPEN cgCur
		FETCH NEXT FROM cgCur INTO @curGrp
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @groups = @groups + @curGrp + '; '
			FETCH NEXT FROM cgCur INTO @curGrp
		END
		CLOSE cgCur
		DEALLOCATE cgCur
		-- Truncate the extra semicolon at the end
		IF LEN(@groups) <> 0
			SET @groups = LEFT(@groups, LEN(@groups) -1 )
		RETURN @groups
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientGroup]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientGroup' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetClientGroup',  '1.4', 'GetClientGroup', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetAssociatedEvents.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAssociatedEvents'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAssociatedEvents]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAssociatedEvents]
  delete from GXDBVersions where name = 'GetAssociatedEvents' and type = 5
END
GO

	CREATE FUNCTION GetAssociatedEvents(@jobId INTEGER, @ccId INTEGER, @locId INTEGER)
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @id INTEGER
		DECLARE @client VARCHAR(512)
		DECLARE @subsys VARCHAR(512)
		DECLARE @timeSrc INTEGER
		DECLARE @MsgText NVARCHAR(MAX)
		DECLARE @returnText NVARCHAR(MAX)
		SET @returnText = ''

		DECLARE evCur CURSOR FOR
		SELECT  E.id, E.client, E.subsystem, E.timeSource, ISNULL(C.Message, ISNULL(dbo.fn_EvFormatEventMsgText(E.id, @locId, E.messageId, 1, @ccid), '')) AS MsgText
		FROM    evMsg E LEFT OUTER JOIN EvMsgCache C ON C.evMsgId = E.id AND C.commcellId = E.commCellID
		WHERE   e.commCellID = @ccId AND E.jobId_l = @jobId

		OPEN evCur
		FETCH NEXT FROM evCur INTO @id, @client, @subsys, @timeSrc, @MsgText
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @returnText = @returnText + '\n'
			SET @returnText = @returnText + CAST(@id AS NVARCHAR(10))
			SET @returnText = @returnText + ' [' + @client + '/' + @subsys + '] '
			SET @returnText = @returnText + (CASE WHEN @timeSrc > 0 THEN ' [' + CAST(dbo.GetDateTime(@timeSrc) AS NVARCHAR(64)) + '] ' ELSE '' END) + ':'
			SET @returnText = @returnText + @MsgText
			FETCH NEXT FROM evCur INTO @id, @client, @subsys, @timeSrc, @MsgText
		END
		CLOSE evCur
		DEALLOCATE evCur
		RETURN @returnText

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAssociatedEvents]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAssociatedEvents' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetAssociatedEvents',  '1.2', 'GetAssociatedEvents', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDriveByJobId.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDriveByJobId'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDriveByJobId]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDriveByJobId]
  delete from GXDBVersions where name = 'GetDriveByJobId' and type = 5
END
GO

	CREATE FUNCTION GetDriveByJobId(@i_jobId INTEGER)
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE	@driveType	integer
		DECLARE	@driveName	nvarchar(128)
		DECLARE @o_driveList NVARCHAR(MAX)
		SET @o_driveList=''

		DECLARE @tempDrive TABLE(
			id	integer
		)

		INSERT INTO @tempDrive
		SELECT DISTINCT DriveId
		FROM JMJobResourceHistory
		WHERE jobId=@i_jobId

		DECLARE driveList CURSOR FOR
			SELECT DISTINCT DriveTypeId, AliasName
			FROM @tempDrive LEFT JOIN MMDrive WITH (READUNCOMMITTED) ON Id=DriveId
		OPEN driveList
		FETCH NEXT FROM driveList INTO @driveType, @driveName
		WHILE @@FETCH_STATUS <> -1
		BEGIN
			IF LEN(@o_driveList) <> 0
				SET @o_driveList =  @o_driveList + ', '

			IF @driveType = 10001
				SET @o_driveList = @o_driveList + 'Magnetic'
			ELSE
				SET @o_driveList = @o_driveList + @driveName

			FETCH NEXT FROM driveList INTO @driveType, @driveName
		END
		CLOSE driveList
		DEALLOCATE driveList

		RETURN @o_driveList
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDriveByJobId]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDriveByJobId' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetDriveByJobId',  '1.2', 'GetDriveByJobId', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetMediaAgent.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetMediaAgent'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetMediaAgent]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetMediaAgent]
  delete from GXDBVersions where name = 'GetMediaAgent' and type = 5
END
GO

	CREATE FUNCTION GetMediaAgent(@i_jobId INTEGER, @ccId INTEGER)
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @MAList NVARCHAR(510)
		DECLARE @temp_MAs TABLE (MAid INTEGER)
		SET @MAList = ''
		INSERT INTO @temp_MAs
		SELECT	DISTINCT JI.ClientId
		FROM	JMJobResourceHistory JI WITH (READUNCOMMITTED)
			JOIN	MMHost M	 WITH (READUNCOMMITTED) ON JI.ClientId=M.ClientId
		WHERE JI.jobId = @i_jobId and JI.commcellId = @ccId

		DECLARE @maName NVARCHAR(510)
		DECLARE maCur CURSOR FOR
		SELECT	C.name FROM	APP_Client C JOIN @temp_MAs M ON M.MAid = C.id
		OPEN maCur
		FETCH NEXT FROM maCur INTO @maName
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @MAList = @MAList + @maName
			FETCH NEXT FROM maCur INTO @maName
			IF @@FETCH_STATUS = 0
				SET @MAList = @MAList + ', '
		END
		CLOSE maCur
		DEALLOCATE maCur
		RETURN @MAList
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetMediaAgent]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetMediaAgent' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetMediaAgent',  '1.2', 'GetMediaAgent', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientOSStatus.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientOSStatus'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientOSStatus]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientOSStatus]
  delete from GXDBVersions where name = 'GetClientOSStatus' and type = 5
END
GO

	CREATE FUNCTION GetClientOSStatus(@clientId integer)
	RETURNS VARCHAR(100)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @obinarySetId integer
		DECLARE	@nbinarySetId integer
		DECLARE @output nvarchar(1000) = ''

		SELECT @obinarySetId = CONVERT(INT,attrVal) FROM APP_ClientProp WHERE componentNameId = @clientId AND attrName = 'Binary Set ID'

		SELECT @nbinarySetId = CONVERT(INT,attrVal) FROM APP_ClientProp WHERE componentNameId = @clientId AND attrName = 'New Binary Set ID'

		IF @obinarySetId <> 0 AND  @nbinarySetId <> 0 AND @obinarySetId <> @nbinarySetId
			SET @output = 'Upgraded, Needs reinstall.'

		RETURN @output
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientOSStatus]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientOSStatus' AND revision = '')

  insert into GXDBVersions values(5, 'GetClientOSStatus',  '', 'GetClientOSStatus', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getHtmlEscapedString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getHtmlEscapedString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getHtmlEscapedString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getHtmlEscapedString]
  delete from GXDBVersions where name = 'getHtmlEscapedString' and type = 5
END
GO

    CREATE FUNCTION getHtmlEscapedString (@message nvarchar(max), @isHtmlConversionNeeded int)
    RETURNS nvarchar(max)
    AS BEGIN
    if (@isHtmlConversionNeeded=0)
    begin
    	return @message
    end
    set @message = replace(@message,"&", "&amp;")
    set @message = replace(@message,'<','&lt;')
    set @message = replace(@message,'>','&gt;')
    RETURN @message
    END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getHtmlEscapedString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getHtmlEscapedString' AND revision = '1.1')

  insert into GXDBVersions values(5, 'getHtmlEscapedString',  '1.1', 'getHtmlEscapedString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientOwners.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientOwners'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientOwners]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientOwners]
  delete from GXDBVersions where name = 'GetClientOwners' and type = 5
END
GO

	CREATE FUNCTION GetClientOwners(@clId INTEGER)
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @owners VARCHAR(max)
	SET @owners = ''
	SELECT @owners = @owners + u.login + ','
	FROM sec_getClientOwners(1) UUG
		INNER JOIN UMUsers U ON U.id = UUG.userId AND UUG.clientId=@clId
	IF @owners IS NOT NULL AND LEN(@owners) > 0
	BEGIN
		SELECT @owners = SUBSTRING(@owners,1,LEN(@owners) -1)
	END
	RETURN @owners
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientOwners]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientOwners' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetClientOwners',  '1.4', 'GetClientOwners', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientAgents.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientAgents'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientAgents]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientAgents]
  delete from GXDBVersions where name = 'GetClientAgents' and type = 5
END
GO

	CREATE FUNCTION GetClientAgents(@clId INTEGER)
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @agents NVARCHAR(max)
	DECLARE @curAgent NVARCHAR(512)
	SET @agents = ''
	DECLARE agentCur CURSOR FOR
	SELECT DISTINCT display_name
	FROM simAppTypeLicTypeMap
	WHERE appTypeId IN (SELECT appTypeId FROM APP_Application WHERE clientId = @clId AND apptypeId < 1000)
	OPEN agentCur
	FETCH NEXT FROM agentCur INTO @curAgent
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @agents = @agents + @curAgent + ', '
		FETCH NEXT FROM agentCur INTO @curAgent
	END
	IF @agents IS NOT NULL AND LEN(@agents) > 0
	BEGIN
		SELECT @agents = SUBSTRING(@agents,1,LEN(@agents) -1)
	END
	CLOSE agentCur
	DEALLOCATE agentCur
	RETURN @agents
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientAgents]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientAgents' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetClientAgents',  '1.3', 'GetClientAgents', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsClientSnapEnabled.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsClientSnapEnabled'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsClientSnapEnabled]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsClientSnapEnabled]
  delete from GXDBVersions where name = 'IsClientSnapEnabled' and type = 5
END
GO

	CREATE FUNCTION IsClientSnapEnabled(@clientId integer)
	RETURNS VARCHAR(100)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result VARCHAR(100) = 'No'
		DECLARE @snapEnabled INT = ISNULL((SELECT CAST(attrVal AS INT) from APP_ClientProp where componentNameId = @clientId and attrName = 'Snap Backups Enabled' and modified = 0),0)
		IF @snapEnabled = 1
		BEGIN
			SET @result='Yes'
		END
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsClientSnapEnabled]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsClientSnapEnabled' AND revision = '1.2')

  insert into GXDBVersions values(5, 'IsClientSnapEnabled',  '1.2', 'IsClientSnapEnabled', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSubclientPropForRefCopy.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSubclientPropForRefCopy'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSubclientPropForRefCopy]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSubclientPropForRefCopy]
  delete from GXDBVersions where name = 'GetSubclientPropForRefCopy' and type = 5
END
GO

	CREATE FUNCTION GetSubclientPropForRefCopy(@scId integer, @propName NVARCHAR(1024), @refCopyId INTEGER)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		--Get the timezone info from the APP_Client table
		DECLARE @attrv varchar(255)
		DECLARE @supportedAttributes table(propertyName nvarchar(1024))
		INSERT INTO @supportedAttributes values('sys:full cycle num')
		INSERT INTO @supportedAttributes values('sys:non full cycle num')
		INSERT INTO @supportedAttributes values('sys:last full')
		INSERT INTO @supportedAttributes values('sys:last incr')
		INSERT INTO @supportedAttributes values('sys:last full start with SP Change')
		INSERT INTO @supportedAttributes values('Reason last backup time cleared')
		BEGIN
			IF @refCopyId <> 0 AND EXISTS(SELECT *FROM @supportedAttributes where propertyName = @propName)
				select @attrv = attrVal  from APP_SubclientProp where componentNameId = @scId AND attrName = @propName + '_' +cast(@refCopyId as nvarchar(10)) AND modified = 0
			ELSE
				select @attrv = attrVal  from APP_SubclientProp where componentNameId = @scId AND attrName = @propName AND modified = 0
		END
		RETURN @attrv
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSubclientPropForRefCopy]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSubclientPropForRefCopy' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetSubclientPropForRefCopy',  '1.2', 'GetSubclientPropForRefCopy', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSubclientAttrName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSubclientAttrName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSubclientAttrName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSubclientAttrName]
  delete from GXDBVersions where name = 'GetSubclientAttrName' and type = 5
END
GO

	CREATE FUNCTION GetSubclientAttrName(@propName NVARCHAR(1024), @refCopyId INTEGER)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @attrName nvarchar(255)
		--Supported Attributes
		DECLARE @supportedAttributes table(propertyName nvarchar(1024))
		--sys:full cycle num , sys:last full, sys:last incr, sys:last full start with SP Change, Reason last backup time cleared
		INSERT INTO @supportedAttributes values('sys:full cycle num')
		INSERT INTO @supportedAttributes values('sys:non full cycle num')
		INSERT INTO @supportedAttributes values('sys:last full')
		INSERT INTO @supportedAttributes values('sys:last incr')
		INSERT INTO @supportedAttributes values('sys:last full start with SP Change')
		INSERT INTO @supportedAttributes values('Reason last backup time cleared')
		BEGIN
			IF @refCopyId <> 0 AND EXISTS(SELECT *FROM @supportedAttributes where propertyName = @propName)
				select @attrName = @propName + '_' +cast(@refCopyId as nvarchar(10))
			ELSE
				select @attrName = @propName
		END
		RETURN @attrName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSubclientAttrName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSubclientAttrName' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetSubclientAttrName',  '1.3', 'GetSubclientAttrName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSelectedSubClients.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: GetSelectedSubClients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSelectedSubClients]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSelectedSubClients]
  delete from GXDBVersions where name = 'GetSelectedSubClients' and type = 5
END
GO

	CREATE FUNCTION GetSelectedSubClients( @treeSelection XML)
		RETURNS @selectedIdsTbl TABLE(
				subClientId INT
		)
		AS
		BEGIN

			DECLARE @handle INT;
			DECLARE @tblSubclientSelection TABLE (clientId INT, appType INT, instance INT, backupSet INT, subclient INT)

			INSERT INTO @tblSubclientSelection
			SELECT	ISNULL(item.c.value('./@clientId', 'INT'), 0), ISNULL(item.c.value('./@applicationId', 'INT'), 0), ISNULL(item.c.value('./@instanceId', 'INT'), 0),
					ISNULL(item.c.value('./@backupsetId', 'INT'), 0), ISNULL(item.c.value('./@subclientId', 'INT'), 0)
			FROM	@treeSelection.nodes('/TreeSelections/subclientFilterList') item(c)

			INSERT INTO @selectedIdsTbl
			SELECT	id FROM APP_Application A, @tblSubClientSelection S
			WHERE	(A.clientId = S.clientId OR S.clientId = 0)
				AND	(A.appTypeId = S.appType OR S.appType = 0)
				AND (A.instance = S.instance OR S.instance = 0)
				AND (A.backupSet = S.backupSet OR S.backupSet = 0)
				AND (A.id = S.subclient OR S.subclient = 0)

		RETURN
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSelectedSubClients]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSelectedSubClients' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetSelectedSubClients',  '1.1', 'GetSelectedSubClients', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetInstanceName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetInstanceName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetInstanceName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetInstanceName]
  delete from GXDBVersions where name = 'GetInstanceName' and type = 5
END
GO

	CREATE FUNCTION GetInstanceName(@instanceName NVARCHAR(512), @appType INT)
	RETURNS NVARCHAR(512)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @instName NVARCHAR(512)
		SET @instName = ''
		DECLARE	@stopIndex INTEGER
		IF	@appType IN (3, 4, 16,
			6, 7, 5,
			51, 52,
			2, 22, 23, 80,
			27, 31,
			32, 37,
			60, 59,
			62, 77,
			70, 81, 104,
			61, 79,
			90, 103, 125, 128,
			106, 58)
		BEGIN
			SET @stopIndex = CASE WHEN CHARINDEX(NCHAR(0x12), @instanceName) > 0 THEN CHARINDEX(NCHAR(0x12), @instanceName) - 1 ELSE LEN(@instanceName) END
			SET @instName = SUBSTRING(@instanceName, 1, @stopIndex)
		END
		ELSE
			SET @instName = 'N/A'

		RETURN @instName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetInstanceName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetInstanceName' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetInstanceName',  '1.3', 'GetInstanceName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobBackupTypeString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobBackupTypeString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobBackupTypeString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobBackupTypeString]
  delete from GXDBVersions where name = 'GetJobBackupTypeString' and type = 5
END
GO

	CREATE FUNCTION GetJobBackupTypeString (@localeId INT, @backupType INT, @appTypeId INT)
	RETURNS NVARCHAR(255)
	AS
	BEGIN
				DECLARE @retStr NVARCHAR(255)
				SET @retStr = N'Unknown'
				IF (@backupType = 1)
					SET @retStr = CASE WHEN @appTypeId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END
				ELSE IF (@backupType = 2)
					SET @retStr = CASE WHEN @appTypeId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN @appTypeId = 125 THEN N'Log Only' ELSE N'Incremental' END
				ELSE IF (@backupType = 4)
					SET @retStr = CASE WHEN @appTypeId IN (37,62) THEN N'Delta' ELSE N'Differential' END
				ELSE IF (@backupType = 0x40)
					SET @retStr = N'Synthetic Full'
				ELSE IF (@backupType = 0x80)
					SET @retStr = N'Synthetic Full'
				ELSE IF (@backupType = 0x4000)
					SET @retStr = N'Synthetic Full'
				ELSE IF (@backupType = 0x100)
					SET @retStr = CASE WHEN @appTypeId = 104 THEN N'Incremental' ELSE N'Transaction Log' END
				ELSE IF (@backupType = 0x200)
					SET @retStr = N'ASR'
				ELSE IF (@backupType = 0x800)
					SET @retStr = N'Snapshot'
				ELSE IF (@backupType = 0x1000)
					SET @retStr = N'New Volume Creation'
				ELSE IF (@backupType = 0x2000)
					SET @retStr = N'Incremental Volume Update'
				ELSE IF (@backupType = 0x8000)
					SET @retStr = N'Online Full'
				ELSE IF (@backupType = 0x400)
					SET @retStr = N'Offline Full'
				ELSE IF (@backupType = 0x20000)
					SET @retStr = N'Analysis'
				ELSE IF (@backupType = 0x40000)
					SET @retStr = N'Discovery'

	IF	@localeId > 0
		SELECT	@retStr = Message
		FROM	WR_LocaleStringsView
		WHERE	LocaleID = @localeId
			AND MessageID = (SELECT TOP 1 MessageID FROM WR_LocaleStringsView WHERE LocaleID = 0 AND Message = @retStr)

	RETURN @retStr
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobBackupTypeString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobBackupTypeString' AND revision = '1.6')

  insert into GXDBVersions values(5, 'GetJobBackupTypeString',  '1.6', 'GetJobBackupTypeString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobOperationString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobOperationString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobOperationString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobOperationString]
  delete from GXDBVersions where name = 'GetJobOperationString' and type = 5
END
GO

	CREATE FUNCTION GetJobOperationString (@localeId INT, @operationId INT, @appTypeId INT)
	RETURNS NVARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE	@retStr NVARCHAR(255)
	SELECT	@retStr =
				  CASE @operationId
			      WHEN 0 THEN N'No Operation'
				  WHEN 1 THEN N'All Operation'
				  WHEN 2 THEN N'Online'
				  WHEN 3 THEN N'Offline'
				  WHEN 4 THEN (CASE WHEN @appTypeId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
				  WHEN 5 THEN N'Restore'
				  WHEN 6 THEN N'Import'
				  WHEN 7 THEN N'CvImport'
				  WHEN 8 THEN N'Media Init'
				  WHEN 9 THEN N'Media Recycle'
				  WHEN 10 THEN N'Prune'
				  WHEN 11 THEN N'CS DR Backup'
				  WHEN 12 THEN N'Index Restore'
				  WHEN 13 THEN N'Aux Copy'
				  WHEN 14 THEN N'Synthetic Full'
				  WHEN 15 THEN N'W2K System Restore'
				  WHEN 16 THEN N'W2K Full Build Restore'
				  WHEN 17 THEN N'Report'
				  WHEN 18 THEN N'Backup 3RD'
				  WHEN 19 THEN N'W2K Full Build Restore371'
				  WHEN 20 THEN N'SchedExport'
				  WHEN 21 THEN N'Media Inventory'
				  WHEN 22 THEN N'Snapshot'
				  WHEN 23 THEN N'Create Replica'
				  WHEN 24 THEN N'Update Replica'
				  WHEN 25 THEN N'DM Outlook Restore'
				  WHEN 26 THEN N'Media Prediction'
				  WHEN 27 THEN N'Snap Recovery'
				  WHEN 28 THEN N'Schedule'
				  WHEN 29 THEN N'Quick DM Restore'
				  WHEN 30 THEN N'System State Backup'
				  WHEN 31 THEN N'Archive Check'
				  WHEN 32 THEN N'Tape Erase'
				  WHEN 33 THEN N'Shelf Mangement'
				  WHEN 34 THEN N'QR Copy Backup'
				  WHEN 35 THEN N'Patch Update'
				  WHEN 36 THEN N'Patch Download'
				  WHEN 37 THEN N'QR RollBack'
				  WHEN 38 THEN N'Selective Delete'
				  WHEN 39 THEN N'WorkFlow'
				  WHEN 40 THEN N'Index Free Restore'
				  WHEN 41 THEN N'Drive Validation'
				  WHEN 42 THEN N'Drive Cleaning'
				  WHEN 43 THEN N'SysRecovery Backup'
				  WHEN 44 THEN N'Browse And Delete'
				  WHEN 45 THEN N'Snap Vault Restore'
				  WHEN 46 THEN N'Stamp Media'
				  WHEN 47 THEN N'Catalogue Media'
				  WHEN 48 THEN N'SR System Recovery'
				  WHEN 49 THEN N'Search And Retrieve'
				  WHEN 50 THEN N'Create Consistency Point'
				  WHEN 51 THEN N'Create Recovery Point'
				  WHEN 52 THEN N'FLR Copy Backup'
				  WHEN 53 THEN N'Offline Content Index'
				  WHEN 54 THEN N'Power Restore'
				  WHEN 55 THEN N'Power Search And Restore'
				  WHEN 56 THEN N'CDR'
				  WHEN 57 THEN N'Online Content Index'
				  WHEN 58 THEN N'SRM OpType'
				  WHEN 59 THEN N'Snap Backup'
				  WHEN 60 THEN N'Snap To Tape'
				  WHEN 61 THEN N'Snap To Tape WorkFlow'
				  WHEN 62 THEN N'SRM Report'
				  WHEN 63 THEN N'Maglib Maintenance'
				  WHEN 64 THEN N'Info Management'
				  WHEN 65 THEN N'Snap Backup3RD'
				  WHEN 66 THEN N'Offline Mining Restore'
				  WHEN 67 THEN N'Install Client'
				  WHEN 68 THEN N'UnInstall Client'
				  WHEN 69 THEN N'FDC WorkFlow'
				  WHEN 70 THEN N'Mining Backup'
				  WHEN 71 THEN N'CCM Capture'
				  WHEN 72 THEN N'CCM Merge'
				  WHEN 73 THEN N'FDC Client'
				  WHEN 74 THEN N'Media Refreshing'
				  WHEN 75 THEN N'FD CopyType'
				  WHEN 76 THEN N'Archive Optype'
				  WHEN 77 THEN N'Mining Content Index'
				  WHEN 78 THEN N'FDC Preparation'
				  WHEN 79 THEN N'Agentless SRM'
				  WHEN 80 THEN N'Dedup DB Reconstruction'
				  WHEN 81 THEN N'Tape Import'
				  WHEN 82 THEN N'Data Verification'
				  WHEN 83 THEN N'Other Admin Operation'
				  WHEN 84 THEN N'Upgrade Client'
				  WHEN 85 THEN N'Virtual Machine Management'
				  WHEN 86 THEN N'Log Monitoring'
				  WHEN 87 THEN N'Turbo NAS'
				  WHEN 88 THEN N'CommCell Synchronization'
				  WHEN 89 THEN N'Virtualize Machine'
				  WHEN 90 THEN N'Workflow Management'
				  WHEN 91 THEN N'PST Archiving'
				  WHEN 92 THEN N'Send Log Files'
				  WHEN 93 THEN N'Reference Copy Work Flow'
				  WHEN 94 THEN N'Smart Copy'
				  WHEN 95 THEN N'Delayed Catalog Work Flow'
				  WHEN 96 THEN N'Delayed Catalog'
				  WHEN 97 THEN N'PST Archiving'
				  WHEN 98 THEN N'Archive'
				  WHEN 99 THEN N'Move Partition'
				  WHEN 104 THEN N'Aux Copy'
				  ELSE N'Unknown'  END

	IF	@localeId > 0
		SELECT	@retStr = Message
		FROM	WR_LocaleStringsView
		WHERE	LocaleID = @localeId
			AND MessageID = (SELECT TOP 1 MessageID FROM WR_LocaleStringsView WHERE LocaleID = 0 AND Message = @retStr)

	RETURN @retStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobOperationString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobOperationString' AND revision = '1.6')

  insert into GXDBVersions values(5, 'GetJobOperationString',  '1.6', 'GetJobOperationString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobStatusString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobStatusString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobStatusString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobStatusString]
  delete from GXDBVersions where name = 'GetJobStatusString' and type = 5
END
GO

	CREATE FUNCTION GetJobStatusString (@localeId INT, @statusId INTEGER)
	RETURNS VARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @jobStatusName varchar(255)
		SELECT @jobStatusName =
			CASE @statusId
			WHEN 1 THEN 'Completed'
			WHEN 2 THEN 'Completed with errors'
			WHEN 3 THEN 'Completed with warnings'
			WHEN 4 THEN 'Failed'
			WHEN 5 THEN 'Killed'
			WHEN 6 THEN 'Delayed'
			WHEN 7 THEN 'Running'
			WHEN 8 THEN 'No Run'
			WHEN 9 THEN 'Committed'
			ELSE 'Unknown' END

	IF	@localeId > 0
		SELECT	@jobStatusName = Message
		FROM	WR_LocaleStringsView
		WHERE	LocaleID = @localeId
			AND MessageID = (SELECT TOP 1 MessageID FROM WR_LocaleStringsView WHERE LocaleID = 0 AND Message = @jobStatusName)

	RETURN @jobStatusName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobStatusString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobStatusString' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetJobStatusString',  '1.4', 'GetJobStatusString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetMaxRetentionTime.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetMaxRetentionTime'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetMaxRetentionTime]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetMaxRetentionTime]
  delete from GXDBVersions where name = 'GetMaxRetentionTime' and type = 5
END
GO

	CREATE FUNCTION GetMaxRetentionTime(@inJobId integer, @inCommcellId integer, @jobStartTime integer)
	RETURNS BIGINT
	WITH ENCRYPTION
	AS
	BEGIN

	DECLARE @MAXINT					bigint
	DECLARE @retentionDays			bigint
	DECLARE @extendedRetentionDays	bigint
	DECLARE @manualRetentionTime	bigint
	DECLARE @retentionTime			bigint
	SET @MAXINT = 0x7FFFFFFFFFFFFFFF
	SET @retentionDays = 0
	SET @extendedRetentionDays = 0
	SET @manualRetentionTime = 0
	SET @retentionTime = 0

	IF EXISTS(SELECT 1 FROM JMBkpStats WITH(NOLOCK) WHERE jobId = @inJobId AND commcellId = @inCommcellId AND dataStatus IN(1, 2))
	BEGIN
		SELECT @retentionTime = CASE WHEN agedTime > 0 THEN agedTime WHEN mediaDeletedTime > 0 THEN mediaDeletedTime ELSE @jobStartTime END
		FROM JMBkpStats WITH(NOLOCK)
		WHERE jobId = @inJobId AND commcellId = @inCommcellId

		RETURN @retentionTime
	END
	ELSE IF EXISTS (SELECT 1 FROM JMAdminJobStatsTable WITH(NOLOCK) WHERE jobId = @inJobId AND commcellId = @inCommcellId AND dataStatus IN(1, 2))
	BEGIN
		SELECT @retentionTime = CASE WHEN ISNULL(MAX(agedTime), 0) > 0 THEN MAX(agedTime) WHEN ISNULL(MAX(mediaDeletedTime), 0) > 0 THEN MAX(mediaDeletedTime) ELSE @jobStartTime END
		FROM JMJobDataStats WITH(NOLOCK) WHERE jobId = @inJobId AND commcellId = @inCommcellId

		RETURN @retentionTime
	END

	declare @tempJobRetention table(
		jobId INT, commCellId INT, archGrpCopyId INT,
		retentionDays BIGINT, extRetentionFlags INT, extRetentionDays BIGINT,
		manualRetentionEndTime BIGINT, manualRetaided INT)

	INSERT INTO @tempJobRetention
	SELECT	DISTINCT B.jobId, B.commCellId, B.archGrpCopyId,
			(case when J.AppType in (SELECT appTypeId FROM APP_IDATypeHandlingInfo WITH (NOLOCK) WHERE isDMAppType = 1)
			 then A.archiverRetDays else A.retentionDays end),
			B.retentionFlags, 0,
			(case when B.manualRetentionEndTime < 0 then @MAXINT else B.manualRetentionEndTime end) AS manualRetentionEndTime, B.disabled & 2
	FROM	JMJobDataStats B WITH (NOLOCK), JmBkpStats J WITH (NOLOCK),
			(SELECT AR.copyId,
					(case when AR.retentionDays < 0 then @MAXINT else AR.retentionDays end) AS retentionDays,
					(case when AR.archiverRetDays < 0 then @MAXINT else AR.archiverRetDays end) AS archiverRetDays
			FROM	archAgingRule AR WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
			WHERE	AR.copyId = AGC.id ) A
	WHERE J.jobId = @inJobId AND J.commCellId = @inCommcellId AND
	B.commCellId = J.commCellId AND B.jobId = J.jobId
		AND B.status IN (2, 100)
		AND A.copyId = B.archGrpCopyId
		AND J.appId = B.appId

	UPDATE	@tempJobRetention
	SET		extRetentionFlags = (
	case
	when extRetentionFlags & 64 <> 0 then 64
	when extRetentionFlags & 32 <> 0 then 32
	when extRetentionFlags & 16 <> 0 then 16
	when extRetentionFlags & 8 <> 0 then 8
	when extRetentionFlags & 4 <> 0 then 4
	when extRetentionFlags & 2 <> 0 then 2
	end)
	WHERE	extRetentionFlags <> 0

	UPDATE	@tempJobRetention
	SET		extRetentionDays = case when b.retentionDays < 0 then @MAXINT else b.retentionDays end
	FROM	@tempJobRetention a,
			(SELECT AR.copyId, AR.retentionRule,
			AR.retentionDays AS retentionDays
			FROM	archAgingRuleExtended AR WITH (READUNCOMMITTED), archGroupCopy AGC WITH (NOLOCK)
			WHERE	AR.copyId = AGC.id ) b
	WHERE	b.copyId = a.archGrpCopyId AND b.retentionRule = a.extRetentionFlags

	SELECT	@retentionDays = MAX(retentionDays), @extendedRetentionDays = MAX(extRetentionDays), @manualRetentionTime = MAX(manualRetentionEndTime)
	FROM	@tempJobRetention
	GROUP BY jobId, commCellId

	IF @retentionDays = @MAXINT OR @extendedRetentionDays = @MAXINT OR @manualRetentionTime = @MAXINT -- Infinite Retention
		SET @retentionTime = -1 -- Infinite Retention
	ELSE
	BEGIN
		IF @retentionDays >= 0 and @extendedRetentionDays > @retentionDays -- Extended Retention check
			SET @retentionDays = @extendedRetentionDays
		SET @retentionTime = @retentionDays
		IF @retentionDays >= 0
		BEGIN
			IF @manualRetentionTime > (@jobStartTime + @retentionDays*24*60*60) -- Manual Retention check
				SET  @retentionTime = @manualRetentionTime
			ELSE
				SET @retentionTime = @jobStartTime + @retentionDays*24*60*60
		END
	END
	RETURN @retentionTime
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetMaxRetentionTime]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetMaxRetentionTime' AND revision = '1.7')

  insert into GXDBVersions values(5, 'GetMaxRetentionTime',  '1.7', 'GetMaxRetentionTime', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDateTimeFormatString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDateTimeFormatString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDateTimeFormatString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDateTimeFormatString]
  delete from GXDBVersions where name = 'GetDateTimeFormatString' and type = 5
END
GO

	CREATE FUNCTION GetDateTimeFormatString (@UnixTimeArg integer, @inTime DATETIME, @formatType integer)
	RETURNS VARCHAR(128)
	WITH ENCRYPTION
	AS
	BEGIN
	 	DECLARE @time 		DATETIME
	 	DECLARE @timeStr	VARCHAR(128)

	 	IF @inTime is not null
	 		SET @time = @inTime
	 	ELSE IF @UnixTimeArg > 0
	 		SET @time = dateadd(second, @UnixTimeArg, '01/01/1970')
	 	ELSE
	 		RETURN ''
		DECLARE @day    int
		DECLARE @month  int
		DECLARE @year   int
		DECLARE @hour   int
		DECLARE @minute int
		DECLARE @sec	int
		DECLARE @dayStr varchar(4)
		DECLARE @monthStr varchar(4)

		SET @month    = DATEPART(MONTH, @time)
		SET @day      = DATEPART(DAY, @time)
            SET @monthStr = ( CASE WHEN @month < 10 THEN '0' + CAST(@month as nvarchar(4)) ELSE CAST(@month as nvarchar(4)) END)
		SET @dayStr   = ( CASE WHEN @day < 10 THEN '0' + CAST(@day as nvarchar(4)) ELSE CAST(@day as nvarchar(4)) END)
		SET @year     = DATEPART(YEAR,@time)
		SET @hour     = DATEPART(hour, @time)
		SET @minute   = DATEPART(minute, @time)
		SET @sec      = DATEPART(second, @time)

		IF ( @formatType = 0 )  SET @timeStr = @monthStr + '/' + @dayStr ELSE SET  @timeStr = @dayStr + '/' + @monthStr

		SET @timeStr += '/'
		SET @timeStr += CAST( @year as nvarchar(4))
		SET @timeStr += ' '
		SET @timeStr += ( CASE WHEN @hour < 10 THEN '0' + CAST(@hour as nvarchar(4)) ELSE CAST(@hour as nvarchar(4)) END)
		SET @timeStr += ':'
		SET @timeStr += ( CASE WHEN @minute < 10 THEN '0' + CAST(@minute as nvarchar(4)) ELSE CAST(@minute as nvarchar(4)) END)
		SET @timeStr += ':'
		SET @timeStr += ( CASE WHEN @sec < 10 THEN '0' + CAST(@sec as nvarchar(4)) ELSE CAST(@sec as nvarchar(4)) END)

		RETURN @timeStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDateTimeFormatString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDateTimeFormatString' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetDateTimeFormatString',  '1.2', 'GetDateTimeFormatString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetAutoSizeStr.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAutoSizeStr'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAutoSizeStr]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAutoSizeStr]
  delete from GXDBVersions where name = 'GetAutoSizeStr' and type = 5
END
GO

	CREATE FUNCTION GetAutoSizeStr(@size bigint)
	RETURNS VARCHAR(128)
	WITH ENCRYPTION
	AS
	BEGIN
    DECLARE @outStr VARCHAR(128)
    DECLARE @Bytes  float = cast( @size as float)
 	SELECT @outStr =
	CASE
	     WHEN @Bytes < 1024 THEN CAST(@Bytes as VARCHAR(100)) + ' Bytes'
   	     WHEN @Bytes < 1048576 THEN CAST(ROUND((@Bytes/1024),2) as VARCHAR(100))+' KB'
	     WHEN @Bytes < 1073741824 THEN CAST(ROUND((@Bytes/1048576),2) as VARCHAR(100)) + ' MB'
	     WHEN @Bytes < 1099511627776 THEN CAST(ROUND((@Bytes/1073741824),2) as VARCHAR(100)) + ' GB'
   	     WHEN @Bytes < 1125899906842624 THEN CAST(ROUND((@Bytes/1099511627776),2) as VARCHAR(100)) + ' TB'
         WHEN @Bytes < 1152921504606846976 THEN CAST(ROUND((@Bytes/1125899906842624),2) as VARCHAR(100)) + ' PB'
	END
    RETURN @outStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAutoSizeStr]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAutoSizeStr' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetAutoSizeStr',  '1.1', 'GetAutoSizeStr', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetLicNameFromType.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetLicNameFromType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetLicNameFromType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetLicNameFromType]
  delete from GXDBVersions where name = 'GetLicNameFromType' and type = 5
END
GO

    CREATE FUNCTION GetLicNameFromType(@licType INTEGER)
    RETURNS NVARCHAR(1024)
    WITH ENCRYPTION
    AS BEGIN
    	DECLARE	@eventNum INTEGER = 0
		DECLARE @eventMsg NVARCHAR(1024)

    	if(@licType = 1)
    		SET @eventNum = (167 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 2)
    		SET @eventNum = (168 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (171 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (172 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (174 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (176 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 11)
    		SET @eventNum = (177 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 11	)
    		SET @eventNum = (177 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 11)
    		SET @eventNum = (177 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 11)
    		SET @eventNum = (177 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 11	)
    		SET @eventNum = (177 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 16)
    		SET @eventNum = (182 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 17)
    		SET @eventNum = (182 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 17)
    		SET @eventNum = (183 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 1)
    		SET @eventNum = (167 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 1)
    		SET @eventNum = (167 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 1)
    		SET @eventNum = (167 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 25)
    		SET @eventNum = (191 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (192 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 1)
    		SET @eventNum = (167 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 1)
    		SET @eventNum = (167 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 17)
    		SET @eventNum = (183 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3	)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 25	)
    		SET @eventNum = (191 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 25)
    		SET @eventNum = (191 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 36)
    		SET @eventNum = (202 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (203 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 1)
    		SET @eventNum = (167 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (212 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 25)
    		SET @eventNum = (191 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (214 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (215 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 11)
    		SET @eventNum = (177 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (182 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (222 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (223 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (214 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (226 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 17)
    		SET @eventNum = (183 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 63)
    		SET @eventNum = (229 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 16)
    		SET @eventNum = (182 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (231 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (233 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (234 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (235 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (236 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 71)
    		SET @eventNum = (237 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 11)
    		SET @eventNum = (177 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 1	)
    		SET @eventNum = (167 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 1)
    		SET @eventNum = (167 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (244 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 16	)
    		SET @eventNum = (182 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1	)
    		SET @eventNum = (246 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 82	)
    		SET @eventNum = (248 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 63)
    		SET @eventNum = (229 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 84)
    		SET @eventNum = (250 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 85)
    		SET @eventNum = (251 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (254 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (182 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 90)
    		SET @eventNum = (256 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 91	)
    		SET @eventNum = (257 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3	)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3	)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1	)
    		SET @eventNum = (260 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 63)
    		SET @eventNum = (229 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (262 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 1	)
    		SET @eventNum = (167 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (264 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (265 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (266 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (267 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 102)
    		SET @eventNum = (311 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 16)
    		SET @eventNum = (182 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 16)
    		SET @eventNum = (182 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 105)
    		SET @eventNum = (314 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (315 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (315 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 110)
    		SET @eventNum = (319 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 111)
    		SET @eventNum = (320 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (322 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (327 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 25)
    		SET @eventNum = (191 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    --6.1 licenses
    	if(@licType = 122)
    		SET @eventNum = (351 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 63)
    		SET @eventNum = (229 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 124)
    		SET @eventNum = (353 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 127)
    		SET @eventNum = (431 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (432 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    --7.0 licenses
    	if(@licType = 129)
    		SET @eventNum = (455 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (182 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 132)
    		SET @eventNum = (458 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 133)
    		SET @eventNum = (459 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (460 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (461 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (464 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (465 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 139 )
    		SET @eventNum = (468 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 141 )
    		SET @eventNum = (470 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 83886080)
    		SET @eventNum = (356 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 100663296)
    		SET @eventNum = (357 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 143)
    		SET @eventNum = (491 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (473 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    --8.0 licenses
    	if(@licType = -1)
    		SET @eventNum = (475 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (476 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (476 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (475 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (475 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (475 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (476 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (476 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (483 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 142)
    		SET @eventNum = (474 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (486 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	--if(@licType = SIM_CSL_AT_V2_OM_EXCH_ADMIN)
    	--	SET @eventNum = CSL_LIC_OM_EXCH_ADMIN
    	if(@licType = 157)
    		SET @eventNum = (490 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 157)
    		SET @eventNum = (492 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 163)
    		SET @eventNum = (494 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (497 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 157)
    		SET @eventNum = (492 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 168)
    		SET @eventNum = (500 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 169)
    		SET @eventNum = (501 | (CAST(POWER(2, 24) AS BIGINT) * 1))
        if(@licType = 170)
            SET @eventNum = (502 | (CAST(POWER(2, 24) AS BIGINT) * 1))

    	--9.0 licenses
    	if(@licType = 171)
    		SET @eventNum = (504 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 172)
    		SET @eventNum = (505 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 174)
    		SET @eventNum = (507 | (CAST(POWER(2, 24) AS BIGINT) * 1))

    	--9.0
    	if(@licType = 177)
    		SET @eventNum = (510 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 179)
    		SET @eventNum = (512 | (CAST(POWER(2, 24) AS BIGINT) * 1))

    	if(@licType = -1)
    		SET @eventNum = (476 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 3)
    		SET @eventNum = (169 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 190)
    		SET @eventNum = (523 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = -1)
    		SET @eventNum = (539 | (CAST(POWER(2, 24) AS BIGINT) * 1))

    	if(@licType = 196)
    		SET @eventNum = (536 | (CAST(POWER(2, 24) AS BIGINT) * 1))

    	--Capacity based licensing
    	if(@licType = 100002)
    		SET @eventNum = (532 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 100004)
    		SET @eventNum = (534 | (CAST(POWER(2, 24) AS BIGINT) * 1))

    	--10.0 new licenses
    	if(@licType = -1)
    		SET @eventNum = (540 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 200)
    		SET @eventNum = (542 | (CAST(POWER(2, 24) AS BIGINT) * 1))

    	if(@licType = 100011)
    		SET @eventNum = (543 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 203)
    		SET @eventNum = (544 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 100013)
    		SET @eventNum = (545 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 100014)
    		SET @eventNum = (546 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 100015)
    		SET @eventNum = (547 | (CAST(POWER(2, 24) AS BIGINT) * 1))
    	if(@licType = 100016)
    		SET @eventNum = (548 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		if (@licType = 100017)
			SET @eventNum = (551 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		if (@licType = 100018)
			SET @eventNum = (570 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		if (@licType = 100024)
			SET @eventNum = (576 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		if (@licType = 100025)
			SET @eventNum = (577 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		if (@licType = 100026)
			SET @eventNum = (578 | (CAST(POWER(2, 24) AS BIGINT) * 1))
		if (@licType = 100027)
			SET @eventNum = (583 | (CAST(POWER(2, 24) AS BIGINT) * 1))

    	IF (@eventNum <> 0)
    	BEGIN
    		SET @eventMsg = dbo.fn_EvFormatEventMsgText(0, 0, @eventNum, 0, 2)
		END
    	ELSE
    	BEGIN
			SET @eventMsg = (SELECT TOP 1 Short_Name FROM SimLicAppTypeV2 WHERE id = @licType)
    	END
		RETURN @eventMsg
    END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetLicNameFromType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetLicNameFromType' AND revision = '1.10')

  insert into GXDBVersions values(5, 'GetLicNameFromType',  '1.10', 'GetLicNameFromType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/ConvertHexToInt.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ConvertHexToInt'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ConvertHexToInt]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ConvertHexToInt]
  delete from GXDBVersions where name = 'ConvertHexToInt' and type = 5
END
GO

	CREATE FUNCTION ConvertHexToInt ( @hexnum  varchar(128))
	RETURNS INT
	AS
	BEGIN
   DECLARE @i                 int;
   DECLARE @digits            int;
   DECLARE @Xdigits           int;
   DECLARE @result            int ;
   DECLARE @current_digit     char(1);
   DECLARE @current_digit_dec int;

   set @digits = Len(@hexnum);
   set @Xdigits = CHARINDEX( 'x', @hexnum, 1)
   set @digits = @digits - @Xdigits
  SET @hexnum = RIGHT(@hexnum , @digits)
   --Trim the hex values

   SET @result = 0
   SET @i = 1
   WHILE ( @i <= @digits)
   BEGIN
     SET @current_digit = SUBSTRING(@hexnum, @i, 1);
      IF  (@current_digit in ('A','B','C','D','E','F'))
        SET  @current_digit_dec = ascii(@current_digit) - ascii('A') + 10;
      ELSE
 	   SET @current_digit_dec = CAST(@current_digit AS int);
      SET @result = (@result * 16) + @current_digit_dec;
      SET @i = @i + 1
   END
  return @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ConvertHexToInt]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ConvertHexToInt' AND revision = '')

  insert into GXDBVersions values(5, 'ConvertHexToInt',  '', 'ConvertHexToInt', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetVSAContentAsString.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: GetVSAContentAsString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetVSAContentAsString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetVSAContentAsString]
  delete from GXDBVersions where name = 'GetVSAContentAsString' and type = 5
END
GO

	CREATE FUNCTION GetVSAContentAsString( @vmXML  XML)
	RETURNS VARCHAR(2048)
	WITH ENCRYPTION
	AS
	BEGIN
		return ('Rule: Backup '+' VM whose '+(STUFF((SELECT (case c.x.value('../@allOrAnyChildren','INT')
					when 1 then ' and '
					when 0 then ' or '
					end)+(case c.x.value('@type','INT')
					when 1  then 'Server Host'
					when 2  then 'Resource Pool'
					when 3  then 'vApp'
					when 4 then 'Datacenter'
					when 5 then 'Folder'
					when 6 then 'Cluster'
					when 7  then 'Datastore'
					when 8  then 'DatastoreCluster'
					when 9  then 'VM'
					when 10 then 'VM Name'
					when 11 then 'VM Guest OS'
					when 12 then 'VM Guest Host Name'
					when 13 then 'Cluster Shared Volumes'
					when 14 then 'Local Disk'
					when 15 then 'Cluster Disk'
					when 18 then 'File Server'
					when 19 then 'Share'
					else 'Unknown' end)
					+(case c.x.value('@equalsOrNotEquals', '[int]')
					when 1 then ' equals '
					when 0 then ' does not match '
					end )
					+c.x.value('@displayName', 'nvarchar(512)')
					FROM @vmXML.nodes('/VirtualServer_VMSubClientEntity/children/children') AS c(x)
					FOR xml path ('')),1,(case @vmXML.value('(/VirtualServer_VMSubClientEntity/children/@allOrAnyChildren)[1]','INT')
					when 1 then 4
					when 0 then 3 end),''))
				)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetVSAContentAsString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetVSAContentAsString' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetVSAContentAsString',  '1.3', 'GetVSAContentAsString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/WR_TranslateString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: WR_TranslateString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[WR_TranslateString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[WR_TranslateString]
  delete from GXDBVersions where name = 'WR_TranslateString' and type = 5
END
GO

	CREATE FUNCTION WR_TranslateString (@toLocaleId INT, @fromLocaleId INT, @fromString NVARCHAR(1024))
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE	@retStr NVARCHAR(1024)
	SELECT	@retStr = @fromString

	IF	@toLocaleId <> @fromLocaleId
		SELECT	@retStr = Message
		FROM	WR_LocaleStringsView
		WHERE	LocaleID = @toLocaleId
			AND MessageID = (SELECT TOP 1 MessageID FROM WR_LocaleStringsView WHERE LocaleID = @fromLocaleId AND Message = @fromString)

	RETURN @retStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [WR_TranslateString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'WR_TranslateString' AND revision = '1.1')

  insert into GXDBVersions values(5, 'WR_TranslateString',  '1.1', 'WR_TranslateString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/WR_GetMediaStatusString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: WR_GetMediaStatusString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[WR_GetMediaStatusString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[WR_GetMediaStatusString]
  delete from GXDBVersions where name = 'WR_GetMediaStatusString' and type = 5
END
GO

	CREATE FUNCTION WR_GetMediaStatusString (@localeId INT, @mediaStatusFlag INT)
	RETURNS NVARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE	@retStr varchar(255)
	SELECT	@retStr =
			CASE @mediaStatusFlag
				  WHEN 1	THEN N'Active'
				  WHEN 2	THEN N'Appendable'
				  WHEN 4	THEN N'Full'
				  WHEN 8	THEN N'New'
				  WHEN 16	THEN N'Aged'
				  WHEN 32	THEN N'Read Only'
				  WHEN 64	THEN N'Bad'
				  WHEN 128	THEN N'Undiscovered'
				  WHEN 256	THEN N'Duplicate Barcode'
				  WHEN 512	THEN N'Ready'
				  WHEN 1024 THEN N'Offline'
				  WHEN 2048 THEN N'Cleaning'
							ELSE N'N/A'
			END

	IF	@localeId > 0
		SELECT	@retStr = Message
		FROM	WR_LocaleStringsView
		WHERE	LocaleID = @localeId
			AND MessageID = (SELECT TOP 1 MessageID FROM WR_LocaleStringsView WHERE LocaleID = 0 AND Message = @retStr)

	RETURN @retStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [WR_GetMediaStatusString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'WR_GetMediaStatusString' AND revision = '1.2')

  insert into GXDBVersions values(5, 'WR_GetMediaStatusString',  '1.2', 'WR_GetMediaStatusString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/WR_GetMediaGroupTypeString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: WR_GetMediaGroupTypeString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[WR_GetMediaGroupTypeString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[WR_GetMediaGroupTypeString]
  delete from GXDBVersions where name = 'WR_GetMediaGroupTypeString' and type = 5
END
GO

	CREATE FUNCTION WR_GetMediaGroupTypeString (@localeId INT, @mediaGroupTypeFlag INT)
	RETURNS NVARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE	@retStr varchar(255)
	SELECT	@retStr =
			CASE @mediaGroupTypeFlag
				  WHEN 1	THEN N'Scratch'
				  WHEN 8	THEN N'Retired'
				  WHEN 16	THEN N'Foreign'
				  WHEN 32	THEN N'Cleaning'
				  WHEN 64	THEN N'Overwrite Protected'
				  WHEN 128	THEN N'Catalog'
							ELSE N'N/A'
			END

	IF	@localeId > 0
		SELECT	@retStr = Message
		FROM	WR_LocaleStringsView
		WHERE	LocaleID = @localeId
			AND MessageID = (SELECT TOP 1 MessageID FROM WR_LocaleStringsView WHERE LocaleID = 0 AND Message = @retStr)

	RETURN @retStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [WR_GetMediaGroupTypeString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'WR_GetMediaGroupTypeString' AND revision = '1.1')

  insert into GXDBVersions values(5, 'WR_GetMediaGroupTypeString',  '1.1', 'WR_GetMediaGroupTypeString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/WR_GetSLACategoryString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: WR_GetSLACategoryString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[WR_GetSLACategoryString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[WR_GetSLACategoryString]
  delete from GXDBVersions where name = 'WR_GetSLACategoryString' and type = 5
END
GO

	CREATE FUNCTION WR_GetSLACategoryString (@localeId INT, @SLA_Category INT)
	RETURNS NVARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE	@retStr varchar(255)
	SELECT	@retStr =
			CASE @SLA_Category
				  WHEN 1	THEN N'Protected'
				  WHEN 2	THEN N'Failed'
				  WHEN 3	THEN N'No Job within SLA Period'
				  WHEN 4	THEN N'No Schedule'
				  WHEN 5	THEN N'Backup Activity Disabled'
				  WHEN 6	THEN N'Longtime Offline'
				  WHEN 7	THEN N'Deconfigured'
				  WHEN 8	THEN N'Exclude From SLA Property'
				  WHEN 9	THEN N'Do Not Backup VM'
				  WHEN 10	THEN N'Recently installed with no finished job'
				  WHEN 11	THEN N'Excluded Server Type'
							ELSE N'N/A'
			END

	IF	@localeId > 0
		SELECT	@retStr = Message
		FROM	WR_LocaleStringsView
		WHERE	LocaleID = @localeId
			AND MessageID = (SELECT TOP 1 MessageID FROM WR_LocaleStringsView WHERE LocaleID = 0 AND Message = @retStr)

	RETURN @retStr
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [WR_GetSLACategoryString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'WR_GetSLACategoryString' AND revision = '1.5')

  insert into GXDBVersions values(5, 'WR_GetSLACategoryString',  '1.5', 'WR_GetSLACategoryString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetBkpLevelOfSnapJobs.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetBkpLevelOfSnapJobs'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetBkpLevelOfSnapJobs]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetBkpLevelOfSnapJobs]
  delete from GXDBVersions where name = 'GetBkpLevelOfSnapJobs' and type = 5
END
GO

	CREATE FUNCTION GetBkpLevelOfSnapJobs(@inJobID BIGINT, @inCommCellID INT, @inArchGroupCopyId INT)
	RETURNS INT
	AS
	BEGIN
	DECLARE @opType INT
	DECLARE @outBkpLevel INT
	DECLARE @appType INT

	SELECT @opType = BKP.opType, @outBkpLevel = BKP.bkpLevel, @appType = APP.appTypeId
	FROM JMBkpStats BKP WITH(NOLOCK)
	INNER JOIN APP_Application APP WITH(NOLOCK) ON APP.id = BKP.appId
	WHERE BKP.jobId = @inJobId AND BKP.commCellId = @inCommCellId

	IF	@inArchGroupCopyId <> 0
		AND @outBkpLevel <> 1 -- FULL
		AND @opType = 59 --SNAPBACKUP
		AND ( @appType IN (13 /*NETAPP*/, 88 /*CENTERA*/, 106 /*VIRTUAL_SERVER_IDA*/) )
			  --OR @appType IN (SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35, 0)) -- APPGRP_FileSystemIDA
		AND EXISTS (SELECT 1
					FROM archGroupCopy AGC WITH (NOLOCK)
					INNER JOIN archGroup AG WITH (NOLOCK) ON AGC.archGroupId = AG.id
					WHERE AGC.isSnapCopy = 1
					AND AG.flags & 32768 = 32768 -- CVA_SP_CONSIDER_INCR_SNAPS_AS_FULL_FLAG
					AND AGC.id = @inArchGroupCopyId)
	BEGIN
		SET @outBkpLevel = 1 --FULL
	END

	RETURN ISNULL(@outBkpLevel, 0)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetBkpLevelOfSnapJobs]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetBkpLevelOfSnapJobs' AND revision = '')

  insert into GXDBVersions values(5, 'GetBkpLevelOfSnapJobs',  '', 'GetBkpLevelOfSnapJobs', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetBkpLevelForSnapCopy.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetBkpLevelForSnapCopy'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetBkpLevelForSnapCopy]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetBkpLevelForSnapCopy]
  delete from GXDBVersions where name = 'GetBkpLevelForSnapCopy' and type = 5
END
GO

	CREATE FUNCTION GetBkpLevelForSnapCopy(@inAppId INTEGER, @inBackupLevel INTEGER, @inArchGroupCopyId INT)
	RETURNS INT
	AS
	BEGIN
	DECLARE @opType INT
	DECLARE @outBkpLevel INT
	DECLARE @appType INT = 0

	SET @outBkpLevel = @inBackupLevel
	SELECT @appType = A.appTypeId
	FROM APP_Application A WITH(NOLOCK)
	INNER JOIN APP_SubClientProp SCPROP WITH(NOLOCK) ON A.id = SCPROP.ComponentNameId
	WHERE A.id = @inAppId AND SCPROP.attrName = 'Enable Snap Backups' AND CAST(attrVal AS INT) = 1

	IF	@inArchGroupCopyId <> 0
		AND @outBkpLevel <> 1 -- FULL
		AND ( @appType IN (13 /*NETAPP*/, 88 /*CENTERA*/, 106 /*VIRTUAL_SERVER_IDA*/) )
			  --OR @appType IN (SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(35, 0)) -- APPGRP_FileSystemIDA
		AND EXISTS (SELECT 1
					FROM archGroupCopy AGC WITH (NOLOCK)
					INNER JOIN archGroup AG WITH (NOLOCK) ON AGC.archGroupId = AG.id
					WHERE AGC.isSnapCopy = 1
					AND AG.flags & 32768 = 32768 -- CVA_SP_CONSIDER_INCR_SNAPS_AS_FULL_FLAG
					AND AGC.id = @inArchGroupCopyId)
	BEGIN
		SET @outBkpLevel = 1 --FULL
	END

	RETURN ISNULL(@outBkpLevel, 0)
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetBkpLevelForSnapCopy]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetBkpLevelForSnapCopy' AND revision = '')

  insert into GXDBVersions values(5, 'GetBkpLevelForSnapCopy',  '', 'GetBkpLevelForSnapCopy', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GenerateHostName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GenerateHostName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GenerateHostName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GenerateHostName]
  delete from GXDBVersions where name = 'GenerateHostName' and type = 5
END
GO

	create function GenerateHostName(
	@name as nvarchar(255),
	@hostname as nvarchar(1024),
		@guid as nvarchar(1024),
		@instancetype as int = 0)
	returns
	int
	AS
	BEGIN
		declare @ret as nvarchar(255)
		declare @queryStr nvarchar(255)
		declare @currentHostName nvarchar(255)
		declare @lastName nvarchar(255)
		declare @lastNumber int
		declare @patIndex int
		set @lastNumber = -1
		declare appclients cursor for
			select cl.net_hostname from APP_Client cl where  CAST(GUID AS NVARCHAR(1024)) = @guid ORDER BY net_hostname
		open appclients
		fetch next from appclients into @currentHostName
		WHILE @@FETCH_STATUS = 0
		begin
			if @currentHostName = @hostname
			begin
				set @lastNumber = 0;
			end
			else
			begin
				set @patIndex = -1
				set @patIndex = patindex(@hostname + '[_]%', @currentHostName)
				if @patIndex != 0
				begin
					declare @startIndex int
					set @startIndex = len(@hostname + '_')
					set @lastName = substring(@currentHostName, @startIndex + 1, len(@currentHostName) - @startIndex)
					if isnumeric(@lastName) = 1 and LEN(@lastName) <= 9
					begin
						set @lastNumber = convert(integer, @lastName)
					end
				end
			end
		fetch next from appclients into @currentHostName
		end
		close  appclients
		deallocate  appclients
		if @lastNumber <> -1
			return @lastNumber
		IF NOT EXISTS	(select * from APP_Client WITH (NOLOCK) where net_hostname = @hostname)
		BEGIN
			SET @lastNumber=0
			return @lastNumber
		END
		DECLARE @nintMaxNum int
		SET @nintMaxNum=2147483647
		SET @lastNumber=1
		WHILE @lastNumber <= @nintMaxNum
		begin

		IF NOT EXISTS	(select * from APP_Client WITH (NOLOCK) where net_hostname = @hostname + '_' + convert(varchar,@lastNumber))
			return @lastNumber

		SET @lastNumber=@lastNumber+1
		end
		return @lastNumber
	End



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GenerateHostName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GenerateHostName' AND revision = '1.10')

  insert into GXDBVersions values(5, 'GenerateHostName',  '1.10', 'GenerateHostName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetClientOwnersEmails.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetClientOwnersEmails'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetClientOwnersEmails]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetClientOwnersEmails]
  delete from GXDBVersions where name = 'GetClientOwnersEmails' and type = 5
END
GO

	CREATE FUNCTION GetClientOwnersEmails(@ownerId INTEGER)
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @emails VARCHAR(max)
	SET @emails = ''
	SELECT @emails = @emails + u.email + ','
	FROM UMUsers U WHERE U.id =@ownerId
	IF @emails IS NOT NULL AND LEN(@emails) > 0
	BEGIN
		SELECT @emails = SUBSTRING(@emails,1,LEN(@emails) -1)
	END
	RETURN @emails
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetClientOwnersEmails]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetClientOwnersEmails' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetClientOwnersEmails',  '1.2', 'GetClientOwnersEmails', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobOptionByIDList.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobOptionByIDList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobOptionByIDList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobOptionByIDList]
  delete from GXDBVersions where name = 'GetJobOptionByIDList' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION GetJobOptionByIDList(@jobId bigint, @optionIdList VARCHAR(MAX) )
	RETURNS
	@listTbl table (optionId bigint, value NVARCHAR(MAX), type INT)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @taskId		INT
		DECLARE @subTaskId	INT
		DECLARE @refTime	INT
		SELECT TOP 1 @taskId=taskId, @subTaskId=subTaskId, @refTime=created from TM_JobRequest WITH (READUNCOMMITTED) WHERE jobRequestId IN (SELECT jobRequestId FROM TM_Jobs WITH (READUNCOMMITTED) WHERE jobId=@jobId)

		declare @xml xml
		set @xml = @optionIdList

		INSERT INTO @listTbl
		SELECT DISTINCT optionId, value, type FROM TM_JobOptions WITH (READUNCOMMITTED)
		WHERE (jobId=@jobId OR
			(jobId=0 AND subTaskId=@subTaskId AND created <=@refTime AND (modified=0 OR modified >@refTime)))
		AND optionId in (
				SELECT	DISTINCT params.value('@val', 'int')
				FROM	@xml.nodes('/id') AS R(params)
				)
		RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobOptionByIDList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobOptionByIDList' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetJobOptionByIDList',  '1.2', 'GetJobOptionByIDList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/TemplateDelim.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: TemplateDelim'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[TemplateDelim]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[TemplateDelim]
  delete from GXDBVersions where name = 'TemplateDelim' and type = 5
END
GO

    SET QUOTED_IDENTIFIER ON
    GO
	CREATE FUNCTION TemplateDelim (@mpid int)
	returns @delims table ( monitoringingPolicyId int ,delim nvarchar(max), sdelim nvarchar(max))
	WITH ENCRYPTION
	AS
	BEGIN
	declare @pos int
	declare @sdelim nvarchar(max)
	declare @delim nvarchar(maX)
	declare @template xml
	select @template=CAST(CAST (templateXML as varchar(MAX))as xml) from APP_Template as T join APP_MonitorTemplateAssoc as MT on MT.templateId=T.templateId and MT.commcellId=T.commcellId
	set @pos= @template.value('(LogMonitoring_TemplateXML/@seperatorList)[1]','int')
	set @delim='%['
	if(@pos & 1=1)
	   set @delim=@delim+' '
	if(@pos & 2=2)
	   set @delim=@delim+' '
	if(@pos & 4=4)
	   set @delim=@delim+';'
	if(@pos & 8=8)
		set @delim=@delim+','
	if(@pos & 16=16)
	   set @delim=@delim+':'
	if(@pos &32=32)
	   set @sdelim = @template.value('(LogMonitoring_TemplateXML/@seperatorString)[1]','nvarchar(max)')
	 else
	 set @sdelim=NULL
	set @delim=@delim+']%'
	insert into @delims
	select @mpid,@delim,@sdelim
	return
	end



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [TemplateDelim]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'TemplateDelim' AND revision = '1.2')

  insert into GXDBVersions values(5, 'TemplateDelim',  '1.2', 'TemplateDelim', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/LMAddMarkTag.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: LMAddMarkTag'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LMAddMarkTag]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[LMAddMarkTag]
  delete from GXDBVersions where name = 'LMAddMarkTag' and type = 5
END
GO

     CREATE FUNCTION LMAddMarkTag(@message nvarchar(max), @position nvarchar(MAX),@delim nvarchar(max),@sdelim nvarchar(max),@isText int)
    returns  nvarchar(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
    declare @marker       int
    declare  @startLocation int
    declare @endLocation int
    declare @searchComm int
    declare @temp int
    declare @markMessage nvarchar(MAX)
    declare @sdelimPosition int
    declare @delimPosition int
    declare @len int
    declare @searchComma int
    set @len=len(@message)
    set @searchComma=CharIndex(',',@position,0)
    set @marker=1
    set @markMessage='0'
    if(@isText=1)
         begin
           set @markMessage=replace(@message,'"','''')
           return @markMessage
    end
    while(@searchComma<>0)
        	begin
        	      set @temp=CharIndex('-',@position,1)
        	      set @startLocation=cast(substring(@position,1,@temp-1) AS int)
        	      set @endLocation=cast(substring(@position,@temp+1,@searchComma-@temp-1)as int)
        	      set @position=substring(@position,@searchComma+1,len(@position))
        	       set @startLocation=@startLocation+1
                   set @endLocation=@endLocation+1
       	      set @searchComma=charIndex(',',@position,0)
        	      if(@startLocation>@len)
        	         begin
        	         if(@markMessage='0')
        			 set @markMessage=dbo.getHtmlEscapedString(substring(@message,@marker,@startLocation-@marker),1)
        		 else
        				set @markMessage=@markMessage+dbo.getHtmlEscapedString(substring(@message,@marker,@startLocation-@marker),1)
    	         return @markMessage
       	      end
        	      if(@endLocation>@len)
        	          set @endLocation=@len
        	      if(@startLocation>@marker)
        	        begin
        	   	  if(@markMessage='0')
        	 	     set @markMessage=dbo.getHtmlEscapedString(substring(@message,@marker,@startLocation-@marker),1)
        		  else
        	             set @markMessage=@markMessage+dbo.getHtmlEscapedString(substring(@message,@marker,@startLocation-@marker),1)
        	        end
        	     if(@startLocation=@endLocation)
        	     begin
        	        set @delimPosition=patIndex(@delim,substring(@message,@startLocation,@len))
        	        set @sdelimPosition =charIndex(@sdelim,substring(@message,@startLocation,@len))
        	        if(@sdelimPosition=0 AND @delimPosition=0)
        	           set @endLocation=@len
        	         else
        	         begin
        	        if((@sdelimPosition!=0 AND @sdelimPosition<@delimPosition)OR @delimPosition=0)
        	                set @endLocation=@endLocation+@sdelimPosition-2
        	        else
        	                set @endLocation=@endLocation+@delimPosition-2
        	         end
        	     end
        	     set @marker=@endLocation+1
        	    if(@markMessage='0')
        	           set @markMessage='<span style="background-color:#FFFF00">'+dbo.getHtmlEscapedString(substring(@message,@startLocation,@endLocation-@startLocation+1),1)+'</span>'
        	    else
        	           set @markMessage=@markMessage+'<span style="background-color:#FFFF00">'+dbo.getHtmlEscapedString(substring(@message,@startLocation,@endLocation-@startLocation+1),1)+'</span>'
       end
        	if(@marker<@len)
        	  set @markMessage=@markMessage+dbo.getHtmlEscapedString(substring(@message,@marker,@len),1)
        return @markMessage
        end



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [LMAddMarkTag]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'LMAddMarkTag' AND revision = '1.2')

  insert into GXDBVersions values(5, 'LMAddMarkTag',  '1.2', 'LMAddMarkTag', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobInitFromString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobInitFromString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobInitFromString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobInitFromString]
  delete from GXDBVersions where name = 'GetJobInitFromString' and type = 5
END
GO

	CREATE FUNCTION GetJobInitFromString (@InitFrom INTEGER)
	RETURNS VARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @jobInitFromString varchar(255)
	SELECT @jobInitFromString =
				  CASE @InitFrom
				  WHEN 1 THEN 'Command Line'
				  WHEN 2 THEN 'Interactive'
				  WHEN 3 THEN 'Schedule'
				  WHEN 4 THEN 'System'
				  ELSE 'N/A'  END
	RETURN @jobInitFromString
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobInitFromString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobInitFromString' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetJobInitFromString',  '1.2', 'GetJobInitFromString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJobScanTypeString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJobScanTypeString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJobScanTypeString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJobScanTypeString]
  delete from GXDBVersions where name = 'GetJobScanTypeString' and type = 5
END
GO

	CREATE FUNCTION GetJobScanTypeString (@ScanType INTEGER)
	RETURNS VARCHAR(255)
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @jobScanTypeString  varchar(255)
	SELECT  @jobScanTypeString  =
				  CASE @ScanType
				  WHEN 1 THEN 'Change Journal'
				  WHEN 2 THEN 'Classic'
				  WHEN 3 THEN 'Mixed'
				  WHEN 4 THEN 'Optimized Scan'
				  ELSE 'N/A'  END
	RETURN @jobScanTypeString
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJobScanTypeString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJobScanTypeString' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetJobScanTypeString',  '1.2', 'GetJobScanTypeString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/ClientGroupsString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ClientGroupsString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ClientGroupsString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ClientGroupsString]
  delete from GXDBVersions where name = 'ClientGroupsString' and type = 5
END
GO

 CREATE FUNCTION ClientGroupsString (
	@Client_ID		INTEGER
	)
 RETURNS @Results TABLE (
	ClientId		INT,
	ClientGroups	NVARCHAR(MAX)
 )
 AS
 BEGIN

 	DECLARE	@tblClientGroupList TABLE (Key1 BIGINT, Key2 BIGINT, ClientGroups NVARCHAR(MAX))
 	DECLARE	@tblClientGroupKey TABLE (ClientId INT, Key1 BIGINT, Key2 BIGINT)

 	INSERT INTO @tblClientGroupKey
 	SELECT	clientId, SUM(CAST(clientGroupId AS BIGINT)), SUM(CAST(clientGroupId AS BIGINT)*CAST(clientGroupId AS BIGINT))
 	FROM	APP_ClientGroupAssoc
 	WHERE	(@Client_ID = 0 OR clientId = @Client_ID)
 	GROUP BY clientId

 	DECLARE ClientGroupListCursor CURSOR FOR
 	SELECT	Key1, Key2, CG.name
 	FROM	APP_ClientGroup CG, APP_ClientGroupAssoc CGA,
 			(SELECT	Key1, Key2, MIN(ClientId) AS ClientId
 			FROM	@tblClientGroupKey
 			GROUP BY Key1, Key2) T
 	WHERE	CG.id = CGA.clientGroupId AND CGA.clientId = T.ClientId
 	ORDER BY Key1, Key2, CG.id

 	DECLARE	@k1		BIGINT = 0
 	DECLARE	@k2		BIGINT = 0
 	DECLARE	@key1	BIGINT = 0
 	DECLARE	@key2	BIGINT = 0
 	DECLARE	@name	NVARCHAR(512) = ''
 	DECLARE	@list	NVARCHAR(MAX) = ''

 	OPEN ClientGroupListCursor
 		FETCH NEXT FROM ClientGroupListCursor INTO @k1, @k2, @name
 	WHILE @@FETCH_STATUS = 0
 	BEGIN
 		IF	@k1 = @key1 AND @k2 = @key2
 			SET @list = (@list + '; ' + @name)
 		ELSE
 		BEGIN
 			IF	@key1 > 0 AND @key2 > 0
 				INSERT	INTO @tblClientGroupList
 				SELECT	@key1, @key2, @list

 			SET @list = @name
 			SET	@key1 = @k1
 			SET @key2 = @k2
 		END

 		FETCH NEXT FROM ClientGroupListCursor INTO @k1, @k2, @name
 	END
 	CLOSE ClientGroupListCursor
 	DEALLOCATE ClientGroupListCursor

 	IF	@key1 > 0 AND @key2 > 0
 		INSERT	INTO @tblClientGroupList
 		SELECT	@key1, @key2, @list

 	INSERT INTO @Results
 	SELECT	K.ClientId, L.ClientGroups
 	FROM	@tblClientGroupKey K, @tblClientGroupList L
 	WHERE	K.Key1 = L.Key1 AND K.Key2 = L.Key2

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ClientGroupsString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ClientGroupsString' AND revision = '1.5')

  insert into GXDBVersions values(5, 'ClientGroupsString',  '1.5', 'ClientGroupsString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/LargestClients.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: LargestClients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LargestClients]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[LargestClients]
  delete from GXDBVersions where name = 'LargestClients' and type = 5
END
GO

 CREATE FUNCTION LargestClients(
	@TimeRangeBegin	INTEGER,
	@TimeRangeEnd	INTEGER,
	@TopN			INTEGER,
	@CountAgedJobs	INTEGER
 )
 RETURNS @Results TABLE (
	CommServer		NVARCHAR(256),
	Client			NVARCHAR(256),
	AppSizeGB		DECIMAL(20,2),
	ShareOfTotal	DECIMAL(20,2),
	TotalSizeGB		DECIMAL(20,2)
 )
 AS
 BEGIN

 DECLARE @csName	VARCHAR(256) = (SELECT aliasName FROM APP_CommCell WHERE id = 2)

 DECLARE @TotalSize	BIGINT

 IF @TimeRangeEnd <= 0
	SET @TimeRangeEnd = 0x7FFFFFFF

 IF	@TopN <= 0
 	SET @TopN = 0x7FFFFFFF

 DECLARE @tblClientSize TABLE (ClientId INT, AppSize BIGINT)

 INSERT	INTO @tblClientSize
 SELECT	clientId, SUM(totalUnCompBytes)
 FROM	APP_Application A INNER JOIN JMBkpStats B ON A.id = B.appId
 WHERE	servEndDate BETWEEN @TimeRangeBegin AND @TimeRangeEnd
 	AND status IN (1, 3, 14) and opType IN (4, 14, 76) AND commCellId = 2
 	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700
 	AND (@CountAgedJobs = 1 OR dataStatus = 0)
 GROUP BY clientId

 SET	@TotalSize = (SELECT SUM(AppSize) FROM @tblClientSize)

 INSERT	INTO @Results
 SELECT	TOP (@TopN)
 		@csName AS CommServer,
 		name AS Client,
 		ROUND(AppSize/1024.0/1024.0/1024.0, 2) AS SizeGB,
 		ROUND(100.0*AppSize/@TotalSize, 2) AS ShareOfTotal,
 		ROUND(@TotalSize/1024.0/1024.0/1024.0, 2) AS TotalSizeGB
 FROM	@tblClientSize S INNER JOIN APP_Client C ON C.id = S.ClientId
 ORDER BY AppSize DESC

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [LargestClients]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'LargestClients' AND revision = '1.3')

  insert into GXDBVersions values(5, 'LargestClients',  '1.3', 'LargestClients', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/SlowestClients.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SlowestClients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SlowestClients]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SlowestClients]
  delete from GXDBVersions where name = 'SlowestClients' and type = 5
END
GO

 CREATE FUNCTION SlowestClients(
	@TimeRangeBegin	INTEGER,
	@TimeRangeEnd	INTEGER,
	@TopN			INTEGER,
	@BackupType		VARCHAR(32),
	@CountAgedJobs	INTEGER
	)
 RETURNS @Results TABLE (
	CommServer		NVARCHAR(256),
	Client			NVARCHAR(256),
	ThroughputMBS	DECIMAL(20,2),
	NumberOfJobs	INT
 )
 AS
 BEGIN

 DECLARE @csName	VARCHAR(256) = (SELECT aliasName FROM APP_CommCell WHERE id = 2)

 IF @TimeRangeEnd <= 0
	SET @TimeRangeEnd = 0x7FFFFFFF

 IF	@TopN <= 0
 	SET @TopN = 0x7FFFFFFF

 DECLARE @tblBackupLevel TABLE (BackupLevel INT)

 IF @BackupType = 'Full'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(1)
	INSERT INTO @tblBackupLevel VALUES(1024)
	INSERT INTO @tblBackupLevel VALUES(32768)
 END
 ELSE IF @BackupType LIKE '%Synth%'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(64)
	INSERT INTO @tblBackupLevel VALUES(16384)
 END
 ELSE IF @BackupType LIKE '%Incr%'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(2)
	INSERT INTO @tblBackupLevel VALUES(4)
	INSERT INTO @tblBackupLevel VALUES(128)
	INSERT INTO @tblBackupLevel VALUES(256)
 END
 ELSE
	SET @BackupType = ''

 DECLARE @tblClientAggr TABLE (ClientId INT, AppSize BIGINT, Duration INT, NumberOfJobs INT)

 INSERT	INTO @tblClientAggr
 SELECT	clientId, SUM(totalUnCompBytes), SUM(totalWriteTime), COUNT(jobId)
 FROM	APP_Application A INNER JOIN JMBkpStats B ON A.id = B.appId
 WHERE	servEndDate BETWEEN @TimeRangeBegin AND @TimeRangeEnd
 	AND status IN (1, 3, 14) and opType IN (4, 14, 76) AND commCellId = 2
 	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700
  	AND (@BackupType = '' OR bkpLevel IN (SELECT BackupLevel FROM @tblBackupLevel))
 	AND (@CountAgedJobs = 1 OR dataStatus = 0)
 GROUP BY clientId

 INSERT	INTO @Results
 SELECT	TOP (@TopN)
 		@csName AS CommServer,
 		name AS Client,
 		(CASE WHEN Duration > 0 THEN ROUND(AppSize/Duration/1024.0/1024.0, 2) ELSE 0 END),
 		NumberOfJobs
 FROM	@tblClientAggr S INNER JOIN APP_Client C ON C.id = S.ClientId
 ORDER BY (CASE WHEN Duration > 0 THEN ROUND(AppSize/Duration/1024.0/1024.0, 2) ELSE 0 END)

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SlowestClients]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SlowestClients' AND revision = '1.3')

  insert into GXDBVersions values(5, 'SlowestClients',  '1.3', 'SlowestClients', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/LeastDedupedJobs.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: LeastDedupedJobs'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LeastDedupedJobs]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[LeastDedupedJobs]
  delete from GXDBVersions where name = 'LeastDedupedJobs' and type = 5
END
GO

 CREATE FUNCTION LeastDedupedJobs(
	@TimeRangeBegin	INTEGER,
	@TimeRangeEnd	INTEGER,
	@LowDedupePct	INTEGER,
	@TopN			INTEGER,
	@BackupType		VARCHAR(32),
	@CountAgedJobs	INTEGER
	)
 RETURNS @Results TABLE (
	JobId			INT,
	CommServer		NVARCHAR(256),
	Client			NVARCHAR(256),
	iDA				NVARCHAR(256),
	Instance		NVARCHAR(256),
	Backupset		NVARCHAR(256),
	Subclient		NVARCHAR(256),
	StoragePolicy	NVARCHAR(256),
	Copy			NVARCHAR(256),
	AppSizeGB		DECIMAL(20,2),
	DedupeRatio		DECIMAL(20,2),
	BackupType		NVARCHAR(32),
	StartTime		NVARCHAR(32),
	EndTime			NVARCHAR(32),
	Status			NVARCHAR(32),
	DedupeStoreName	NVARCHAR(256),
	FirstBackupTime	NVARCHAR(32),
	TimeZone		NVARCHAR(256)
 )
 AS
 BEGIN

 IF @TimeRangeEnd <= 0
	SET @TimeRangeEnd = 0x7FFFFFFF

 IF	@TopN <= 0
 	SET @TopN = 0x7FFFFFFF

 DECLARE @tblBackupLevel TABLE (BackupLevel INT)

 IF @BackupType = 'Full'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(1)
	INSERT INTO @tblBackupLevel VALUES(1024)
	INSERT INTO @tblBackupLevel VALUES(32768)
 END
 ELSE IF @BackupType LIKE '%Synth%'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(64)
	INSERT INTO @tblBackupLevel VALUES(16384)
 END
 ELSE IF @BackupType LIKE '%Incr%'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(2)
	INSERT INTO @tblBackupLevel VALUES(4)
	INSERT INTO @tblBackupLevel VALUES(128)
	INSERT INTO @tblBackupLevel VALUES(256)
 END
 ELSE
	SET @BackupType = ''

 DECLARE @csName	 VARCHAR(256)
 DECLARE @csTimeZone VARCHAR(256)

 SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2

 SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
 WHERE	TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)

 DECLARE @tblJobs TABLE (jobId INT, commCellId INT, appId INT, archGrpId INT, archGrpCopyId INT,
						appSizeGB DECIMAL(20,2), dedupeRatio DECIMAL(20,2), backupLevel INT,
						startTime INT, endTime INT, status INT, SIDBStoreId INT)

 INSERT	INTO @tblJobs
 SELECT	TOP (@topN) D.jobId, D.commCellId, D.appId, D.archGrpId, D.archGrpCopyId, ROUND(B.totalUncompBytes/1024.0/1024.0/1024.0, 2),
 		DedupeRatio = CASE WHEN (B.totalUncompBytes - D.sizeOnMedia) <= 0 THEN 0
 					ELSE ROUND(100.0*(B.totalUncompBytes - D.sizeOnMedia)/B.totalUncompBytes, 2) END,
 		B.bkpLevel, B.servStartDate, B.servEndDate, B.status, 0
 FROM	JMJobDataStats D
 		INNER JOIN archGroupCopy C ON C.id = D.archGrpCopyId
 		INNER JOIN JMBkpStats B ON B.jobId = D.jobId AND B.commCellId = D.commCellId
 WHERE	D.dataType IN (1, 4) AND D.status = 100 AND (@CountAgedJobs = 1 OR (D.disabled & 256) = 0)
 	AND C.SIDBStoreId > 0
 	AND B.servEndDate BETWEEN @TimeRangeBegin AND @TimeRangeEnd
  	AND B.status IN (1, 3, 14) and B.opType IN (4, 14, 76) AND B.commCellId = 2
  	AND B.appType < 1000 AND B.appType NOT BETWEEN 600 AND 700
  	AND (@BackupType = '' OR bkpLevel IN (SELECT BackupLevel FROM @tblBackupLevel))
 	AND B.totalUncompBytes > 0 AND 100.0*(B.totalUncompBytes - D.sizeOnMedia)/B.totalUncompBytes < @LowDedupePct
 ORDER BY DedupeRatio

 UPDATE	@tblJobs
 SET	SIDBStoreId = T.SIDBStoreId
 FROM	@tblJobs J INNER JOIN
 		(SELECT	A.jobId, A.commCellId, A.archGrpCopyId, MAX(AFC.SIDBStoreId) AS SIDBStoreId
 		FROM	@tblJobs A INNER JOIN archFile AF
 					ON AF.jobId = A.jobId AND AF.commCellId = A.commCellId
 				INNER JOIN archFileCopyDedup AFC
 					ON AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = A.archGrpCopyId
 		GROUP BY A.jobId, A.commCellId, A.archGrpCopyId) T
 	ON	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.archGrpCopyId = T.archGrpCopyId

 INSERT	INTO @Results
 SELECT	J.jobId, @csName, CL.name, IT.name, I.name, BS.name, A.subclientName, AG.name, AGC.name, appSizeGB, dedupeRatio,
		dbo.GetJobBackupTypeDisplay(J.backupLevel),
		dbo.UTCToLocalStringTime(dbo.GetDateTime(J.startTime), @csTimeZone),
		dbo.UTCToLocalStringTime(dbo.GetDateTime(J.endTime), @csTimeZone),
		dbo.GetJobStatusName(J.status), S.SIDBStoreName,
		dbo.UTCToLocalStringTime(dbo.GetDateTime(S.FirstBackupTime), @csTimeZone), @csTimeZone
 FROM	@tblJobs J
 		INNER JOIN APP_Application A ON A.id = J.appId
 		INNER JOIN APP_Client CL ON CL.id = A.clientId
 		INNER JOIN APP_iDAType IT ON IT.type = A.appTypeId
 		INNER JOIN APP_InstanceName I ON I.id = A.instance
 		INNER JOIN APP_BackupsetName BS ON BS.id = A.backupset
 		INNER JOIN archGroup AG ON AG.id = J.archGrpId
 		INNER JOIN archGroupCopy AGC ON AGC.id = J.archGrpCopyId
 		INNER JOIN IdxSIDBStore S ON S.SIDBStoreId = J.SIDBStoreId

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [LeastDedupedJobs]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'LeastDedupedJobs' AND revision = '1.3')

  insert into GXDBVersions values(5, 'LeastDedupedJobs',  '1.3', 'LeastDedupedJobs', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/LongRunJobs.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: LongRunJobs'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LongRunJobs]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[LongRunJobs]
  delete from GXDBVersions where name = 'LongRunJobs' and type = 5
END
GO

 CREATE FUNCTION LongRunJobs(
	@TimeRangeBegin	INTEGER,
	@TimeRangeEnd	INTEGER,
	@LongRunHours	INTEGER,
	@TopN			INTEGER,
	@BackupType		VARCHAR(32),
	@ActiveJobsOnly	INTEGER,
	@CountAgedJobs	INTEGER
	)
 RETURNS @Results TABLE (
	JobId			INT,
	CommServer		NVARCHAR(256),
	Client			NVARCHAR(256),
	iDA				NVARCHAR(256),
	Instance		NVARCHAR(256),
	Backupset		NVARCHAR(256),
	Subclient		NVARCHAR(256),
	BackupType		NVARCHAR(32),
	StartTime		NVARCHAR(32),
	EndTime			NVARCHAR(32),
	DurationHr		DECIMAL(10,2),
	Status			NVARCHAR(32),
	AppSizeGB		DECIMAL(20,2),
	TimeZone		NVARCHAR(256)
 )
 AS
 BEGIN

 IF @TimeRangeEnd <= 0
	SET @TimeRangeEnd = 0x7FFFFFFF

 IF	@TopN <= 0
 	SET @TopN = 0x7FFFFFFF

 DECLARE @tblBackupLevel TABLE (BackupLevel INT)

 IF @BackupType = 'Full'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(1)
	INSERT INTO @tblBackupLevel VALUES(1024)
	INSERT INTO @tblBackupLevel VALUES(32768)
 END
 ELSE IF @BackupType LIKE '%Synth%'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(64)
	INSERT INTO @tblBackupLevel VALUES(16384)
 END
 ELSE IF @BackupType LIKE '%Incr%'
 BEGIN
	INSERT INTO @tblBackupLevel VALUES(2)
	INSERT INTO @tblBackupLevel VALUES(4)
	INSERT INTO @tblBackupLevel VALUES(128)
	INSERT INTO @tblBackupLevel VALUES(256)
 END
 ELSE
	SET @BackupType = ''

 DECLARE @tblJobs TABLE (jobId INT, appId INT, backupLevel INT, startTime INT, endTime INT, duration INT,
						status VARCHAR(256), appSize BIGINT)

 DECLARE @now INT = dbo.GetUnixTime(GETUTCDATE())

 DECLARE @csName	 VARCHAR(256)
 DECLARE @csTimeZone VARCHAR(256)

 SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2

 SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
 WHERE	TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)

 IF @ActiveJobsOnly = 0
 INSERT	INTO @tblJobs
 SELECT	TOP (@topN) jobId, appId, bkpLevel, servStartDate, servEndDate, (servEndDate - servStartDate),
		dbo.GetJobStatusName(status), totalUncompBytes
 FROM	JMBkpStats
 WHERE	servEndDate BETWEEN @TimeRangeBegin AND @TimeRangeEnd
  	AND status IN (1, 3, 14) and opType IN (4, 14, 76) AND commCellId = 2
  	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700
  	AND (@BackupType = '' OR bkpLevel IN (SELECT BackupLevel FROM @tblBackupLevel))
  	AND (@CountAgedJobs = 1 OR dataStatus = 0)
 ORDER BY (servEndDate - servStartDate) DESC

 INSERT	INTO @tblJobs
 SELECT	TOP (@topN) B.jobId, B.applicationId, B.bkpLevel, J.jobStartTime, 0, (@now - J.jobStartTime),
		dbo.GetJobStateName(J.state), B.unCompBytes
 FROM	JMBkpJobInfo B INNER JOIN JMJobInfo J ON J.jobId = B.jobId AND J.commCellId = B.commcellId
 WHERE (@BackupType = '' OR bkpLevel IN (SELECT BackupLevel FROM @tblBackupLevel))
 ORDER BY J.jobStartTime

 INSERT	INTO @Results
 SELECT	TOP (@topN) J.jobId, @csName, CL.name, IT.name, I.name, BS.name, A.subclientName,
		dbo.GetJobBackupTypeDisplay(J.backupLevel),
		dbo.UTCToLocalStringTime(dbo.GetDateTime(startTime), @csTimeZone),
		CASE WHEN endTime > 0 THEN dbo.UTCToLocalStringTime(dbo.GetDateTime(endTime), @csTimeZone) ELSE 'N/A' END,
		ROUND(J.duration/3600.0, 2), J.status, ROUND(appSize/1024.0/1024.0/1024.0, 2), @csTimeZone
 FROM	@tblJobs J
 		INNER JOIN APP_Application A ON A.id = J.appId
 		INNER JOIN APP_Client CL ON CL.id = A.clientId
 		INNER JOIN APP_iDAType IT ON IT.type = A.appTypeId
 		INNER JOIN APP_InstanceName I ON I.id = A.instance
 		INNER JOIN APP_BackupsetName BS ON BS.id = A.backupset
 WHERE	J.duration > @LongRunHours*3600
 ORDER BY J.duration DESC

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [LongRunJobs]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'LongRunJobs' AND revision = '1.3')

  insert into GXDBVersions values(5, 'LongRunJobs',  '1.3', 'LongRunJobs', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/WeeklyBackupSummary.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: WeeklyBackupSummary'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[WeeklyBackupSummary]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[WeeklyBackupSummary]
  delete from GXDBVersions where name = 'WeeklyBackupSummary' and type = 5
END
GO

 CREATE FUNCTION WeeklyBackupSummary(
	@StartDate		VARCHAR(32),
	@DedupOnly		INTEGER,
	@CountAgedJobs	INTEGER
	)
 RETURNS @Results TABLE (
	StoragePolicy	NVARCHAR(256),
	Copy			NVARCHAR(256),
	Dedupe			VARCHAR(4),
	WeekStartDate	VARCHAR(32),
	AppSizeGB		DECIMAL(20,2),
	SizeOnMediaGB	DECIMAL(20,2),
	DedupeRatio		DECIMAL(20,2),
	Jobs			INT,
	Clients			INT
 )
 AS
 BEGIN

 DECLARE @tblWeek TABLE (WeekStartDate DATETIME, WeekStartTime INT, WeekEndTime INT)

 DECLARE @csTimeZone	VARCHAR(256)
 DECLARE @TmpStartDate	DATETIME
 DECLARE @TmpEndDate	DATETIME
 DECLARE @Today			DATETIME = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), 0)

 SELECT	@csTimeZone = timeZone FROM APP_CommCell WHERE id = 2

 SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
 WHERE	TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)

 SET	@TmpStartDate = dbo.LocalToUTCTime(@StartDate, @csTimeZone)
 SET	@Today = dbo.LocalToUTCTime(@Today, @csTimeZone)

 WHILE (@TmpStartDate < @Today)
 BEGIN
 	SET	@TmpEndDate = DATEADD(DAY, 7, @TmpStartDate)

 	INSERT	INTO @tblWeek
 	SELECT	dbo.UTCToLocalTime(@TmpStartDate, @csTimeZone), dbo.GetUnixTime(@TmpStartDate), dbo.GetUnixTime(@TmpEndDate)

 	SET	@TmpStartDate = @TmpEndDate
 END

 DECLARE @tblSPCopy TABLE (
 		WeekStartDate DATETIME, WeekStartTime INT, WeekEndTime INT,
 		PolicyId INT, PolicyName NVARCHAR(512), CopyId INT, CopyName NVARCHAR(512), SIDBStoreId INT)

 INSERT	INTO @tblSPCopy
 SELECT	W.*, C.*
 FROM	@tblWeek W
 		CROSS JOIN (SELECT	AG.id AS PolicyId, AG.name AS PolicyName, AGC.id AS CopyId, AGC.name AS CopyName, AGC.SIDBStoreId
 					FROM	archGroup AG INNER JOIN archGroupCopy AGC
 						 ON AGC.archGroupId = AG.id AND AGC.id = AG.defaultCopy
 					WHERE	AG.type = 1 AND AG.id > 1
 						AND (AGC.SIDBStoreId > 0 OR @DedupOnly = 0)) C

 DECLARE @tblSummary TABLE (
 		WeekStartDate DATETIME, CopyId INT, AppSize BIGINT, SizeOnMedia BIGINT, nJobs INT, nClients INT)



 INSERT	INTO @tblSummary
 SELECT A.WeekStartDate, A.CopyId,
	 SUM(JM.totalUncompBytes),SUM(A.size),COUNT(DISTINCT A.jobId), COUNT(DISTINCT AA.clientId)
	 from
	 (
	 SELECT	W.WeekStartDate, W.CopyId,
			B.jobId,
 			SUM(D.sizeOnMedia) size
	 FROM	@tblSPCopy W
 			INNER JOIN JMBkpStats B ON B.servStartDate BETWEEN W.WeekStartTime AND W.WeekEndTime
 			INNER JOIN JMJobDataStats D ON D.jobId = B.jobId AND D.commCellId = B.commCellId AND D.archGrpCopyId = W.CopyId
	 WHERE	D.dataType IN (1, 4) AND D.status = 100 AND (@CountAgedJobs = 1 OR (D.disabled & 256) = 0)
  		AND B.status IN (1, 3, 14) and B.opType IN (4, 14, 18, 76) AND B.commCellId = 2
  		AND B.appType < 1000 AND B.appType NOT BETWEEN 600 AND 700
		GROUP BY W.WeekStartDate, W.CopyId,B.jobId
		) A
		INNER JOIN JMBkpStats JM ON A.jobId=JM.jobId
		INNER JOIN APP_Application AA ON AA.id = JM.appId
		GROUP BY A.WeekStartDate, A.CopyId

 INSERT INTO @Results
 SELECT	PolicyName, CopyName, (CASE WHEN SIDBStoreId > 0 THEN 'Yes' ELSE 'No' END) AS Dedupe, W.WeekStartDate,
 		ROUND(ISNULL(AppSize/1024/1024/1024, 0), 2) AS AppSizeGB,
 		ROUND(ISNULL(SizeOnMedia/1024/1024/1024, 0), 2) AS SizeOnMediaGB,
 		ISNULL(CASE WHEN SIDBStoreId = 0 OR AppSize = 0 OR AppSize < SizeOnMedia THEN 0
 				ELSE ROUND(100.0*(AppSize - SizeOnMedia)/AppSize, 2) END, 0) AS DedupeRatio,
 		ISNULL(nJobs, 0) AS nJobs, ISNULL(nClients, 0) AS nClients
 FROM	@tblSPCopy W
 		LEFT OUTER JOIN @tblSummary S ON S.WeekStartDate = W.WeekStartDate AND S.CopyId = W.CopyId
 ORDER BY PolicyName, CopyName, WeekStartDate DESC

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [WeeklyBackupSummary]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'WeeklyBackupSummary' AND revision = '1.3')

  insert into GXDBVersions values(5, 'WeeklyBackupSummary',  '1.3', 'WeeklyBackupSummary', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/BackupStrikes.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BackupStrikes'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BackupStrikes]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BackupStrikes]
  delete from GXDBVersions where name = 'BackupStrikes' and type = 5
END
GO

 CREATE FUNCTION BackupStrikes (
	@BackupWindowFrom	VARCHAR(32),
	@CountSynthFull		INTEGER
	)
 RETURNS @Results TABLE (
 	StrikeCounts	INT,
	CommServer		NVARCHAR(256),
	ClientGroups	NVARCHAR(1024),
	Client			NVARCHAR(256),
 	Agent			NVARCHAR(256),
 	Instance		NVARCHAR(256),
 	Backupset		NVARCHAR(256),
 	Subclient		NVARCHAR(256),
 	BackupType		NVARCHAR(32),
 	FailedFrom		NVARCHAR(32),
 	FailedDays		INT,
 	LastJobID		INT,
 	LastJobStart	NVARCHAR(32),
 	LastJobEnd		NVARCHAR(32),
	TimeZone		NVARCHAR(256),
 	LastJobStatus	NVARCHAR(32),
	FailureMsgIds	NVARCHAR(256),
 	FailureReason	NVARCHAR(MAX)
 )
 AS
 BEGIN

 DECLARE @csName	VARCHAR(256)
 DECLARE @csTimeZone VARCHAR(256)

 SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2

 SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
 WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)

 DECLARE @dtCurrWindowBegin DATETIME= DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), @BackupWindowFrom)
 IF		 @dtCurrWindowBegin < GETDATE()
	 SET @dtCurrWindowBegin = DATEADD(DAY, 1, @dtCurrWindowBegin)
 SET	 @dtCurrWindowBegin = dbo.ClientLocalToUTCTime(@dtCurrWindowBegin, 2)
 DECLARE @CurrWindowEnd	INT = dbo.GetUnixTime(DATEADD(DAY, 1, @dtCurrWindowBegin))
 DECLARE @hms INT = DATEPART(HOUR, @dtCurrWindowBegin)*3600 +  DATEPART(MINUTE, @dtCurrWindowBegin)*60 + DATEPART(SECOND, @dtCurrWindowBegin)

 DECLARE @TblFailedApp TABLE (vmClientId INT, appId INT, backupType INT, lastSuccJobTime INT, firstFailedJobStart DATETIME, lastFailedJobId INT, lastFailedJobTime INT)

 INSERT INTO @TblFailedApp
 SELECT	0, appId, CASE WHEN bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END, 0, NULL, MAX(jobId), 0
 FROM	JMBkpStats
 WHERE	(bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND status NOT IN (1, 14) AND failureErrorCode <> 8
 	AND (status <> 3 OR appType NOT IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND opType IN (4, 14, 18, 30, 43, 59, 65, 76) AND commCellId = 2
  	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700 AND appType <> 106
 GROUP BY appId, CASE WHEN bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END

 INSERT INTO @TblFailedApp
 SELECT JMQ.clientId, 0, CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END, 0, NULL, MAX(J.jobId), 0
 FROM	JMQinetixUpdateStatus JMQ
 		INNER JOIN JMBkpStats J
 				ON J.jobId = JMQ.jobId AND J.commCellId = JMQ.commCellId
 		INNER JOIN APP_VMProp V
 				ON JMQ.jobId = V.jobId AND JMQ.commCellId = V.commCellId
 				AND JMQ.clientId = V.VMclientId AND V.attrName = 'vmStatus' AND V.attrVal IN ('1', '2', '4')
 		INNER JOIN APP_Application A ON J.appId = A.id AND J.appId <> 0
 AND	dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 1 AND ( A.subclientStatus & (16|32|4|2) =0)
 AND    J.appType = 106 and J.commCellId = 2 and JMQ.commCellId = 2
 	AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND J.status NOT IN (1, 14) AND J.failureErrorCode <> 8
	AND opType IN (4, 14, 18, 30, 43, 59, 65, 76)
  	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700
 GROUP BY JMQ.clientId, CASE WHEN bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END

 UPDATE @TblFailedApp
 SET	lastFailedJobTime = J.servStartDate
 FROM	@TblFailedApp F INNER JOIN JMBkpStats J ON J.jobId = F.lastFailedJobId AND J.commCellId = 2

 DELETE	@TblFailedApp
 FROM	@TblFailedApp F INNER JOIN APP_Application A ON F.appId = A.id AND F.appId <> 0
 WHERE	dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 0
	OR A.dataArchGrpId <= 1 AND A.logArchGrpId <= 1
	OR (A.subclientStatus & (2 | 4)) > 0
	OR A.id IN (SELECT componentNameId FROM APP_subclientProp WHERE attrName = 'DDB Backup' AND attrVal <> '0' AND modified = 0)
	OR A.clientId IN (SELECT componentNameId FROM APP_ClientProp WHERE attrName = 'Content Index Server' AND attrVal = '1')
	OR EXISTS (SELECT * FROM JMJobAction WHERE opType = 4 AND action = 1
		AND (clientId = 1 AND appType = 0 AND appId = 1 AND clientGroupId = 0
			OR clientId = A.clientId AND appType IN (A.appTypeId, 0) OR appId = A.id))
	OR EXISTS (SELECT * FROM JMJobAction J INNER JOIN APP_ClientGroupAssoc CGA
		ON CGA.clientGroupId = J.clientGroupId AND CGA.clientId = A.clientId
		AND J.opType = 4 AND J.action = 1 AND J.clientGroupId > 0 AND J.clientId = 1 AND J.appType = 0 AND J.appId = 1)

 DECLARE @TblLastSuccJob TABLE (vmClientId INT, appId INT, backupType INT, jobId INT, startTime INT, backupLevel INT)

 INSERT INTO @TblLastSuccJob
 SELECT	0, F.appId, (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END), MAX(J.jobId), 0, 0
 FROM	JMBkpStats J INNER JOIN @TblFailedApp F
	ON  J.appId = F.appId
 WHERE	(J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND (J.status IN (1, 14) OR J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76) AND J.commCellId = 2
 GROUP BY F.appId, (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END)

 INSERT INTO @TblLastSuccJob
 SELECT F.vmClientId, 0, (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END), Max(J.jobId), 0, 0
 FROM	JMQinetixUpdateStatus JMQ
 		INNER JOIN @TblFailedApp F
 				ON F.vmClientId = JMQ.clientId AND F.vmClientId > 0
 		INNER JOIN JMBkpStats J
 				ON J.jobId = JMQ.jobId AND J.commCellId = JMQ.commCellId AND F.appId = 0
 		INNER JOIN APP_VMProp V
 				ON JMQ.jobId = V.jobId AND JMQ.commCellId = V.commCellId AND JMQ.clientId = V.VMclientId
 				AND V.attrName = 'vmStatus' AND V.attrVal IN ('0', '3')
 		INNER JOIN APP_Application A ON J.appId = A.id AND J.appId <> 0
 AND	dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 1 AND ( A.subclientStatus & (16|32|4|2) =0)
 AND    J.appType = 106 and J.commCellId = 2 and JMQ.commCellId = 2
 	AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND (J.status IN (1, 3, 14)) --OR J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND opType IN (4, 14, 18, 30, 43, 59, 65, 76)
 GROUP BY F.vmClientId, (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END)

 UPDATE @TblLastSuccJob
 SET	startTime = J.servStartDate, backupLevel = J.bkpLevel
 FROM	@TblLastSuccJob S INNER JOIN JMBkpStats J ON J.jobId = S.jobId AND J.commCellId = 2

 DELETE @TblFailedApp
 FROM	@TblFailedApp F INNER JOIN @TblLastSuccJob S ON F.vmClientId = S.vmClientId AND F.appId = S.appId
  WHERE	F.lastFailedJobTime <= S.startTime AND S.backupType IN (1, F.backupType)

 UPDATE @TblFailedApp
 SET appId = J.appId FROM @TblFailedApp F INNER JOIN JMBkpStats J ON F.lastFailedJobId = J.jobId WHERE F.appId = 0

 UPDATE @TblLastSuccJob
 SET appId = J.appId FROM @TblLastSuccJob S INNER JOIN JMBkpStats J ON S.jobId = J.jobId WHERE S.appId = 0

 UPDATE @TblFailedApp
 SET	lastSuccJobTime = S.startTime
 FROM	@TblFailedApp F INNER JOIN @TblLastSuccJob S ON F.vmClientId = S.vmClientId AND F.appId = S.appId AND F.backupType = S.backupType

 UPDATE @TblFailedApp
 SET	lastSuccJobTime = FF.startTime
 FROM	@TblFailedApp F INNER JOIN @TblLastSuccJob FF ON F.vmClientId = FF.vmClientId AND F.appId = FF.appId
 WHERE	F.backupType = 2 AND FF.backupType = 1 AND F.lastSuccJobTime < FF.startTime
 	AND (@CountSynthFull = 0 OR FF.backupLevel NOT IN (64, 128, 16384))

 DECLARE @TblFirstFailedJob	TABLE (vmClientId INT, appId INT, backupType INT, startTime INT)

 INSERT INTO @TblFirstFailedJob
 SELECT	0, F.appId, F.backupType, MIN(J.servStartDate)
 FROM	JMBkpStats J INNER JOIN @TblFailedApp F
	ON  J.appId = F.appId AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
 WHERE	(J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND J.status NOT IN (1, 14) AND J.failureErrorCode <> 8
 	AND (J.status <> 3 OR J.appType NOT IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76) AND J.commCellId = 2
  	AND J.servStartDate > F.lastSuccJobTime
 GROUP BY F.appId, F.backupType

 INSERT INTO @TblFirstFailedJob
 SELECT	F.vmClientId, J.appId, F.backupType, MIN(J.servStartDate)
 FROM	JMBkpStats J
		INNER JOIN @TblFailedApp F
				ON J.appId = F.appId AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
		INNER JOIN APP_VMProp V
 				ON V.jobId = J.jobId AND V.commCellId = J.commCellId
 			AND V.attrName = 'vmStatus' AND V.attrVal IN ('1', '2', '4')
	AND J.appType = 106 AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND J.status NOT IN (1, 14) AND J.failureErrorCode <> 8
 	AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76) AND J.commCellId = 2
 	AND J.servStartDate > F.lastSuccJobTime
 GROUP BY F.vmClientId, J.appId, F.backupType

 UPDATE @TblFailedApp
 SET	firstFailedJobStart = dbo.GetDateTime(FF.startTime)
 FROM	@TblFailedApp F INNER JOIN @TblFirstFailedJob FF ON F.vmClientId = FF.vmClientId AND F.appId = FF.appId AND F.backupType = FF.backupType

 DECLARE @TblStrikes TABLE (
		vmClientId INT, appId INT, backupType INT, failedFrom DATETIME, failedDays INT,
		lastJobId INT, lastJobStartTime DATETIME, lastJobEndTime DATETIME, lastJobStatus INT, failureReason VARCHAR(MAX))

 INSERT INTO @TblStrikes
 SELECT	F.vmClientId, F.appId, F.backupType, F.firstFailedJobStart,
 		DATEDIFF(DAY, F.firstFailedJobStart, @dtCurrWindowBegin) +
 		CASE WHEN ( DATEPART(HOUR,   F.firstFailedJobStart)*3600 +
 					DATEPART(MINUTE, F.firstFailedJobStart)*60 +
 					DATEPART(SECOND, F.firstFailedJobStart) ) > @hms
 		THEN -1 ELSE 0 END,
		J.jobId, dbo.GetDateTime(J.servStartDate), dbo.GetDateTime(J.servEndDate), J.status, J.failureReason
 FROM	JMBkpStats J INNER JOIN @TblFailedApp F
	ON  J.jobId = F.lastFailedJobId AND J.commCellId = 2

 DECLARE @tblFailureMsgIds TABLE (jobId INT, messageId INT, JPR varchar(20), failureReasonTime INT)

 INSERT INTO @tblFailureMsgIds
 SELECT	M.jobId, M.messageId, DBO.GetJPRFromMsgId(M.messageId), MAX(M.failureReasonTime) AS maxFailureReasonTime
 FROM	JMFailureReasonMsg M INNER JOIN @TblStrikes S
 	ON	M.jobId = S.lastJobId AND M.commCellId = 2 AND S.vmClientId = 0
 GROUP BY M.jobId, M.messageId
 ORDER BY M.jobId, maxFailureReasonTime DESC
 DECLARE @NewLine char(1)
 SET @NewLine=char(10)
 DECLARE @NewLine2 char(1)
 SET @NewLine2=char(13)
 DECLARE @BR char(4)
 SET @BR='<BR>'
 INSERT INTO @Results
 SELECT	CASE WHEN F.failedDays = 0 THEN 1 WHEN F.failedDays > 3 THEN 3 ELSE F.failedDays END AS StrikeCounts,
 		@csName AS CommServer,
 		ISNULL(CG.ClientGroups, '') AS ClientGroups,
 		CASE WHEN F.vmClientId = 0 THEN CL.name ELSE (SELECT name FROM APP_Client WHERE id = F.vmClientId) END AS Client,
 		IDA.name + CASE WHEN (A.appTypeId <> 106 OR ISNULL(A.id, 0) = 0) THEN ''
			ELSE ISNULL((SELECT ' in ' + name FROM APP_Client WITH (NOLOCK) WHERE id = A.clientId), '')
			END AS Agent,
 		dbo.FixInstanceName(INS.name, A.appTypeId) AS Instance,
 		B.name AS Backupset,
 		A.subclientName AS Subclient,
 		CASE WHEN F.backupType = 1 THEN 'Full' ELSE 'NonFull' END AS BackupType,
 		dbo.UTCToLocalStringTime(F.failedFrom, @csTimeZone) AS FailedFrom,
 		F.failedDays AS FailedDays,
 		F.lastJobId AS LastJobID,
 		dbo.UTCToLocalStringTime(F.lastJobStartTime, @csTimeZone) AS LastJobStart,
 		dbo.UTCToLocalStringTime(F.lastJobEndTime, @csTimeZone) AS LastJobEnd,
 		@csTimeZone AS TimeZone,
 		dbo.GetJobStatusName(F.lastJobStatus) AS LastJobStatus,
 		ISNULL((SELECT JPR + ' ; ' FROM @tblFailureMsgIds
 				WHERE jobId = F.lastJobId FOR XML PATH('')), '') AS FailureMsgIds,
 		CASE WHEN F.failureReason = '' THEN (Select V.attrVal FROM APP_VMProp V WHERE V.VMclientId = F.vmClientId AND F.lastJobId = V.jobId AND V.attrName = 'vmFailureReason')
 			ELSE (REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(LEFT(dbo.JMGetLocalizedMessageFunc(0, F.failureReason),1022),',',' '),@NewLine,';'),@NewLine2,';'),'''',' '),@BR,'')) END AS FailureReason
 FROM	@TblStrikes F
 		INNER JOIN APP_Application A ON A.id = F.appId
 		LEFT OUTER JOIN ClientGroupsStringView CG ON A.clientId = CG.ClientId
 		INNER JOIN APP_Client CL ON CL.id = A.clientId
 		INNER JOIN APP_iDAType IDA ON IDA.type = A.appTypeId
 		INNER JOIN APP_InstanceName INS ON INS.id = A.instance
 		INNER JOIN APP_BackupSetName B ON B.id = A.backupSet
 ORDER BY StrikeCounts, ClientGroups, Client, Agent, Instance, Backupset, Subclient, BackupType

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BackupStrikes]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BackupStrikes' AND revision = '1.15')

  insert into GXDBVersions values(5, 'BackupStrikes',  '1.15', 'BackupStrikes', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/StrikeRecovery.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: StrikeRecovery'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[StrikeRecovery]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[StrikeRecovery]
  delete from GXDBVersions where name = 'StrikeRecovery' and type = 5
END
GO

 CREATE FUNCTION StrikeRecovery (
	@BackupWindowFrom	VARCHAR(32),
	@CountSynthFull		INTEGER,
	@NumberOfDays		INTEGER
	)
 RETURNS @Results TABLE (
 	StrikeCounts	INT,
	CommServer		NVARCHAR(256),
	ClientGroups	NVARCHAR(1024),
	Client			NVARCHAR(256),
 	Agent			NVARCHAR(256),
 	Instance		NVARCHAR(256),
 	Backupset		NVARCHAR(256),
 	Subclient		NVARCHAR(256),
 	BackupType		NVARCHAR(32),
 	FailedFrom		NVARCHAR(32),
 	FailedDays		INT,
 	RecoveryJobID	INT,
 	RecoveryJobStart NVARCHAR(32),
 	RecoveryJobEnd	NVARCHAR(32),
	TimeZone		NVARCHAR(256)
 )
 AS
 BEGIN

 DECLARE @csName	VARCHAR(256)
 DECLARE @csTimeZone VARCHAR(256)

 SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2

 SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
 WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)

 DECLARE @dtCurrWindowBegin	DATETIME = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), @BackupWindowFrom)
 SET	 @dtCurrWindowBegin	= dbo.ClientLocalToUTCTime(@dtCurrWindowBegin, 2)
 DECLARE @hms INT = DATEPART(HOUR, @dtCurrWindowBegin)*3600 +  DATEPART(MINUTE, @dtCurrWindowBegin)*60 + DATEPART(SECOND, @dtCurrWindowBegin)
 DECLARE @CurrWindowEnd		INT = dbo.GetUnixTime(DATEADD(DAY, 1, @dtCurrWindowBegin))
 DECLARE @PrevWindowBegin	INT = dbo.GetUnixTime(DATEADD(DAY, -@NumberOfDays, @dtCurrWindowBegin))

 DECLARE @TblFailedApp TABLE (vmClientId INT, appId INT, backupType INT, prevSuccJobTime INT, recoveryJobTime INT, recoveryJobStart DATETIME,
							firstFailedJobStart DATETIME, lastFailedJobId INT, lastFailedJobTime INT)

 INSERT INTO @TblFailedApp
 SELECT	0, appId, CASE WHEN bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END, 0, 0, NULL, NULL, MAX(jobId), 0
 FROM	JMBkpStats
 WHERE	(bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND status NOT IN (1, 14) AND failureErrorCode <> 8
 	AND (status <> 3 OR appType NOT IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND opType IN (4, 14, 76) AND commCellId = 2
 	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700 AND appType <> 106
 GROUP BY appId, CASE WHEN bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END

 DELETE	@TblFailedApp
 FROM	@TblFailedApp F INNER JOIN APP_Application A ON F.appId = A.id
 WHERE	dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 0
	OR A.id IN (SELECT componentNameId FROM APP_subclientProp WHERE attrName = 'DDB Backup' AND attrVal <> '0' AND modified = 0)
	OR A.clientId IN (SELECT componentNameId FROM APP_ClientProp WHERE attrName = 'Content Index Server' AND attrVal = '1')
	OR EXISTS (SELECT * FROM JMJobAction WHERE opType = 4 AND action = 1 AND (clientId = A.ClientId AND appType IN (A.AppTypeId, 0) OR appId = A.id))

 INSERT INTO @TblFailedApp
 SELECT JMQ.clientId, J.appId, CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END, 0, 0, NULL, NULL, MAX(J.jobId), 0
	FROM	JMQinetixUpdateStatus JMQ
		INNER JOIN JMBkpStats J
 		ON J.jobId = JMQ.jobId AND J.commCellId = JMQ.commCellId
		INNER JOIN APP_VMProp V
 		ON JMQ.jobId = V.jobId AND JMQ.commCellId = V.commCellId
 			AND JMQ.clientId = V.VMclientId AND V.attrName = 'vmStatus' AND V.attrVal IN ('1', '2', '4')
 WHERE	J.appType = 106 and J.commCellId = 2 and JMQ.commCellId = 2
 	AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND J.status NOT IN (1, 14) AND J.failureErrorCode <> 8
 	AND opType IN (4, 14, 76)
 	AND appType < 1000 AND appType NOT BETWEEN 600 AND 700
 GROUP BY JMQ.clientId, J.appId, CASE WHEN bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END

 UPDATE @TblFailedApp
 SET	lastFailedJobTime = J.servStartDate
 FROM	@TblFailedApp F INNER JOIN JMBkpStats J ON J.jobId = F.lastFailedJobId AND J.commCellId = 2

 DECLARE @TblLastSuccJob TABLE (vmClientId INT, appId INT, backupType INT, jobId INT, startTime INT, backupLevel INT)

 INSERT INTO @TblLastSuccJob
 SELECT	0, F.appId, F.backupType, MIN(J.jobId), 0, 0
 FROM	JMBkpStats J INNER JOIN @TblFailedApp F
	ON  J.appId = F.appId AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
 WHERE	(J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND (J.status IN (1, 14) OR J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND J.opType IN (4, 14, 76) AND J.commCellId = 2
 	AND J.servStartDate > F.lastFailedJobTime
 GROUP BY F.appId, F.backupType

 INSERT INTO @TblLastSuccJob
 SELECT F.vmClientId, J.appId, F.backupType, MIN(J.jobId), 0, 0
 FROM	JMQinetixUpdateStatus JMQ
 	INNER JOIN @TblFailedApp F
 		ON F.vmClientId = JMQ.clientId AND F.vmClientId > 0
 	INNER JOIN JMBkpStats J
 		ON J.jobId = JMQ.jobId AND J.commCellId = JMQ.commCellId
 		AND F.appId = J.appId
 		AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
 	INNER JOIN APP_VMProp V
 		ON JMQ.jobId = V.jobId AND JMQ.commCellId = V.commCellId AND JMQ.clientId = V.VMclientId
 		AND V.attrName = 'vmStatus' AND V.attrVal IN ('0', '3')
 WHERE	J.appType = 106 and J.commCellId = 2 and JMQ.commCellId = 2
 	AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 AND (J.status IN (1, 3, 14)) --OR J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 AND opType IN (4, 14, 76)
 AND J.servStartDate > F.lastFailedJobTime
 GROUP BY F.vmClientId, J.appId, F.backupType

 UPDATE @TblLastSuccJob
 SET		startTime = J.servStartDate, backupLevel = J.bkpLevel
 FROM	@TblLastSuccJob S INNER JOIN JMBkpStats J ON J.jobId = S.jobId AND J.commCellId = 2

 --DELETE @TblFailedApp
 --FROM	@TblFailedApp F INNER JOIN @TblLastSuccJob S ON F.vmClientId = S.vmClientId AND F.appId = S.appId
 --WHERE	F.lastFailedJobTime <= S.startTime AND S.backupType IN (1, F.backupType)

 UPDATE @TblFailedApp
 SET	recoveryJobTime = S.startTime, recoveryJobStart = dbo.getDateTime(S.startTime)
 FROM	@TblFailedApp F INNER JOIN @TblLastSuccJob S ON F.vmClientId = S.vmClientId AND F.appId = S.appId AND F.backupType = S.backupType

 UPDATE @TblFailedApp
 SET	recoveryJobTime = FF.startTime, recoveryJobStart = dbo.getDateTime(FF.startTime)
 FROM	@TblFailedApp F INNER JOIN @TblLastSuccJob FF ON F.vmClientId = FF.vmClientId AND F.appId = FF.appId
 WHERE	F.backupType = 2 AND FF.backupType = 1 AND F.recoveryJobTime > FF.startTime
 	AND (@CountSynthFull = 0 OR FF.backupLevel NOT IN (64, 128, 16384))

 DELETE @TblFailedApp
 WHERE	recoveryJobTime < lastFailedJobTime OR recoveryJobTime < @PrevWindowBegin

 DECLARE @TblPrevSuccJob TABLE (vmClientId INT, appId INT, backupType INT, startTime INT)

 INSERT INTO @TblPrevSuccJob
 SELECT	0, F.appId, F.backupType, MAX(J.servStartDate)
 FROM	JMBkpStats J INNER JOIN @TblFailedApp F
	ON  J.appId = F.appId AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
 WHERE	(J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND (J.status IN (1, 14) OR J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND J.opType IN (4, 14, 76) AND J.commCellId = 2
  	AND J.servStartDate < F.lastFailedJobTime
 GROUP BY F.appId, F.backupType

 INSERT INTO @TblPrevSuccJob
 SELECT F.vmClientId, J.appId, F.backupType, MAX(J.servStartDate)
 FROM	JMQinetixUpdateStatus JMQ
	INNER JOIN @TblFailedApp F
		ON F.vmClientId = JMQ.clientId AND F.vmClientId > 0
	INNER JOIN JMBkpStats J
		ON J.jobId = JMQ.jobId AND J.commCellId = JMQ.commCellId
		AND F.appId = J.appId
		AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
	INNER JOIN APP_VMProp V
		ON JMQ.jobId = V.jobId AND JMQ.commCellId = V.commCellId AND JMQ.clientId = V.VMclientId
		AND V.attrName = 'vmStatus' AND V.attrVal IN ('0', '3')
 WHERE	J.appType = 106 and J.commCellId = 2 and JMQ.commCellId = 2
	AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
	AND (J.status IN (1, 3, 14)) --OR J.status = 3 AND J.appType IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
	AND opType IN (4, 14, 76)
 GROUP BY F.vmClientId, J.appId, F.backupType

 UPDATE @TblFailedApp
 SET	prevSuccJobTime = S.startTime
 FROM	@TblFailedApp F INNER JOIN @TblPrevSuccJob S ON F.appId = S.appId AND F.backupType = S.backupType

 UPDATE @TblFailedApp
 SET	prevSuccJobTime = FF.startTime
 FROM	@TblFailedApp F INNER JOIN @TblPrevSuccJob FF ON F.appId = FF.appId
 WHERE	F.backupType = 2 AND FF.backupType = 1 AND FF.startTime BETWEEN F.prevSuccJobTime AND F.lastFailedJobTime
 	AND (@CountSynthFull = 0 OR NOT EXISTS(SELECT jobId FROM JMBkpStats
 		WHERE appId = FF.appId AND servStartDate = FF.startTime AND bkpLevel IN (64, 128, 16384)))

 DECLARE @TblFirstFailedJob TABLE (vmClientId INT, appId INT, backupType INT, startTime INT)

 INSERT INTO @TblFirstFailedJob
 SELECT	0, F.appId, F.backupType, MIN(J.servStartDate)
 FROM	JMBkpStats J INNER JOIN @TblFailedApp F
	ON  J.appId = F.appId AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
 WHERE	(J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 	AND J.status NOT IN (1, 14) AND J.failureErrorCode <> 8
 	AND (J.status <> 3 OR J.appType NOT IN (SELECT type FROM APP_iDAType WHERE isCWEjobValid = 1))
 	AND J.opType IN (4, 14, 76) AND J.commCellId = 2
 	AND J.servStartDate BETWEEN F.prevSuccJobTime AND F.lastFailedJobTime
 GROUP BY F.appId, F.backupType

 INSERT INTO @TblFirstFailedJob
 SELECT	F.vmClientId, J.appId, F.backupType, MIN(J.servStartDate)
 	FROM	JMBkpStats J
 	INNER JOIN @TblFailedApp F
 		ON J.appId = F.appId AND (CASE WHEN J.bkpLevel IN (1, 1024, 32768, 64, 128, 16384) THEN 1 ELSE 2 END) = F.backupType
 	INNER JOIN APP_VMProp V
 		ON V.jobId = J.jobId AND V.commCellId = J.commCellId
 		AND V.attrName = 'vmStatus' AND V.attrVal IN ('1', '2', '4')
 		AND J.appType = 106 AND (J.bkpLevel NOT IN (64, 128, 16384) OR @CountSynthFull = 1)
 		AND J.status NOT IN (1, 14) AND J.failureErrorCode <> 8
 		AND J.opType IN (4, 14, 76) AND J.commCellId = 2
 		AND J.servStartDate BETWEEN F.prevSuccJobTime AND F.lastFailedJobTime
 GROUP BY F.vmClientId, J.appId, F.backupType

 UPDATE @TblFailedApp
 SET	firstFailedJobStart = dbo.GetDateTime(FF.startTime)
 FROM	@TblFailedApp F INNER JOIN @TblFirstFailedJob FF ON F.vmClientId = FF.vmClientId AND F.appId = FF.appId AND F.backupType = FF.backupType

 DECLARE @TblStrikes TABLE (
 		vmClientId INT, appId INT, backupType INT, failedFrom DATETIME, failedDays INT, hourDiff1 INT, hourDiff2 INT,
 		recoveryJobId INT, recoveryJobStart DATETIME, recoveryJobEnd DATETIME)

 INSERT INTO @TblStrikes
 SELECT	F.vmClientId, F.appId, F.backupType, F.firstFailedJobStart,
 		DATEDIFF(DAY, F.firstFailedJobStart, F.recoveryJobStart),
 		CASE WHEN ( DATEPART(HOUR,   F.firstFailedJobStart)*3600 +
 					DATEPART(MINUTE, F.firstFailedJobStart)*60 +
 					DATEPART(SECOND, F.firstFailedJobStart) ) < @hms
 		THEN -1 ELSE 1 END,
 		CASE WHEN ( DATEPART(HOUR,   F.recoveryJobStart)*3600 +
 					DATEPART(MINUTE, F.recoveryJobStart)*60 +
 					DATEPART(SECOND, F.recoveryJobStart) ) < @hms
 		THEN -1 ELSE 1 END,
 		J.jobId, dbo.GetDateTime(J.servStartDate), dbo.GetDateTime(J.servEndDate)
 FROM	JMBkpStats J INNER JOIN @TblFailedApp F
	ON  J.jobId = F.lastFailedJobId AND J.commCellId = 2;

 UPDATE	@TblStrikes
 SET	failedDays = ISNULL(failedDays + (CASE WHEN hourDiff1 < 0 AND hourDiff2 > 0 THEN 1 WHEN hourDiff1 > 0 AND hourDiff2 < 0 THEN -1 ELSE 0 END), 0)

 INSERT INTO @Results
 SELECT	CASE WHEN F.failedDays = 0 THEN 1 WHEN F.failedDays > 3 THEN 3 ELSE F.failedDays END AS StrikeCounts,
 		@csName AS CommServer,
 		ISNULL(CG.ClientGroups, '') AS ClientGroups,
 		CASE WHEN F.vmClientId = 0 THEN CL.name ELSE (SELECT name FROM APP_Client WHERE id = F.vmClientId) END AS Client,
 		IDA.name AS Agent,
 		dbo.FixInstanceName(INS.name, A.appTypeId) AS Instance,
 		B.name AS Backupset,
 		A.subclientName AS Subclient,
 		CASE WHEN F.backupType = 1 THEN 'Full' ELSE 'NonFull' END AS BackupType,
 		dbo.UTCToLocalStringTime(F.failedFrom, @csTimeZone) AS FailedFrom,
 		F.failedDays AS FailedDays,
 		F.recoveryJobId AS RecoveryJobID,
 		dbo.UTCToLocalStringTime(F.recoveryJobStart, @csTimeZone) AS RecoveryJobStart,
 		dbo.UTCToLocalStringTime(F.recoveryJobEnd,   @csTimeZone) AS RecoveryJobEnd,
 		@csTimeZone AS TimeZone
 FROM	@TblStrikes F
 		INNER JOIN APP_Application A ON A.id = F.appId
 		LEFT OUTER JOIN ClientGroupsStringView CG ON A.clientId = CG.ClientId
 		INNER JOIN APP_Client CL ON CL.id = A.clientId
 		INNER JOIN APP_iDAType IDA ON IDA.type = A.appTypeId
 		INNER JOIN APP_InstanceName INS ON INS.id = A.instance
 		INNER JOIN APP_BackupSetName B ON B.id = A.backupSet
 ORDER BY StrikeCounts, ClientGroups, Client, Agent, Instance, Backupset, Subclient, BackupType

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [StrikeRecovery]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'StrikeRecovery' AND revision = '1.3')

  insert into GXDBVersions values(5, 'StrikeRecovery',  '1.3', 'StrikeRecovery', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/CompletedBackupJobs.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: CompletedBackupJobs'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CompletedBackupJobs]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[CompletedBackupJobs]
  delete from GXDBVersions where name = 'CompletedBackupJobs' and type = 5
END
GO

 CREATE FUNCTION CompletedBackupJobs (
	@TimeRangeBegin	DATETIME,
	@TimeRangeEnd	DATETIME,
	@CountAgedJobs	INTEGER,
	@IsSummary		INTEGER
 )
 RETURNS @Results TABLE (
	JobId			INTEGER,
	CommCell		NVARCHAR(256),
	ClientGroup		NVARCHAR(MAX),
	Client			NVARCHAR(256),
	Agent			NVARCHAR(256),
	Instance		NVARCHAR(256),
	Backupset		NVARCHAR(256),
	Subclient		NVARCHAR(256),
	BackupType		NVARCHAR(16),
	ScanType		NVARCHAR(16),
	StoragePolicy	NVARCHAR(256),
	StartTime		VARCHAR(20),
	EndTime			VARCHAR(20),
	StartedFrom		NVARCHAR(32),
	StartedBy		NVARCHAR(256),
	Status			NVARCHAR(32),
	AppSizeGB		DECIMAL(20,2),
	AppSizeChangePtc INT,
	CompressionPtc	DECIMAL(10,2),
	DataWrittenGB	DECIMAL(20,2),
	SpaceSavingPct	DECIMAL(10,2),
	TransferredGB	DECIMAL(20,2),
	TransferTime	NVARCHAR(32),
	ThroughputGBPerHr DECIMAL(10,2),
	ProtectedObjects BIGINT,
	FailedObjects	BIGINT,
	FailedFolders	BIGINT,
	TimeZone		NVARCHAR(256)
 )
 AS
 BEGIN

 DECLARE @csName	 VARCHAR(256)
 DECLARE @csTimeZone VARCHAR(256)

 SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2

 SELECT	@csTimeZone = TimeZoneStdName FROM SchedTimeZone
 WHERE	TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)

 DECLARE @TotalSize	BIGINT
 DECLARE @StartTime	INT = dbo.GetUnixTime(dbo.LocalToUTCTime(@TimeRangeBegin, @csTimeZone))
 DECLARE @EndTime	INT = dbo.GetUnixTime(dbo.LocalToUTCTime(@TimeRangeEnd, @csTimeZone))

 IF	@IsSummary > 0
 INSERT	INTO @Results
 SELECT	COUNT(B.jobId), @csName, ISNULL(CG.ClientGroups, ''), CL.name, IDA.name,
 		dbo.FixInstanceName(INS.name, A.appTypeId), BS.name, A.subclientName,
 		'', '', '', '', '', '', '', '',
 		ROUND(SUM(B.totalUncompBytes)/1024.0/1024.0/1024.0, 2), 0, 0,
 		ROUND(SUM(D.SizeOnMedia)/1024.0/1024.0/1024.0, 2), 0,
 		ROUND(SUM(B.nwTransBytes)/1024.0/1024.0/1024.0, 2), '', 0, 0, 0, 0, ''
 FROM	(SELECT	JDS.jobId, JDS.commCellId, SUM(JDS.SizeOnMedia) AS SizeOnMedia
		FROM	JMBkpStats BKP WITH (NOLOCK)
				INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON JDS.jobId = BKP.jobId AND JDS.commCellId = BKP.commCellId
				INNER JOIN archGroup AG WITH (NOLOCK) ON ((AG.defaultCopy = JDS.archGrpCopyId AND BKP.opType IN (4, 14,18,76))
	         											  OR (JDS.archGrpCopyId  = AG.defaultSnapCopy AND BKP.opType IN (59,65)))
		WHERE	BKP.servEndDate BETWEEN @StartTime AND @EndTime
 			AND BKP.appType < 1000 AND BKP.appType NOT BETWEEN 600 AND 700
			AND (@CountAgedJobs = 1 OR BKP.dataStatus = 0)
		GROUP BY JDS.jobId, JDS.commCellId) D
 		INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.jobId = D.jobId AND B.commCellId = D.commCellId
 		INNER JOIN APP_Application A WITH (NOLOCK) ON A.id = B.appId
		INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = A.clientId
		INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON IDA.type = A.appTypeId
		INNER JOIN APP_InstanceName INS WITH (NOLOCK) ON INS.id = A.instance
		INNER JOIN APP_BackupsetName BS WITH (NOLOCK) ON BS.id = A.backupset
		LEFT OUTER JOIN ClientGroupsStringView CG ON CG.ClientId = A.clientId
 WHERE	(B.status IN (1, 14) OR B.status = 3 AND IDA.isCWEJobValid = 1)
 GROUP BY ISNULL(CG.ClientGroups, ''), CL.name, IDA.name, dbo.FixInstanceName(INS.name, A.appTypeId), BS.name, A.subclientName
 ORDER BY ISNULL(CG.ClientGroups, ''), CL.name, IDA.name, dbo.FixInstanceName(INS.name, A.appTypeId), BS.name, A.subclientName
 ELSE
 INSERT	INTO @Results
 SELECT	B.jobId, @csName, ISNULL(CG.ClientGroups, ''), CL.name, IDA.name,
 		dbo.FixInstanceName(INS.name, A.appTypeId), BS.name, A.subclientName,
 		dbo.GetJobBackupTypeDisplay(B.bkpLevel), dbo.GetJobScanTypeString(B.scanType), D.spName,
 		dbo.UTCToLocalStringTime(dbo.GetDateTime(B.servStartDate), @csTimeZone),
 		dbo.UTCToLocalStringTime(dbo.GetDateTime(B.servEndDate), @csTimeZone),
 		dbo.GetJobInitFromString(B.initFrom), B.userName, dbo.GetJobStatusName(B.status),
 		ROUND(B.totalUncompBytes/1024.0/1024.0/1024.0, 2), B.percentageChange,
 		CASE WHEN B.totalCompBytes > 0 AND B.totalUncompBytes > B.totalCompBytes THEN ROUND(100.0*(B.totalUncompBytes - B.totalCompBytes)/B.totalUncompBytes, 2) ELSE 0 END,
 		ROUND(D.SizeOnMedia/1024.0/1024.0/1024.0, 2),
 		CASE WHEN B.totalUncompBytes > D.SizeOnMedia THEN ROUND(100.0*(B.totalUncompBytes - D.SizeOnMedia)/B.totalUncompBytes, 2) ELSE 0 END,
 		ROUND(B.nwTransBytes/1024.0/1024.0/1024.0, 2),
 		RTRIM(B.totalWriteTime/3600) + ':' + RIGHT('0'+RTRIM((B.totalWriteTime%3600)/60), 2) + ':' + RIGHT('0'+RTRIM((B.totalWriteTime%3600)%60), 2),
 		CASE WHEN B.totalWriteTime > 0 THEN ROUND(3600.0*B.totalUncompBytes/B.totalWriteTime/1024.0/1024.0/1024.0, 2) ELSE 0 END,
 		B.totalNumOfFiles, B.scanFileFailures + B.backupFileFailures, B.scanFolderFailures + B.backupFolderFailures, @csTimeZone
 FROM	(SELECT	JDS.jobId, JDS.commCellId, JDS.appId, AG.name AS spName, SUM(JDS.SizeOnMedia) AS SizeOnMedia
		FROM	JMBkpStats BKP WITH (NOLOCK)
				INNER JOIN JMJobDataStats JDS WITH (NOLOCK) ON JDS.jobId = BKP.jobId AND JDS.commCellId = BKP.commCellId
				INNER JOIN archGroup AG WITH (NOLOCK) ON ((AG.defaultCopy = JDS.archGrpCopyId AND BKP.opType IN (4, 14,18,76))
	         											  OR (JDS.archGrpCopyId  = AG.defaultSnapCopy AND BKP.opType IN (59,65)))
		WHERE	BKP.servEndDate BETWEEN @StartTime AND @EndTime
 			AND BKP.appType < 1000 AND BKP.appType NOT BETWEEN 600 AND 700
			AND (@CountAgedJobs = 1 OR BKP.dataStatus = 0)
		GROUP BY JDS.jobId, JDS.commCellId, JDS.appId, AG.name) D
 		INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.jobId = D.jobId AND B.commCellId = D.commCellId
 		INNER JOIN APP_Application A WITH (NOLOCK) ON A.id = B.appId
		INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = A.clientId
		INNER JOIN APP_iDAType IDA WITH (NOLOCK) ON IDA.type = A.appTypeId
		INNER JOIN APP_InstanceName INS WITH (NOLOCK) ON INS.id = A.instance
		INNER JOIN APP_BackupsetName BS WITH (NOLOCK) ON BS.id = A.backupset
		LEFT OUTER JOIN ClientGroupsStringView CG ON CG.ClientId = A.clientId
 WHERE	(B.status IN (1, 14) OR B.status = 3 AND IDA.isCWEJobValid = 1)
 ORDER BY B.jobId DESC

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [CompletedBackupJobs]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'CompletedBackupJobs' AND revision = '1.4')

  insert into GXDBVersions values(5, 'CompletedBackupJobs',  '1.4', 'CompletedBackupJobs', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/VMProtectionCoverage.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: VMProtectionCoverage'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[VMProtectionCoverage]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[VMProtectionCoverage]
  delete from GXDBVersions where name = 'VMProtectionCoverage' and type = 5
END
GO

 CREATE FUNCTION VMProtectionCoverage(
	@nLastDays	INTEGER,
	@BackupType	NVARCHAR(32)
	)
 RETURNS @VMCoverage TABLE (
	VMName				NVARCHAR(256),
	BackupStatus			VARCHAR(256),
	InstanceName			NVARCHAR(256),
	BackupSetName			NVARCHAR(256),
	SubclientName			NVARCHAR(256),
	VMSizeGB			BIGINT,
	VMBackedupSizeGB		BIGINT,
	EstimatedVMDataWrittenSizeGB	BIGINT,
	LastSuccessfulBackupJobId	INTEGER,
	LastBackupTime			DATETIME,
	LastBackupType			NVARCHAR(16),
	TotalTimeForLastBackup		INTEGER,
	clientId					INTEGER,
	CommCellId					INTEGER,
    CommCellName                VARCHAR(256)
 )
 AS
 BEGIN
 -----------------------------------------------------------------------------------
 -- InPut Param: @nLastDays >0, or -1, @BackupType=Full,Synth,Incr
 -- IF @nLastDays = -1 THEN NEEDS TO COUNT ALL CURRENTLY PROTECTED VMS.
 -- USED FOR LICENSING...
 -----------------------------------------------------------------------------------
 		DECLARE	@Today		DATETIME = DATEDIFF(DAY, 0, GETDATE())
 		DECLARE	@StartTime	INT = 0
 		if @nLastDays >=0
 			SET	@StartTime = dbo.GetUnixTime(DATEADD(DAY, -@nLastDays, @Today))
 		DECLARE  @VMInfo TABLE(
			clientId			INT,
 			VMName				nvarchar(1024),
 			VMGuid				nvarchar(255),
			status				INT  --0 Discovered, 1 manually excluded
		)
 		DECLARE @tblBackupLevel TABLE (BackupLevel INT)
 		IF @BackupType = 'Full'
 		BEGIN
			INSERT INTO @tblBackupLevel VALUES(1)
			INSERT INTO @tblBackupLevel VALUES(1024)
			INSERT INTO @tblBackupLevel VALUES(32768)
 		END
 		ELSE IF @BackupType LIKE '%Synth%'
 		BEGIN
			INSERT INTO @tblBackupLevel VALUES(64)
			INSERT INTO @tblBackupLevel VALUES(16384)
 		END
 		ELSE IF @BackupType LIKE '%Incr%'
 		BEGIN
			INSERT INTO @tblBackupLevel VALUES(2)
			INSERT INTO @tblBackupLevel VALUES(4)
			INSERT INTO @tblBackupLevel VALUES(128)
			INSERT INTO @tblBackupLevel VALUES(256)
 		END
 		ELSE
			SET @BackupType = ''
			INSERT INTO @VMInfo  (clientId, VMName, VMGuid,status)
			select distinct C.id, C.name, '', 0 from APP_Client C WITH (NOLOCK)
			INNER JOIN APP_ClientProp CP WITH (NOLOCK)
			ON C.id = CP.componentNameId
			AND CP.attrName = 'Virtual Server Discovered Clients'
			AND CP.modified =0
			AND CP.attrVal = '1'
			UPDATE @VMInfo
			SET VMGuid = CP.attrVal FROM APP_ClientProp CP WITH (NOLOCK) INNER JOIN @VMInfo vmInfo ON
			vmInfo.clientId = CP.componentNameId
			AND CP.attrName='Virtual Machine GUID'
			DECLARE @VMJobInfo TABLE(
				commcellid					INT,
				clientId					INT,
				appId						INT,
				BackupStatus			    INT, -- 0 - Backed Up, 1 -  Did Not Backup, 2 - manually exlcuded
				LastSuccessfulBackupJobId	BIGINT,
				LastBackupJobId				BIGINT,
				LastBackupType				INT,
				LastBackupTime				BIGINT,
				VMBackupStartTime			BIGINT,
				VMBackupEndTime				BIGINT,
				TotalTimeForLastBackup		BIGINT,
				BackupSetName				nvarchar(1024),
				InstanceName				nvarchar(1024),
				SubClientName				nvarchar(1024),
				VMSize						BIGINT,
				VMDataWrittenSize			BIGINT,
				VMBackedupSize				BIGINT,
				DataStatus				INT
			)
			DECLARE @VMTotalSize TABLE(
				vmJobId				INT,
				TotalVMBackupSize	BIGINT,
				DataWritten			BIGINT
			)
			INSERT	INTO @VMJobInfo
			SELECT	JMQ.commCellId,
					JMQ.clientId,
					MAX(B.appId),
					1,
					MAX(CASE  WHEN B.status in ( 1,3,14,16)  THEN(
								CASE	WHEN V.attrVal IS NOT NULL AND V.attrVal IN ('0', '3')
									THEN B.jobid
								WHEN V.attrVal IS  NULL AND JMQ.status IN (1,3)
									THEN B.jobId
								ELSE 0
								END)
						END),
					MAX(B.jobId),
					0,
					0,
					0,
					0,
					0,
					NULL,
					NULL,
					NULL,
					0,
					0,
					0,
					0
			FROM JMQinetixUpdateStatus JMQ WITH (NOLOCK)
				INNER JOIN JMBkpStats B WITH (NOLOCK) ON
					B.jobId = JMQ.jobId AND
					B.commCellId = B.commCellId AND
					(@BackupType = '' OR B.bkpLevel IN (SELECT BackupLevel FROM @tblBackupLevel))
				LEFT OUTER JOIN APP_VMProp V WITH (NOLOCK) ON
					JMQ.jobId = V.jobId AND
					JMQ.commCellId = V.commCellId AND
					JMQ.clientId = V.VMclientId AND
				V.attrName = 'vmStatus'
			WHERE	B.appType = 106
			GROUP BY
				JMQ.clientId, JMQ.commCellId
		UPDATE @VMJobInfo
		SET VMSize = CAST(V.attrVal as bigint)
		FROM APP_VMProp V WITH (NOLOCK) INNER JOIN @VMJobInfo vm ON
			V.VMclientId = vm.clientId
			AND vm.LastSuccessfulBackupJobId = V.jobId
			AND V.attrName ='vmSize'
		UPDATE @VMJobInfo
		SET VMBackedupSize = CAST(V.attrVal as bigint)
		FROM APP_VMProp V WITH (NOLOCK) INNER JOIN @VMJobInfo vm ON
			V.VMclientId = vm.clientId
			AND vm.LastSuccessfulBackupJobId = V.jobId
			AND V.attrName ='vmUsedSpace'
		UPDATE @VMJobInfo
		SET VMBackupStartTime = CAST(V.attrVal AS BIGINT)
		FROM APP_VMProp V WITH (NOLOCK) INNER JOIN @VMJobInfo vm ON
			V.VMclientId = vm.clientId
			AND vm.LastSuccessfulBackupJobId = V.jobId
			AND V.attrName ='vmBackupStartTime'
		UPDATE @VMJobInfo
		SET VMBackupEndTime = CAST(V.attrVal AS BIGINT)
		FROM APP_VMProp V WITH (NOLOCK) INNER JOIN @VMJobInfo vm ON
			V.VMclientId = vm.clientId
			AND vm.LastSuccessfulBackupJobId = V.jobId
			AND V.attrName ='vmBackupEndTime'
		INSERT INTO @VMTotalSize
		SELECT LastSuccessfulBackupJobId, SUM(VMBackedupSize),0 FROM @VMJobInfo where LastSuccessfulBackupJobId > 0 group by LastSuccessfulBackupJobId
		UPDATE  @VMTotalSize
		SET     DataWritten = ISNULL(
					   (SELECT TOP 1 T.sizeOnMedia
						   FROM    (SELECT S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
							   FROM    JMJobDataStats S WITH (READUNCOMMITTED)
								   WHERE   2 = S.commcellId and vmJobId =S.jobid and S.AuxCopyJobId = 0
								   GROUP BY S.archGrpCopyId) AS T),0)
		UPDATE	@VMJobInfo
		SET		appId = B.appId,
				LastBackupType = B.bkpLevel,
				--TotalTimeForLastBackup = (B.servEndDate - B.servStartDate),
					LastBackupTime = B.servEndDate,
					DataStatus = B.DataStatus
			FROM	@VMJobInfo V INNER JOIN
					JMBkpStats B WITH (NOLOCK) ON
					B.jobId =  V.LastSuccessfulBackupJobId
					AND B.commCellId = V.commcellid
					AND B.status in (1,3,14,16)
		IF @nLastDays < 0
			DELETE FROM @VMJobInfo WHERE DataStatus >0
		UPDATE @VMJobInfo
		SET		appId = B.appId
		FROM @VMJobInfo V INNER JOIN
			JMBkpStats B WITH (NOLOCK) ON
			v.LastSuccessfulBackupJobId = 0
			AND B.jobId = v.LastBackupJobId
		UPDATE	@VMJobInfo
		SET		SubClientName = A.subclientName,
				BackupSetName = BS.name,
				InstanceName = I.name
		FROM	@VMJobInfo vmJobInfo
				INNER JOIN APP_Application A WITH (NOLOCK) ON
					vmJobInfo.appId = A.id
					INNER JOIN APP_BackupSetName BS WITH (NOLOCK) ON
					BS.id = A.backupSet
				INNER JOIN APP_InstanceName I ON
					I.id = A.instance
		if @nLastDays >=0
			UPDATE @VMJobInfo
			SET BackupStatus = ( SELECT CASE WHEN LastBackupTime < @StartTime THEN 1
										 ELSE 0
										 END )
		else
			UPDATE @VMJobInfo SET BackupStatus = 0 where LastBackupTime >0
		UPDATE @VMInfo SET status = 1
		FROM @VMInfo vmInfo
			INNER JOIN APP_SubClientProp SCP WITH (NOLOCK)
				ON	vmInfo.VMName = SUBSTRING(SCP.attrVal, 0, CHARINDEX(' ',SCP.attrVal))
				AND	SCP.attrType = 121 AND SCP.modified = 0
			INNER JOIN APP_Application app WITH (NOLOCK)
				ON app.id = SCP.componentNameId
			AND	app.subclientName LIKE 'Do Not Backup' AND app.appTypeId = 106
		UPDATE @VMJobInfo
		SET VMDataWrittenSize = cast(VMBackedupSize*(cast(vmTotalSize.DataWritten as real)/vmTotalSize.TotalVMBackupSize) as bigint)
		FROM @VMTotalSize vmTotalSize INNER JOIN @VMJobInfo
		ON vmTotalSize.vmJobId = LastSuccessfulBackupJobId
		AND vmTotalSize.TotalVMBackupSize > 0
		AND LastSuccessfulBackupJobId >0
	DECLARE @CommCellId INT
	DECLARE @aliasName varchar(256)
	SELECT @CommCellId = number, @aliasName=aliasName from APP_CommCell WITH (NOLOCK) where clientId =2
		INSERT INTO @VMCoverage
			SELECT	VMName,
					(CASE WHEN BackupStatus IS NULL
						THEN ( CASE vmInfo.status  WHEN 0 THEN 'Discovered, Not protected'
								ELSE 'Manually Excluded'
								END
						)
						ELSE ( CASE BackupStatus
								WHEN 0 THEN 'Currently protected'
								WHEN 1 THEN 'Not protected in the time range'
								END
						)
						END ) as BackupStatus,
					InstanceName,
					BackupSetName,
					SubClientName,
					CAST(VMSize/1024.0/1024.0/1024.0 as decimal(10,2)) as VMSizeGB,
					CAST(VMBackedupSize/1024.0/1024/1024 as decimal(10,2)) as VMBackedupSizeGB,
					CAST(VMDataWrittenSize/1024.0/1024/1024 as decimal(10,2) ) as EstimatedVMDataWrittenSizeGB,
					LastSuccessfulBackupJobId,
					dbo.GetDateTime(LastBackupTime) as LastBackupTime,
					CASE LastBackupType
						WHEN 1 THEN 'Full'
						WHEN 2 THEN 'Incremental'
						WHEN 4 THEN 'Differential'
						WHEN 64 THEN 'SyntheticFull'
						ELSE null
						END as LastBackupType,
					--TotalTimeForLastBackup,
					VMBackupEndTime - VMBackupStartTime as TotalTimeForLastBackup,
					vmInfo.clientId,
					@CommCellId as CommCellId,
                    @aliasName  as CommCellName
			FROM	@VMInfo vmInfo
			LEFT OUTER JOIN @VMJobInfo vmJobInfo
			ON vmInfo.clientId = vmJobInfo.clientId
			ORDER BY VMName
    RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [VMProtectionCoverage]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'VMProtectionCoverage' AND revision = '1.7')

  insert into GXDBVersions values(5, 'VMProtectionCoverage',  '1.7', 'VMProtectionCoverage', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DataProtectionCoverage.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DataProtectionCoverage'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DataProtectionCoverage]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DataProtectionCoverage]
  delete from GXDBVersions where name = 'DataProtectionCoverage' and type = 5
END
GO

 CREATE FUNCTION DataProtectionCoverage(
	@nLastDays	INTEGER,
	@bSummary	INTEGER
	)
 RETURNS @ClientDPCoverage TABLE (
	Client				NVARCHAR(256),
	ClientGroup			NVARCHAR(MAX),
	ClientDescription	NVARCHAR(MAX),
	Agent				NVARCHAR(256),
	Instance			NVARCHAR(256),
	Backupset			NVARCHAR(256),
	Subclient			NVARCHAR(256),
	Category			NVARCHAR(64),
	SLA_Reason			NVARCHAR(64),
	Scheduled			VARCHAR(4),
	SuccessfulJobs		INTEGER,
	UnsuccessfulJobs	INTEGER,
	LastBackupJobID		INTEGER,
	LastBackupType		NVARCHAR(16),
	LastJobStartTime	VARCHAR(20),
	LastJobEndTime		VARCHAR(20),
	LastJobStatus		NVARCHAR(32),
	LastJobAppSizeGB	FLOAT,
	LastJobFailureReason NVARCHAR(MAX),
    LastOnlineTime      VARCHAR(20)
 )
 AS
 BEGIN

	DECLARE @csTimeZoneName NVARCHAR(255) = (SELECT timeZone FROM APP_CommCell WHERE id = 2)

	SELECT  @csTimeZoneName = TimeZoneStdName
	FROM    SchedTimeZone
	WHERE   TimeZoneName = SUBSTRING(@csTimeZoneName, CHARINDEX(':', @csTimeZoneName, CHARINDEX(':', @csTimeZoneName, 0) + 1) + 1, 255)

	DECLARE	@Today		DATETIME = DATEDIFF(DAY, 0, GETDATE())
	DECLARE	@StartTime	INT

	SET	@StartTime = dbo.GetUnixTime(DATEADD(DAY, -@nLastDays, @Today))

	DECLARE	@tblSubclient TABLE (ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT, SubclientName NVARCHAR(128),
								ClientGroupList NVARCHAR(MAX), BackupScheduled INT, Deconfigured INT, Disabled INT)

	INSERT	INTO @tblSubclient
	SELECT	A.clientId, A.appTypeId, A.instance, A.backupSet, A.id, A.SubclientName, '', 0,
			CASE WHEN (A.subclientStatus & 6) = 0 THEN 0 ELSE 1 END AS Deconfigured, 0
	FROM	APP_Application A
	WHERE	dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 1
		AND A.id NOT IN (SELECT componentNameId FROM APP_subclientProp WHERE attrName = 'DDB Backup' AND attrVal <> '0' AND modified = 0)
		AND A.clientId NOT IN (SELECT componentNameId FROM APP_ClientProp WHERE attrName = 'Content Index Server' AND attrVal = '1')

	UPDATE	@tblSubclient
	SET		Disabled = 1
	FROM	@tblSubclient S INNER JOIN JMJobAction J
		ON	J.opType = 4 AND J.action = 1 AND (J.clientId = S.ClientId AND J.appType IN (S.AppTypeId, 0) OR J.appId = S.AppId)

	DECLARE	@tblSubclientAggr TABLE (AppId INT, nSuccessfulJobs INT, nUnsuccessfulJobs INT, ScanStarted INT, ScanCompleted INT, DataTransfer INT,
			LastSuccessfulJobID INT, LastJobID INT, LastJobType INT, LastJobStartTime INT, LastJobEndTime INT, LastJobStatus INT,
			LastJobAppSize BIGINT, LastJobFailureReason VARCHAR(256))

	INSERT	INTO @tblSubclientAggr
	SELECT	S.AppId,
			SUM(CASE WHEN B.jobId IS NOT NULL AND B.status IN (1, 3, 14) THEN 1 ELSE 0 END),
			SUM(CASE WHEN B.jobId IS NOT NULL AND B.status NOT IN (1, 3, 14) THEN 1 ELSE 0 END),
			0, 0, 0,
			MAX(CASE WHEN B.status IN (1, 3, 14) THEN B.jobId ELSE 0 END),
			MAX(B.jobId),
			0, 0, 0 ,0, 0, ''
	FROM	@tblSubclient S INNER JOIN JMBkpStats B ON B.appId = S.AppId
	WHERE	B.servEndDate > @StartTime AND B.bkpLevel IN (1, 2, 4, 256, 1024, 32768) AND B.commCellId = 2
	GROUP BY S.AppId

	IF	@bSummary = 1
	BEGIN
		INSERT	INTO @ClientDPCoverage
		SELECT	'', 'All', '', '', '', '', '',
				CASE WHEN S.Deconfigured > 0 OR S.Disabled > 0 OR CL.clientDescription LIKE '%offline%' THEN 'Excluded'
					 WHEN ISNULL(A.nSuccessfulJobs, 0) > 0 THEN 'Protected'
					 ELSE 'Not Protected' END,
				'', '', COUNT(*), 0, 0, '', '', '', '', 0, '',''
		FROM	@tblSubclient S
				LEFT OUTER JOIN @tblSubclientAggr A ON A.AppId = S.AppId
				INNER JOIN APP_Client CL ON CL.id = S.ClientId
				INNER JOIN APP_InstanceName INST ON INST.id = S.InstanceId
		WHERE	CL.origCCId NOT IN (SELECT id FROM APP_CommCell WHERE type > 1) AND (INST.status & 2048) = 0
		GROUP BY CASE WHEN S.Deconfigured > 0 OR S.Disabled > 0 OR CL.clientDescription LIKE '%offline%' THEN 'Excluded'
					  WHEN ISNULL(A.nSuccessfulJobs, 0) > 0 THEN 'Protected'
					  ELSE 'Not Protected' END

		INSERT	INTO @ClientDPCoverage
		SELECT	'', ISNULL(CG.name, ''), '', '', '', '', '',
				CASE WHEN S.Deconfigured > 0 OR S.Disabled > 0 OR CL.clientDescription LIKE '%offline%' THEN 'Excluded'
					 WHEN ISNULL(A.nSuccessfulJobs, 0) > 0 THEN 'Protected'
					 ELSE 'Not Protected' END,
				'', '', COUNT(*), 0, 0, '', '', '', '', 0, '',''
		FROM	@tblSubclient S
				LEFT OUTER JOIN @tblSubclientAggr A ON A.AppId = S.AppId
				INNER JOIN APP_Client CL ON CL.id = S.ClientId
				INNER JOIN APP_InstanceName INST ON INST.id = S.InstanceId
				LEFT OUTER JOIN APP_ClientGroupAssoc CGA ON CGA.clientId = S.ClientId
				LEFT OUTER JOIN APP_ClientGroup CG ON CG.id = CGA.clientGroupId
		WHERE	CL.origCCId NOT IN (SELECT id FROM APP_CommCell WHERE type > 1) AND (INST.status & 2048) = 0
		GROUP BY ISNULL(CG.name, ''),
				CASE WHEN S.Deconfigured > 0 OR S.Disabled > 0 OR CL.clientDescription LIKE '%offline%' THEN 'Excluded'
					 WHEN ISNULL(A.nSuccessfulJobs, 0) > 0 THEN 'Protected'
					 ELSE 'Not Protected' END
	END
	ELSE
	BEGIN
		UPDATE	@tblSubclient
		SET		ClientGroupList = CG.ClientGroups
		FROM	@tblSubclient SC
				INNER JOIN ClientGroupsStringView CG ON CG.ClientId = SC.ClientId

		DECLARE	@tblBackupTask TABLE (ClientGroupId INT, ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT)

		INSERT	INTO @tblBackupTask
		SELECT	DISTINCT AE.clientGroupId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId
		FROM	TM_AssocEntity AE
		        INNER JOIN TM_SubTask ST ON AE.taskId = ST.taskId
		        INNER JOIN TM_SubTaskOptions STO ON STO.subTaskId = ST.SubTaskId
		        INNER JOIN TM_Task T ON T.taskId = ST.taskId
		WHERE	STO.optionId = 458405394 AND STO.value IN ('1', '2', '3', '6')
			AND ST.subTaskType = 2
			AND T.disabled = 0
			AND (AE.clientGroupId = 0 AND AE.taskId NOT IN (SELECT DISTINCT taskId FROM TM_AssocFilter WHERE filter_type = 2 AND filter_value = 124)
			  OR AE.clientGroupId > 0 AND AE.taskId NOT IN (SELECT taskId FROM TM_Task WHERE taskName = 'System Created for Content Store' AND taskType = 4))
		DECLARE @clientOnlineTime TABLE ( clientId int, LastOnlineTime INT)

        DECLARE @csClientId  int
        SET @csClientId = (SELECT distinct ClientID From APP_CommCell WHERE id = 2)

		INSERT INTO @clientOnlineTime
		SELECT  C.id,MAX(LastOnlineTime)
		FROM CCRClientToClient CCR
		INNER JOIN APP_Client C
		ON CCR.FromClientID = @csClientId
		AND CCR.ToClientID = C.id
		GROUP BY C.id

		UPDATE	@tblSubclient
		SET		BackupScheduled = 1
		FROM	@tblSubclient S, @tblBackupTask T
		WHERE (	T.ClientId = 0 AND T.ClientGroupId = 0
			OR	T.ClientId > 0 AND S.ClientId = T.ClientId
				AND S.AppTypeId IN (T.AppTypeId, 0) AND S.InstanceId IN (T.InstanceId, 0) AND S.BackupsetId IN (T.BackupsetId, 0) AND S.AppId IN (T.AppId, 0) )

		UPDATE	@tblSubclient
		SET		BackupScheduled = 1
		FROM	@tblSubclient S, APP_ClientGroupAssoc CGA,
				(SELECT ClientGroupId FROM @tblBackupTask WHERE ClientId = 0 AND ClientGroupId > 0) T
		WHERE	S.BackupScheduled = 0 AND S.ClientId = CGA.clientId AND CGA.ClientGroupId = T.ClientGroupId

		UPDATE	@tblSubclientAggr
		SET		LastJobId = LastSuccessfulJobID
		WHERE	LastSuccessfulJobID > 0

		UPDATE	@tblSubclientAggr
		SET		LastJobStartTime = B.servStartDate, LastJobEndTime = B.servEndDate,
				LastJobType = B.bkpLevel, LastJobStatus = B.status,
				LastJobAppSize = B.totalUncompBytes, LastJobFailureReason = B.failureReason
		FROM	@tblSubclientAggr S INNER JOIN JMBkpStats B
			ON B.jobId = S.LastJobId AND B.commCellId = 2

		UPDATE	@tblSubclientAggr
		SET		ScanStarted		= CASE WHEN Y.ScanStarted > 0 THEN 1 ELSE 0 END,
				ScanCompleted	= CASE WHEN Y.ScanCompleted > 0 THEN 1 ELSE 0 END,
				DataTransfer	= CASE WHEN Y.DataTransfer > 0 THEN 1 ELSE 0 END
		FROM	@tblSubclientAggr X,
				(SELECT	S.AppId,
						COUNT(B.jobId) AS ScanStarted,
						SUM(CASE WHEN A.status = 1 THEN 1 ELSE 0 END) AS ScanCompleted,
						SUM(A.nwTransBytes) AS DataTransfer
				FROM	@tblSubclientAggr S
				INNER JOIN JMBkpStats B
					ON	B.appId = S.AppId
				INNER JOIN JMBkpAtmptStats A
					ON	A.jobId = B.jobId AND A.commCellId = B.commCellId
				WHERE	B.servEndDate > @StartTime AND B.bkpLevel IN (1, 2, 4, 256, 1024, 32768) AND B.commCellId = 2
				GROUP BY S.AppId) Y
		WHERE	X.AppId = Y.AppId

		INSERT	INTO @ClientDPCoverage
		SELECT	CL.name,
				S.ClientGroupList,
				CL.clientDescription,
				IDA.name,
				dbo.FixInstanceName(INST.name, S.AppTypeId),
				BSN.name,
				S.SubclientName,
				CASE WHEN S.Deconfigured > 0 OR S.Disabled > 0 OR CL.clientDescription LIKE '%offline%' THEN 'Excluded'
					 WHEN ISNULL(A.nSuccessfulJobs, 0) > 0 THEN 'Protected'
					 ELSE 'Not Protected' END,
				CASE WHEN S.Deconfigured > 0			THEN 'Deconfigured'
					 WHEN S.Disabled > 0				THEN 'Backup Disabled'
					 WHEN CL.clientDescription LIKE '%offline%'	THEN 'Offline'
					 WHEN ISNULL(A.nSuccessfulJobs, 0) > 0		THEN 'Protected'
					 WHEN ISNULL(A.nUnsuccessfulJobs, 0) > 0 AND ISNULL(A.DataTransfer, 0) > 0
																THEN 'Backup Failed With Transferred Data'
					 WHEN ISNULL(A.nUnsuccessfulJobs, 0) > 0 AND ISNULL(A.ScanCompleted, 0) = 1 AND ISNULL(A.DataTransfer, 0) = 0
																THEN 'Backup Failed Without Transferred Data'
					 WHEN ISNULL(A.nUnsuccessfulJobs, 0) > 0 AND ISNULL(A.ScanStarted, 0) = 1 AND ISNULL(A.ScanCompleted, 0) = 0
																THEN 'Backup Scan Phase Not Completed'
					 WHEN ISNULL(A.nUnsuccessfulJobs, 0) > 0 AND ISNULL(A.ScanStarted, 0) = 0
																THEN 'Backup Scan Phase Not Started'
					 WHEN ISNULL(A.nUnsuccessfulJobs, 0) = 0 AND S.BackupScheduled = 1
																THEN 'Backup May Be Scheduled At A Later Time'
					 WHEN ISNULL(A.nUnsuccessfulJobs, 0) = 0 AND S.BackupScheduled = 0
																THEN 'Backup Not Scheduled'
					 ELSE 'Not Protected' END,
				CASE WHEN S.Deconfigured > 0 OR S.Disabled > 0 THEN 'N/A' WHEN S.BackupScheduled = 1 THEN 'Yes' ELSE 'NO' END,
				ISNULL(A.nSuccessfulJobs, 0),
				ISNULL(A.nUnsuccessfulJobs, 0),
				ISNULL(A.LastJobID, 0),
				CASE WHEN ISNULL(A.LastJobType, 0) = 0 THEN 'N/A'
					 ELSE dbo.GetJobBackupTypeDisplay(A.LastJobType) END,
				CASE WHEN ISNULL(A.LastJobStartTime, 0) = 0 THEN 'N/A'
					 ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(A.LastJobStartTime), @csTimeZoneName) END,
				CASE WHEN ISNULL(A.LastJobEndTime, 0) = 0 THEN 'N/A'
					 ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(A.LastJobEndTime), @csTimeZoneName) END,
				CASE WHEN ISNULL(A.LastJobStatus, 0) = 0 THEN 'No Run'
					 WHEN A.LastJobStatus = 1  THEN 'Completed'
					 WHEN A.LastJobStatus = 3  THEN 'Completed With Errors'
					 WHEN A.LastJobStatus = 14 THEN 'Completed With Warnings'
					 WHEN A.LastJobStatus IN (2, 9)  THEN 'Failed'
					 WHEN A.LastJobStatus IN (4, 15) THEN 'Killed' END,
				ROUND(ISNULL(A.LastJobAppSize, 0)/1024.0/1024.0/1024.0, 2),
				dbo.JMGetLocalizedMessageFunc(0, ISNULL(A.LastJobFailureReason, '')),
				CASE WHEN ISNULL(clTime.LastOnlineTime, 0) = 0 THEN 'N/A'
					 ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(clTime.LastOnlineTime), @csTimeZoneName) END
		FROM	@tblSubclient S
				LEFT OUTER JOIN @tblSubclientAggr A ON A.AppId = S.AppId
				INNER JOIN APP_Client CL ON CL.id = S.ClientId
				INNER JOIN APP_iDAType IDA ON IDA.type = S.AppTypeId
				INNER JOIN APP_InstanceName INST ON INST.id = S.InstanceId
				INNER JOIN APP_BackupsetName BSN ON BSN.id = S.BackupsetId
				LEFT OUTER JOIN @clientOnlineTime clTime ON clTime.clientId = S.ClientId
		WHERE	CL.origCCId NOT IN (SELECT id FROM APP_CommCell WHERE type > 1) AND (INST.status & 2048) = 0
		ORDER BY S.Deconfigured DESC,
				S.Disabled DESC,
				CASE WHEN CL.clientDescription LIKE '%offline%' THEN 1 ELSE 0 END DESC,
				(CASE WHEN ISNULL(A.nSuccessfulJobs, 0) > 0 THEN 2 WHEN ISNULL(A.nUnsuccessfulJobs, 0) > 0 THEN 1 ELSE 0 END),
				ISNULL(A.DataTransfer, 0) DESC,
				ISNULL(A.ScanCompleted, 0) DESC,
				ISNULL(A.ScanStarted, 0) DESC,
				S.BackupScheduled DESC,
				CL.name,
				IDA.name,
				BSN.name,
				S.SubclientName
	END
    RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DataProtectionCoverage]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DataProtectionCoverage' AND revision = '1.5')

  insert into GXDBVersions values(5, 'DataProtectionCoverage',  '1.5', 'DataProtectionCoverage', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DataProtectionCoverageSummary.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DataProtectionCoverageSummary'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DataProtectionCoverageSummary]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DataProtectionCoverageSummary]
  delete from GXDBVersions where name = 'DataProtectionCoverageSummary' and type = 5
END
GO

 CREATE FUNCTION DataProtectionCoverageSummary(
	@nLastDays	INTEGER
	)
 RETURNS @DPCoverageSummary TABLE (
	ClientGroup				NVARCHAR(MAX),
	nExcludedSubclients		INTEGER,
	nProtectedSubclients	INTEGER,
	nNotProtectedSubclients	INTEGER
 )
 AS
 BEGIN

    INSERT	INTO @DPCoverageSummary
    SELECT	ClientGroup,
    		SUM(CASE WHEN Category = 'Excluded' THEN SuccessfulJobs ELSE 0 END),
    		SUM(CASE WHEN Category = 'Protected' THEN SuccessfulJobs ELSE 0 END),
    		SUM(CASE WHEN Category = 'Not Protected' THEN SuccessfulJobs ELSE 0 END)
	FROM	dbo.DataProtectionCoverage(@nLastDays, 1)
	GROUP BY ClientGroup
	ORDER BY ClientGroup

	RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DataProtectionCoverageSummary]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DataProtectionCoverageSummary' AND revision = '1.3')

  insert into GXDBVersions values(5, 'DataProtectionCoverageSummary',  '1.3', 'DataProtectionCoverageSummary', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/CommCellBackupInfoFn.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: CommCellBackupInfoFn'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CommCellBackupInfoFn]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[CommCellBackupInfoFn]
  delete from GXDBVersions where name = 'CommCellBackupInfoFn' and type = 5
END
GO

	CREATE FUNCTION CommCellBackupInfoFn(@days int)
	RETURNS
	@listJobs table (jobid  bigint,
    appid  int,
	jobinitfrom nvarchar(20),
	clientname  nvarchar(1024),
	idataagent  nvarchar(1024),
	instance    nvarchar(1024),
	backupset   nvarchar(1024),
	subclient   nvarchar(1024),
	data_sp     nvarchar(1024),
	backuplevelInt  int,
	backuplevel nvarchar(64),
	incrlevel  int,
	jobstatusInt int,
	jobstatus nvarchar(20),
	jobfailedreason  nvarchar(max),
	startdateunixsec  int,
	enddateunixsec int,
	startdate  datetime,
	enddate    datetime,
	durationunixsec  int,
	duration  nvarchar(20),
	numstreams  int,
	numbytesuncomp  bigint,
	numbytescomp bigint,
	numobjects  bigint,
	isAged  int,
	isAgedStr nvarchar(20),
	xmlJobOptions xml,
	retentionDays int,
	systemStateBackup int
	)
	WITH ENCRYPTION
	AS
	BEGIN
	---Copyright (c) 1998  CommVault Systems, Inc.
	---Display Backup History Info
	DECLARE @date int =0
	IF ( @days > 0 )
		SET @date =dbo.GetUnixTime(DATEADD(day, -@days,GETUTCDATE()))
	IF ( @days > 0 )
	BEGIN
		INSERT INTO @listJobs
		SELECT
		jobid=BS.jobId,
		appid=BS.appid,
		jobinitfrom=
		case BS.initFrom
		when 1 then 'Command Line'
		when 2 then 'Gui'
		when 3 then 'Schedule'
		when 4 then 'System'
					end,
		clientname = dbo.APP_Client.name,
		idataagent = dbo.APP_IDAType.name,
		instance = APP_InstanceName.name,
		backupset = dbo.APP_BackupSetName.Name,
		subclient = dbo.app_application.SubClientName,
		data_sp=dbo.archGroup.name ,
		backuplevelInt =BS.bkplevel,
		backuplevel =
		CASE  BS.bkplevel
		 WHEN 1 THEN 'Full'
		 WHEN 2 THEN 'Incremental'
		 WHEN 4 THEN 'Differential'
		 WHEN 64 THEN 'SyntheticFull'
		 WHEN 128 THEN 'SyntheticFull'
		 WHEN 256 THEN 'Transaction Log w. NoTruncate'
		 WHEN 512 THEN 'ASR'
		 WHEN 16384 THEN 'Incremental'
		 ELSE 'Unknown'
		 END,
		incrlevel =
		case  BS.bkplevel
		when 2 then
			 case BS.oraSublevel
			 when 0 then 1
			 else BS.oraSublevel
			 end
		else 0
		end,
		jobstatusInt =BS.status,
		jobstatus =
		 CASE BS.status
		 WHEN 1 THEN 'Success'
		 WHEN 2 THEN 'Failed'
		 WHEN 3 THEN 'PartialSuccess'
		 WHEN 4 THEN 'Killed'
		 WHEN 5 THEN 'Stopped'
		 WHEN 6 THEN 'Interrupted'
		 WHEN 9 THEN 'Failed to Start'
		 ELSE 'Unknown'
		 END,
		jobfailedreason =
		case
		when BS.status > 1 then
			case when dbo.JMGetLocalizedMessageFunc(0,failureReason) =''
		 				then  (select top 1 dbo.JMGetLocalizedMessageFunc(0,dbo.GetJobFailureReason(jobId))
						from JMBkpAtmptStats WITH (NOLOCK)
						where jobid =Bs.jobid)
				 else dbo.JMGetLocalizedMessageFunc(0,failureReason)
			end
		else ''
		end,
		startdateunixsec =  BS.servStartdate,
		enddateunixsec = BS.servEndDate,
		startdate = dbo.GetDateTime(BS.servStartDate),
		enddate =dbo.GetDateTime(BS.servEndDate),
		durationunixsec = BS.duration,
		duration = case
		  when BS.duration between 0 and 60 then  convert (varchar(2), BS.duration) + ' s'
		  when BS.duration between 60 and 3600 then convert(varchar(2), BS.duration/60) + ' m ' + convert (varchar(2), BS.duration % 60) + ' s'
		  when BS.duration between 3600 and 86400 then convert(varchar(2), BS.duration/3600) + ' h ' + convert (varchar(2), (BS.duration % 3600)/60) + ' m ' + convert(varchar(2), (BS.duration%3600)%60) + ' s'
		  when BS.duration > 86400 then convert(varchar(3), BS.duration/86400) + ' d ' + convert(varchar(2), (BS.duration%86400)/3600) +' h ' + convert(varchar(2), (((BS.duration%86400)%3600)/60))+' m ' + convert(varchar(2),(((BS.duration%86400)%3600)%60)) + ' s'
		  else ''
		  end,
		numstreams = BS.numStreams,
		numbytesuncomp= BS.totaluncompbytes,
		numbytescomp=BS.totalcompbytes,
		numobjects=BS.totalNumOfFiles + BS.totalNumOfFolders,
		isAged=
		 (CASE BS.agedtime
			 WHEN 0 THEN 0
			 WHEN NULL THEN 0
			 ELSE 1
		 END),
		isAgedStr=
		 (CASE BS.agedtime
			 WHEN 0 THEN 'No'
			 WHEN NULL THEN 'No'
			 ELSE 'Yes'
		 END),
		xmlJobOptions = dbo.GetXMLJobOptions(BS.jobId),
		AR.retentionDays,
		systemStateBackup = CASE
								WHEN ((BS.opType = 43) OR (BS.BkpAttributes & 0x100000 <> 0)) THEN 1
								ELSE	0
							END
		FROM  dbo.APP_Application WITH (NOLOCK) INNER JOIN
			  dbo.APP_BackupSetName WITH (NOLOCK) ON dbo.APP_Application.backupSet = dbo.APP_BackupSetName.id INNER JOIN
			  dbo.APP_InstanceName WITH (NOLOCK) ON dbo.APP_Application.instance = dbo.APP_InstanceName.id INNER JOIN
			  dbo.APP_iDAType WITH (NOLOCK) ON dbo.APP_Application.appTypeId = dbo.APP_iDAType.type INNER JOIN
			  dbo.APP_Client WITH (NOLOCK) ON dbo.APP_Application.clientId = dbo.APP_Client.id INNER JOIN
			  dbo.JMBkpStats AS BS WITH (NOLOCK) ON dbo.APP_Application.id = BS.appId
			  LEFT OUTER JOIN  dbo.archGroup WITH (NOLOCK) ON BS.dataArchGrpId = dbo.archGroup.id
			  LEFT OUTER JOIN  dbo.archAgingRule AR WITH (NOLOCK) ON AR.copyId = dbo.archGroup.defaultCopy AND BS.opType NOT IN (59, 65)
				OR AR.copyId = dbo.archGroup.defaultSnapCopy AND BS.opType IN (59, 65)
		WHERE BS.servEndDate is NULL or BS.servEndDate >= @date
	END
	ELSE
	BEGIN
		INSERT INTO @listJobs
		SELECT
		jobid=BS.jobId,
		appid=BS.appid,
		jobinitfrom=
		case BS.initFrom
		when 1 then 'Command Line'
		when 2 then 'Gui'
		when 3 then 'Schedule'
		when 4 then 'System'
		end,
		clientname = dbo.APP_Client.name,
		idataagent = dbo.APP_IDAType.name,
		instance = APP_InstanceName.name,
		backupset = dbo.APP_BackupSetName.Name,
		subclient = dbo.app_application.SubClientName,
		data_sp=dbo.archGroup.name ,
		backuplevelInt =BS.bkplevel,
		backuplevel =
		CASE  BS.bkplevel
		 WHEN 1 THEN 'Full'
		 WHEN 2 THEN 'Incremental'
		 WHEN 4 THEN 'Differential'
		 WHEN 64 THEN 'SyntheticFull'
		 WHEN 128 THEN 'SyntheticFull'
		 WHEN 256 THEN 'Transaction Log w. NoTruncate'
		 WHEN 512 THEN 'ASR'
		 WHEN 16384 THEN 'Incremental'
		 ELSE 'Unknown'
		 END,
		incrlevel =
		case  BS.bkplevel
		when 2 then
			 case BS.oraSublevel
			 when 0 then 1
			 else BS.oraSublevel
			 end
		else 0
		end,
		jobstatusInt =BS.status,
		jobstatus =
		 CASE BS.status
		 WHEN 1 THEN 'Success'
		 WHEN 2 THEN 'Failed'
		 WHEN 3 THEN 'PartialSuccess'
		 WHEN 4 THEN 'Killed'
		 WHEN 5 THEN 'Stopped'
		 WHEN 6 THEN 'Interrupted'
		 WHEN 9 THEN 'Failed to Start'
		 ELSE 'Unknown'
		 END,
		jobfailedreason =
		case
		when BS.status > 1 then
			case when dbo.JMGetLocalizedMessageFunc(0,failureReason) =''
		 				then  (select top 1 dbo.JMGetLocalizedMessageFunc(0,dbo.GetJobFailureReason(jobId))
						from JMBkpAtmptStats WITH (NOLOCK)
						where jobid =Bs.jobid)
				 else dbo.JMGetLocalizedMessageFunc(0,failureReason)
			end
		else ''
		end,
		startdateunixsec =  BS.servStartdate,
		enddateunixsec = BS.servEndDate,
		startdate = dbo.GetDateTime(BS.servStartDate),
		enddate =dbo.GetDateTime(BS.servEndDate),
		durationunixsec = BS.duration,
		duration = case
		  when BS.duration between 0 and 60 then  convert (varchar(2), BS.duration) + ' s'
		  when BS.duration between 60 and 3600 then convert(varchar(2), BS.duration/60) + ' m ' + convert (varchar(2), BS.duration % 60) + ' s'
		  when BS.duration between 3600 and 86400 then convert(varchar(2), BS.duration/3600) + ' h ' + convert (varchar(2), (BS.duration % 3600)/60) + ' m ' + convert(varchar(2), (BS.duration%3600)%60) + ' s'
		  when BS.duration > 86400 then convert(varchar(3), BS.duration/86400) + ' d ' + convert(varchar(2), (BS.duration%86400)/3600) +' h ' + convert(varchar(2), (((BS.duration%86400)%3600)/60))+' m ' + convert(varchar(2),(((BS.duration%86400)%3600)%60)) + ' s'
		  else ''
		  end,
		numstreams = BS.numStreams,
		numbytesuncomp= BS.totaluncompbytes,
		numbytescomp=BS.totalcompbytes,
		numobjects=BS.totalNumOfFiles + BS.totalNumOfFolders,
		isAged=
		 (CASE BS.agedtime
			 WHEN 0 THEN 0
			 WHEN NULL THEN 0
			 ELSE 1
		 END),
		isAgedStr=
		 (CASE BS.agedtime
			 WHEN 0 THEN 'No'
			 WHEN NULL THEN 'No'
			 ELSE 'Yes'
		 END),
		xmlJobOptions = dbo.GetXMLJobOptions(BS.jobId),
		AR.retentionDays,
		systemStateBackup = CASE
								WHEN ((BS.opType = 43) OR (BS.BkpAttributes & 0x100000 <> 0)) THEN 1
								ELSE	0
							END
		FROM  dbo.APP_Application WITH (NOLOCK) INNER JOIN
			  dbo.APP_BackupSetName WITH (NOLOCK) ON dbo.APP_Application.backupSet = dbo.APP_BackupSetName.id INNER JOIN
			  dbo.APP_InstanceName WITH (NOLOCK) ON dbo.APP_Application.instance = dbo.APP_InstanceName.id INNER JOIN
			  dbo.APP_iDAType WITH (NOLOCK) ON dbo.APP_Application.appTypeId = dbo.APP_iDAType.type INNER JOIN
			  dbo.APP_Client WITH (NOLOCK) ON dbo.APP_Application.clientId = dbo.APP_Client.id INNER JOIN
			  dbo.JMBkpStats AS BS WITH (NOLOCK) ON dbo.APP_Application.id = BS.appId
			  LEFT OUTER JOIN  dbo.archGroup WITH (NOLOCK) ON BS.dataArchGrpId = dbo.archGroup.id
			  LEFT OUTER JOIN  dbo.archAgingRule AR WITH (NOLOCK) ON AR.copyId = dbo.archGroup.defaultCopy AND BS.opType NOT IN (59, 65)
				OR AR.copyId = dbo.archGroup.defaultSnapCopy AND BS.opType IN (59, 65)
	END
	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [CommCellBackupInfoFn]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'CommCellBackupInfoFn' AND revision = '1.8')

  insert into GXDBVersions values(5, 'CommCellBackupInfoFn',  '1.8', 'CommCellBackupInfoFn', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDeferredCatalogSupportedAppTypes.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDeferredCatalogSupportedAppTypes'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDeferredCatalogSupportedAppTypes]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDeferredCatalogSupportedAppTypes]
  delete from GXDBVersions where name = 'GetDeferredCatalogSupportedAppTypes' and type = 5
END
GO

		CREATE FUNCTION GetDeferredCatalogSupportedAppTypes ()
		RETURNS @AppTypeList TABLE (appTypeId INTEGER )
		AS
		BEGIN
		INSERT INTO @AppTypeList
		SELECT 13
		RETURN;
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDeferredCatalogSupportedAppTypes]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDeferredCatalogSupportedAppTypes' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetDeferredCatalogSupportedAppTypes',  '1.2', 'GetDeferredCatalogSupportedAppTypes', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getMysqlProxyAndInstance.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getMysqlProxyAndInstance'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getMysqlProxyAndInstance]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getMysqlProxyAndInstance]
  delete from GXDBVersions where name = 'getMysqlProxyAndInstance' and type = 5
END
GO

	CREATE FUNCTION getMysqlProxyAndInstance(@jobId int, @subclientId int )
	RETURNS NVARCHAR(1024)
	AS
	BEGIN
	declare @instanceNamewherejobran nvarchar(1024)
	declare @instanceWhereJobRan int
	declare @clientWhereJObRan nvarchar(1024)
	declare @ranOnProxy int
	Declare @clientSlashProxy nvarchar (1024)
	set @ranOnProxy =  ISNULL(convert (int,(select attributeValue from JMJobOptions WITH (READUNCOMMITTED) where attributeName like '%MYSQL Run On Proxy%' and jobId=@jobId)),0)
	if @ranOnProxy = 1
	begin
	select @instanceNamewherejobran = name,@instanceWhereJobRan = id from app_instancename WITH (READUNCOMMITTED) where id in (select ISNULL(convert(int,(select attrVal from APP_InstanceProp WITH (READUNCOMMITTED)where componentNameId in ( select instance from APP_Application WITH (READUNCOMMITTED) where id = @subclientId) and attrName = 'MySQL proxy instance id')),0))
	end
	else
	begin
	select @instanceNamewherejobran = name,@instanceWhereJobRan = id from app_instancename WITH (READUNCOMMITTED) where id in (select instance from APP_Application WITH (READUNCOMMITTED) where id = @subclientId)
	end
	select @clientWhereJObRan = name from APP_Client WITH (READUNCOMMITTED) where id in (select top 1 clientid from APP_Application WITH (READUNCOMMITTED) where instance=@instanceWhereJobRan)
	SET @clientSlashProxy = @clientWhereJObRan+'\'+@instanceNamewherejobran
	return @clientSlashProxy
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getMysqlProxyAndInstance]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getMysqlProxyAndInstance' AND revision = '1.1')

  insert into GXDBVersions values(5, 'getMysqlProxyAndInstance',  '1.1', 'getMysqlProxyAndInstance', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/VMProtectionCoverage.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: VMProtectionCoverage'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[VMProtectionCoverage]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[VMProtectionCoverage]
  delete from GXDBVersions where name = 'VMProtectionCoverage' and type = 5
END
GO

 CREATE FUNCTION VMProtectionCoverage(
	@nLastDays	INTEGER,
	@BackupType	NVARCHAR(32)
	)
 RETURNS @VMCoverage TABLE (
	VMName				NVARCHAR(256),
	BackupStatus			VARCHAR(256),
	InstanceName			NVARCHAR(256),
	BackupSetName			NVARCHAR(256),
	SubclientName			NVARCHAR(256),
	VMSizeGB			BIGINT,
	VMBackedupSizeGB		BIGINT,
	EstimatedVMDataWrittenSizeGB	BIGINT,
	LastSuccessfulBackupJobId	INTEGER,
	LastBackupTime			DATETIME,
	LastBackupType			NVARCHAR(16),
	TotalTimeForLastBackup		INTEGER,
	clientId					INTEGER,
	CommCellId					INTEGER,
    CommCellName                VARCHAR(256)
 )
 AS
 BEGIN
 -----------------------------------------------------------------------------------
 -- InPut Param: @nLastDays >0, or -1, @BackupType=Full,Synth,Incr
 -- IF @nLastDays = -1 THEN NEEDS TO COUNT ALL CURRENTLY PROTECTED VMS.
 -- USED FOR LICENSING...
 -----------------------------------------------------------------------------------
 		DECLARE	@Today		DATETIME = DATEDIFF(DAY, 0, GETDATE())
 		DECLARE	@StartTime	INT = 0
 		if @nLastDays >=0
 			SET	@StartTime = dbo.GetUnixTime(DATEADD(DAY, -@nLastDays, @Today))
 		DECLARE  @VMInfo TABLE(
			clientId			INT,
 			VMName				nvarchar(1024),
 			VMGuid				nvarchar(255),
			status				INT  --0 Discovered, 1 manually excluded
		)
 		DECLARE @tblBackupLevel TABLE (BackupLevel INT)
 		IF @BackupType = 'Full'
 		BEGIN
			INSERT INTO @tblBackupLevel VALUES(1)
			INSERT INTO @tblBackupLevel VALUES(1024)
			INSERT INTO @tblBackupLevel VALUES(32768)
 		END
 		ELSE IF @BackupType LIKE '%Synth%'
 		BEGIN
			INSERT INTO @tblBackupLevel VALUES(64)
			INSERT INTO @tblBackupLevel VALUES(16384)
 		END
 		ELSE IF @BackupType LIKE '%Incr%'
 		BEGIN
			INSERT INTO @tblBackupLevel VALUES(2)
			INSERT INTO @tblBackupLevel VALUES(4)
			INSERT INTO @tblBackupLevel VALUES(128)
			INSERT INTO @tblBackupLevel VALUES(256)
 		END
 		ELSE
			SET @BackupType = ''
			INSERT INTO @VMInfo  (clientId, VMName, VMGuid,status)
			select distinct C.id, C.name, '', 0 from APP_Client C WITH (NOLOCK)
			INNER JOIN APP_ClientProp CP WITH (NOLOCK)
			ON C.id = CP.componentNameId
			AND CP.attrName = 'Virtual Server Discovered Clients'
			AND CP.modified =0
			AND CP.attrVal = '1'
			UPDATE @VMInfo
			SET VMGuid = CP.attrVal FROM APP_ClientProp CP WITH (NOLOCK) INNER JOIN @VMInfo vmInfo ON
			vmInfo.clientId = CP.componentNameId
			AND CP.attrName='Virtual Machine GUID'
			DECLARE @VMJobInfo TABLE(
				commcellid					INT,
				clientId					INT,
				appId						INT,
				BackupStatus			    INT, -- 0 - Backed Up, 1 -  Did Not Backup, 2 - manually exlcuded
				LastSuccessfulBackupJobId	BIGINT,
				LastBackupJobId				BIGINT,
				LastBackupType				INT,
				LastBackupTime				BIGINT,
				VMBackupStartTime			BIGINT,
				VMBackupEndTime				BIGINT,
				TotalTimeForLastBackup		BIGINT,
				BackupSetName				nvarchar(1024),
				InstanceName				nvarchar(1024),
				SubClientName				nvarchar(1024),
				VMSize						BIGINT,
				VMDataWrittenSize			BIGINT,
				VMBackedupSize				BIGINT,
				DataStatus				INT
			)
			DECLARE @VMTotalSize TABLE(
				vmJobId				INT,
				TotalVMBackupSize	BIGINT,
				DataWritten			BIGINT
			)
			INSERT	INTO @VMJobInfo
			SELECT	JMQ.commCellId,
					JMQ.clientId,
					MAX(B.appId),
					1,
					MAX(CASE  WHEN B.status in ( 1,3,14,16)  THEN(
								CASE	WHEN V.attrVal IS NOT NULL AND V.attrVal IN ('0', '3')
									THEN B.jobid
								WHEN V.attrVal IS  NULL AND JMQ.status IN (1,3)
									THEN B.jobId
								ELSE 0
								END)
						END),
					MAX(B.jobId),
					0,
					0,
					0,
					0,
					0,
					NULL,
					NULL,
					NULL,
					0,
					0,
					0,
					0
			FROM JMQinetixUpdateStatus JMQ WITH (NOLOCK)
				INNER JOIN JMBkpStats B WITH (NOLOCK) ON
					B.jobId = JMQ.jobId AND
					B.commCellId = B.commCellId AND
					(@BackupType = '' OR B.bkpLevel IN (SELECT BackupLevel FROM @tblBackupLevel))
				LEFT OUTER JOIN APP_VMProp V WITH (NOLOCK) ON
					JMQ.jobId = V.jobId AND
					JMQ.commCellId = V.commCellId AND
					JMQ.clientId = V.VMclientId AND
				V.attrName = 'vmStatus'
			WHERE	B.appType = 106
			GROUP BY
				JMQ.clientId, JMQ.commCellId
		UPDATE @VMJobInfo
		SET VMSize = CAST(V.attrVal as bigint)
		FROM APP_VMProp V WITH (NOLOCK) INNER JOIN @VMJobInfo vm ON
			V.VMclientId = vm.clientId
			AND vm.LastSuccessfulBackupJobId = V.jobId
			AND V.attrName ='vmSize'
		UPDATE @VMJobInfo
		SET VMBackedupSize = CAST(V.attrVal as bigint)
		FROM APP_VMProp V WITH (NOLOCK) INNER JOIN @VMJobInfo vm ON
			V.VMclientId = vm.clientId
			AND vm.LastSuccessfulBackupJobId = V.jobId
			AND V.attrName ='vmUsedSpace'
		UPDATE @VMJobInfo
		SET VMBackupStartTime = CAST(V.attrVal AS BIGINT)
		FROM APP_VMProp V WITH (NOLOCK) INNER JOIN @VMJobInfo vm ON
			V.VMclientId = vm.clientId
			AND vm.LastSuccessfulBackupJobId = V.jobId
			AND V.attrName ='vmBackupStartTime'
		UPDATE @VMJobInfo
		SET VMBackupEndTime = CAST(V.attrVal AS BIGINT)
		FROM APP_VMProp V WITH (NOLOCK) INNER JOIN @VMJobInfo vm ON
			V.VMclientId = vm.clientId
			AND vm.LastSuccessfulBackupJobId = V.jobId
			AND V.attrName ='vmBackupEndTime'
		INSERT INTO @VMTotalSize
		SELECT LastSuccessfulBackupJobId, SUM(VMBackedupSize),0 FROM @VMJobInfo where LastSuccessfulBackupJobId > 0 group by LastSuccessfulBackupJobId
		UPDATE  @VMTotalSize
		SET     DataWritten = ISNULL(
					   (SELECT TOP 1 T.sizeOnMedia
						   FROM    (SELECT S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
							   FROM    JMJobDataStats S WITH (READUNCOMMITTED)
								   WHERE   2 = S.commcellId and vmJobId =S.jobid and S.AuxCopyJobId = 0
								   GROUP BY S.archGrpCopyId) AS T),0)
		UPDATE	@VMJobInfo
		SET		appId = B.appId,
				LastBackupType = B.bkpLevel,
				--TotalTimeForLastBackup = (B.servEndDate - B.servStartDate),
					LastBackupTime = B.servEndDate,
					DataStatus = B.DataStatus
			FROM	@VMJobInfo V INNER JOIN
					JMBkpStats B WITH (NOLOCK) ON
					B.jobId =  V.LastSuccessfulBackupJobId
					AND B.commCellId = V.commcellid
					AND B.status in (1,3,14,16)
		IF @nLastDays < 0
			DELETE FROM @VMJobInfo WHERE DataStatus >0
		UPDATE @VMJobInfo
		SET		appId = B.appId
		FROM @VMJobInfo V INNER JOIN
			JMBkpStats B WITH (NOLOCK) ON
			v.LastSuccessfulBackupJobId = 0
			AND B.jobId = v.LastBackupJobId
		UPDATE	@VMJobInfo
		SET		SubClientName = A.subclientName,
				BackupSetName = BS.name,
				InstanceName = I.name
		FROM	@VMJobInfo vmJobInfo
				INNER JOIN APP_Application A WITH (NOLOCK) ON
					vmJobInfo.appId = A.id
					INNER JOIN APP_BackupSetName BS WITH (NOLOCK) ON
					BS.id = A.backupSet
				INNER JOIN APP_InstanceName I ON
					I.id = A.instance
		if @nLastDays >=0
			UPDATE @VMJobInfo
			SET BackupStatus = ( SELECT CASE WHEN LastBackupTime < @StartTime THEN 1
										 ELSE 0
										 END )
		else
			UPDATE @VMJobInfo SET BackupStatus = 0 where LastBackupTime >0
		UPDATE @VMInfo SET status = 1
		FROM @VMInfo vmInfo
			INNER JOIN APP_SubClientProp SCP WITH (NOLOCK)
				ON	vmInfo.VMName = SUBSTRING(SCP.attrVal, 0, CHARINDEX(' ',SCP.attrVal))
				AND	SCP.attrType = 121 AND SCP.modified = 0
			INNER JOIN APP_Application app WITH (NOLOCK)
				ON app.id = SCP.componentNameId
			AND	app.subclientName LIKE 'Do Not Backup' AND app.appTypeId = 106
		UPDATE @VMJobInfo
		SET VMDataWrittenSize = cast(VMBackedupSize*(cast(vmTotalSize.DataWritten as real)/vmTotalSize.TotalVMBackupSize) as bigint)
		FROM @VMTotalSize vmTotalSize INNER JOIN @VMJobInfo
		ON vmTotalSize.vmJobId = LastSuccessfulBackupJobId
		AND vmTotalSize.TotalVMBackupSize > 0
		AND LastSuccessfulBackupJobId >0
	DECLARE @CommCellId INT
	DECLARE @aliasName varchar(256)
	SELECT @CommCellId = number, @aliasName=aliasName from APP_CommCell WITH (NOLOCK) where clientId =2
		INSERT INTO @VMCoverage
			SELECT	VMName,
					(CASE WHEN BackupStatus IS NULL
						THEN ( CASE vmInfo.status  WHEN 0 THEN 'Discovered, Not protected'
								ELSE 'Manually Excluded'
								END
						)
						ELSE ( CASE BackupStatus
								WHEN 0 THEN 'Currently protected'
								WHEN 1 THEN 'Not protected in the time range'
								END
						)
						END ) as BackupStatus,
					InstanceName,
					BackupSetName,
					SubClientName,
					CAST(VMSize/1024.0/1024.0/1024.0 as decimal(10,2)) as VMSizeGB,
					CAST(VMBackedupSize/1024.0/1024/1024 as decimal(10,2)) as VMBackedupSizeGB,
					CAST(VMDataWrittenSize/1024.0/1024/1024 as decimal(10,2) ) as EstimatedVMDataWrittenSizeGB,
					LastSuccessfulBackupJobId,
					dbo.GetDateTime(LastBackupTime) as LastBackupTime,
					CASE LastBackupType
						WHEN 1 THEN 'Full'
						WHEN 2 THEN 'Incremental'
						WHEN 4 THEN 'Differential'
						WHEN 64 THEN 'SyntheticFull'
						ELSE null
						END as LastBackupType,
					--TotalTimeForLastBackup,
					VMBackupEndTime - VMBackupStartTime as TotalTimeForLastBackup,
					vmInfo.clientId,
					@CommCellId as CommCellId,
                    @aliasName  as CommCellName
			FROM	@VMInfo vmInfo
			LEFT OUTER JOIN @VMJobInfo vmJobInfo
			ON vmInfo.clientId = vmJobInfo.clientId
			ORDER BY VMName
    RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [VMProtectionCoverage]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'VMProtectionCoverage' AND revision = '1.7')

  insert into GXDBVersions values(5, 'VMProtectionCoverage',  '1.7', 'VMProtectionCoverage', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DataGrowthPerCopy.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DataGrowthPerCopy'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DataGrowthPerCopy]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DataGrowthPerCopy]
  delete from GXDBVersions where name = 'DataGrowthPerCopy' and type = 5
END
GO

 CREATE FUNCTION DataGrowthPerCopy (
	@Frequency		VARCHAR(32),	-- 'Day', 'Week' or 'Month'
	@Periods		INTEGER,
	@StartDate		VARCHAR(32),	-- 'mm/dd/yyyy' or '' for 8 weeks ago
	@EndDate		VARCHAR(32),	-- 'mm/dd/yyyy' or '' for current date
	@Predictions	INTEGER,		-- Numer of prediction points
	@MediaType		VARCHAR(32),	-- 'Disk', 'Tape' or '' for all
	@CopyType		VARCHAR(32),	-- 'Backup', 'Replication' or '' for all
	@LibraryName	NVARCHAR(144),	-- '' for all
	@PolicyName		NVARCHAR(144),	-- '' for all
	@CopyName		NVARCHAR(64)	-- '' for all
 )
 RETURNS @Results TABLE (
	CommCell		NVARCHAR(256),
	StoragePolicy	NVARCHAR(256),
	Copy			NVARCHAR(256),
	IsPrimaryCopy	VARCHAR(4),
	IsDedupeCopy	VARCHAR(4),
	PeriodBegin		VARCHAR(32),
	PeriodEnd		VARCHAR(32),
	SizeOnMedia_GB	DECIMAL(20,2),
	DataGrowth_GB	DECIMAL(20,2),
	Duration_Hr		DECIMAL(10,2),
	Throughput_GBHr DECIMAL(10,2),
	IsPrediction	VARCHAR(4),
	MediaAgent		NVARCHAR(256),
	Library			NVARCHAR(128),
	LibGrowth_GBDay DECIMAL(20,2),
	LibFreeSpace_GB	DECIMAL(20,2),
	LibEstDaysToUse	INTEGER,
	TimeZone		NVARCHAR(256),
	LibTotalSpace_GB DECIMAL(20,2)
 )
 AS
 BEGIN

 IF	@StartDate = ''
 BEGIN
 	IF	@Frequency = 'Day'
 		SET @StartDate = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()) - @Periods + 1, 0)
 	ELSE
 	IF	@Frequency = 'Month'
 		SET @StartDate = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - @Periods + 1, 0)
 	ELSE
 		SET @StartDate = DATEADD(WEEK, DATEDIFF(WEEK, 0, GETDATE()) - @Periods + 1, 0)
 END

 IF	@EndDate = ''
 	SET @EndDate = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), 0)

 SET @EndDate = DATEADD(DAY, 1, @EndDate)

 IF	@PolicyName <> '' AND @CopyName <> ''
 	SET @MediaType = 0

 DECLARE @tblPeriod TABLE (StartDate DATETIME, EndDate DATETIME)

 DECLARE @csName		VARCHAR(256)
 DECLARE @csTimeZone	VARCHAR(256)
 DECLARE @TmpStartDate	DATETIME = @StartDate
 DECLARE @TmpEndDate	DATETIME = @EndDate
 DECLARE @MaxEndDate	DATETIME
 DECLARE @PrevStartDate	DATETIME
 DECLARE @nDays			INTEGER

 SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2

 SELECT	@csTimeZone	= TimeZoneStdName FROM SchedTimeZone
 WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)

 SET	@MaxEndDate	= @TmpEndDate

 WHILE (@TmpStartDate < @MaxEndDate)
 BEGIN
 	IF	@Frequency = 'Month'
 		SET	@TmpEndDate = DATEADD(MONTH, 1, @TmpStartDate)
 	ELSE IF @Frequency = 'Day'
 		SET	@TmpEndDate = DATEADD(DAY, 1, @TmpStartDate)
 	ELSE
 		SET	@TmpEndDate = DATEADD(WEEK, 1, @TmpStartDate)

 	IF	@TmpEndDate > @MaxEndDate
 		SET	@TmpEndDate = @MaxEndDate

 	INSERT	INTO @tblPeriod
 	SELECT	dbo.LocalToUTCTime(@TmpStartDate, @csTimeZone), dbo.LocalToUTCTime(@TmpEndDate, @csTimeZone)

 	SET	@TmpStartDate = @TmpEndDate
 END

 SELECT	@TmpStartDate = MIN(StartDate), @TmpEndDate = MAX(EndDate) FROM @tblPeriod

 SET	@nDays = DATEDIFF(DAY, @TmpStartDate, @TmpEndDate)

 DECLARE @tblSPCopy TABLE (
 	PolicyId INT, PolicyName NVARCHAR(512), CopyId INT, CopyName NVARCHAR(512), SIDBStoreId INT,
 	IsPrimaryCopy INT, IsDiskCopy INT, MediaAgentId INT, LibraryId INT, GrowthRate BIGINT, days INT)

 INSERT	INTO @tblSPCopy
 SELECT	AG.id AS PolicyId, AG.name AS PolicyName, AGC.id AS CopyId, AGC.name AS CopyName, AGC.SIDBStoreId,
 		CASE WHEN AGC.id = AG.defaultCopy THEN 1 ELSE 0 END,
 		CASE WHEN DPL.DrivePoolType = 10001 THEN 1 ELSE 0 END,
 		DP.HostClientId, MP.LibraryId, 0, @nDays
 FROM	archGroup AG
 		INNER JOIN archGroupCopy AGC ON AGC.archGroupId = AG.id
 		INNER JOIN MMDataPath DP ON DP.CopyId = AGC.id AND (DP.Flag & 1) = 1
 		INNER JOIN MMDrivePool DPL ON DPL.DrivePoolId = DP.DrivePoolId
 		INNER JOIN MMMasterPool MP ON MP.MasterPoolId = DPL.MasterPoolId
 WHERE	AG.type = 1 AND AG.id > 1 AND AGC.type IN (1, 2) AND AGC.isSnapCopy = 0

 IF	@PolicyName <> ''
  	DELETE	@tblSPCopy WHERE LibraryId NOT IN (SELECT DISTINCT LibraryId FROM @tblSPCopy
			WHERE PolicyName = @PolicyName AND (@CopyName = '' OR CopyName = @CopyName))
 ELSE
 BEGIN
	IF	@MediaType <> '' OR @CopyType <> ''
 		DELETE	@tblSPCopy WHERE @MediaType = 'Disk' AND IsDiskCopy = 0 OR @MediaType = 'Tape' AND IsDiskCopy = 1

 	IF	@CopyType = 'Backup' OR @CopyType = 'Replication'
  		DELETE	@tblSPCopy WHERE LibraryId NOT IN (SELECT LibraryId FROM @tblSPCopy
				WHERE @CopyType = 'Backup' AND IsPrimaryCopy = 1 OR @CopyType = 'Replication' AND IsPrimaryCopy = 0)
 END

 IF	@LibraryName <> ''
  	DELETE	@tblSPCopy WHERE LibraryId NOT IN (SELECT LibraryId FROM MMLibrary WHERE AliasName = @LibraryName)

 DECLARE @tblSummary TABLE (
 	StartDate DATETIME, EndDate DATETIME, CopyId INT, SizeOnMedia BIGINT, DataGrowth BIGINT, Duration INT, Prediction INT)

 INSERT	INTO @tblSummary
 SELECT	P.*, C.CopyId, 0, 0, 0, 0
 FROM	@tblPeriod P CROSS JOIN @tblSPCopy C


 UPDATE	@tblSPCopy
 SET	GrowthRate = S.DataGrowth/C.days
 FROM	@tblSPCopy C INNER JOIN
 		(SELECT	CopyId, SUM(DataGrowth) AS DataGrowth
 		FROM	@tblSummary
 		GROUP BY CopyId) S
 	ON	C.CopyId = S.CopyId

 DECLARE @tblLibrary TABLE (LibraryId INT, LibraryName NVARCHAR(128), FreeSpaceMB BIGINT, GrowthRate BIGINT, DaysOfMedia INT, TotalSpaceMB BIGINT)

 INSERT	INTO @tblLibrary
 SELECT	L.LibraryId, L.AliasName,
		SUM(CASE WHEN M.IsAged = 0 THEN CAST(MS.FreeBytesMB AS BIGINT) ELSE CAST(MS.TotalSpaceMB AS BIGINT) END),
		0, -1, SUM(CAST(MS.TotalSpaceMB AS BIGINT))
 FROM	MMLibrary L
		INNER JOIN MMMedia M ON M.LibraryId = L.LibraryId
		INNER JOIN MMMediaSide MS ON M.MediaId = MS.MediaId
 WHERE	L.LibraryId > 0
 GROUP BY L.LibraryId, L.AliasName

 SELECT	@TmpStartDate = MAX(StartDate) FROM @tblPeriod

 UPDATE	@tblLibrary
 SET	GrowthRate = T.GrowthRate, DaysOfMedia = (1024.0*1024.0*FreeSpaceMB)/T.GrowthRate
 FROM	@tblLibrary L INNER JOIN
 		(SELECT	LibraryId, SUM(GrowthRate) AS GrowthRate
 		FROM	@tblSPCopy
 		GROUP BY LibraryId) T
 	ON	L.LibraryId = T.LibraryId
 WHERE	FreeSpaceMB > 0 AND T.GrowthRate > 0

 DELETE	@tblSPCopy
 WHERE	@PolicyName <> '' AND (PolicyName <> @PolicyName OR @CopyName <> '' AND CopyName <> @CopyName)
	OR	@CopyType = 'Backup' AND IsPrimaryCopy = 0 OR @CopyType = 'Replication' AND IsPrimaryCopy = 1

 IF (@Predictions > 0)
 BEGIN
	SELECT	@PrevStartDate = MAX(StartDate) FROM @tblPeriod

	SET	@TmpStartDate  = dbo.UTCToLocalTime(@PrevStartDate, @csTimeZone)
	IF	@Frequency = 'Month'
		SET	@TmpEndDate = DATEADD(MONTH, 1, @TmpStartDate)
	ELSE IF @Frequency = 'Day'
		SET	@TmpEndDate = DATEADD(DAY, 1, @TmpStartDate)
	ELSE
		SET	@TmpEndDate = DATEADD(WEEK, 1, @TmpStartDate)

	SET	@TmpStartDate = @MaxEndDate
 END

 WHILE (@Predictions > 0)
 BEGIN
 	SET	@nDays = DATEDIFF(DAY, @TmpStartDate, @TmpEndDate)
 	IF	@nDays > 0
 	BEGIN
 		INSERT	INTO @tblSummary
 		SELECT	dbo.LocalToUTCTime(@TmpStartDate, @csTimeZone), dbo.LocalToUTCTime(@TmpEndDate, @csTimeZone), S.CopyId,
 				S.SizeOnMedia + C.GrowthRate*@nDays, C.GrowthRate*@nDays, 0, 1
 		FROM	@tblSummary S INNER JOIN @tblSPCopy C ON S.CopyId = C.CopyId
 		WHERE	S.StartDate = @PrevStartDate

 		SET	@PrevStartDate	= dbo.LocalToUTCTime(@TmpStartDate, @csTimeZone)
 		SET	@Predictions	= @Predictions - 1
 	END

 	SET @TmpStartDate = @TmpEndDate
 	IF	@Frequency = 'Month'
 		SET	@TmpEndDate = DATEADD(MONTH, 1, @TmpEndDate)
 	ELSE IF @Frequency = 'Day'
 		SET	@TmpEndDate = DATEADD(DAY, 1, @TmpEndDate)
 	ELSE
 		SET	@TmpEndDate = DATEADD(WEEK, 1, @TmpEndDate)
 END

 INSERT INTO @Results
 SELECT
 		@csName AS CommCell,
 		PolicyName, CopyName,
 		CASE WHEN IsPrimaryCopy > 0 THEN 'Yes' ELSE 'No' END AS IsPrimaryCopy,
 		CASE WHEN SIDBStoreId > 0 THEN 'Yes' ELSE 'No' END AS IsDedupeCopy,
 		dbo.UTCToLocalStringTime(S.StartDate, @csTimeZone), dbo.UTCToLocalStringTime(DATEADD(SECOND, -1, S.EndDate), @csTimeZone),
 		CAST(ISNULL(SizeOnMedia, 0)/1024.0/1024.0/1024.0 AS DECIMAL(20, 2)) AS SizeOnMedia_GB,
 		CAST(ISNULL(DataGrowth, 0)/1024.0/1024.0/1024.0 AS DECIMAL(20, 2)) AS DataGrowth_GB,
 		CAST(ISNULL(Duration, 0)/3600.0 AS DECIMAL(10, 2)) AS Duration_Hr,
 		CASE WHEN ISNULL(Duration, 0) = 0 THEN 0
 			 ELSE CAST(ISNULL(DataGrowth, 0)/1024.0/1024.0/1024.0/(ISNULL(Duration, 0)/3600.0) AS DECIMAL(10, 2))END AS Throughput_GBHr,
 		CASE WHEN Prediction > 0 THEN 'Yes' ELSE 'No' END AS IsPrediction,
 		CL.name AS MediaAgent, L.LibraryName,
 		CAST(L.GrowthRate/1024.0/1024.0/1024.0 AS DECIMAL(10, 2)) AS LibGrowth_GBDay,
 		CAST(L.FreeSpaceMB/1024.0 AS DECIMAL(20, 2)) AS LibFreeSpace_GB, L.DaysOfMedia AS LibEstDaysToUse,
 		@csTimeZone AS TimeZone,
		CAST(L.TotalSpaceMB/1024.0 AS DECIMAL(20, 2)) AS LibTotalSpace_GB
 FROM	@tblSPCopy C
 		INNER JOIN APP_Client CL ON CL.id = C.MediaAgentId
 		INNER JOIN @tblSummary S ON S.CopyId = C.CopyId
 		INNER JOIN @tblLibrary L ON L.LibraryId = C.LibraryId
 ORDER BY PolicyName, CopyName, EndDate, Prediction

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DataGrowthPerCopy]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DataGrowthPerCopy' AND revision = '1.5')

  insert into GXDBVersions values(5, 'DataGrowthPerCopy',  '1.5', 'DataGrowthPerCopy', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/LargestClientDataOnMedia.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: LargestClientDataOnMedia'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LargestClientDataOnMedia]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[LargestClientDataOnMedia]
  delete from GXDBVersions where name = 'LargestClientDataOnMedia' and type = 5
END
GO

 CREATE FUNCTION LargestClientDataOnMedia (
	@TopN			INTEGER,
	@CountAgedJobs	INTEGER
 )
 RETURNS @Results TABLE (
	Client			NVARCHAR(256),
	SizeOnMediaGB	DECIMAL(20,2),
	ShareOfTotal	DECIMAL(20,2),
	TotalSizeGB		DECIMAL(20,2)
 )
 AS
 BEGIN

 DECLARE @TotalSize	BIGINT

 IF	@TopN <= 0
 	SET @TopN = 0x7FFFFFFF

 DECLARE @tblClientSize TABLE (ClientId INT, SizeOnMedia BIGINT)

 INSERT	INTO @tblClientSize
 SELECT	A.clientId, SUM(J.sizeOnMedia)
 FROM	APP_Application A INNER JOIN JMJobDataStats J ON J.appId = A.id
 WHERE	J.status IN (100, 102, 103) AND ((J.disabled & 256) = 0 OR @CountAgedJobs = 1)
 GROUP BY A.clientId

 SET	@TotalSize = (SELECT SUM(SizeOnMedia) FROM @tblClientSize)

 INSERT	INTO @Results
 SELECT	TOP (@TopN)
 		name AS Client,
 		ROUND(SizeOnMedia/1024.0/1024.0/1024.0, 2) AS SizeOnMediaGB,
 		ROUND(100.0*SizeOnMedia/@TotalSize, 2) AS ShareOfTotal,
 		ROUND(@TotalSize/1024.0/1024.0/1024.0, 2) AS TotalSizeGB
 FROM	@tblClientSize S INNER JOIN APP_Client C ON C.id = S.ClientId
 ORDER BY SizeOnMedia DESC

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [LargestClientDataOnMedia]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'LargestClientDataOnMedia' AND revision = '1.2')

  insert into GXDBVersions values(5, 'LargestClientDataOnMedia',  '1.2', 'LargestClientDataOnMedia', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/ProtectedClientsPerPolicy.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ProtectedClientsPerPolicy'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ProtectedClientsPerPolicy]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ProtectedClientsPerPolicy]
  delete from GXDBVersions where name = 'ProtectedClientsPerPolicy' and type = 5
END
GO

 CREATE FUNCTION ProtectedClientsPerPolicy (
	@TimeRangeBegin	INTEGER,
	@TimeRangeEnd	INTEGER,
	@CountAgedJobs	INTEGER
 )
 RETURNS @Results TABLE (
	CommCell		NVARCHAR(256),
	Policy			NVARCHAR(256),
	Client			NVARCHAR(256),
	CompletedJobs	INTEGER,
	SizeOnMediaGB	DECIMAL(20,2)
 )
 AS
 BEGIN

 DECLARE @csName	VARCHAR(256) = (SELECT aliasName FROM APP_CommCell WHERE id = 2)

 DECLARE @TotalSize	BIGINT

 IF @TimeRangeEnd <= 0
	SET @TimeRangeEnd = 0x7FFFFFFF

 DECLARE @tblClientSize TABLE (PolicyName NVARCHAR(144), ClientId INT, CompletedJobs INT, SizeOnMedia BIGINT)

 INSERT	INTO @tblClientSize
 SELECT	G.name, clientId, COUNT(DISTINCT B.jobId), SUM(D.sizeOnMedia)
 FROM	APP_Application A
 		INNER JOIN JMBkpStats B ON A.id = B.appId
 		INNER JOIN JMJobDataStats D ON D.jobId = B.jobId AND D.commCellId = B.commCellId
 		INNER JOIN archGroup G ON D.archGrpCopyId IN (G.defaultCopy, G.defaultSnapCopy)
 		INNER JOIN APP_iDAType I ON I.type = B.appType
 WHERE	B.servEndDate BETWEEN @TimeRangeBegin AND @TimeRangeEnd
 	AND (B.status IN (1, 14) OR B.status = 3 AND I.isCWEJobValid = 1)
 	AND B.opType IN (4, 14, 18, 59, 65, 76) AND B.commCellId = 2
 	AND B.appType < 1000 AND B.appType NOT BETWEEN 600 AND 700
 	AND (@CountAgedJobs = 1 OR B.dataStatus = 0)
 GROUP BY G.name, A.clientId

 INSERT	INTO @Results
 SELECT	@csName AS CommCell,
		S.PolicyName AS Policy,
 		C.name AS Client,
 		S.CompletedJobs,
 		ROUND(SizeOnMedia/1024.0/1024.0/1024.0, 2) AS SizeOnMediaGB
 FROM	@tblClientSize S INNER JOIN APP_Client C ON C.id = S.ClientId
 ORDER BY S.PolicyName, C.name

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ProtectedClientsPerPolicy]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ProtectedClientsPerPolicy' AND revision = '1.3')

  insert into GXDBVersions values(5, 'ProtectedClientsPerPolicy',  '1.3', 'ProtectedClientsPerPolicy', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetJPRFromMsgId.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetJPRFromMsgId'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetJPRFromMsgId]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetJPRFromMsgId]
  delete from GXDBVersions where name = 'GetJPRFromMsgId' and type = 5
END
GO

	CREATE FUNCTION GetJPRFromMsgId(@msgId INT = 0)
	RETURNS VARCHAR(30)
	WITH ENCRYPTION
	AS
	BEGIN
		IF @msgId = 0 RETURN ''
		DECLARE @subSystem INT = @msgId / (POWER(2,24));
		DECLARE @msgNum INT = @msgId &  (POWER(2, 24) - 1);
		DECLARE @JPR VARCHAR(30) = CAST(@subSystem AS VARCHAR) + ':' + cast (@msgNum AS VARCHAR);
		RETURN @JPR
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetJPRFromMsgId]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetJPRFromMsgId' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetJPRFromMsgId',  '1.2', 'GetJPRFromMsgId', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DDBGrowthPerCopy.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DDBGrowthPerCopy'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DDBGrowthPerCopy]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DDBGrowthPerCopy]
  delete from GXDBVersions where name = 'DDBGrowthPerCopy' and type = 5
END
GO

 CREATE FUNCTION DDBGrowthPerCopy (
	@Frequency		VARCHAR(32),	-- 'Day', 'Week' or 'Month'
	@Periods		INTEGER,
	@StartDate		VARCHAR(32),	-- 'mm/dd/yyyy' or '' for 8 weeks ago
	@EndDate		VARCHAR(32),	-- 'mm/dd/yyyy' or '' for current date
	@Predictions	INTEGER,		-- Numer of prediction points
	@PolicyName		NVARCHAR(144),	-- '' for all
	@CopyName		NVARCHAR(64)	-- '' for all
 )
 RETURNS @Results TABLE (
	StoragePolicy	NVARCHAR(256),
	Copy			NVARCHAR(256),
	MediaAgent		NVARCHAR(512),
	SIDBPath		VARCHAR(1024),
	PeriodBegin		VARCHAR(32),
	PeriodEnd		VARCHAR(32),
	IsPrediction	VARCHAR(4),
	DDBSize_MB		DECIMAL(20,2),
	DDBFreeSpace_MB	DECIMAL(20,2),
	TimeZone		NVARCHAR(256)
 )
 AS
 BEGIN
 IF	@StartDate = ''
 BEGIN
  	IF	@Frequency = 'Day'
 		SET @StartDate = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()) - @Periods + 1, 0)
 	ELSE
  	IF	@Frequency = 'Month'
  		SET @StartDate = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - @Periods + 1, 0)
  	ELSE
  		SET @StartDate = DATEADD(WEEK, DATEDIFF(WEEK, 0, GETDATE()) - @Periods + 1, 0)
  END
  IF	@EndDate = ''
  	SET @EndDate = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), 0)
  SET @EndDate = DATEADD(DAY, 1, @EndDate)
  DECLARE @tblPeriod TABLE (StartDate DATETIME, EndDate DATETIME)
  DECLARE @csName		VARCHAR(256)
  DECLARE @csTimeZone	VARCHAR(256)
  DECLARE @TmpStartDate	DATETIME = @StartDate
  DECLARE @TmpEndDate	DATETIME = @EndDate
  DECLARE @MaxEndDate	DATETIME
  DECLARE @nDays			INTEGER
  SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2
  SELECT	@csTimeZone	= TimeZoneStdName FROM SchedTimeZone
  WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
  SET	@MaxEndDate	= @TmpEndDate
  WHILE (@TmpStartDate < @MaxEndDate)
  BEGIN
  	IF	@Frequency = 'Month'
  		SET	@TmpEndDate = DATEADD(MONTH, 1, @TmpStartDate)
  	ELSE IF @Frequency = 'Day'
  		SET	@TmpEndDate = DATEADD(DAY, 1, @TmpStartDate)
  	ELSE
  		SET	@TmpEndDate = DATEADD(WEEK, 1, @TmpStartDate)
  	IF	@TmpEndDate > @MaxEndDate
  		BREAK
  	INSERT	INTO @tblPeriod
  	SELECT	@TmpStartDate, @TmpEndDate
  	SET	@TmpStartDate = @TmpEndDate
  END
 DECLARE @SIDBStoresToReport table(SubStoreId int, storeCCId int, SIDBPath VARCHAR(1024), IdxCacheFreeSpaceMB bigint,GrowthRate bigint, lastDDBSize bigint, MediaAgent nvarchar(512))
 INSERT @SIDBStoresToReport
 SELECT distinct store.SubStoreId, store.CommCellId, apath.Path, cache.FreeDiskSpaceMB, null, 0, ''
 FROM archGroup AG inner join archGroupCopy AGC ON AG.id = AGC.archGroupId AND AGC.SIDBStoreId > 0
 inner join IdxSIDBSubStore store ON store.SIDBStoreId = AGC.SIDBStoreId
 inner join IdxAccessPath  aPath ON apath.IdxAccessPathId = store.IdxAccessPathId
 inner join IdxCache cache ON store.IdxCacheId = cache.IdxCacheId
 WHERE (@PolicyName = '' OR AG.name = @PolicyName) AND (@CopyName = '' OR (@PolicyName <> '' AND AGC.name = @CopyName))
 AND AG.id > 1 AND AGC.id > 0
 UPDATE @SIDBStoresToReport SET MediaAgent = cl.name
 FROM @SIDBStoresToReport stores INNER JOIN IdxSIDBSubStore storeTbl ON stores.SubStoreId = storeTbl.SubStoreId AND stores.storeCCId = storeTbl.CommCellId
 INNER JOIN APP_Client cl ON storeTbl.ClientId = cl.id AND cl.id > 1
 DECLARE @tblSummary table(StartDate DATETIME, EndDate DATETIME, SubStoreId int, storeCCID int, SIDBPath nvarchar(1024),
 DDBSize bigint, AvgDDBSize bigint, isPrediction int)
 INSERT @tblSummary
 SELECT P.*, store.SubStoreId, store.storeCCId,store.SIDBPath, 0, 0, 0
 FROM @tblPeriod P, @SIDBStoresToReport store
 --Remove period/store combinations before the minimum time we have in our history information for that store
 DELETE @tblSummary
 FROM @tblSummary summ left outer join
 (SELECT SubStoreId, CommCellId, MIN(modifiedTime) "minModifiedTime" FROM IdxSIDBUsageHistory
 GROUP BY SubStoreId, commcellId) hist
 ON summ.SubStoreId = hist.SubStoreId AND summ.storeCCID = hist.CommCellId
 WHERE hist.minModifiedTime is null OR dbo.getunixTime(summ.EndDate) < hist.minModifiedTime
 UPDATE @tblSummary
 SET DDBSize = sidbHistory.SizeOccupied, AvgDDBSize = T.avgDDBSize
 FROM @tblSummary summ inner join
 (
 SELECT A.SubStoreId, A.storeCCID, A.StartDate "StartDate", A.EndDate "EndDate",
 MAX(B.ModifiedTime) "histTime", AVG(SizeOccupied) avgDDBSize
 FROM @tblSummary A inner join IdxSIDBUsageHistory B
 ON A.SubStoreId = B.SubStoreId AND A.storeCCID = B.CommCellId
 AND B.ModifiedTime >= dbo.GetUnixTime(A.StartDate) AND B.ModifiedTime < dbo.GetUnixTime(A.EndDate)
 GROUP BY A.SubStoreId, A.storeCCID, A.startDate, A.EndDate
 ) T
 ON summ.StartDate = T.StartDate AND summ.EndDate = T.EndDate AND summ.SubStoreId = T.SubStoreId
 AND summ.storeCCID = T.storeCCID
 inner join IdxSIDBUsageHistory sidbHistory
 ON summ.SubStoreId = sidbHistory.SubStoreId AND summ.storeCCID = sidbHistory.CommCellId
 AND sidbHistory.ModifiedTime = T.histTime
 UPDATE @tblSummary SET DDBSize = T.DDBSize, AvgDDBSize = T.AvgDDBSize
 FROM @tblSummary summ
 inner join
 (
 SELECT A.SubStoreId, A.storeCCID, A.EndDate, B.DDBSize, B.AvgDDBSize, row_number() over(partition by A.SubStoreId, A.StoreCCId, A.EndDate order by B.EndDate desc) as rn
 FROM @tblSummary A
 inner join @tblSummary B ON A.DDBSize = 0 AND B.DDBSize > 0 AND A.SubStoreId = B.SubStoreId AND A.storeCCID = B.storeCCID AND B.EndDate < A.EndDate
 ) T
 ON summ.SubStoreId = T.SubStoreId AND summ.storeCCID = T.storeCCID AND summ.EndDate = T.EndDate AND T.rn = 1
 UPDATE @SIDBStoresToReport SET GrowthRate = 0, lastDDBSize = T.DDBSize
 FROM @SIDBStoresToReport stores inner join
 (SELECT SubStoreId, storeCCID, MAX(DDBSize) "DDBSize" FROM @tblSummary
 group by SubStoreId, storeCCID
 having COUNT(distinct EndDate) = 1) T ON stores.SubStoreId = T.SubStoreId AND stores.storeCCId = T.storeCCID
 UPDATE @SIDBStoresToReport SET GrowthRate = (C.AvgDDBSize - B.AvgDDBSize)
 /CASE WHEN @Frequency = 'Day' THEN DATEDIFF(Day,B.EndDate,C.EndDate) WHEN @Frequency = 'Week' THEN DATEDIFF(Week,B.EndDate,C.EndDate) WHEN @Frequency = 'Month' THEN DATEDIFF(Month,B.EndDate,C.EndDate) END,
 lastDDBSize = C.DDBSize
 FROM @SIDBStoresToReport A inner join
 (SELECT SubStoreId, storeCCID, DDBSize, AvgDDBSize, EndDate, row_number() over(partition by SubStoreId, storeCCId order by EndDate asc) as rn FROM @tblSummary)B
 ON A.SubStoreId = B.SubStoreId AND A.storeCCId = B.storeCCID AND B.rn = 1 AND A.GrowthRate is null inner join
 (SELECT SubStoreId, storeCCID, DDBSize,AvgDDBSize, EndDate, row_number() over(partition by subStoreId, storeCCId order by EndDate desc) as rn FROM @tblSummary)C
 ON A.SubStoreId = C.SubStoreId AND A.storeCCId = C.storeCCID AND C.rn = 1
 SELECT @TmpEndDate = MAX(EndDate) FROM @tblPeriod
 DECLARE @counter int = 0
 WHILE (@Predictions > 0)
 BEGIN
 	SET @counter = @counter + 1
  	SET @TmpStartDate = @TmpEndDate
  	IF	@Frequency = 'Month'
 		SET	@TmpEndDate = DATEADD(MONTH, 1, @TmpEndDate)
  	ELSE IF @Frequency = 'Day'
  		SET	@TmpEndDate = DATEADD(DAY, 1, @TmpEndDate)
  	ELSE
  		SET	@TmpEndDate = DATEADD(WEEK, 1, @TmpEndDate)
  	INSERT	INTO @tblSummary
 	SELECT	@TmpStartDate, @TmpEndDate, summ.SubStoreId, summ.storeCCID, summ.SIDBPath, stores.lastDDBSize + @counter * stores.GrowthRate, 0, 1
 	FROM (SELECT distinct SubStoreId, storeCCId, SIDBPath FROM @tblSummary) summ
 	inner join @SIDBStoresToReport stores ON stores.SubStoreId = summ.SubStoreId AND stores.storeCCId = summ.storeCCID AND stores.GrowthRate is not null
 	SET	@Predictions	= @Predictions - 1
  END
  INSERT INTO @Results
  SELECT AG.name, AGC.name, stores.MediaAgent, stores.SIDBPath, summ.StartDate, summ.EndDate, summ.isPrediction, summ.DDBSize, stores.IdxCacheFreeSpaceMB, @csTimeZone
  FROM @tblSummary summ inner join @SIDBStoresToReport stores ON summ.SubStoreId = stores.SubStoreId AND summ.storeCCID = stores.storeCCId
  inner join IdxSIDBSubStore subStore ON subStore.SubStoreId = stores.SubStoreId AND subStore.commcellId = stores.storeCCId
  inner join archGroupCopy AGC ON AGC.SIDBStoreId = subStore.SIDBStoreId AND AGC.dedupeFlags & 134217728 = 0
  inner join archGroup AG ON AGC.archGroupId = AG.id
  order by AG.name, AGC.name, summ.EndDate, isPrediction
  RETURN
  END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DDBGrowthPerCopy]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DDBGrowthPerCopy' AND revision = '1.3')

  insert into GXDBVersions values(5, 'DDBGrowthPerCopy',  '1.3', 'DDBGrowthPerCopy', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/MarkNonErrorForDel.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MarkNonErrorForDel'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MarkNonErrorForDel]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MarkNonErrorForDel]
  delete from GXDBVersions where name = 'MarkNonErrorForDel' and type = 5
END
GO

 CREATE FUNCTION MarkNonErrorForDel(@messageId integer, @inputMsgs varchar(256))
 RETURNS INT
 WITH ENCRYPTION
 AS
 BEGIN
 	DECLARE @flag int
 	DECLARE @msgId INT
 	DECLARE @endIndex integer
 	DECLARE @startIndex integer
 	DECLARE @EventId integer
 	SET @startIndex = 0
 	SET @endIndex = CHARINDEX(',', @inputMsgs, @startIndex)
 	BEGIN
 		SET @flag = 0
 		WHILE(@endIndex IS NOT NULL AND @endIndex <> 0)
 		BEGIN
 			SET @EventId = CAST(SUBSTRING(@inputMsgs,@startIndex,@endIndex-@startIndex) AS INT)
 			SET @msgId = (SELECT messageId FROM JMFailureReasonMsg WITH (READUNCOMMITTED) WHERE id = @EventId)
 			IF(@messageId = @msgId)
 			BEGIN
 				SET @flag = 1
 				BREAK;
 			END
 			SET @startIndex = @endIndex + 1
 			SET @endIndex = CHARINDEX(',', @inputMsgs, @startIndex)
 		END
 	END
 	RETURN @flag
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MarkNonErrorForDel]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MarkNonErrorForDel' AND revision = '1.1')

  insert into GXDBVersions values(5, 'MarkNonErrorForDel',  '1.1', 'MarkNonErrorForDel', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSPBkpInfoForMMSummPage.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: GetSPBkpInfoForMMSummPage'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSPBkpInfoForMMSummPage]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSPBkpInfoForMMSummPage]
  delete from GXDBVersions where name = 'GetSPBkpInfoForMMSummPage' and type = 5
END
GO

CREATE FUNCTION GetSPBkpInfoForMMSummPage (@spId integer)
RETURNS @BkpInfo table (jobCount int, sizeOnMedia bigint)
AS
BEGIN
DECLARE @l_defaultCopy	INT
DECLARE @l_spFlags INT
DECLARE @l_policyType INT
SELECT	@l_defaultCopy = defaultCopy, @l_spFlags = flags, @l_policyType = type
FROM	archGroup WITH (NOLOCK)
WHERE	id = @spId
IF @l_spFlags & 256 = 0
BEGIN
DECLARE @tempJobStats table
(
jobId int,
commcellId int,
sizeOnMedia bigint,
primary key(jobId, commcellId)
)
INSERT @tempJobStats
SELECT distinct jbkp.jobId, jbkp.commCellId, 0 FROM
(SELECT DISTINCT appId FROM archFile WITH (NOLOCK)
WHERE 	archGroupId = @spId AND isValid > 0) T
INNER JOIN JMBkpStats jbkp ON jbkp.appId = T.appId AND (jbkp.dataArchGrpId = @spId OR jbkp.logArchGrpId = @spId OR jbkp.diffArchGrpId = @spId)
INNER JOIN App_Commcell C ON jbkp.commcellId = C.id AND (C.type = 1 OR @l_policyType = 5)
INNER JOIN JmJobDataStats jds ON jbkp.jobid = jds.jobid AND jbkp.commCellid = jds.commCellId
WHERE jbkp.status IN (1, 3, 14, 16)
AND jds.status IN (2, 100)
OPTION(RECOMPILE)
INSERT @tempJobStats
SELECT distinct jbkp.jobId, jbkp.commCellId, 0 FROM
(SELECT DISTINCT appId FROM archFile WITH (NOLOCK)
WHERE 	archGroupId = @spId AND isValid > 0) T
INNER JOIN JMAdminJobStatsTable jbkp ON jbkp.appId = T.appId AND jbkp.archGrpID = @spId
INNER JOIN JmJobDataStats jds ON jbkp.jobid = jds.jobid AND jbkp.commCellid = jds.commCellId
WHERE jds.status IN (2, 100)
OPTION(RECOMPILE)
DELETE  @tempJobStats
FROM    @tempJobStats A, JMPreparedJob B
WHERE   A.jobId = B.jobId AND A.commCellId = B.commCellId
AND B.status = 3
DELETE @tempJobStats
FROM @tempJobStats A left outer join
(SELECT	distinct B.jobId, B.commCellId
FROM	JMJobDataStats B WITH (NOLOCK), @tempJobStats J
WHERE	B.commCellId = J.commCellId AND B.jobId = J.jobId
GROUP BY B.jobId, B.commCellId, B.archGrpCopyId
HAVING
(MAX(CASE WHEN ((B.status IN (101, 102, 103, 1000)) OR (B.disabled&256=256)) THEN 1 ELSE 0 END))  = 0) T
ON A.jobId = T.jobId AND A.commcellId = T.commcellId
WHERE T.jobId is null
UPDATE	@tempJobStats
SET		sizeOnMedia = S.sizeOnMedia
FROM	(SELECT	J.jobId, J.commCellId, SUM(J.sizeOnMedia) AS sizeOnMedia
FROM	@tempJobStats T, JMJobDataStats J WITH (NOLOCK)
WHERE	J.jobId = T.jobId AND J.commCellId = T.commCellId AND J.archGrpCopyId = @l_defaultCopy
GROUP BY J.jobId, J.commCellId
HAVING  SUM(J.sizeOnMedia) > 0) S, @tempJobStats jobs
WHERE	jobs.jobId = S.jobId AND jobs.commCellId = S.commCellId
IF EXISTS (SELECT 1 FROM @tempJobStats WHERE sizeOnMedia = 0)
BEGIN
UPDATE jobs
SET sizeOnMedia = J.totalBackupSize
FROM @tempJobStats jobs
JOIN JMBkpStats J ON jobs.jobId = J.jobId AND J.commCellId = jobs.commCellId
WHERE jobs.sizeOnMedia = 0
END
INSERT INTO @BkpInfo
SELECT COUNT(jobId), SUM(sizeOnMedia) from @tempJobStats
END
ELSE
BEGIN
DECLARE @tempJobStatsGDSP table
(
jobId int,
commcellId int,
agedFlag int,
sizeOnMedia bigint,
copyId int,
dataStatus int,
primary key(jobId, commcellId, copyId)
)
DECLARE @l_sidbstoreId int = 0
DECLARE @l_copyId int = 0
SELECT @l_sidbstoreId = SIDBStoreId
FROM archGroupCopy where id = (SELECT defaultCopy from archGroup where id = @spId)
DECLARE CopyIdListCursor CURSOR FOR
SELECT id from archGroupCopy WHERE SIDBStoreId = @l_sidbstoreId AND dedupeFlags & 134217728 <> 0
OPEN CopyIdListCursor
FETCH NEXT FROM CopyIdListCursor INTO @l_copyId
WHILE(@@FETCH_STATUS = 0)
BEGIN
DECLARE @policyId int
SET @policyId = 0
SELECT @policyId = archGroupId FROM archGroupCopy WHERE id = @l_copyId
INSERT INTO @tempJobStatsGDSP
SELECT jds.jobId, jds.commCellId, MAX(jds.disabled & 256), SUM(jds.sizeOnMedia), @l_copyId, CASE WHEN MIN(jds.status) = 100 AND MAX(jds.status) = 101 THEN 103 ELSE MAX(jds.status) END
FROM JMBkpStats jbkp INNER JOIN JMJobDataStats jds ON jbkp.jobId = jds.jobId AND jbkp.commCellId = jds.commCellId
left outer join @tempJobStatsGDSP jobs ON jds.jobId = jobs.jobId AND jds.commCellId = jobs.commcellId AND jds.archGrpCopyId = jobs.copyId
WHERE jbkp.status IN (1, 3, 14, 16) AND (jbkp.dataArchGrpId = @policyId OR jbkp.logArchGrpId = @policyId OR jbkp.diffArchGrpId = @policyId)
AND jds.archGrpCopyId = @l_copyId AND jobs.jobId is null
GROUP BY jds.jobId, jds.commCellId
FETCH NEXT FROM CopyIdListCursor INTO @l_copyId
END
CLOSE CopyIdListCursor
DEALLOCATE CopyIdListCursor
DELETE @tempJobStatsGDSP WHERE agedFlag = 256
DELETE @tempJobStatsGDSP WHERE dataStatus not in (100, 103)
INSERT INTO @BkpInfo
SELECT COUNT(jobId), SUM(sizeOnMedia) from @tempJobStatsGDSP
END
RETURN
END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSPBkpInfoForMMSummPage]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSPBkpInfoForMMSummPage' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetSPBkpInfoForMMSummPage',  '1.3', 'GetSPBkpInfoForMMSummPage', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetReportApptypeName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetReportApptypeName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetReportApptypeName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetReportApptypeName]
  delete from GXDBVersions where name = 'GetReportApptypeName' and type = 5
END
GO

	CREATE FUNCTION GetReportApptypeName(@appTypeId BIGINT)
		RETURNS NVARCHAR(MAX)
		AS
		BEGIN
			DECLARE @rptApptypeName 	NVARCHAR(MAX)
			SET @rptApptypeName = (SELECT CASE @appTypeId
							WHEN 33   THEN            'Q_FILESYSTEM'
							WHEN 34   THEN           'Q_FILESYSTEM'
							WHEN 78   THEN           'Q_SHAREPOINT_SERVER'
							WHEN 69   THEN            'Q_SHAREPOINT_SERVER'
							WHEN 54   THEN            'Q_MSEXCH_MB'
							WHEN 53   THEN           'Q_MSEXCH_DB'
							WHEN 55   THEN         'Q_MSEX_WEB'
							WHEN 56			   THEN   'Q_MSEX_MIG'
							WHEN 35				THEN         'Q_MSEX_PUB'
							WHEN 1				THEN              'Q_FILESYSTEM'
							WHEN 11   THEN                       'Q_FILESYSTEM'
							WHEN 12   THEN                    'Q_FILESYSTEM'
							WHEN 18   THEN                     'Q_FILESYSTEM'
							WHEN 20   THEN                  'Q_FILESYSTEM'
							WHEN 21   THEN                        'Q_FILESYSTEM'
							WHEN 17   THEN                       'Q_FILESYSTEM'
							WHEN 19   THEN                    'Q_FILESYSTEM'
							WHEN 29   THEN                      'Q_FILESYSTEM'
							WHEN 33   THEN            'Q_FILESYSTEM'
							WHEN 34   THEN           'Q_FILESYSTEM'
							WHEN 36   THEN              'Q_FILESYSTEM'
							WHEN 38   THEN              'Q_FILESYSTEM'
							WHEN 42   THEN       'Q_FILESYSTEM'
							WHEN 43   THEN       'Q_FILESYSTEM'
							WHEN 63   THEN                   'Q_FILESYSTEM'
							WHEN 64   THEN                        'Q_FILESYSTEM'
							WHEN 74   THEN                      'Q_FILESYSTEM'
							WHEN 58   THEN 	         'Q_WINFS_MIG'
							WHEN 66   THEN         'Q_UNIXFS_MIG'
							WHEN 22   THEN                       'Q_ORACLE'
							WHEN 37   THEN                           'Q_DB2'
							WHEN 62   THEN                      'Q_UNIX_DB2'
							WHEN 3   THEN                      'Q_INFORMIX'
							WHEN 4   THEN                   'Q_MSSQLSERVER'
							WHEN 16   THEN              'Q_MSSQL_2K'
							WHEN 70   THEN              'Q_MSSQL_YUKON'
							WHEN 81   THEN                         'Q_MSSQL'
							WHEN 5   THEN                        'Q_SYBASE'
							WHEN 8   THEN         'Q_MSEX_MB'
							WHEN 14   THEN       'Q_MSEX2K_MB'
							WHEN 54   THEN            'Q_MSEX2003_MB'
							WHEN 9   THEN        'Q_MSEX_DB'
							WHEN 15   THEN      'Q_MSEX2K_DB'
							WHEN 53   THEN           'Q_MSEX2003_DB'
							WHEN 35   THEN         'Q_MSEX55_PUB'
							WHEN 44   THEN      'Q_MSEX2K_WEB'
							WHEN 55   THEN         'Q_MSEX2003_WEB'
							WHEN 67   THEN          'Q_MSEX_ARCH'
							WHEN 68   THEN        'Q_MSEX55_ARCH'
							WHEN 45   THEN        'Q_MSEX2K_MIG'
							WHEN 56   THEN   'Q_MSEX2003_MIG'
							WHEN 57   THEN      'Q_MSEX55_MIG'
							WHEN 6   THEN           'Q_LOTUS_DB'
							WHEN 51  THEN            'Q_LOTUS_UNIX_DB'
							WHEN 59   THEN        'Q_LOTUS_DOMINO_DB'
							WHEN 77   THEN           'Q_LOTUS6_DB'
							WHEN 7   THEN           'Q_LOTUS_DOC'
							WHEN 52   THEN           'Q_LOTUS_UNIX_DOC'
							WHEN 60   THEN        'Q_LOTUS_DOMINO_DOC'
							WHEN 71   THEN                   'Q_GROUPWISE'
							WHEN 10   THEN                           'Q_NDS'
							WHEN 24   THEN           'Q_SDM_WIN2K'
							WHEN 48   THEN                  'Q_SDM_UNIX'
							WHEN 61   THEN                'Q_SAP_ORADB'
							WHEN 79   THEN      'Q_SAP_SAPDB'
							WHEN 25   THEN                     'Q_PROXYHOST'
							WHEN 40   THEN                'Q_PROXYHOST_UNIX'
							WHEN 41   THEN                   'Q_ACTIVEDIR'
							WHEN 65   THEN               'Q_IMAGELEVEL_WIN'
							WHEN 75   THEN              'Q_IMAGELEVEL_UNIX'
							WHEN 76   THEN          'Q_IMAGELEVEL_PROXY'
							WHEN 73   THEN           'Q_NETSTORAGE_MIG'
							WHEN 13   THEN                        'Q_NAS'
							WHEN 47   THEN 	                 'Q_REPLICATION'
							WHEN 50   THEN          'Q_REPLICATION_UNIX'
							WHEN 82   THEN   'Q_MSEXPF_MIG'
							WHEN 80   THEN                    'Q_ORACLE_RAC'
							WHEN 83   THEN      'Q_NETWARE_MIG'
							WHEN 84   THEN 							 'Q_FILE_REPLICATION'
							WHEN 85   THEN       'Q_DATA_CLASSIFICATION'
							WHEN 86   THEN                  'Q_FILESYSTEM'
							WHEN 87   THEN     'Q_PROXYHOST_IMAGE_UNIX'
							WHEN 88   THEN                       'Q_FILESYSTEM'
							WHEN 89   THEN             'Q_SHAREPOINT_ARCH'
							WHEN 90   THEN       'Q_LOTUS_DOC_MIG'
							WHEN 91   THEN                     'Q_DPM_AGENT'
							WHEN 103   THEN                       'Q_DB2_DPF'
							WHEN 104   THEN                         'Q_MYSQL'
							WHEN 107   THEN            'Q_WBA'
							WHEN (-1)   THEN            'Q_FILESYSTEM'
							WHEN 106   THEN 				 'Q_VIRTUAL_SERVER'
							--//9.0
							WHEN 125   THEN 					 'Q_POSTGRESS'
							WHEN 126   THEN 					 'Q_SYBASE_IQ'
							WHEN 127   THEN 		 'Q_EXTERNAL_DATA_CONNECTOR'
							WHEN 128   THEN 					 'Q_DOCUMENTUM'
							WHEN 130   THEN 					 'Q_FORIEGN_APPLICATIONS'
							WHEN 131   THEN 				 'Q_OBJECT_STORE'
							WHEN 600   THEN 					 'Q_SRM_WINFS'
							ELSE                               'Q_UNSUPPORTED'
							END)
			RETURN @rptApptypeName
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetReportApptypeName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetReportApptypeName' AND revision = '1.3')

  insert into GXDBVersions values(5, 'GetReportApptypeName',  '1.3', 'GetReportApptypeName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/BackupScheduledSubclients.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: BackupScheduledSubclients'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[BackupScheduledSubclients]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[BackupScheduledSubclients]
  delete from GXDBVersions where name = 'BackupScheduledSubclients' and type = 5
END
GO

 CREATE FUNCTION BackupScheduledSubclients (
	@i_ClientId	INTEGER
	)
 RETURNS @TblResults TABLE (
	AppId		INTEGER
 )
 AS
 BEGIN
 DECLARE @TblBackupTask TABLE (taskId INT, taskType INT)

 INSERT	INTO @TblBackupTask
 SELECT	DISTINCT T.taskId, T.taskType
 FROM	TM_SubTask ST WITH (NOLOCK)
 	    INNER JOIN TM_Task T WITH (NOLOCK)
 			ON T.taskId = ST.taskId AND T.disabled = 0 AND ST.subTaskType = 2
 	    INNER JOIN TM_SubTaskOptions STO WITH (NOLOCK)
 			ON STO.subTaskId = ST.SubTaskId
 			AND	STO.optionId = 458405394 AND STO.value IN ('1', '2', '3', '6')
 WHERE	T.taskType = 2
 	 OR T.taskType = 4 AND T.taskName NOT IN ('System Created for Content Store', 'System Created for DDB subclients')

 DECLARE @TblBackupTaskAsso TABLE (TaskId INT, AssocType INT, ClientGroupId INT, ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT)

 INSERT	INTO @TblBackupTaskAsso
 SELECT	DISTINCT AE.taskId, AE.assocType, AE.clientGroupId, AE.clientId, AE.apptypeId, AE.instanceId, AE.backupsetId, AE.subclientId
 FROM	TM_AssocEntity AE WITH (NOLOCK)
 	    INNER JOIN @TblBackupTask T ON AE.taskId = T.taskId
 WHERE	(T.taskType = 2 OR T.taskType = 4 AND AE.assocType NOT IN (2, 28))
 	AND AE.taskId NOT IN (SELECT DISTINCT taskId FROM TM_AssocFilter WITH (NOLOCK) WHERE filter_type = 2 AND filter_value = 124)
 UNION
 SELECT	DISTINCT AE.taskId, AE.assocType, AE.clientGroupId, 0, CASE WHEN ISNULL(AF.filter_type, 0) = 1 THEN ISNULL(ATGA.appTypeId, 0) ELSE ISNULL(AF.filter_value, 0) END, 0, 0, 0
 FROM	TM_AssocEntity AE WITH (NOLOCK)
 	    INNER JOIN @TblBackupTask T ON AE.taskId = T.taskId AND T.taskType = 4
 	    LEFT OUTER JOIN TM_AssocFilter AF WITH (NOLOCK) ON AF.taskId = T.taskId
 	    LEFT OUTER JOIN APP_AppTypeGroup ATG WITH (NOLOCK) ON ATG.appTypeGroupId = AF.filter_value AND AF.filter_type = 1
 	    LEFT OUTER JOIN APP_AppTypeGroupAssoc ATGA WITH (NOLOCK) ON ATGA.appGroupId = ATG.appTypeGroupId
 WHERE	AE.assocType IN (2, 28) AND (ISNULL(AF.filter_type, 0) <> 2 OR ISNULL(AF.filter_value, 0) <> 124)

 INSERT	INTO @TblResults
 SELECT	A.id
 FROM	APP_Application A WITH (NOLOCK), @TblBackupTaskAsso T
 WHERE	T.ClientId IN (A.ClientId, 0) AND (T.ClientId > 0 OR T.AssocType = 2)
 	AND T.AppTypeId IN (A.AppTypeId, 0)
 	AND T.InstanceId IN (A.Instance, 0)
 	AND T.BackupsetId IN (A.Backupset, 0)
 	AND T.AppId IN (A.id, 0)
  	AND (@i_ClientId = 0 OR A.clientId = @i_ClientId)
 UNION
 SELECT	A.id
 FROM	APP_Application A WITH (NOLOCK)
 		INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON A.ClientId = CGA.clientId
 		INNER JOIN @TblBackupTaskAsso T ON CGA.ClientGroupId = T.ClientGroupId AND T.ClientId = 0 AND T.ClientGroupId > 0
 WHERE	(T.AppTypeId = 0 OR A.appTypeId = T.AppTypeId)
  	AND (@i_ClientId = 0 OR A.clientId = @i_ClientId)

 RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [BackupScheduledSubclients]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'BackupScheduledSubclients' AND revision = '1.6')

  insert into GXDBVersions values(5, 'BackupScheduledSubclients',  '1.6', 'BackupScheduledSubclients', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSolrDateString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSolrDateString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSolrDateString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSolrDateString]
  delete from GXDBVersions where name = 'GetSolrDateString' and type = 5
END
GO

	CREATE FUNCTION GetSolrDateString (@DateTimeValue datetime)
	RETURNS varchar(50)
	AS
	BEGIN
		DECLARE @retValue varchar(50)
		IF @DateTimeValue IS NOT NULL
		SELECT @retValue = LEFT(CONVERT(varchar(30), @DateTimeValue, 127), 19) + 'Z'
		RETURN @retValue
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSolrDateString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSolrDateString' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetSolrDateString',  '1.2', 'GetSolrDateString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DCGetPackageUsers.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DCGetPackageUsers'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DCGetPackageUsers]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DCGetPackageUsers]
  delete from GXDBVersions where name = 'DCGetPackageUsers' and type = 5
END
GO

	CREATE FUNCTION DCGetPackageUsers (@PackageId INT, @UserFlag INT, @delimiter VARCHAR(5))
	RETURNS NVARCHAR(MAX)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @ReturnValue NVARCHAR(MAX)
		SELECT @ReturnValue = COALESCE(@ReturnValue + @delimiter, '') +  V.SecuredEntityGuid FROM DCPackageVisibility V
		WHERE PackageId = @PackageId AND VisbilityFlags & @UserFlag = @UserFlag
		RETURN @ReturnValue
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DCGetPackageUsers]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DCGetPackageUsers' AND revision = '1.2')

  insert into GXDBVersions values(5, 'DCGetPackageUsers',  '1.2', 'DCGetPackageUsers', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getHTMLTableFromXML.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: getHTMLTableFromXML'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getHTMLTableFromXML]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getHTMLTableFromXML]
  delete from GXDBVersions where name = 'getHTMLTableFromXML' and type = 5
END
GO

 CREATE FUNCTION getHTMLTableFromXML (
     		@i_inXML		XML
     	)
     	RETURNS @htmlTblStr TABLE (
     		tblStr NVARCHAR(MAX)
     	)
     	AS
     	BEGIN

 			DECLARE @columnsList TABLE (id INT IDENTITY, columnName NVARCHAR(256))
 			DECLARE @columnName NVARCHAR(256)
 			DECLARE @numberOfRows INT

 			SELECT @numberOfRows = @i_inXML.value('count(/Results/TableResults/Row)', 'int')

 			INSERT INTO @columnsList(columnName)
 			SELECT	T.cc.value('@columnName', 'nvarchar(1024)')
 			FROM	@i_inXML.nodes('/Results/TableResults/Row[1]/Column') T(cc)


 			-- Create table Header
 			DECLARE @th NVARCHAR(MAX) = N''
 			DECLARE @td NVARCHAR(MAX) = N''
 			DECLARE columnCursor CURSOR FOR
 			SELECT columnName FROM @columnsList ORDER BY id
 			OPEN columnCursor
 			FETCH FROM columnCursor INTO @columnName
 			WHILE @@FETCH_STATUS = 0
 			BEGIN
 				SET @th += '<TH style="background-color: #666666;color: #FFFFFF;padding: 5px;font-weight: bold;text-align: left;font-size: 12px !important;">'+ @columnName + '</TH>'
 				FETCH FROM columnCursor INTO @columnName
 			END
 			CLOSE columnCursor
 			IF @th <> ''
 				SET @th = '<TR class="header" style="padding-right: 0; margin-left: 0; padding-top: 15px; margin-top: 5px; border-left-width: 1px; border-right-width: 1px; border-left-style: solid; padding-bottom: 15px; border-right-style: solid; border-top-style: solid; border-bottom-style: solid; border-top-width: 1px; margin-bottom: 5px; border-bottom-width: 1px; font-size: 12px; margin-right: 0; background-color: #F4F4F4; padding-left: 0; text-align: center;">' + @th + '</TR>'

 			DECLARE @rowIndex INT = 1
 			DECLARE @temp NVARCHAR(1024) = N''
 			WHILE @rowIndex <= @numberOfRows
 			BEGIN
 				IF @rowIndex % 2 = 0
 					SET @td += '<TR class="even">'
 				ELSE
 					SET @td += '<TR class="odd">'
 				OPEN columnCursor
 				FETCH FROM columnCursor INTO @columnName
 				WHILE @@FETCH_STATUS = 0
 				BEGIN
 					SELECT	@temp = T.cc.value('Row[sql:variable("@rowIndex")][1]/Column[@columnName=sql:variable("@columnName")][1]/text()[1]', 'nvarchar(1024)')
 					FROM	@i_inXML.nodes('/Results/TableResults') T(cc)
 					IF @rowIndex % 2 = 0
 						SET @td += '<TD style="background-color: #F9F9F9;padding: 5px;font-size: 12px !important;">' + ISNULL(@temp, '') + '</TD>'
 					ELSE
 						SET @td += '<TD style="background-color: #EAEAEA;padding: 5px;font-size: 12px !important;">' + ISNULL(@temp, '') + '</TD>'
 					FETCH FROM columnCursor INTO @columnName
 				END
 				CLOSE columnCursor
 				SET @rowIndex = @rowIndex + 1
 				SET @td += '</TR>'
 			END

 			DEALLOCATE columnCursor
 			INSERT INTO @htmlTblStr
 			SELECT '<TABLE class="datatable" style="border: 1px solid #CCCCCC;border-collapse: collapse;color: #444444 !important;font-family: helvetica,arial,sans-serif;font-size: 12px !important;width: 100%;text-align: left;">'+@th+@td+'</TABLE>'

     		RETURN
     	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getHTMLTableFromXML]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getHTMLTableFromXML' AND revision = '1.4')

  insert into GXDBVersions values(5, 'getHTMLTableFromXML',  '1.4', 'getHTMLTableFromXML', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getEntityTypeHirearchyXMLFromGenericEntityXML.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getEntityTypeHirearchyXMLFromGenericEntityXML'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getEntityTypeHirearchyXMLFromGenericEntityXML]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getEntityTypeHirearchyXMLFromGenericEntityXML]
  delete from GXDBVersions where name = 'getEntityTypeHirearchyXMLFromGenericEntityXML' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION getEntityTypeHirearchyXMLFromGenericEntityXML(@genericEntityXML XML)
	RETURNS XML
	AS
	BEGIN
	DECLARE @xmlRet AS XML
	DECLARE @entityType AS INT
	SET @entityType = ISNULL((SELECT @genericEntityXML.value('(/*/@_type_)[1]','int')),0)
	DECLARE @entityType1 AS INT = 0
	DECLARE @entityType2 AS INT = 0
	DECLARE @entityType3 AS INT = 0
	DECLARE @entityType4 AS INT = 0
	DECLARE @entityType5 AS INT = 0
	DECLARE @entityId1 AS INT = 0
	DECLARE @entityId2 AS INT = 0
	DECLARE @entityId3 AS INT = 0
	DECLARE @entityId4 AS INT = 0
	DECLARE @entityId5 AS INT = 0
	IF @entityType IN (3, 4, 5, 6, 7)
	BEGIN
		IF @entityType IN (3, 4, 5, 6, 7)
		BEGIN
			SET @entityType1 = 3			--client entity
			SET @entityId1 = ISNULL((SELECT @genericEntityXML.value('(/*/@clientId)[1]', 'int')),0)
		END
		IF @entityType IN (4, 5, 6, 7)
		BEGIN
			SET @entityType2 = 4			--apptype entity
			SET @entityId2 = ISNULL((SELECT @genericEntityXML.value('(/*/@applicationId)[1]', 'int')),0)
		END
		IF @entityType IN (5, 6, 7)
		BEGIN
			SET @entityType3 = 5			--instance entity
			SET @entityId3 = ISNULL((SELECT @genericEntityXML.value('(/*/@instanceId)[1]', 'int')),0)
		END
		IF @entityType IN (6, 7)
		BEGIN
			SET @entityType4 = 6			--backupset entity
			SET @entityId4 = ISNULL((SELECT @genericEntityXML.value('(/*/@backupsetId)[1]', 'int')),0)
		END
		IF @entityType IN (7)
		BEGIN
			SET @entityType5 = 7			--subclient entity
			SET @entityid5 = ISNULL((SELECT @genericEntityXML.value('(/*/@subclientId)[1]', 'int')),0)
		END
	END
	ELSE IF @entityType = 150
	BEGIN
		SET @entityType1 = ISNULL((SELECT @genericEntityXML.value('(/*/@entityType)[1]','int')),0)
		SET @entityId1 = ISNULL((SELECT @genericEntityXML.value('(/*/@entityId)[1]','int')),0)
	END
	ELSE IF @entityType = 126 OR (@genericEntityXML.value('(/*/flags/@includeAll)[1]','INT') = 1)
	BEGIN
		SET @entityType1 = @entityType
	END
	ELSE
	BEGIN
		DECLARE @entityFieldName AS NVARCHAR(MAX) = ISNULL((SELECT TOP 1 entityIdInXML FROM APP_Entity WHERE entityType = @entityType),'')
		IF @entityFieldName <> ''
		BEGIN
			SET @entityType1 = @entityType
			SET @entityId1 = ISNULL((SELECT T.N.value('.','INT') AS value
									 FROM @genericEntityXML.nodes('//@*') AS T(N)
									 WHERE T.N.value('local-name(.)','varchar(max)') = @entityFieldName),0)
		END
	END
	SET @xmlRet = (SELECT @entityType1 AS '@entityType1',
			  @entityId1 AS '@entityId1',
			  @entityType2 AS '@entityType2',
			  @entityId2 AS '@entityId2',
			  @entityType3 AS '@entityType3',
			  @entityId3 AS '@entityId3',
			  @entityType4 AS '@entityType4',
			  @entityId4 AS '@entityId4',
			  @entityType5 AS '@entityType5',
			  @entityId5 AS '@entityId5'
			FOR XML PATH('entityAssociated'))
	RETURN @xmlRet
	END
	GO
	SET QUOTED_IDENTIFIER OFF
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getEntityTypeHirearchyXMLFromGenericEntityXML]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getEntityTypeHirearchyXMLFromGenericEntityXML' AND revision = '')

  insert into GXDBVersions values(5, 'getEntityTypeHirearchyXMLFromGenericEntityXML',  '', 'getEntityTypeHirearchyXMLFromGenericEntityXML', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getGenericXMLFromEntityType.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getGenericXMLFromEntityType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getGenericXMLFromEntityType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getGenericXMLFromEntityType]
  delete from GXDBVersions where name = 'getGenericXMLFromEntityType' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION getGenericXMLFromEntityType(@entityType1 INT, @entityId1 INT, @entityType2 INT, @entityId2 INT, @entityType3 INT, @entityId3 INT, @entityType4 INT, @entityId4 INT, @entityType5 INT, @entityId5 INT, @exclude INT , @includeAll INT, @returnvariable NVARCHAR(MAX))
	RETURNS XML
	AS
	BEGIN
	DECLARE @xmlRet AS XML
	DECLARE @entityType INT= (SELECT dbo.getEntityLevelFromEntityHierarchy(@entityType1,@entityType2,@entityType3,@entityType4,@entityType5))
	DECLARE @entityTypeName AS NVARCHAR(MAX)
	IF @entityType IN (3,4,5,6,7)
	BEGIN
		SET @xmlRet = (SELECT
				CASE WHEN @entityType1 = 3 THEN @entityId1 END AS '@clientId',
				CASE WHEN @entityType2 = 4 THEN @entityId2 END AS '@applicationId',
				CASE WHEN @entityType3 = 5 THEN @entityId3 END AS '@instanceId',
				CASE WHEN @entityType4 = 6 THEN @entityId4 END AS '@backupsetId',
				CASE WHEN @entityType5 = 7 THEN @entityId5 END AS '@subclientId',
				@entityType AS '@_type_',
				CASE WHEN @exclude = 1 THEN '1' END AS 'flags/@exclude',
				CASE WHEN @includeAll = 1 THEN '1' END AS 'flags/@includeAll'
			FOR XML PATH('entityAssociated'))
	END
	--custom entity
	ELSE IF (SELECT flags & 0x001 FROM APP_Entity WHERE entityTYpe = @entityType) <> 0
	BEGIN
			--let us get in English as for now, will think about localization later
			SET @entityTypeName = ISNULL((SELECT entityTypeName FROM APP_Entity WHERE entityTYpe = @entityType), N'')
			SET @xmlRet = (SELECT 150 AS '@_type_',
					@entityType AS '@entityType',
					@entityId1 AS '@entityId',
					@entityTypeName AS '@entityTypeName',
					CASE WHEN @exclude = 1 THEN '1' END AS 'flags/@exclude',
					CASE WHEN @includeAll = 1 THEN '1' END AS 'flags/@includeAll'
			FOR XML PATH ('entityAssociated'))
	END
	ELSE IF @entityType = 126 OR @includeAll = 1
	BEGIN
		SET @xmlRet = (SELECT @entityType AS '@_type_',
						CASE WHEN @exclude = 1 THEN '1' END AS 'flags/@exclude',
						CASE WHEN @includeAll = 1 THEN '1' END AS 'flags/@includeAll'
					   FOR XML PATH('entityAssociated'))
	END
	ELSE
	BEGIN
		SET @xmlRet = (SELECT @entityId1 AS '@entityId1',
						@entityType AS '@_type_',
 					    CASE WHEN @exclude = 1 THEN '1' END AS 'flags/@exclude',
                        CASE WHEN @includeAll = 1 THEN '1' END AS 'flags/@includeAll'
						FOR XML PATH('entityAssociated'))
		SET @entityTypeName = ISNULL((SELECT entityIdInXML FROM APP_Entity WHERE entityType = @entityType),'')
		IF @entityTypeName <> ''
		BEGIN
			SET @xmlRet = CAST(REPLACE(CAST(@xmlRet AS NVARCHAR(MAX)), 'entityId1', @entityTypeName) AS XML)
		END
	END
	SET @xmlRet = CAST(REPLACE(CAST(@xmlRet AS NVARCHAR(MAX)), 'entityAssociated', @returnvariable) AS XML)
	RETURN @xmlRet
	END
	GO
	SET QUOTED_IDENTIFIER OFF
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getGenericXMLFromEntityType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getGenericXMLFromEntityType' AND revision = '')

  insert into GXDBVersions values(5, 'getGenericXMLFromEntityType',  '', 'getGenericXMLFromEntityType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getEntityLevelFromEntityHierarchy.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getEntityLevelFromEntityHierarchy'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getEntityLevelFromEntityHierarchy]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getEntityLevelFromEntityHierarchy]
  delete from GXDBVersions where name = 'getEntityLevelFromEntityHierarchy' and type = 5
END
GO

	SET QUOTED_IDENTIFIER ON
	GO
	CREATE FUNCTION getEntityLevelFromEntityHierarchy(@entityType1 INT, @entityType2 INT, @entityType3 INT, @entityType4 INT, @entityType5 INT)
	RETURNS INT
	AS
	BEGIN
	DECLARE @entityLevel AS INT
	IF @entityType5 <> 0
	SET @entityLevel = @entityType5
	ELSE IF @entityType4 <> 0
	SET @entityLevel = @entityType4
	ELSE IF @entityType3 <> 0
	SET @entityLevel = @entityType3
	ELSE IF @entityType2 <> 0
	SET @entityLevel = @entityType2
	ELSE IF @entityType1 <> 0
	SET @entityLevel = @entityType1
	RETURN @entityLevel
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getEntityLevelFromEntityHierarchy]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getEntityLevelFromEntityHierarchy' AND revision = '')

  insert into GXDBVersions values(5, 'getEntityLevelFromEntityHierarchy',  '', 'getEntityLevelFromEntityHierarchy', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getAllPermissionsForCategory.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getAllPermissionsForCategory'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getAllPermissionsForCategory]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getAllPermissionsForCategory]
  delete from GXDBVersions where name = 'getAllPermissionsForCategory' and type = 5
END
GO

	CREATE FUNCTION getAllPermissionsForCategory (@categoryId INT,@skipHiddenPermission int =1)
	RETURNS @permissionsTbl TABLE
	(
				categoryId INT,
                permissionId INT
	)
	AS
	BEGIN
                INSERT INTO @permissionsTbl
                                SELECT categoryid, id
                                FROM UMPermissions
                                WHERE categoryId = @categoryId and(@skipHiddenPermission=0 OR flags&0x002=0 )
                                UNION
                                SELECT Perm.categoryid, Perm.permissionId
                                FROM UMCategories AS Cat
                                CROSS APPLY dbo.getAllPermissionsForCategory(Cat.id,@skipHiddenPermission) AS Perm
                                WHERE parentCategoryId = @categoryId
                RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getAllPermissionsForCategory]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getAllPermissionsForCategory' AND revision = '')

  insert into GXDBVersions values(5, 'getAllPermissionsForCategory',  '', 'getAllPermissionsForCategory', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getAllCategoriesRecurXML.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getAllCategoriesRecurXML'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getAllCategoriesRecurXML]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getAllCategoriesRecurXML]
  delete from GXDBVersions where name = 'getAllCategoriesRecurXML' and type = 5
END
GO

	CREATE FUNCTION getAllCategoriesRecurXML
	(
		@categoryId INT,
		@localeId INT
	)
	RETURNS XML
	AS
	BEGIN
	DECLARE @returnXML XML
	IF EXISTS( SELECT * from dbo.getAllPermissionsForCategory(@categoryId,1))
	BEGIN
	                       SET @returnXML =(
                                        SELECT(SELECT UMCategories.id AS '@categoryId', dbo.sec_getLocalizedCategory(UMCategories.id, @localeId) AS '@categoryName'
                                                        FOR XML PATH('category'),TYPE),
                                                        (SELECT Perm.id AS '@permissionId', dbo.sec_getLocalizedPermission(Perm.id, @localeId) AS '@permissionName'
                                                        FROM UMPermissions Perm
                                                        WHERE Perm.categoryId = @categoryId and flags&0x002=0
                                                        FOR XML PATH('permissionsList'),TYPE),
                                                        (SELECT dbo.getAllCategoriesRecurXML(Cat1.id, @localeId)
                                                          FROM UMCategories Cat1
                                                          WHERE Cat1.parentCategoryId = @categoryId
                                                          FOR XML PATH(''), TYPE)
                                        FROM UMCategories
                                        WHERE id = @categoryId
                                        FOR XML PATH('categoriesList'))
	END
	RETURN @returnXML
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getAllCategoriesRecurXML]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getAllCategoriesRecurXML' AND revision = '')

  insert into GXDBVersions values(5, 'getAllCategoriesRecurXML',  '', 'getAllCategoriesRecurXML', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getAllParentsForCatOrPerm.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getAllParentsForCatOrPerm'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getAllParentsForCatOrPerm]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getAllParentsForCatOrPerm]
  delete from GXDBVersions where name = 'getAllParentsForCatOrPerm' and type = 5
END
GO

	CREATE FUNCTION getAllParentsForCatOrPerm (@categoryId INT, @permissionId INT)
	RETURNS @parentsTbl TABLE
	(
				categoryId INT
	)
	AS
	BEGIN
                IF @permissionId <> 0			--this is a permission
                BEGIN
					INSERT INTO @parentsTbl
						SELECT categoryId		--immediate parent
						FROM UMPermissions
						WHERE id = @permissionId
						UNION
						SELECT Parent.categoryId	--for immediate parent category go recursively to find all parent categories
						FROM UMPermissions AS Perm
						CROSS APPLY dbo.getAllParentsForCatOrPerm(Perm.categoryId, 0) AS Parent
						WHERE Perm.id = @permissionId
                END
                ELSE IF @categoryId <> 0			--this is a category
                BEGIN
					INSERT INTO @parentsTbl			--immediate parent
						SELECT parentCategoryId
						FROM UMCategories
						WHERE id = @categoryId AND parentCategoryId <> 0
						UNION
						SELECT Parent.categoryId	--for immediate parent category go recursively to find all parent categories
						FROM UMCategories AS Cat
						CROSS APPLY dbo.getAllParentsForCatOrPerm(Cat.parentCategoryId, 0) AS parent
						WHERE Cat.id = @categoryId AND Cat.parentCategoryId <> 0
                END
                RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getAllParentsForCatOrPerm]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getAllParentsForCatOrPerm' AND revision = '')

  insert into GXDBVersions values(5, 'getAllParentsForCatOrPerm',  '', 'getAllParentsForCatOrPerm', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_ObjectTypeToEntitytype.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sec_ObjectTypeToEntitytype'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_ObjectTypeToEntitytype]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_ObjectTypeToEntitytype]
  delete from GXDBVersions where name = 'sec_ObjectTypeToEntitytype' and type = 5
END
GO

  CREATE FUNCTION sec_ObjectTypeToEntitytype(@objecttype integer)
  	RETURNS INTEGER
  	AS
  	BEGIN
  			IF(@objectType=0)
				RETURN 0
			IF(@objectType = 2018)			--commcell
  				RETURN 1
  			IF(@objectType = 2572)			--server group (Client group)
  				RETURN 28
  			IF(@objectType = 2009)			--client
  				RETURN 3
			IF(@objectType = 2230)			--app type
				RETURN  4
  			IF(@objectType = 2011)			--instance
  				RETURN 5
  			IF(@objectType = 2012)			--backupset
  				RETURN 6
  			IF(@objectType = 2013)			--subclient
  				RETURN 7
  			IF(@objectType = 2048)			--media agent
  				RETURN 11
  			IF(@objectType = 2049)			--library
  				RETURN 9
  			IF(@objectType = 8462)			--vault tracker policy
  				RETURN 21
  			IF(@objectType = 4300)			--schedule policy
  				RETURN 35
  			IF(@objectType = 14033)			--workflow
  				RETURN 83
  			IF(@objectType = 9646)			--LM
  				RETURN 90
  			IF(@objectType = 8464)			--destination item
  				RETURN 53
  			IF(@objectType = 9651)			--custom query item
  				RETURN 124
  			IF(@objectType = 2231)			--storage policy
  				RETURN 17
			IF(@objectType = 2900)			--custom reports
				RETURN 131
			IF(@objectType = 8107)		--container
				RETURN 130
			IF(@objectType = 8180)	--shelf
				RETURN 57
			IF(@objectType = 9615)		--array
				RETURN 153
  			RETURN @objecttype
  	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_ObjectTypeToEntitytype]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_ObjectTypeToEntitytype' AND revision = '')

  insert into GXDBVersions values(5, 'sec_ObjectTypeToEntitytype',  '', 'sec_ObjectTypeToEntitytype', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_convert4EntityTypeTo5EntityType.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sec_convert4EntityTypeTo5EntityType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_convert4EntityTypeTo5EntityType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_convert4EntityTypeTo5EntityType]
  delete from GXDBVersions where name = 'sec_convert4EntityTypeTo5EntityType' and type = 5
END
GO

  CREATE FUNCTION sec_convert4EntityTypeTo5EntityType(@type1 INT, @type2 INT, @type3 INT, @type4 INT,
											 @id1 INT, @id2 INT, @id3 INT, @id4 INT)
	RETURNS @entity5Type TABLE
	(	clientId INT,
	appTypeId INT,
	instanceID INT,
	backupsetId INT,
	subclientId INT
	)
	AS
	BEGIN
	DECLARE @InstanceId INT = 0
	DECLARE @backupsetId INT = 0
	IF (@type3 = 0)			--no instance, backupset and subclient confusions
	BEGIN
		SET @instanceId = 0
		SET @backupsetID = 0
	END
	ELSE IF (@type3 = 2011)	--instance item
	BEGIN
		SET @InstanceId = @id3
		SET @backupsetId = 1
		IF @type4 = 2013	--subclient item
			SET @backupsetId = ISNULL ((SELECT TOP 1 backupSet FROM [APP_Application] WHERE id = @id4 ), 1)
		ELSE IF @type4 = 2012 --backupset item
		BEGIN
			SET @backupsetId = @id4
			SET @id4 = 0
		END
		ELSE --instance item, no backupset and subclient
			SET @backupsetId = 0
	END
	ELSE IF (@type3 = 2012)		--backupset item
	BEGIN
		SET @instanceID = 1
		SET @backupsetId = @id3
	END
	INSERT INTO @entity5Type
		SELECT @id1, @id2, @instanceId, @backupsetId, @id4
	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_convert4EntityTypeTo5EntityType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_convert4EntityTypeTo5EntityType' AND revision = '')

  insert into GXDBVersions values(5, 'sec_convert4EntityTypeTo5EntityType',  '', 'sec_convert4EntityTypeTo5EntityType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_EntityTypeToObjectType.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sec_EntityTypeToObjectType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_EntityTypeToObjectType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_EntityTypeToObjectType]
  delete from GXDBVersions where name = 'sec_EntityTypeToObjectType' and type = 5
END
GO

  CREATE FUNCTION sec_EntityTypeToObjectType(@entityType integer)
  	RETURNS INTEGER
  	AS
  	BEGIN
  			IF(@entityType=0)
				RETURN 0
			IF(@entityType = 1)
  				RETURN 2018
  			IF(@entityType = 28)
  				RETURN 2572
  			IF(@entityType = 3)
  				RETURN 2009
			IF(@entityType = 4)
				RETURN 2230
  			IF(@entityType = 5)
  				RETURN 2011
  			IF(@entityType = 6)
  				RETURN 2012
  			IF(@entityType = 7)
  				RETURN 2013
  			IF(@entityType = 11)
  				RETURN 2048
  			IF(@entityType = 9)
  				RETURN 2049
  			IF(@entityType = 21)
  				RETURN 8462
  			IF(@entityType = 35)
  				RETURN 4300
  			IF(@entityType = 83)
  				RETURN 14033
  			IF(@entityType = 90)
  				RETURN 9646
  			IF(@entityType = 53)
  				RETURN 8464
  			IF(@entityType = 124)
  				RETURN 9651
  			IF(@entityType = 17)			--storage policy
  				RETURN 2231
			IF(@entityType = 131)			--custom reports
				RETURN 2900
			IF(@entityType = 130)
				RETURN 8107
			IF(@entityType = 57)
				RETURN 8180
			IF(@entityType = 153)
				RETURN 9615
  			RETURN @entityType			--if no match is found, then give the same entity type
  	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_EntityTypeToObjectType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_EntityTypeToObjectType' AND revision = '')

  insert into GXDBVersions values(5, 'sec_EntityTypeToObjectType',  '', 'sec_EntityTypeToObjectType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_getCapabilityToPermissionMap.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sec_getCapabilityToPermissionMap'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_getCapabilityToPermissionMap]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_getCapabilityToPermissionMap]
  delete from GXDBVersions where name = 'sec_getCapabilityToPermissionMap' and type = 5
END
GO

	CREATE FUNCTION dbo.sec_getCapabilityToPermissionMap (@capabilityId INT, @shouldExpandPermissionsForCategory INT)
	RETURNS @permissionIdTbl TABLE
	(
	capabilityId INT,
	categoryId INT,
	permissionId INT
	)
	AS
	BEGIN
    IF(@capabilityId=7)
	BEGIN
			INSERT INTO @permissionIdTbl
			SELECT @capabilityId,categoryId, id
			FROM UMPermissions WHERE id=7
				INSERT INTO @permissionIdTbl
				SELECT @capabilityId,categoryId,id
				FROM UMPermissions WHERE id=65
	END
 	ELSE
	IF @capabilityId NOT IN (14)
	BEGIN
		INSERT INTO @permissionIdTbl
			SELECT @capabilityId, categoryid, id
			FROM UMPermissions
			WHERE (id = @capabilityid)
				  OR (@capabilityId = 33 AND id IN (110, 113)) 		--execute is mapped to workflow execute and monitoring policy execute
				  OR (@capabilityId = 34 AND id IN (109, 112)) 				--edit is mapped to workflow edit and monitoring policy edit
				  OR (@capabilityId = 35 AND id IN (111, 114))			--delete is mapped to workflow delete and monitoring policy delete
				  OR (@capabilityId IN (20,24) AND id IN (119))
							--Inplace restore, end user capability will have overwrite by default.
	END
	ELSE
		IF @shouldExpandPermissionsForCategory = 1
			INSERT INTO @permissionIdTbl
				SELECT @capabilityid, categoryId, id
				FROM UMPermissions
				WHERE categoryId = @capabilityId
		ELSE
			INSERT INTO @permissionIdTbl
				SELECT DISTINCT @capabilityId, categoryId, 0
				FROM UMPermissions
				WHERE categoryId = @capabilityid
	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_getCapabilityToPermissionMap]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_getCapabilityToPermissionMap' AND revision = '')

  insert into GXDBVersions values(5, 'sec_getCapabilityToPermissionMap',  '', 'sec_getCapabilityToPermissionMap', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_getCapabilityBitMaskToPermissionMap.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sec_getCapabilityBitMaskToPermissionMap'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_getCapabilityBitMaskToPermissionMap]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_getCapabilityBitMaskToPermissionMap]
  delete from GXDBVersions where name = 'sec_getCapabilityBitMaskToPermissionMap' and type = 5
END
GO

	CREATE FUNCTION dbo.sec_getCapabilityBitMaskToPermissionMap (@capabilities BIGINT, @shouldExpandPermissionsForCategory INT)
	RETURNS @permissionIdTbl TABLE
	(
	capabilityId INT,
	categoryId INT,
	permissionId INT
	)
	AS
	BEGIN
	DECLARE @capabilityTable TABLE (capabilityId INT)
	INSERT INTO @capabilityTable
		SELECT id
		FROM UMCapability
		WHERE CAST(POWER(2.0, id-1) AS BIGINT) & @capabilities <> 0
	INSERT INTO @permissionIdTbl
		SELECT DISTINCT Cap.capabilityId, Map.categoryId, Map.permissionId
		FROM @capabilityTable Cap CROSS APPLY sec_getCapabilityToPermissionMap(capabilityId, @shouldExpandPermissionsForCategory) Map
		WHERE Cap.capabilityId = Map.capabilityId

	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_getCapabilityBitMaskToPermissionMap]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_getCapabilityBitMaskToPermissionMap' AND revision = '')

  insert into GXDBVersions values(5, 'sec_getCapabilityBitMaskToPermissionMap',  '', 'sec_getCapabilityBitMaskToPermissionMap', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_getLocalizedCategory.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sec_getLocalizedCategory'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_getLocalizedCategory]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_getLocalizedCategory]
  delete from GXDBVersions where name = 'sec_getLocalizedCategory' and type = 5
END
GO

	CREATE FUNCTION sec_getLocalizedCategory (@categoryId INT, @LocaleId INT)
	RETURNS NVARCHAR(MAX)
	AS
	BEGIN
		DECLARE @categoryName NVARCHAR(MAX) = N''
		IF @categoryId <> 0
		SET @categoryName = ISNULL((SELECT message FROM EvlocaleMsgs WHERE localeId = @localeId AND messageId = (SELECT messageID FROM UMCategories WHERE id = @categoryId)),
									 (SELECT categoryname FROM UMCategories WHERE id = @categoryId))


	RETURN @categoryName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_getLocalizedCategory]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_getLocalizedCategory' AND revision = '')

  insert into GXDBVersions values(5, 'sec_getLocalizedCategory',  '', 'sec_getLocalizedCategory', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_getLocalizedPermission.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sec_getLocalizedPermission'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_getLocalizedPermission]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_getLocalizedPermission]
  delete from GXDBVersions where name = 'sec_getLocalizedPermission' and type = 5
END
GO

	CREATE FUNCTION sec_getLocalizedPermission (@permissionId INT, @LocaleId INT)
	RETURNS NVARCHAR(MAX)
	AS
	BEGIN
		DECLARE @permissionName NVARCHAR(MAX) = N''
		IF @permissionId <> 0
		SET @permissionName = ISNULL((SELECT message FROM EvlocaleMsgs WHERE localeId = @localeId AND messageId = (SELECT messageID FROM UMPermissions WHERE id = @permissionId)),
									 (SELECT permissionName FROM UMPermissions WHERE id = @permissionId))


	RETURN @permissionName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_getLocalizedPermission]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_getLocalizedPermission' AND revision = '')

  insert into GXDBVersions values(5, 'sec_getLocalizedPermission',  '', 'sec_getLocalizedPermission', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_getClientOwners.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sec_getClientOwners'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_getClientOwners]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_getClientOwners]
  delete from GXDBVersions where name = 'sec_getClientOwners' and type = 5
END
GO

    CREATE FUNCTION sec_getClientOwners(@flags integer)
	RETURNS @ownersTable TABLE (clientId INT, userId INT, userGroupId INT, externalGroupId INT)
	AS
	BEGIN
	IF dbo.isNewSecurity() = 1
	BEGIN
		DECLARE @tempTable TABLE (clientId INT, userId INT, userGroupId INT)
		INSERT INTO @tempTable
			SELECT Cli.id,
			CASE WHEN isUser = 1 THEN userOrGroupID ELSE 0 END,
		    CASE WHEN isUser = 0 THEN userOrGroupID ELSE 0 END
		    FROM UMOwners Owners INNER JOIN APP_Client Cli
			ON Owners.entityType = 1 AND Owners.entityId = 2
		INSERT INTO @tempTable
			SELECT CGA.clientId,
				   CASE WHEN isUser = 1 THEN userOrGroupID ELSE 0 END,
				   CASE WHEN isUser = 0 THEN userOrGroupID ELSE 0 END
			FROM UMOwners Owners INNER JOIN APP_ClientGroupAssoc CGA
			ON Owners.entityType = 28 AND Owners.entityId = CGA.clientGroupId
		INSERT INTO @tempTable
			SELECT Owners.entityid,
				   CASE WHEN isUser = 1 THEN userOrGroupID ELSE 0 END,
				   CASE WHEN isUser = 0 THEN userOrGroupID ELSE 0 END
			FROM UMOwners Owners
			WHERE Owners.entityType = 3
		INSERT INTO @ownersTable
			SELECT clientId, userId, 0, 0
			FROM @tempTable
			WHERE userID <> 0
			UNION
			SELECT clientId, userId, CASE WHEN umdsProviderID = 0 THEN id ELSE 0 END,
									 CASE WHEN umdsProviderID <> 0 THEN id ELSE 0 END
			FROM @tempTable Tbl INNER JOIN UMGroups G
			ON Tbl.userGroupId = G.id
			WHERE Tbl.userGRoupID <> 0
	END
	ELSE
	BEGIN
		INSERT INTO @ownersTable
			SELECT objectid, userId, CASE WHEN providerId = 0 THEN groupId ELSE 0 END, CASE WHEN providerId <> 0 THEN groupId ELSE 0 END
			FROM UMUserandGroupEntityAssociation
			WHERE entityType = 2009 AND (userId <> 0 OR groupId <> 0)
	END
	IF @flags = 1				--have to expand user groups to users
	BEGIN
			INSERT INTO @ownersTable
				SELECT clientID, 0, 0, GM.umdsGroupId
				FROM @ownersTable Tbl INNER JOIN UMDSGroupMaps GM
				ON Tbl.userGroupId = GM.umgroupId

			INSERT INTO @ownersTable
				SELECT clientID, UM.userId, 0, 0
				FROM @ownersTable Tbl INNER JOIN UMUserGroup UM
				ON Tbl.userGroupId = UM.groupId

			INSERT INTO @ownersTable
				SELECT clientID, UM.userId, 0, 0
				FROM @ownersTable Tbl INNER JOIN UMUserGroup UM
				ON Tbl.externalGroupId = UM.groupId
	END
	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_getClientOwners]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_getClientOwners' AND revision = '')

  insert into GXDBVersions values(5, 'sec_getClientOwners',  '', 'sec_getClientOwners', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_permissionToCapability.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sec_permissionToCapability'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_permissionToCapability]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_permissionToCapability]
  delete from GXDBVersions where name = 'sec_permissionToCapability' and type = 5
END
GO

	CREATE FUNCTION sec_permissionToCapability(@permissionId INTEGER)
	RETURNS  INT
	AS
	BEGIN
	DECLARE @capability INT
	IF EXISTS (SELECT id FROM UMCapability WHERE id = @permissionId)
	BEGIN
		SET @capability = (SELECT id FROM UMCapability WHERE id = @permissionId)
	END
	RETURN @capability
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_permissionToCapability]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_permissionToCapability' AND revision = '')

  insert into GXDBVersions values(5, 'sec_permissionToCapability',  '', 'sec_permissionToCapability', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_getOwnerPermissions.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sec_getOwnerPermissions'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_getOwnerPermissions]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_getOwnerPermissions]
  delete from GXDBVersions where name = 'sec_getOwnerPermissions' and type = 5
END
GO

    CREATE FUNCTION sec_getOwnerPermissions(@entityType int,@entityId int)
	RETURNS @permissionTable TABLE (permissionId INT)
	AS
	BEGIN
	IF dbo.isNewSecurity() = 1
	BEGIN
		INSERT INTO @permissionTable(permissionId)
		SELECT  RPE.permissionId
		FROM UMOwnerRoles ORoles JOIN UMrolesWithPermissionsExpanded RPE ON ORoles.roleId =Rpe.roleId
		WHERE entitytype=@entityType and entityId=@entityId and ORoles.roleId<>0
		UNION
		SELECT permissionId
		FROM UMOwnerRoles
		WHERE entitytype=@entityType and entityId=@entityId and permissionId<>0
   END
   RETURN
   END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_getOwnerPermissions]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_getOwnerPermissions' AND revision = '')

  insert into GXDBVersions values(5, 'sec_getOwnerPermissions',  '', 'sec_getOwnerPermissions', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getHTMLTableForAlerts.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: getHTMLTableForAlerts'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getHTMLTableForAlerts]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getHTMLTableForAlerts]
  delete from GXDBVersions where name = 'getHTMLTableForAlerts' and type = 5
END
GO

 CREATE FUNCTION getHTMLTableForAlerts (
     		@i_inXML		XML
     	)
     	RETURNS @htmlTblStr TABLE (
     		tblStr NVARCHAR(MAX)
     	)
     	AS
     	BEGIN

 			DECLARE @columnsList TABLE (id INT IDENTITY, columnName NVARCHAR(256),shldBePartOfOutput int)
 			DECLARE @rowColList table (rowId int,colIndex int,colVal nvarchar(max))
 			DECLARE @columnName NVARCHAR(256)
 			DECLARE @shldBePartOfOutput int
 			DECLARE @numberOfRows INT
 			set @numberOfRows = 0

 			SELECT @numberOfRows = @i_inXML.value('count(App_ExternalQueryResults/resultSet)', 'int')

 			INSERT INTO @columnsList(columnName,shldBePartOfOutput)
 			SELECT	T.cc.value('@val', 'nvarchar(1024)'),1
 			FROM	@i_inXML.nodes('App_ExternalQueryResults/colList/columnName') T(cc)

 			iNSERT INTO @rowColList
 			SELECT	T.cc.value('for $i in . return count(../../*[local-name(.)=''resultSet'' and . << $i])', 'int'),
			T.cc.value('for $j in . return count(../*[local-name(.)=''colValues'' and . << $j])', 'int')+1,
 			T.cc.value('@val', 'nvarchar(1024)')
 			FROM	@i_inXML.nodes('App_ExternalQueryResults/resultSet/colValues') T(cc)

 			Update @columnsList
 			set shldBePartOfOutput = 0
 			WHERE	columnName IN ('CommServ UniqueId', 'CommServer IP', 'CommServer GUID', 'Running Time in Seconds', 'CommCell ID')
 				OR	columnName LIKE '%<HIDDEN>%'

 			declare @CountOfColumns int = 0
 			select @CountOfColumns = count(*) from @columnsList

 			-- Create table Header
 			DECLARE @th NVARCHAR(MAX) = N''
 			DECLARE @td NVARCHAR(MAX) = N''
 			DECLARE columnCursor CURSOR FOR
 			SELECT columnName,shldBePartOfOutput FROM @columnsList ORDER BY id
 			OPEN columnCursor
 			FETCH FROM columnCursor INTO @columnName,@shldBePartOfOutput
 			WHILE @@FETCH_STATUS = 0
 			BEGIN
 				if @shldBePartOfOutput=1
 				begin
 					SET @th += '<TH style="background-color: #666666;color: #FFFFFF;padding: 5px;font-weight: bold;text-align: left;font-size: 12px !important;">'+ @columnName + '</TH>'
 				end
 				FETCH FROM columnCursor INTO @columnName,@shldBePartOfOutput
 			END
 			CLOSE columnCursor
			IF @th <> ''
                SET @th = '<TR class="header" style="padding-right: 0; margin-left: 0; padding-top: 15px; margin-top: 5px; border-left-width: 1px; border-right-width: 1px; border-left-style: solid; padding-bottom: 15px; border-right-style: solid; border-top-style: solid; border-bottom-style: solid; border-top-width: 1px; margin-bottom: 5px; border-bottom-width: 1px; font-size: 12px; margin-right: 0; background-color: #F4F4F4; padding-left: 0; text-align: center;">' + @th + '</TR>'

 			DECLARE @rowIndex INT = 1
 			DECLARE @colIndexTemp INT = 1
 			DECLARE @temp NVARCHAR(1024) = N''
 			WHILE @rowIndex <= @numberOfRows
 			BEGIN
 				IF @rowIndex % 2 = 0
                    SET @td += '<TR class="even">'
                ELSE
                    SET @td += '<TR class="odd">'
 				set @colIndexTemp = 1

 				WHILE @colIndexTemp<=@CountOfColumns
 				BEGIN
 					set @shldBePartOfOutput = 1
 					select  @shldBePartOfOutput = shldBePartOfOutput from @columnsList
 					where id = @colIndexTemp

 					if (@shldBePartOfOutput = 1)
 					begin
 						set @temp = ''
 						SELECT	@temp = colVal FROM @ROWCOLList where rowId=@rowIndex and colIndex=@colIndexTemp
 						IF @rowIndex % 2 = 0
 						begin
							SET @td += '<TD style="background-color: #F9F9F9;padding: 5px;font-size: 12px !important;">' + ISNULL(@temp, '') + '</TD>'
						end
						ELSE
						begin
							SET @td += '<TD style="background-color: #EAEAEA;padding: 5px;font-size: 12px !important;">' + ISNULL(@temp, '') + '</TD>'
						end
 					end
 					set @colIndexTemp = @colIndexTemp + 1
 				END

 				SET @rowIndex = @rowIndex + 1
 				SET @td += '</TR>'
 			END

 			DEALLOCATE columnCursor
 			INSERT INTO @htmlTblStr
 			SELECT '<TABLE class="datatable" style="border: 1px solid #CCCCCC;border-collapse: collapse;color: #444444 !important;font-family: helvetica,arial,sans-serif;font-size: 12px !important;width: 100%;text-align: left;">'+@th+@td+'</TABLE>'

     		RETURN
     	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getHTMLTableForAlerts]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getHTMLTableForAlerts' AND revision = '1.3')

  insert into GXDBVersions values(5, 'getHTMLTableForAlerts',  '1.3', 'getHTMLTableForAlerts', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getHTMLTableForCustomAlert.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: getHTMLTableForCustomAlert'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getHTMLTableForCustomAlert]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getHTMLTableForCustomAlert]
  delete from GXDBVersions where name = 'getHTMLTableForCustomAlert' and type = 5
END
GO

 CREATE FUNCTION getHTMLTableForCustomAlert (
     		@i_inXML		XML
     	)
     	RETURNS @htmlTblStr TABLE (
     		tblStr NVARCHAR(MAX)
     	)
     	AS
     	BEGIN

 			DECLARE @columnsList TABLE (id INT IDENTITY, columnName NVARCHAR(256),shldBePartOfOutput int)
 			DECLARE @rowColList table (rowId int,colIndex int,colVal nvarchar(max))
 			DECLARE @columnName NVARCHAR(256)
 			DECLARE @shldBePartOfOutput int
 			DECLARE @numberOfRows INT
 			set @numberOfRows = 0

 			SELECT @numberOfRows = @i_inXML.value('count(App_CustomRuleResults/resultSet)', 'int')

 			INSERT INTO @columnsList(columnName,shldBePartOfOutput)
 			SELECT	T.cc.value('@val', 'nvarchar(1024)'),
 				T.cc.value('@shldBePartOfOutput','int')
 			FROM	@i_inXML.nodes('App_CustomRuleResults/colList/columnName') T(cc)

 			iNSERT INTO @rowColList
 			SELECT	T.cc.value('for $i in . return count(../../*[local-name(.)=''resultSet'' and . << $i])', 'int'),
			T.cc.value('for $j in . return count(../*[local-name(.)=''colValues'' and . << $j])', 'int')+1,
 			dbo.DecodeInvalidXmlChar(T.cc.value('@val', 'nvarchar(1024)'))
 			FROM	@i_inXML.nodes('App_CustomRuleResults/resultSet/colValues') T(cc)


 			declare @CountOfColumns int = 0
 			select @CountOfColumns = count(*) from @columnsList

 			-- Create table Header
 			DECLARE @th NVARCHAR(MAX) = N''
 			DECLARE @td NVARCHAR(MAX) = N''
 			DECLARE columnCursor CURSOR FOR
 			SELECT columnName,shldBePartOfOutput FROM @columnsList ORDER BY id
 			OPEN columnCursor
 			FETCH FROM columnCursor INTO @columnName,@shldBePartOfOutput
 			WHILE @@FETCH_STATUS = 0
 			BEGIN
 				if @shldBePartOfOutput=1
 				begin
 					SET @th += '<TH style="background-color: #666666;color: #FFFFFF;padding: 5px;font-weight: bold;text-align: left;font-size: 12px !important;">'+ @columnName + '</TH>'
 				end
 				FETCH FROM columnCursor INTO @columnName,@shldBePartOfOutput
 			END
 			CLOSE columnCursor
			IF @th <> ''
                SET @th = '<TR class="header" style="padding-right: 0; margin-left: 0; padding-top: 15px; margin-top: 5px; border-left-width: 1px; border-right-width: 1px; border-left-style: solid; padding-bottom: 15px; border-right-style: solid; border-top-style: solid; border-bottom-style: solid; border-top-width: 1px; margin-bottom: 5px; border-bottom-width: 1px; font-size: 12px; margin-right: 0; background-color: #F4F4F4; padding-left: 0; text-align: center;">' + @th + '</TR>'

 			DECLARE @rowIndex INT = 1
 			DECLARE @colIndexTemp INT = 1
 			DECLARE @temp NVARCHAR(1024) = N''
 			WHILE @rowIndex <= @numberOfRows
 			BEGIN
 				IF @rowIndex % 2 = 0
                    SET @td += '<TR class="even">'
                ELSE
                    SET @td += '<TR class="odd">'
 				set @colIndexTemp = 1

 				WHILE @colIndexTemp<=@CountOfColumns
 				BEGIN
 					set @shldBePartOfOutput = 1
 					select  @shldBePartOfOutput = shldBePartOfOutput from @columnsList
 					where id = @colIndexTemp

 					if (@shldBePartOfOutput = 1)
 					begin
 						set @temp = ''
 						SELECT	@temp = colVal FROM @ROWCOLList where rowId=@rowIndex and colIndex=@colIndexTemp
 						IF @rowIndex % 2 = 0
 						begin
							SET @td += '<TD style="background-color: #F9F9F9;padding: 5px;font-size: 12px !important;">' + ISNULL(@temp, '') + '</TD>'
						end
						ELSE
						begin
							SET @td += '<TD style="background-color: #EAEAEA;padding: 5px;font-size: 12px !important;">' + ISNULL(@temp, '') + '</TD>'
						end
 					end
 					set @colIndexTemp = @colIndexTemp + 1
 				END

 				SET @rowIndex = @rowIndex + 1
 				SET @td += '</TR>'
 			END

 			DEALLOCATE columnCursor
 			INSERT INTO @htmlTblStr
 			SELECT '<TABLE class="datatable" style="border: 1px solid #CCCCCC;border-collapse: collapse;color: #444444 !important;font-family: helvetica,arial,sans-serif;font-size: 12px !important;width: 100%;text-align: left;">'+@th+@td+'</TABLE>'

     		RETURN
     	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getHTMLTableForCustomAlert]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getHTMLTableForCustomAlert' AND revision = '1.4')

  insert into GXDBVersions values(5, 'getHTMLTableForCustomAlert',  '1.4', 'getHTMLTableForCustomAlert', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgClientHasLibrary.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgClientHasLibrary'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgClientHasLibrary]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgClientHasLibrary]
  delete from GXDBVersions where name = 'scgClientHasLibrary' and type = 5
END
GO

	CREATE FUNCTION scgClientHasLibrary(@clientid INTEGER,@operation NVARCHAR(10),@libraryPattern NVARCHAR(1024))
	RETURNS INTEGER
	BEGIN
		DECLARE @output INTEGER = 0
		DECLARE @islibPresent INTEGER = 0
		IF @operation = 'E_WITH'
		SET @librarypattern = '%'+@librarypattern
		IF @operation = 'S_WITH'
		SET @librarypattern = @librarypattern+'%'
		IF @operation = 'LIKE' or @operation = 'N_LIKE'
		SET @librarypattern = '%'+@librarypattern+'%'
		IF EXISTS (SELECT 1 FROM
		app_application app WITH (NOLOCK)
		inner join archGroup   ag WITH (NOLOCK)  ON (app.dataArchGrpID = ag.id or app.logArchGrpID = ag.id) and app.clientid = @clientid
		inner join archGroupCopy agc WITH (NOLOCK) ON agc.archGroupId = ag.id
		inner join MMDataPath dph WITH (NOLOCK)  ON agc.id  = dph.CopyId
		inner join MMDrivePool dp WITH (NOLOCK)  ON dph.DrivePoolId  = dp.DrivePoolId
		inner join MMMasterPool mp WITH (NOLOCK)  ON dp.MasterPoolId = mp.MasterPoolId
		inner join mmlibrary l WITH (NOLOCK)  ON  mp.LibraryId = l.LibraryId
		WHERE l.Aliasname like @libraryPattern and l.LibraryId !=0 )
		SET @islibPresent = 1
		IF (@operation = '!=' or @operation = 'N_LIKE')
		BEGIN
			IF @islibPresent = 0
			SET @output = 1
		END
		ELSE
		BEGIN
		    	IF @islibPresent =1
		    	SET @output =1
		END
		RETURN @output
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgClientHasLibrary]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgClientHasLibrary' AND revision = '')

  insert into GXDBVersions values(5, 'scgClientHasLibrary',  '', 'scgClientHasLibrary', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgIsExternalUserGroupClientOwner.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgIsExternalUserGroupClientOwner'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgIsExternalUserGroupClientOwner]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgIsExternalUserGroupClientOwner]
  delete from GXDBVersions where name = 'scgIsExternalUserGroupClientOwner' and type = 5
END
GO

	CREATE FUNCTION scgIsExternalUserGroupClientOwner(@clientId integer, @operation varchar(8), @groupName nvarchar(max) )
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
	--Requirement - Client should have at least one owner as group
	DECLARE @result integer = 0
		IF EXISTS(SELECT * FROM  sec_getClientOwners(1) owners
		WHERE externalGroupId IN
		(
		 (select g.id From UMDSgroups g
		INNER JOIN UMDSProviders p on p.id=g.umdsProviderId
		WHERE  	((@operation = 'LIKE' AND p.domainname + '\' + g.name LIKE '%' + @groupName + '%') OR
	(@operation = 'N_LIKE' AND p.domainname + '\' + g.name  NOT LIKE '%' + @groupName + '%') OR
	(@operation = '=' AND p.domainname + '\' + g.name  = @groupName) OR
	(@operation = '!=' AND p.domainname + '\' + g.name  <> @groupName) OR
	(@operation = 'S_WITH' AND p.domainname + '\' + g.name LIKE  @groupName + '%'	) OR
	(@operation = 'E_WITH' AND p.domainname + '\' + g.name  LIKE   '%' + @groupName 	)
	)))
		 and owners.clientID=@clientId)
	BEGIN
		SET @result = 1
	END
	RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgIsExternalUserGroupClientOwner]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgIsExternalUserGroupClientOwner' AND revision = '1.3')

  insert into GXDBVersions values(5, 'scgIsExternalUserGroupClientOwner',  '1.3', 'scgIsExternalUserGroupClientOwner', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgIsLocalUserGroupClientOwner.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgIsLocalUserGroupClientOwner'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgIsLocalUserGroupClientOwner]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgIsLocalUserGroupClientOwner]
  delete from GXDBVersions where name = 'scgIsLocalUserGroupClientOwner' and type = 5
END
GO

	CREATE FUNCTION scgIsLocalUserGroupClientOwner(@clientId integer, @operation varchar(8), @groupName nvarchar(255) )
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
	--Requirement - Client should have at least one owner as group
	DECLARE @recCount integer = 0
	DECLARE @result integer = 0
	IF EXISTS(SELECT owners.clientId FROM sec_getClientOwners(1) owners WHERE owners.clientId = @clientId AND
    (usergroupId IN (SELECT id FROM UMGroups um with(nolock)  WHERE ((@operation = 'LIKE' AND um.name  LIKE '%' + @groupName + '%') OR
	(@operation = 'N_LIKE' AND um.name  NOT LIKE '%' + @groupName + '%') OR
	(@operation = '=' AND um.name  = @groupName) OR
	(@operation = '!=' AND um.name  <> @groupName) OR
	(@operation = 'S_WITH' AND um.name  LIKE  @groupName + '%'	) OR
	(@operation = 'E_WITH' AND um.name  LIKE   '%' + @groupName 	)
	)	)  ))
	BEGIN
		SET @result = 1
	END
	RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgIsLocalUserGroupClientOwner]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgIsLocalUserGroupClientOwner' AND revision = '1.3')

  insert into GXDBVersions values(5, 'scgIsLocalUserGroupClientOwner',  '1.3', 'scgIsLocalUserGroupClientOwner', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgIsUserClientOwner.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgIsUserClientOwner'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgIsUserClientOwner]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgIsUserClientOwner]
  delete from GXDBVersions where name = 'scgIsUserClientOwner' and type = 5
END
GO

	CREATE FUNCTION scgIsUserClientOwner(@clientId integer, @operation varchar(8), @loginName nvarchar(255) )
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
	--Requirement - Client should have at least one owner as user
	DECLARE @includeUsersFlags int = -1;
	SET @includeUsersFlags = ( CAST (0x001 AS INT) ) --( CAST (0x001 AS INT) )
	DECLARE @result integer = 0
	IF Exists(SELECT owners.clientID FROM sec_getClientOwners(1) owners
	INNER JOIN
	(SELECT distinct id  FROM UMUsers with(nolock)  WHERE flags & @includeUsersFlags <> 0 AND
	((@operation = 'LIKE' AND login LIKE '%' + @loginName + '%') OR
	(@operation = 'N_LIKE' AND login NOT LIKE '%' + @loginName + '%') OR
	(@operation = '=' AND login = @loginName) OR
	(@operation = '!=' AND login <> @loginName) OR
	(@operation = 'S_WITH' AND login LIKE  @loginName + '%'	) OR
	(@operation = 'E_WITH' AND login LIKE   '%' + @loginName 	)
	)) u
	ON owners.userId = u.id AND owners.clientId	= @clientId)
	SET @result = 1
	RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgIsUserClientOwner]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgIsUserClientOwner' AND revision = '1.3')

  insert into GXDBVersions values(5, 'scgIsUserClientOwner',  '1.3', 'scgIsUserClientOwner', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsClientOwner.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsClientOwner'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsClientOwner]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsClientOwner]
  delete from GXDBVersions where name = 'IsClientOwner' and type = 5
END
GO

	CREATE FUNCTION IsClientOwner(@clientId integer,@userId integer)
	RETURNS INT
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result INT = 0


		IF EXISTS( SELECT owners.clientID FROM sec_getClientOwners(1) owners
		WHERE owners.userId = @UserId AND owners.clientId = @clientiD)
			SET @result=1


		RETURN @result
	END




GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsClientOwner]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsClientOwner' AND revision = '')

  insert into GXDBVersions values(5, 'IsClientOwner',  '', 'IsClientOwner', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsPseudoClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsPseudoClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsPseudoClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsPseudoClient]
  delete from GXDBVersions where name = 'IsPseudoClient' and type = 5
END
GO

	CREATE FUNCTION IsPseudoClient(@clientId integer)
	RETURNS INT
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result INT = 0
		DECLARE @status INT = 0
		DECLARE @specialClientFlags INT = 0

		-- PROCCED ONLY IF NO PACKAGES EXIST, ELSE ITS NOT A PSEUDO CLIENT
		IF EXISTS (SELECT * FROM SIMINSTALLEDPACKAGES WHERE clientId = @clientId)
		BEGIN
			SET @result = 0
			RETURN @result
		END

		SELECT @status = C.status , @specialClientFlags = specialClientFlags  FROM APP_CLIENT C WHERE C.id = @clientId

		-- DEPENDENT on status flags (DAG/RAC/DB2DBF/NAS/REFERENCE COPY)
		SET @result = (SELECT CASE
			WHEN (@status & 0x0040    ) > 0 THEN 1
			WHEN (@status & 0x0080			) > 0 THEN 1
			WHEN (@status & 0x0200       ) > 0 THEN 1
			WHEN (@status & 0x200000			) > 0 THEN 1
			WHEN (@status & 0x400000 ) > 0 THEN 1
			WHEN (@status & 0x4000000) > 0 THEN 1
			WHEN (@status & 0x2000000		) > 0 THEN 1
			WHEN (@status & 0x20000000		) > 0 THEN 1
			END)

		IF @result = 1
			RETURN @result


		-- DISCOVERED CLIENTS
		IF EXISTS(SELECT ACP.componentNameId  FROM APP_ClientProp ACP WHERE ACP.componentNameId = @clientId AND ( ACP.attrName = 'Virtual Server Discovered Clients'  OR ACP.attrName = 'Mini SRM Agent' ) AND attrval = '1')
		BEGIN
			SET @result = 1
			RETURN @result
		END

		-- VS PSEUDO CLIENTS
		IF EXISTS(select distinct Ida.id from app_idaprop IdaProp,APP_IDAName Ida where Ida.clientId = @clientId and IdaProp.componentNameId = Ida.id and attrName = 'Pseudo Apptype' and attrVal = '1')
		BEGIN
			SET @result = 1
			RETURN @result
		END

		-- OPENVMS CLIENTS	N_CV_OS_ID_OPENVMS = 38
		IF EXISTS(SELECT * FROM APP_Client WHERE id = @clientId AND simOperatingSystemId = 38)
		BEGIN
			SET @result = 1
			RETURN @result
		END

		--EDC CLIENTS
		IF EXISTS(SELECT  * FROM app_clientgroup CG INNER JOIN app_clientGroupAssoc CGA  ON CG.id = CGA.clientGroupId and CGA.clientId = @clientId
			WHERE ((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200)))
		BEGIN
			SET @result = 1
			RETURN @result
		END

		-- WINDOWS/LINUX DUMMY CLIENTS -- SAME_COMMCELL_GALAXY_PACKAGES_ABSENT. THIS FLAG WOULD BE SET FOR PACKAGES WHICH IS UINSTALLED. SO ADD ADDITIONAL CHECKS
		IF(@specialClientFlags & 0x02) <> 0
		BEGIN
			IF EXISTS(SELECT * FROM APP_APPLICATION WHERE clientId = @clientId) OR EXISTS(SELECT * FROM LICUSAGE WHERE Cid = @clientId)
				SET @result = 0
			ELSE
				SET @result = 1
		END

		RETURN ISNULL(@result,0)
	END




GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsPseudoClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsPseudoClient' AND revision = '1.3')

  insert into GXDBVersions values(5, 'IsPseudoClient',  '1.3', 'IsPseudoClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetNASProxyVersion.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetNASProxyVersion'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetNASProxyVersion]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetNASProxyVersion]
  delete from GXDBVersions where name = 'GetNASProxyVersion' and type = 5
END
GO

 	CREATE FUNCTION GetNASProxyVersion(@subclientId INTEGER, @jobType integer=0)
 	RETURNS INT
 	WITH ENCRYPTION
 	AS
 	BEGIN
 	DECLARE @releaseId INTEGER=0
 	DECLARE @inClientId INTEGER = NULL
 	DECLARE @inAppType INTEGER = NULL
 	DECLARE @proxyClientId INTEGER = 0
	DECLARE @onepass INTEGER = 0

	SELECT TOP 1  @inClientId = [clientId],
 			 @inAppType = [appTypeid]
				FROM APP_Application App WITH (NOLOCK)
				INNER JOIN APP_CLIENT C WITH (NOLOCK)
				ON App.id = @subclientId AND
 				C.id = App.clientId AND
 				(C.Status & 0x0080) = 0x0080

	IF ( @inClientId IS NULL)
 	BEGIN
 		RETURN @releaseId
 	END

 	-- NAS ONE PASS
 	SELECT TOP 1 @onepass = 1
 			FROM	App_subclientProp WITH (NOLOCK)
 			WHERE	componentnameId = @subclientId
 			AND attrName = N'Is Turbo Subclient' and modified = 0 and attrVal = '1'

 	IF @jobType = 1 AND @onepass = 0 --- SNAP TO TAPE
 	BEGIN
 		-- find the nas proxy clientId defined on subclient property
 		SET @proxyClientId = ISNULL((SELECT CONVERT(INT, attrVal)
 			FROM	App_subclientProp WITH (NOLOCK)
 			WHERE	componentnameId = @subclientId
 			AND attrName = N'Snap to tape : proxy to use' and modified = 0),0)
 	END

 	IF @proxyClientId = 0 AND @onepass = 0 -- SNAP AND ONE PASS ARE MUTUALLY EXCLUSIVE
 	BEGIN
 		-- find the nas proxy clientId defined on subclient property
 		SET @proxyClientId = ISNULL((SELECT CONVERT(INT, attrVal)
 			FROM	App_subclientProp WITH (NOLOCK)
 			WHERE	componentnameId = @subclientId
 			AND attrName = N'Snap copy : proxy to use' and modified = 0),0)
 	END

 	IF @proxyClientId = 0
 	BEGIN
 		-- find the nas proxy clientId defined on subclient property
 		SET @proxyClientId = ISNULL((SELECT CONVERT(INT, attrVal)
 			FROM	App_subclientProp WITH (NOLOCK)
 			WHERE	componentnameId = @subclientId
 			AND attrName = N'Turbo NAS Proxy Client' and modified = 0),0)
 	END

 	IF @proxyClientId = 0
 	BEGIN
 		SET @proxyClientId = ISNULL((SELECT CONVERT(INT, attrVal)
 		FROM	App_IdaProp WITH (NOLOCK)
 		WHERE	componentnameId = (SELECT id FROM App_IdaName WHERE clientId = @inclientId and appTypeId =  @inAppType)
 		AND attrName = N'FPOLICY PRIMARY CLIENT' and modified = 0),0)
 	END

 	SET @releaseId = (SELECT releaseId FROM App_client where id = @proxyClientId)
 	RETURN @releaseId

 	END




GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetNASProxyVersion]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetNASProxyVersion' AND revision = '')

  insert into GXDBVersions values(5, 'GetNASProxyVersion',  '', 'GetNASProxyVersion', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetUserName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetUserName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetUserName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetUserName]
  delete from GXDBVersions where name = 'GetUserName' and type = 5
END
GO

	CREATE FUNCTION GetUserName (@userId INTEGER)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
	IF  @userId IS NULL OR @userId = 0
		RETURN NULL
	DECLARE @userName NVARCHAR(1024) = (SELECT name FROM UMUsers WHERE id = @userId)
	RETURN @userName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetUserName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetUserName' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetUserName',  '1.2', 'GetUserName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetEventSeverityString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetEventSeverityString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetEventSeverityString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetEventSeverityString]
  delete from GXDBVersions where name = 'GetEventSeverityString' and type = 5
END
GO

	CREATE FUNCTION GetEventSeverityString (@severity INTEGER, @localeId INTEGER = 0)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
	IF  @severity IS NULL
		RETURN ''
	DECLARE @severityTxt NVARCHAR(1024) = (CASE WHEN @severity = 9 THEN DBO.fn_EvFormatEventMsgText(0,@localeId,1023410763,0,2)
											WHEN  @severity = 3 THEN DBO.fn_EvFormatEventMsgText(0,@localeId,1023410761,0,2)
											WHEN  @severity = 6 THEN DBO.fn_EvFormatEventMsgText(0,@localeId,1023410762,0,2)
											WHEN  @severity = 0 THEN DBO.fn_EvFormatEventMsgText(0,@localeId,1023410760,0,2)
  											ELSE '' END)
	RETURN @severityTxt
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetEventSeverityString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetEventSeverityString' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetEventSeverityString',  '1.2', 'GetEventSeverityString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetCommCellNameFromId.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetCommCellNameFromId'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetCommCellNameFromId]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetCommCellNameFromId]
  delete from GXDBVersions where name = 'GetCommCellNameFromId' and type = 5
END
GO

	CREATE FUNCTION GetCommCellNameFromId (@commcellId INTEGER)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
	IF  @commcellId IS NULL OR @commcellId = 0
		RETURN NULL
	DECLARE @commCellName NVARCHAR(1024) = (SELECT aliasName FROM APP_CommCell WHERE id = @commcellId)
	RETURN @commCellName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetCommCellNameFromId]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetCommCellNameFromId' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetCommCellNameFromId',  '1.2', 'GetCommCellNameFromId', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetDriveAliasName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetDriveAliasName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetDriveAliasName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetDriveAliasName]
  delete from GXDBVersions where name = 'GetDriveAliasName' and type = 5
END
GO

	CREATE FUNCTION GetDriveAliasName (@driveId INTEGER)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
	IF  @driveId IS NULL OR @driveId = 0
		RETURN NULL
	DECLARE @driveAliasName NVARCHAR(1024) = (SELECT AliasName FROM MMDrive WHERE DriveId = @driveId)
	RETURN @driveAliasName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetDriveAliasName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetDriveAliasName' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetDriveAliasName',  '1.2', 'GetDriveAliasName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetMediaBarCode.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetMediaBarCode'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetMediaBarCode]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetMediaBarCode]
  delete from GXDBVersions where name = 'GetMediaBarCode' and type = 5
END
GO

	CREATE FUNCTION GetMediaBarCode (@mediaId INTEGER)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
	AS
	BEGIN
	IF @mediaId IS NULL OR  @mediaId = 0
		RETURN NULL
	DECLARE @mediaName NVARCHAR(1024) = (SELECT BarCode FROM MMMedia WHERE MediaId = @mediaId)
	RETURN @mediaName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetMediaBarCode]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetMediaBarCode' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetMediaBarCode',  '1.2', 'GetMediaBarCode', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetLibraryAliasName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetLibraryAliasName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetLibraryAliasName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetLibraryAliasName]
  delete from GXDBVersions where name = 'GetLibraryAliasName' and type = 5
END
GO

	CREATE FUNCTION GetLibraryAliasName (@libraryId INTEGER)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
 	AS
	BEGIN
	IF @libraryId IS NULL OR  @libraryId = 0
		RETURN NULL
	DECLARE @libName NVARCHAR(1024) = (SELECT AliasName FROM MMLibrary WHERE LibraryId = @libraryId)
	RETURN @libName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetLibraryAliasName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetLibraryAliasName' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetLibraryAliasName',  '1.2', 'GetLibraryAliasName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetQueryDisplayNameForNTRule.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: GetQueryDisplayNameForNTRule'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetQueryDisplayNameForNTRule]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetQueryDisplayNameForNTRule]
  delete from GXDBVersions where name = 'GetQueryDisplayNameForNTRule' and type = 5
END
GO

	CREATE FUNCTION GetQueryDisplayNameForNTRule (@notificationId INTEGER)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
 	AS
	BEGIN
	declare @queryCriteriaName nvarchar(max)
	declare @queryParamsInfo xml
	declare @queryId int
	select
	@queryParamsInfo = xmlInfo,
	@queryId = QueryId
	from NTNotificationQueryMapping
	where NTNotificationQueryMapping.NtNotificationId = @notificationId

	select @queryCriteriaName = NTQueryList.queryName
	from NTqueryList where queryId = @queryId

	return @queryCriteriaName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetQueryDisplayNameForNTRule]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetQueryDisplayNameForNTRule' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetQueryDisplayNameForNTRule',  '1.4', 'GetQueryDisplayNameForNTRule', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/NTGetSqlDataType.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: NTGetSqlDataType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTGetSqlDataType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NTGetSqlDataType]
  delete from GXDBVersions where name = 'NTGetSqlDataType' and type = 5
END
GO

	CREATE FUNCTION NTGetSqlDataType (@inputType nvarchar(max))
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
 	AS
	BEGIN
	if (@inputType like '%commvault.msgs%')
	begin
		return 'int'
	end
	if (@inputType like '%integer%')
	begin
		return 'int'
	end
	if (@inputType like '%boolean%')
	begin
		return 'bit'
	end
	if (@inputType like '%datetime%')
	begin
		return 'datetime'
	end
	if (@inputType like '%date%')
	begin
		return 'datetime'
	end
	if (@inputType like '%double%')
	begin
		return 'float'
	end
	if (@inputType like '%float%')
	begin
		return 'float'
	end
	if (@inputType like '%long%')
	begin
		return 'bigint'
	end
	if (@inputType like '%time%')
	begin
		return 'datetime'
	end
	if (@inputType like '%short%')
	begin
		return 'int'
	end
	if (@inputType like '%xml%')
	begin
		return 'xml'
	end
	return 'nvarchar(max)'
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NTGetSqlDataType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NTGetSqlDataType' AND revision = '1.4')

  insert into GXDBVersions values(5, 'NTGetSqlDataType',  '1.4', 'NTGetSqlDataType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/NTGetListDataType.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: NTGetListDataType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTGetListDataType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NTGetListDataType]
  delete from GXDBVersions where name = 'NTGetListDataType' and type = 5
END
GO

	CREATE FUNCTION NTGetListDataType (@inputType nvarchar(max))
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
 	AS
	BEGIN
	if (@inputType like '%commvault.msgs%')
	begin
		return 'CVListEntity'
	end
	if (@inputType like '%integer%')
	begin
		return 'CVListInt'
	end
	if (@inputType like '%boolean%')
	begin
		return 'CVListBit'
	end
	if (@inputType like '%datetime%')
	begin
		return 'CVListDatetime'
	end
	if (@inputType like '%date%')
	begin
		return 'CVListDatetime'
	end
	if (@inputType like '%double%')
	begin
		return 'CVListFloat'
	end
	if (@inputType like '%float%')
	begin
		return 'CVListFloat'
	end
	if (@inputType like '%long%')
	begin
		return 'CVListBigint'
	end
	if (@inputType like '%time%')
	begin
		return 'CVListDatetime'
	end
	if (@inputType like '%short%')
	begin
		return 'CVListInt'
	end
	if (@inputType like '%xml%')
	begin
		return 'CVListXml'
	end
	return 'CVListNvarchar'
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NTGetListDataType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NTGetListDataType' AND revision = '1.3')

  insert into GXDBVersions values(5, 'NTGetListDataType',  '1.3', 'NTGetListDataType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetCurrentAvgQITimeMedian.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetCurrentAvgQITimeMedian'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetCurrentAvgQITimeMedian]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetCurrentAvgQITimeMedian]
  delete from GXDBVersions where name = 'GetCurrentAvgQITimeMedian' and type = 5
END
GO

	CREATE FUNCTION GetCurrentAvgQITimeMedian(@SIDBStoreId int, @SubStoreId int, @CommCellId int, @DaysToConsider int)
	RETURNS bigint
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @SubStoresAvgQITime table (SubStoreId int, AvgQITime bigint, RowNumber int)
		DECLARE @SubStoresMedianAvgQITime table (SubStoreId int, AvgQITime bigint)
		DECLARE @AvgQITimeMedian bigint = 0
		DECLARE @DayStartOnDaysToConsider int = 0

		IF (@DaysToConsider = 0)
		BEGIN
			SELECT	TOP 1 @DaysToConsider = ISNULL(value, 3)
			FROM	MMConfigs WITH (READUNCOMMITTED)
			WHERE	name = 'MMCONFIG_STORE_LIMIT_EVENT_DAYS_TO_CONSIDER'
		END
		SET @DayStartOnDaysToConsider = dbo.GetUnixTime(dbo.ClientLocalToUTCTime(DATEADD(DAY, datediff(DAY, 0, GETDATE()), -@DaysToConsider), 2))

		INSERT 	INTO @SubStoresAvgQITime
		SELECT 	SubStoreId, AvgQITime,
				ROW_NUMBER() OVER (PARTITION BY SubStoreId ORDER BY AvgQITime ASC) AS RowNumber
		FROM 	IdxSIDBUsageHistory WITH (READUNCOMMITTED)
		WHERE 	HistoryType = 2
				AND SIDBStoreId = @SIDBStoreId
				AND (@SubStoreId = 0 OR SubStoreId = @SubStoreId)
				AND CommCellId = @CommCellId
				AND ModifiedTime >= @DayStartOnDaysToConsider
		--Cleanup if we dont have records for number of days to consider, we dont need such stores.
		DELETE SSD1
		FROM @SubStoresAvgQITime SSD1,
		(
			SELECT SubStoreId FROM @SubStoresAvgQITime GROUP BY SubStoreId HAVING COUNT(*) < @DaysToConsider
		) SSD2
		WHERE SSD1.SubStoreId = SSD2.SubstoreId

		INSERT INTO @SubStoresMedianAvgQITime
		SELECT SubStoreId,  AVG(AvgQITime)
		FROM (
				SELECT	SubStoreId, AvgQITime,
				RowNumber AS RowNumAsc,
				ROW_NUMBER() OVER (PARTITION BY SubStoreId ORDER BY RowNumber DESC) AS RowNumDesc
				FROM 	@SubStoresAvgQITime
			) Usage
		WHERE RowNumAsc IN (RowNumDesc, RowNumDesc - 1, RowNumDesc + 1)
		GROUP BY SubStoreId
		SELECT @AvgQITimeMedian = ISNULL(MAX(AvgQITime), 0)
		FROM @SubStoresMedianAvgQITime


		RETURN @AvgQITimeMedian
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetCurrentAvgQITimeMedian]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetCurrentAvgQITimeMedian' AND revision = '1.5')

  insert into GXDBVersions values(5, 'GetCurrentAvgQITimeMedian',  '1.5', 'GetCurrentAvgQITimeMedian', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/AlertDetectedTimeInUTC.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: AlertDetectedTimeInUTC'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[AlertDetectedTimeInUTC]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[AlertDetectedTimeInUTC]
  delete from GXDBVersions where name = 'AlertDetectedTimeInUTC' and type = 5
END
GO

				CREATE FUNCTION AlertDetectedTimeInUTC( @timeStr NVARCHAR(128))
				RETURNS DATETIME
				WITH ENCRYPTION
				BEGIN
				--@timeStr Format 'Tue Feb 11 21:46:48 2014'
				DECLARE strCur CURSOR FOR
				SELECT data FROM dbo.SplitString(@timeStr, ' ')
				DECLARE @i_level NVARCHAR(128)
				DECLARE @YEAR VARCHAR(32)
				DECLARE @MON VARCHAR(32)
				DECLARE @DAY VARCHAR(32)
				DECLARE @TIME VARCHAR(32)
				DECLARE @i INTEGER = 1
				OPEN strCur
				FETCH NEXT FROM strCur INTO @i_level
				WHILE @@FETCH_STATUS = 0
				BEGIN
						IF @i = 1
							goto Fetch_Next
						IF @i = 2
							SET @MON = (CASE @i_level WHEN 'Jan' THEN '01' WHEN 'Feb' THEN '02' WHEN 'Mar' THEN '03'
										WHEN 'Apr' THEN '04' WHEN 'May' THEN '05' WHEN 'Jun' THEN '06' WHEN 'Jul' THEN '07'
											WHEN 'Aug' THEN '08' WHEN 'Sep' THEN '09' WHEN 'Oct' THEN '10' WHEN 'Nov' THEN '11'
												WHEN 'Dec' THEN '12' END)
						IF @i =3
							SET @DAY =  @i_level

						IF @i = 4
							SET @TIME = @i_level
						IF @i = 5
							SET @YEAR =	@i_level

				Fetch_Next:
					SET @i = @i +1
					FETCH NEXT FROM strCur INTO @i_level
				END
				CLOSE strCur
				DEALLOCATE strCur
				DECLARE @FINAL VARCHAR(128) = @YEAR + '-' +@MON +'-'+ @DAY + ' ' + @TIME
				RETURN dbo.CellLocalToUTCTime(CONVERT(datetime,@FINAL),2)
				END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [AlertDetectedTimeInUTC]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'AlertDetectedTimeInUTC' AND revision = '')

  insert into GXDBVersions values(5, 'AlertDetectedTimeInUTC',  '', 'AlertDetectedTimeInUTC', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/ProperCase.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ProperCase'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ProperCase]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ProperCase]
  delete from GXDBVersions where name = 'ProperCase' and type = 5
END
GO

 			CREATE FUNCTION ProperCase
 			(@string VARCHAR(255))
			RETURNS VARCHAR(255) AS
			BEGIN
			-- Declarations
			DECLARE @return VARCHAR(255)
			DECLARE @len INT
			DECLARE @finished BIT
			DECLARE @pos INT
			DECLARE @thischar CHAR(1)
			DECLARE @thisasc INT
			DECLARE @capitalise BIT
			-- Initialise
			SELECT @finished = 0
			SELECT @string = LOWER(@string)
			SELECT @return = @string
			SELECT @len = DATALENGTH(@return)
			-- Failsafe
			IF @len = 0
			SELECT @finished = 1
			-- Loop over all characters: capitalise first character and those after spaces, replace underscores with spaces
			SELECT @pos = 0
			SELECT @capitalise = 1
			WHILE @finished = 0
			BEGIN
			-- Next position in string
				SELECT @pos = @pos + 1
				-- Done?
				IF @pos > @len
					SELECT @finished = 1
				ELSE
				BEGIN
					-- Read this character
					SELECT @thischar = SUBSTRING(@return, @pos, 1)
					SELECT @thisasc = ASCII(@thischar)
					IF @thischar IN ('_', ' ')
					BEGIN
						SELECT @return = LEFT(@return, @pos - 1) + ' ' + RIGHT(@return, @len - @pos)
						SELECT @capitalise = 1
					END
					ELSE
					BEGIN
						IF @capitalise = 1 AND (@thisasc BETWEEN 97 AND 122)
						BEGIN
							SELECT @thisasc = @thisasc - 32
							SELECT @return = LEFT(@return, @pos - 1) + CHAR(@thisasc) + RIGHT(@return, @len - @pos)
							SELECT @capitalise = 0
						END
					END
				END
			END
			-- Done
			RETURN @return
			END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ProperCase]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ProperCase' AND revision = '1.3')

  insert into GXDBVersions values(5, 'ProperCase',  '1.3', 'ProperCase', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/MMS2FUNC_CheckForPruningOpWindowOnMA.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MMS2FUNC_CheckForPruningOpWindowOnMA'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MMS2FUNC_CheckForPruningOpWindowOnMA]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MMS2FUNC_CheckForPruningOpWindowOnMA]
  delete from GXDBVersions where name = 'MMS2FUNC_CheckForPruningOpWindowOnMA' and type = 5
END
GO

 			create function MMS2FUNC_CheckForPruningOpWindowOnMA (@hostID integer)
			returns bit
			as
			begin

				declare @clientTimeMidNight dateTime = CAST (CAST (dbo.UTCToClientLocalTime(GETUTCDATE(),@hostID) as date) as datetime)
				declare @clientTimeZoned dateTime = dbo.ClientLocalToUTCTime(@clientTimeMidnight, @hostID)
				declare @unixTimeOnClient integer = dbo.getUnixTime(@clientTimeZoned)
				declare @clientTime datetime = dbo.UTCToClientLocalTime(GETUTCDATE(),@hostID)
				declare @currentTime integer = ( (datepart(hh,@clientTime) + CAST(datepart(mi,@clientTime) as FLOAT)/CAST(60 AS FLOAT) + CAST(datepart(ss,@clientTime) AS FLOAT)/CAST(3600 AS FLOAT))*3600)
				declare @dayOnClient integer = ( power(2, DATEPART (dw, @clientTime) - 1) )
				declare @tmpOperationTbl table (hostId integer, startDate integer, endDate integer, daysOfWeek integer, startTime integer, endTime integer)

				insert into @tmpOperationTbl
				select clientId, startDate, endDate, daysOfWeek, startTime, endTime
				from APP_OpWindowRule where clientId = @hostID and opType = 131072 -- add optype in the where clause later

				if( (select count (*) from @tmpOperationTbl) = 0)
				begin
					return 0
				end
				else
				begin

					IF EXISTS(
					select * from @tmpOperationTbl t
					where (startdate <> 0 and enddate <> 0  and @unixTimeOnClient between startDate and (endDate+ 86499))
					AND (t.daysOfWeek & @dayOnClient) > 0
					AND @currentTime between startTime and endTime

								UNION

					SELECT * from @tmpOperationTbl t
					WHERE (startDate = 0 and endDate<>0 and @unixTimeOnClient <= (endDate+ 86499) )
					AND (t.daysOfWeek & @dayOnClient) > 0
					AND @currentTime between startTime and endTime

								UNION
					SELECT * from @tmpOperationTbl t
					WHERE (startDate = 0 and endDate = 0)
					AND (t.daysOfWeek & @dayOnClient) > 0
					AND @currentTime between startTime and endTime

								UNION
					SELECT * from @tmpOperationTbl t
					WHERE (startDate <> 0 and endDate = 0 and startDate <= @unixTimeOnClient)
					AND (t.daysOfWeek & @dayOnClient) > 0
					AND @currentTime between startTime and endTime

					)
					begin
						return 1
					end
					else
					begin
						return 0
					end
				end
			return 0
			end



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MMS2FUNC_CheckForPruningOpWindowOnMA]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MMS2FUNC_CheckForPruningOpWindowOnMA' AND revision = '')

  insert into GXDBVersions values(5, 'MMS2FUNC_CheckForPruningOpWindowOnMA',  '', 'MMS2FUNC_CheckForPruningOpWindowOnMA', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsUserOwnerofLockedClient.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsUserOwnerofLockedClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsUserOwnerofLockedClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsUserOwnerofLockedClient]
  delete from GXDBVersions where name = 'IsUserOwnerofLockedClient' and type = 5
END
GO

 CREATE FUNCTION IsUserOwnerofLockedClient(@userId integer)
 RETURNS INT
 WITH ENCRYPTION
 AS
 BEGIN
 	DECLARE @result INT = 0


 	IF EXISTS( SELECT owners.clientID FROM sec_getClientOwners (1) owners
 	WHERE owners.userId = @userID
 	AND owners.clientId in (SELECT distinct componentNameId from App_clientProp where attrName = 'Enable Data Security' and attrVal = '1' and modified =0 ) )
 		SET @result=1


 	RETURN @result
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsUserOwnerofLockedClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsUserOwnerofLockedClient' AND revision = '')

  insert into GXDBVersions values(5, 'IsUserOwnerofLockedClient',  '', 'IsUserOwnerofLockedClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientOSVersion.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientOSVersion'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientOSVersion]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientOSVersion]
  delete from GXDBVersions where name = 'scgGetClientOSVersion' and type = 5
END
GO

	CREATE FUNCTION scgGetClientOSVersion(@i_clientId integer)
	RETURNS NVARCHAR(max)
	WITH ENCRYPTION
	AS
	BEGIN
	declare @simOsInfo nvarchar(2048)
	declare @osName nvarchar(255)
	declare @osRel nvarchar(255)
	declare @osInfo nvarchar(1024)
	declare @isNas int = 0
	declare @osId int = 0
	declare @clientStatus int = 0
	declare @simOSId int = 0
	set @simOsInfo = (select attrval from APP_ClientProp with (nolock) where attrName like 'sim os info' and componentNameId = @i_clientId)
    SET @osName = dbo.GetClientOSName(@i_clientId, @simOsInfo)
	select @clientStatus = status, @simOSId = simOperatingSystemId from APP_Client with (nolock) where id = @i_clientId
	if @osName is NULL or @osName = ''
	    set @osName = (select name from simOperatingSystem with (nolock) where id = @simOSId)
	set @isNas = (select (case Type
	                when 'Any' then (case SubType
	                                    when 'NAS' then 1
	                                    else 0
	                                    end)
	else 0
	                end)
	                from simOperatingSystem with (nolock) where id = @simOSId)
	if @isNas <> 0 and @clientStatus & 2 != 2
	begin
	      if @clientStatus & 0x8000000 = 0
	      begin
	          set @osInfo = ISNULL((SELECT FirmwareRevision from MMNDMPHostInfo with (nolock) where ClientId = @i_clientId),'')
	          if @osInfo <> ''
	                set @osName = @osName + N' ' + @osInfo
	          end
	      else
	            set @osName = ''
	end
	RETURN @osName
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientOSVersion]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientOSVersion' AND revision = '1.3')

  insert into GXDBVersions values(5, 'scgGetClientOSVersion',  '1.3', 'scgGetClientOSVersion', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgGetClientProductVersion.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgGetClientProductVersion'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgGetClientProductVersion]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgGetClientProductVersion]
  delete from GXDBVersions where name = 'scgGetClientProductVersion' and type = 5
END
GO

	CREATE FUNCTION scgGetClientProductVersion(@i_clientId integer)
	RETURNS NVARCHAR(max)
	WITH ENCRYPTION
	AS
	BEGIN
	declare @SPVersionInfo nvarchar(255) = ''
	declare @virtual int = 0
	declare @physicalClientId int = 0
	declare @clientVersion nvarchar(255) = ''
	SELECT	@SPVersionInfo = ISNULL([SP Version Info], N''),
			@virtual = ISNULL([Virtual client], 0),
			@physicalClientId = ISNULL([Active Physical Node], 0),
			@clientVersion = ISNULL([Client Version], N'')
				FROM
				(
							SELECT	componentNameId, attrName, attrVal
									FROM	App_ClientProp with (nolock)
										WHERE	componentNameId = @i_clientId
											AND		modified = 0
				) AS clients
				PIVOT
				(
						MAX(attrVal)
						FOR attrName IN
						(
								[SP Version Info],
								[Virtual client],
								[Active Physical Node],
								[Client Version]

						)
				) AS pvt
	if @virtual = 1
	begin
	    set @SPVersionInfo = (select attrVal from app_clientprop with (nolock) where componentNameId = @physicalClientId and attrName = 'SP Version Info')
	end
	if @SPVersionInfo is NULL or @SPVersionInfo = N''
	begin
	    set @SPVersionInfo = N''
	    if @clientVersion is not NULL
	    begin
	        if @clientVersion = N'9.0.0(BUILD84)'
	            set @SPVersionInfo = N'9.0 R2'
	        else
	            set @SPVersionInfo = @clientVersion
	    end
	end
	RETURN @SPVersionInfo
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgGetClientProductVersion]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgGetClientProductVersion' AND revision = '1.3')

  insert into GXDBVersions values(5, 'scgGetClientProductVersion',  '1.3', 'scgGetClientProductVersion', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/getHtmlUnEscapedString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: getHtmlUnEscapedString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[getHtmlUnEscapedString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[getHtmlUnEscapedString]
  delete from GXDBVersions where name = 'getHtmlUnEscapedString' and type = 5
END
GO

    CREATE FUNCTION getHtmlUnEscapedString (@message nvarchar(max))
    RETURNS nvarchar(max)
    AS BEGIN
    set @message = replace(@message,"&amp;", "&")
    set @message = replace(@message,'&lt;','<')
    set @message = replace(@message,'&gt;','>')
    RETURN @message
    END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [getHtmlUnEscapedString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'getHtmlUnEscapedString' AND revision = '1.2')

  insert into GXDBVersions values(5, 'getHtmlUnEscapedString',  '1.2', 'getHtmlUnEscapedString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/isNewSecurity.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: isNewSecurity'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[isNewSecurity]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[isNewSecurity]
  delete from GXDBVersions where name = 'isNewSecurity' and type = 5
END
GO

	CREATE FUNCTION isNewSecurity()
	RETURNS INT
	BEGIN
		DECLARE @isSecurityNew AS INT
		SET @isSecurityNew = (ISNULL((SELECT CASE WHEN CAST(value AS NVARCHAR(10))= 'false' AND enabled = 1 THEN 0 ELSE 1 END FROM APP_AdvanceSettings WHERE keyName = 'bEnableNewSecurity'),1))
		RETURN @isSecurityNew
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [isNewSecurity]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'isNewSecurity' AND revision = '')

  insert into GXDBVersions values(5, 'isNewSecurity',  '', 'isNewSecurity', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/fn_WeedOutHtmlTags.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: fn_WeedOutHtmlTags'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[fn_WeedOutHtmlTags]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[fn_WeedOutHtmlTags]
  delete from GXDBVersions where name = 'fn_WeedOutHtmlTags' and type = 5
END
GO

	CREATE FUNCTION fn_WeedOutHtmlTags(@inputString nvarchar(max))
	RETURNS NVARCHAR(max)
	WITH ENCRYPTION
 	AS
	BEGIN
	declare @i int=0
	declare @done bit=0
	declare @newBuf NVARCHAR(max)
	declare @leftPos int
	declare @rightPos int
	set @newBuf=''
	set @leftPos=0

	if(len(@inputString)=0)
	begin
		return @inputString
	end

	set @inputString = replace(@inputString,'<br>',' ')
	while(len(@inputString)>0)
	begin
		-- Identify the start of a tag
		set @leftPos  = CHARINDEX(N'<', @inputString,@leftPos)
		if(@leftPos = 0)
		begin
			break
		end
		-- Identify the end of a tag
		set @rightPos = CHARINDEX(N'>', @inputString,@leftPos)
		if(@rightPos=0)
		begin
			break
		end
		set @inputString = stuff(@inputString,@leftPos,@rightPos - @leftPos+1,'')
	end

	set @inputString = replace(@inputString,'&nbsp;',' ')
	return LTRIM(RTRIM(@inputString))
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [fn_WeedOutHtmlTags]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'fn_WeedOutHtmlTags' AND revision = '1.3')

  insert into GXDBVersions values(5, 'fn_WeedOutHtmlTags',  '1.3', 'fn_WeedOutHtmlTags', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/NTGetSqlDataTypeFRomLMDataType.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: NTGetSqlDataTypeFRomLMDataType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTGetSqlDataTypeFRomLMDataType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NTGetSqlDataTypeFRomLMDataType]
  delete from GXDBVersions where name = 'NTGetSqlDataTypeFRomLMDataType' and type = 5
END
GO

	CREATE FUNCTION NTGetSqlDataTypeFRomLMDataType (@inputType int)
	RETURNS NVARCHAR(1024)
	WITH ENCRYPTION
 	AS
	BEGIN
	if (@inputType=20)
	begin
		return 'xml'
	end
	if (@inputType=0)
	begin
		return 'int'
	end
	if (@inputType=15)
	begin
		return 'bit'
	end
	if (@inputType=7)
	begin
		return 'datetime'
	end
	if (@inputType=2)
	begin
		return 'datetime'
	end
	if (@inputType=16)
	begin
		return 'float'
	end
	if (@inputType=17)
	begin
		return 'float'
	end
	if (@inputType=18)
	begin
		return 'bigint'
	end
	if (@inputType=3)
	begin
		return 'datetime'
	end
	if (@inputType=19)
	begin
		return 'int'
	end
	if (@inputType=8)
	begin
		return 'int'
	end
	if ((@inputType>=9) and @inputType<=14)
	begin
		return 'int'
	end
	return 'nvarchar(max)'
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NTGetSqlDataTypeFRomLMDataType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NTGetSqlDataTypeFRomLMDataType' AND revision = '1.2')

  insert into GXDBVersions values(5, 'NTGetSqlDataTypeFRomLMDataType',  '1.2', 'NTGetSqlDataTypeFRomLMDataType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/NTGetAssociationFromCommcellTreeNode.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: NTGetAssociationFromCommcellTreeNode'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTGetAssociationFromCommcellTreeNode]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NTGetAssociationFromCommcellTreeNode]
  delete from GXDBVersions where name = 'NTGetAssociationFromCommcellTreeNode' and type = 5
END
GO

    CREATE FUNCTION NTGetAssociationFromCommcellTreeNode(@xmlEntityList xml)
    RETURNS xml
    AS BEGIN

    IF @xmlEntityList.exist('CVGui_CommCellTreeNode/associations') = 1
    BEGIN
       GOTO ENDFUNC
    END

    -- For retrieving entity information stored in older format in CommcellTreeNode under clients and clientgroups node
    DECLARE @EntityListTableTemp TABLE
			(
					_type_  INT ,
		            clientGroupId INT DEFAULT 0 ,
					clientGroupName nvarchar(MAX) default '',
					clientId INT DEFAULT 0 ,
					clientName nvarchar(MAX) default '',
					applicationId  INT DEFAULT 0,
					applicationName nvarchar(MAX) default '',
					instanceId  INT DEFAULT 0 ,
					instanceName nvarchar(MAX) default '',
					backupsetId INT DEFAULT 0,
					backupsetName nvarchar(MAX) default '',
					subclientId INT DEFAULT 0,
					subclientName nvarchar(MAX) default '',
					mediaAgentId INT DEFAULT 0 ,
					mediaAgentName nvarchar(MAX) default '',
					schedulePolicyId INT  DEFAULT 0,
					schedulePolicyName nvarchar(MAX) default '',
					libraryId INT DEFAULT 0 ,
					libraryName nvarchar(MAX) default '',
					storagePolicyId INT DEFAULT 0,
					storagePolicyName nvarchar(MAX) default '',
					copyId  INT  DEFAULT 0,
					copyName nvarchar(MAX) default '',
					trackingPolicyId INT DEFAULT 0,
					trackingPolicyName nvarchar(MAX) default '',
					workflowId INT DEFAULT 0,
					workflowName nvarchar(MAX) default '',
					monitoringPolicyId INT DEFAULT 0,
					monitoringPolicyName nvarchar(MAX) default '',
					criteriaId INT DEFAULT 0,
					criteriaName nvarchar(MAX) default ''
				)

    INSERT INTO @EntityListTableTemp
    (_type_ )
		SELECT  CASE
					WHEN ISNULL(ref.value('@includeAll','INT'),0) = 1 THEN 27 --ALL_CLIENT_GROUPS_ENTITY = 27
				END AS _type_
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/clientGroups') R(ref)


		INSERT INTO @EntityListTableTemp
		(_type_ , clientGroupId , clientGroupName )
		SELECT  28 AS '_type_' ,  -- CLIENT_GROUP_ENTITY = 28
				ISNULL(ref.value('@clientGroupId','INT'),0) AS 'clientGroupId' ,
				ISNULL(ref.value('@name','nvarchar(MAX)'),'') AS 'clientGroupName'
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/clientGroups/clientGroups') R(ref)


		INSERT INTO @EntityListTableTemp
		(_type_ )
		SELECT  CASE
					WHEN ISNULL(ref.value('@includeAll','INT'),0) = 1 THEN 2 --ALL_CLIENTS = 2
				END AS _type_
		FROM @xmlEntityList.nodes('/CVGui_CommCellTreeNode/clients') R(ref)

		INSERT INTO @EntityListTableTemp
		(_type_ , clientId , clientName , applicationId , applicationName , instanceId , instanceName , backupsetId , backupsetName , subclientId , subclientName )
		SELECT
			   CASE
					WHEN ISNULL(ref.value('@subclientId','INT'),0) <> 0 THEN 7 -- SUBCLIENT_ENTITY = 7,
					WHEN ISNULL(ref.value('@backupsetId','INT'),0) <> 0 THEN 6 -- BACKUPSET_ENTITY = 6,
					WHEN ISNULL(ref.value('@instanceId','INT'),0) <> 0 THEN 5 -- INSTANCE_ENTITY = 5,
					WHEN ISNULL(ref.value('@idaTypeId','INT'),0) <> 0 THEN 4 -- APPTYPE_ENTITY = 4,
					WHEN ISNULL(ref.value('@clientId','INT'),0) <> 0 THEN 3 --CLIENTS = 3
				END AS _type_ ,

				ISNULL(ref.value('@clientId','INT'),0) AS 'clientId' ,
				ISNULL(ref.value('@clientName','nvarchar(MAX)'),'') AS 'clientName',
				ISNULL(ref.value('@idaTypeId','INT'),0) AS 'applicationId' ,
				ISNULL(ref.value('@idaName','nvarchar(MAX)'),'') AS 'applicationName',
				ISNULL(ref.value('@instanceId','INT'),0) AS 'instanceId' ,
				ISNULL(ref.value('@instanceName','nvarchar(MAX)'),'') AS 'instanceName',
				ISNULL(ref.value('@backupsetId','INT'),0) AS 'backupsetId' ,
				ISNULL(ref.value('@backupsetName','nvarchar(MAX)'),'') AS 'backupsetName',
				ISNULL(ref.value('@subclientId','INT'),0) AS 'subclientId' ,
				ISNULL(ref.value('@subclientName','nvarchar(MAX)'),'') AS 'subclientName'
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/clients/clients') R(ref)




		INSERT INTO @EntityListTableTemp
		(_type_ )
		SELECT  CASE
					WHEN ISNULL(ref.value('@includeAll','INT'),0) = 1 THEN 10 -- ALL_MEDIAAGENTS = 10,
				END AS _type_
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/mediaAgents') R(ref)


		INSERT INTO @EntityListTableTemp
		(_type_ , mediaAgentId , mediaAgentName )
		SELECT  11 AS '_type_' ,  -- MEDIAAGENT_ENTITY = 11,
				ISNULL(ref.value('@mediaAgentId','INT'),0) AS 'mediaAgentId' ,
				ISNULL(ref.value('@name','nvarchar(MAX)'),'') AS 'mediaAgentName'
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/mediaAgents/mediaAgents') R(ref)



		INSERT INTO @EntityListTableTemp
		(_type_ )
		SELECT  CASE
					WHEN ISNULL(ref.value('@includeAll','INT'),0) = 1 THEN 8 -- LIBRARIES_ENTITY = 8,
				END AS _type_
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/libraries') R(ref)


		INSERT INTO @EntityListTableTemp
		(_type_ , libraryId , libraryName )
		SELECT  9 AS '_type_' ,  --  LIBRARY_ENTITY = 9,
				ISNULL(ref.value('@libraryID','INT'),0) AS 'libraryId' ,
				ISNULL(ref.value('@name','nvarchar(MAX)'),'') AS 'libraryName'
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/libraries/libraries') R(ref)



		INSERT INTO @EntityListTableTemp
		(_type_ )
		SELECT  CASE
					WHEN ISNULL(ref.value('@includeAll','INT'),0) = 1 THEN 16 -- STORAGE_POLICIES_ENTITY = 16,
				END AS _type_
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/storagePolcies') R(ref)


		INSERT INTO @EntityListTableTemp
		(_type_ , storagePolicyId , storagePolicyName, copyId , copyName )
		SELECT  CASE
					WHEN ISNULL(ref.value('@copyId','INT'),0) <> 0 THEN 18 --STORAGE_POLICY_COPY_ENTITY = 18,
					WHEN ISNULL(ref.value('@backupsetId','INT'),0) <> 0 THEN 17 --STORAGE_POLICY_ENTITY = 17
				END AS _type_ ,
				ISNULL(ref.value('@storagePolicyId','INT'),0) AS 'storagePolicyId' ,
			ISNULL(ref.value('@spName','nvarchar(MAX)'),'') AS 'storagePolicyName' ,
				ISNULL(ref.value('@copyId','INT'),0) AS 'copyId' ,
				ISNULL(ref.value('@copyName','nvarchar(MAX)'),'') AS 'copyName'
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/storagePolcies/policies') R(ref)


		INSERT INTO @EntityListTableTemp
		(_type_ )
		SELECT  CASE
					WHEN ISNULL(ref.value('@includeAll','INT'),0) = 1 THEN 20 -- TRACKING_POLICIES_ENTITY = 20,
				END AS _type_
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/trackingPolicies') R(ref)


		INSERT INTO @EntityListTableTemp
		(_type_ , trackingPolicyId , trackingPolicyName )
		SELECT  21 AS '_type_' ,  --   TRACKING_POLICY_ENTITY = 21,
				ISNULL(ref.value('@trackingPolicyId','INT'),0) AS 'trackingPolicyId' ,
				ISNULL(ref.value('@name','nvarchar(MAX)'),'') AS 'trackingPolicyName'
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/trackingPolicies/policies') R(ref)


		--  TrackingSchedules   trackingSchedules --  no need to import to new protocol ( undable to move to generic enities )
		-- entitis   --  no need to import to new protocol ( undable to move to generic enities )
		-- Tracking jobs --  no need to import to new protocol ( undable to move to generic enities )



		INSERT INTO @EntityListTableTemp
		(_type_ )
		SELECT  CASE
					WHEN ISNULL(ref.value('@includeAll','INT'),0) = 1 THEN 95 -- LM_ALL_CRITERIAS_ENTITY = 95,
				END AS _type_
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/criterias') R(ref)


		INSERT INTO @EntityListTableTemp
		(_type_ , monitoringPolicyId , monitoringPolicyName , criteriaId , criteriaName )
		SELECT  96 AS '_type_' ,  --    LM_CRITERIA_ENTITY = 96,
				ISNULL(ref.value('@monitoringPolicyId','INT'),0) AS 'monitoringPolicyId' ,
				'' AS 'monitoringPolicyName' ,
				ISNULL(ref.value('@criteriaId','INT'),0) AS 'criteriaId' ,
				ISNULL(ref.value('@criteriaName','nvarchar(MAX)'),'') AS 'criteriaName'
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/criterias/criterias') R(ref)


		INSERT INTO @EntityListTableTemp
		(_type_ )
		SELECT  CASE
					WHEN ISNULL(ref.value('@includeAll','INT'),0) = 1 THEN 114 --  ALL_WORKFLOW = 114,
				END AS _type_
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/workflows') R(ref)


		INSERT INTO @EntityListTableTemp
		(_type_ , workflowId , workflowName  )
		SELECT  83 AS '_type_' ,  --  WORKFLOW_ENTITY = 83,
				ISNULL(ref.value('@workflowId','INT'),0) AS 'workflowId' ,
				ISNULL(ref.value('@workflowName','nvarchar(MAX)'),'') AS 'workflowName'
		FROM @xmlEntityList.nodes ('/CVGui_CommCellTreeNode/workflows/workflows') R(ref)



		DECLARE @associationXml xml

		SET @associationXml =
								 (
								  SELECT _type_ AS '@_type_',
									clientGroupId AS '@clientGroupId',
									clientGroupName AS '@clientGroupName',
									clientId AS '@clientId',
									clientName AS '@clientName',
									applicationId  AS '@applicationId',
									applicationName AS '@appName',
									instanceId  AS '@instanceId',
									instanceName AS '@instanceName',
									backupsetId AS '@backupsetId',
									backupsetName AS '@backupsetName',
									subclientId AS '@subclientId',
									subclientName AS '@subclientName',
									mediaAgentId AS '@mediaAgentId',
									mediaAgentName AS '@mediaAgentName',
									schedulePolicyId AS '@schedulePolicyId',
									schedulePolicyName AS '@schedulePolicyName',
									libraryId AS '@libraryId',
									libraryName AS '@libraryName',
									storagePolicyId AS '@storagePolicyId',
									storagePolicyName AS '@storagePolicyName',
									copyId  AS '@copyId',
									copyName AS '@copyName',
									trackingPolicyId AS '@trackingPolicyId',
									trackingPolicyName AS '@trackingPolicyName',
									workflowId AS '@workflowId',
									workflowName AS '@workflowName',
									monitoringPolicyId AS '@policyId',
									monitoringPolicyName AS '@policyName',
									criteriaId AS '@criteriaId',
									criteriaName AS '@criteriaName'
								  FROM @EntityListTableTemp
								  WHERE _type_ IS NOT NULL
								  FOR XML PATH ('associations'),TYPE
								 )

		set @xmlEntityList.modify('insert(
										   sql:variable("@associationXml")
										 ) into
										 (/CVGui_CommCellTreeNode[1])'
								 )


		ENDFUNC:
		IF @xmlEntityList.exist('CVGui_CommCellTreeNode/clientGroups') = 1
		BEGIN
			set @xmlEntityList.modify('delete  /CVGui_CommCellTreeNode/clientGroups')
		END
		IF @xmlEntityList.exist('CVGui_CommCellTreeNode/clients') = 1
		BEGIN
			set @xmlEntityList.modify('delete  /CVGui_CommCellTreeNode/clients')
		END
		IF @xmlEntityList.exist('CVGui_CommCellTreeNode/mediaAgents') = 1
		BEGIN
			set @xmlEntityList.modify('delete  /CVGui_CommCellTreeNode/mediaAgents')
		END
		IF @xmlEntityList.exist('CVGui_CommCellTreeNode/libraries') = 1
		BEGIN
			set @xmlEntityList.modify('delete  /CVGui_CommCellTreeNode/libraries')
		END
		IF @xmlEntityList.exist('CVGui_CommCellTreeNode/storagePolcies') = 1
		BEGIN
			set @xmlEntityList.modify('delete  /CVGui_CommCellTreeNode/storagePolcies')
		END
		IF @xmlEntityList.exist('CVGui_CommCellTreeNode/trackingPolicies') = 1
		BEGIN
			set @xmlEntityList.modify('delete  /CVGui_CommCellTreeNode/trackingPolicies')
		END
		IF @xmlEntityList.exist('CVGui_CommCellTreeNode/criterias') = 1
		BEGIN
			set @xmlEntityList.modify('delete  /CVGui_CommCellTreeNode/criterias')
		END
		IF @xmlEntityList.exist('CVGui_CommCellTreeNode/workflows') = 1
		BEGIN
			set @xmlEntityList.modify('delete  /CVGui_CommCellTreeNode/workflows')
		END

        return @xmlEntityList
       END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NTGetAssociationFromCommcellTreeNode]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NTGetAssociationFromCommcellTreeNode' AND revision = '1.5')

  insert into GXDBVersions values(5, 'NTGetAssociationFromCommcellTreeNode',  '1.5', 'NTGetAssociationFromCommcellTreeNode', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/SplitStringMaxLen.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SplitStringMaxLen'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SplitStringMaxLen]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SplitStringMaxLen]
  delete from GXDBVersions where name = 'SplitStringMaxLen' and type = 5
END
GO

	CREATE FUNCTION [dbo].[SplitStringMaxLen]
	(
		@RowData nvarchar(max),
		@SplitOn nvarchar(256)
	)
	RETURNS @RtnValue table
	(
		Id int identity(1,1),
		Data nvarchar(max)
	)
	AS
	BEGIN
	Declare @Cnt int
	Set @Cnt = 1
	Declare @dummy INT = 0
	DECLARE @quoteIndex INT = 0
	DECLARE @splitIndex INT = 0
	While @dummy = 0
	Begin
		SET @quoteIndex = CHARINDEX('"',@RowData)
		SET @splitIndex = CHARINDEX(@SplitOn,@RowData)
		IF @splitIndex = 0
			BREAK
		IF ( @quoteIndex <> 0 AND @quoteIndex < @splitIndex )
		BEGIN
			IF (CHARINDEX('"', @RowData, @quoteIndex + 1) > 0)
			BEGIN
				Insert Into @RtnValue (data)
				Select
				Data = ltrim(rtrim(Substring(@RowData,@quoteIndex + LEN(@SplitOn),(CHARINDEX('"', @RowData, @quoteIndex + 1)-2))))
				Set @RowData = Substring(@RowData,Charindex('"',@RowData, @quoteIndex + 1)+2,len(@RowData))
			END
		END
		ELSE
		BEGIN
			Insert Into @RtnValue (data)
			Select
				Data = ltrim(rtrim(Substring(@RowData,1,Charindex(@SplitOn,@RowData)-1)))
			Set @RowData = Substring(@RowData,Charindex(@SplitOn,@RowData)+LEN(@SplitOn),len(@RowData))
		END
		Set @Cnt = @Cnt + 1
	End
	IF LEN(LTRIM(RTRIM(@ROWDATA))) <> 0
		Insert Into @RtnValue (data)
			Select Data = ltrim(rtrim(@RowData))
	Return
	END
	GO



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SplitStringMaxLen]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SplitStringMaxLen' AND revision = '1.1')

  insert into GXDBVersions values(5, 'SplitStringMaxLen',  '1.1', 'SplitStringMaxLen', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsGUID.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsGUID'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsGUID]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsGUID]
  delete from GXDBVersions where name = 'IsGUID' and type = 5
END
GO

	create function IsGUID(@str as NVARCHAR(255))
	returns
	int
	AS
	BEGIN
		declare @ret int
		select  @ret = 0,
            @str = replace(replace(@str, '{', ''), '}', '')
		if len(isnull(@str, '')) = 36 and
			@str NOT LIKE '%[^0-9A-Fa-f-]%' and
			-- check for proper positions of hyphens (-)
			charindex('-', @str) = 9 and
			charindex('-', @str, 10) = 14 and
			charindex('-', @str, 15) = 19 and
			charindex('-', @str, 20) = 24 and
			charindex('-', @str, 25) = 0
			set @ret = 1

    return @ret
	End



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsGUID]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsGUID' AND revision = '1.2')

  insert into GXDBVersions values(5, 'IsGUID',  '1.2', 'IsGUID', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/NTGetUsersforSubscriptionAlert.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: NTGetUsersforSubscriptionAlert'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTGetUsersforSubscriptionAlert]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NTGetUsersforSubscriptionAlert]
  delete from GXDBVersions where name = 'NTGetUsersforSubscriptionAlert' and type = 5
END
GO

	CREATE FUNCTION NTGetUsersforSubscriptionAlert(@notifId integer, @clientId integer, @escLevel integer,@clientInAlertEntityList integer)
	RETURNS
	@userSubscriptionListFinal table (userId int)
	WITH ENCRYPTION
	AS
	BEGIN
	IF NOT EXISTS (select 1 from NTnotificationRule where [ID] = @notifId and (status & 128)>0)
	begin
		return
	end

	declare @RecepientsList table
	(
		userId		int,
		type		int
	)

	declare @userSubscription table
	(
		userId int,
		flags int,
		preferenceLevel int
	)

	INSERT @RecepientsList(userId, type)
	SELECT	userId, 0
	FROM	sec_getCLientOwners(0) owners
	WHERE	owners.clientId = @clientId and userId <> 0
	UNION
	SELECT UG.userId,0
	FROM   sec_getCLientOwners(0) AS owners, UMuserGroup as UG, UMgroups as G
	WHERE  owners.clientID = @clientId
	  AND ((owners.userGroupId <> 0 AND owners.userGroupId = G.id) OR (owners.externalGroupId <> 0 AND owners.externalGroupId = G.id))
	  AND G.id = UG.groupId
	  AND (G.groupFlags & 0x0001) = 0x0001			--'GF_GROUP_ENABLED'
	UNION
	SELECT UMDSUG.userid,0
	FROM sec_getClientOwners(0) AS owners, UMDSGroups as UEG,UMDSUserGroup UMDSUG,UMDSGroupMaps UMDSGM,
	UMGroups AS G
	WHERE owners.usergroupId = UMDSGM.umgroupId
	  AND owners.clientId = @clientId
	  AND UMDSGM.umDSgroupId = UMDSUG.groupId
	  AND  G.id       = UMDSGM.umgroupId
	  AND  ((G.groupFlags & 1) =1)

	-- Now that client owners are retrieved, we will remove users who dont wish to be notified.

	-- First we give preference to users
	Insert into @userSubscription
	select userId,flags,0 from NTAlertSubScriptions
	where ntRuleId=@notifId
	and @clientId = clientID
	and @clientId > 0
	and escalationLevel = @escLevel

	Insert into @userSubscription
	select userId,flags,1 from NTAlertSubScriptions
	where ntRuleId=@notifId
	and clientID = 0
	and escalationLevel = @escLevel

	-- First we check whether that client is a dlo client.
	if exists(select  1 from App_client
	where (STATUS & 0x1000)>0
		and id=@clientId)
	begin
		-- Then check whether this client is part of entity selection list for this alert.

		if @clientInAlertEntityList=1
		begin
			Insert into @userSubscription
			-- Now we want to enable subscription based alert for all users by default even if they havent made any selection from webconsole.
			select ClientOwners.userId,1,2 from @RecepientsList ClientOwners
			left join NTAlertSubScriptions on
			NTAlertSubScriptions.userId = ClientOwners.userId and
			NTAlertSubScriptions.ntRuleId = @notifId and
			(NTAlertSubScriptions.clientId = @clientId Or NTAlertSubScriptions.clientId = 0)
			where ClientOwners.userId <> 0
			and @clientId > 0
			and NTAlertSubScriptions.ntRuleId is null
		end
	end
	-- Retrieve users who want to get notified. And remove the rest.
	delete from @RecepientsList
	where userId not in
	(
		select userId from
		(
			select userId,flags,
			Rank() over (Partition by userId Order by preferenceLevel) as rowNo
			from @userSubscription
		) t
		where rowNo = 1
		and ((flags & 1)>0)
	) and type=0

	delete from @userSubscriptionListFinal
	Insert into @userSubscriptionListFinal
	select userId from @RecepientsList
		RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NTGetUsersforSubscriptionAlert]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NTGetUsersforSubscriptionAlert' AND revision = '1.3')

  insert into GXDBVersions values(5, 'NTGetUsersforSubscriptionAlert',  '1.3', 'NTGetUsersforSubscriptionAlert', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetVMInstanceTypeDesc.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetVMInstanceTypeDesc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetVMInstanceTypeDesc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetVMInstanceTypeDesc]
  delete from GXDBVersions where name = 'GetVMInstanceTypeDesc' and type = 5
END
GO

	CREATE FUNCTION GetVMInstanceTypeDesc(@instanceName nvarchar(64))
	RETURNS NVARCHAR(256)
	AS
	BEGIN
		DECLARE @newGenInstName NVARCHAR(64)
		DECLARE @resultInstType NVARCHAR(256)
		SET @newGenInstName = (
			CASE WHEN @instanceName = 'ExtraSmall'
					THEN 'A0'
				WHEN @instanceName = 'Small'
					THEN 'A1'
				WHEN @instanceName = 'Medium'
					THEN 'A2'
				WHEN @instanceName = 'Large'
					THEN 'A3'
				WHEN @instanceName = 'ExtraLarge'
					THEN 'A4'
				WHEN @instanceName = 'Standard_D1'
					THEN 'D1'
				WHEN @instanceName = 'Standard_D2'
					THEN 'D2'
				WHEN @instanceName = 'Standard_D3'
					THEN 'D3'
				WHEN @instanceName = 'Standard_D4'
					THEN 'D4'
				WHEN @instanceName = 'Standard_D11'
					THEN 'D11'
				WHEN @instanceName = 'Standard_D12'
					THEN 'D12'
				WHEN @instanceName = 'Standard_D13'
					THEN 'D13'
				WHEN @instanceName = 'Standard_D14'
					THEN 'D14'
				ELSE @instanceName
			END)
		SELECT	@resultInstType = instanceType +
				CASE WHEN flags = 0 THEN '' ELSE ' (' + CASE WHEN cpuCores = 0 THEN 'Shared' ELSE CAST(cpuCores AS VARCHAR(8)) END + ' core(s) ' + memory + ' GB memory)' END
		FROM	App_VMInstanceTypes
		WHERE	instanceType = @newGenInstName
		OR  RIGHT(instanceType, len(@newGenInstName)+2) = '(' + @newGenInstName +')'

		RETURN ISNULL(@resultInstType, '')
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetVMInstanceTypeDesc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetVMInstanceTypeDesc' AND revision = '1.4')

  insert into GXDBVersions values(5, 'GetVMInstanceTypeDesc',  '1.4', 'GetVMInstanceTypeDesc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/split.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: split'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[split]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[split]
  delete from GXDBVersions where name = 'split' and type = 5
END
GO

	CREATE FUNCTION split (@RowData nvarchar(max), @SplitBy nvarchar(5))
	RETURNS @RtnValue table
	(
		Id int identity(1,1),
		Data nvarchar(max)
	)
	WITH ENCRYPTION
	AS
	BEGIN
		Declare @Cnt int
		Set @Cnt = 1
		While (Charindex(@SplitBy,@RowData)>0)
		Begin
			Insert Into @RtnValue (data)
			Select
				Data = ltrim(rtrim(Substring(@RowData,1,Charindex(@SplitBy,@RowData)-1)))
			Set @RowData = Substring(@RowData,Charindex(@SplitBy,@RowData)+1,len(@RowData))
			Set @Cnt = @Cnt + 1
		End
		Insert Into @RtnValue (data)
		Select Data = ltrim(rtrim(@RowData))
		Return
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [split]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'split' AND revision = '1.1')

  insert into GXDBVersions values(5, 'split',  '1.1', 'split', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/DoesEventHasResponses.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DoesEventHasResponses'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DoesEventHasResponses]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DoesEventHasResponses]
  delete from GXDBVersions where name = 'DoesEventHasResponses' and type = 5
END
GO

	CREATE FUNCTION [dbo].[DoesEventHasResponses]( @EventId INT )
	RETURNS BIT
	AS
	BEGIN
	DECLARE @countResp INT
	SELECT @countResp = COUNT(R.ResponseID) FROM CvEvents_Response R WHERE R.QuestionID IN (SELECT QuestionID FROM CvEvents_Question WHERE EventID = @EventId)
	RETURN (CASE WHEN ISNULL(@countResp, 0) > 0 THEN 1 ELSE 0 END) --AS HasResponses
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DoesEventHasResponses]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DoesEventHasResponses' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DoesEventHasResponses',  '1.1', 'DoesEventHasResponses', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/scgIsClientVersionSameAsCsVersion.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: scgIsClientVersionSameAsCsVersion'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[scgIsClientVersionSameAsCsVersion]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[scgIsClientVersionSameAsCsVersion]
  delete from GXDBVersions where name = 'scgIsClientVersionSameAsCsVersion' and type = 5
END
GO

	CREATE FUNCTION scgIsClientVersionSameAsCsVersion(@clientId integer, @operation varchar(8), @val  integer )
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
	DECLARE @defaultCommcell INT = 2
            DECLARE @CsHighestSP INT = 0
            DECLARE @CsSpMinorVersion INT = 0
           DECLARE @CsReleaseId INT = 0
           DECLARE @result INT = 0
           DECLARE @ClientHighestSP INT = 0
           DECLARE @ClientSpMinorVersion INT = 0
           DECLARE @ClientReleaseId INT = 0
           --check if the CS is clustered and get the active node client id
           --IF((SELECT attrVal FROM APP_CLIENTPROP WHERE attrName='CS Active Physical Node' and componentnameid = @defaultCommcell) <> @defaultCommcell AND modified=0)
           SET @defaultCommcell =  ISNULL((SELECT attrVal FROM APP_CLIENTPROP WHERE attrName='CS Active Physical Node' AND componentnameid = @defaultCommcell AND modified=0), @defaultCommcell)
           SELECT @CsHighestSP = HighestSP,@CsSpMinorVersion=SpMinorVersion
           FROM simInstalledPackages with (nolock) WHERE ClientId=@defaultCommcell  and simPackageID=1
            SELECT @CsReleaseId=releaseId FROM APP_Client with (nolock)  WHERE id=@defaultCommcell
            --check if the client is clustered and get the active node client id
           --IF((SELECT attrVal FROM APP_CLIENTPROP WHERE attrName='CS Active Physical Node' and componentnameid = @clientId AND modified=0) <> @clientId)
            SET @clientId =  ISNULL((SELECT attrVal FROM APP_CLIENTPROP WHERE attrName='CS Active Physical Node' AND componentnameid = @clientId AND modified=0), @clientId)
            SELECT @ClientHighestSP = HighestSP,@ClientSpMinorVersion=SpMinorVersion
           FROM simInstalledPackages with (nolock) WHERE ClientId=@clientId  and simPackageID in (1,1002)
            SELECT @ClientReleaseId=releaseId FROM APP_Client with (nolock)  WHERE id=@clientId
          IF(@operation = 'true' and @CsHighestSP = @ClientHighestSP and @CsHighestSP=@ClientHighestSP AND @CsSpMinorVersion=@ClientSpMinorVersion)
                 SET @result = 1
           RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [scgIsClientVersionSameAsCsVersion]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'scgIsClientVersionSameAsCsVersion' AND revision = '1.1')

  insert into GXDBVersions values(5, 'scgIsClientVersionSameAsCsVersion',  '1.1', 'scgIsClientVersionSameAsCsVersion', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetSerialNo.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetSerialNo'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetSerialNo]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetSerialNo]
  delete from GXDBVersions where name = 'GetSerialNo' and type = 5
END
GO

 CREATE FUNCTION GetSerialNo (
	@i_commcellname nvarchar(255)
	)
 RETURNS nvarchar(30)
 AS
 BEGIN

 DECLARE @guid nvarchar(70)=''
 DECLARE @serialno nvarchar(30)=''

 SET @guid = (select GUID from app_client where name like @i_commcellname)

 if @guid = ''
 	RETURN null;

 SET @guid = (select replace(@guid,'-',''))

 SET @serialno = (select substring(@guid,1,4) + '-')
 SET @serialno = @serialno + (select substring(@guid,5,4) + '-')
 SET @serialno = @serialno + (select substring(@guid,9,4) + '-')
 SET @serialno = @serialno + (select substring(@guid,13,4) + '-')
 SET @serialno = @serialno + (select substring(@guid,17,6))

 RETURN @serialno

 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetSerialNo]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetSerialNo' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetSerialNo',  '1.2', 'GetSerialNo', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetRegistrationCode.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetRegistrationCode'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetRegistrationCode]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetRegistrationCode]
  delete from GXDBVersions where name = 'GetRegistrationCode' and type = 5
END
GO

 CREATE FUNCTION GetRegistrationCode
 	(
 		@i_commcellname nvarchar(255)
 	)
 RETURNS nvarchar(15)

 AS
 BEGIN

 DECLARE @guid nvarchar(70)=''
 DECLARE @regcode nvarchar(15)=''

 SET @guid = (select GUID from app_client where name like @i_commcellname)

 if @guid = ''
 	RETURN null;

 SET @guid = (select replace(@guid,'-',''))

 SET @regcode = (select substring(@guid,23,3) + '-')
 SET @regcode = @regcode + (select substring(@guid,26,3) + '-')
 SET @regcode = @regcode + (select substring(@guid,29,4))

 return @regcode

 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetRegistrationCode]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetRegistrationCode' AND revision = '1.2')

  insert into GXDBVersions values(5, 'GetRegistrationCode',  '1.2', 'GetRegistrationCode', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/sfGetWFName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sfGetWFName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sfGetWFName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sfGetWFName]
  delete from GXDBVersions where name = 'sfGetWFName' and type = 5
END
GO

	CREATE FUNCTION sfGetWFName(@workFlowId integer)
	RETURNS NVARCHAR(max)
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result nvarchar(max) =  (SELECT name from WF_Definition with(nolock) where WorkFlowId=@workFlowId)
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sfGetWFName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sfGetWFName' AND revision = '1.1')

  insert into GXDBVersions values(5, 'sfGetWFName',  '1.1', 'sfGetWFName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/sfGetWorkFlowProps.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sfGetWorkFlowProps'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sfGetWorkFlowProps]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sfGetWorkFlowProps]
  delete from GXDBVersions where name = 'sfGetWorkFlowProps' and type = 5
END
GO

	CREATE FUNCTION sfGetWorkFlowProps(@workFlowId integer, @operation varchar(8), @workFlowProp integer )
	RETURNS INTEGER
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result INTEGER = 0
		DECLARE @propTrue	INTEGER = 0
		IF (@workFlowProp = 1) -- Deployed
		BEGIN
		IF EXISTS (select * from WF_Deploy(NOLOCK) where WorkflowId=@workFlowId)
		BEGIN
			IF EXISTS (select * from WF_Deploy(NOLOCK) where workFlowId = @workFlowId and version = (select version from WF_Definition(NOLOCK) Where WorkflowId = @workFlowId) )
				SET @propTrue = 1
			ELSE
				SET @propTrue = 0
		END

		IF ((@operation = '=') AND (@propTrue = 1))
				SET @result=1
		IF ((@operation = '!=') AND (@propTrue != 1))
				SET @result=1
		END
		RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sfGetWorkFlowProps]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sfGetWorkFlowProps' AND revision = '1.2')

  insert into GXDBVersions values(5, 'sfGetWorkFlowProps',  '1.2', 'sfGetWorkFlowProps', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/sfIsUserWorkFlowOwner.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sfIsUserWorkFlowOwner'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sfIsUserWorkFlowOwner]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sfIsUserWorkFlowOwner]
  delete from GXDBVersions where name = 'sfIsUserWorkFlowOwner' and type = 5
END
GO

	CREATE FUNCTION sfIsUserWorkFlowOwner(@workFlowId integer, @operation varchar(8), @loginName nvarchar(255) )
	RETURNS INTEGER
	AS
	BEGIN
	--Requirement - Client should have at least one owner as user
	DECLARE @includeUsersFlags int = -1;
	SET @includeUsersFlags = ( CAST (0x001 AS INT) ) --( CAST (0x001 AS INT) )
	DECLARE @result integer = 0
	IF Exists(SELECT * FROM WF_Definition (nolock) WF,
	(SELECT distinct id  FROM UMUsers with(nolock)  WHERE flags & @includeUsersFlags <> 0 AND
	((@operation = 'LIKE' AND login LIKE '%' + @loginName + '%') OR
	(@operation = 'N_LIKE' AND login NOT LIKE '%' + @loginName + '%') OR
	(@operation = '=' AND login = @loginName) OR
	(@operation = '!=' AND login <> @loginName) OR
	(@operation = 'S_WITH' AND login LIKE  @loginName + '%'	) OR
	(@operation = 'E_WITH' AND login LIKE   '%' + @loginName 	)
	)) u
	WHERE WF.workFlowId = @workFlowId AND u.id = WF.userId )
		SET @result = 1
	RETURN @result
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sfIsUserWorkFlowOwner]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sfIsUserWorkFlowOwner' AND revision = '1.4')

  insert into GXDBVersions values(5, 'sfIsUserWorkFlowOwner',  '1.4', 'sfIsUserWorkFlowOwner', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetFolderAssocs.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetFolderAssocs'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetFolderAssocs]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetFolderAssocs]
  delete from GXDBVersions where name = 'GetFolderAssocs' and type = 5
END
GO

	CREATE FUNCTION GetFolderAssocs(@folderId int, @expandlevel int)
	RETURNS
	@assocTbl table (componentId INT)
	WITH ENCRYPTION
	AS
	BEGIN

		Insert into @assocTbl
		select distinct componentId From APP_SmartFolderAssoc where folderId = @folderId and status = 0 and componentType = @expandlevel

		RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetFolderAssocs]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetFolderAssocs' AND revision = '1.1')

  insert into GXDBVersions values(5, 'GetFolderAssocs',  '1.1', 'GetFolderAssocs', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsIndexingV2Enabled.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsIndexingV2Enabled'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsIndexingV2Enabled]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsIndexingV2Enabled]
  delete from GXDBVersions where name = 'IsIndexingV2Enabled' and type = 5
END
GO

	CREATE FUNCTION IsIndexingV2Enabled(@clientId integer,@appTypeId integer, @appId integer)
	RETURNS INT
	WITH ENCRYPTION
	AS
	BEGIN
		DECLARE @result INT = 0
	IF @clientId = 0 OR @appTypeId = 0
	BEGIN
		IF @appId  = 0
			RETURN @result
	ELSE
		select @clientId = clientId, @appTypeId = appTypeId from APP_Application WITH(NOLOCK) where id = @appId
	END
	select @result  = CAST(attrVal AS INT) from APP_ClientProp WITH(NOLOCK) where componentNameId = @clientId AND attrName='IndexingV2' AND modified = 0
	IF @appTypeId NOT IN (SELECT appTypeId from APP_AppTypeGroupAssoc WITH(NOLOCK) where appGroupId IN (34, 22))
		SET @result = 0
	RETURN @result
	END




GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsIndexingV2Enabled]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsIndexingV2Enabled' AND revision = '')

  insert into GXDBVersions values(5, 'IsIndexingV2Enabled',  '', 'IsIndexingV2Enabled', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/JMGetStoragePolicyForJob.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: JMGetStoragePolicyForJob'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[JMGetStoragePolicyForJob]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[JMGetStoragePolicyForJob]
  delete from GXDBVersions where name = 'JMGetStoragePolicyForJob' and type = 5
END
GO

		CREATE FUNCTION JMGetStoragePolicyForJob(@inJobId int, @inCommCelId INT, @inOpType int, @inBkpLevel int, @inDataType int)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @outArchGroupId INT = 0
			IF @inCommCelId = 0
				SET @inCommCelId = 2 --DEFAULT_COMM_CELL_ID
			IF @inOpType = 0
				SET @inOpType = 4 -- BACKUP
			IF @inDataType = 4 --CVA_DATATYPE_LOGS
				SET @inDataType = 2 -- CV_INDEX_ARCHIVE_GROUP
			ELSE
				SET @inDataType = 1 -- CV_DATA_ARCHIVE_GROUP
			DECLARE @optionName NVARCHAR(256) = 'CachedStoragePolicyFor:' + CAST(@inOpType AS NVARCHAR(32)) + ':'  + CAST(@inBkpLevel AS NVARCHAR(32)) + ':' + CAST(@inDataType AS NVARCHAR(32))
			SET @outArchGroupId = ISNULL((
											SELECT attributeValueInt
											FROM JMJobOptions WITH (NOLOCK)
											WHERE jobId = @inJobId
											AND commCellId = @inCommCelId
											AND attributeId = 48 -- JM_CACHED_STORAGE_POLICY
											AND attributeName = @optionName
										 ), 0)
			return @outArchGroupId
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [JMGetStoragePolicyForJob]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'JMGetStoragePolicyForJob' AND revision = '1.2')

  insert into GXDBVersions values(5, 'JMGetStoragePolicyForJob',  '1.2', 'JMGetStoragePolicyForJob', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/NTGetCategoryName.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: NTGetCategoryName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTGetCategoryName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NTGetCategoryName]
  delete from GXDBVersions where name = 'NTGetCategoryName' and type = 5
END
GO

	CREATE FUNCTION NTGetCategoryName (@ntRuleId int, @localeId int)
	RETURNS NVARCHAR(max)
	WITH ENCRYPTION
 	AS
	BEGIN
	declare @queryTypeId int = 0
	declare @categoryName NVARCHAR(max) = ''
	select @queryTypeId = convert(xml,NTQueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@queryType)[1]','int')
		from NTNotificationQueryMapping with (nolock)
		inner join NTQueryList with (nolock) on
		NTNotificationQueryMapping.queryId = NTQueryList.queryId
		and NTNotificationQueryMapping.NTNotificationId=@ntRuleId

	if (@queryTypeId is null)
		set @queryTypeId = 0
	if (@queryTypeId<>2)
	begin
		select @categoryName = dbo.fn_EvFormatEventMsgText(0,@localeId, (SELECT nameID  FROM NtCategory as AT, NTnotificationRule AS NR
	       WHERE NR.id = @ntRuleId
	       AND NR.categoryId = AT.id) ,0,2)
	end
	else
	begin
		select @categoryName = dbo.fn_EvFormatEventMsgText(0,@localeId,(1162 | (CAST(POWER(2, 24) AS BIGINT) * 74)),0,2)
	end
	return @categoryName

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NTGetCategoryName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NTGetCategoryName' AND revision = '1.1')

  insert into GXDBVersions values(5, 'NTGetCategoryName',  '1.1', 'NTGetCategoryName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/FormatBytes.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: FormatBytes'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[FormatBytes]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[FormatBytes]
  delete from GXDBVersions where name = 'FormatBytes' and type = 5
END
GO

	CREATE FUNCTION [dbo].[FormatBytes]
	(
	   @InputNumber   DECIMAL(38,7),
	   @InputUOM      VARCHAR(5) = 'Bytes'
	)
	RETURNS VARCHAR(20)
	WITH SCHEMABINDING
	AS
	BEGIN
	   -- Declare the return variable here
	   DECLARE @Output VARCHAR(48)
	   DECLARE @Prefix MONEY
	   DECLARE @Suffix VARCHAR(6)
	   DECLARE @Multiplier DECIMAL(38,2)
	   DECLARE @Bytes  DECIMAL(38,2)

	   SELECT @Multiplier =
	      CASE @InputUOM
	         WHEN 'Bytes'         THEN 1
	         WHEN 'Byte'          THEN 1
	         WHEN 'B'             THEN 1
	         WHEN 'Kilobytes'     THEN 1024
	         WHEN 'Kilobyte'      THEN 1024
	         WHEN 'KB'            THEN 1024
	         WHEN 'Megabytes'     THEN 1048576
	         WHEN 'Megabyte'      THEN 1048576
	         WHEN 'MB'            THEN 1048576
	         WHEN 'Gigabytes'     THEN 1073741824
	         WHEN 'Gigabyte'      THEN 1073741824
	         WHEN 'GB'            THEN 1073741824
	         WHEN 'Terabytes'     THEN 1099511627776
	         WHEN 'Terabyte'      THEN 1099511627776
	         WHEN 'TB'            THEN 1099511627776
	         WHEN 'Petabytes'     THEN 1125899906842624
	         WHEN 'Petabyte'      THEN 1125899906842624
	         WHEN 'PB'            THEN 1125899906842624
	         WHEN 'Exabytes'      THEN 1152921504606846976
	         WHEN 'Exabyte'       THEN 1152921504606846976
	         WHEN 'EB'            THEN 1152921504606846976
	         WHEN 'Zettabytes'    THEN 1180591620717411303424
	         WHEN 'Zettabyte'     THEN 1180591620717411303424
	         WHEN 'ZB'            THEN 1180591620717411303424
	         WHEN 'Yottabytes'    THEN 1208925819614629174706176
	         WHEN 'Yottabyte'     THEN 1208925819614629174706176
	         WHEN 'YB'            THEN 1208925819614629174706176
	         WHEN 'Brontobytes'   THEN 1237940039285380274899124224
	         WHEN 'Brontobyte'    THEN 1237940039285380274899124224
	         WHEN 'BB'            THEN 1237940039285380274899124224
	         WHEN 'Geopbytes'     THEN 1267650600228229401496703205376
	         WHEN 'Geopbyte'      THEN 1267650600228229401496703205376
	      END

	   SELECT @Bytes = @InputNumber*@Multiplier

	   SELECT @Prefix =
	      CASE
	         WHEN ABS(@Bytes) < 1024 THEN @Bytes --bytes
	         WHEN ABS(@Bytes) < 1048576 THEN (@Bytes/1024) --kb
	         WHEN ABS(@Bytes) < 1073741824 THEN (@Bytes/1048576) --mb
	         WHEN ABS(@Bytes) < 1099511627776 THEN (@Bytes/1073741824) --gb
	         WHEN ABS(@Bytes) < 1125899906842624 THEN (@Bytes/1099511627776) --tb
	         WHEN ABS(@Bytes) < 1152921504606846976 THEN (@Bytes/1125899906842624) --pb
	         WHEN ABS(@Bytes) < 1180591620717411303424 THEN (@Bytes/1152921504606846976) --eb
	         WHEN ABS(@Bytes) < 1208925819614629174706176 THEN (@Bytes/1180591620717411303424) --zb
	         WHEN ABS(@Bytes) < 1237940039285380274899124224 THEN (@Bytes/1208925819614629174706176) --yb
	         WHEN ABS(@Bytes) < 1267650600228229401496703205376 THEN (@Bytes/1237940039285380274899124224) --bb
	         ELSE (@Bytes/1267650600228229401496703205376) --geopbytes
	      END,
	          @Suffix =
	     CASE
	         WHEN ABS(@Bytes) < 1024 THEN ' Bytes'
	         WHEN ABS(@Bytes) < 1048576 THEN ' KB'
	         WHEN ABS(@Bytes) < 1073741824 THEN ' MB'
	         WHEN ABS(@Bytes) < 1099511627776 THEN ' GB'
	         WHEN ABS(@Bytes) < 1125899906842624 THEN ' TB'
	         WHEN ABS(@Bytes) < 1152921504606846976 THEN ' PB'
	         WHEN ABS(@Bytes) < 1180591620717411303424 THEN ' EB'
	         WHEN ABS(@Bytes) < 1208925819614629174706176 THEN ' ZB'
	         WHEN ABS(@Bytes) < 1237940039285380274899124224 THEN ' YB'
	         WHEN ABS(@Bytes) < 1267650600228229401496703205376 THEN ' BB'
	         ELSE ' Geopbytes'
	      END

	   -- Return the result of the function
	   SELECT @Output = CAST(@Prefix AS VARCHAR(39)) + @Suffix
	   RETURN @Output
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [FormatBytes]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'FormatBytes' AND revision = '1.2')

  insert into GXDBVersions values(5, 'FormatBytes',  '1.2', 'FormatBytes', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsDeferredCatalogSupported.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: IsDeferredCatalogSupported'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsDeferredCatalogSupported]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsDeferredCatalogSupported]
  delete from GXDBVersions where name = 'IsDeferredCatalogSupported' and type = 5
END
GO

		CREATE FUNCTION IsDeferredCatalogSupported (@i_appId INT)
		RETURNS INT
		AS
		BEGIN
			DECLARE @retVal int
			IF EXISTS
			(
			SELECT 1 FROM App_Application APP WITH(NOLOCK) INNER JOIN App_Client CL WITH(NOLOCK) ON APP.clientId = CL.id
			WHERE APP.id = @i_appId AND CL.simOperatingSystemId = 16 AND APP.appTypeId = 13
			)
				SET @retVal = 1
			ELSE
				SET @retVal = 0

			RETURN @retVal

		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsDeferredCatalogSupported]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsDeferredCatalogSupported' AND revision = '1.2')

  insert into GXDBVersions values(5, 'IsDeferredCatalogSupported',  '1.2', 'IsDeferredCatalogSupported', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/MM_SMGetMetaData.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: MM_SMGetMetaData'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[MM_SMGetMetaData]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[MM_SMGetMetaData]
  delete from GXDBVersions where name = 'MM_SMGetMetaData' and type = 5
END
GO

 			create function MM_SMGetMetaData(@metadata NVARCHAR(MAX), @metaDataType INT)
 			returns NVARCHAR(MAX)
 			as
 			begin
 				if(@metadata = N'') return N''
 				DECLARE @tblSplitMdRows TABLE (Id INT, Data NVARCHAR(MAX))
	 			DECLARE	@rtnData NVARCHAR(MAX)
 				SET @metadata = SUBSTRING(@metadata, CHARINDEX('#', @metadata) + 1, LEN(@metadata))
 				INSERT INTO @tblSplitMdRows
 				SELECT * FROM SplitStringMaxLen(@metadata, '|..|' )
 				UPDATE	@tblSplitMdRows
 				SET		Data = SUBSTRING(Data, CHARINDEX('#', Data) + 1, LEN(Data))
 				DECLARE @mdRow NVARCHAR(MAX)
 				SET		@mdRow = (select  TMP.Data
 				FROM	@tblSplitMdRows TMP
 						OUTER APPLY SplitStringMaxLen(TMP.Data, '|::|') SPLIT
 				WHERE	Split.Id = 1 AND Split.Data = CONVERT(NVARCHAR(10), @metaDataType))
				if @mdRow IS NULL OR @mdRow = N''
					return N''
 				SET @rtnData = (SELECT	Data
 				FROM	SplitStringMaxLen(@mdRow, '|::|')
 				WHERE	ID = 2)
 				RETURN @rtnData
 			end



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [MM_SMGetMetaData]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'MM_SMGetMetaData' AND revision = '1.3')

  insert into GXDBVersions values(5, 'MM_SMGetMetaData',  '1.3', 'MM_SMGetMetaData', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/LMGetMonitoringTypesForAppType.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: LMGetMonitoringTypesForAppType'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[LMGetMonitoringTypesForAppType]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[LMGetMonitoringTypesForAppType]
  delete from GXDBVersions where name = 'LMGetMonitoringTypesForAppType' and type = 5
END
GO

CREATE FUNCTION dbo.LMGetMonitoringTypesForAppType
(
@lmAppType int
)
RETURNS
@monitoringTypesForAppType table
(
monitoringType int
)
AS
BEGIN
if @lmAppType=0 or @lmAppType=3
begin
insert into @monitoringTypesForAppType
select 0 --      TEXTLOGS,
union
select 1 -- EVENTLOGS,
union
select 2 -- SYSLOGS,
union
select 3 -- SIMPANA_EVENTVIEWER,
union
select 4 -- UPLOADED_FILES,
union
select 5 -- DATABASE_DATASET,
union
select 6 -- SYSTEM_MONITORING
return
end
-- Else currently return based on type.
if @lmAppType=1
begin
insert into @monitoringTypesForAppType
select 0 --      TEXTLOGS,
union
select 1 -- EVENTLOGS,
union
select 2 -- SYSLOGS,
union
select 3 -- SIMPANA_EVENTVIEWER,
union
select 4 -- UPLOADED_FILES,
union
select 5 -- DATABASE_DATASET,
return
end
if @lmAppType=2
begin
insert into @monitoringTypesForAppType
select 6 -- SYSTEM_MONITORING
return
end
return
end



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [LMGetMonitoringTypesForAppType]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'LMGetMonitoringTypesForAppType' AND revision = '1.2')

  insert into GXDBVersions values(5, 'LMGetMonitoringTypesForAppType',  '1.2', 'LMGetMonitoringTypesForAppType', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/NTGetUsersForAlertRule.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: NTGetUsersForAlertRule'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[NTGetUsersForAlertRule]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[NTGetUsersForAlertRule]
  delete from GXDBVersions where name = 'NTGetUsersForAlertRule' and type = 5
END
GO

CREATE FUNCTION NTGetUsersForAlertRule ( @ruleId INTEGER, @escalationLevel INTEGER, @messType INTEGER , @laptopClientId INTEGER)
RETURNS
@reciepientDetails table(
userId      int,
Login       nvarchar(max),
UserName    nvarchar(max),
Email       nvarchar(max)
)
WITH ENCRYPTION
AS
BEGIN
DECLARE @isOwnerReporting as integer =  0
DECLARE @isMetricsAlarm   as integer =  0
IF EXISTS (
SELECT * FROM NTNotificationQueryMapping
INNER JOIN NTQueryList
ON NTNotificationQueryMapping.QueryId = NTQueryList.queryId
WHERE NtNotificationId = @ruleId
AND status & 32 <>0
)
SET @isMetricsAlarm = 1
IF (   (@messType = 1) AND ( @isMetricsAlarm = 1 )  )
BEGIN
INSERT INTO @reciepientDetails
SELECT NULL ,NULL, NULL ,nonGalaxyUserName
FROM  NTNotificationNonGalaxyUsers
WHERE NTnotificationID = @ruleId
RETURN
END
IF EXISTS (select 1 from NTnotificationRule where [ID] = @ruleId and (status & 128)>0)
SET @isOwnerReporting = 1
DECLARE  @recepientsList TABLE
(
userId      int,
Login       nvarchar(max),
UserName    nvarchar(max),
type        int,
Email       nvarchar(max)
)
IF  @messType in (1, 8192)
BEGIN
IF (@isOwnerReporting <> 0)         --'NT_STATUS_LAPTOP_ALERT'
BEGIN                               -- NEED TO FETCH EMAILS FROM USERS/GROUPS WHO "OWN" THE CLIENT
INSERT @recepientsList(userId, type)
SELECT  userId, 0
FROM    sec_getCLientOwners(1) owners
WHERE   owners.clientId = @lapTopClientId and owners.userId <> 0
-- Now that client owners are retrieved, we will remove users who dont wish to be notified.
declare @userSubscription table
(
userId int,
flags int,
preferenceLevel int
)
-- First we give preference to users
Insert into @userSubscription
select userId,flags,0 from NTAlertSubScriptions
where ntRuleId=@ruleId
and @lapTopClientId = clientID
and @lapTopClientId > 0
and escalationLevel = @escalationLevel
Insert into @userSubscription
select userId,flags,1 from NTAlertSubScriptions
where ntRuleId=@ruleId
and clientID = 0
and escalationLevel = @escalationLevel
-- First we check whether that client is a dlo client.
if exists(select  1 from App_client
where (STATUS & 0x1000)>0
and id=@lapTopClientId)
begin
-- Then check whether this client is part of entity selection list for this alert.
declare @genericEntity nvarchar(max)
declare @resultMatch int = 0
set @genericEntity = '<CvEntities_GenericEntity clientId="'+convert(nvarchar(10),@lapTopClientId)+'"/>'
declare @subscripNTRuleXmlEntityList xml
select @subscripNTRuleXmlEntityList = xmlEntityList from NTNotificationRule
where id=@ruleId
declare @entityCheckResult table
(
result int
)
set @subscripNTRuleXmlEntityList = @subscripNTRuleXmlEntityList.query('CVGui_CommCellTreeNode/associations')
set @subscripNTRuleXmlEntityList = convert(xml,replace(replace(convert(nvarchar(max),@subscripNTRuleXmlEntityList),
'<associations','<entity'),'</associations>','</entity>'))
set @subscripNTRuleXmlEntityList = (
select @subscripNTRuleXmlEntityList.query('.')
for xml path(''),root('App_Associations')
)
if dbo.IsEntityInAssocList( @genericEntity,@subscripNTRuleXmlEntityList) = 1
begin
Insert into @userSubscription
-- Now we want to enable subscription based alert for all users by default even if they havent made any selection from webconsole.
select ClientOwners.userId,1,2 from @recepientsList ClientOwners
left join NTAlertSubScriptions on
NTAlertSubScriptions.userId = ClientOwners.userId and
NTAlertSubScriptions.ntRuleId = @ruleId and
(NTAlertSubScriptions.clientId = @lapTopClientId Or NTAlertSubScriptions.clientId = 0)
where ClientOwners.userId <> 0
and @lapTopClientId > 0
and NTAlertSubScriptions.ntRuleId is null
end
end
-- Retrieve users who want to get notified. And remove the rest.
delete from @recepientsList
where userId not in
(
select userId from
(
select userId,flags,
Rank() over (Partition by userId Order by preferenceLevel) as rowNo
from @userSubscription
) t
where rowNo = 1
and ((flags & 1)>0)
)
and type=0
-- IF @lapTopClientId = 0 .. NEED TO ABORT OUT SOMEHOW?
-- TODO, FLUSH OUT GETTING EMAIL RECEPIENTS BASED ON A JOIN WITH TABLE "UMUserandGroupEntityAssociation".
-- .. (Should be a mimic of code to retrieve from NT tables below)
END
ELSE
BEGIN                       -- NOT A LAPTOP ALERT, FETCH EMAILS STORED WITH ALERT ITSELF
INSERT INTO   @recepientsList(userId,type)
SELECT NU.userId,0
FROM NTnotificationUsers AS NU
WHERE NU.NTnotificationId = @ruleId
AND NU.escalationLevel = @escalationLevel
UNION
SELECT UG.userId,0
FROM NTnotificationGroups AS NG, USuserGroups as UG, USgroups as G
WHERE NTnotificationId = @ruleId   AND escalationLevel = @escalationLevel
AND G.groupId = UG.groupId
AND NG.groupId = UG.groupId
AND (G.groupFlags & 0x0001) = 0x0001          --'GF_GROUP_ENABLED'
UNION
SELECT NEG.externalGroupId,1
FROM NTnotificationExternalGroups AS NEG, UMDSGroups as UEG
WHERE NTnotificationId = @ruleId   AND escalationLevel = @escalationLevel
AND NEG.externalGroupId = UEG.id
AND UEG.enabled = 1
-- Inserting the non-galaxy user information
INSERT INTO   @recepientsList(type,Email)
SELECT 2,NNG.nonGalaxyUserName FROM NTnotificationNonGalaxyUsers NNG
WHERE NTnotificationId = @ruleId   AND escalationLevel = @escalationLevel
END
END
------------------------------------------------------------------------
-- WE'VE ALREADY FILTERED OUT GROUPS THAT ARE DISABLED, BUT NOW PRUNE --
-- RECEPIENTS LIST OF USERS THAT ARE DISABLED                        --
------------------------------------------------------------------------
DeLeTe @recepientsList
FROM  @recepientsList AS RL, UMUsers as U
WHERE RL.userID = U.id
AND RL.type = 0
AND U.enabled = 0
IF ( @messType = 1 )
BEGIN
UPDATE @recepientsList
SET login = US.login, UserName = US.name, Email=US.Email
FROM @recepientsList as RL, UMUsers AS US
WHERE RL.userId = US.id AND RL.type = 0
-- External Groups
UPDATE @recepientsList
SET login = UEG.name, UserName = UEG.name, Email=UEG.Email
FROM @recepientsList as RL, UMDSGroups AS UEG
WHERE RL.userId = UEG.id AND RL.type = 1
END
IF  @messType  = 8192
BEGIN
INSERT INTO  @recepientsList (userId,type)  -- Type 2 for expanded users
SELECT UMUserGroup.userId , 0 FROM @recepientsList  AS RL
INNER JOIN UMUserGroup ON RL.userId  =  UMUserGroup.groupId
WHERE RL.type = 1
END
UPDATE @recepientsList
SET userId = NULL
WHERE type = 1
INSERT INTO @reciepientDetails
SELECT userId ,Login, UserName ,Email  FROM @recepientsList
RETURN
END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [NTGetUsersForAlertRule]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'NTGetUsersForAlertRule' AND revision = '1.3')

  insert into GXDBVersions values(5, 'NTGetUsersForAlertRule',  '1.3', 'NTGetUsersForAlertRule', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/IsEntityInAssocList.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: IsEntityInAssocList'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[IsEntityInAssocList]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[IsEntityInAssocList]
  delete from GXDBVersions where name = 'IsEntityInAssocList' and type = 5
END
GO

CREATE FUNCTION IsEntityInAssocList (@entity xml , @entityList xml)
RETURNS INTEGER
AS
BEGIN
DECLARE @retval INT
DECLARE @handle INT
DECLARE @PrepareXmlStatus INT
DECLARE @_type_ INT
DECLARE @commcellId INT
DECLARE @clientGroupId INT
DECLARE @clientId INT
DECLARE @applicationId INT
DECLARE @instanceId INT
DECLARE @backupsetId INT
DECLARE @subclientId INT
DECLARE @mediaAgentId INT
DECLARE @libraryId INT
DECLARE @storagePolicyId INT
DECLARE @schedulePolicyId INT
DECLARE @copyID INT
DECLARE @trackingPolicyId INT
DECLARE @workflowId INT
DECLARE @criteriaId INT
DECLARE @EntityListTableTemp TABLE
(
_type_  INT,
clientGroupId INT,
clientId INT,
applicationId  INT,
instanceId  INT,
backupsetId INT,
subclientId INT,
mediaAgentId INT ,
schedulePolicyId INT ,
libraryId INT ,
storagePolicyId INT ,
copyId  INT ,
trackingPolicyId INT,
workflowId INT,
criteriaId INT,
exclude INT
)
INSERT INTO @EntityListTableTemp
(   _type_ ,
clientGroupId,
clientId,
applicationId ,
instanceId ,
backupsetId ,
subclientId,
mediaAgentId,
schedulePolicyId,
libraryId,
storagePolicyId,
copyId,
trackingPolicyId,
workflowId,
criteriaId ,
exclude
)
SELECT
ISNULL(ref.value('@_type_','INT'),0),
ISNULL(ref.value('@clientGroupId','INT'),0),
ISNULL(ref.value('@clientId','INT'),0),
ISNULL(ref.value('@applicationId','INT'),0),
ISNULL(ref.value('@instanceId','INT'),0),
ISNULL(ref.value('@backupsetId','INT'),0),
ISNULL(ref.value('@subclientId','INT'),0),
ISNULL(ref.value('@mediaAgentId','INT'),0),
ISNULL(ref.value('@schedulePolicyId','INT'),0),
ISNULL(ref.value('@libraryId','INT'),0),
ISNULL(ref.value('@storagePolicyId','INT'),0),
ISNULL(ref.value('@copyId','INT'),0),
ISNULL(ref.value('@trackingPolicyId','INT'),0),
ISNULL(ref.value('@workflowId','INT'),0),
ISNULL(ref.value('@criteriaId','INT'),0),
ISNULL(ref.value('(flags/@exclude)[1]','INT'),0)
FROM @entityList.nodes ('/App_Associations/entity') R(ref)
SELECT
@_type_ = ISNULL(ref.value('@_type','INT'),0) ,
@clientgroupid = ISNULL(ref.value('@clientGroupId','INT'),0) ,
@clientId = ISNULL(ref.value('@clientId','INT'),0),
@applicationId = ISNULL(ref.value('@applicationId','INT'),0),
@instanceId = ISNULL(ref.value('@instanceId','INT'),0),
@backupsetId = ISNULL(ref.value('@backupsetId','INT'),0),
@subclientId = ISNULL(ref.value('@subclientId','INT'),0),
@mediaAgentId = ISNULL(ref.value('@mediaAgentId','INT'),0),
@schedulePolicyId = ISNULL(ref.value('@schedulePolicyId','INT'),0),
@libraryId = ISNULL(ref.value('@libraryId','INT'),0),
@storagePolicyId = ISNULL(ref.value('@storagePolicyId','INT'),0),
@copyId = ISNULL(ref.value('@copyId','INT'),0),
@trackingPolicyId = ISNULL(ref.value('@trackingPolicyId','INT'),0),
@workflowId = ISNULL(ref.value('@workflowId','INT'),0),
@criteriaId = ISNULL(ref.value('@criteriaId','INT'),0)
FROM @entity.nodes ('CvEntities_GenericEntity') R(ref)
IF ( @clientGroupId = 0 AND @clientId = 0 AND @applicationId = 0 AND
@instanceId = 0 AND @backupsetId = 0 AND @subclientId = 0 AND
@mediaAgentId = 0 AND @schedulePolicyId = 0  AND
@libraryId = 0 AND @storagePolicyId = 0 AND @copyId = 0  AND
@trackingPolicyId = 0   AND @workflowId = 0 AND @criteriaId = 0
)
BEGIN
--Print ' empty data input returning 0'
SET @retval = 0
return @retval
END
----------- fixing the mr --- setting instanceId if not given -----
IF ( @subclientId <> 0 and (@backupsetId = 0 OR @instanceId = 0) )
begin
select @backupsetId = backupSet , @instanceId = instance
from APP_Application  with (nolock)
where id = @subclientId
end
------------------------------
IF ( @clientid <> 0)
BEGIN
IF(  ( SELECT COUNT(*) FROM @EntityListTableTemp AS ELIST
JOIN APP_ClientGroupAssoc AS CGROUPASSOC WITH ( NOLOCK )
ON ELIST.clientGroupId = CGROUPASSOC.clientGroupId
WHERE CGROUPASSOC.clientid = @clientId AND exclude = 1  And (ELIST.clientId=0 OR ELIST.clientId=@clientId) ) > 0
)
BEGIN
--PRINT 'Client group is excluded '
SET @retval = 0
return @retval
END
END
IF (
( SELECT COUNT(*) FROM @EntityListTableTemp
WHERE
(
(mediaAgentId = @mediaAgentId OR mediaAgentId = 0 ) AND
(libraryId = @libraryId OR libraryId = 0  ) AND
(criteriaId = @criteriaId OR criteriaId = 0 ) AND
(schedulePolicyId = @schedulePolicyId OR schedulePolicyId = 0 )AND
((storagePolicyId = @storagePolicyId OR storagePolicyId = 0 ) AND
(copyId = @copyId OR  copyId= 0 ))AND
(trackingPolicyId = @trackingPolicyId OR trackingPolicyId = 0 ) AND
(workflowId = @workflowId OR workflowId = 0 ) AND
(clientGroupId = @clientgroupid OR clientgroupid = 0 ) AND
((clientId = @clientId OR  clientId = 0 ) AND
(applicationId = @applicationId OR applicationId = 0 ) AND
(instanceId = @instanceId OR  instanceId = 0 ) AND
(backupsetId = @backupsetId OR  backupsetId = 0) AND
(subclientId = @subclientId OR  subclientId = 0 ))AND
exclude = 1
)
) > 0
)
BEGIN
--print 'FOUND IN EXCLUDED LIST'
SET @retval = 0
return @retval
END
IF (  ( SELECT COUNT(*) FROM @EntityListTableTemp
WHERE  clientGroupId = 0 AND clientId = 0 AND applicationId = 0
AND instanceId = 0 AND backupsetId = 0 AND subclientId = 0
AND mediaAgentId = 0 AND schedulePolicyId = 0
AND libraryId = 0 AND storagePolicyId = 0 AND copyId = 0
AND trackingPolicyId = 0 AND  workflowId = 0
AND criteriaId = 0
AND _type_ <> 27 ) >0
)
BEGIN
--print 'All Entities are included'
SET @retval = 1
return @retval
END
IF( @clientId <>0 )
BEGIN
IF (
( SELECT COUNT(*) FROM @EntityListTableTemp
WHERE  _type_ = 27 ) >0
)
BEGIN
IF (  ( ( SELECT COUNT(*) FROM APP_ClientGroupAssoc WITH (NOLOCK)
WHERE clientId = @clientId  ) >0 )
)
BEGIN
--  PRINT 'ALL_CLIENT_GROUPS_ENTITY inluded and entity is client inside some clientgroup or entity is a valid client group'
SET @retval = 1
return @retval
END
END
END
IF( ( SELECT COUNT(*) FROM @EntityListTableTemp
WHERE
(
(mediaAgentId = @mediaAgentId OR mediaAgentId = 0 ) AND
(libraryId = @libraryId OR libraryId = 0 )  AND
(criteriaId = @criteriaId OR criteriaId = 0 ) AND
(schedulePolicyId = @schedulePolicyId OR schedulePolicyId = 0 )AND
((storagePolicyId = @storagePolicyId OR storagePolicyId = 0 ) AND
(copyId = @copyId OR copyId = 0 ))AND
(trackingPolicyId = @trackingPolicyId OR trackingPolicyId = 0 ) AND
(workflowId = @workflowId OR workflowId = 0 ) AND
(clientGroupId = @clientgroupid OR clientgroupid = 0  ) AND
((clientId = @clientId OR clientId = 0 ) AND
(applicationId = @applicationId OR applicationId = 0 ) AND
(instanceId = @instanceId OR instanceId = 0 ) AND
(backupsetId = @backupsetId OR  backupsetId = 0) AND
(subclientId = @subclientId OR  subclientId = 0 ))
)
) > 0
)
BEGIN
--print 'FOUND IN included LIST'
SET @retval = 1
return @retval
END
IF ( @clientid <> 0)
BEGIN
IF(  ( SELECT COUNT(*) FROM @EntityListTableTemp AS ELIST
JOIN APP_ClientGroupAssoc AS CGROUPASSOC WITH ( NOLOCK )
ON ELIST.clientGroupId = CGROUPASSOC.clientGroupId
WHERE CGROUPASSOC.clientid = @clientId  ) > 0
)
BEGIN
--  PRINT 'Client group is included and client is part of it'
SET @retval = 1
return @retval
END
END
BEGIN
--print'Entity is not present in excluded or included list so return 0'
SET @retval = 0
return @retval
END
END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [IsEntityInAssocList]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'IsEntityInAssocList' AND revision = '1.3')

  insert into GXDBVersions values(5, 'IsEntityInAssocList',  '1.3', 'IsEntityInAssocList', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetExtendedRetentionRuleString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetExtendedRetentionRuleString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetExtendedRetentionRuleString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetExtendedRetentionRuleString]
  delete from GXDBVersions where name = 'GetExtendedRetentionRuleString' and type = 5
END
GO

	CREATE FUNCTION GetExtendedRetentionRuleString (@retentionRule INTEGER)
	RETURNS VARCHAR(50)
	AS
	BEGIN
		DECLARE @RuleString VARCHAR(50)
		SET @RuleString = 'Error'
		IF (@retentionRule = 0)
		BEGIN
			SET @RuleString = 'N\A'
			GOTO FUNC_EXIT
		END
		ELSE IF (@retentionRule = 2)
		BEGIN
			SET @RuleString = 'All Full'
			GOTO FUNC_EXIT
		END
		ELSE IF (@retentionRule = 262144)
		BEGIN
			SET @RuleString = 'Hourly Full'
			GOTO FUNC_EXIT
		END
		ELSE IF (@retentionRule = 524288)
		BEGIN
			SET @RuleString = 'Daily Full'
			GOTO FUNC_EXIT
		END
		ELSE IF (@retentionRule = 4)
		BEGIN
			SET @RuleString = 'Weekly Full'
			GOTO FUNC_EXIT
		END
		ELSE IF (@retentionRule = 8)
		BEGIN
			SET @RuleString = 'Monthly Full'
			GOTO FUNC_EXIT
		END
		ELSE IF (@retentionRule = 16)
		BEGIN
			SET @RuleString = 'Quarterly Full'
			GOTO FUNC_EXIT
		END
		ELSE IF (@retentionRule = 32)
		BEGIN
			SET @RuleString = 'Half Yearly Full'
			GOTO FUNC_EXIT
		END
		ELSE IF (@retentionRule = 64)
		BEGIN
			SET @RuleString = 'Yearly Full'
			GOTO FUNC_EXIT
		END

		FUNC_EXIT:
			RETURN @RuleString

	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetExtendedRetentionRuleString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetExtendedRetentionRuleString' AND revision = '')

  insert into GXDBVersions values(5, 'GetExtendedRetentionRuleString',  '', 'GetExtendedRetentionRuleString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Function/GetTempExtendedRentiontionTransposedTable.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetTempExtendedRentiontionTransposedTable'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetTempExtendedRentiontionTransposedTable]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetTempExtendedRentiontionTransposedTable]
  delete from GXDBVersions where name = 'GetTempExtendedRentiontionTransposedTable' and type = 5
END
GO

     CREATE FUNCTION GetTempExtendedRentiontionTransposedTable ()
     RETURNS @TempExtendedRentiontionTransposedTable TABLE
     (
            Copyid                  INT,
            retentionDays1  INT,
            retentionRule1  INT,
            GraceDays1              INT,
            retentionDays2  INT,
            retentionRule2  INT,
            GraceDays2              INT,
            retentionDays3  INT,
            retentionRule3  INT,
            GraceDays3              INT
     )
     AS
     BEGIN
            WITH TempRuleOrder (Copyid , retentionDays , retentionRule ,GraceDays,ruleOrder)
            AS
            (
                    SELECT                  copyId,
                                                    retentionDays,
                                                    retentionRule,
                                                    GraceDays,
                                                    ruleOrder = CASE retentionRule
                                                                                    WHEN 2          THEN 1
                                                                                    WHEN 262144 THEN 2
                                                                                    WHEN 524288 THEN 3
                                                                                    WHEN 4          THEN 4
                                                                                    WHEN 8          THEN 5
                                                                                    WHEN 16         THEN 6
                                                                                    WHEN 32         THEN 7
                                                                                    WHEN 64         THEN 8
                                                                            END

                            FROM archAgingRuleExtended
            ),

            TempMaster(Copyid , retentionDays , retentionRule ,GraceDays , RowNumber )
            AS
            (
                            SELECT      copyId,
                                                    retentionDays,
                                                    retentionRule,
                                                    GraceDays,
                                                    RowNumber = ROW_NUMBER() OVER (Partition by copyId order by  ruleOrder ASC)
                            FROM TempRuleOrder
            ),
            TempRetentionRulesExtended (Copyid , retentionDays1 , retentionRule1 ,GraceDays1 , retentionDays2 , retentionRule2 ,GraceDays2 ,retentionDays3 , retentionRule3 ,GraceDays3)
            AS
            (
                            SELECT  A.Copyid,
                                            A.retentionDays,
                                            A.retentionRule,
                                            A.GraceDays,
                            