

--  ------------  Generated from [../../../Source/CommServer/Db/Function/EncodeInvalidXMLChar.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: EncodeInvalidXMLChar'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[EncodeInvalidXMLChar]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[EncodeInvalidXMLChar]
  delete from GXDBVersions where name = 'EncodeInvalidXMLChar' and type = 5
END
GO

	CREATE FUNCTION EncodeInvalidXMLChar(@inputstring nvarchar(max))
	RETURNS nvarchar(max)
	AS
	BEGIN
					DECLARE @outputstring nvarchar(max)
						SET @outputstring = ''
					DECLARE @length int
						SET @length = LEN(@inputstring)
					DECLARE @pos int
						SET @pos = 1
					DECLARE @hexVal varbinary(4)
						SET @hexVal = 0
					DECLARE @hexStr varchar(16)
						SET @hexStr = ''
					DECLARE @invalidCharFound int
						SET @invalidCharFound = 0
					DECLARE @currentChar nvarchar(1)
					WHILE @pos < (@length + 1)
					BEGIN
						SET @currentChar = SUBSTRING(@inputstring, @pos, 1)
						DECLARE @currentCharBin int
						SET @currentCharBin = unicode(@currentChar)

						IF  (@currentCharBin = 0x9) OR (@currentCharBin = 0xA) OR (@currentCharBin = 0xD )
								OR ((@currentCharBin >= 0x20) AND (@currentCharBin <= 0xD7FF))
								OR ((@currentCharBin >= 0xE000) AND (@currentCharBin <= 0xFFFD))  --((ch >= 0x10000) && (ch <= 0x10FFFF))  -- wchar max size is 2 bytes so commenting the condition
						BEGIN
							SET @outputstring = @outputstring + @currentChar
						END
						ELSE
						BEGIN
							SET @invalidCharFound = 1
							SET @outputstring = @outputstring + '|#'
							SET @hexVal = CAST(unicode(@currentChar) AS varbinary(2)) -- each nvarchar is 2 bytes
							SET @hexStr = master.dbo.fn_varbintohexstr(@hexVal)
							SET @hexStr = SUBSTRING(@hexStr,3,16)
							SET @outputstring = @outputstring + @hexStr + '!'
						END
						SET @pos = @pos + 1
					END
					IF @invalidCharFound <> 0
					BEGIN
						SET @outputstring = '|' + @outputstring
					END
					return @outputstring
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [EncodeInvalidXMLChar]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'EncodeInvalidXMLChar' AND revision = '1.9')

  insert into GXDBVersions values(5, 'EncodeInvalidXMLChar',  '1.9', 'EncodeInvalidXMLChar', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
