SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO

BEGIN
	DECLARE @FuncNameCursorFlag 	INTEGER
	SET 		@FuncNameCursorFlag 	= 0
	
	DECLARE	@errorCode	INTEGER
	SET 		@errorCode	= 0
	
	DECLARE	@FuncName		nvarchar(256)
		
	DECLARE	FuncNameListCursor CURSOR STATIC FOR
	SELECT	distinct aliasname
	FROM		GXDBVersions
	WHERE		type = 5 -- (For Functions)
		
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
		
	SET		@FuncNameCursorFlag = 1
	OPEN	FuncNameListCursor

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT

	FETCH	NEXT 
	FROM FuncNameListCursor
	INTO @FuncName

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	
	--Drop all functions
	WHILE	@@FETCH_STATUS = 0
	BEGIN
					
		IF EXISTS (select * from sysobjects where name = @FuncName and OBJECTPROPERTY(id, N'IsInlineFunction') = 0)
		BEGIN
			print '>>> Drop Function: ' + @FuncName + ' <<<'
			EXEC ('DROP FUNCTION [' + @FuncName + ']')
		END

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
					
		IF EXISTS (select * from GXDBVersions where aliasname = @FuncName AND type = 5)
			DELETE FROM GXDBVersions WHERE aliasname = @FuncName AND type = 5
	
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		FETCH	NEXT 
		FROM FuncNameListCursor
		INTO @FuncName

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT		
	END

CX_EXIT:	
	IF @FuncNameCursorFlag = 1
	BEGIN
			CLOSE				FuncNameListCursor
			DEALLOCATE	FuncNameListCursor
	END
END	

RETURN
GO
