

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DataProtectionCoverageSummary.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DataProtectionCoverageSummary'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DataProtectionCoverageSummary]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DataProtectionCoverageSummary]
  delete from GXDBVersions where name = 'DataProtectionCoverageSummary' and type = 5
END
GO

 CREATE FUNCTION DataProtectionCoverageSummary(
	@nLastDays	INTEGER
	)
 RETURNS @DPCoverageSummary TABLE (
	ClientGroup				NVARCHAR(MAX),
	nExcludedSubclients		INTEGER,
	nProtectedSubclients	INTEGER,
	nNotProtectedSubclients	INTEGER
 )
 AS
 BEGIN

    INSERT	INTO @DPCoverageSummary
    SELECT	ClientGroup,
    		SUM(CASE WHEN Category = 'Excluded' THEN SuccessfulJobs ELSE 0 END),
    		SUM(CASE WHEN Category = 'Protected' THEN SuccessfulJobs ELSE 0 END),
    		SUM(CASE WHEN Category = 'Not Protected' THEN SuccessfulJobs ELSE 0 END)
	FROM	dbo.DataProtectionCoverage(@nLastDays, 1)
	GROUP BY ClientGroup
	ORDER BY ClientGroup

	RETURN
 END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DataProtectionCoverageSummary]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DataProtectionCoverageSummary' AND revision = '1.3')

  insert into GXDBVersions values(5, 'DataProtectionCoverageSummary',  '1.3', 'DataProtectionCoverageSummary', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
