

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DataGrowthPerCopy.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DataGrowthPerCopy'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DataGrowthPerCopy]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DataGrowthPerCopy]
  delete from GXDBVersions where name = 'DataGrowthPerCopy' and type = 5
END
GO

 CREATE FUNCTION DataGrowthPerCopy (
	@Frequency		VARCHAR(32),	-- 'Day', 'Week' or 'Month'
	@Periods		INTEGER,
	@StartDate		VARCHAR(32),	-- 'mm/dd/yyyy' or '' for 8 weeks ago
	@EndDate		VARCHAR(32),	-- 'mm/dd/yyyy' or '' for current date
	@Predictions	INTEGER,		-- Numer of prediction points
	@MediaType		VARCHAR(32),	-- 'Disk', 'Tape' or '' for all
	@CopyType		VARCHAR(32),	-- 'Backup', 'Replication' or '' for all
	@LibraryName	NVARCHAR(144),	-- '' for all
	@PolicyName		NVARCHAR(144),	-- '' for all
	@CopyName		NVARCHAR(64)	-- '' for all
 )
 RETURNS @Results TABLE (
	CommCell		NVARCHAR(256),
	StoragePolicy	NVARCHAR(256),
	Copy			NVARCHAR(256),
	IsPrimaryCopy	VARCHAR(4),
	IsDedupeCopy	VARCHAR(4),
	PeriodBegin		VARCHAR(32),
	PeriodEnd		VARCHAR(32),
	SizeOnMedia_GB	DECIMAL(20,2),
	DataGrowth_GB	DECIMAL(20,2),
	Duration_Hr		DECIMAL(10,2),
	Throughput_GBHr DECIMAL(10,2),
	IsPrediction	VARCHAR(4),
	MediaAgent		NVARCHAR(256),
	Library			NVARCHAR(128),
	LibGrowth_GBDay DECIMAL(20,2),
	LibFreeSpace_GB	DECIMAL(20,2),
	LibEstDaysToUse	INTEGER,
	TimeZone		NVARCHAR(256),
	LibTotalSpace_GB DECIMAL(20,2)
 )
 AS
 BEGIN

 IF	@StartDate = ''
 BEGIN
 	IF	@Frequency = 'Day'
 		SET @StartDate = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()) - @Periods + 1, 0)
 	ELSE
 	IF	@Frequency = 'Month'
 		SET @StartDate = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - @Periods + 1, 0)
 	ELSE
 		SET @StartDate = DATEADD(WEEK, DATEDIFF(WEEK, 0, GETDATE()) - @Periods + 1, 0)
 END

 IF	@EndDate = ''
 	SET @EndDate = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), 0)

 SET @EndDate = DATEADD(DAY, 1, @EndDate)

 IF	@PolicyName <> '' AND @CopyName <> ''
 	SET @MediaType = 0

 DECLARE @tblPeriod TABLE (StartDate DATETIME, EndDate DATETIME)

 DECLARE @csName		VARCHAR(256)
 DECLARE @csTimeZone	VARCHAR(256)
 DECLARE @TmpStartDate	DATETIME = @StartDate
 DECLARE @TmpEndDate	DATETIME = @EndDate
 DECLARE @MaxEndDate	DATETIME
 DECLARE @PrevStartDate	DATETIME
 DECLARE @nDays			INTEGER

 SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2

 SELECT	@csTimeZone	= TimeZoneStdName FROM SchedTimeZone
 WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)

 SET	@MaxEndDate	= @TmpEndDate

 WHILE (@TmpStartDate < @MaxEndDate)
 BEGIN
 	IF	@Frequency = 'Month'
 		SET	@TmpEndDate = DATEADD(MONTH, 1, @TmpStartDate)
 	ELSE IF @Frequency = 'Day'
 		SET	@TmpEndDate = DATEADD(DAY, 1, @TmpStartDate)
 	ELSE
 		SET	@TmpEndDate = DATEADD(WEEK, 1, @TmpStartDate)

 	IF	@TmpEndDate > @MaxEndDate
 		SET	@TmpEndDate = @MaxEndDate

 	INSERT	INTO @tblPeriod
 	SELECT	dbo.LocalToUTCTime(@TmpStartDate, @csTimeZone), dbo.LocalToUTCTime(@TmpEndDate, @csTimeZone)

 	SET	@TmpStartDate = @TmpEndDate
 END

 SELECT	@TmpStartDate = MIN(StartDate), @TmpEndDate = MAX(EndDate) FROM @tblPeriod

 SET	@nDays = DATEDIFF(DAY, @TmpStartDate, @TmpEndDate)

 DECLARE @tblSPCopy TABLE (
 	PolicyId INT, PolicyName NVARCHAR(512), CopyId INT, CopyName NVARCHAR(512), dedupeFlags INT,
 	IsPrimaryCopy INT, IsDiskCopy INT, MediaAgentId INT, LibraryId INT, GrowthRate BIGINT, days INT)

 INSERT	INTO @tblSPCopy
 SELECT	AG.id AS PolicyId, AG.name AS PolicyName, AGC.id AS CopyId, AGC.name AS CopyName, AGC.dedupeFlags,
 		CASE WHEN AGC.id = AG.defaultCopy THEN 1 ELSE 0 END,
 		CASE WHEN DPL.DrivePoolType = 10001 THEN 1 ELSE 0 END,
 		DP.HostClientId, MP.LibraryId, 0, @nDays
 FROM	archGroup AG
 		INNER JOIN archGroupCopy AGC ON AGC.archGroupId = AG.id
 		INNER JOIN MMDataPath DP ON DP.CopyId = AGC.id AND (DP.Flag & 1) = 1
 		INNER JOIN MMDrivePool DPL ON DPL.DrivePoolId = DP.DrivePoolId
 		INNER JOIN MMMasterPool MP ON MP.MasterPoolId = DPL.MasterPoolId
 WHERE	AG.type = 1 AND AG.id > 1 AND AGC.type IN (1, 2) AND AGC.isSnapCopy = 0

 IF	@PolicyName <> ''
  	DELETE	@tblSPCopy WHERE LibraryId NOT IN (SELECT DISTINCT LibraryId FROM @tblSPCopy
			WHERE PolicyName = @PolicyName AND (@CopyName = '' OR CopyName = @CopyName))
 ELSE
 BEGIN
	IF	@MediaType <> '' OR @CopyType <> ''
 		DELETE	@tblSPCopy WHERE @MediaType = 'Disk' AND IsDiskCopy = 0 OR @MediaType = 'Tape' AND IsDiskCopy = 1

 	IF	@CopyType = 'Backup' OR @CopyType = 'Replication'
  		DELETE	@tblSPCopy WHERE LibraryId NOT IN (SELECT LibraryId FROM @tblSPCopy
				WHERE @CopyType = 'Backup' AND IsPrimaryCopy = 1 OR @CopyType = 'Replication' AND IsPrimaryCopy = 0)
 END

 IF	@LibraryName <> ''
  	DELETE	@tblSPCopy WHERE LibraryId NOT IN (SELECT LibraryId FROM MMLibrary WHERE AliasName = @LibraryName)

 DECLARE @tblSummary TABLE (
 	StartDate DATETIME, EndDate DATETIME, CopyId INT, SizeOnMedia BIGINT, DataGrowth BIGINT, Duration INT, Prediction INT)

 INSERT	INTO @tblSummary
 SELECT	P.*, C.CopyId, 0, 0, 0, 0
 FROM	@tblPeriod P CROSS JOIN @tblSPCopy C


 UPDATE	@tblSPCopy
 SET	GrowthRate = S.DataGrowth/C.days
 FROM	@tblSPCopy C INNER JOIN
 		(SELECT	CopyId, SUM(DataGrowth) AS DataGrowth
 		FROM	@tblSummary
 		GROUP BY CopyId) S
 	ON	C.CopyId = S.CopyId

 DECLARE @tblLibrary TABLE (LibraryId INT, LibraryName NVARCHAR(128), FreeSpaceMB BIGINT, GrowthRate BIGINT, DaysOfMedia INT, TotalSpaceMB BIGINT)

 INSERT	INTO @tblLibrary
 SELECT	L.LibraryId, L.AliasName,
		SUM(CASE WHEN M.IsAged = 0 THEN CAST(MS.FreeBytesMB AS BIGINT) ELSE CAST(MS.TotalSpaceMB AS BIGINT) END),
		0, -1, SUM(CAST(MS.TotalSpaceMB AS BIGINT))
 FROM	MMLibrary L
		INNER JOIN MMMedia M ON M.LibraryId = L.LibraryId
		INNER JOIN MMMediaSide MS ON M.MediaId = MS.MediaId
 WHERE	L.LibraryId > 0
 GROUP BY L.LibraryId, L.AliasName

 SELECT	@TmpStartDate = MAX(StartDate) FROM @tblPeriod

 UPDATE	@tblLibrary
 SET	GrowthRate = T.GrowthRate, DaysOfMedia = (1024.0*1024.0*FreeSpaceMB)/T.GrowthRate
 FROM	@tblLibrary L INNER JOIN
 		(SELECT	LibraryId, SUM(GrowthRate) AS GrowthRate
 		FROM	@tblSPCopy
 		GROUP BY LibraryId) T
 	ON	L.LibraryId = T.LibraryId
 WHERE	FreeSpaceMB > 0 AND T.GrowthRate > 0

 DELETE	@tblSPCopy
 WHERE	@PolicyName <> '' AND (PolicyName <> @PolicyName OR @CopyName <> '' AND CopyName <> @CopyName)
	OR	@CopyType = 'Backup' AND IsPrimaryCopy = 0 OR @CopyType = 'Replication' AND IsPrimaryCopy = 1

 IF (@Predictions > 0)
 BEGIN
	SELECT	@PrevStartDate = MAX(StartDate) FROM @tblPeriod

	SET	@TmpStartDate  = dbo.UTCToLocalTime(@PrevStartDate, @csTimeZone)
	IF	@Frequency = 'Month'
		SET	@TmpEndDate = DATEADD(MONTH, 1, @TmpStartDate)
	ELSE IF @Frequency = 'Day'
		SET	@TmpEndDate = DATEADD(DAY, 1, @TmpStartDate)
	ELSE
		SET	@TmpEndDate = DATEADD(WEEK, 1, @TmpStartDate)

	SET	@TmpStartDate = @MaxEndDate
 END

 WHILE (@Predictions > 0)
 BEGIN
 	SET	@nDays = DATEDIFF(DAY, @TmpStartDate, @TmpEndDate)
 	IF	@nDays > 0
 	BEGIN
 		INSERT	INTO @tblSummary
 		SELECT	dbo.LocalToUTCTime(@TmpStartDate, @csTimeZone), dbo.LocalToUTCTime(@TmpEndDate, @csTimeZone), S.CopyId,
 				S.SizeOnMedia + C.GrowthRate*@nDays, C.GrowthRate*@nDays, 0, 1
 		FROM	@tblSummary S INNER JOIN @tblSPCopy C ON S.CopyId = C.CopyId
 		WHERE	S.StartDate = @PrevStartDate

 		SET	@PrevStartDate	= dbo.LocalToUTCTime(@TmpStartDate, @csTimeZone)
 		SET	@Predictions	= @Predictions - 1
 	END

 	SET @TmpStartDate = @TmpEndDate
 	IF	@Frequency = 'Month'
 		SET	@TmpEndDate = DATEADD(MONTH, 1, @TmpEndDate)
 	ELSE IF @Frequency = 'Day'
 		SET	@TmpEndDate = DATEADD(DAY, 1, @TmpEndDate)
 	ELSE
 		SET	@TmpEndDate = DATEADD(WEEK, 1, @TmpEndDate)
 END

 INSERT INTO @Results
 SELECT
 		@csName AS CommCell,
 		PolicyName, CopyName,
 		CASE WHEN IsPrimaryCopy > 0 THEN 'Yes' ELSE 'No' END AS IsPrimaryCopy,
 		CASE WHEN (dedupeFlags & 262144)  > 0 THEN 'Yes' ELSE 'No' END AS IsDedupeCopy,
 		dbo.UTCToLocalStringTime(S.StartDate, @csTimeZone), dbo.UTCToLocalStringTime(DATEADD(SECOND, -1, S.EndDate), @csTimeZone),
 		CAST(ISNULL(SizeOnMedia, 0)/1024.0/1024.0/1024.0 AS DECIMAL(20, 2)) AS SizeOnMedia_GB,
 		CAST(ISNULL(DataGrowth, 0)/1024.0/1024.0/1024.0 AS DECIMAL(20, 2)) AS DataGrowth_GB,
 		CAST(ISNULL(Duration, 0)/3600.0 AS DECIMAL(10, 2)) AS Duration_Hr,
 		CASE WHEN ISNULL(Duration, 0) = 0 THEN 0
 			 ELSE CAST(ISNULL(DataGrowth, 0)/1024.0/1024.0/1024.0/(ISNULL(Duration, 0)/3600.0) AS DECIMAL(10, 2))END AS Throughput_GBHr,
 		CASE WHEN Prediction > 0 THEN 'Yes' ELSE 'No' END AS IsPrediction,
 		CL.name AS MediaAgent, L.LibraryName,
 		CAST(L.GrowthRate/1024.0/1024.0/1024.0 AS DECIMAL(10, 2)) AS LibGrowth_GBDay,
 		CAST(L.FreeSpaceMB/1024.0 AS DECIMAL(20, 2)) AS LibFreeSpace_GB, L.DaysOfMedia AS LibEstDaysToUse,
 		@csTimeZone AS TimeZone,
		CAST(L.TotalSpaceMB/1024.0 AS DECIMAL(20, 2)) AS LibTotalSpace_GB
 FROM	@tblSPCopy C
 		INNER JOIN APP_Client CL ON CL.id = C.MediaAgentId
 		INNER JOIN @tblSummary S ON S.CopyId = C.CopyId
 		INNER JOIN @tblLibrary L ON L.LibraryId = C.LibraryId
 ORDER BY PolicyName, CopyName, EndDate, Prediction

 RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DataGrowthPerCopy]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DataGrowthPerCopy' AND revision = '1.5.66.2')

  insert into GXDBVersions values(5, 'DataGrowthPerCopy',  '1.5.66.2', 'DataGrowthPerCopy', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
