

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DaTSRptGetMountPathErrorCode.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DaTSRptGetMountPathErrorCode'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DaTSRptGetMountPathErrorCode]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DaTSRptGetMountPathErrorCode]
  delete from GXDBVersions where name = 'DaTSRptGetMountPathErrorCode' and type = 5
END
GO

	CREATE FUNCTION DaTSRptGetMountPathErrorCode(@inSIDBStoreId INTEGER, @inCopyId INTEGER, @inMediaId INTEGER)
		RETURNS VARCHAR(MAX)
		AS
		BEGIN
			DECLARE @ErrorCodeList VARCHAR(MAX)

			DECLARE	@numberOfFailureToDisplay		INTEGER
			SET			@numberOfFailureToDisplay		= 5

			SELECT @numberOfFailureToDisplay = isnull(value, 0)
			FROM MMConfigs
			WHERE name = 'DA_CONFIG_NUMBER_OF_FAILURE_REASON_TO_DISPLAY_IN_REPORT'

			--Populate MountPath ErrorCode for failures in pruning
			--Replace -ve error code with 53032 (E_MM_SIDB_PRUNE_AFILE_PENDING)
			SELECT TOP (@numberOfFailureToDisplay) @ErrorCodeList = COALESCE(@ErrorCodeList + ',', '') + CAST(TMP.FailureErrorCode AS VARCHAR(10))
			FROM (
							SELECT T.SIDBStoreId, T.copyId, T.MediaId, T.FailureErrorCode, SUM(T.ErrorCount) AS ErrorCount
							FROM (
									SELECT DAF.SIDBStoreId, DAF.copyId, MS.MediaId,
												 (CASE WHEN DAF.FailureErrorCode >= 0 THEN DAF.FailureErrorCode ELSE 53032 END) AS FailureErrorCode,
												 COUNT(*) AS ErrorCount
      						FROM MMDeletedAF DAF WITH (NOLOCK), MMMountPath MP WITH (NOLOCK), MMMediaSide MS WITH (NOLOCK)
									WHERE DAF.MountPathId > 0
									AND		DAF.FailureErrorCode != 0
									AND		DAF.SIDBStoreId = @inSIDBStoreId
									AND		DAF.copyId = @inCopyId
									AND		DAF.MountPathId = MP.MountPathId
									AND		MP.MediaSideId = MS.MediaSideId
									AND		MS.MediaId = @inMediaId
      						GROUP BY DAF.SIDBStoreId, DAF.copyId, MS.MediaId, (CASE WHEN DAF.FailureErrorCode >= 0 THEN DAF.FailureErrorCode ELSE 53032 END)

									UNION ALL

									SELECT V.SIDBStoreId, ISNULL(CAST(S.archGroupCopyId AS INT), 2147483647) AS copyId, V.mediaId,
												 (CASE WHEN V.FailureErrorCode >= 0 THEN V.FailureErrorCode ELSE 53032 END) AS FailureErrorCode,
												 COUNT(*) AS ErrorCount
									FROM MMVolume V WITH (NOLOCK)
									LEFT OUTER JOIN archStream S WITH (NOLOCK)
										ON	V.mediaGroupId = S.mediaGroupId
      						WHERE V.mediaId > 0
									AND		V.FailureErrorCode != 0
									AND		V.siloStatus != 2
									AND		V.SIDBStoreId = @inSIDBStoreId
									AND	 	ISNULL(CAST(S.archGroupCopyId AS INT), 2147483647) = @inCopyId
 									AND		V.MediaId = @inMediaId
									GROUP BY V.SIDBStoreId, ISNULL(CAST(S.archGroupCopyId AS INT), 2147483647), V.mediaId, (CASE WHEN V.FailureErrorCode >= 0 THEN V.FailureErrorCode ELSE 53032 END)

									UNION ALL

      						SELECT V.SIDBStoreId, ISNULL(CAST(S.archGroupCopyId AS INT), 2147483647) AS copyId, MS.mediaId,
												 (CASE WHEN V.FailureErrorCode >= 0 THEN V.FailureErrorCode ELSE 53032 END) AS FailureErrorCode,
												 COUNT(*) AS ErrorCount
									FROM MMVolume V WITH (NOLOCK)
										INNER JOIN MMMountPath MP WITH (NOLOCK)
											ON V.currMountPathId = MP.mountPathId
										INNER JOIN MMMediaSide MS WITH (NOLOCK)
											ON		MP.MediaSideId = MS.MediaSideId
										LEFT OUTER JOIN archStream S WITH (NOLOCK)
											ON	V.mediaGroupId = S.mediaGroupId
									WHERE V.currMountPathId > 0
      						AND		V.FailureErrorCode != 0
									AND		V.siloStatus = 2
									AND		V.SIDBStoreId = @inSIDBStoreId
									AND	 	ISNULL(CAST(S.archGroupCopyId AS INT), 2147483647) = @inCopyId
									AND		MS.MediaId = @inMediaId
									GROUP BY V.SIDBStoreId, ISNULL(CAST(S.archGroupCopyId AS INT), 2147483647), MS.mediaId, (CASE WHEN V.FailureErrorCode >= 0 THEN V.FailureErrorCode ELSE 53032 END)
							) T
      				GROUP BY T.SIDBStoreId, T.copyId, T.MediaId, T.FailureErrorCode
			) TMP
			ORDER BY TMP.ErrorCount DESC

			RETURN @ErrorCodeList
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DaTSRptGetMountPathErrorCode]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DaTSRptGetMountPathErrorCode' AND revision = '1.4')

  insert into GXDBVersions values(5, 'DaTSRptGetMountPathErrorCode',  '1.4', 'DaTSRptGetMountPathErrorCode', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
