

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DDBGrowthPerCopy.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DDBGrowthPerCopy'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DDBGrowthPerCopy]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DDBGrowthPerCopy]
  delete from GXDBVersions where name = 'DDBGrowthPerCopy' and type = 5
END
GO

 CREATE FUNCTION DDBGrowthPerCopy (
	@Frequency		VARCHAR(32),	-- 'Day', 'Week' or 'Month'
	@Periods		INTEGER,
	@StartDate		VARCHAR(32),	-- 'mm/dd/yyyy' or '' for 8 weeks ago
	@EndDate		VARCHAR(32),	-- 'mm/dd/yyyy' or '' for current date
	@Predictions	INTEGER,		-- Numer of prediction points
	@PolicyName		NVARCHAR(144),	-- '' for all
	@CopyName		NVARCHAR(64)	-- '' for all
 )
 RETURNS @Results TABLE (
	StoragePolicy	NVARCHAR(256),
	Copy			NVARCHAR(256),
	MediaAgent		NVARCHAR(512),
	SIDBPath		VARCHAR(1024),
	PeriodBegin		VARCHAR(32),
	PeriodEnd		VARCHAR(32),
	IsPrediction	VARCHAR(4),
	DDBSize_MB		DECIMAL(20,2),
	DDBFreeSpace_MB	DECIMAL(20,2),
	TimeZone		NVARCHAR(256)
 )
 AS
 BEGIN
 IF	@StartDate = ''
 BEGIN
  	IF	@Frequency = 'Day'
 		SET @StartDate = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()) - @Periods + 1, 0)
 	ELSE
  	IF	@Frequency = 'Month'
  		SET @StartDate = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()) - @Periods + 1, 0)
  	ELSE
  		SET @StartDate = DATEADD(WEEK, DATEDIFF(WEEK, 0, GETDATE()) - @Periods + 1, 0)
  END
  IF	@EndDate = ''
  	SET @EndDate = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), 0)
  SET @EndDate = DATEADD(DAY, 1, @EndDate)
  DECLARE @tblPeriod TABLE (StartDate DATETIME, EndDate DATETIME)
  DECLARE @csName		VARCHAR(256)
  DECLARE @csTimeZone	VARCHAR(256)
  DECLARE @TmpStartDate	DATETIME = @StartDate
  DECLARE @TmpEndDate	DATETIME = @EndDate
  DECLARE @MaxEndDate	DATETIME
  DECLARE @nDays			INTEGER
  SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2
  SELECT	@csTimeZone	= TimeZoneStdName FROM SchedTimeZone
  WHERE	TimeZoneName= SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
  SET	@MaxEndDate	= @TmpEndDate
  WHILE (@TmpStartDate < @MaxEndDate)
  BEGIN
  	IF	@Frequency = 'Month'
  		SET	@TmpEndDate = DATEADD(MONTH, 1, @TmpStartDate)
  	ELSE IF @Frequency = 'Day'
  		SET	@TmpEndDate = DATEADD(DAY, 1, @TmpStartDate)
  	ELSE
  		SET	@TmpEndDate = DATEADD(WEEK, 1, @TmpStartDate)
  	IF	@TmpEndDate > @MaxEndDate
  		BREAK
  	INSERT	INTO @tblPeriod
  	SELECT	@TmpStartDate, @TmpEndDate
  	SET	@TmpStartDate = @TmpEndDate
  END
 DECLARE @SIDBStoresToReport table(SubStoreId int, storeCCId int, SIDBPath VARCHAR(1024), IdxCacheFreeSpaceMB bigint,GrowthRate bigint, lastDDBSize bigint, MediaAgent nvarchar(512))
 INSERT @SIDBStoresToReport
 SELECT distinct store.SubStoreId, store.CommCellId, apath.Path, cache.FreeDiskSpaceMB, null, 0, ''
 FROM archGroup AG inner join archGroupCopy AGC ON AG.id = AGC.archGroupId AND AGC.SIDBStoreId > 0
 INNER JOIN archCopySIDBStore CS ON CS.CopyId = AGC.id AND ((CS.Flags & 4) > 0)
 inner join IdxSIDBSubStore store ON store.SIDBStoreId = CS.SIDBStoreId
 inner join IdxAccessPath  aPath ON apath.IdxAccessPathId = store.IdxAccessPathId
 inner join IdxCache cache ON store.IdxCacheId = cache.IdxCacheId
 WHERE (@PolicyName = '' OR AG.name = @PolicyName) AND (@CopyName = '' OR (@PolicyName <> '' AND AGC.name = @CopyName))
 AND AG.id > 1 AND AGC.id > 0
 UPDATE @SIDBStoresToReport SET MediaAgent = cl.name
 FROM @SIDBStoresToReport stores INNER JOIN IdxSIDBSubStore storeTbl ON stores.SubStoreId = storeTbl.SubStoreId AND stores.storeCCId = storeTbl.CommCellId
 INNER JOIN APP_Client cl ON storeTbl.ClientId = cl.id AND cl.id > 1
 DECLARE @tblSummary table(StartDate DATETIME, EndDate DATETIME, SubStoreId int, storeCCID int, SIDBPath nvarchar(1024),
 DDBSize bigint, AvgDDBSize bigint, isPrediction int)
 INSERT @tblSummary
 SELECT P.*, store.SubStoreId, store.storeCCId,store.SIDBPath, 0, 0, 0
 FROM @tblPeriod P, @SIDBStoresToReport store
 --Remove period/store combinations before the minimum time we have in our history information for that store
 DELETE @tblSummary
 FROM @tblSummary summ left outer join
 (SELECT SubStoreId, CommCellId, MIN(modifiedTime) "minModifiedTime" FROM IdxSIDBUsageHistory
 GROUP BY SubStoreId, commcellId) hist
 ON summ.SubStoreId = hist.SubStoreId AND summ.storeCCID = hist.CommCellId
 WHERE hist.minModifiedTime is null OR dbo.getunixTime(summ.EndDate) < hist.minModifiedTime
 UPDATE @tblSummary
 SET DDBSize = sidbHistory.SizeOccupied, AvgDDBSize = T.avgDDBSize
 FROM @tblSummary summ inner join
 (
 SELECT A.SubStoreId, A.storeCCID, A.StartDate "StartDate", A.EndDate "EndDate",
 MAX(B.ModifiedTime) "histTime", AVG(SizeOccupied) avgDDBSize
 FROM @tblSummary A inner join IdxSIDBUsageHistory B
 ON A.SubStoreId = B.SubStoreId AND A.storeCCID = B.CommCellId
 AND B.ModifiedTime >= dbo.GetUnixTime(A.StartDate) AND B.ModifiedTime < dbo.GetUnixTime(A.EndDate)
 GROUP BY A.SubStoreId, A.storeCCID, A.startDate, A.EndDate
 ) T
 ON summ.StartDate = T.StartDate AND summ.EndDate = T.EndDate AND summ.SubStoreId = T.SubStoreId
 AND summ.storeCCID = T.storeCCID
 inner join IdxSIDBUsageHistory sidbHistory
 ON summ.SubStoreId = sidbHistory.SubStoreId AND summ.storeCCID = sidbHistory.CommCellId
 AND sidbHistory.ModifiedTime = T.histTime
 UPDATE @tblSummary SET DDBSize = T.DDBSize, AvgDDBSize = T.AvgDDBSize
 FROM @tblSummary summ
 inner join
 (
 SELECT A.SubStoreId, A.storeCCID, A.EndDate, B.DDBSize, B.AvgDDBSize, row_number() over(partition by A.SubStoreId, A.StoreCCId, A.EndDate order by B.EndDate desc) as rn
 FROM @tblSummary A
 inner join @tblSummary B ON A.DDBSize = 0 AND B.DDBSize > 0 AND A.SubStoreId = B.SubStoreId AND A.storeCCID = B.storeCCID AND B.EndDate < A.EndDate
 ) T
 ON summ.SubStoreId = T.SubStoreId AND summ.storeCCID = T.storeCCID AND summ.EndDate = T.EndDate AND T.rn = 1
 UPDATE @SIDBStoresToReport SET GrowthRate = 0, lastDDBSize = T.DDBSize
 FROM @SIDBStoresToReport stores inner join
 (SELECT SubStoreId, storeCCID, MAX(DDBSize) "DDBSize" FROM @tblSummary
 group by SubStoreId, storeCCID
 having COUNT(distinct EndDate) = 1) T ON stores.SubStoreId = T.SubStoreId AND stores.storeCCId = T.storeCCID
 UPDATE @SIDBStoresToReport SET GrowthRate = (C.AvgDDBSize - B.AvgDDBSize)
 /CASE WHEN @Frequency = 'Day' THEN DATEDIFF(Day,B.EndDate,C.EndDate) WHEN @Frequency = 'Week' THEN DATEDIFF(Week,B.EndDate,C.EndDate) WHEN @Frequency = 'Month' THEN DATEDIFF(Month,B.EndDate,C.EndDate) END,
 lastDDBSize = C.DDBSize
 FROM @SIDBStoresToReport A inner join
 (SELECT SubStoreId, storeCCID, DDBSize, AvgDDBSize, EndDate, row_number() over(partition by SubStoreId, storeCCId order by EndDate asc) as rn FROM @tblSummary)B
 ON A.SubStoreId = B.SubStoreId AND A.storeCCId = B.storeCCID AND B.rn = 1 AND A.GrowthRate is null inner join
 (SELECT SubStoreId, storeCCID, DDBSize,AvgDDBSize, EndDate, row_number() over(partition by subStoreId, storeCCId order by EndDate desc) as rn FROM @tblSummary)C
 ON A.SubStoreId = C.SubStoreId AND A.storeCCId = C.storeCCID AND C.rn = 1
 SELECT @TmpEndDate = MAX(EndDate) FROM @tblPeriod
 DECLARE @counter int = 0
 WHILE (@Predictions > 0)
 BEGIN
 	SET @counter = @counter + 1
  	SET @TmpStartDate = @TmpEndDate
  	IF	@Frequency = 'Month'
 		SET	@TmpEndDate = DATEADD(MONTH, 1, @TmpEndDate)
  	ELSE IF @Frequency = 'Day'
  		SET	@TmpEndDate = DATEADD(DAY, 1, @TmpEndDate)
  	ELSE
  		SET	@TmpEndDate = DATEADD(WEEK, 1, @TmpEndDate)
  	INSERT	INTO @tblSummary
 	SELECT	@TmpStartDate, @TmpEndDate, summ.SubStoreId, summ.storeCCID, summ.SIDBPath, stores.lastDDBSize + @counter * stores.GrowthRate, 0, 1
 	FROM (SELECT distinct SubStoreId, storeCCId, SIDBPath FROM @tblSummary) summ
 	inner join @SIDBStoresToReport stores ON stores.SubStoreId = summ.SubStoreId AND stores.storeCCId = summ.storeCCID AND stores.GrowthRate is not null
 	SET	@Predictions	= @Predictions - 1
  END
  INSERT INTO @Results
  SELECT AG.name, AGC.name, stores.MediaAgent, stores.SIDBPath, summ.StartDate, summ.EndDate, summ.isPrediction, summ.DDBSize, stores.IdxCacheFreeSpaceMB, @csTimeZone
  FROM @tblSummary summ inner join @SIDBStoresToReport stores ON summ.SubStoreId = stores.SubStoreId AND summ.storeCCID = stores.storeCCId
  inner join IdxSIDBSubStore subStore ON subStore.SubStoreId = stores.SubStoreId AND subStore.commcellId = stores.storeCCId
  INNER JOIN archCopySIDBStore CS ON CS.SIDBStoreId = subStore.SIDBStoreId AND ((CS.Flags & 4) > 0)
  inner join archGroupCopy AGC ON AGC.id = CS.CopyId AND AGC.dedupeFlags & 134217728 = 0
  inner join archGroup AG ON AGC.archGroupId = AG.id
  order by AG.name, AGC.name, summ.EndDate, isPrediction
  RETURN
  END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DDBGrowthPerCopy]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DDBGrowthPerCopy' AND revision = '1.3.88.2')

  insert into GXDBVersions values(5, 'DDBGrowthPerCopy',  '1.3.88.2', 'DDBGrowthPerCopy', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
