

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetYearStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetYearStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetYearStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetYearStart]
  delete from GXDBVersions where name = 'DAGetYearStart' and type = 5
END
GO

	CREATE FUNCTION DAGetYearStart(@jobStartTime INTEGER, @calendarId INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @jobStartDate 			DATETIME
			DECLARE @monthStartDate			DATETIME
			DECLARE @yearStartDate 			DATETIME
			DECLARE @year 							INTEGER
			DECLARE @month 							INTEGER
			DECLARE @day 								INTEGER
			DECLARE @calType 						INTEGER
			DECLARE @yearStartMonth 		INTEGER
			DECLARE @diffMonth 					INTEGER

			-- Get the Date Part
			SET @jobStartDate = DATEADD(DAY, DATEDIFF(DAY, 0, dbo.getDateTime(@jobStartTime)), 0)
			SET @calType = 0
			SET @year = DATEPART(YEAR, @jobStartDate)
			SET @month = DATEPART(MONTH, @jobStartDate)
			SET @day = DATEPART(DAY, @jobStartDate)
			SET @monthStartDate = 0
			SET @yearStartDate = 0
			SET @yearStartMonth = 0
			SET @diffMonth = 0

			SET @calType = (SELECT calType FROM APP_CustomCalendar WHERE id = @calendarId)
			IF (@calType > 2)
			BEGIN
			  SELECT @monthStartDate = startDate, @year = year, @month = month
				FROM APP_CustomCalendarMonths
				WHERE startDate <= @jobStartDate
				AND endDate >= @jobStartDate
				AND calendarId = @calendarId
			END

			--If Standard Calendar OR Custom Calendar with no months defined OR custom calendar not defined, then get standard calendar dates
			IF (@monthStartDate = 0)
			BEGIN
				SET @year = DATEPART(YEAR, @jobStartDate)
				SET @month = DATEPART(MONTH, @jobStartDate)
				SET @day = DATEPART(DAY, @jobStartDate)
				IF (@calType <> 2)
					SET @calendarId = 1
			END

			SELECT @yearStartMonth = beginMonth
			FROM APP_CustomCalendar
			WHERE id = @calendarId

			--If Standard Calendar OR Custom Calendar with no months defined OR custom calendar not defined, then get standard calendar month
			IF (@yearStartMonth = 0)
				SET @yearStartMonth = 1

			SET @diffMonth = @month - @yearStartMonth

			IF (@diffMonth < 0)
				SET @yearStartDate = dbo.getstartday((@year -1), @yearStartMonth, @calendarId)
			ELSE
				SET @yearStartDate = dbo.getstartday(@year, @yearStartMonth, @calendarId)

			RETURN dbo.getUnixTime(@yearStartDate)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetYearStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetYearStart' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DAGetYearStart',  '1.1', 'DAGetYearStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
