

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetYearEnd.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetYearEnd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetYearEnd]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetYearEnd]
  delete from GXDBVersions where name = 'DAGetYearEnd' and type = 5
END
GO

	CREATE FUNCTION DAGetYearEnd(@jobStartTime INTEGER, @calendarId INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @yearStartDate 	INTEGER
			DECLARE @yearEndDate 		DATETIME
			DECLARE @year 					INTEGER
			DECLARE @month 					INTEGER
			DECLARE @endMonth 			INTEGER

			SET @year 	= 0
			SET @month 	= 0
			SET @yearEndDate = 0

			-- Get the StartDate of Year
			SET @yearStartDate = dbo.DAGetYearStart(@jobStartTime, @calendarId)

			SELECT @year = year, @month = month
			FROM APP_CustomCalendarMonths
			WHERE startDate = dbo.getDateTime(@yearStartDate)
			AND		calendarId = @calendarId

			--Custom Calendar
			IF (@month <> 0 AND @year <> 0)
			BEGIN
				SET @endMonth =  CASE (((@month % 12) + 11) % 12) WHEN 0 THEN 12 ELSE (((@month % 12) + 11) % 12) END
				IF (@endMonth <= @month)
				BEGIN
					SET @year = @year + 1
				END

				SELECT @yearEndDate = endDate
				FROM APP_CustomCalendarMonths
				WHERE year = @year
				AND		month = @endMonth
				AND		calendarId = @calendarId
			END

			--Standard Calendar
			IF (@yearEndDate = 0)
			BEGIN
				SET @yearEndDate = DATEADD(MONTH, 12, dbo.getDateTime(@yearStartDate))
				SET @yearEndDate = DATEADD(DAY, -1, @yearEndDate)
			END

			RETURN dbo.getUnixTime(@yearEndDate) + (24 * 3600) - 1
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetYearEnd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetYearEnd' AND revision = '1.2')

  insert into GXDBVersions values(5, 'DAGetYearEnd',  '1.2', 'DAGetYearEnd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
