

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetWeekStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetWeekStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetWeekStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetWeekStart]
  delete from GXDBVersions where name = 'DAGetWeekStart' and type = 5
END
GO

	CREATE FUNCTION DAGetWeekStart(@jobStartTime INTEGER, @weekStartsFrom INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @jobStartDate 	DATETIME
			DECLARE @dayOfWeek 			INTEGER
			DECLARE @numDay 				INTEGER
			DECLARE @startDate 			DATETIME

			-- Get the Date Part
			SET @jobStartDate = DATEADD(DAY, DATEDIFF(DAY, 0, dbo.getDateTime(@jobStartTime)), 0)
			SET @dayOfWeek = (DATEPART(WEEKDAY, @jobStartDate) +  @@DATEFIRST - 1) % 7

			IF (@dayOfWeek < @weekStartsFrom)
				SET @numDay = @weekStartsFrom - @dayOfWeek - 7;
			else
				SET @numDay = @weekStartsFrom - @dayOfWeek;

			SET @startDate = DATEADD(DAY, @numDay, @jobStartDate)

			RETURN dbo.getUnixTime(@startDate)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetWeekStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetWeekStart' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DAGetWeekStart',  '1.1', 'DAGetWeekStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
