

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetWeekEnd.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetWeekEnd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetWeekEnd]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetWeekEnd]
  delete from GXDBVersions where name = 'DAGetWeekEnd' and type = 5
END
GO

	CREATE FUNCTION DAGetWeekEnd(@jobStartTime INTEGER, @weekStartsFrom INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @weekStartDate 	INTEGER
			DECLARE @weekEndDate 		DATETIME

			-- Get the StartDate of Week
			SET @weekStartDate = dbo.DAGetWeekStart(@jobStartTime, @weekStartsFrom)
			SET @weekEndDate = DATEADD(DAY, 6, dbo.getDateTime(@weekStartDate))

			RETURN dbo.getUnixTime(@weekEndDate) + (24 * 3600) - 1
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetWeekEnd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetWeekEnd' AND revision = '1.2')

  insert into GXDBVersions values(5, 'DAGetWeekEnd',  '1.2', 'DAGetWeekEnd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
