

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetQuarterStart.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetQuarterStart'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetQuarterStart]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetQuarterStart]
  delete from GXDBVersions where name = 'DAGetQuarterStart' and type = 5
END
GO

	CREATE FUNCTION DAGetQuarterStart(@jobStartTime INTEGER, @calendarId INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @jobStartDate 			DATETIME
			DECLARE @monthStartDate			DATETIME
			DECLARE @quarterStartDate 	DATETIME
			DECLARE @year 							INTEGER
			DECLARE @month 							INTEGER
			DECLARE @day 								INTEGER
			DECLARE @calType 						INTEGER
			DECLARE @yearStartMonth 		INTEGER
			DECLARE @diffMonth 					INTEGER
			DECLARE @monthOffset 				INTEGER

			-- Get the Date Part
			SET @jobStartDate = DATEADD(DAY, DATEDIFF(DAY, 0, dbo.getDateTime(@jobStartTime)), 0)
			SET @calType = 0
			SET @year = DATEPART(YEAR, @jobStartDate)
			SET @month = DATEPART(MONTH, @jobStartDate)
			SET @day = DATEPART(DAY, @jobStartDate)
			SET @monthStartDate = 0
			SET @quarterStartDate = 0
			SET @yearStartMonth = 0
			SET @diffMonth = 0
			SET @monthOffset = 0

			SET @calType = (SELECT calType FROM APP_CustomCalendar WHERE id = @calendarId)
			IF (@calType > 2)
			BEGIN
			  SELECT @monthStartDate = startDate, @year = year, @month = month
				FROM APP_CustomCalendarMonths
				WHERE startDate <= @jobStartDate
				AND endDate >= @jobStartDate
				AND calendarId = @calendarId
			END

			--If Standard Calendar OR Custom Calendar with no months defined OR custom calendar not defined, then set standard calendar
			IF (@monthStartDate = 0)
			BEGIN
				SET @year = DATEPART(YEAR, @jobStartDate)
				SET @month = DATEPART(MONTH, @jobStartDate)
				SET @day = DATEPART(DAY, @jobStartDate)
				IF (@calType <> 2)
					SET @calendarId = 1
			END

			SELECT @yearStartMonth = beginMonth
			FROM APP_CustomCalendar
			WHERE id = @calendarId

			--If Standard Calendar OR Custom Calendar with no months defined OR custom calendar not defined, then get standard calendar month
			IF (@yearStartMonth = 0)
				SET @yearStartMonth = 1

			SET @diffMonth = @month - @yearStartMonth

			IF (@diffMonth < 0)
 			BEGIN
				SET @diffMonth = @diffMonth + 12
				SET @monthOffset = @yearStartMonth + (@diffMonth / 3) * 3
				IF (@monthOffset > 12)
					SET @quarterStartDate = dbo.getstartday(@year, (@yearStartMonth - 12 + (@diffMonth / 3) * 3), @calendarId)
				ELSE
					SET @quarterStartDate = dbo.getstartday((@year -1), (@yearStartMonth + (@diffMonth / 3) * 3), @calendarId)
			END
			ELSE
			BEGIN
				SET @quarterStartDate = dbo.getstartday(@year, (@yearStartMonth + (@diffMonth / 3) * 3), @calendarId)
			END

			RETURN dbo.getUnixTime(@quarterStartDate)
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetQuarterStart]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetQuarterStart' AND revision = '1.1')

  insert into GXDBVersions values(5, 'DAGetQuarterStart',  '1.1', 'DAGetQuarterStart', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
