

--  ------------  Generated from [../../../Source/CommServer/Db/Function/DAGetQuarterEnd.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: DAGetQuarterEnd'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[DAGetQuarterEnd]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[DAGetQuarterEnd]
  delete from GXDBVersions where name = 'DAGetQuarterEnd' and type = 5
END
GO

	CREATE FUNCTION DAGetQuarterEnd(@jobStartTime INTEGER, @calendarId INTEGER)
		RETURNS INTEGER
		AS
		BEGIN
			DECLARE @quarterStartDate 	INTEGER
			DECLARE @quarterEndDate 		DATETIME
			DECLARE @year 							INTEGER
			DECLARE @month 							INTEGER
			DECLARE @endMonth 					INTEGER

			SET @year 	= 0
			SET @month 	= 0
			SET @quarterEndDate = 0

			-- Get the StartDate of Quarter
			SET @quarterStartDate = dbo.DAGetQuarterStart(@jobStartTime, @calendarId)

			SELECT @year = year, @month = month
			FROM APP_CustomCalendarMonths
			WHERE startDate = dbo.getDateTime(@quarterStartDate)
			AND		calendarId = @calendarId

			--Custom Calendar
			IF (@month <> 0 AND @year <> 0)
			BEGIN
				SET @endMonth =  CASE (((@month % 12) + 2) % 12) WHEN 0 THEN 12 ELSE (((@month % 12) + 2) % 12) END
				IF (@endMonth <= @month)
				BEGIN
					SET @year = @year + 1
				END

				SELECT @quarterEndDate = endDate
				FROM APP_CustomCalendarMonths
				WHERE year = @year
				AND		month = @endMonth
				AND		calendarId = @calendarId
			END

			--Standard Calendar
			IF (@quarterEndDate = 0)
			BEGIN
				SET @quarterEndDate = DATEADD(MONTH, 3, dbo.getDateTime(@quarterStartDate))
				SET @quarterEndDate = DATEADD(DAY, -1, @quarterEndDate)
			END

			RETURN dbo.getUnixTime(@quarterEndDate) + (24 * 3600) - 1
		END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [DAGetQuarterEnd]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'DAGetQuarterEnd' AND revision = '1.2')

  insert into GXDBVersions values(5, 'DAGetQuarterEnd',  '1.2', 'DAGetQuarterEnd', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
